<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_update = new bcode_update();

// Run the page
$bcode_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fbcodeupdate = currentForm = new ew.Form("fbcodeupdate", "update");

// Validate form
fbcodeupdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($bcode_update->order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_order_date");
			uelm = this.getElements("u" + infix + "_order_date");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->order_date->caption(), $bcode->order_date->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_date");
			uelm = this.getElements("u" + infix + "_order_date");
			if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->order_date->errorMessage()) ?>");
		<?php if ($bcode_update->dispatch_week_p->Required) { ?>
			elm = this.getElements("x" + infix + "_dispatch_week_p");
			uelm = this.getElements("u" + infix + "_dispatch_week_p");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->dispatch_week_p->caption(), $bcode->dispatch_week_p->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			uelm = this.getElements("u" + infix + "_status");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->status->caption(), $bcode->status->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->buyer_loc->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_loc");
			uelm = this.getElements("u" + infix + "_buyer_loc");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->buyer_loc->caption(), $bcode->buyer_loc->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->sqm_u->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm_u");
			uelm = this.getElements("u" + infix + "_sqm_u");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->sqm_u->caption(), $bcode->sqm_u->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm_u");
			uelm = this.getElements("u" + infix + "_sqm_u");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->sqm_u->errorMessage()) ?>");
		<?php if ($bcode_update->c_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_c_sqm");
			uelm = this.getElements("u" + infix + "_c_sqm");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->c_sqm->caption(), $bcode->c_sqm->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_c_sqm");
			uelm = this.getElements("u" + infix + "_c_sqm");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->c_sqm->errorMessage()) ?>");
		<?php if ($bcode_update->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			uelm = this.getElements("u" + infix + "_weaving_works");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->weaving_works->caption(), $bcode->weaving_works->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->current_works->Required) { ?>
			elm = this.getElements("x" + infix + "_current_works");
			uelm = this.getElements("u" + infix + "_current_works");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->current_works->caption(), $bcode->current_works->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->q_sku->Required) { ?>
			elm = this.getElements("x" + infix + "_q_sku");
			uelm = this.getElements("u" + infix + "_q_sku");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->q_sku->caption(), $bcode->q_sku->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_q_sku");
			uelm = this.getElements("u" + infix + "_q_sku");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->q_sku->errorMessage()) ?>");
		<?php if ($bcode_update->po_price->Required) { ?>
			elm = this.getElements("x" + infix + "_po_price");
			uelm = this.getElements("u" + infix + "_po_price");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->po_price->caption(), $bcode->po_price->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->po_discount->Required) { ?>
			elm = this.getElements("x" + infix + "_po_discount");
			uelm = this.getElements("u" + infix + "_po_discount");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->po_discount->caption(), $bcode->po_discount->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_discount");
			uelm = this.getElements("u" + infix + "_po_discount");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->po_discount->errorMessage()) ?>");
		<?php if ($bcode_update->po_currency->Required) { ?>
			elm = this.getElements("x" + infix + "_po_currency");
			uelm = this.getElements("u" + infix + "_po_currency");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->po_currency->caption(), $bcode->po_currency->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->completed->Required) { ?>
			elm = this.getElements("x" + infix + "_completed");
			uelm = this.getElements("u" + infix + "_completed");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->completed->caption(), $bcode->completed->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			uelm = this.getElements("u" + infix + "_remarks");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->remarks->caption(), $bcode->remarks->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->roll_no->Required) { ?>
			elm = this.getElements("x" + infix + "_roll_no");
			uelm = this.getElements("u" + infix + "_roll_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->roll_no->caption(), $bcode->roll_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->qty->Required) { ?>
			elm = this.getElements("x" + infix + "_qty");
			uelm = this.getElements("u" + infix + "_qty");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->qty->caption(), $bcode->qty->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->pl_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_no");
			uelm = this.getElements("u" + infix + "_pl_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->pl_no->caption(), $bcode->pl_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			uelm = this.getElements("u" + infix + "_category");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->category->caption(), $bcode->category->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->p_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_p_remarks");
			uelm = this.getElements("u" + infix + "_p_remarks");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->p_remarks->caption(), $bcode->p_remarks->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($bcode_update->roll_no_qty_tmp->Required) { ?>
			elm = this.getElements("x" + infix + "_roll_no_qty_tmp");
			uelm = this.getElements("u" + infix + "_roll_no_qty_tmp");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bcode->roll_no_qty_tmp->caption(), $bcode->roll_no_qty_tmp->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_roll_no_qty_tmp");
			uelm = this.getElements("u" + infix + "_roll_no_qty_tmp");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bcode->roll_no_qty_tmp->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbcodeupdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcodeupdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcodeupdate.lists["x_dispatch_week_p"] = <?php echo $bcode_update->dispatch_week_p->Lookup->toClientList() ?>;
fbcodeupdate.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($bcode_update->dispatch_week_p->lookupOptions()) ?>;
fbcodeupdate.lists["x_status"] = <?php echo $bcode_update->status->Lookup->toClientList() ?>;
fbcodeupdate.lists["x_status"].options = <?php echo JsonEncode($bcode_update->status->lookupOptions()) ?>;
fbcodeupdate.lists["x_weaving_works"] = <?php echo $bcode_update->weaving_works->Lookup->toClientList() ?>;
fbcodeupdate.lists["x_weaving_works"].options = <?php echo JsonEncode($bcode_update->weaving_works->lookupOptions()) ?>;
fbcodeupdate.lists["x_current_works"] = <?php echo $bcode_update->current_works->Lookup->toClientList() ?>;
fbcodeupdate.lists["x_current_works"].options = <?php echo JsonEncode($bcode_update->current_works->lookupOptions()) ?>;
fbcodeupdate.lists["x_po_currency"] = <?php echo $bcode_update->po_currency->Lookup->toClientList() ?>;
fbcodeupdate.lists["x_po_currency"].options = <?php echo JsonEncode($bcode_update->po_currency->lookupOptions()) ?>;
fbcodeupdate.lists["x_completed"] = <?php echo $bcode_update->completed->Lookup->toClientList() ?>;
fbcodeupdate.lists["x_completed"].options = <?php echo JsonEncode($bcode_update->completed->options(FALSE, TRUE)) ?>;
fbcodeupdate.lists["x_category"] = <?php echo $bcode_update->category->Lookup->toClientList() ?>;
fbcodeupdate.lists["x_category"].options = <?php echo JsonEncode($bcode_update->category->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bcode_update->showPageHeader(); ?>
<?php
$bcode_update->showMessage();
?>
<form name="fbcodeupdate" id="fbcodeupdate" class="<?php echo $bcode_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode">
<?php if ($bcode->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$bcode_update->IsModal ?>">
<?php foreach ($bcode_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_bcodeupdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $bcode_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($bcode->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_order_date" id="u_order_date" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->order_date->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_order_date" id="u_order_date" value="<?php echo $bcode->order_date->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->order_date->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_order_date"><?php echo $bcode->order_date->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->order_date->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_order_date">
<input type="text" data-table="bcode" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($bcode->order_date->getPlaceHolder()) ?>" value="<?php echo $bcode->order_date->EditValue ?>"<?php echo $bcode->order_date->editAttributes() ?>>
<?php if (!$bcode->order_date->ReadOnly && !$bcode->order_date->Disabled && !isset($bcode->order_date->EditAttrs["readonly"]) && !isset($bcode->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbcodeupdate", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_bcode_order_date">
<span<?php echo $bcode->order_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->order_date->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_order_date" name="x_order_date" id="x_order_date" value="<?php echo HtmlEncode($bcode->order_date->FormValue) ?>">
<?php } ?>
<?php echo $bcode->order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_status" id="u_status" value="<?php echo $bcode->status->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_status"><?php echo $bcode->status->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->status->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_status" data-value-separator="<?php echo $bcode->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $bcode->status->editAttributes() ?>>
		<?php echo $bcode->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $bcode->status->Lookup->getParamTag("p_x_status") ?>
</span>
<?php } else { ?>
<span id="el_bcode_status">
<span<?php echo $bcode->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->status->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_status" name="x_status" id="x_status" value="<?php echo HtmlEncode($bcode->status->FormValue) ?>">
<?php } ?>
<?php echo $bcode->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->buyer_loc->Visible) { // buyer_loc ?>
	<div id="r_buyer_loc" class="form-group row">
		<label for="x_buyer_loc" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_buyer_loc" id="u_buyer_loc" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->buyer_loc->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_buyer_loc" id="u_buyer_loc" value="<?php echo $bcode->buyer_loc->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->buyer_loc->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_buyer_loc"><?php echo $bcode->buyer_loc->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->buyer_loc->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_buyer_loc">
<input type="text" data-table="bcode" data-field="x_buyer_loc" name="x_buyer_loc" id="x_buyer_loc" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($bcode->buyer_loc->getPlaceHolder()) ?>" value="<?php echo $bcode->buyer_loc->EditValue ?>"<?php echo $bcode->buyer_loc->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_bcode_buyer_loc">
<span<?php echo $bcode->buyer_loc->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->buyer_loc->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_buyer_loc" name="x_buyer_loc" id="x_buyer_loc" value="<?php echo HtmlEncode($bcode->buyer_loc->FormValue) ?>">
<?php } ?>
<?php echo $bcode->buyer_loc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->sqm_u->Visible) { // sqm_u ?>
	<div id="r_sqm_u" class="form-group row">
		<label for="x_sqm_u" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_sqm_u" id="u_sqm_u" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->sqm_u->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_sqm_u" id="u_sqm_u" value="<?php echo $bcode->sqm_u->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->sqm_u->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_sqm_u"><?php echo $bcode->sqm_u->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->sqm_u->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_sqm_u">
<input type="text" data-table="bcode" data-field="x_sqm_u" name="x_sqm_u" id="x_sqm_u" size="30" placeholder="<?php echo HtmlEncode($bcode->sqm_u->getPlaceHolder()) ?>" value="<?php echo $bcode->sqm_u->EditValue ?>"<?php echo $bcode->sqm_u->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_bcode_sqm_u">
<span<?php echo $bcode->sqm_u->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->sqm_u->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_sqm_u" name="x_sqm_u" id="x_sqm_u" value="<?php echo HtmlEncode($bcode->sqm_u->FormValue) ?>">
<?php } ?>
<?php echo $bcode->sqm_u->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->c_sqm->Visible) { // c_sqm ?>
	<div id="r_c_sqm" class="form-group row">
		<label for="x_c_sqm" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_c_sqm" id="u_c_sqm" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->c_sqm->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_c_sqm" id="u_c_sqm" value="<?php echo $bcode->c_sqm->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->c_sqm->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_c_sqm"><?php echo $bcode->c_sqm->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->c_sqm->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_c_sqm">
<input type="text" data-table="bcode" data-field="x_c_sqm" name="x_c_sqm" id="x_c_sqm" size="30" placeholder="<?php echo HtmlEncode($bcode->c_sqm->getPlaceHolder()) ?>" value="<?php echo $bcode->c_sqm->EditValue ?>"<?php echo $bcode->c_sqm->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_bcode_c_sqm">
<span<?php echo $bcode->c_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->c_sqm->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_c_sqm" name="x_c_sqm" id="x_c_sqm" value="<?php echo HtmlEncode($bcode->c_sqm->FormValue) ?>">
<?php } ?>
<?php echo $bcode->c_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_weaving_works" id="u_weaving_works" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->weaving_works->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_weaving_works" id="u_weaving_works" value="<?php echo $bcode->weaving_works->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->weaving_works->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_weaving_works"><?php echo $bcode->weaving_works->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->weaving_works->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_weaving_works" data-value-separator="<?php echo $bcode->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $bcode->weaving_works->editAttributes() ?>>
		<?php echo $bcode->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $bcode->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
<?php } else { ?>
<span id="el_bcode_weaving_works">
<span<?php echo $bcode->weaving_works->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->weaving_works->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_weaving_works" name="x_weaving_works" id="x_weaving_works" value="<?php echo HtmlEncode($bcode->weaving_works->FormValue) ?>">
<?php } ?>
<?php echo $bcode->weaving_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_current_works" id="u_current_works" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->current_works->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_current_works" id="u_current_works" value="<?php echo $bcode->current_works->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->current_works->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_current_works"><?php echo $bcode->current_works->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->current_works->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_current_works" data-value-separator="<?php echo $bcode->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $bcode->current_works->editAttributes() ?>>
		<?php echo $bcode->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $bcode->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
<?php } else { ?>
<span id="el_bcode_current_works">
<span<?php echo $bcode->current_works->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->current_works->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_current_works" name="x_current_works" id="x_current_works" value="<?php echo HtmlEncode($bcode->current_works->FormValue) ?>">
<?php } ?>
<?php echo $bcode->current_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->q_sku->Visible) { // q_sku ?>
	<div id="r_q_sku" class="form-group row">
		<label for="x_q_sku" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_q_sku" id="u_q_sku" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->q_sku->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_q_sku" id="u_q_sku" value="<?php echo $bcode->q_sku->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->q_sku->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_q_sku"><?php echo $bcode->q_sku->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->q_sku->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_q_sku">
<input type="text" data-table="bcode" data-field="x_q_sku" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($bcode->q_sku->getPlaceHolder()) ?>" value="<?php echo $bcode->q_sku->EditValue ?>"<?php echo $bcode->q_sku->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_bcode_q_sku">
<span<?php echo $bcode->q_sku->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->q_sku->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_q_sku" name="x_q_sku" id="x_q_sku" value="<?php echo HtmlEncode($bcode->q_sku->FormValue) ?>">
<?php } ?>
<?php echo $bcode->q_sku->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->po_discount->Visible) { // po_discount ?>
	<div id="r_po_discount" class="form-group row">
		<label for="x_po_discount" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_po_discount" id="u_po_discount" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->po_discount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_po_discount" id="u_po_discount" value="<?php echo $bcode->po_discount->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->po_discount->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_po_discount"><?php echo $bcode->po_discount->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->po_discount->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_po_discount">
<input type="text" data-table="bcode" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" size="30" placeholder="<?php echo HtmlEncode($bcode->po_discount->getPlaceHolder()) ?>" value="<?php echo $bcode->po_discount->EditValue ?>"<?php echo $bcode->po_discount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_bcode_po_discount">
<span<?php echo $bcode->po_discount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->po_discount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_po_discount" name="x_po_discount" id="x_po_discount" value="<?php echo HtmlEncode($bcode->po_discount->FormValue) ?>">
<?php } ?>
<?php echo $bcode->po_discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label for="x_completed" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_completed" id="u_completed" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->completed->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_completed" id="u_completed" value="<?php echo $bcode->completed->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->completed->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_completed"><?php echo $bcode->completed->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->completed->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_completed" data-value-separator="<?php echo $bcode->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $bcode->completed->editAttributes() ?>>
		<?php echo $bcode->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_bcode_completed">
<span<?php echo $bcode->completed->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->completed->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_completed" name="x_completed" id="x_completed" value="<?php echo HtmlEncode($bcode->completed->FormValue) ?>">
<?php } ?>
<?php echo $bcode->completed->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_remarks" id="u_remarks" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->remarks->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_remarks" id="u_remarks" value="<?php echo $bcode->remarks->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->remarks->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_remarks"><?php echo $bcode->remarks->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->remarks->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_remarks">
<input type="text" data-table="bcode" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($bcode->remarks->getPlaceHolder()) ?>" value="<?php echo $bcode->remarks->EditValue ?>"<?php echo $bcode->remarks->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_bcode_remarks">
<span<?php echo $bcode->remarks->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->remarks->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_remarks" name="x_remarks" id="x_remarks" value="<?php echo HtmlEncode($bcode->remarks->FormValue) ?>">
<?php } ?>
<?php echo $bcode->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_category" id="u_category" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->category->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_category" id="u_category" value="<?php echo $bcode->category->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->category->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_category"><?php echo $bcode->category->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->category->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bcode" data-field="x_category" data-value-separator="<?php echo $bcode->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $bcode->category->editAttributes() ?>>
		<?php echo $bcode->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $bcode->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php } else { ?>
<span id="el_bcode_category">
<span<?php echo $bcode->category->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->category->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_category" name="x_category" id="x_category" value="<?php echo HtmlEncode($bcode->category->FormValue) ?>">
<?php } ?>
<?php echo $bcode->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label for="x_p_remarks" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_p_remarks" id="u_p_remarks" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->p_remarks->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_p_remarks" id="u_p_remarks" value="<?php echo $bcode->p_remarks->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->p_remarks->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_p_remarks"><?php echo $bcode->p_remarks->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->p_remarks->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_p_remarks">
<textarea data-table="bcode" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($bcode->p_remarks->getPlaceHolder()) ?>"<?php echo $bcode->p_remarks->editAttributes() ?>><?php echo $bcode->p_remarks->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el_bcode_p_remarks">
<span<?php echo $bcode->p_remarks->viewAttributes() ?>>
<?php echo $bcode->p_remarks->ViewValue ?></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" value="<?php echo HtmlEncode($bcode->p_remarks->FormValue) ?>">
<?php } ?>
<?php echo $bcode->p_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($bcode->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
	<div id="r_roll_no_qty_tmp" class="form-group row">
		<label for="x_roll_no_qty_tmp" class="<?php echo $bcode_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$bcode->isConfirm()) { ?>
<input type="checkbox" name="u_roll_no_qty_tmp" id="u_roll_no_qty_tmp" class="form-check-input ew-multi-select" value="1"<?php echo ($bcode->roll_no_qty_tmp->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_roll_no_qty_tmp" id="u_roll_no_qty_tmp" value="<?php echo $bcode->roll_no_qty_tmp->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($bcode->roll_no_qty_tmp->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_roll_no_qty_tmp"><?php echo $bcode->roll_no_qty_tmp->caption() ?></label></div></label>
		<div class="<?php echo $bcode_update->RightColumnClass ?>"><div<?php echo $bcode->roll_no_qty_tmp->cellAttributes() ?>>
<?php if (!$bcode->isConfirm()) { ?>
<span id="el_bcode_roll_no_qty_tmp">
<input type="text" data-table="bcode" data-field="x_roll_no_qty_tmp" name="x_roll_no_qty_tmp" id="x_roll_no_qty_tmp" size="30" placeholder="<?php echo HtmlEncode($bcode->roll_no_qty_tmp->getPlaceHolder()) ?>" value="<?php echo $bcode->roll_no_qty_tmp->EditValue ?>"<?php echo $bcode->roll_no_qty_tmp->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_bcode_roll_no_qty_tmp">
<span<?php echo $bcode->roll_no_qty_tmp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bcode->roll_no_qty_tmp->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="bcode" data-field="x_roll_no_qty_tmp" name="x_roll_no_qty_tmp" id="x_roll_no_qty_tmp" value="<?php echo HtmlEncode($bcode->roll_no_qty_tmp->FormValue) ?>">
<?php } ?>
<?php echo $bcode->roll_no_qty_tmp->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$bcode_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $bcode_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$bcode->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $bcode_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bcode_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bcode_update->terminate();
?>