<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bcode_view = new bcode_view();

// Run the page
$bcode_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bcode_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bcode->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbcodeview = currentForm = new ew.Form("fbcodeview", "view");

// Form_CustomValidate event
fbcodeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbcodeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbcodeview.lists["x_design_id"] = <?php echo $bcode_view->design_id->Lookup->toClientList() ?>;
fbcodeview.lists["x_design_id"].options = <?php echo JsonEncode($bcode_view->design_id->lookupOptions()) ?>;
fbcodeview.lists["x_process_d[]"] = <?php echo $bcode_view->process_d->Lookup->toClientList() ?>;
fbcodeview.lists["x_process_d[]"].options = <?php echo JsonEncode($bcode_view->process_d->lookupOptions()) ?>;
fbcodeview.lists["x_buyer_ref"] = <?php echo $bcode_view->buyer_ref->Lookup->toClientList() ?>;
fbcodeview.lists["x_buyer_ref"].options = <?php echo JsonEncode($bcode_view->buyer_ref->lookupOptions()) ?>;
fbcodeview.lists["x_despatch_week"] = <?php echo $bcode_view->despatch_week->Lookup->toClientList() ?>;
fbcodeview.lists["x_despatch_week"].options = <?php echo JsonEncode($bcode_view->despatch_week->lookupOptions()) ?>;
fbcodeview.lists["x_dispatch_week_p"] = <?php echo $bcode_view->dispatch_week_p->Lookup->toClientList() ?>;
fbcodeview.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($bcode_view->dispatch_week_p->lookupOptions()) ?>;
fbcodeview.lists["x_status"] = <?php echo $bcode_view->status->Lookup->toClientList() ?>;
fbcodeview.lists["x_status"].options = <?php echo JsonEncode($bcode_view->status->lookupOptions()) ?>;
fbcodeview.lists["x_buyers_id"] = <?php echo $bcode_view->buyers_id->Lookup->toClientList() ?>;
fbcodeview.lists["x_buyers_id"].options = <?php echo JsonEncode($bcode_view->buyers_id->lookupOptions()) ?>;
fbcodeview.lists["x_po_currency"] = <?php echo $bcode_view->po_currency->Lookup->toClientList() ?>;
fbcodeview.lists["x_po_currency"].options = <?php echo JsonEncode($bcode_view->po_currency->lookupOptions()) ?>;
fbcodeview.lists["x_product_type"] = <?php echo $bcode_view->product_type->Lookup->toClientList() ?>;
fbcodeview.lists["x_product_type"].options = <?php echo JsonEncode($bcode_view->product_type->options(FALSE, TRUE)) ?>;
fbcodeview.lists["x_shape"] = <?php echo $bcode_view->shape->Lookup->toClientList() ?>;
fbcodeview.lists["x_shape"].options = <?php echo JsonEncode($bcode_view->shape->lookupOptions()) ?>;
fbcodeview.lists["x_payment_plan"] = <?php echo $bcode_view->payment_plan->Lookup->toClientList() ?>;
fbcodeview.lists["x_payment_plan"].options = <?php echo JsonEncode($bcode_view->payment_plan->lookupOptions()) ?>;
fbcodeview.lists["x_production_plan"] = <?php echo $bcode_view->production_plan->Lookup->toClientList() ?>;
fbcodeview.lists["x_production_plan"].options = <?php echo JsonEncode($bcode_view->production_plan->options(FALSE, TRUE)) ?>;
fbcodeview.lists["x_completed"] = <?php echo $bcode_view->completed->Lookup->toClientList() ?>;
fbcodeview.lists["x_completed"].options = <?php echo JsonEncode($bcode_view->completed->options(FALSE, TRUE)) ?>;
fbcodeview.lists["x_operator"] = <?php echo $bcode_view->operator->Lookup->toClientList() ?>;
fbcodeview.lists["x_operator"].options = <?php echo JsonEncode($bcode_view->operator->lookupOptions()) ?>;
fbcodeview.lists["x_batch_no"] = <?php echo $bcode_view->batch_no->Lookup->toClientList() ?>;
fbcodeview.lists["x_batch_no"].options = <?php echo JsonEncode($bcode_view->batch_no->lookupOptions()) ?>;
fbcodeview.lists["x_cs"] = <?php echo $bcode_view->cs->Lookup->toClientList() ?>;
fbcodeview.lists["x_cs"].options = <?php echo JsonEncode($bcode_view->cs->options(FALSE, TRUE)) ?>;
fbcodeview.lists["x_process[]"] = <?php echo $bcode_view->process->Lookup->toClientList() ?>;
fbcodeview.lists["x_process[]"].options = <?php echo JsonEncode($bcode_view->process->lookupOptions()) ?>;
fbcodeview.lists["x_process_c[]"] = <?php echo $bcode_view->process_c->Lookup->toClientList() ?>;
fbcodeview.lists["x_process_c[]"].options = <?php echo JsonEncode($bcode_view->process_c->lookupOptions()) ?>;
fbcodeview.lists["x_category"] = <?php echo $bcode_view->category->Lookup->toClientList() ?>;
fbcodeview.lists["x_category"].options = <?php echo JsonEncode($bcode_view->category->lookupOptions()) ?>;
fbcodeview.lists["x_pp_id"] = <?php echo $bcode_view->pp_id->Lookup->toClientList() ?>;
fbcodeview.lists["x_pp_id"].options = <?php echo JsonEncode($bcode_view->pp_id->lookupOptions()) ?>;
fbcodeview.autoSuggests["x_pp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bcode->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $bcode_view->ExportOptions->render("body") ?>
<?php $bcode_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $bcode_view->showPageHeader(); ?>
<?php
$bcode_view->showMessage();
?>
<form name="fbcodeview" id="fbcodeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bcode_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bcode_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bcode">
<input type="hidden" name="modal" value="<?php echo (int)$bcode_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($bcode->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_id"><?php echo $bcode->id->caption() ?></span></td>
		<td data-name="id"<?php echo $bcode->id->cellAttributes() ?>>
<span id="el_bcode_id">
<span<?php echo $bcode->id->viewAttributes() ?>>
<?php echo $bcode->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->pid->Visible) { // pid ?>
	<tr id="r_pid">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_pid"><?php echo $bcode->pid->caption() ?></span></td>
		<td data-name="pid"<?php echo $bcode->pid->cellAttributes() ?>>
<span id="el_bcode_pid">
<span<?php echo $bcode->pid->viewAttributes() ?>>
<?php echo $bcode->pid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_po"><?php echo $bcode->po->caption() ?></span></td>
		<td data-name="po"<?php echo $bcode->po->cellAttributes() ?>>
<span id="el_bcode_po">
<span<?php echo $bcode->po->viewAttributes() ?>>
<?php echo $bcode->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_design_id"><?php echo $bcode->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $bcode->design_id->cellAttributes() ?>>
<span id="el_bcode_design_id">
<span<?php echo $bcode->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->design_id->getViewValue())) && $bcode->design_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode->design_id->linkAttributes() ?>><?php echo $bcode->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->size_cm->Visible) { // size_cm ?>
	<tr id="r_size_cm">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_size_cm"><?php echo $bcode->size_cm->caption() ?></span></td>
		<td data-name="size_cm"<?php echo $bcode->size_cm->cellAttributes() ?>>
<span id="el_bcode_size_cm">
<span<?php echo $bcode->size_cm->viewAttributes() ?>>
<?php echo $bcode->size_cm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__barcode"><?php echo $bcode->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $bcode->_barcode->cellAttributes() ?>>
<span id="el_bcode__barcode">
<span<?php echo $bcode->_barcode->viewAttributes() ?>>
<?php echo $bcode->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->process_d->Visible) { // process_d ?>
	<tr id="r_process_d">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_process_d"><?php echo $bcode->process_d->caption() ?></span></td>
		<td data-name="process_d"<?php echo $bcode->process_d->cellAttributes() ?>>
<span id="el_bcode_process_d">
<span<?php echo $bcode->process_d->viewAttributes() ?>>
<?php echo $bcode->process_d->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_buyer_ref"><?php echo $bcode->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $bcode->buyer_ref->cellAttributes() ?>>
<span id="el_bcode_buyer_ref">
<span<?php echo $bcode->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->buyer_ref->getViewValue())) && $bcode->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $bcode->buyer_ref->linkAttributes() ?>><?php echo $bcode->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->order_date->Visible) { // order_date ?>
	<tr id="r_order_date">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_order_date"><?php echo $bcode->order_date->caption() ?></span></td>
		<td data-name="order_date"<?php echo $bcode->order_date->cellAttributes() ?>>
<span id="el_bcode_order_date">
<span<?php echo $bcode->order_date->viewAttributes() ?>>
<?php echo $bcode->order_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->despatch_date->Visible) { // despatch_date ?>
	<tr id="r_despatch_date">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_despatch_date"><?php echo $bcode->despatch_date->caption() ?></span></td>
		<td data-name="despatch_date"<?php echo $bcode->despatch_date->cellAttributes() ?>>
<span id="el_bcode_despatch_date">
<span<?php echo $bcode->despatch_date->viewAttributes() ?>>
<?php echo $bcode->despatch_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->despatch_week->Visible) { // despatch_week ?>
	<tr id="r_despatch_week">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_despatch_week"><?php echo $bcode->despatch_week->caption() ?></span></td>
		<td data-name="despatch_week"<?php echo $bcode->despatch_week->cellAttributes() ?>>
<span id="el_bcode_despatch_week">
<span<?php echo $bcode->despatch_week->viewAttributes() ?>>
<?php echo $bcode->despatch_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<tr id="r_dispatch_week_p">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_dispatch_week_p"><?php echo $bcode->dispatch_week_p->caption() ?></span></td>
		<td data-name="dispatch_week_p"<?php echo $bcode->dispatch_week_p->cellAttributes() ?>>
<span id="el_bcode_dispatch_week_p">
<span<?php echo $bcode->dispatch_week_p->viewAttributes() ?>>
<?php echo $bcode->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_status"><?php echo $bcode->status->caption() ?></span></td>
		<td data-name="status"<?php echo $bcode->status->cellAttributes() ?>>
<span id="el_bcode_status">
<span<?php echo $bcode->status->viewAttributes() ?>>
<?php echo $bcode->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->buyers_id->Visible) { // buyers_id ?>
	<tr id="r_buyers_id">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_buyers_id"><?php echo $bcode->buyers_id->caption() ?></span></td>
		<td data-name="buyers_id"<?php echo $bcode->buyers_id->cellAttributes() ?>>
<span id="el_bcode_buyers_id">
<span<?php echo $bcode->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->buyers_id->getViewValue())) && $bcode->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $bcode->buyers_id->linkAttributes() ?>><?php echo $bcode->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->buyer_uid->Visible) { // buyer_uid ?>
	<tr id="r_buyer_uid">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_buyer_uid"><?php echo $bcode->buyer_uid->caption() ?></span></td>
		<td data-name="buyer_uid"<?php echo $bcode->buyer_uid->cellAttributes() ?>>
<span id="el_bcode_buyer_uid">
<span<?php echo $bcode->buyer_uid->viewAttributes() ?>>
<?php echo $bcode->buyer_uid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->buyer_loc->Visible) { // buyer_loc ?>
	<tr id="r_buyer_loc">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_buyer_loc"><?php echo $bcode->buyer_loc->caption() ?></span></td>
		<td data-name="buyer_loc"<?php echo $bcode->buyer_loc->cellAttributes() ?>>
<span id="el_bcode_buyer_loc">
<span<?php echo $bcode->buyer_loc->viewAttributes() ?>>
<?php echo $bcode->buyer_loc->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_quantity"><?php echo $bcode->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $bcode->quantity->cellAttributes() ?>>
<span id="el_bcode_quantity">
<span<?php echo $bcode->quantity->viewAttributes() ?>>
<?php echo $bcode->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_sqm"><?php echo $bcode->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $bcode->sqm->cellAttributes() ?>>
<span id="el_bcode_sqm">
<span<?php echo $bcode->sqm->viewAttributes() ?>>
<?php echo $bcode->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->sqm_u->Visible) { // sqm_u ?>
	<tr id="r_sqm_u">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_sqm_u"><?php echo $bcode->sqm_u->caption() ?></span></td>
		<td data-name="sqm_u"<?php echo $bcode->sqm_u->cellAttributes() ?>>
<span id="el_bcode_sqm_u">
<span<?php echo $bcode->sqm_u->viewAttributes() ?>>
<?php echo $bcode->sqm_u->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->c_sqm->Visible) { // c_sqm ?>
	<tr id="r_c_sqm">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_c_sqm"><?php echo $bcode->c_sqm->caption() ?></span></td>
		<td data-name="c_sqm"<?php echo $bcode->c_sqm->cellAttributes() ?>>
<span id="el_bcode_c_sqm">
<span<?php echo $bcode->c_sqm->viewAttributes() ?>>
<?php echo $bcode->c_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->q_sku->Visible) { // q_sku ?>
	<tr id="r_q_sku">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_q_sku"><?php echo $bcode->q_sku->caption() ?></span></td>
		<td data-name="q_sku"<?php echo $bcode->q_sku->cellAttributes() ?>>
<span id="el_bcode_q_sku">
<span<?php echo $bcode->q_sku->viewAttributes() ?>>
<?php echo $bcode->q_sku->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->po_price->Visible) { // po_price ?>
	<tr id="r_po_price">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_po_price"><?php echo $bcode->po_price->caption() ?></span></td>
		<td data-name="po_price"<?php echo $bcode->po_price->cellAttributes() ?>>
<span id="el_bcode_po_price">
<span<?php echo $bcode->po_price->viewAttributes() ?>>
<?php echo $bcode->po_price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->po_discount->Visible) { // po_discount ?>
	<tr id="r_po_discount">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_po_discount"><?php echo $bcode->po_discount->caption() ?></span></td>
		<td data-name="po_discount"<?php echo $bcode->po_discount->cellAttributes() ?>>
<span id="el_bcode_po_discount">
<span<?php echo $bcode->po_discount->viewAttributes() ?>>
<?php echo $bcode->po_discount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->po_currency->Visible) { // po_currency ?>
	<tr id="r_po_currency">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_po_currency"><?php echo $bcode->po_currency->caption() ?></span></td>
		<td data-name="po_currency"<?php echo $bcode->po_currency->cellAttributes() ?>>
<span id="el_bcode_po_currency">
<span<?php echo $bcode->po_currency->viewAttributes() ?>>
<?php echo $bcode->po_currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_product_type"><?php echo $bcode->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $bcode->product_type->cellAttributes() ?>>
<span id="el_bcode_product_type">
<span<?php echo $bcode->product_type->viewAttributes() ?>>
<?php echo $bcode->product_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->shape->Visible) { // shape ?>
	<tr id="r_shape">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_shape"><?php echo $bcode->shape->caption() ?></span></td>
		<td data-name="shape"<?php echo $bcode->shape->cellAttributes() ?>>
<span id="el_bcode_shape">
<span<?php echo $bcode->shape->viewAttributes() ?>>
<?php echo $bcode->shape->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->payment_plan->Visible) { // payment_plan ?>
	<tr id="r_payment_plan">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_payment_plan"><?php echo $bcode->payment_plan->caption() ?></span></td>
		<td data-name="payment_plan"<?php echo $bcode->payment_plan->cellAttributes() ?>>
<span id="el_bcode_payment_plan">
<span<?php echo $bcode->payment_plan->viewAttributes() ?>>
<?php echo $bcode->payment_plan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->production_plan->Visible) { // production_plan ?>
	<tr id="r_production_plan">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_production_plan"><?php echo $bcode->production_plan->caption() ?></span></td>
		<td data-name="production_plan"<?php echo $bcode->production_plan->cellAttributes() ?>>
<span id="el_bcode_production_plan">
<span<?php echo $bcode->production_plan->viewAttributes() ?>>
<?php echo $bcode->production_plan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_datetime"><?php echo $bcode->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $bcode->datetime->cellAttributes() ?>>
<span id="el_bcode_datetime">
<span<?php echo $bcode->datetime->viewAttributes() ?>>
<?php echo $bcode->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->completed->Visible) { // completed ?>
	<tr id="r_completed">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_completed"><?php echo $bcode->completed->caption() ?></span></td>
		<td data-name="completed"<?php echo $bcode->completed->cellAttributes() ?>>
<span id="el_bcode_completed">
<span<?php echo $bcode->completed->viewAttributes() ?>>
<?php echo $bcode->completed->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->buyer_po->Visible) { // buyer_po ?>
	<tr id="r_buyer_po">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_buyer_po"><?php echo $bcode->buyer_po->caption() ?></span></td>
		<td data-name="buyer_po"<?php echo $bcode->buyer_po->cellAttributes() ?>>
<span id="el_bcode_buyer_po">
<span<?php echo $bcode->buyer_po->viewAttributes() ?>>
<?php echo $bcode->buyer_po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_operator"><?php echo $bcode->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $bcode->operator->cellAttributes() ?>>
<span id="el_bcode_operator">
<span<?php echo $bcode->operator->viewAttributes() ?>>
<?php echo $bcode->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->jc_no->Visible) { // jc_no ?>
	<tr id="r_jc_no">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_jc_no"><?php echo $bcode->jc_no->caption() ?></span></td>
		<td data-name="jc_no"<?php echo $bcode->jc_no->cellAttributes() ?>>
<span id="el_bcode_jc_no">
<span<?php echo $bcode->jc_no->viewAttributes() ?>>
<?php echo $bcode->jc_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->sqm_a->Visible) { // sqm_a ?>
	<tr id="r_sqm_a">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_sqm_a"><?php echo $bcode->sqm_a->caption() ?></span></td>
		<td data-name="sqm_a"<?php echo $bcode->sqm_a->cellAttributes() ?>>
<span id="el_bcode_sqm_a">
<span<?php echo $bcode->sqm_a->viewAttributes() ?>>
<?php echo $bcode->sqm_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_2srm->Visible) { // 2srm ?>
	<tr id="r__2srm">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__2srm"><?php echo $bcode->_2srm->caption() ?></span></td>
		<td data-name="_2srm"<?php echo $bcode->_2srm->cellAttributes() ?>>
<span id="el_bcode__2srm">
<span<?php echo $bcode->_2srm->viewAttributes() ?>>
<?php echo $bcode->_2srm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_2srm_a->Visible) { // 2srm_a ?>
	<tr id="r__2srm_a">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__2srm_a"><?php echo $bcode->_2srm_a->caption() ?></span></td>
		<td data-name="_2srm_a"<?php echo $bcode->_2srm_a->cellAttributes() ?>>
<span id="el_bcode__2srm_a">
<span<?php echo $bcode->_2srm_a->viewAttributes() ?>>
<?php echo $bcode->_2srm_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_4srm->Visible) { // 4srm ?>
	<tr id="r__4srm">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__4srm"><?php echo $bcode->_4srm->caption() ?></span></td>
		<td data-name="_4srm"<?php echo $bcode->_4srm->cellAttributes() ?>>
<span id="el_bcode__4srm">
<span<?php echo $bcode->_4srm->viewAttributes() ?>>
<?php echo $bcode->_4srm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_4srm_a->Visible) { // 4srm_a ?>
	<tr id="r__4srm_a">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__4srm_a"><?php echo $bcode->_4srm_a->caption() ?></span></td>
		<td data-name="_4srm_a"<?php echo $bcode->_4srm_a->cellAttributes() ?>>
<span id="el_bcode__4srm_a">
<span<?php echo $bcode->_4srm_a->viewAttributes() ?>>
<?php echo $bcode->_4srm_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->buyer_tid->Visible) { // buyer_tid ?>
	<tr id="r_buyer_tid">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_buyer_tid"><?php echo $bcode->buyer_tid->caption() ?></span></td>
		<td data-name="buyer_tid"<?php echo $bcode->buyer_tid->cellAttributes() ?>>
<span id="el_bcode_buyer_tid">
<span<?php echo $bcode->buyer_tid->viewAttributes() ?>>
<?php echo $bcode->buyer_tid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_grp"><?php echo $bcode->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $bcode->grp->cellAttributes() ?>>
<span id="el_bcode_grp">
<span<?php echo $bcode->grp->viewAttributes() ?>>
<?php echo $bcode->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_s_grp"><?php echo $bcode->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $bcode->s_grp->cellAttributes() ?>>
<span id="el_bcode_s_grp">
<span<?php echo $bcode->s_grp->viewAttributes() ?>>
<?php echo $bcode->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_batch_no"><?php echo $bcode->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $bcode->batch_no->cellAttributes() ?>>
<span id="el_bcode_batch_no">
<span<?php echo $bcode->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($bcode->batch_no->getViewValue())) && $bcode->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $bcode->batch_no->linkAttributes() ?>><?php echo $bcode->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bcode->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->cs->Visible) { // cs ?>
	<tr id="r_cs">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_cs"><?php echo $bcode->cs->caption() ?></span></td>
		<td data-name="cs"<?php echo $bcode->cs->cellAttributes() ?>>
<span id="el_bcode_cs">
<span<?php echo $bcode->cs->viewAttributes() ?>>
<?php echo $bcode->cs->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_process"><?php echo $bcode->process->caption() ?></span></td>
		<td data-name="process"<?php echo $bcode->process->cellAttributes() ?>>
<span id="el_bcode_process">
<span<?php echo $bcode->process->viewAttributes() ?>>
<?php echo $bcode->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->process_c->Visible) { // process_c ?>
	<tr id="r_process_c">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_process_c"><?php echo $bcode->process_c->caption() ?></span></td>
		<td data-name="process_c"<?php echo $bcode->process_c->cellAttributes() ?>>
<span id="el_bcode_process_c">
<span<?php echo $bcode->process_c->viewAttributes() ?>>
<?php echo $bcode->process_c->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->weight->Visible) { // weight ?>
	<tr id="r_weight">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_weight"><?php echo $bcode->weight->caption() ?></span></td>
		<td data-name="weight"<?php echo $bcode->weight->cellAttributes() ?>>
<span id="el_bcode_weight">
<span<?php echo $bcode->weight->viewAttributes() ?>>
<?php echo $bcode->weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_remarks"><?php echo $bcode->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $bcode->remarks->cellAttributes() ?>>
<span id="el_bcode_remarks">
<span<?php echo $bcode->remarks->viewAttributes() ?>>
<?php echo $bcode->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->roll_no->Visible) { // roll_no ?>
	<tr id="r_roll_no">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_roll_no"><?php echo $bcode->roll_no->caption() ?></span></td>
		<td data-name="roll_no"<?php echo $bcode->roll_no->cellAttributes() ?>>
<span id="el_bcode_roll_no">
<span<?php echo $bcode->roll_no->viewAttributes() ?>>
<?php echo $bcode->roll_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->qty->Visible) { // qty ?>
	<tr id="r_qty">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_qty"><?php echo $bcode->qty->caption() ?></span></td>
		<td data-name="qty"<?php echo $bcode->qty->cellAttributes() ?>>
<span id="el_bcode_qty">
<span<?php echo $bcode->qty->viewAttributes() ?>>
<?php echo $bcode->qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->pl_no->Visible) { // pl_no ?>
	<tr id="r_pl_no">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_pl_no"><?php echo $bcode->pl_no->caption() ?></span></td>
		<td data-name="pl_no"<?php echo $bcode->pl_no->cellAttributes() ?>>
<span id="el_bcode_pl_no">
<span<?php echo $bcode->pl_no->viewAttributes() ?>>
<?php echo $bcode->pl_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_category"><?php echo $bcode->category->caption() ?></span></td>
		<td data-name="category"<?php echo $bcode->category->cellAttributes() ?>>
<span id="el_bcode_category">
<span<?php echo $bcode->category->viewAttributes() ?>>
<?php echo $bcode->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->pp_id->Visible) { // pp_id ?>
	<tr id="r_pp_id">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_pp_id"><?php echo $bcode->pp_id->caption() ?></span></td>
		<td data-name="pp_id"<?php echo $bcode->pp_id->cellAttributes() ?>>
<span id="el_bcode_pp_id">
<span<?php echo $bcode->pp_id->viewAttributes() ?>>
<?php echo $bcode->pp_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_11->Visible) { // 11 ?>
	<tr id="r__11">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__11"><?php echo $bcode->_11->caption() ?></span></td>
		<td data-name="_11"<?php echo $bcode->_11->cellAttributes() ?>>
<span id="el_bcode__11">
<span<?php echo $bcode->_11->viewAttributes() ?>>
<?php echo $bcode->_11->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_12->Visible) { // 12 ?>
	<tr id="r__12">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__12"><?php echo $bcode->_12->caption() ?></span></td>
		<td data-name="_12"<?php echo $bcode->_12->cellAttributes() ?>>
<span id="el_bcode__12">
<span<?php echo $bcode->_12->viewAttributes() ?>>
<?php echo $bcode->_12->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_13->Visible) { // 13 ?>
	<tr id="r__13">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__13"><?php echo $bcode->_13->caption() ?></span></td>
		<td data-name="_13"<?php echo $bcode->_13->cellAttributes() ?>>
<span id="el_bcode__13">
<span<?php echo $bcode->_13->viewAttributes() ?>>
<?php echo $bcode->_13->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_14->Visible) { // 14 ?>
	<tr id="r__14">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__14"><?php echo $bcode->_14->caption() ?></span></td>
		<td data-name="_14"<?php echo $bcode->_14->cellAttributes() ?>>
<span id="el_bcode__14">
<span<?php echo $bcode->_14->viewAttributes() ?>>
<?php echo $bcode->_14->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_15->Visible) { // 15 ?>
	<tr id="r__15">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__15"><?php echo $bcode->_15->caption() ?></span></td>
		<td data-name="_15"<?php echo $bcode->_15->cellAttributes() ?>>
<span id="el_bcode__15">
<span<?php echo $bcode->_15->viewAttributes() ?>>
<?php echo $bcode->_15->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_16->Visible) { // 16 ?>
	<tr id="r__16">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__16"><?php echo $bcode->_16->caption() ?></span></td>
		<td data-name="_16"<?php echo $bcode->_16->cellAttributes() ?>>
<span id="el_bcode__16">
<span<?php echo $bcode->_16->viewAttributes() ?>>
<?php echo $bcode->_16->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_17->Visible) { // 17 ?>
	<tr id="r__17">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__17"><?php echo $bcode->_17->caption() ?></span></td>
		<td data-name="_17"<?php echo $bcode->_17->cellAttributes() ?>>
<span id="el_bcode__17">
<span<?php echo $bcode->_17->viewAttributes() ?>>
<?php echo $bcode->_17->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_18->Visible) { // 18 ?>
	<tr id="r__18">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__18"><?php echo $bcode->_18->caption() ?></span></td>
		<td data-name="_18"<?php echo $bcode->_18->cellAttributes() ?>>
<span id="el_bcode__18">
<span<?php echo $bcode->_18->viewAttributes() ?>>
<?php echo $bcode->_18->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_19->Visible) { // 19 ?>
	<tr id="r__19">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__19"><?php echo $bcode->_19->caption() ?></span></td>
		<td data-name="_19"<?php echo $bcode->_19->cellAttributes() ?>>
<span id="el_bcode__19">
<span<?php echo $bcode->_19->viewAttributes() ?>>
<?php echo $bcode->_19->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_20->Visible) { // 20 ?>
	<tr id="r__20">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__20"><?php echo $bcode->_20->caption() ?></span></td>
		<td data-name="_20"<?php echo $bcode->_20->cellAttributes() ?>>
<span id="el_bcode__20">
<span<?php echo $bcode->_20->viewAttributes() ?>>
<?php echo $bcode->_20->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_21->Visible) { // 21 ?>
	<tr id="r__21">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__21"><?php echo $bcode->_21->caption() ?></span></td>
		<td data-name="_21"<?php echo $bcode->_21->cellAttributes() ?>>
<span id="el_bcode__21">
<span<?php echo $bcode->_21->viewAttributes() ?>>
<?php echo $bcode->_21->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_22->Visible) { // 22 ?>
	<tr id="r__22">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__22"><?php echo $bcode->_22->caption() ?></span></td>
		<td data-name="_22"<?php echo $bcode->_22->cellAttributes() ?>>
<span id="el_bcode__22">
<span<?php echo $bcode->_22->viewAttributes() ?>>
<?php echo $bcode->_22->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_23->Visible) { // 23 ?>
	<tr id="r__23">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__23"><?php echo $bcode->_23->caption() ?></span></td>
		<td data-name="_23"<?php echo $bcode->_23->cellAttributes() ?>>
<span id="el_bcode__23">
<span<?php echo $bcode->_23->viewAttributes() ?>>
<?php echo $bcode->_23->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_24->Visible) { // 24 ?>
	<tr id="r__24">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__24"><?php echo $bcode->_24->caption() ?></span></td>
		<td data-name="_24"<?php echo $bcode->_24->cellAttributes() ?>>
<span id="el_bcode__24">
<span<?php echo $bcode->_24->viewAttributes() ?>>
<?php echo $bcode->_24->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_25->Visible) { // 25 ?>
	<tr id="r__25">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__25"><?php echo $bcode->_25->caption() ?></span></td>
		<td data-name="_25"<?php echo $bcode->_25->cellAttributes() ?>>
<span id="el_bcode__25">
<span<?php echo $bcode->_25->viewAttributes() ?>>
<?php echo $bcode->_25->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_26->Visible) { // 26 ?>
	<tr id="r__26">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__26"><?php echo $bcode->_26->caption() ?></span></td>
		<td data-name="_26"<?php echo $bcode->_26->cellAttributes() ?>>
<span id="el_bcode__26">
<span<?php echo $bcode->_26->viewAttributes() ?>>
<?php echo $bcode->_26->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_27->Visible) { // 27 ?>
	<tr id="r__27">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__27"><?php echo $bcode->_27->caption() ?></span></td>
		<td data-name="_27"<?php echo $bcode->_27->cellAttributes() ?>>
<span id="el_bcode__27">
<span<?php echo $bcode->_27->viewAttributes() ?>>
<?php echo $bcode->_27->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_28->Visible) { // 28 ?>
	<tr id="r__28">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__28"><?php echo $bcode->_28->caption() ?></span></td>
		<td data-name="_28"<?php echo $bcode->_28->cellAttributes() ?>>
<span id="el_bcode__28">
<span<?php echo $bcode->_28->viewAttributes() ?>>
<?php echo $bcode->_28->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_29->Visible) { // 29 ?>
	<tr id="r__29">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__29"><?php echo $bcode->_29->caption() ?></span></td>
		<td data-name="_29"<?php echo $bcode->_29->cellAttributes() ?>>
<span id="el_bcode__29">
<span<?php echo $bcode->_29->viewAttributes() ?>>
<?php echo $bcode->_29->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_30->Visible) { // 30 ?>
	<tr id="r__30">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__30"><?php echo $bcode->_30->caption() ?></span></td>
		<td data-name="_30"<?php echo $bcode->_30->cellAttributes() ?>>
<span id="el_bcode__30">
<span<?php echo $bcode->_30->viewAttributes() ?>>
<?php echo $bcode->_30->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_31->Visible) { // 31 ?>
	<tr id="r__31">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__31"><?php echo $bcode->_31->caption() ?></span></td>
		<td data-name="_31"<?php echo $bcode->_31->cellAttributes() ?>>
<span id="el_bcode__31">
<span<?php echo $bcode->_31->viewAttributes() ?>>
<?php echo $bcode->_31->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_32->Visible) { // 32 ?>
	<tr id="r__32">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__32"><?php echo $bcode->_32->caption() ?></span></td>
		<td data-name="_32"<?php echo $bcode->_32->cellAttributes() ?>>
<span id="el_bcode__32">
<span<?php echo $bcode->_32->viewAttributes() ?>>
<?php echo $bcode->_32->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_33->Visible) { // 33 ?>
	<tr id="r__33">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__33"><?php echo $bcode->_33->caption() ?></span></td>
		<td data-name="_33"<?php echo $bcode->_33->cellAttributes() ?>>
<span id="el_bcode__33">
<span<?php echo $bcode->_33->viewAttributes() ?>>
<?php echo $bcode->_33->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_34->Visible) { // 34 ?>
	<tr id="r__34">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__34"><?php echo $bcode->_34->caption() ?></span></td>
		<td data-name="_34"<?php echo $bcode->_34->cellAttributes() ?>>
<span id="el_bcode__34">
<span<?php echo $bcode->_34->viewAttributes() ?>>
<?php echo $bcode->_34->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_35->Visible) { // 35 ?>
	<tr id="r__35">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__35"><?php echo $bcode->_35->caption() ?></span></td>
		<td data-name="_35"<?php echo $bcode->_35->cellAttributes() ?>>
<span id="el_bcode__35">
<span<?php echo $bcode->_35->viewAttributes() ?>>
<?php echo $bcode->_35->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_36->Visible) { // 36 ?>
	<tr id="r__36">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__36"><?php echo $bcode->_36->caption() ?></span></td>
		<td data-name="_36"<?php echo $bcode->_36->cellAttributes() ?>>
<span id="el_bcode__36">
<span<?php echo $bcode->_36->viewAttributes() ?>>
<?php echo $bcode->_36->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_37->Visible) { // 37 ?>
	<tr id="r__37">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__37"><?php echo $bcode->_37->caption() ?></span></td>
		<td data-name="_37"<?php echo $bcode->_37->cellAttributes() ?>>
<span id="el_bcode__37">
<span<?php echo $bcode->_37->viewAttributes() ?>>
<?php echo $bcode->_37->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_38->Visible) { // 38 ?>
	<tr id="r__38">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__38"><?php echo $bcode->_38->caption() ?></span></td>
		<td data-name="_38"<?php echo $bcode->_38->cellAttributes() ?>>
<span id="el_bcode__38">
<span<?php echo $bcode->_38->viewAttributes() ?>>
<?php echo $bcode->_38->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_39->Visible) { // 39 ?>
	<tr id="r__39">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__39"><?php echo $bcode->_39->caption() ?></span></td>
		<td data-name="_39"<?php echo $bcode->_39->cellAttributes() ?>>
<span id="el_bcode__39">
<span<?php echo $bcode->_39->viewAttributes() ?>>
<?php echo $bcode->_39->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_40->Visible) { // 40 ?>
	<tr id="r__40">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__40"><?php echo $bcode->_40->caption() ?></span></td>
		<td data-name="_40"<?php echo $bcode->_40->cellAttributes() ?>>
<span id="el_bcode__40">
<span<?php echo $bcode->_40->viewAttributes() ?>>
<?php echo $bcode->_40->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_41->Visible) { // 41 ?>
	<tr id="r__41">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__41"><?php echo $bcode->_41->caption() ?></span></td>
		<td data-name="_41"<?php echo $bcode->_41->cellAttributes() ?>>
<span id="el_bcode__41">
<span<?php echo $bcode->_41->viewAttributes() ?>>
<?php echo $bcode->_41->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_42->Visible) { // 42 ?>
	<tr id="r__42">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__42"><?php echo $bcode->_42->caption() ?></span></td>
		<td data-name="_42"<?php echo $bcode->_42->cellAttributes() ?>>
<span id="el_bcode__42">
<span<?php echo $bcode->_42->viewAttributes() ?>>
<?php echo $bcode->_42->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_43->Visible) { // 43 ?>
	<tr id="r__43">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__43"><?php echo $bcode->_43->caption() ?></span></td>
		<td data-name="_43"<?php echo $bcode->_43->cellAttributes() ?>>
<span id="el_bcode__43">
<span<?php echo $bcode->_43->viewAttributes() ?>>
<?php echo $bcode->_43->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_44->Visible) { // 44 ?>
	<tr id="r__44">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__44"><?php echo $bcode->_44->caption() ?></span></td>
		<td data-name="_44"<?php echo $bcode->_44->cellAttributes() ?>>
<span id="el_bcode__44">
<span<?php echo $bcode->_44->viewAttributes() ?>>
<?php echo $bcode->_44->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_45->Visible) { // 45 ?>
	<tr id="r__45">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__45"><?php echo $bcode->_45->caption() ?></span></td>
		<td data-name="_45"<?php echo $bcode->_45->cellAttributes() ?>>
<span id="el_bcode__45">
<span<?php echo $bcode->_45->viewAttributes() ?>>
<?php echo $bcode->_45->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_46->Visible) { // 46 ?>
	<tr id="r__46">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__46"><?php echo $bcode->_46->caption() ?></span></td>
		<td data-name="_46"<?php echo $bcode->_46->cellAttributes() ?>>
<span id="el_bcode__46">
<span<?php echo $bcode->_46->viewAttributes() ?>>
<?php echo $bcode->_46->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_47->Visible) { // 47 ?>
	<tr id="r__47">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__47"><?php echo $bcode->_47->caption() ?></span></td>
		<td data-name="_47"<?php echo $bcode->_47->cellAttributes() ?>>
<span id="el_bcode__47">
<span<?php echo $bcode->_47->viewAttributes() ?>>
<?php echo $bcode->_47->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_48->Visible) { // 48 ?>
	<tr id="r__48">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__48"><?php echo $bcode->_48->caption() ?></span></td>
		<td data-name="_48"<?php echo $bcode->_48->cellAttributes() ?>>
<span id="el_bcode__48">
<span<?php echo $bcode->_48->viewAttributes() ?>>
<?php echo $bcode->_48->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_49->Visible) { // 49 ?>
	<tr id="r__49">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__49"><?php echo $bcode->_49->caption() ?></span></td>
		<td data-name="_49"<?php echo $bcode->_49->cellAttributes() ?>>
<span id="el_bcode__49">
<span<?php echo $bcode->_49->viewAttributes() ?>>
<?php echo $bcode->_49->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->_50->Visible) { // 50 ?>
	<tr id="r__50">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode__50"><?php echo $bcode->_50->caption() ?></span></td>
		<td data-name="_50"<?php echo $bcode->_50->cellAttributes() ?>>
<span id="el_bcode__50">
<span<?php echo $bcode->_50->viewAttributes() ?>>
<?php echo $bcode->_50->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->p_remarks->Visible) { // p_remarks ?>
	<tr id="r_p_remarks">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_p_remarks"><?php echo $bcode->p_remarks->caption() ?></span></td>
		<td data-name="p_remarks"<?php echo $bcode->p_remarks->cellAttributes() ?>>
<span id="el_bcode_p_remarks">
<span<?php echo $bcode->p_remarks->viewAttributes() ?>>
<?php echo $bcode->p_remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bcode->roll_no_qty_tmp->Visible) { // roll_no_qty_tmp ?>
	<tr id="r_roll_no_qty_tmp">
		<td class="<?php echo $bcode_view->TableLeftColumnClass ?>"><span id="elh_bcode_roll_no_qty_tmp"><?php echo $bcode->roll_no_qty_tmp->caption() ?></span></td>
		<td data-name="roll_no_qty_tmp"<?php echo $bcode->roll_no_qty_tmp->cellAttributes() ?>>
<span id="el_bcode_roll_no_qty_tmp">
<span<?php echo $bcode->roll_no_qty_tmp->viewAttributes() ?>>
<?php echo $bcode->roll_no_qty_tmp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$bcode_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bcode->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bcode_view->terminate();
?>