<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$blending_process_f_search = new blending_process_f_search();

// Run the page
$blending_process_f_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$blending_process_f_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($blending_process_f_search->IsModal) { ?>
var fblending_process_fsearch = currentAdvancedSearchForm = new ew.Form("fblending_process_fsearch", "search");
<?php } else { ?>
var fblending_process_fsearch = currentForm = new ew.Form("fblending_process_fsearch", "search");
<?php } ?>

// Form_CustomValidate event
fblending_process_fsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fblending_process_fsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fblending_process_fsearch.lists["x_product"] = <?php echo $blending_process_f_search->product->Lookup->toClientList() ?>;
fblending_process_fsearch.lists["x_product"].options = <?php echo JsonEncode($blending_process_f_search->product->lookupOptions()) ?>;
fblending_process_fsearch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fblending_process_fsearch.lists["x_godown"] = <?php echo $blending_process_f_search->godown->Lookup->toClientList() ?>;
fblending_process_fsearch.lists["x_godown"].options = <?php echo JsonEncode($blending_process_f_search->godown->lookupOptions()) ?>;
fblending_process_fsearch.lists["x_packing_type"] = <?php echo $blending_process_f_search->packing_type->Lookup->toClientList() ?>;
fblending_process_fsearch.lists["x_packing_type"].options = <?php echo JsonEncode($blending_process_f_search->packing_type->lookupOptions()) ?>;
fblending_process_fsearch.lists["x_status"] = <?php echo $blending_process_f_search->status->Lookup->toClientList() ?>;
fblending_process_fsearch.lists["x_status"].options = <?php echo JsonEncode($blending_process_f_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fblending_process_fsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lot_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->lot_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_supplier");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->supplier->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->process_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_yield");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_process_f->avg_yield->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $blending_process_f_search->showPageHeader(); ?>
<?php
$blending_process_f_search->showMessage();
?>
<form name="fblending_process_fsearch" id="fblending_process_fsearch" class="<?php echo $blending_process_f_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($blending_process_f_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $blending_process_f_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="blending_process_f">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$blending_process_f_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($blending_process_f->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_id"><?php echo $blending_process_f->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->id->cellAttributes() ?>>
			<span id="el_blending_process_f_id">
<input type="text" data-table="blending_process_f" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($blending_process_f->id->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->id->EditValue ?>"<?php echo $blending_process_f->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_dated"><?php echo $blending_process_f->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->dated->cellAttributes() ?>>
			<span id="el_blending_process_f_dated">
<input type="text" data-table="blending_process_f" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($blending_process_f->dated->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->dated->EditValue ?>"<?php echo $blending_process_f->dated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_product"><?php echo $blending_process_f->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->product->cellAttributes() ?>>
			<span id="el_blending_process_f_product">
<?php
$wrkonchange = "" . trim(@$blending_process_f->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$blending_process_f->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($blending_process_f->product->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($blending_process_f->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($blending_process_f->product->getPlaceHolder()) ?>"<?php echo $blending_process_f->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="blending_process_f" data-field="x_product" data-value-separator="<?php echo $blending_process_f->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($blending_process_f->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fblending_process_fsearch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $blending_process_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_product_code"><?php echo $blending_process_f->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->product_code->cellAttributes() ?>>
			<span id="el_blending_process_f_product_code">
<input type="text" data-table="blending_process_f" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($blending_process_f->product_code->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->product_code->EditValue ?>"<?php echo $blending_process_f->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_godown"><?php echo $blending_process_f->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->godown->cellAttributes() ?>>
			<span id="el_blending_process_f_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_process_f" data-field="x_godown" data-value-separator="<?php echo $blending_process_f->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $blending_process_f->godown->editAttributes() ?>>
		<?php echo $blending_process_f->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $blending_process_f->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_Balance"><?php echo $blending_process_f->Balance->caption() ?></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->Balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($blending_process_f->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_blending_process_f_Balance">
<input type="text" data-table="blending_process_f" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->Balance->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->Balance->EditValue ?>"<?php echo $blending_process_f->Balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_blending_process_f_Balance" class="btw1_Balance d-none">
<input type="text" data-table="blending_process_f" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->Balance->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->Balance->EditValue2 ?>"<?php echo $blending_process_f->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_IN"><?php echo $blending_process_f->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->IN->cellAttributes() ?>>
			<span id="el_blending_process_f_IN">
<input type="text" data-table="blending_process_f" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->IN->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->IN->EditValue ?>"<?php echo $blending_process_f->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_OUT"><?php echo $blending_process_f->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->OUT->cellAttributes() ?>>
			<span id="el_blending_process_f_OUT">
<input type="text" data-table="blending_process_f" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->OUT->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->OUT->EditValue ?>"<?php echo $blending_process_f->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_packets"><?php echo $blending_process_f->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->packets->cellAttributes() ?>>
			<span id="el_blending_process_f_packets">
<input type="text" data-table="blending_process_f" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->packets->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->packets->EditValue ?>"<?php echo $blending_process_f->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_packing_type"><?php echo $blending_process_f->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->packing_type->cellAttributes() ?>>
			<span id="el_blending_process_f_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_process_f" data-field="x_packing_type" data-value-separator="<?php echo $blending_process_f->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $blending_process_f->packing_type->editAttributes() ?>>
		<?php echo $blending_process_f->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $blending_process_f->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_lot_no"><?php echo $blending_process_f->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->lot_no->cellAttributes() ?>>
			<span id="el_blending_process_f_lot_no">
<input type="text" data-table="blending_process_f" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->lot_no->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->lot_no->EditValue ?>"<?php echo $blending_process_f->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label for="x_supplier" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_supplier"><?php echo $blending_process_f->supplier->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_supplier" id="z_supplier" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->supplier->cellAttributes() ?>>
			<span id="el_blending_process_f_supplier">
<input type="text" data-table="blending_process_f" data-field="x_supplier" name="x_supplier" id="x_supplier" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->supplier->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->supplier->EditValue ?>"<?php echo $blending_process_f->supplier->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_remarks"><?php echo $blending_process_f->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->remarks->cellAttributes() ?>>
			<span id="el_blending_process_f_remarks">
<input type="text" data-table="blending_process_f" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($blending_process_f->remarks->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->remarks->EditValue ?>"<?php echo $blending_process_f->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_status"><?php echo $blending_process_f->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->status->cellAttributes() ?>>
			<span id="el_blending_process_f_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_process_f" data-field="x_status" data-value-separator="<?php echo $blending_process_f->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $blending_process_f->status->editAttributes() ?>>
		<?php echo $blending_process_f->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_tmp_lot"><?php echo $blending_process_f->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->tmp_lot->cellAttributes() ?>>
			<span id="el_blending_process_f_tmp_lot">
<input type="text" data-table="blending_process_f" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->tmp_lot->EditValue ?>"<?php echo $blending_process_f->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->product_n->Visible) { // product_n ?>
	<div id="r_product_n" class="form-group row">
		<label for="x_product_n" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_product_n"><?php echo $blending_process_f->product_n->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_n" id="z_product_n" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->product_n->cellAttributes() ?>>
			<span id="el_blending_process_f_product_n">
<input type="text" data-table="blending_process_f" data-field="x_product_n" name="x_product_n" id="x_product_n" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($blending_process_f->product_n->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->product_n->EditValue ?>"<?php echo $blending_process_f->product_n->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->process_type->Visible) { // process_type ?>
	<div id="r_process_type" class="form-group row">
		<label for="x_process_type" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_process_type"><?php echo $blending_process_f->process_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_type" id="z_process_type" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->process_type->cellAttributes() ?>>
			<span id="el_blending_process_f_process_type">
<input type="text" data-table="blending_process_f" data-field="x_process_type" name="x_process_type" id="x_process_type" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->process_type->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->process_type->EditValue ?>"<?php echo $blending_process_f->process_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->gcode->Visible) { // gcode ?>
	<div id="r_gcode" class="form-group row">
		<label for="x_gcode" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_gcode"><?php echo $blending_process_f->gcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gcode" id="z_gcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->gcode->cellAttributes() ?>>
			<span id="el_blending_process_f_gcode">
<input type="text" data-table="blending_process_f" data-field="x_gcode" name="x_gcode" id="x_gcode" size="30" maxlength="3" placeholder="<?php echo HtmlEncode($blending_process_f->gcode->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->gcode->EditValue ?>"<?php echo $blending_process_f->gcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_process_f->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label for="x_avg_yield" class="<?php echo $blending_process_f_search->LeftColumnClass ?>"><span id="elh_blending_process_f_avg_yield"><?php echo $blending_process_f->avg_yield->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_yield" id="z_avg_yield" value="="></span>
		</label>
		<div class="<?php echo $blending_process_f_search->RightColumnClass ?>"><div<?php echo $blending_process_f->avg_yield->cellAttributes() ?>>
			<span id="el_blending_process_f_avg_yield">
<input type="text" data-table="blending_process_f" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" size="30" placeholder="<?php echo HtmlEncode($blending_process_f->avg_yield->getPlaceHolder()) ?>" value="<?php echo $blending_process_f->avg_yield->EditValue ?>"<?php echo $blending_process_f->avg_yield->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$blending_process_f_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $blending_process_f_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$blending_process_f_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$blending_process_f_search->terminate();
?>