<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$blending_table_search = new blending_table_search();

// Run the page
$blending_table_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$blending_table_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($blending_table_search->IsModal) { ?>
var fblending_tablesearch = currentAdvancedSearchForm = new ew.Form("fblending_tablesearch", "search");
<?php } else { ?>
var fblending_tablesearch = currentForm = new ew.Form("fblending_tablesearch", "search");
<?php } ?>

// Form_CustomValidate event
fblending_tablesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fblending_tablesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fblending_tablesearch.lists["x_ref[]"] = <?php echo $blending_table_search->ref->Lookup->toClientList() ?>;
fblending_tablesearch.lists["x_ref[]"].options = <?php echo JsonEncode($blending_table_search->ref->lookupOptions()) ?>;
fblending_tablesearch.lists["x_rid"] = <?php echo $blending_table_search->rid->Lookup->toClientList() ?>;
fblending_tablesearch.lists["x_rid"].options = <?php echo JsonEncode($blending_table_search->rid->lookupOptions()) ?>;
fblending_tablesearch.lists["x_par_com"] = <?php echo $blending_table_search->par_com->Lookup->toClientList() ?>;
fblending_tablesearch.lists["x_par_com"].options = <?php echo JsonEncode($blending_table_search->par_com->options(FALSE, TRUE)) ?>;
fblending_tablesearch.lists["x_packing_type"] = <?php echo $blending_table_search->packing_type->Lookup->toClientList() ?>;
fblending_tablesearch.lists["x_packing_type"].options = <?php echo JsonEncode($blending_table_search->packing_type->lookupOptions()) ?>;
fblending_tablesearch.lists["x_godown"] = <?php echo $blending_table_search->godown->Lookup->toClientList() ?>;
fblending_tablesearch.lists["x_godown"].options = <?php echo JsonEncode($blending_table_search->godown->lookupOptions()) ?>;
fblending_tablesearch.lists["x_employee_id[]"] = <?php echo $blending_table_search->employee_id->Lookup->toClientList() ?>;
fblending_tablesearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($blending_table_search->employee_id->lookupOptions()) ?>;
fblending_tablesearch.lists["x_operator"] = <?php echo $blending_table_search->operator->Lookup->toClientList() ?>;
fblending_tablesearch.lists["x_operator"].options = <?php echo JsonEncode($blending_table_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fblending_tablesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_table->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_table->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($blending_table->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $blending_table_search->showPageHeader(); ?>
<?php
$blending_table_search->showMessage();
?>
<form name="fblending_tablesearch" id="fblending_tablesearch" class="<?php echo $blending_table_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($blending_table_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $blending_table_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="blending_table">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$blending_table_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($blending_table->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_id"><?php echo $blending_table->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->id->cellAttributes() ?>>
			<span id="el_blending_table_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_table" data-field="x_id" data-value-separator="<?php echo $blending_table->id->displayValueSeparatorAttribute() ?>" id="x_id" name="x_id"<?php echo $blending_table->id->editAttributes() ?>>
		<?php echo $blending_table->id->selectOptionListHtml("x_id") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_ref"><?php echo $blending_table->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->ref->cellAttributes() ?>>
			<span id="el_blending_table_ref">
<div id="tp_x_ref" class="ew-template"><input type="checkbox" class="form-check-input" data-table="blending_table" data-field="x_ref" data-value-separator="<?php echo $blending_table->ref->displayValueSeparatorAttribute() ?>" name="x_ref[]" id="x_ref[]" value="{value}"<?php echo $blending_table->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $blending_table->ref->checkBoxListHtml(FALSE, "x_ref[]") ?>
</div></div>
<?php echo $blending_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_rid"><?php echo $blending_table->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->rid->cellAttributes() ?>>
			<span id="el_blending_table_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_table" data-field="x_rid" data-value-separator="<?php echo $blending_table->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $blending_table->rid->editAttributes() ?>>
		<?php echo $blending_table->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $blending_table->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_tmp_lot"><?php echo $blending_table->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->tmp_lot->cellAttributes() ?>>
			<span id="el_blending_table_tmp_lot">
<input type="text" data-table="blending_table" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($blending_table->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $blending_table->tmp_lot->EditValue ?>"<?php echo $blending_table->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_packets"><?php echo $blending_table->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->packets->cellAttributes() ?>>
			<span id="el_blending_table_packets">
<input type="text" data-table="blending_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($blending_table->packets->getPlaceHolder()) ?>" value="<?php echo $blending_table->packets->EditValue ?>"<?php echo $blending_table->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_quantity"><?php echo $blending_table->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->quantity->cellAttributes() ?>>
			<span id="el_blending_table_quantity">
<input type="text" data-table="blending_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($blending_table->quantity->getPlaceHolder()) ?>" value="<?php echo $blending_table->quantity->EditValue ?>"<?php echo $blending_table->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->par_com->Visible) { // par_com ?>
	<div id="r_par_com" class="form-group row">
		<label class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_par_com"><?php echo $blending_table->par_com->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_par_com" id="z_par_com" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->par_com->cellAttributes() ?>>
			<span id="el_blending_table_par_com">
<div id="tp_x_par_com" class="ew-template"><input type="radio" class="form-check-input" data-table="blending_table" data-field="x_par_com" data-value-separator="<?php echo $blending_table->par_com->displayValueSeparatorAttribute() ?>" name="x_par_com" id="x_par_com" value="{value}"<?php echo $blending_table->par_com->editAttributes() ?>></div>
<div id="dsl_x_par_com" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $blending_table->par_com->radioButtonListHtml(FALSE, "x_par_com") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_packing_type"><?php echo $blending_table->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->packing_type->cellAttributes() ?>>
			<span id="el_blending_table_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_table" data-field="x_packing_type" data-value-separator="<?php echo $blending_table->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $blending_table->packing_type->editAttributes() ?>>
		<?php echo $blending_table->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $blending_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_godown"><?php echo $blending_table->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->godown->cellAttributes() ?>>
			<span id="el_blending_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_table" data-field="x_godown" data-value-separator="<?php echo $blending_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $blending_table->godown->editAttributes() ?>>
		<?php echo $blending_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $blending_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_dated"><?php echo $blending_table->dated->caption() ?></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($blending_table->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_blending_table_dated">
<input type="text" data-table="blending_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($blending_table->dated->getPlaceHolder()) ?>" value="<?php echo $blending_table->dated->EditValue ?>"<?php echo $blending_table->dated->editAttributes() ?>>
<?php if (!$blending_table->dated->ReadOnly && !$blending_table->dated->Disabled && !isset($blending_table->dated->EditAttrs["readonly"]) && !isset($blending_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fblending_tablesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_blending_table_dated" class="btw1_dated d-none">
<input type="text" data-table="blending_table" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($blending_table->dated->getPlaceHolder()) ?>" value="<?php echo $blending_table->dated->EditValue2 ?>"<?php echo $blending_table->dated->editAttributes() ?>>
<?php if (!$blending_table->dated->ReadOnly && !$blending_table->dated->Disabled && !isset($blending_table->dated->EditAttrs["readonly"]) && !isset($blending_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fblending_tablesearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_employee_id"><?php echo $blending_table->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->employee_id->cellAttributes() ?>>
			<span id="el_blending_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($blending_table->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($blending_table->employee_id->AdvancedSearch->ViewValue) : $blending_table->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($blending_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($blending_table->employee_id->ReadOnly || $blending_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $blending_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="blending_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $blending_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $blending_table->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $blending_table->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_operator"><?php echo $blending_table->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->operator->cellAttributes() ?>>
			<span id="el_blending_table_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="blending_table" data-field="x_operator" data-value-separator="<?php echo $blending_table->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $blending_table->operator->editAttributes() ?>>
		<?php echo $blending_table->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $blending_table->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_datetime"><?php echo $blending_table->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($blending_table->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_blending_table_datetime">
<input type="text" data-table="blending_table" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($blending_table->datetime->getPlaceHolder()) ?>" value="<?php echo $blending_table->datetime->EditValue ?>"<?php echo $blending_table->datetime->editAttributes() ?>>
<?php if (!$blending_table->datetime->ReadOnly && !$blending_table->datetime->Disabled && !isset($blending_table->datetime->EditAttrs["readonly"]) && !isset($blending_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fblending_tablesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_blending_table_datetime" class="btw1_datetime d-none">
<input type="text" data-table="blending_table" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($blending_table->datetime->getPlaceHolder()) ?>" value="<?php echo $blending_table->datetime->EditValue2 ?>"<?php echo $blending_table->datetime->editAttributes() ?>>
<?php if (!$blending_table->datetime->ReadOnly && !$blending_table->datetime->Disabled && !isset($blending_table->datetime->EditAttrs["readonly"]) && !isset($blending_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fblending_tablesearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($blending_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $blending_table_search->LeftColumnClass ?>"><span id="elh_blending_table_remarks"><?php echo $blending_table->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $blending_table_search->RightColumnClass ?>"><div<?php echo $blending_table->remarks->cellAttributes() ?>>
			<span id="el_blending_table_remarks">
<input type="text" data-table="blending_table" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="40" placeholder="<?php echo HtmlEncode($blending_table->remarks->getPlaceHolder()) ?>" value="<?php echo $blending_table->remarks->EditValue ?>"<?php echo $blending_table->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$blending_table_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $blending_table_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$blending_table_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$blending_table_search->terminate();
?>