<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bom_f_list = new bom_f_list();

// Run the page
$bom_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bom_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bom_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbom_flist = currentForm = new ew.Form("fbom_flist", "list");
fbom_flist.formKeyCountName = '<?php echo $bom_f_list->FormKeyCountName ?>';

// Validate form
fbom_flist.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($bom_f_list->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->id->caption(), $bom_f->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->grp->caption(), $bom_f->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->s_grp->caption(), $bom_f->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->product->caption(), $bom_f->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_f->product->errorMessage()) ?>");
		<?php if ($bom_f_list->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->rid->caption(), $bom_f->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_f->rid->errorMessage()) ?>");
		<?php if ($bom_f_list->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->batch_no->caption(), $bom_f->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_f->batch_no->errorMessage()) ?>");
		<?php if ($bom_f_list->material_group->Required) { ?>
			elm = this.getElements("x" + infix + "_material_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->material_group->caption(), $bom_f->material_group->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->material->Required) { ?>
			elm = this.getElements("x" + infix + "_material");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->material->caption(), $bom_f->material->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->material_id->Required) { ?>
			elm = this.getElements("x" + infix + "_material_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->material_id->caption(), $bom_f->material_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->quantity->caption(), $bom_f->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_f->quantity->errorMessage()) ?>");
		<?php if ($bom_f_list->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->method->caption(), $bom_f->method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->unit->caption(), $bom_f->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->operator->caption(), $bom_f->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->datetime->caption(), $bom_f->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_f_list->a_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_a_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_f->a_operator->caption(), $bom_f->a_operator->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	if (gridinsert && addcnt == 0) { // No row added
		ew.alert(ew.language.phrase("NoAddRecord"));
		return false;
	}
	return true;
}

// Check empty row
fbom_flist.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "grp", false)) return false;
	if (ew.valueChanged(fobj, infix, "s_grp", false)) return false;
	if (ew.valueChanged(fobj, infix, "product", false)) return false;
	if (ew.valueChanged(fobj, infix, "rid", false)) return false;
	if (ew.valueChanged(fobj, infix, "batch_no", false)) return false;
	if (ew.valueChanged(fobj, infix, "material_group", false)) return false;
	if (ew.valueChanged(fobj, infix, "material", false)) return false;
	if (ew.valueChanged(fobj, infix, "material_id", false)) return false;
	if (ew.valueChanged(fobj, infix, "quantity", false)) return false;
	if (ew.valueChanged(fobj, infix, "method", false)) return false;
	if (ew.valueChanged(fobj, infix, "unit", false)) return false;
	if (ew.valueChanged(fobj, infix, "a_operator", false)) return false;
	return true;
}

// Form_CustomValidate event
fbom_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbom_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbom_flist.lists["x_grp"] = <?php echo $bom_f_list->grp->Lookup->toClientList() ?>;
fbom_flist.lists["x_grp"].options = <?php echo JsonEncode($bom_f_list->grp->options(FALSE, TRUE)) ?>;
fbom_flist.lists["x_s_grp"] = <?php echo $bom_f_list->s_grp->Lookup->toClientList() ?>;
fbom_flist.lists["x_s_grp"].options = <?php echo JsonEncode($bom_f_list->s_grp->lookupOptions()) ?>;
fbom_flist.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_flist.lists["x_product"] = <?php echo $bom_f_list->product->Lookup->toClientList() ?>;
fbom_flist.lists["x_product"].options = <?php echo JsonEncode($bom_f_list->product->lookupOptions()) ?>;
fbom_flist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_flist.lists["x_rid"] = <?php echo $bom_f_list->rid->Lookup->toClientList() ?>;
fbom_flist.lists["x_rid"].options = <?php echo JsonEncode($bom_f_list->rid->lookupOptions()) ?>;
fbom_flist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_flist.lists["x_material_group"] = <?php echo $bom_f_list->material_group->Lookup->toClientList() ?>;
fbom_flist.lists["x_material_group"].options = <?php echo JsonEncode($bom_f_list->material_group->lookupOptions()) ?>;
fbom_flist.lists["x_material"] = <?php echo $bom_f_list->material->Lookup->toClientList() ?>;
fbom_flist.lists["x_material"].options = <?php echo JsonEncode($bom_f_list->material->lookupOptions()) ?>;
fbom_flist.lists["x_material_id"] = <?php echo $bom_f_list->material_id->Lookup->toClientList() ?>;
fbom_flist.lists["x_material_id"].options = <?php echo JsonEncode($bom_f_list->material_id->lookupOptions()) ?>;
fbom_flist.lists["x_method"] = <?php echo $bom_f_list->method->Lookup->toClientList() ?>;
fbom_flist.lists["x_method"].options = <?php echo JsonEncode($bom_f_list->method->lookupOptions()) ?>;
fbom_flist.lists["x_unit"] = <?php echo $bom_f_list->unit->Lookup->toClientList() ?>;
fbom_flist.lists["x_unit"].options = <?php echo JsonEncode($bom_f_list->unit->lookupOptions()) ?>;
fbom_flist.lists["x_operator"] = <?php echo $bom_f_list->operator->Lookup->toClientList() ?>;
fbom_flist.lists["x_operator"].options = <?php echo JsonEncode($bom_f_list->operator->lookupOptions()) ?>;
fbom_flist.lists["x_a_operator"] = <?php echo $bom_f_list->a_operator->Lookup->toClientList() ?>;
fbom_flist.lists["x_a_operator"].options = <?php echo JsonEncode($bom_f_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fbom_flistsrch = currentSearchForm = new ew.Form("fbom_flistsrch");

// Validate function for search
fbom_flistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_f->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_f->batch_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbom_flistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbom_flistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbom_flistsrch.lists["x_grp"] = <?php echo $bom_f_list->grp->Lookup->toClientList() ?>;
fbom_flistsrch.lists["x_grp"].options = <?php echo JsonEncode($bom_f_list->grp->options(FALSE, TRUE)) ?>;
fbom_flistsrch.lists["x_product"] = <?php echo $bom_f_list->product->Lookup->toClientList() ?>;
fbom_flistsrch.lists["x_product"].options = <?php echo JsonEncode($bom_f_list->product->lookupOptions()) ?>;
fbom_flistsrch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_flistsrch.lists["x_method"] = <?php echo $bom_f_list->method->Lookup->toClientList() ?>;
fbom_flistsrch.lists["x_method"].options = <?php echo JsonEncode($bom_f_list->method->lookupOptions()) ?>;

// Filters
fbom_flistsrch.filterList = <?php echo $bom_f_list->getFilterList() ?>;

// Init search panel as collapsed
fbom_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bom_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($bom_f_list->TotalRecs > 0 && $bom_f_list->ExportOptions->visible()) { ?>
<?php $bom_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($bom_f_list->ImportOptions->visible()) { ?>
<?php $bom_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($bom_f_list->SearchOptions->visible()) { ?>
<?php $bom_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($bom_f_list->FilterOptions->visible()) { ?>
<?php $bom_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$bom_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$bom_f->isExport() && !$bom_f->CurrentAction) { ?>
<form name="fbom_flistsrch" id="fbom_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($bom_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbom_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bom_f">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$bom_f_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$bom_f->RowType = ROWTYPE_SEARCH;

// Render row
$bom_f->resetAttributes();
$bom_f_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($bom_f->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $bom_f->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_grp" data-value-separator="<?php echo $bom_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $bom_f->grp->editAttributes() ?>>
		<?php echo $bom_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($bom_f->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $bom_f->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$bom_f->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($bom_f->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>"<?php echo $bom_f->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_product" data-value-separator="<?php echo $bom_f->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($bom_f->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flistsrch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $bom_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($bom_f->batch_no->Visible) { // batch_no ?>
	<div id="xsc_batch_no" class="ew-cell form-group">
		<label for="x_batch_no" class="ew-search-caption ew-label"><?php echo $bom_f->batch_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="bom_f" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_f->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_f->batch_no->EditValue ?>"<?php echo $bom_f->batch_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($bom_f->method->Visible) { // method ?>
	<div id="xsc_method" class="ew-cell form-group">
		<label for="x_method" class="ew-search-caption ew-label"><?php echo $bom_f->method->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_method" data-value-separator="<?php echo $bom_f->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $bom_f->method->editAttributes() ?>>
		<?php echo $bom_f->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $bom_f->method->Lookup->getParamTag("p_x_method") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($bom_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($bom_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $bom_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($bom_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($bom_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($bom_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($bom_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bom_f_list->showPageHeader(); ?>
<?php
$bom_f_list->showMessage();
?>
<?php if ($bom_f_list->TotalRecs > 0 || $bom_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($bom_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> bom_f">
<?php if (!$bom_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$bom_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bom_f_list->Pager)) $bom_f_list->Pager = new PrevNextPager($bom_f_list->StartRec, $bom_f_list->DisplayRecs, $bom_f_list->TotalRecs, $bom_f_list->AutoHidePager) ?>
<?php if ($bom_f_list->Pager->RecordCount > 0 && $bom_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bom_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bom_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bom_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bom_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bom_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bom_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bom_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bom_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bom_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bom_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bom_f_list->TotalRecs > 0 && (!$bom_f_list->AutoHidePageSizeSelector || $bom_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bom_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bom_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bom_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bom_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bom_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bom_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bom_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bom_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbom_flist" id="fbom_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bom_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bom_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bom_f">
<div id="gmp_bom_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($bom_f_list->TotalRecs > 0 || $bom_f->isGridEdit()) { ?>
<table id="tbl_bom_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$bom_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$bom_f_list->renderListOptions();

// Render list options (header, left)
$bom_f_list->ListOptions->render("header", "left");
?>
<?php if ($bom_f->id->Visible) { // id ?>
	<?php if ($bom_f->sortUrl($bom_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $bom_f->id->headerCellClass() ?>"><div id="elh_bom_f_id" class="bom_f_id"><div class="ew-table-header-caption"><?php echo $bom_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $bom_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->id) ?>',2);"><div id="elh_bom_f_id" class="bom_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->grp->Visible) { // grp ?>
	<?php if ($bom_f->sortUrl($bom_f->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $bom_f->grp->headerCellClass() ?>"><div id="elh_bom_f_grp" class="bom_f_grp"><div class="ew-table-header-caption"><?php echo $bom_f->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $bom_f->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->grp) ?>',2);"><div id="elh_bom_f_grp" class="bom_f_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->s_grp->Visible) { // s_grp ?>
	<?php if ($bom_f->sortUrl($bom_f->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $bom_f->s_grp->headerCellClass() ?>"><div id="elh_bom_f_s_grp" class="bom_f_s_grp"><div class="ew-table-header-caption"><?php echo $bom_f->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $bom_f->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->s_grp) ?>',2);"><div id="elh_bom_f_s_grp" class="bom_f_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->product->Visible) { // product ?>
	<?php if ($bom_f->sortUrl($bom_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $bom_f->product->headerCellClass() ?>"><div id="elh_bom_f_product" class="bom_f_product"><div class="ew-table-header-caption"><?php echo $bom_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $bom_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->product) ?>',2);"><div id="elh_bom_f_product" class="bom_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->rid->Visible) { // rid ?>
	<?php if ($bom_f->sortUrl($bom_f->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $bom_f->rid->headerCellClass() ?>"><div id="elh_bom_f_rid" class="bom_f_rid"><div class="ew-table-header-caption"><?php echo $bom_f->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $bom_f->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->rid) ?>',2);"><div id="elh_bom_f_rid" class="bom_f_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->batch_no->Visible) { // batch_no ?>
	<?php if ($bom_f->sortUrl($bom_f->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $bom_f->batch_no->headerCellClass() ?>"><div id="elh_bom_f_batch_no" class="bom_f_batch_no"><div class="ew-table-header-caption"><?php echo $bom_f->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $bom_f->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->batch_no) ?>',2);"><div id="elh_bom_f_batch_no" class="bom_f_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_f->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->material_group->Visible) { // material_group ?>
	<?php if ($bom_f->sortUrl($bom_f->material_group) == "") { ?>
		<th data-name="material_group" class="<?php echo $bom_f->material_group->headerCellClass() ?>"><div id="elh_bom_f_material_group" class="bom_f_material_group"><div class="ew-table-header-caption"><?php echo $bom_f->material_group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_group" class="<?php echo $bom_f->material_group->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->material_group) ?>',2);"><div id="elh_bom_f_material_group" class="bom_f_material_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->material_group->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->material_group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->material_group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->material->Visible) { // material ?>
	<?php if ($bom_f->sortUrl($bom_f->material) == "") { ?>
		<th data-name="material" class="<?php echo $bom_f->material->headerCellClass() ?>"><div id="elh_bom_f_material" class="bom_f_material"><div class="ew-table-header-caption"><?php echo $bom_f->material->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material" class="<?php echo $bom_f->material->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->material) ?>',2);"><div id="elh_bom_f_material" class="bom_f_material">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->material->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->material->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->material->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->material_id->Visible) { // material_id ?>
	<?php if ($bom_f->sortUrl($bom_f->material_id) == "") { ?>
		<th data-name="material_id" class="<?php echo $bom_f->material_id->headerCellClass() ?>"><div id="elh_bom_f_material_id" class="bom_f_material_id"><div class="ew-table-header-caption"><?php echo $bom_f->material_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_id" class="<?php echo $bom_f->material_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->material_id) ?>',2);"><div id="elh_bom_f_material_id" class="bom_f_material_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->material_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->material_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->material_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->quantity->Visible) { // quantity ?>
	<?php if ($bom_f->sortUrl($bom_f->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $bom_f->quantity->headerCellClass() ?>"><div id="elh_bom_f_quantity" class="bom_f_quantity"><div class="ew-table-header-caption"><?php echo $bom_f->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $bom_f->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->quantity) ?>',2);"><div id="elh_bom_f_quantity" class="bom_f_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_f->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->method->Visible) { // method ?>
	<?php if ($bom_f->sortUrl($bom_f->method) == "") { ?>
		<th data-name="method" class="<?php echo $bom_f->method->headerCellClass() ?>"><div id="elh_bom_f_method" class="bom_f_method"><div class="ew-table-header-caption"><?php echo $bom_f->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $bom_f->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->method) ?>',2);"><div id="elh_bom_f_method" class="bom_f_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->unit->Visible) { // unit ?>
	<?php if ($bom_f->sortUrl($bom_f->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $bom_f->unit->headerCellClass() ?>"><div id="elh_bom_f_unit" class="bom_f_unit"><div class="ew-table-header-caption"><?php echo $bom_f->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $bom_f->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->unit) ?>',2);"><div id="elh_bom_f_unit" class="bom_f_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->operator->Visible) { // operator ?>
	<?php if ($bom_f->sortUrl($bom_f->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $bom_f->operator->headerCellClass() ?>"><div id="elh_bom_f_operator" class="bom_f_operator"><div class="ew-table-header-caption"><?php echo $bom_f->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $bom_f->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->operator) ?>',2);"><div id="elh_bom_f_operator" class="bom_f_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->datetime->Visible) { // datetime ?>
	<?php if ($bom_f->sortUrl($bom_f->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $bom_f->datetime->headerCellClass() ?>"><div id="elh_bom_f_datetime" class="bom_f_datetime"><div class="ew-table-header-caption"><?php echo $bom_f->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $bom_f->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->datetime) ?>',2);"><div id="elh_bom_f_datetime" class="bom_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_f->a_operator->Visible) { // a_operator ?>
	<?php if ($bom_f->sortUrl($bom_f->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $bom_f->a_operator->headerCellClass() ?>"><div id="elh_bom_f_a_operator" class="bom_f_a_operator"><div class="ew-table-header-caption"><?php echo $bom_f->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $bom_f->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_f->SortUrl($bom_f->a_operator) ?>',2);"><div id="elh_bom_f_a_operator" class="bom_f_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_f->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_f->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_f->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bom_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bom_f->ExportAll && $bom_f->isExport()) {
	$bom_f_list->StopRec = $bom_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bom_f_list->TotalRecs > $bom_f_list->StartRec + $bom_f_list->DisplayRecs - 1)
		$bom_f_list->StopRec = $bom_f_list->StartRec + $bom_f_list->DisplayRecs - 1;
	else
		$bom_f_list->StopRec = $bom_f_list->TotalRecs;
}

// Restore number of post back records
if ($CurrentForm && $bom_f_list->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($bom_f_list->FormKeyCountName) && ($bom_f->isGridAdd() || $bom_f->isGridEdit() || $bom_f->isConfirm())) {
		$bom_f_list->KeyCount = $CurrentForm->getValue($bom_f_list->FormKeyCountName);
		$bom_f_list->StopRec = $bom_f_list->StartRec + $bom_f_list->KeyCount - 1;
	}
}
$bom_f_list->RecCnt = $bom_f_list->StartRec - 1;
if ($bom_f_list->Recordset && !$bom_f_list->Recordset->EOF) {
	$bom_f_list->Recordset->moveFirst();
	$selectLimit = $bom_f_list->UseSelectLimit;
	if (!$selectLimit && $bom_f_list->StartRec > 1)
		$bom_f_list->Recordset->move($bom_f_list->StartRec - 1);
} elseif (!$bom_f->AllowAddDeleteRow && $bom_f_list->StopRec == 0) {
	$bom_f_list->StopRec = $bom_f->GridAddRowCount;
}

// Initialize aggregate
$bom_f->RowType = ROWTYPE_AGGREGATEINIT;
$bom_f->resetAttributes();
$bom_f_list->renderRow();
if ($bom_f->isGridAdd())
	$bom_f_list->RowIndex = 0;
if ($bom_f->isGridEdit())
	$bom_f_list->RowIndex = 0;
while ($bom_f_list->RecCnt < $bom_f_list->StopRec) {
	$bom_f_list->RecCnt++;
	if ($bom_f_list->RecCnt >= $bom_f_list->StartRec) {
		$bom_f_list->RowCnt++;
		if ($bom_f->isGridAdd() || $bom_f->isGridEdit() || $bom_f->isConfirm()) {
			$bom_f_list->RowIndex++;
			$CurrentForm->Index = $bom_f_list->RowIndex;
			if ($CurrentForm->hasValue($bom_f_list->FormActionName) && $bom_f_list->EventCancelled)
				$bom_f_list->RowAction = strval($CurrentForm->getValue($bom_f_list->FormActionName));
			elseif ($bom_f->isGridAdd())
				$bom_f_list->RowAction = "insert";
			else
				$bom_f_list->RowAction = "";
		}

		// Set up key count
		$bom_f_list->KeyCount = $bom_f_list->RowIndex;

		// Init row class and style
		$bom_f->resetAttributes();
		$bom_f->CssClass = "";
		if ($bom_f->isGridAdd()) {
			$bom_f_list->loadRowValues(); // Load default values
		} else {
			$bom_f_list->loadRowValues($bom_f_list->Recordset); // Load row values
		}
		$bom_f->RowType = ROWTYPE_VIEW; // Render view
		if ($bom_f->isGridAdd()) // Grid add
			$bom_f->RowType = ROWTYPE_ADD; // Render add
		if ($bom_f->isGridAdd() && $bom_f->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$bom_f_list->restoreCurrentRowFormValues($bom_f_list->RowIndex); // Restore form values
		if ($bom_f->isGridEdit()) { // Grid edit
			if ($bom_f->EventCancelled)
				$bom_f_list->restoreCurrentRowFormValues($bom_f_list->RowIndex); // Restore form values
			if ($bom_f_list->RowAction == "insert")
				$bom_f->RowType = ROWTYPE_ADD; // Render add
			else
				$bom_f->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($bom_f->isGridEdit() && ($bom_f->RowType == ROWTYPE_EDIT || $bom_f->RowType == ROWTYPE_ADD) && $bom_f->EventCancelled) // Update failed
			$bom_f_list->restoreCurrentRowFormValues($bom_f_list->RowIndex); // Restore form values
		if ($bom_f->RowType == ROWTYPE_EDIT) // Edit row
			$bom_f_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$bom_f->RowAttrs = array_merge($bom_f->RowAttrs, array('data-rowindex'=>$bom_f_list->RowCnt, 'id'=>'r' . $bom_f_list->RowCnt . '_bom_f', 'data-rowtype'=>$bom_f->RowType));

		// Render row
		$bom_f_list->renderRow();

		// Render list options
		$bom_f_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($bom_f_list->RowAction <> "delete" && $bom_f_list->RowAction <> "insertdelete" && !($bom_f_list->RowAction == "insert" && $bom_f->isConfirm() && $bom_f_list->emptyRow())) {
?>
	<tr<?php echo $bom_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bom_f_list->ListOptions->render("body", "left", $bom_f_list->RowCnt);
?>
	<?php if ($bom_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $bom_f->id->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="bom_f" data-field="x_id" name="o<?php echo $bom_f_list->RowIndex ?>_id" id="o<?php echo $bom_f_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bom_f->id->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_id" class="form-group bom_f_id">
<span<?php echo $bom_f->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bom_f->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bom_f" data-field="x_id" name="x<?php echo $bom_f_list->RowIndex ?>_id" id="x<?php echo $bom_f_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bom_f->id->CurrentValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_id" class="bom_f_id">
<span<?php echo $bom_f->id->viewAttributes() ?>>
<?php echo $bom_f->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $bom_f->grp->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_grp" class="form-group bom_f_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_grp" data-value-separator="<?php echo $bom_f->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_grp" name="x<?php echo $bom_f_list->RowIndex ?>_grp"<?php echo $bom_f->grp->editAttributes() ?>>
		<?php echo $bom_f->grp->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_grp") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="bom_f" data-field="x_grp" name="o<?php echo $bom_f_list->RowIndex ?>_grp" id="o<?php echo $bom_f_list->RowIndex ?>_grp" value="<?php echo HtmlEncode($bom_f->grp->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_grp" class="form-group bom_f_grp">
<span<?php echo $bom_f->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bom_f->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bom_f" data-field="x_grp" name="x<?php echo $bom_f_list->RowIndex ?>_grp" id="x<?php echo $bom_f_list->RowIndex ?>_grp" value="<?php echo HtmlEncode($bom_f->grp->CurrentValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_grp" class="bom_f_grp">
<span<?php echo $bom_f->grp->viewAttributes() ?>>
<?php echo $bom_f->grp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $bom_f->s_grp->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_s_grp" class="form-group bom_f_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_f->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_s_grp" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_s_grp" id="sv_x<?php echo $bom_f_list->RowIndex ?>_s_grp" value="<?php echo RemoveHtml($bom_f->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->s_grp->getPlaceHolder()) ?>"<?php echo $bom_f->s_grp->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_s_grp" data-value-separator="<?php echo $bom_f->s_grp->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_s_grp" id="x<?php echo $bom_f_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_f->s_grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_s_grp","forceSelect":false});
</script>
<?php echo $bom_f->s_grp->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_s_grp") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_s_grp" name="o<?php echo $bom_f_list->RowIndex ?>_s_grp" id="o<?php echo $bom_f_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_f->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_s_grp" class="form-group bom_f_s_grp">
<span<?php echo $bom_f->s_grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bom_f->s_grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bom_f" data-field="x_s_grp" name="x<?php echo $bom_f_list->RowIndex ?>_s_grp" id="x<?php echo $bom_f_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_f->s_grp->CurrentValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_s_grp" class="bom_f_s_grp">
<span<?php echo $bom_f->s_grp->viewAttributes() ?>>
<?php echo $bom_f->s_grp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $bom_f->product->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_product" class="form-group bom_f_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_f->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->product->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_product" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_product" id="sv_x<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo RemoveHtml($bom_f->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>"<?php echo $bom_f->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_product" data-value-separator="<?php echo $bom_f->product->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_product" id="x<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_f->product->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_product","forceSelect":false});
</script>
<?php echo $bom_f->product->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_product" name="o<?php echo $bom_f_list->RowIndex ?>_product" id="o<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_f->product->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_product" class="form-group bom_f_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_f->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->product->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_product" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_product" id="sv_x<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo RemoveHtml($bom_f->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>"<?php echo $bom_f->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_product" data-value-separator="<?php echo $bom_f->product->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_product" id="x<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_f->product->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_product","forceSelect":false});
</script>
<?php echo $bom_f->product->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_product") ?>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_product" class="bom_f_product">
<span<?php echo $bom_f->product->viewAttributes() ?>>
<?php echo $bom_f->product->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $bom_f->rid->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_rid" class="form-group bom_f_rid">
<?php
$wrkonchange = "" . trim(@$bom_f->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_rid" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_rid" id="sv_x<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo RemoveHtml($bom_f->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->rid->getPlaceHolder()) ?>"<?php echo $bom_f->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_rid" data-value-separator="<?php echo $bom_f->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_rid" id="x<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_f->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_rid","forceSelect":false});
</script>
<?php echo $bom_f->rid->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_rid" name="o<?php echo $bom_f_list->RowIndex ?>_rid" id="o<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_f->rid->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_rid" class="form-group bom_f_rid">
<?php
$wrkonchange = "" . trim(@$bom_f->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_rid" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_rid" id="sv_x<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo RemoveHtml($bom_f->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->rid->getPlaceHolder()) ?>"<?php echo $bom_f->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_rid" data-value-separator="<?php echo $bom_f->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_rid" id="x<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_f->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_rid","forceSelect":false});
</script>
<?php echo $bom_f->rid->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_rid") ?>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_rid" class="bom_f_rid">
<span<?php echo $bom_f->rid->viewAttributes() ?>>
<?php echo $bom_f->rid->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $bom_f->batch_no->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_batch_no" class="form-group bom_f_batch_no">
<input type="text" data-table="bom_f" data-field="x_batch_no" name="x<?php echo $bom_f_list->RowIndex ?>_batch_no" id="x<?php echo $bom_f_list->RowIndex ?>_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_f->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_f->batch_no->EditValue ?>"<?php echo $bom_f->batch_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_batch_no" name="o<?php echo $bom_f_list->RowIndex ?>_batch_no" id="o<?php echo $bom_f_list->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($bom_f->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_batch_no" class="form-group bom_f_batch_no">
<input type="text" data-table="bom_f" data-field="x_batch_no" name="x<?php echo $bom_f_list->RowIndex ?>_batch_no" id="x<?php echo $bom_f_list->RowIndex ?>_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_f->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_f->batch_no->EditValue ?>"<?php echo $bom_f->batch_no->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_batch_no" class="bom_f_batch_no">
<span<?php echo $bom_f->batch_no->viewAttributes() ?>>
<?php echo $bom_f->batch_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->material_group->Visible) { // material_group ?>
		<td data-name="material_group"<?php echo $bom_f->material_group->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material_group" class="form-group bom_f_material_group">
<?php $bom_f->material_group->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_f->material_group->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material_group" data-value-separator="<?php echo $bom_f->material_group->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material_group" name="x<?php echo $bom_f_list->RowIndex ?>_material_group"<?php echo $bom_f->material_group->editAttributes() ?>>
		<?php echo $bom_f->material_group->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material_group") ?>
	</select>
</div>
<?php echo $bom_f->material_group->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material_group") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_material_group" name="o<?php echo $bom_f_list->RowIndex ?>_material_group" id="o<?php echo $bom_f_list->RowIndex ?>_material_group" value="<?php echo HtmlEncode($bom_f->material_group->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material_group" class="form-group bom_f_material_group">
<?php $bom_f->material_group->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_f->material_group->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material_group" data-value-separator="<?php echo $bom_f->material_group->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material_group" name="x<?php echo $bom_f_list->RowIndex ?>_material_group"<?php echo $bom_f->material_group->editAttributes() ?>>
		<?php echo $bom_f->material_group->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material_group") ?>
	</select>
</div>
<?php echo $bom_f->material_group->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material_group") ?>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material_group" class="bom_f_material_group">
<span<?php echo $bom_f->material_group->viewAttributes() ?>>
<?php echo $bom_f->material_group->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->material->Visible) { // material ?>
		<td data-name="material"<?php echo $bom_f->material->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material" class="form-group bom_f_material">
<?php $bom_f->material->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_f->material->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material" data-value-separator="<?php echo $bom_f->material->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material" name="x<?php echo $bom_f_list->RowIndex ?>_material"<?php echo $bom_f->material->editAttributes() ?>>
		<?php echo $bom_f->material->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material") ?>
	</select>
</div>
<?php echo $bom_f->material->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_material" name="o<?php echo $bom_f_list->RowIndex ?>_material" id="o<?php echo $bom_f_list->RowIndex ?>_material" value="<?php echo HtmlEncode($bom_f->material->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material" class="form-group bom_f_material">
<?php $bom_f->material->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_f->material->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material" data-value-separator="<?php echo $bom_f->material->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material" name="x<?php echo $bom_f_list->RowIndex ?>_material"<?php echo $bom_f->material->editAttributes() ?>>
		<?php echo $bom_f->material->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material") ?>
	</select>
</div>
<?php echo $bom_f->material->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material") ?>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material" class="bom_f_material">
<span<?php echo $bom_f->material->viewAttributes() ?>>
<?php echo $bom_f->material->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->material_id->Visible) { // material_id ?>
		<td data-name="material_id"<?php echo $bom_f->material_id->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material_id" class="form-group bom_f_material_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material_id" data-value-separator="<?php echo $bom_f->material_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material_id" name="x<?php echo $bom_f_list->RowIndex ?>_material_id"<?php echo $bom_f->material_id->editAttributes() ?>>
		<?php echo $bom_f->material_id->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material_id") ?>
	</select>
</div>
<?php echo $bom_f->material_id->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material_id") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_material_id" name="o<?php echo $bom_f_list->RowIndex ?>_material_id" id="o<?php echo $bom_f_list->RowIndex ?>_material_id" value="<?php echo HtmlEncode($bom_f->material_id->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material_id" class="form-group bom_f_material_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material_id" data-value-separator="<?php echo $bom_f->material_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material_id" name="x<?php echo $bom_f_list->RowIndex ?>_material_id"<?php echo $bom_f->material_id->editAttributes() ?>>
		<?php echo $bom_f->material_id->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material_id") ?>
	</select>
</div>
<?php echo $bom_f->material_id->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material_id") ?>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_material_id" class="bom_f_material_id">
<span<?php echo $bom_f->material_id->viewAttributes() ?>>
<?php echo $bom_f->material_id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $bom_f->quantity->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_quantity" class="form-group bom_f_quantity">
<input type="text" data-table="bom_f" data-field="x_quantity" name="x<?php echo $bom_f_list->RowIndex ?>_quantity" id="x<?php echo $bom_f_list->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_f->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_f->quantity->EditValue ?>"<?php echo $bom_f->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_quantity" name="o<?php echo $bom_f_list->RowIndex ?>_quantity" id="o<?php echo $bom_f_list->RowIndex ?>_quantity" value="<?php echo HtmlEncode($bom_f->quantity->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_quantity" class="form-group bom_f_quantity">
<input type="text" data-table="bom_f" data-field="x_quantity" name="x<?php echo $bom_f_list->RowIndex ?>_quantity" id="x<?php echo $bom_f_list->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_f->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_f->quantity->EditValue ?>"<?php echo $bom_f->quantity->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_quantity" class="bom_f_quantity">
<span<?php echo $bom_f->quantity->viewAttributes() ?>>
<?php echo $bom_f->quantity->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->method->Visible) { // method ?>
		<td data-name="method"<?php echo $bom_f->method->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_method" class="form-group bom_f_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_method" data-value-separator="<?php echo $bom_f->method->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_method" name="x<?php echo $bom_f_list->RowIndex ?>_method"<?php echo $bom_f->method->editAttributes() ?>>
		<?php echo $bom_f->method->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_method") ?>
	</select>
</div>
<?php echo $bom_f->method->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_method") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_method" name="o<?php echo $bom_f_list->RowIndex ?>_method" id="o<?php echo $bom_f_list->RowIndex ?>_method" value="<?php echo HtmlEncode($bom_f->method->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_method" class="form-group bom_f_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_method" data-value-separator="<?php echo $bom_f->method->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_method" name="x<?php echo $bom_f_list->RowIndex ?>_method"<?php echo $bom_f->method->editAttributes() ?>>
		<?php echo $bom_f->method->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_method") ?>
	</select>
</div>
<?php echo $bom_f->method->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_method") ?>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_method" class="bom_f_method">
<span<?php echo $bom_f->method->viewAttributes() ?>>
<?php echo $bom_f->method->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $bom_f->unit->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_unit" class="form-group bom_f_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_unit" data-value-separator="<?php echo $bom_f->unit->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_unit" name="x<?php echo $bom_f_list->RowIndex ?>_unit"<?php echo $bom_f->unit->editAttributes() ?>>
		<?php echo $bom_f->unit->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_unit") ?>
	</select>
</div>
<?php echo $bom_f->unit->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_unit") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_unit" name="o<?php echo $bom_f_list->RowIndex ?>_unit" id="o<?php echo $bom_f_list->RowIndex ?>_unit" value="<?php echo HtmlEncode($bom_f->unit->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_unit" class="form-group bom_f_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_unit" data-value-separator="<?php echo $bom_f->unit->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_unit" name="x<?php echo $bom_f_list->RowIndex ?>_unit"<?php echo $bom_f->unit->editAttributes() ?>>
		<?php echo $bom_f->unit->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_unit") ?>
	</select>
</div>
<?php echo $bom_f->unit->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_unit") ?>
</span>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_unit" class="bom_f_unit">
<span<?php echo $bom_f->unit->viewAttributes() ?>>
<?php echo $bom_f->unit->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $bom_f->operator->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="bom_f" data-field="x_operator" name="o<?php echo $bom_f_list->RowIndex ?>_operator" id="o<?php echo $bom_f_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($bom_f->operator->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_operator" class="bom_f_operator">
<span<?php echo $bom_f->operator->viewAttributes() ?>>
<?php echo $bom_f->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $bom_f->datetime->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="bom_f" data-field="x_datetime" name="o<?php echo $bom_f_list->RowIndex ?>_datetime" id="o<?php echo $bom_f_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($bom_f->datetime->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_datetime" class="bom_f_datetime">
<span<?php echo $bom_f->datetime->viewAttributes() ?>>
<?php echo $bom_f->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_f->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $bom_f->a_operator->cellAttributes() ?>>
<?php if ($bom_f->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_a_operator" class="form-group bom_f_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_a_operator" data-value-separator="<?php echo $bom_f->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_a_operator" name="x<?php echo $bom_f_list->RowIndex ?>_a_operator"<?php echo $bom_f->a_operator->editAttributes() ?>>
		<?php echo $bom_f->a_operator->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $bom_f->a_operator->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_a_operator") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_a_operator" name="o<?php echo $bom_f_list->RowIndex ?>_a_operator" id="o<?php echo $bom_f_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($bom_f->a_operator->OldValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_a_operator" class="form-group bom_f_a_operator">
<span<?php echo $bom_f->a_operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bom_f->a_operator->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bom_f" data-field="x_a_operator" name="x<?php echo $bom_f_list->RowIndex ?>_a_operator" id="x<?php echo $bom_f_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($bom_f->a_operator->CurrentValue) ?>">
<?php } ?>
<?php if ($bom_f->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_f_list->RowCnt ?>_bom_f_a_operator" class="bom_f_a_operator">
<span<?php echo $bom_f->a_operator->viewAttributes() ?>>
<?php echo $bom_f->a_operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bom_f_list->ListOptions->render("body", "right", $bom_f_list->RowCnt);
?>
	</tr>
<?php if ($bom_f->RowType == ROWTYPE_ADD || $bom_f->RowType == ROWTYPE_EDIT) { ?>
<script>
fbom_flist.updateLists(<?php echo $bom_f_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$bom_f->isGridAdd())
		if (!$bom_f_list->Recordset->EOF)
			$bom_f_list->Recordset->moveNext();
}
?>
<?php
	if ($bom_f->isGridAdd() || $bom_f->isGridEdit()) {
		$bom_f_list->RowIndex = '$rowindex$';
		$bom_f_list->loadRowValues();

		// Set row properties
		$bom_f->resetAttributes();
		$bom_f->RowAttrs = array_merge($bom_f->RowAttrs, array('data-rowindex'=>$bom_f_list->RowIndex, 'id'=>'r0_bom_f', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($bom_f->RowAttrs["class"], "ew-template");
		$bom_f->RowType = ROWTYPE_ADD;

		// Render row
		$bom_f_list->renderRow();

		// Render list options
		$bom_f_list->renderListOptions();
		$bom_f_list->StartRowCnt = 0;
?>
	<tr<?php echo $bom_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bom_f_list->ListOptions->render("body", "left", $bom_f_list->RowIndex);
?>
	<?php if ($bom_f->id->Visible) { // id ?>
		<td data-name="id">
<input type="hidden" data-table="bom_f" data-field="x_id" name="o<?php echo $bom_f_list->RowIndex ?>_id" id="o<?php echo $bom_f_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bom_f->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->grp->Visible) { // grp ?>
		<td data-name="grp">
<span id="el$rowindex$_bom_f_grp" class="form-group bom_f_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_grp" data-value-separator="<?php echo $bom_f->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_grp" name="x<?php echo $bom_f_list->RowIndex ?>_grp"<?php echo $bom_f->grp->editAttributes() ?>>
		<?php echo $bom_f->grp->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_grp") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="bom_f" data-field="x_grp" name="o<?php echo $bom_f_list->RowIndex ?>_grp" id="o<?php echo $bom_f_list->RowIndex ?>_grp" value="<?php echo HtmlEncode($bom_f->grp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp">
<span id="el$rowindex$_bom_f_s_grp" class="form-group bom_f_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_f->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_s_grp" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_s_grp" id="sv_x<?php echo $bom_f_list->RowIndex ?>_s_grp" value="<?php echo RemoveHtml($bom_f->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->s_grp->getPlaceHolder()) ?>"<?php echo $bom_f->s_grp->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_s_grp" data-value-separator="<?php echo $bom_f->s_grp->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_s_grp" id="x<?php echo $bom_f_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_f->s_grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_s_grp","forceSelect":false});
</script>
<?php echo $bom_f->s_grp->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_s_grp") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_s_grp" name="o<?php echo $bom_f_list->RowIndex ?>_s_grp" id="o<?php echo $bom_f_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_f->s_grp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->product->Visible) { // product ?>
		<td data-name="product">
<span id="el$rowindex$_bom_f_product" class="form-group bom_f_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_f->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->product->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_product" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_product" id="sv_x<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo RemoveHtml($bom_f->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->product->getPlaceHolder()) ?>"<?php echo $bom_f->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_product" data-value-separator="<?php echo $bom_f->product->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_product" id="x<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_f->product->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_product","forceSelect":false});
</script>
<?php echo $bom_f->product->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_product" name="o<?php echo $bom_f_list->RowIndex ?>_product" id="o<?php echo $bom_f_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_f->product->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->rid->Visible) { // rid ?>
		<td data-name="rid">
<span id="el$rowindex$_bom_f_rid" class="form-group bom_f_rid">
<?php
$wrkonchange = "" . trim(@$bom_f->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_f->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_f_list->RowIndex ?>_rid" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_f_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_f_list->RowIndex ?>_rid" id="sv_x<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo RemoveHtml($bom_f->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_f->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_f->rid->getPlaceHolder()) ?>"<?php echo $bom_f->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_rid" data-value-separator="<?php echo $bom_f->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_f_list->RowIndex ?>_rid" id="x<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_f->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_flist.createAutoSuggest({"id":"x<?php echo $bom_f_list->RowIndex ?>_rid","forceSelect":false});
</script>
<?php echo $bom_f->rid->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_rid" name="o<?php echo $bom_f_list->RowIndex ?>_rid" id="o<?php echo $bom_f_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_f->rid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no">
<span id="el$rowindex$_bom_f_batch_no" class="form-group bom_f_batch_no">
<input type="text" data-table="bom_f" data-field="x_batch_no" name="x<?php echo $bom_f_list->RowIndex ?>_batch_no" id="x<?php echo $bom_f_list->RowIndex ?>_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_f->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_f->batch_no->EditValue ?>"<?php echo $bom_f->batch_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_batch_no" name="o<?php echo $bom_f_list->RowIndex ?>_batch_no" id="o<?php echo $bom_f_list->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($bom_f->batch_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->material_group->Visible) { // material_group ?>
		<td data-name="material_group">
<span id="el$rowindex$_bom_f_material_group" class="form-group bom_f_material_group">
<?php $bom_f->material_group->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_f->material_group->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material_group" data-value-separator="<?php echo $bom_f->material_group->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material_group" name="x<?php echo $bom_f_list->RowIndex ?>_material_group"<?php echo $bom_f->material_group->editAttributes() ?>>
		<?php echo $bom_f->material_group->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material_group") ?>
	</select>
</div>
<?php echo $bom_f->material_group->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material_group") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_material_group" name="o<?php echo $bom_f_list->RowIndex ?>_material_group" id="o<?php echo $bom_f_list->RowIndex ?>_material_group" value="<?php echo HtmlEncode($bom_f->material_group->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->material->Visible) { // material ?>
		<td data-name="material">
<span id="el$rowindex$_bom_f_material" class="form-group bom_f_material">
<?php $bom_f->material->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_f->material->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material" data-value-separator="<?php echo $bom_f->material->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material" name="x<?php echo $bom_f_list->RowIndex ?>_material"<?php echo $bom_f->material->editAttributes() ?>>
		<?php echo $bom_f->material->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material") ?>
	</select>
</div>
<?php echo $bom_f->material->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_material" name="o<?php echo $bom_f_list->RowIndex ?>_material" id="o<?php echo $bom_f_list->RowIndex ?>_material" value="<?php echo HtmlEncode($bom_f->material->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->material_id->Visible) { // material_id ?>
		<td data-name="material_id">
<span id="el$rowindex$_bom_f_material_id" class="form-group bom_f_material_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_material_id" data-value-separator="<?php echo $bom_f->material_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_material_id" name="x<?php echo $bom_f_list->RowIndex ?>_material_id"<?php echo $bom_f->material_id->editAttributes() ?>>
		<?php echo $bom_f->material_id->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_material_id") ?>
	</select>
</div>
<?php echo $bom_f->material_id->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_material_id") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_material_id" name="o<?php echo $bom_f_list->RowIndex ?>_material_id" id="o<?php echo $bom_f_list->RowIndex ?>_material_id" value="<?php echo HtmlEncode($bom_f->material_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->quantity->Visible) { // quantity ?>
		<td data-name="quantity">
<span id="el$rowindex$_bom_f_quantity" class="form-group bom_f_quantity">
<input type="text" data-table="bom_f" data-field="x_quantity" name="x<?php echo $bom_f_list->RowIndex ?>_quantity" id="x<?php echo $bom_f_list->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_f->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_f->quantity->EditValue ?>"<?php echo $bom_f->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_f" data-field="x_quantity" name="o<?php echo $bom_f_list->RowIndex ?>_quantity" id="o<?php echo $bom_f_list->RowIndex ?>_quantity" value="<?php echo HtmlEncode($bom_f->quantity->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->method->Visible) { // method ?>
		<td data-name="method">
<span id="el$rowindex$_bom_f_method" class="form-group bom_f_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_method" data-value-separator="<?php echo $bom_f->method->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_method" name="x<?php echo $bom_f_list->RowIndex ?>_method"<?php echo $bom_f->method->editAttributes() ?>>
		<?php echo $bom_f->method->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_method") ?>
	</select>
</div>
<?php echo $bom_f->method->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_method") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_method" name="o<?php echo $bom_f_list->RowIndex ?>_method" id="o<?php echo $bom_f_list->RowIndex ?>_method" value="<?php echo HtmlEncode($bom_f->method->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->unit->Visible) { // unit ?>
		<td data-name="unit">
<span id="el$rowindex$_bom_f_unit" class="form-group bom_f_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_unit" data-value-separator="<?php echo $bom_f->unit->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_unit" name="x<?php echo $bom_f_list->RowIndex ?>_unit"<?php echo $bom_f->unit->editAttributes() ?>>
		<?php echo $bom_f->unit->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_unit") ?>
	</select>
</div>
<?php echo $bom_f->unit->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_unit") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_unit" name="o<?php echo $bom_f_list->RowIndex ?>_unit" id="o<?php echo $bom_f_list->RowIndex ?>_unit" value="<?php echo HtmlEncode($bom_f->unit->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->operator->Visible) { // operator ?>
		<td data-name="operator">
<input type="hidden" data-table="bom_f" data-field="x_operator" name="o<?php echo $bom_f_list->RowIndex ?>_operator" id="o<?php echo $bom_f_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($bom_f->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<input type="hidden" data-table="bom_f" data-field="x_datetime" name="o<?php echo $bom_f_list->RowIndex ?>_datetime" id="o<?php echo $bom_f_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($bom_f->datetime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_f->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator">
<span id="el$rowindex$_bom_f_a_operator" class="form-group bom_f_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_f" data-field="x_a_operator" data-value-separator="<?php echo $bom_f->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_f_list->RowIndex ?>_a_operator" name="x<?php echo $bom_f_list->RowIndex ?>_a_operator"<?php echo $bom_f->a_operator->editAttributes() ?>>
		<?php echo $bom_f->a_operator->selectOptionListHtml("x<?php echo $bom_f_list->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $bom_f->a_operator->Lookup->getParamTag("p_x" . $bom_f_list->RowIndex . "_a_operator") ?>
</span>
<input type="hidden" data-table="bom_f" data-field="x_a_operator" name="o<?php echo $bom_f_list->RowIndex ?>_a_operator" id="o<?php echo $bom_f_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($bom_f->a_operator->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bom_f_list->ListOptions->render("body", "right", $bom_f_list->RowIndex);
?>
<script>
fbom_flist.updateLists(<?php echo $bom_f_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$bom_f->RowType = ROWTYPE_AGGREGATE;
$bom_f->resetAttributes();
$bom_f_list->renderRow();
?>
<?php if ($bom_f_list->TotalRecs > 0 && !$bom_f->isGridAdd() && !$bom_f->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$bom_f_list->renderListOptions();

// Render list options (footer, left)
$bom_f_list->ListOptions->render("footer", "left");
?>
	<?php if ($bom_f->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $bom_f->id->footerCellClass() ?>"><span id="elf_bom_f_id" class="bom_f_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $bom_f->grp->footerCellClass() ?>"><span id="elf_bom_f_grp" class="bom_f_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $bom_f->s_grp->footerCellClass() ?>"><span id="elf_bom_f_s_grp" class="bom_f_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $bom_f->product->footerCellClass() ?>"><span id="elf_bom_f_product" class="bom_f_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $bom_f->rid->footerCellClass() ?>"><span id="elf_bom_f_rid" class="bom_f_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $bom_f->batch_no->footerCellClass() ?>"><span id="elf_bom_f_batch_no" class="bom_f_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->material_group->Visible) { // material_group ?>
		<td data-name="material_group" class="<?php echo $bom_f->material_group->footerCellClass() ?>"><span id="elf_bom_f_material_group" class="bom_f_material_group">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->material->Visible) { // material ?>
		<td data-name="material" class="<?php echo $bom_f->material->footerCellClass() ?>"><span id="elf_bom_f_material" class="bom_f_material">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->material_id->Visible) { // material_id ?>
		<td data-name="material_id" class="<?php echo $bom_f->material_id->footerCellClass() ?>"><span id="elf_bom_f_material_id" class="bom_f_material_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $bom_f->quantity->footerCellClass() ?>"><span id="elf_bom_f_quantity" class="bom_f_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $bom_f->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($bom_f->method->Visible) { // method ?>
		<td data-name="method" class="<?php echo $bom_f->method->footerCellClass() ?>"><span id="elf_bom_f_method" class="bom_f_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $bom_f->unit->footerCellClass() ?>"><span id="elf_bom_f_unit" class="bom_f_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $bom_f->operator->footerCellClass() ?>"><span id="elf_bom_f_operator" class="bom_f_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $bom_f->datetime->footerCellClass() ?>"><span id="elf_bom_f_datetime" class="bom_f_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_f->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator" class="<?php echo $bom_f->a_operator->footerCellClass() ?>"><span id="elf_bom_f_a_operator" class="bom_f_a_operator">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$bom_f_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($bom_f->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $bom_f_list->FormKeyCountName ?>" id="<?php echo $bom_f_list->FormKeyCountName ?>" value="<?php echo $bom_f_list->KeyCount ?>">
<?php echo $bom_f_list->MultiSelectKey ?>
<?php } ?>
<?php if ($bom_f->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $bom_f_list->FormKeyCountName ?>" id="<?php echo $bom_f_list->FormKeyCountName ?>" value="<?php echo $bom_f_list->KeyCount ?>">
<?php echo $bom_f_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$bom_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($bom_f_list->Recordset)
	$bom_f_list->Recordset->Close();
?>
<?php if (!$bom_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$bom_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bom_f_list->Pager)) $bom_f_list->Pager = new PrevNextPager($bom_f_list->StartRec, $bom_f_list->DisplayRecs, $bom_f_list->TotalRecs, $bom_f_list->AutoHidePager) ?>
<?php if ($bom_f_list->Pager->RecordCount > 0 && $bom_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bom_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bom_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bom_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bom_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bom_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bom_f_list->pageUrl() ?>start=<?php echo $bom_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bom_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bom_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bom_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bom_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bom_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bom_f_list->TotalRecs > 0 && (!$bom_f_list->AutoHidePageSizeSelector || $bom_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bom_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bom_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bom_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bom_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bom_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bom_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bom_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bom_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($bom_f_list->TotalRecs == 0 && !$bom_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $bom_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$bom_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bom_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$bom_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_bom_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bom_f_list->terminate();
?>