<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bom_fp_list = new bom_fp_list();

// Run the page
$bom_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bom_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bom_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbom_fplist = currentForm = new ew.Form("fbom_fplist", "list");
fbom_fplist.formKeyCountName = '<?php echo $bom_fp_list->FormKeyCountName ?>';

// Validate form
fbom_fplist.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($bom_fp_list->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->id->caption(), $bom_fp->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->grp->caption(), $bom_fp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->s_grp->caption(), $bom_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_fp->s_grp->errorMessage()) ?>");
		<?php if ($bom_fp_list->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->product->caption(), $bom_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_fp->product->errorMessage()) ?>");
		<?php if ($bom_fp_list->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->rid->caption(), $bom_fp->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->batch_no->caption(), $bom_fp->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_fp->batch_no->errorMessage()) ?>");
		<?php if ($bom_fp_list->material_group->Required) { ?>
			elm = this.getElements("x" + infix + "_material_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->material_group->caption(), $bom_fp->material_group->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->material->Required) { ?>
			elm = this.getElements("x" + infix + "_material");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->material->caption(), $bom_fp->material->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->material_id->Required) { ?>
			elm = this.getElements("x" + infix + "_material_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->material_id->caption(), $bom_fp->material_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->quantity->caption(), $bom_fp->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($bom_fp->quantity->errorMessage()) ?>");
		<?php if ($bom_fp_list->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->method->caption(), $bom_fp->method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->unit->caption(), $bom_fp->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->operator->caption(), $bom_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->datetime->caption(), $bom_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->a_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_a_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->a_operator->caption(), $bom_fp->a_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($bom_fp_list->a_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_a_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $bom_fp->a_datetime->caption(), $bom_fp->a_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	if (gridinsert && addcnt == 0) { // No row added
		ew.alert(ew.language.phrase("NoAddRecord"));
		return false;
	}
	return true;
}

// Check empty row
fbom_fplist.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "grp", false)) return false;
	if (ew.valueChanged(fobj, infix, "s_grp", false)) return false;
	if (ew.valueChanged(fobj, infix, "product", false)) return false;
	if (ew.valueChanged(fobj, infix, "rid", false)) return false;
	if (ew.valueChanged(fobj, infix, "batch_no", false)) return false;
	if (ew.valueChanged(fobj, infix, "material_group", false)) return false;
	if (ew.valueChanged(fobj, infix, "material", false)) return false;
	if (ew.valueChanged(fobj, infix, "material_id", false)) return false;
	if (ew.valueChanged(fobj, infix, "quantity", false)) return false;
	if (ew.valueChanged(fobj, infix, "method", false)) return false;
	if (ew.valueChanged(fobj, infix, "unit", false)) return false;
	if (ew.valueChanged(fobj, infix, "a_operator", false)) return false;
	if (ew.valueChanged(fobj, infix, "a_datetime", false)) return false;
	return true;
}

// Form_CustomValidate event
fbom_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbom_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbom_fplist.lists["x_grp"] = <?php echo $bom_fp_list->grp->Lookup->toClientList() ?>;
fbom_fplist.lists["x_grp"].options = <?php echo JsonEncode($bom_fp_list->grp->options(FALSE, TRUE)) ?>;
fbom_fplist.lists["x_s_grp"] = <?php echo $bom_fp_list->s_grp->Lookup->toClientList() ?>;
fbom_fplist.lists["x_s_grp"].options = <?php echo JsonEncode($bom_fp_list->s_grp->lookupOptions()) ?>;
fbom_fplist.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_fplist.lists["x_product"] = <?php echo $bom_fp_list->product->Lookup->toClientList() ?>;
fbom_fplist.lists["x_product"].options = <?php echo JsonEncode($bom_fp_list->product->lookupOptions()) ?>;
fbom_fplist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_fplist.lists["x_rid"] = <?php echo $bom_fp_list->rid->Lookup->toClientList() ?>;
fbom_fplist.lists["x_rid"].options = <?php echo JsonEncode($bom_fp_list->rid->lookupOptions()) ?>;
fbom_fplist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_fplist.lists["x_material_group"] = <?php echo $bom_fp_list->material_group->Lookup->toClientList() ?>;
fbom_fplist.lists["x_material_group"].options = <?php echo JsonEncode($bom_fp_list->material_group->lookupOptions()) ?>;
fbom_fplist.lists["x_material"] = <?php echo $bom_fp_list->material->Lookup->toClientList() ?>;
fbom_fplist.lists["x_material"].options = <?php echo JsonEncode($bom_fp_list->material->lookupOptions()) ?>;
fbom_fplist.lists["x_material_id"] = <?php echo $bom_fp_list->material_id->Lookup->toClientList() ?>;
fbom_fplist.lists["x_material_id"].options = <?php echo JsonEncode($bom_fp_list->material_id->lookupOptions()) ?>;
fbom_fplist.lists["x_method"] = <?php echo $bom_fp_list->method->Lookup->toClientList() ?>;
fbom_fplist.lists["x_method"].options = <?php echo JsonEncode($bom_fp_list->method->lookupOptions()) ?>;
fbom_fplist.lists["x_unit"] = <?php echo $bom_fp_list->unit->Lookup->toClientList() ?>;
fbom_fplist.lists["x_unit"].options = <?php echo JsonEncode($bom_fp_list->unit->lookupOptions()) ?>;
fbom_fplist.lists["x_operator"] = <?php echo $bom_fp_list->operator->Lookup->toClientList() ?>;
fbom_fplist.lists["x_operator"].options = <?php echo JsonEncode($bom_fp_list->operator->lookupOptions()) ?>;
fbom_fplist.lists["x_a_operator"] = <?php echo $bom_fp_list->a_operator->Lookup->toClientList() ?>;
fbom_fplist.lists["x_a_operator"].options = <?php echo JsonEncode($bom_fp_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fbom_fplistsrch = currentSearchForm = new ew.Form("fbom_fplistsrch");

// Validate function for search
fbom_fplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_fp->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_fp->batch_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbom_fplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbom_fplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbom_fplistsrch.lists["x_grp"] = <?php echo $bom_fp_list->grp->Lookup->toClientList() ?>;
fbom_fplistsrch.lists["x_grp"].options = <?php echo JsonEncode($bom_fp_list->grp->options(FALSE, TRUE)) ?>;
fbom_fplistsrch.lists["x_product"] = <?php echo $bom_fp_list->product->Lookup->toClientList() ?>;
fbom_fplistsrch.lists["x_product"].options = <?php echo JsonEncode($bom_fp_list->product->lookupOptions()) ?>;
fbom_fplistsrch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_fplistsrch.lists["x_method"] = <?php echo $bom_fp_list->method->Lookup->toClientList() ?>;
fbom_fplistsrch.lists["x_method"].options = <?php echo JsonEncode($bom_fp_list->method->lookupOptions()) ?>;

// Filters
fbom_fplistsrch.filterList = <?php echo $bom_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fbom_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bom_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($bom_fp_list->TotalRecs > 0 && $bom_fp_list->ExportOptions->visible()) { ?>
<?php $bom_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($bom_fp_list->ImportOptions->visible()) { ?>
<?php $bom_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($bom_fp_list->SearchOptions->visible()) { ?>
<?php $bom_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($bom_fp_list->FilterOptions->visible()) { ?>
<?php $bom_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$bom_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$bom_fp->isExport() && !$bom_fp->CurrentAction) { ?>
<form name="fbom_fplistsrch" id="fbom_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($bom_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbom_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="bom_fp">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$bom_fp_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$bom_fp->RowType = ROWTYPE_SEARCH;

// Render row
$bom_fp->resetAttributes();
$bom_fp_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($bom_fp->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $bom_fp->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_grp" data-value-separator="<?php echo $bom_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $bom_fp->grp->editAttributes() ?>>
		<?php echo $bom_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($bom_fp->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $bom_fp->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$bom_fp->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($bom_fp->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>"<?php echo $bom_fp->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_product" data-value-separator="<?php echo $bom_fp->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($bom_fp->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplistsrch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $bom_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($bom_fp->batch_no->Visible) { // batch_no ?>
	<div id="xsc_batch_no" class="ew-cell form-group">
		<label for="x_batch_no" class="ew-search-caption ew-label"><?php echo $bom_fp->batch_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="bom_fp" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_fp->batch_no->EditValue ?>"<?php echo $bom_fp->batch_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($bom_fp->method->Visible) { // method ?>
	<div id="xsc_method" class="ew-cell form-group">
		<label for="x_method" class="ew-search-caption ew-label"><?php echo $bom_fp->method->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_method" data-value-separator="<?php echo $bom_fp->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $bom_fp->method->editAttributes() ?>>
		<?php echo $bom_fp->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $bom_fp->method->Lookup->getParamTag("p_x_method") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($bom_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($bom_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $bom_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($bom_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($bom_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($bom_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($bom_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $bom_fp_list->showPageHeader(); ?>
<?php
$bom_fp_list->showMessage();
?>
<?php if ($bom_fp_list->TotalRecs > 0 || $bom_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($bom_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> bom_fp">
<?php if (!$bom_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$bom_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bom_fp_list->Pager)) $bom_fp_list->Pager = new PrevNextPager($bom_fp_list->StartRec, $bom_fp_list->DisplayRecs, $bom_fp_list->TotalRecs, $bom_fp_list->AutoHidePager) ?>
<?php if ($bom_fp_list->Pager->RecordCount > 0 && $bom_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bom_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bom_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bom_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bom_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bom_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bom_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bom_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bom_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bom_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bom_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bom_fp_list->TotalRecs > 0 && (!$bom_fp_list->AutoHidePageSizeSelector || $bom_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bom_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bom_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bom_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bom_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bom_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bom_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bom_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bom_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbom_fplist" id="fbom_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bom_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bom_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bom_fp">
<div id="gmp_bom_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($bom_fp_list->TotalRecs > 0 || $bom_fp->isGridEdit()) { ?>
<table id="tbl_bom_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$bom_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$bom_fp_list->renderListOptions();

// Render list options (header, left)
$bom_fp_list->ListOptions->render("header", "left");
?>
<?php if ($bom_fp->id->Visible) { // id ?>
	<?php if ($bom_fp->sortUrl($bom_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $bom_fp->id->headerCellClass() ?>"><div id="elh_bom_fp_id" class="bom_fp_id"><div class="ew-table-header-caption"><?php echo $bom_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $bom_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->id) ?>',2);"><div id="elh_bom_fp_id" class="bom_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->grp->Visible) { // grp ?>
	<?php if ($bom_fp->sortUrl($bom_fp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $bom_fp->grp->headerCellClass() ?>"><div id="elh_bom_fp_grp" class="bom_fp_grp"><div class="ew-table-header-caption"><?php echo $bom_fp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $bom_fp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->grp) ?>',2);"><div id="elh_bom_fp_grp" class="bom_fp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->s_grp->Visible) { // s_grp ?>
	<?php if ($bom_fp->sortUrl($bom_fp->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $bom_fp->s_grp->headerCellClass() ?>"><div id="elh_bom_fp_s_grp" class="bom_fp_s_grp"><div class="ew-table-header-caption"><?php echo $bom_fp->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $bom_fp->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->s_grp) ?>',2);"><div id="elh_bom_fp_s_grp" class="bom_fp_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->product->Visible) { // product ?>
	<?php if ($bom_fp->sortUrl($bom_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $bom_fp->product->headerCellClass() ?>"><div id="elh_bom_fp_product" class="bom_fp_product"><div class="ew-table-header-caption"><?php echo $bom_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $bom_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->product) ?>',2);"><div id="elh_bom_fp_product" class="bom_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->rid->Visible) { // rid ?>
	<?php if ($bom_fp->sortUrl($bom_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $bom_fp->rid->headerCellClass() ?>"><div id="elh_bom_fp_rid" class="bom_fp_rid"><div class="ew-table-header-caption"><?php echo $bom_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $bom_fp->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->rid) ?>',2);"><div id="elh_bom_fp_rid" class="bom_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->batch_no->Visible) { // batch_no ?>
	<?php if ($bom_fp->sortUrl($bom_fp->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $bom_fp->batch_no->headerCellClass() ?>"><div id="elh_bom_fp_batch_no" class="bom_fp_batch_no"><div class="ew-table-header-caption"><?php echo $bom_fp->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $bom_fp->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->batch_no) ?>',2);"><div id="elh_bom_fp_batch_no" class="bom_fp_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->material_group->Visible) { // material_group ?>
	<?php if ($bom_fp->sortUrl($bom_fp->material_group) == "") { ?>
		<th data-name="material_group" class="<?php echo $bom_fp->material_group->headerCellClass() ?>"><div id="elh_bom_fp_material_group" class="bom_fp_material_group"><div class="ew-table-header-caption"><?php echo $bom_fp->material_group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_group" class="<?php echo $bom_fp->material_group->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->material_group) ?>',2);"><div id="elh_bom_fp_material_group" class="bom_fp_material_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->material_group->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->material_group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->material_group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->material->Visible) { // material ?>
	<?php if ($bom_fp->sortUrl($bom_fp->material) == "") { ?>
		<th data-name="material" class="<?php echo $bom_fp->material->headerCellClass() ?>"><div id="elh_bom_fp_material" class="bom_fp_material"><div class="ew-table-header-caption"><?php echo $bom_fp->material->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material" class="<?php echo $bom_fp->material->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->material) ?>',2);"><div id="elh_bom_fp_material" class="bom_fp_material">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->material->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->material->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->material->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->material_id->Visible) { // material_id ?>
	<?php if ($bom_fp->sortUrl($bom_fp->material_id) == "") { ?>
		<th data-name="material_id" class="<?php echo $bom_fp->material_id->headerCellClass() ?>"><div id="elh_bom_fp_material_id" class="bom_fp_material_id"><div class="ew-table-header-caption"><?php echo $bom_fp->material_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_id" class="<?php echo $bom_fp->material_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->material_id) ?>',2);"><div id="elh_bom_fp_material_id" class="bom_fp_material_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->material_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->material_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->material_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->quantity->Visible) { // quantity ?>
	<?php if ($bom_fp->sortUrl($bom_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $bom_fp->quantity->headerCellClass() ?>"><div id="elh_bom_fp_quantity" class="bom_fp_quantity"><div class="ew-table-header-caption"><?php echo $bom_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $bom_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->quantity) ?>',2);"><div id="elh_bom_fp_quantity" class="bom_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->method->Visible) { // method ?>
	<?php if ($bom_fp->sortUrl($bom_fp->method) == "") { ?>
		<th data-name="method" class="<?php echo $bom_fp->method->headerCellClass() ?>"><div id="elh_bom_fp_method" class="bom_fp_method"><div class="ew-table-header-caption"><?php echo $bom_fp->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $bom_fp->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->method) ?>',2);"><div id="elh_bom_fp_method" class="bom_fp_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->unit->Visible) { // unit ?>
	<?php if ($bom_fp->sortUrl($bom_fp->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $bom_fp->unit->headerCellClass() ?>"><div id="elh_bom_fp_unit" class="bom_fp_unit"><div class="ew-table-header-caption"><?php echo $bom_fp->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $bom_fp->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->unit) ?>',2);"><div id="elh_bom_fp_unit" class="bom_fp_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->operator->Visible) { // operator ?>
	<?php if ($bom_fp->sortUrl($bom_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $bom_fp->operator->headerCellClass() ?>"><div id="elh_bom_fp_operator" class="bom_fp_operator"><div class="ew-table-header-caption"><?php echo $bom_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $bom_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->operator) ?>',2);"><div id="elh_bom_fp_operator" class="bom_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->datetime->Visible) { // datetime ?>
	<?php if ($bom_fp->sortUrl($bom_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $bom_fp->datetime->headerCellClass() ?>"><div id="elh_bom_fp_datetime" class="bom_fp_datetime"><div class="ew-table-header-caption"><?php echo $bom_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $bom_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->datetime) ?>',2);"><div id="elh_bom_fp_datetime" class="bom_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->a_operator->Visible) { // a_operator ?>
	<?php if ($bom_fp->sortUrl($bom_fp->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $bom_fp->a_operator->headerCellClass() ?>"><div id="elh_bom_fp_a_operator" class="bom_fp_a_operator"><div class="ew-table-header-caption"><?php echo $bom_fp->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $bom_fp->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->a_operator) ?>',2);"><div id="elh_bom_fp_a_operator" class="bom_fp_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom_fp->a_datetime->Visible) { // a_datetime ?>
	<?php if ($bom_fp->sortUrl($bom_fp->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $bom_fp->a_datetime->headerCellClass() ?>"><div id="elh_bom_fp_a_datetime" class="bom_fp_a_datetime"><div class="ew-table-header-caption"><?php echo $bom_fp->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $bom_fp->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $bom_fp->SortUrl($bom_fp->a_datetime) ?>',2);"><div id="elh_bom_fp_a_datetime" class="bom_fp_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom_fp->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_fp->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_fp->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bom_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($bom_fp->ExportAll && $bom_fp->isExport()) {
	$bom_fp_list->StopRec = $bom_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($bom_fp_list->TotalRecs > $bom_fp_list->StartRec + $bom_fp_list->DisplayRecs - 1)
		$bom_fp_list->StopRec = $bom_fp_list->StartRec + $bom_fp_list->DisplayRecs - 1;
	else
		$bom_fp_list->StopRec = $bom_fp_list->TotalRecs;
}

// Restore number of post back records
if ($CurrentForm && $bom_fp_list->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($bom_fp_list->FormKeyCountName) && ($bom_fp->isGridAdd() || $bom_fp->isGridEdit() || $bom_fp->isConfirm())) {
		$bom_fp_list->KeyCount = $CurrentForm->getValue($bom_fp_list->FormKeyCountName);
		$bom_fp_list->StopRec = $bom_fp_list->StartRec + $bom_fp_list->KeyCount - 1;
	}
}
$bom_fp_list->RecCnt = $bom_fp_list->StartRec - 1;
if ($bom_fp_list->Recordset && !$bom_fp_list->Recordset->EOF) {
	$bom_fp_list->Recordset->moveFirst();
	$selectLimit = $bom_fp_list->UseSelectLimit;
	if (!$selectLimit && $bom_fp_list->StartRec > 1)
		$bom_fp_list->Recordset->move($bom_fp_list->StartRec - 1);
} elseif (!$bom_fp->AllowAddDeleteRow && $bom_fp_list->StopRec == 0) {
	$bom_fp_list->StopRec = $bom_fp->GridAddRowCount;
}

// Initialize aggregate
$bom_fp->RowType = ROWTYPE_AGGREGATEINIT;
$bom_fp->resetAttributes();
$bom_fp_list->renderRow();
if ($bom_fp->isGridAdd())
	$bom_fp_list->RowIndex = 0;
if ($bom_fp->isGridEdit())
	$bom_fp_list->RowIndex = 0;
while ($bom_fp_list->RecCnt < $bom_fp_list->StopRec) {
	$bom_fp_list->RecCnt++;
	if ($bom_fp_list->RecCnt >= $bom_fp_list->StartRec) {
		$bom_fp_list->RowCnt++;
		if ($bom_fp->isGridAdd() || $bom_fp->isGridEdit() || $bom_fp->isConfirm()) {
			$bom_fp_list->RowIndex++;
			$CurrentForm->Index = $bom_fp_list->RowIndex;
			if ($CurrentForm->hasValue($bom_fp_list->FormActionName) && $bom_fp_list->EventCancelled)
				$bom_fp_list->RowAction = strval($CurrentForm->getValue($bom_fp_list->FormActionName));
			elseif ($bom_fp->isGridAdd())
				$bom_fp_list->RowAction = "insert";
			else
				$bom_fp_list->RowAction = "";
		}

		// Set up key count
		$bom_fp_list->KeyCount = $bom_fp_list->RowIndex;

		// Init row class and style
		$bom_fp->resetAttributes();
		$bom_fp->CssClass = "";
		if ($bom_fp->isGridAdd()) {
			$bom_fp_list->loadRowValues(); // Load default values
		} else {
			$bom_fp_list->loadRowValues($bom_fp_list->Recordset); // Load row values
		}
		$bom_fp->RowType = ROWTYPE_VIEW; // Render view
		if ($bom_fp->isGridAdd()) // Grid add
			$bom_fp->RowType = ROWTYPE_ADD; // Render add
		if ($bom_fp->isGridAdd() && $bom_fp->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$bom_fp_list->restoreCurrentRowFormValues($bom_fp_list->RowIndex); // Restore form values
		if ($bom_fp->isGridEdit()) { // Grid edit
			if ($bom_fp->EventCancelled)
				$bom_fp_list->restoreCurrentRowFormValues($bom_fp_list->RowIndex); // Restore form values
			if ($bom_fp_list->RowAction == "insert")
				$bom_fp->RowType = ROWTYPE_ADD; // Render add
			else
				$bom_fp->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($bom_fp->isGridEdit() && ($bom_fp->RowType == ROWTYPE_EDIT || $bom_fp->RowType == ROWTYPE_ADD) && $bom_fp->EventCancelled) // Update failed
			$bom_fp_list->restoreCurrentRowFormValues($bom_fp_list->RowIndex); // Restore form values
		if ($bom_fp->RowType == ROWTYPE_EDIT) // Edit row
			$bom_fp_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$bom_fp->RowAttrs = array_merge($bom_fp->RowAttrs, array('data-rowindex'=>$bom_fp_list->RowCnt, 'id'=>'r' . $bom_fp_list->RowCnt . '_bom_fp', 'data-rowtype'=>$bom_fp->RowType));

		// Render row
		$bom_fp_list->renderRow();

		// Render list options
		$bom_fp_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($bom_fp_list->RowAction <> "delete" && $bom_fp_list->RowAction <> "insertdelete" && !($bom_fp_list->RowAction == "insert" && $bom_fp->isConfirm() && $bom_fp_list->emptyRow())) {
?>
	<tr<?php echo $bom_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bom_fp_list->ListOptions->render("body", "left", $bom_fp_list->RowCnt);
?>
	<?php if ($bom_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $bom_fp->id->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="bom_fp" data-field="x_id" name="o<?php echo $bom_fp_list->RowIndex ?>_id" id="o<?php echo $bom_fp_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bom_fp->id->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_id" class="form-group bom_fp_id">
<span<?php echo $bom_fp->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bom_fp->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_id" name="x<?php echo $bom_fp_list->RowIndex ?>_id" id="x<?php echo $bom_fp_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bom_fp->id->CurrentValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_id" class="bom_fp_id">
<span<?php echo $bom_fp->id->viewAttributes() ?>>
<?php echo $bom_fp->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $bom_fp->grp->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_grp" class="form-group bom_fp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_grp" data-value-separator="<?php echo $bom_fp->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_grp" name="x<?php echo $bom_fp_list->RowIndex ?>_grp"<?php echo $bom_fp->grp->editAttributes() ?>>
		<?php echo $bom_fp->grp->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_grp") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_grp" name="o<?php echo $bom_fp_list->RowIndex ?>_grp" id="o<?php echo $bom_fp_list->RowIndex ?>_grp" value="<?php echo HtmlEncode($bom_fp->grp->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_grp" class="form-group bom_fp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_grp" data-value-separator="<?php echo $bom_fp->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_grp" name="x<?php echo $bom_fp_list->RowIndex ?>_grp"<?php echo $bom_fp->grp->editAttributes() ?>>
		<?php echo $bom_fp->grp->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_grp") ?>
	</select>
</div>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_grp" class="bom_fp_grp">
<span<?php echo $bom_fp->grp->viewAttributes() ?>>
<?php echo $bom_fp->grp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $bom_fp->s_grp->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_s_grp" class="form-group bom_fp_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo RemoveHtml($bom_fp->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>"<?php echo $bom_fp->s_grp->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_s_grp" data-value-separator="<?php echo $bom_fp->s_grp->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="x<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_fp->s_grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_s_grp","forceSelect":false});
</script>
<?php echo $bom_fp->s_grp->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_s_grp") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_s_grp" name="o<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="o<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_fp->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_s_grp" class="form-group bom_fp_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo RemoveHtml($bom_fp->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>"<?php echo $bom_fp->s_grp->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_s_grp" data-value-separator="<?php echo $bom_fp->s_grp->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="x<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_fp->s_grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_s_grp","forceSelect":false});
</script>
<?php echo $bom_fp->s_grp->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_s_grp") ?>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_s_grp" class="bom_fp_s_grp">
<span<?php echo $bom_fp->s_grp->viewAttributes() ?>>
<?php echo $bom_fp->s_grp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $bom_fp->product->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_product" class="form-group bom_fp_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->product->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_product" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<div class="input-group">
		<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_product" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo RemoveHtml($bom_fp->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>"<?php echo $bom_fp->product->editAttributes() ?>>
<?php if (AllowAdd(CurrentProjectID() . "product_fp") && !$bom_fp->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $bom_fp_list->RowIndex ?>_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $bom_fp->product->caption() ?>" data-title="<?php echo $bom_fp->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $bom_fp_list->RowIndex ?>_product',url:'product_fpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
	</div>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_product" data-value-separator="<?php echo $bom_fp->product->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_product" id="x<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_fp->product->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_product","forceSelect":false});
</script>
<?php echo $bom_fp->product->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_product" name="o<?php echo $bom_fp_list->RowIndex ?>_product" id="o<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_fp->product->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_product" class="form-group bom_fp_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->product->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_product" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<div class="input-group">
		<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_product" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo RemoveHtml($bom_fp->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>"<?php echo $bom_fp->product->editAttributes() ?>>
<?php if (AllowAdd(CurrentProjectID() . "product_fp") && !$bom_fp->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $bom_fp_list->RowIndex ?>_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $bom_fp->product->caption() ?>" data-title="<?php echo $bom_fp->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $bom_fp_list->RowIndex ?>_product',url:'product_fpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
	</div>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_product" data-value-separator="<?php echo $bom_fp->product->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_product" id="x<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_fp->product->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_product","forceSelect":false});
</script>
<?php echo $bom_fp->product->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_product") ?>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_product" class="bom_fp_product">
<span<?php echo $bom_fp->product->viewAttributes() ?>>
<?php echo $bom_fp->product->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $bom_fp->rid->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_rid" class="form-group bom_fp_rid">
<?php
$wrkonchange = "" . trim(@$bom_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_rid" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_rid" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo RemoveHtml($bom_fp->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>"<?php echo $bom_fp->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_rid" data-value-separator="<?php echo $bom_fp->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_rid" id="x<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_fp->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_rid","forceSelect":false});
</script>
<?php echo $bom_fp->rid->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_rid" name="o<?php echo $bom_fp_list->RowIndex ?>_rid" id="o<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_fp->rid->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_rid" class="form-group bom_fp_rid">
<?php
$wrkonchange = "" . trim(@$bom_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_rid" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_rid" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo RemoveHtml($bom_fp->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>"<?php echo $bom_fp->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_rid" data-value-separator="<?php echo $bom_fp->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_rid" id="x<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_fp->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_rid","forceSelect":false});
</script>
<?php echo $bom_fp->rid->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_rid") ?>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_rid" class="bom_fp_rid">
<span<?php echo $bom_fp->rid->viewAttributes() ?>>
<?php echo $bom_fp->rid->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $bom_fp->batch_no->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_batch_no" class="form-group bom_fp_batch_no">
<input type="text" data-table="bom_fp" data-field="x_batch_no" name="x<?php echo $bom_fp_list->RowIndex ?>_batch_no" id="x<?php echo $bom_fp_list->RowIndex ?>_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_fp->batch_no->EditValue ?>"<?php echo $bom_fp->batch_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_batch_no" name="o<?php echo $bom_fp_list->RowIndex ?>_batch_no" id="o<?php echo $bom_fp_list->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($bom_fp->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_batch_no" class="form-group bom_fp_batch_no">
<input type="text" data-table="bom_fp" data-field="x_batch_no" name="x<?php echo $bom_fp_list->RowIndex ?>_batch_no" id="x<?php echo $bom_fp_list->RowIndex ?>_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_fp->batch_no->EditValue ?>"<?php echo $bom_fp->batch_no->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_batch_no" class="bom_fp_batch_no">
<span<?php echo $bom_fp->batch_no->viewAttributes() ?>>
<?php echo $bom_fp->batch_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->material_group->Visible) { // material_group ?>
		<td data-name="material_group"<?php echo $bom_fp->material_group->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material_group" class="form-group bom_fp_material_group">
<?php $bom_fp->material_group->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material_group->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material_group" data-value-separator="<?php echo $bom_fp->material_group->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_material_group" name="x<?php echo $bom_fp_list->RowIndex ?>_material_group"<?php echo $bom_fp->material_group->editAttributes() ?>>
		<?php echo $bom_fp->material_group->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_material_group") ?>
	</select>
</div>
<?php echo $bom_fp->material_group->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material_group") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_material_group" name="o<?php echo $bom_fp_list->RowIndex ?>_material_group" id="o<?php echo $bom_fp_list->RowIndex ?>_material_group" value="<?php echo HtmlEncode($bom_fp->material_group->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material_group" class="form-group bom_fp_material_group">
<?php $bom_fp->material_group->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material_group->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material_group" data-value-separator="<?php echo $bom_fp->material_group->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_material_group" name="x<?php echo $bom_fp_list->RowIndex ?>_material_group"<?php echo $bom_fp->material_group->editAttributes() ?>>
		<?php echo $bom_fp->material_group->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_material_group") ?>
	</select>
</div>
<?php echo $bom_fp->material_group->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material_group") ?>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material_group" class="bom_fp_material_group">
<span<?php echo $bom_fp->material_group->viewAttributes() ?>>
<?php echo $bom_fp->material_group->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->material->Visible) { // material ?>
		<td data-name="material"<?php echo $bom_fp->material->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material" class="form-group bom_fp_material">
<?php $bom_fp->material->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material" data-value-separator="<?php echo $bom_fp->material->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_material" name="x<?php echo $bom_fp_list->RowIndex ?>_material"<?php echo $bom_fp->material->editAttributes() ?>>
		<?php echo $bom_fp->material->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_material") ?>
	</select>
</div>
<?php echo $bom_fp->material->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_material" name="o<?php echo $bom_fp_list->RowIndex ?>_material" id="o<?php echo $bom_fp_list->RowIndex ?>_material" value="<?php echo HtmlEncode($bom_fp->material->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material" class="form-group bom_fp_material">
<?php $bom_fp->material->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material" data-value-separator="<?php echo $bom_fp->material->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_material" name="x<?php echo $bom_fp_list->RowIndex ?>_material"<?php echo $bom_fp->material->editAttributes() ?>>
		<?php echo $bom_fp->material->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_material") ?>
	</select>
</div>
<?php echo $bom_fp->material->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material") ?>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material" class="bom_fp_material">
<span<?php echo $bom_fp->material->viewAttributes() ?>>
<?php echo $bom_fp->material->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->material_id->Visible) { // material_id ?>
		<td data-name="material_id"<?php echo $bom_fp->material_id->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material_id" class="form-group bom_fp_material_id">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($bom_fp->material_id->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $bom_fp->material_id->ViewValue ?></button>
		<div id="dsl_x<?php echo $bom_fp_list->RowIndex ?>_material_id" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $bom_fp->material_id->radioButtonListHtml(TRUE, "x{$bom_fp_list->RowIndex}_material_id") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x<?php echo $bom_fp_list->RowIndex ?>_material_id" class="ew-template"><input type="radio" class="form-check-input" data-table="bom_fp" data-field="x_material_id" data-value-separator="<?php echo $bom_fp->material_id->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_material_id" id="x<?php echo $bom_fp_list->RowIndex ?>_material_id" value="{value}"<?php echo $bom_fp->material_id->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$bom_fp->material_id->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
<?php echo $bom_fp->material_id->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material_id") ?>
	<?php } ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<input type="hidden" data-table="bom_fp" data-field="x_material_id" name="o<?php echo $bom_fp_list->RowIndex ?>_material_id" id="o<?php echo $bom_fp_list->RowIndex ?>_material_id" value="<?php echo HtmlEncode($bom_fp->material_id->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material_id" class="form-group bom_fp_material_id">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($bom_fp->material_id->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $bom_fp->material_id->ViewValue ?></button>
		<div id="dsl_x<?php echo $bom_fp_list->RowIndex ?>_material_id" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $bom_fp->material_id->radioButtonListHtml(TRUE, "x{$bom_fp_list->RowIndex}_material_id") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x<?php echo $bom_fp_list->RowIndex ?>_material_id" class="ew-template"><input type="radio" class="form-check-input" data-table="bom_fp" data-field="x_material_id" data-value-separator="<?php echo $bom_fp->material_id->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_material_id" id="x<?php echo $bom_fp_list->RowIndex ?>_material_id" value="{value}"<?php echo $bom_fp->material_id->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$bom_fp->material_id->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
<?php echo $bom_fp->material_id->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material_id") ?>
	<?php } ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_material_id" class="bom_fp_material_id">
<span<?php echo $bom_fp->material_id->viewAttributes() ?>>
<?php echo $bom_fp->material_id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $bom_fp->quantity->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_quantity" class="form-group bom_fp_quantity">
<input type="text" data-table="bom_fp" data-field="x_quantity" name="x<?php echo $bom_fp_list->RowIndex ?>_quantity" id="x<?php echo $bom_fp_list->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_fp->quantity->EditValue ?>"<?php echo $bom_fp->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_quantity" name="o<?php echo $bom_fp_list->RowIndex ?>_quantity" id="o<?php echo $bom_fp_list->RowIndex ?>_quantity" value="<?php echo HtmlEncode($bom_fp->quantity->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_quantity" class="form-group bom_fp_quantity">
<input type="text" data-table="bom_fp" data-field="x_quantity" name="x<?php echo $bom_fp_list->RowIndex ?>_quantity" id="x<?php echo $bom_fp_list->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_fp->quantity->EditValue ?>"<?php echo $bom_fp->quantity->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_quantity" class="bom_fp_quantity">
<span<?php echo $bom_fp->quantity->viewAttributes() ?>>
<?php echo $bom_fp->quantity->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->method->Visible) { // method ?>
		<td data-name="method"<?php echo $bom_fp->method->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_method" class="form-group bom_fp_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_method" data-value-separator="<?php echo $bom_fp->method->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_method" name="x<?php echo $bom_fp_list->RowIndex ?>_method"<?php echo $bom_fp->method->editAttributes() ?>>
		<?php echo $bom_fp->method->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_method") ?>
	</select>
</div>
<?php echo $bom_fp->method->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_method") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_method" name="o<?php echo $bom_fp_list->RowIndex ?>_method" id="o<?php echo $bom_fp_list->RowIndex ?>_method" value="<?php echo HtmlEncode($bom_fp->method->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_method" class="form-group bom_fp_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_method" data-value-separator="<?php echo $bom_fp->method->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_method" name="x<?php echo $bom_fp_list->RowIndex ?>_method"<?php echo $bom_fp->method->editAttributes() ?>>
		<?php echo $bom_fp->method->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_method") ?>
	</select>
</div>
<?php echo $bom_fp->method->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_method") ?>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_method" class="bom_fp_method">
<span<?php echo $bom_fp->method->viewAttributes() ?>>
<?php echo $bom_fp->method->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $bom_fp->unit->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_unit" class="form-group bom_fp_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_unit" data-value-separator="<?php echo $bom_fp->unit->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_unit" name="x<?php echo $bom_fp_list->RowIndex ?>_unit"<?php echo $bom_fp->unit->editAttributes() ?>>
		<?php echo $bom_fp->unit->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_unit") ?>
	</select>
</div>
<?php echo $bom_fp->unit->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_unit") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_unit" name="o<?php echo $bom_fp_list->RowIndex ?>_unit" id="o<?php echo $bom_fp_list->RowIndex ?>_unit" value="<?php echo HtmlEncode($bom_fp->unit->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_unit" class="form-group bom_fp_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_unit" data-value-separator="<?php echo $bom_fp->unit->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_unit" name="x<?php echo $bom_fp_list->RowIndex ?>_unit"<?php echo $bom_fp->unit->editAttributes() ?>>
		<?php echo $bom_fp->unit->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_unit") ?>
	</select>
</div>
<?php echo $bom_fp->unit->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_unit") ?>
</span>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_unit" class="bom_fp_unit">
<span<?php echo $bom_fp->unit->viewAttributes() ?>>
<?php echo $bom_fp->unit->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $bom_fp->operator->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="bom_fp" data-field="x_operator" name="o<?php echo $bom_fp_list->RowIndex ?>_operator" id="o<?php echo $bom_fp_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($bom_fp->operator->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_operator" class="bom_fp_operator">
<span<?php echo $bom_fp->operator->viewAttributes() ?>>
<?php echo $bom_fp->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $bom_fp->datetime->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="bom_fp" data-field="x_datetime" name="o<?php echo $bom_fp_list->RowIndex ?>_datetime" id="o<?php echo $bom_fp_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($bom_fp->datetime->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_datetime" class="bom_fp_datetime">
<span<?php echo $bom_fp->datetime->viewAttributes() ?>>
<?php echo $bom_fp->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $bom_fp->a_operator->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_a_operator" class="form-group bom_fp_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_a_operator" data-value-separator="<?php echo $bom_fp->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_a_operator" name="x<?php echo $bom_fp_list->RowIndex ?>_a_operator"<?php echo $bom_fp->a_operator->editAttributes() ?>>
		<?php echo $bom_fp->a_operator->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $bom_fp->a_operator->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_a_operator") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_a_operator" name="o<?php echo $bom_fp_list->RowIndex ?>_a_operator" id="o<?php echo $bom_fp_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($bom_fp->a_operator->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_a_operator" class="form-group bom_fp_a_operator">
<span<?php echo $bom_fp->a_operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bom_fp->a_operator->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_a_operator" name="x<?php echo $bom_fp_list->RowIndex ?>_a_operator" id="x<?php echo $bom_fp_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($bom_fp->a_operator->CurrentValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_a_operator" class="bom_fp_a_operator">
<span<?php echo $bom_fp->a_operator->viewAttributes() ?>>
<?php echo $bom_fp->a_operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($bom_fp->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $bom_fp->a_datetime->cellAttributes() ?>>
<?php if ($bom_fp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_a_datetime" class="form-group bom_fp_a_datetime">
<input type="text" data-table="bom_fp" data-field="x_a_datetime" name="x<?php echo $bom_fp_list->RowIndex ?>_a_datetime" id="x<?php echo $bom_fp_list->RowIndex ?>_a_datetime" size="30" placeholder="<?php echo HtmlEncode($bom_fp->a_datetime->getPlaceHolder()) ?>" value="<?php echo $bom_fp->a_datetime->EditValue ?>"<?php echo $bom_fp->a_datetime->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_a_datetime" name="o<?php echo $bom_fp_list->RowIndex ?>_a_datetime" id="o<?php echo $bom_fp_list->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($bom_fp->a_datetime->OldValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_a_datetime" class="form-group bom_fp_a_datetime">
<span<?php echo $bom_fp->a_datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($bom_fp->a_datetime->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_a_datetime" name="x<?php echo $bom_fp_list->RowIndex ?>_a_datetime" id="x<?php echo $bom_fp_list->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($bom_fp->a_datetime->CurrentValue) ?>">
<?php } ?>
<?php if ($bom_fp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $bom_fp_list->RowCnt ?>_bom_fp_a_datetime" class="bom_fp_a_datetime">
<span<?php echo $bom_fp->a_datetime->viewAttributes() ?>>
<?php echo $bom_fp->a_datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bom_fp_list->ListOptions->render("body", "right", $bom_fp_list->RowCnt);
?>
	</tr>
<?php if ($bom_fp->RowType == ROWTYPE_ADD || $bom_fp->RowType == ROWTYPE_EDIT) { ?>
<script>
fbom_fplist.updateLists(<?php echo $bom_fp_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$bom_fp->isGridAdd())
		if (!$bom_fp_list->Recordset->EOF)
			$bom_fp_list->Recordset->moveNext();
}
?>
<?php
	if ($bom_fp->isGridAdd() || $bom_fp->isGridEdit()) {
		$bom_fp_list->RowIndex = '$rowindex$';
		$bom_fp_list->loadRowValues();

		// Set row properties
		$bom_fp->resetAttributes();
		$bom_fp->RowAttrs = array_merge($bom_fp->RowAttrs, array('data-rowindex'=>$bom_fp_list->RowIndex, 'id'=>'r0_bom_fp', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($bom_fp->RowAttrs["class"], "ew-template");
		$bom_fp->RowType = ROWTYPE_ADD;

		// Render row
		$bom_fp_list->renderRow();

		// Render list options
		$bom_fp_list->renderListOptions();
		$bom_fp_list->StartRowCnt = 0;
?>
	<tr<?php echo $bom_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bom_fp_list->ListOptions->render("body", "left", $bom_fp_list->RowIndex);
?>
	<?php if ($bom_fp->id->Visible) { // id ?>
		<td data-name="id">
<input type="hidden" data-table="bom_fp" data-field="x_id" name="o<?php echo $bom_fp_list->RowIndex ?>_id" id="o<?php echo $bom_fp_list->RowIndex ?>_id" value="<?php echo HtmlEncode($bom_fp->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->grp->Visible) { // grp ?>
		<td data-name="grp">
<span id="el$rowindex$_bom_fp_grp" class="form-group bom_fp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_grp" data-value-separator="<?php echo $bom_fp->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_grp" name="x<?php echo $bom_fp_list->RowIndex ?>_grp"<?php echo $bom_fp->grp->editAttributes() ?>>
		<?php echo $bom_fp->grp->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_grp") ?>
	</select>
</div>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_grp" name="o<?php echo $bom_fp_list->RowIndex ?>_grp" id="o<?php echo $bom_fp_list->RowIndex ?>_grp" value="<?php echo HtmlEncode($bom_fp->grp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp">
<span id="el$rowindex$_bom_fp_s_grp" class="form-group bom_fp_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo RemoveHtml($bom_fp->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>"<?php echo $bom_fp->s_grp->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_s_grp" data-value-separator="<?php echo $bom_fp->s_grp->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="x<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_fp->s_grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_s_grp","forceSelect":false});
</script>
<?php echo $bom_fp->s_grp->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_s_grp") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_s_grp" name="o<?php echo $bom_fp_list->RowIndex ?>_s_grp" id="o<?php echo $bom_fp_list->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($bom_fp->s_grp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->product->Visible) { // product ?>
		<td data-name="product">
<span id="el$rowindex$_bom_fp_product" class="form-group bom_fp_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->product->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_product" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<div class="input-group">
		<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_product" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo RemoveHtml($bom_fp->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>"<?php echo $bom_fp->product->editAttributes() ?>>
<?php if (AllowAdd(CurrentProjectID() . "product_fp") && !$bom_fp->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $bom_fp_list->RowIndex ?>_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $bom_fp->product->caption() ?>" data-title="<?php echo $bom_fp->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $bom_fp_list->RowIndex ?>_product',url:'product_fpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
	</div>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_product" data-value-separator="<?php echo $bom_fp->product->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_product" id="x<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_fp->product->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_product","forceSelect":false});
</script>
<?php echo $bom_fp->product->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_product" name="o<?php echo $bom_fp_list->RowIndex ?>_product" id="o<?php echo $bom_fp_list->RowIndex ?>_product" value="<?php echo HtmlEncode($bom_fp->product->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->rid->Visible) { // rid ?>
		<td data-name="rid">
<span id="el$rowindex$_bom_fp_rid" class="form-group bom_fp_rid">
<?php
$wrkonchange = "" . trim(@$bom_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $bom_fp_list->RowIndex ?>_rid" class="text-nowrap" style="z-index: <?php echo (9000 - $bom_fp_list->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $bom_fp_list->RowIndex ?>_rid" id="sv_x<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo RemoveHtml($bom_fp->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>"<?php echo $bom_fp->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_rid" data-value-separator="<?php echo $bom_fp->rid->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_rid" id="x<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_fp->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fplist.createAutoSuggest({"id":"x<?php echo $bom_fp_list->RowIndex ?>_rid","forceSelect":false});
</script>
<?php echo $bom_fp->rid->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_rid" name="o<?php echo $bom_fp_list->RowIndex ?>_rid" id="o<?php echo $bom_fp_list->RowIndex ?>_rid" value="<?php echo HtmlEncode($bom_fp->rid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no">
<span id="el$rowindex$_bom_fp_batch_no" class="form-group bom_fp_batch_no">
<input type="text" data-table="bom_fp" data-field="x_batch_no" name="x<?php echo $bom_fp_list->RowIndex ?>_batch_no" id="x<?php echo $bom_fp_list->RowIndex ?>_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_fp->batch_no->EditValue ?>"<?php echo $bom_fp->batch_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_batch_no" name="o<?php echo $bom_fp_list->RowIndex ?>_batch_no" id="o<?php echo $bom_fp_list->RowIndex ?>_batch_no" value="<?php echo HtmlEncode($bom_fp->batch_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->material_group->Visible) { // material_group ?>
		<td data-name="material_group">
<span id="el$rowindex$_bom_fp_material_group" class="form-group bom_fp_material_group">
<?php $bom_fp->material_group->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material_group->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material_group" data-value-separator="<?php echo $bom_fp->material_group->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_material_group" name="x<?php echo $bom_fp_list->RowIndex ?>_material_group"<?php echo $bom_fp->material_group->editAttributes() ?>>
		<?php echo $bom_fp->material_group->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_material_group") ?>
	</select>
</div>
<?php echo $bom_fp->material_group->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material_group") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_material_group" name="o<?php echo $bom_fp_list->RowIndex ?>_material_group" id="o<?php echo $bom_fp_list->RowIndex ?>_material_group" value="<?php echo HtmlEncode($bom_fp->material_group->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->material->Visible) { // material ?>
		<td data-name="material">
<span id="el$rowindex$_bom_fp_material" class="form-group bom_fp_material">
<?php $bom_fp->material->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material" data-value-separator="<?php echo $bom_fp->material->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_material" name="x<?php echo $bom_fp_list->RowIndex ?>_material"<?php echo $bom_fp->material->editAttributes() ?>>
		<?php echo $bom_fp->material->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_material") ?>
	</select>
</div>
<?php echo $bom_fp->material->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_material" name="o<?php echo $bom_fp_list->RowIndex ?>_material" id="o<?php echo $bom_fp_list->RowIndex ?>_material" value="<?php echo HtmlEncode($bom_fp->material->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->material_id->Visible) { // material_id ?>
		<td data-name="material_id">
<span id="el$rowindex$_bom_fp_material_id" class="form-group bom_fp_material_id">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($bom_fp->material_id->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $bom_fp->material_id->ViewValue ?></button>
		<div id="dsl_x<?php echo $bom_fp_list->RowIndex ?>_material_id" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $bom_fp->material_id->radioButtonListHtml(TRUE, "x{$bom_fp_list->RowIndex}_material_id") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x<?php echo $bom_fp_list->RowIndex ?>_material_id" class="ew-template"><input type="radio" class="form-check-input" data-table="bom_fp" data-field="x_material_id" data-value-separator="<?php echo $bom_fp->material_id->displayValueSeparatorAttribute() ?>" name="x<?php echo $bom_fp_list->RowIndex ?>_material_id" id="x<?php echo $bom_fp_list->RowIndex ?>_material_id" value="{value}"<?php echo $bom_fp->material_id->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$bom_fp->material_id->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
<?php echo $bom_fp->material_id->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_material_id") ?>
	<?php } ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<input type="hidden" data-table="bom_fp" data-field="x_material_id" name="o<?php echo $bom_fp_list->RowIndex ?>_material_id" id="o<?php echo $bom_fp_list->RowIndex ?>_material_id" value="<?php echo HtmlEncode($bom_fp->material_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity">
<span id="el$rowindex$_bom_fp_quantity" class="form-group bom_fp_quantity">
<input type="text" data-table="bom_fp" data-field="x_quantity" name="x<?php echo $bom_fp_list->RowIndex ?>_quantity" id="x<?php echo $bom_fp_list->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_fp->quantity->EditValue ?>"<?php echo $bom_fp->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_quantity" name="o<?php echo $bom_fp_list->RowIndex ?>_quantity" id="o<?php echo $bom_fp_list->RowIndex ?>_quantity" value="<?php echo HtmlEncode($bom_fp->quantity->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->method->Visible) { // method ?>
		<td data-name="method">
<span id="el$rowindex$_bom_fp_method" class="form-group bom_fp_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_method" data-value-separator="<?php echo $bom_fp->method->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_method" name="x<?php echo $bom_fp_list->RowIndex ?>_method"<?php echo $bom_fp->method->editAttributes() ?>>
		<?php echo $bom_fp->method->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_method") ?>
	</select>
</div>
<?php echo $bom_fp->method->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_method") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_method" name="o<?php echo $bom_fp_list->RowIndex ?>_method" id="o<?php echo $bom_fp_list->RowIndex ?>_method" value="<?php echo HtmlEncode($bom_fp->method->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->unit->Visible) { // unit ?>
		<td data-name="unit">
<span id="el$rowindex$_bom_fp_unit" class="form-group bom_fp_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_unit" data-value-separator="<?php echo $bom_fp->unit->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_unit" name="x<?php echo $bom_fp_list->RowIndex ?>_unit"<?php echo $bom_fp->unit->editAttributes() ?>>
		<?php echo $bom_fp->unit->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_unit") ?>
	</select>
</div>
<?php echo $bom_fp->unit->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_unit") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_unit" name="o<?php echo $bom_fp_list->RowIndex ?>_unit" id="o<?php echo $bom_fp_list->RowIndex ?>_unit" value="<?php echo HtmlEncode($bom_fp->unit->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->operator->Visible) { // operator ?>
		<td data-name="operator">
<input type="hidden" data-table="bom_fp" data-field="x_operator" name="o<?php echo $bom_fp_list->RowIndex ?>_operator" id="o<?php echo $bom_fp_list->RowIndex ?>_operator" value="<?php echo HtmlEncode($bom_fp->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<input type="hidden" data-table="bom_fp" data-field="x_datetime" name="o<?php echo $bom_fp_list->RowIndex ?>_datetime" id="o<?php echo $bom_fp_list->RowIndex ?>_datetime" value="<?php echo HtmlEncode($bom_fp->datetime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator">
<span id="el$rowindex$_bom_fp_a_operator" class="form-group bom_fp_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_a_operator" data-value-separator="<?php echo $bom_fp->a_operator->displayValueSeparatorAttribute() ?>" id="x<?php echo $bom_fp_list->RowIndex ?>_a_operator" name="x<?php echo $bom_fp_list->RowIndex ?>_a_operator"<?php echo $bom_fp->a_operator->editAttributes() ?>>
		<?php echo $bom_fp->a_operator->selectOptionListHtml("x<?php echo $bom_fp_list->RowIndex ?>_a_operator") ?>
	</select>
</div>
<?php echo $bom_fp->a_operator->Lookup->getParamTag("p_x" . $bom_fp_list->RowIndex . "_a_operator") ?>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_a_operator" name="o<?php echo $bom_fp_list->RowIndex ?>_a_operator" id="o<?php echo $bom_fp_list->RowIndex ?>_a_operator" value="<?php echo HtmlEncode($bom_fp->a_operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($bom_fp->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime">
<span id="el$rowindex$_bom_fp_a_datetime" class="form-group bom_fp_a_datetime">
<input type="text" data-table="bom_fp" data-field="x_a_datetime" name="x<?php echo $bom_fp_list->RowIndex ?>_a_datetime" id="x<?php echo $bom_fp_list->RowIndex ?>_a_datetime" size="30" placeholder="<?php echo HtmlEncode($bom_fp->a_datetime->getPlaceHolder()) ?>" value="<?php echo $bom_fp->a_datetime->EditValue ?>"<?php echo $bom_fp->a_datetime->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_a_datetime" name="o<?php echo $bom_fp_list->RowIndex ?>_a_datetime" id="o<?php echo $bom_fp_list->RowIndex ?>_a_datetime" value="<?php echo HtmlEncode($bom_fp->a_datetime->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$bom_fp_list->ListOptions->render("body", "right", $bom_fp_list->RowIndex);
?>
<script>
fbom_fplist.updateLists(<?php echo $bom_fp_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$bom_fp->RowType = ROWTYPE_AGGREGATE;
$bom_fp->resetAttributes();
$bom_fp_list->renderRow();
?>
<?php if ($bom_fp_list->TotalRecs > 0 && !$bom_fp->isGridAdd() && !$bom_fp->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$bom_fp_list->renderListOptions();

// Render list options (footer, left)
$bom_fp_list->ListOptions->render("footer", "left");
?>
	<?php if ($bom_fp->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $bom_fp->id->footerCellClass() ?>"><span id="elf_bom_fp_id" class="bom_fp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $bom_fp->grp->footerCellClass() ?>"><span id="elf_bom_fp_grp" class="bom_fp_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $bom_fp->s_grp->footerCellClass() ?>"><span id="elf_bom_fp_s_grp" class="bom_fp_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $bom_fp->product->footerCellClass() ?>"><span id="elf_bom_fp_product" class="bom_fp_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $bom_fp->rid->footerCellClass() ?>"><span id="elf_bom_fp_rid" class="bom_fp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $bom_fp->batch_no->footerCellClass() ?>"><span id="elf_bom_fp_batch_no" class="bom_fp_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->material_group->Visible) { // material_group ?>
		<td data-name="material_group" class="<?php echo $bom_fp->material_group->footerCellClass() ?>"><span id="elf_bom_fp_material_group" class="bom_fp_material_group">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->material->Visible) { // material ?>
		<td data-name="material" class="<?php echo $bom_fp->material->footerCellClass() ?>"><span id="elf_bom_fp_material" class="bom_fp_material">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->material_id->Visible) { // material_id ?>
		<td data-name="material_id" class="<?php echo $bom_fp->material_id->footerCellClass() ?>"><span id="elf_bom_fp_material_id" class="bom_fp_material_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $bom_fp->quantity->footerCellClass() ?>"><span id="elf_bom_fp_quantity" class="bom_fp_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $bom_fp->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->method->Visible) { // method ?>
		<td data-name="method" class="<?php echo $bom_fp->method->footerCellClass() ?>"><span id="elf_bom_fp_method" class="bom_fp_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $bom_fp->unit->footerCellClass() ?>"><span id="elf_bom_fp_unit" class="bom_fp_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $bom_fp->operator->footerCellClass() ?>"><span id="elf_bom_fp_operator" class="bom_fp_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $bom_fp->datetime->footerCellClass() ?>"><span id="elf_bom_fp_datetime" class="bom_fp_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator" class="<?php echo $bom_fp->a_operator->footerCellClass() ?>"><span id="elf_bom_fp_a_operator" class="bom_fp_a_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($bom_fp->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime" class="<?php echo $bom_fp->a_datetime->footerCellClass() ?>"><span id="elf_bom_fp_a_datetime" class="bom_fp_a_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$bom_fp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($bom_fp->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $bom_fp_list->FormKeyCountName ?>" id="<?php echo $bom_fp_list->FormKeyCountName ?>" value="<?php echo $bom_fp_list->KeyCount ?>">
<?php echo $bom_fp_list->MultiSelectKey ?>
<?php } ?>
<?php if ($bom_fp->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $bom_fp_list->FormKeyCountName ?>" id="<?php echo $bom_fp_list->FormKeyCountName ?>" value="<?php echo $bom_fp_list->KeyCount ?>">
<?php echo $bom_fp_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$bom_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($bom_fp_list->Recordset)
	$bom_fp_list->Recordset->Close();
?>
<?php if (!$bom_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$bom_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($bom_fp_list->Pager)) $bom_fp_list->Pager = new PrevNextPager($bom_fp_list->StartRec, $bom_fp_list->DisplayRecs, $bom_fp_list->TotalRecs, $bom_fp_list->AutoHidePager) ?>
<?php if ($bom_fp_list->Pager->RecordCount > 0 && $bom_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($bom_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($bom_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $bom_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($bom_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($bom_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $bom_fp_list->pageUrl() ?>start=<?php echo $bom_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $bom_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($bom_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $bom_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $bom_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $bom_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($bom_fp_list->TotalRecs > 0 && (!$bom_fp_list->AutoHidePageSizeSelector || $bom_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="bom_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($bom_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($bom_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($bom_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($bom_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($bom_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($bom_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $bom_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($bom_fp_list->TotalRecs == 0 && !$bom_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $bom_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$bom_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bom_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$bom_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_bom_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bom_fp_list->terminate();
?>