<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bom_fp_search = new bom_fp_search();

// Run the page
$bom_fp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bom_fp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($bom_fp_search->IsModal) { ?>
var fbom_fpsearch = currentAdvancedSearchForm = new ew.Form("fbom_fpsearch", "search");
<?php } else { ?>
var fbom_fpsearch = currentForm = new ew.Form("fbom_fpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fbom_fpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbom_fpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbom_fpsearch.lists["x_grp"] = <?php echo $bom_fp_search->grp->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_grp"].options = <?php echo JsonEncode($bom_fp_search->grp->options(FALSE, TRUE)) ?>;
fbom_fpsearch.lists["x_s_grp"] = <?php echo $bom_fp_search->s_grp->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_s_grp"].options = <?php echo JsonEncode($bom_fp_search->s_grp->lookupOptions()) ?>;
fbom_fpsearch.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_fpsearch.lists["x_product"] = <?php echo $bom_fp_search->product->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_product"].options = <?php echo JsonEncode($bom_fp_search->product->lookupOptions()) ?>;
fbom_fpsearch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_fpsearch.lists["x_rid"] = <?php echo $bom_fp_search->rid->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_rid"].options = <?php echo JsonEncode($bom_fp_search->rid->lookupOptions()) ?>;
fbom_fpsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbom_fpsearch.lists["x_material_group"] = <?php echo $bom_fp_search->material_group->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_material_group"].options = <?php echo JsonEncode($bom_fp_search->material_group->lookupOptions()) ?>;
fbom_fpsearch.lists["x_material"] = <?php echo $bom_fp_search->material->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_material"].options = <?php echo JsonEncode($bom_fp_search->material->lookupOptions()) ?>;
fbom_fpsearch.lists["x_material_id"] = <?php echo $bom_fp_search->material_id->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_material_id"].options = <?php echo JsonEncode($bom_fp_search->material_id->lookupOptions()) ?>;
fbom_fpsearch.lists["x_method"] = <?php echo $bom_fp_search->method->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_method"].options = <?php echo JsonEncode($bom_fp_search->method->lookupOptions()) ?>;
fbom_fpsearch.lists["x_unit"] = <?php echo $bom_fp_search->unit->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_unit"].options = <?php echo JsonEncode($bom_fp_search->unit->lookupOptions()) ?>;
fbom_fpsearch.lists["x_operator"] = <?php echo $bom_fp_search->operator->Lookup->toClientList() ?>;
fbom_fpsearch.lists["x_operator"].options = <?php echo JsonEncode($bom_fp_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbom_fpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_fp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_fp->s_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_fp->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_fp->batch_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom_fp->quantity->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bom_fp_search->showPageHeader(); ?>
<?php
$bom_fp_search->showMessage();
?>
<form name="fbom_fpsearch" id="fbom_fpsearch" class="<?php echo $bom_fp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bom_fp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bom_fp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bom_fp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$bom_fp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($bom_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_id"><?php echo $bom_fp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->id->cellAttributes() ?>>
			<span id="el_bom_fp_id">
<input type="text" data-table="bom_fp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bom_fp->id->getPlaceHolder()) ?>" value="<?php echo $bom_fp->id->EditValue ?>"<?php echo $bom_fp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_grp"><?php echo $bom_fp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->grp->cellAttributes() ?>>
			<span id="el_bom_fp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_grp" data-value-separator="<?php echo $bom_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $bom_fp->grp->editAttributes() ?>>
		<?php echo $bom_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_s_grp"><?php echo $bom_fp->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->s_grp->cellAttributes() ?>>
			<span id="el_bom_fp_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_s_grp" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_s_grp" id="sv_x_s_grp" value="<?php echo RemoveHtml($bom_fp->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->s_grp->getPlaceHolder()) ?>"<?php echo $bom_fp->s_grp->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_s_grp" data-value-separator="<?php echo $bom_fp->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($bom_fp->s_grp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fpsearch.createAutoSuggest({"id":"x_s_grp","forceSelect":false});
</script>
<?php echo $bom_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_product"><?php echo $bom_fp->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->product->cellAttributes() ?>>
			<span id="el_bom_fp_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$bom_fp->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($bom_fp->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->product->getPlaceHolder()) ?>"<?php echo $bom_fp->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_product" data-value-separator="<?php echo $bom_fp->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($bom_fp->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fpsearch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $bom_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_rid"><?php echo $bom_fp->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->rid->cellAttributes() ?>>
			<span id="el_bom_fp_rid">
<?php
$wrkonchange = "" . trim(@$bom_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8950">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($bom_fp->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom_fp->rid->getPlaceHolder()) ?>"<?php echo $bom_fp->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom_fp" data-field="x_rid" data-value-separator="<?php echo $bom_fp->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($bom_fp->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbom_fpsearch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $bom_fp->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_batch_no"><?php echo $bom_fp->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->batch_no->cellAttributes() ?>>
			<span id="el_bom_fp_batch_no">
<input type="text" data-table="bom_fp" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($bom_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $bom_fp->batch_no->EditValue ?>"<?php echo $bom_fp->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->material_group->Visible) { // material_group ?>
	<div id="r_material_group" class="form-group row">
		<label for="x_material_group" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_material_group"><?php echo $bom_fp->material_group->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_group" id="z_material_group" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->material_group->cellAttributes() ?>>
			<span id="el_bom_fp_material_group">
<?php $bom_fp->material_group->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material_group->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material_group" data-value-separator="<?php echo $bom_fp->material_group->displayValueSeparatorAttribute() ?>" id="x_material_group" name="x_material_group"<?php echo $bom_fp->material_group->editAttributes() ?>>
		<?php echo $bom_fp->material_group->selectOptionListHtml("x_material_group") ?>
	</select>
</div>
<?php echo $bom_fp->material_group->Lookup->getParamTag("p_x_material_group") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label for="x_material" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_material"><?php echo $bom_fp->material->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material" id="z_material" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->material->cellAttributes() ?>>
			<span id="el_bom_fp_material">
<?php $bom_fp->material->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom_fp->material->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_material" data-value-separator="<?php echo $bom_fp->material->displayValueSeparatorAttribute() ?>" id="x_material" name="x_material"<?php echo $bom_fp->material->editAttributes() ?>>
		<?php echo $bom_fp->material->selectOptionListHtml("x_material") ?>
	</select>
</div>
<?php echo $bom_fp->material->Lookup->getParamTag("p_x_material") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->material_id->Visible) { // material_id ?>
	<div id="r_material_id" class="form-group row">
		<label for="x_material_id" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_material_id"><?php echo $bom_fp->material_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_material_id" id="z_material_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->material_id->cellAttributes() ?>>
			<span id="el_bom_fp_material_id">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($bom_fp->material_id->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $bom_fp->material_id->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_material_id" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $bom_fp->material_id->radioButtonListHtml(TRUE, "x_material_id") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_material_id" class="ew-template"><input type="radio" class="form-check-input" data-table="bom_fp" data-field="x_material_id" data-value-separator="<?php echo $bom_fp->material_id->displayValueSeparatorAttribute() ?>" name="x_material_id" id="x_material_id" value="{value}"<?php echo $bom_fp->material_id->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$bom_fp->material_id->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
<?php echo $bom_fp->material_id->Lookup->getParamTag("p_x_material_id") ?>
	<?php } ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_quantity"><?php echo $bom_fp->quantity->caption() ?></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->quantity->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_quantity" id="z_quantity" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bom_fp->quantity->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bom_fp_quantity">
<input type="text" data-table="bom_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_fp->quantity->EditValue ?>"<?php echo $bom_fp->quantity->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_quantity d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bom_fp_quantity" class="btw1_quantity d-none">
<input type="text" data-table="bom_fp" data-field="x_quantity" name="y_quantity" id="y_quantity" size="30" placeholder="<?php echo HtmlEncode($bom_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $bom_fp->quantity->EditValue2 ?>"<?php echo $bom_fp->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_method"><?php echo $bom_fp->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->method->cellAttributes() ?>>
			<span id="el_bom_fp_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_method" data-value-separator="<?php echo $bom_fp->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $bom_fp->method->editAttributes() ?>>
		<?php echo $bom_fp->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $bom_fp->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_unit"><?php echo $bom_fp->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->unit->cellAttributes() ?>>
			<span id="el_bom_fp_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_unit" data-value-separator="<?php echo $bom_fp->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $bom_fp->unit->editAttributes() ?>>
		<?php echo $bom_fp->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $bom_fp->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_operator"><?php echo $bom_fp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->operator->cellAttributes() ?>>
			<span id="el_bom_fp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom_fp" data-field="x_operator" data-value-separator="<?php echo $bom_fp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $bom_fp->operator->editAttributes() ?>>
		<?php echo $bom_fp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $bom_fp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom_fp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $bom_fp_search->LeftColumnClass ?>"><span id="elh_bom_fp_datetime"><?php echo $bom_fp->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $bom_fp_search->RightColumnClass ?>"><div<?php echo $bom_fp->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bom_fp->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bom_fp_datetime">
<input type="text" data-table="bom_fp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($bom_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $bom_fp->datetime->EditValue ?>"<?php echo $bom_fp->datetime->editAttributes() ?>>
<?php if (!$bom_fp->datetime->ReadOnly && !$bom_fp->datetime->Disabled && !isset($bom_fp->datetime->EditAttrs["readonly"]) && !isset($bom_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbom_fpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bom_fp_datetime" class="btw1_datetime d-none">
<input type="text" data-table="bom_fp" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($bom_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $bom_fp->datetime->EditValue2 ?>"<?php echo $bom_fp->datetime->editAttributes() ?>>
<?php if (!$bom_fp->datetime->ReadOnly && !$bom_fp->datetime->Disabled && !isset($bom_fp->datetime->EditAttrs["readonly"]) && !isset($bom_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbom_fpsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bom_fp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bom_fp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bom_fp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bom_fp_search->terminate();
?>