<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$bom_preview = new bom_preview();

// Run the page
$bom_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bom_preview->Page_Render();
?>
<?php $bom_preview->showPageHeader(); ?>
<div class="card ew-grid bom"><!-- .card -->
<?php if ($bom_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$bom_preview->renderListOptions();

// Render list options (header, left)
$bom_preview->ListOptions->render("header", "left");
?>
<?php if ($bom->id->Visible) { // id ?>
	<?php if ($bom->SortUrl($bom->id) == "") { ?>
		<th class="<?php echo $bom->id->headerCellClass() ?>"><?php echo $bom->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->id->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->id->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->id->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->batch_no->Visible) { // batch_no ?>
	<?php if ($bom->SortUrl($bom->batch_no) == "") { ?>
		<th class="<?php echo $bom->batch_no->headerCellClass() ?>"><?php echo $bom->batch_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->batch_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->batch_no->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->batch_no->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->batch_no->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->warp_weft->Visible) { // warp_weft ?>
	<?php if ($bom->SortUrl($bom->warp_weft) == "") { ?>
		<th class="<?php echo $bom->warp_weft->headerCellClass() ?>"><?php echo $bom->warp_weft->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->warp_weft->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->warp_weft->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->warp_weft->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->warp_weft->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->warp_weft->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->m_grp->Visible) { // m_grp ?>
	<?php if ($bom->SortUrl($bom->m_grp) == "") { ?>
		<th class="<?php echo $bom->m_grp->headerCellClass() ?>"><?php echo $bom->m_grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->m_grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->m_grp->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->m_grp->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->m_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->m_grp->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->m_sgrp->Visible) { // m_sgrp ?>
	<?php if ($bom->SortUrl($bom->m_sgrp) == "") { ?>
		<th class="<?php echo $bom->m_sgrp->headerCellClass() ?>"><?php echo $bom->m_sgrp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->m_sgrp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->m_sgrp->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->m_sgrp->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->m_sgrp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->m_sgrp->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->m_product->Visible) { // m_product ?>
	<?php if ($bom->SortUrl($bom->m_product) == "") { ?>
		<th class="<?php echo $bom->m_product->headerCellClass() ?>"><?php echo $bom->m_product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->m_product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->m_product->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->m_product->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->m_product->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->m_product->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->m_rid->Visible) { // m_rid ?>
	<?php if ($bom->SortUrl($bom->m_rid) == "") { ?>
		<th class="<?php echo $bom->m_rid->headerCellClass() ?>"><?php echo $bom->m_rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->m_rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->m_rid->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->m_rid->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->m_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->m_rid->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->m_packing->Visible) { // m_packing ?>
	<?php if ($bom->SortUrl($bom->m_packing) == "") { ?>
		<th class="<?php echo $bom->m_packing->headerCellClass() ?>"><?php echo $bom->m_packing->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->m_packing->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->m_packing->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->m_packing->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->m_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->m_packing->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->quantity_a->Visible) { // quantity_a ?>
	<?php if ($bom->SortUrl($bom->quantity_a) == "") { ?>
		<th class="<?php echo $bom->quantity_a->headerCellClass() ?>"><?php echo $bom->quantity_a->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->quantity_a->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->quantity_a->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->quantity_a->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->quantity_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->quantity_a->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->bom_waste->Visible) { // bom_waste ?>
	<?php if ($bom->SortUrl($bom->bom_waste) == "") { ?>
		<th class="<?php echo $bom->bom_waste->headerCellClass() ?>"><?php echo $bom->bom_waste->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->bom_waste->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->bom_waste->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->bom_waste->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->bom_waste->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->bom_waste->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->method->Visible) { // method ?>
	<?php if ($bom->SortUrl($bom->method) == "") { ?>
		<th class="<?php echo $bom->method->headerCellClass() ?>"><?php echo $bom->method->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->method->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->method->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->method->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->method->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->unit->Visible) { // unit ?>
	<?php if ($bom->SortUrl($bom->unit) == "") { ?>
		<th class="<?php echo $bom->unit->headerCellClass() ?>"><?php echo $bom->unit->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->unit->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->unit->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->unit->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->unit->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->gross_nett->Visible) { // gross_nett ?>
	<?php if ($bom->SortUrl($bom->gross_nett) == "") { ?>
		<th class="<?php echo $bom->gross_nett->headerCellClass() ?>"><?php echo $bom->gross_nett->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->gross_nett->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->gross_nett->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->gross_nett->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->gross_nett->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->gross_nett->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->grp->Visible) { // grp ?>
	<?php if ($bom->SortUrl($bom->grp) == "") { ?>
		<th class="<?php echo $bom->grp->headerCellClass() ?>"><?php echo $bom->grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->grp->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->grp->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->grp->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->s_grp->Visible) { // s_grp ?>
	<?php if ($bom->SortUrl($bom->s_grp) == "") { ?>
		<th class="<?php echo $bom->s_grp->headerCellClass() ?>"><?php echo $bom->s_grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->s_grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->s_grp->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->s_grp->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->s_grp->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->product->Visible) { // product ?>
	<?php if ($bom->SortUrl($bom->product) == "") { ?>
		<th class="<?php echo $bom->product->headerCellClass() ?>"><?php echo $bom->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->product->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->product->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->product->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->rid->Visible) { // rid ?>
	<?php if ($bom->SortUrl($bom->rid) == "") { ?>
		<th class="<?php echo $bom->rid->headerCellClass() ?>"><?php echo $bom->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->rid->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->rid->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->rid->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->packing_type->Visible) { // packing_type ?>
	<?php if ($bom->SortUrl($bom->packing_type) == "") { ?>
		<th class="<?php echo $bom->packing_type->headerCellClass() ?>"><?php echo $bom->packing_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->packing_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->packing_type->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->packing_type->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->packing_type->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->operator->Visible) { // operator ?>
	<?php if ($bom->SortUrl($bom->operator) == "") { ?>
		<th class="<?php echo $bom->operator->headerCellClass() ?>"><?php echo $bom->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->operator->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->operator->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->operator->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->datetime->Visible) { // datetime ?>
	<?php if ($bom->SortUrl($bom->datetime) == "") { ?>
		<th class="<?php echo $bom->datetime->headerCellClass() ?>"><?php echo $bom->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->datetime->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->datetime->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->datetime->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->a_operator->Visible) { // a_operator ?>
	<?php if ($bom->SortUrl($bom->a_operator) == "") { ?>
		<th class="<?php echo $bom->a_operator->headerCellClass() ?>"><?php echo $bom->a_operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->a_operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->a_operator->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->a_operator->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->a_operator->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($bom->a_datetime->Visible) { // a_datetime ?>
	<?php if ($bom->SortUrl($bom->a_datetime) == "") { ?>
		<th class="<?php echo $bom->a_datetime->headerCellClass() ?>"><?php echo $bom->a_datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $bom->a_datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($bom->a_datetime->Name) ?>" data-sort-order="<?php echo $bom_preview->SortField == $bom->a_datetime->Name && $bom_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $bom->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($bom_preview->SortField == $bom->a_datetime->Name) { ?><?php if ($bom_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($bom_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$bom_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$bom_preview->RecCount = 0;
$bom_preview->RowCnt = 0;
while ($bom_preview->Recordset && !$bom_preview->Recordset->EOF) {

	// Init row class and style
	$bom_preview->RecCount++;
	$bom_preview->RowCnt++;
	$bom_preview->CssStyle = "";
	$bom_preview->loadListRowValues($bom_preview->Recordset);
	$bom_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$bom_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$bom_preview->resetAttributes();
	$bom_preview->renderListRow();

	// Render list options
	$bom_preview->renderListOptions();
?>
	<tr<?php echo $bom_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$bom_preview->ListOptions->render("body", "left", $bom_preview->RowCnt);
?>
<?php if ($bom->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $bom->id->cellAttributes() ?>>
<span<?php echo $bom->id->viewAttributes() ?>>
<?php echo $bom->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td<?php echo $bom->batch_no->cellAttributes() ?>>
<span<?php echo $bom->batch_no->viewAttributes() ?>>
<?php echo $bom->batch_no->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->warp_weft->Visible) { // warp_weft ?>
		<!-- warp_weft -->
		<td<?php echo $bom->warp_weft->cellAttributes() ?>>
<span<?php echo $bom->warp_weft->viewAttributes() ?>>
<?php echo $bom->warp_weft->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->m_grp->Visible) { // m_grp ?>
		<!-- m_grp -->
		<td<?php echo $bom->m_grp->cellAttributes() ?>>
<span<?php echo $bom->m_grp->viewAttributes() ?>>
<?php if ((!EmptyString($bom->m_grp->getViewValue())) && $bom->m_grp->linkAttributes() <> "") { ?>
<a<?php echo $bom->m_grp->linkAttributes() ?>><?php echo $bom->m_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bom->m_grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($bom->m_sgrp->Visible) { // m_sgrp ?>
		<!-- m_sgrp -->
		<td<?php echo $bom->m_sgrp->cellAttributes() ?>>
<span<?php echo $bom->m_sgrp->viewAttributes() ?>>
<?php echo $bom->m_sgrp->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->m_product->Visible) { // m_product ?>
		<!-- m_product -->
		<td<?php echo $bom->m_product->cellAttributes() ?>>
<span<?php echo $bom->m_product->viewAttributes() ?>>
<?php echo $bom->m_product->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->m_rid->Visible) { // m_rid ?>
		<!-- m_rid -->
		<td<?php echo $bom->m_rid->cellAttributes() ?>>
<span<?php echo $bom->m_rid->viewAttributes() ?>>
<?php echo $bom->m_rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->m_packing->Visible) { // m_packing ?>
		<!-- m_packing -->
		<td<?php echo $bom->m_packing->cellAttributes() ?>>
<span<?php echo $bom->m_packing->viewAttributes() ?>>
<?php echo $bom->m_packing->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->quantity_a->Visible) { // quantity_a ?>
		<!-- quantity_a -->
		<td<?php echo $bom->quantity_a->cellAttributes() ?>>
<span<?php echo $bom->quantity_a->viewAttributes() ?>>
<?php echo $bom->quantity_a->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->bom_waste->Visible) { // bom_waste ?>
		<!-- bom_waste -->
		<td<?php echo $bom->bom_waste->cellAttributes() ?>>
<span<?php echo $bom->bom_waste->viewAttributes() ?>>
<?php echo $bom->bom_waste->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->method->Visible) { // method ?>
		<!-- method -->
		<td<?php echo $bom->method->cellAttributes() ?>>
<span<?php echo $bom->method->viewAttributes() ?>>
<?php echo $bom->method->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->unit->Visible) { // unit ?>
		<!-- unit -->
		<td<?php echo $bom->unit->cellAttributes() ?>>
<span<?php echo $bom->unit->viewAttributes() ?>>
<?php echo $bom->unit->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->gross_nett->Visible) { // gross_nett ?>
		<!-- gross_nett -->
		<td<?php echo $bom->gross_nett->cellAttributes() ?>>
<span<?php echo $bom->gross_nett->viewAttributes() ?>>
<?php echo $bom->gross_nett->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->grp->Visible) { // grp ?>
		<!-- grp -->
		<td<?php echo $bom->grp->cellAttributes() ?>>
<span<?php echo $bom->grp->viewAttributes() ?>>
<?php echo $bom->grp->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td<?php echo $bom->s_grp->cellAttributes() ?>>
<span<?php echo $bom->s_grp->viewAttributes() ?>>
<?php echo $bom->s_grp->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $bom->product->cellAttributes() ?>>
<span<?php echo $bom->product->viewAttributes() ?>>
<?php echo $bom->product->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $bom->rid->cellAttributes() ?>>
<span<?php echo $bom->rid->viewAttributes() ?>>
<?php echo $bom->rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td<?php echo $bom->packing_type->cellAttributes() ?>>
<span<?php echo $bom->packing_type->viewAttributes() ?>>
<?php echo $bom->packing_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $bom->operator->cellAttributes() ?>>
<span<?php echo $bom->operator->viewAttributes() ?>>
<?php echo $bom->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $bom->datetime->cellAttributes() ?>>
<span<?php echo $bom->datetime->viewAttributes() ?>>
<?php echo $bom->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->a_operator->Visible) { // a_operator ?>
		<!-- a_operator -->
		<td<?php echo $bom->a_operator->cellAttributes() ?>>
<span<?php echo $bom->a_operator->viewAttributes() ?>>
<?php echo $bom->a_operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($bom->a_datetime->Visible) { // a_datetime ?>
		<!-- a_datetime -->
		<td<?php echo $bom->a_datetime->cellAttributes() ?>>
<span<?php echo $bom->a_datetime->viewAttributes() ?>>
<?php echo $bom->a_datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$bom_preview->ListOptions->render("body", "right", $bom_preview->RowCnt);
?>
	</tr>
<?php
	$bom_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$bom_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$bom_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$bom_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$bom_preview->ListOptions->render("footer", "left");
?>
<?php if ($bom->id->Visible) { // id ?>
		<!-- id -->
		<td class="<?php echo $bom->id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td class="<?php echo $bom->batch_no->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->warp_weft->Visible) { // warp_weft ?>
		<!-- warp_weft -->
		<td class="<?php echo $bom->warp_weft->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->m_grp->Visible) { // m_grp ?>
		<!-- m_grp -->
		<td class="<?php echo $bom->m_grp->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->m_sgrp->Visible) { // m_sgrp ?>
		<!-- m_sgrp -->
		<td class="<?php echo $bom->m_sgrp->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->m_product->Visible) { // m_product ?>
		<!-- m_product -->
		<td class="<?php echo $bom->m_product->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->m_rid->Visible) { // m_rid ?>
		<!-- m_rid -->
		<td class="<?php echo $bom->m_rid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->m_packing->Visible) { // m_packing ?>
		<!-- m_packing -->
		<td class="<?php echo $bom->m_packing->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->quantity_a->Visible) { // quantity_a ?>
		<!-- quantity_a -->
		<td class="<?php echo $bom->quantity_a->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $bom->quantity_a->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($bom->bom_waste->Visible) { // bom_waste ?>
		<!-- bom_waste -->
		<td class="<?php echo $bom->bom_waste->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->method->Visible) { // method ?>
		<!-- method -->
		<td class="<?php echo $bom->method->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->unit->Visible) { // unit ?>
		<!-- unit -->
		<td class="<?php echo $bom->unit->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->gross_nett->Visible) { // gross_nett ?>
		<!-- gross_nett -->
		<td class="<?php echo $bom->gross_nett->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->grp->Visible) { // grp ?>
		<!-- grp -->
		<td class="<?php echo $bom->grp->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td class="<?php echo $bom->s_grp->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->product->Visible) { // product ?>
		<!-- product -->
		<td class="<?php echo $bom->product->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->rid->Visible) { // rid ?>
		<!-- rid -->
		<td class="<?php echo $bom->rid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td class="<?php echo $bom->packing_type->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->operator->Visible) { // operator ?>
		<!-- operator -->
		<td class="<?php echo $bom->operator->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td class="<?php echo $bom->datetime->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->a_operator->Visible) { // a_operator ?>
		<!-- a_operator -->
		<td class="<?php echo $bom->a_operator->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($bom->a_datetime->Visible) { // a_datetime ?>
		<!-- a_datetime -->
		<td class="<?php echo $bom->a_datetime->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$bom_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($bom_preview->TotalRecs > 0) { ?>
<?php if (!isset($bom_preview->Pager)) $bom_preview->Pager = new PrevNextPager($bom_preview->StartRec, $bom_preview->DisplayRecs, $bom_preview->TotalRecs) ?>
<?php if ($bom_preview->Pager->RecordCount > 0 && $bom_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($bom_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $bom_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($bom_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $bom_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($bom_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $bom_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($bom_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $bom_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $bom_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $bom_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $bom_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($bom_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$bom_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($bom_preview->Recordset)
	$bom_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$bom_preview->terminate();
?>