<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bom_search = new bom_search();

// Run the page
$bom_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bom_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($bom_search->IsModal) { ?>
var fbomsearch = currentAdvancedSearchForm = new ew.Form("fbomsearch", "search");
<?php } else { ?>
var fbomsearch = currentForm = new ew.Form("fbomsearch", "search");
<?php } ?>

// Form_CustomValidate event
fbomsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbomsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbomsearch.lists["x_batch_no"] = <?php echo $bom_search->batch_no->Lookup->toClientList() ?>;
fbomsearch.lists["x_batch_no"].options = <?php echo JsonEncode($bom_search->batch_no->lookupOptions()) ?>;
fbomsearch.autoSuggests["x_batch_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbomsearch.lists["x_warp_weft"] = <?php echo $bom_search->warp_weft->Lookup->toClientList() ?>;
fbomsearch.lists["x_warp_weft"].options = <?php echo JsonEncode($bom_search->warp_weft->options(FALSE, TRUE)) ?>;
fbomsearch.lists["x_m_grp"] = <?php echo $bom_search->m_grp->Lookup->toClientList() ?>;
fbomsearch.lists["x_m_grp"].options = <?php echo JsonEncode($bom_search->m_grp->lookupOptions()) ?>;
fbomsearch.lists["x_m_sgrp"] = <?php echo $bom_search->m_sgrp->Lookup->toClientList() ?>;
fbomsearch.lists["x_m_sgrp"].options = <?php echo JsonEncode($bom_search->m_sgrp->lookupOptions()) ?>;
fbomsearch.lists["x_m_product"] = <?php echo $bom_search->m_product->Lookup->toClientList() ?>;
fbomsearch.lists["x_m_product"].options = <?php echo JsonEncode($bom_search->m_product->lookupOptions()) ?>;
fbomsearch.lists["x_m_rid"] = <?php echo $bom_search->m_rid->Lookup->toClientList() ?>;
fbomsearch.lists["x_m_rid"].options = <?php echo JsonEncode($bom_search->m_rid->lookupOptions()) ?>;
fbomsearch.autoSuggests["x_m_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbomsearch.lists["x_m_packing"] = <?php echo $bom_search->m_packing->Lookup->toClientList() ?>;
fbomsearch.lists["x_m_packing"].options = <?php echo JsonEncode($bom_search->m_packing->lookupOptions()) ?>;
fbomsearch.lists["x_method"] = <?php echo $bom_search->method->Lookup->toClientList() ?>;
fbomsearch.lists["x_method"].options = <?php echo JsonEncode($bom_search->method->lookupOptions()) ?>;
fbomsearch.lists["x_unit"] = <?php echo $bom_search->unit->Lookup->toClientList() ?>;
fbomsearch.lists["x_unit"].options = <?php echo JsonEncode($bom_search->unit->lookupOptions()) ?>;
fbomsearch.lists["x_gross_nett"] = <?php echo $bom_search->gross_nett->Lookup->toClientList() ?>;
fbomsearch.lists["x_gross_nett"].options = <?php echo JsonEncode($bom_search->gross_nett->options(FALSE, TRUE)) ?>;
fbomsearch.lists["x_grp"] = <?php echo $bom_search->grp->Lookup->toClientList() ?>;
fbomsearch.lists["x_grp"].options = <?php echo JsonEncode($bom_search->grp->lookupOptions()) ?>;
fbomsearch.lists["x_s_grp"] = <?php echo $bom_search->s_grp->Lookup->toClientList() ?>;
fbomsearch.lists["x_s_grp"].options = <?php echo JsonEncode($bom_search->s_grp->lookupOptions()) ?>;
fbomsearch.lists["x_product"] = <?php echo $bom_search->product->Lookup->toClientList() ?>;
fbomsearch.lists["x_product"].options = <?php echo JsonEncode($bom_search->product->lookupOptions()) ?>;
fbomsearch.lists["x_rid"] = <?php echo $bom_search->rid->Lookup->toClientList() ?>;
fbomsearch.lists["x_rid"].options = <?php echo JsonEncode($bom_search->rid->lookupOptions()) ?>;
fbomsearch.lists["x_packing_type"] = <?php echo $bom_search->packing_type->Lookup->toClientList() ?>;
fbomsearch.lists["x_packing_type"].options = <?php echo JsonEncode($bom_search->packing_type->lookupOptions()) ?>;
fbomsearch.lists["x_operator"] = <?php echo $bom_search->operator->Lookup->toClientList() ?>;
fbomsearch.lists["x_operator"].options = <?php echo JsonEncode($bom_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbomsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom->batch_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_bom_waste");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom->bom_waste->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($bom->quantity->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $bom_search->showPageHeader(); ?>
<?php
$bom_search->showMessage();
?>
<form name="fbomsearch" id="fbomsearch" class="<?php echo $bom_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bom_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bom_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bom">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$bom_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($bom->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_id"><?php echo $bom->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->id->cellAttributes() ?>>
			<span id="el_bom_id">
<input type="text" data-table="bom" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($bom->id->getPlaceHolder()) ?>" value="<?php echo $bom->id->EditValue ?>"<?php echo $bom->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_batch_no"><?php echo $bom->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->batch_no->cellAttributes() ?>>
			<span id="el_bom_batch_no">
<?php
$wrkonchange = "" . trim(@$bom->batch_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom->batch_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_batch_no" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_batch_no" id="sv_x_batch_no" value="<?php echo RemoveHtml($bom->batch_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom->batch_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom->batch_no->getPlaceHolder()) ?>"<?php echo $bom->batch_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="bom" data-field="x_batch_no" data-value-separator="<?php echo $bom->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?php echo HtmlEncode($bom->batch_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbomsearch.createAutoSuggest({"id":"x_batch_no","forceSelect":false});
</script>
<?php echo $bom->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->warp_weft->Visible) { // warp_weft ?>
	<div id="r_warp_weft" class="form-group row">
		<label for="x_warp_weft" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_warp_weft"><?php echo $bom->warp_weft->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_warp_weft" id="z_warp_weft" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->warp_weft->cellAttributes() ?>>
			<span id="el_bom_warp_weft">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_warp_weft" data-value-separator="<?php echo $bom->warp_weft->displayValueSeparatorAttribute() ?>" id="x_warp_weft" name="x_warp_weft"<?php echo $bom->warp_weft->editAttributes() ?>>
		<?php echo $bom->warp_weft->selectOptionListHtml("x_warp_weft") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->m_grp->Visible) { // m_grp ?>
	<div id="r_m_grp" class="form-group row">
		<label for="x_m_grp" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_m_grp"><?php echo $bom->m_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_m_grp" id="z_m_grp" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->m_grp->cellAttributes() ?>>
			<span id="el_bom_m_grp">
<?php $bom->m_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom->m_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_m_grp" data-value-separator="<?php echo $bom->m_grp->displayValueSeparatorAttribute() ?>" id="x_m_grp" name="x_m_grp"<?php echo $bom->m_grp->editAttributes() ?>>
		<?php echo $bom->m_grp->selectOptionListHtml("x_m_grp") ?>
	</select>
</div>
<?php echo $bom->m_grp->Lookup->getParamTag("p_x_m_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->m_sgrp->Visible) { // m_sgrp ?>
	<div id="r_m_sgrp" class="form-group row">
		<label for="x_m_sgrp" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_m_sgrp"><?php echo $bom->m_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_m_sgrp" id="z_m_sgrp" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->m_sgrp->cellAttributes() ?>>
			<span id="el_bom_m_sgrp">
<input type="text" data-table="bom" data-field="x_m_sgrp" name="x_m_sgrp" id="x_m_sgrp" size="30" placeholder="<?php echo HtmlEncode($bom->m_sgrp->getPlaceHolder()) ?>" value="<?php echo $bom->m_sgrp->EditValue ?>"<?php echo $bom->m_sgrp->editAttributes() ?>>
<?php echo $bom->m_sgrp->Lookup->getParamTag("p_x_m_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->m_product->Visible) { // m_product ?>
	<div id="r_m_product" class="form-group row">
		<label for="x_m_product" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_m_product"><?php echo $bom->m_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_m_product" id="z_m_product" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->m_product->cellAttributes() ?>>
			<span id="el_bom_m_product">
<input type="text" data-table="bom" data-field="x_m_product" name="x_m_product" id="x_m_product" size="30" placeholder="<?php echo HtmlEncode($bom->m_product->getPlaceHolder()) ?>" value="<?php echo $bom->m_product->EditValue ?>"<?php echo $bom->m_product->editAttributes() ?>>
<?php echo $bom->m_product->Lookup->getParamTag("p_x_m_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->m_rid->Visible) { // m_rid ?>
	<div id="r_m_rid" class="form-group row">
		<label class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_m_rid"><?php echo $bom->m_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_m_rid" id="z_m_rid" value="LIKE"></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->m_rid->cellAttributes() ?>>
			<span id="el_bom_m_rid">
<?php
$wrkonchange = "" . trim(@$bom->m_rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$bom->m_rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_m_rid" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_m_rid" id="sv_x_m_rid" value="<?php echo RemoveHtml($bom->m_rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($bom->m_rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($bom->m_rid->getPlaceHolder()) ?>"<?php echo $bom->m_rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($bom->m_rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_m_rid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($bom->m_rid->ReadOnly || $bom->m_rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="bom" data-field="x_m_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $bom->m_rid->displayValueSeparatorAttribute() ?>" name="x_m_rid" id="x_m_rid" value="<?php echo HtmlEncode($bom->m_rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbomsearch.createAutoSuggest({"id":"x_m_rid","forceSelect":false});
</script>
<?php echo $bom->m_rid->Lookup->getParamTag("p_x_m_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->m_packing->Visible) { // m_packing ?>
	<div id="r_m_packing" class="form-group row">
		<label for="x_m_packing" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_m_packing"><?php echo $bom->m_packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_m_packing" id="z_m_packing" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->m_packing->cellAttributes() ?>>
			<span id="el_bom_m_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_m_packing" data-value-separator="<?php echo $bom->m_packing->displayValueSeparatorAttribute() ?>" id="x_m_packing" name="x_m_packing"<?php echo $bom->m_packing->editAttributes() ?>>
		<?php echo $bom->m_packing->selectOptionListHtml("x_m_packing") ?>
	</select>
</div>
<?php echo $bom->m_packing->Lookup->getParamTag("p_x_m_packing") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->bom_waste->Visible) { // bom_waste ?>
	<div id="r_bom_waste" class="form-group row">
		<label for="x_bom_waste" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_bom_waste"><?php echo $bom->bom_waste->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_bom_waste" id="z_bom_waste" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->bom_waste->cellAttributes() ?>>
			<span id="el_bom_bom_waste">
<input type="text" data-table="bom" data-field="x_bom_waste" name="x_bom_waste" id="x_bom_waste" size="30" placeholder="<?php echo HtmlEncode($bom->bom_waste->getPlaceHolder()) ?>" value="<?php echo $bom->bom_waste->EditValue ?>"<?php echo $bom->bom_waste->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_quantity"><?php echo $bom->quantity->caption() ?></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->quantity->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_quantity" id="z_quantity" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bom->quantity->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bom_quantity">
<input type="text" data-table="bom" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($bom->quantity->getPlaceHolder()) ?>" value="<?php echo $bom->quantity->EditValue ?>"<?php echo $bom->quantity->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_quantity d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bom_quantity" class="btw1_quantity d-none">
<input type="text" data-table="bom" data-field="x_quantity" name="y_quantity" id="y_quantity" size="30" placeholder="<?php echo HtmlEncode($bom->quantity->getPlaceHolder()) ?>" value="<?php echo $bom->quantity->EditValue2 ?>"<?php echo $bom->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_method"><?php echo $bom->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->method->cellAttributes() ?>>
			<span id="el_bom_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_method" data-value-separator="<?php echo $bom->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $bom->method->editAttributes() ?>>
		<?php echo $bom->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $bom->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_unit"><?php echo $bom->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->unit->cellAttributes() ?>>
			<span id="el_bom_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_unit" data-value-separator="<?php echo $bom->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $bom->unit->editAttributes() ?>>
		<?php echo $bom->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $bom->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->gross_nett->Visible) { // gross_nett ?>
	<div id="r_gross_nett" class="form-group row">
		<label for="x_gross_nett" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_gross_nett"><?php echo $bom->gross_nett->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gross_nett" id="z_gross_nett" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->gross_nett->cellAttributes() ?>>
			<span id="el_bom_gross_nett">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_gross_nett" data-value-separator="<?php echo $bom->gross_nett->displayValueSeparatorAttribute() ?>" id="x_gross_nett" name="x_gross_nett"<?php echo $bom->gross_nett->editAttributes() ?>>
		<?php echo $bom->gross_nett->selectOptionListHtml("x_gross_nett") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_grp"><?php echo $bom->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->grp->cellAttributes() ?>>
			<span id="el_bom_grp">
<?php $bom->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_grp" data-value-separator="<?php echo $bom->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $bom->grp->editAttributes() ?>>
		<?php echo $bom->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $bom->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_s_grp"><?php echo $bom->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->s_grp->cellAttributes() ?>>
			<span id="el_bom_s_grp">
<?php $bom->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_s_grp" data-value-separator="<?php echo $bom->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $bom->s_grp->editAttributes() ?>>
		<?php echo $bom->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $bom->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_product"><?php echo $bom->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->product->cellAttributes() ?>>
			<span id="el_bom_product">
<?php $bom->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$bom->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_product" data-value-separator="<?php echo $bom->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $bom->product->editAttributes() ?>>
		<?php echo $bom->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $bom->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_rid"><?php echo $bom->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->rid->cellAttributes() ?>>
			<span id="el_bom_rid">
<input type="text" data-table="bom" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($bom->rid->getPlaceHolder()) ?>" value="<?php echo $bom->rid->EditValue ?>"<?php echo $bom->rid->editAttributes() ?>>
<?php echo $bom->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_packing_type"><?php echo $bom->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->packing_type->cellAttributes() ?>>
			<span id="el_bom_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_packing_type" data-value-separator="<?php echo $bom->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $bom->packing_type->editAttributes() ?>>
		<?php echo $bom->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $bom->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_operator"><?php echo $bom->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->operator->cellAttributes() ?>>
			<span id="el_bom_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="bom" data-field="x_operator" data-value-separator="<?php echo $bom->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $bom->operator->editAttributes() ?>>
		<?php echo $bom->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $bom->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($bom->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $bom_search->LeftColumnClass ?>"><span id="elh_bom_datetime"><?php echo $bom->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $bom_search->RightColumnClass ?>"><div<?php echo $bom->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($bom->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_bom_datetime">
<input type="text" data-table="bom" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($bom->datetime->getPlaceHolder()) ?>" value="<?php echo $bom->datetime->EditValue ?>"<?php echo $bom->datetime->editAttributes() ?>>
<?php if (!$bom->datetime->ReadOnly && !$bom->datetime->Disabled && !isset($bom->datetime->EditAttrs["readonly"]) && !isset($bom->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbomsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_bom_datetime" class="btw1_datetime d-none">
<input type="text" data-table="bom" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($bom->datetime->getPlaceHolder()) ?>" value="<?php echo $bom->datetime->EditValue2 ?>"<?php echo $bom->datetime->editAttributes() ?>>
<?php if (!$bom->datetime->ReadOnly && !$bom->datetime->Disabled && !isset($bom->datetime->EditAttrs["readonly"]) && !isset($bom->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbomsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$bom_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $bom_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$bom_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$bom_search->terminate();
?>