<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$bom_view = new bom_view();

// Run the page
$bom_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$bom_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$bom->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbomview = currentForm = new ew.Form("fbomview", "view");

// Form_CustomValidate event
fbomview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbomview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbomview.lists["x_batch_no"] = <?php echo $bom_view->batch_no->Lookup->toClientList() ?>;
fbomview.lists["x_batch_no"].options = <?php echo JsonEncode($bom_view->batch_no->lookupOptions()) ?>;
fbomview.autoSuggests["x_batch_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbomview.lists["x_warp_weft"] = <?php echo $bom_view->warp_weft->Lookup->toClientList() ?>;
fbomview.lists["x_warp_weft"].options = <?php echo JsonEncode($bom_view->warp_weft->options(FALSE, TRUE)) ?>;
fbomview.lists["x_m_grp"] = <?php echo $bom_view->m_grp->Lookup->toClientList() ?>;
fbomview.lists["x_m_grp"].options = <?php echo JsonEncode($bom_view->m_grp->lookupOptions()) ?>;
fbomview.lists["x_m_sgrp"] = <?php echo $bom_view->m_sgrp->Lookup->toClientList() ?>;
fbomview.lists["x_m_sgrp"].options = <?php echo JsonEncode($bom_view->m_sgrp->lookupOptions()) ?>;
fbomview.lists["x_m_product"] = <?php echo $bom_view->m_product->Lookup->toClientList() ?>;
fbomview.lists["x_m_product"].options = <?php echo JsonEncode($bom_view->m_product->lookupOptions()) ?>;
fbomview.lists["x_m_rid"] = <?php echo $bom_view->m_rid->Lookup->toClientList() ?>;
fbomview.lists["x_m_rid"].options = <?php echo JsonEncode($bom_view->m_rid->lookupOptions()) ?>;
fbomview.autoSuggests["x_m_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbomview.lists["x_m_packing"] = <?php echo $bom_view->m_packing->Lookup->toClientList() ?>;
fbomview.lists["x_m_packing"].options = <?php echo JsonEncode($bom_view->m_packing->lookupOptions()) ?>;
fbomview.lists["x_method"] = <?php echo $bom_view->method->Lookup->toClientList() ?>;
fbomview.lists["x_method"].options = <?php echo JsonEncode($bom_view->method->lookupOptions()) ?>;
fbomview.lists["x_unit"] = <?php echo $bom_view->unit->Lookup->toClientList() ?>;
fbomview.lists["x_unit"].options = <?php echo JsonEncode($bom_view->unit->lookupOptions()) ?>;
fbomview.lists["x_gross_nett"] = <?php echo $bom_view->gross_nett->Lookup->toClientList() ?>;
fbomview.lists["x_gross_nett"].options = <?php echo JsonEncode($bom_view->gross_nett->options(FALSE, TRUE)) ?>;
fbomview.lists["x_grp"] = <?php echo $bom_view->grp->Lookup->toClientList() ?>;
fbomview.lists["x_grp"].options = <?php echo JsonEncode($bom_view->grp->lookupOptions()) ?>;
fbomview.lists["x_s_grp"] = <?php echo $bom_view->s_grp->Lookup->toClientList() ?>;
fbomview.lists["x_s_grp"].options = <?php echo JsonEncode($bom_view->s_grp->lookupOptions()) ?>;
fbomview.lists["x_product"] = <?php echo $bom_view->product->Lookup->toClientList() ?>;
fbomview.lists["x_product"].options = <?php echo JsonEncode($bom_view->product->lookupOptions()) ?>;
fbomview.lists["x_rid"] = <?php echo $bom_view->rid->Lookup->toClientList() ?>;
fbomview.lists["x_rid"].options = <?php echo JsonEncode($bom_view->rid->lookupOptions()) ?>;
fbomview.lists["x_packing_type"] = <?php echo $bom_view->packing_type->Lookup->toClientList() ?>;
fbomview.lists["x_packing_type"].options = <?php echo JsonEncode($bom_view->packing_type->lookupOptions()) ?>;
fbomview.lists["x_operator"] = <?php echo $bom_view->operator->Lookup->toClientList() ?>;
fbomview.lists["x_operator"].options = <?php echo JsonEncode($bom_view->operator->lookupOptions()) ?>;
fbomview.lists["x_a_operator"] = <?php echo $bom_view->a_operator->Lookup->toClientList() ?>;
fbomview.lists["x_a_operator"].options = <?php echo JsonEncode($bom_view->a_operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$bom->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $bom_view->ExportOptions->render("body") ?>
<?php $bom_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $bom_view->showPageHeader(); ?>
<?php
$bom_view->showMessage();
?>
<form name="fbomview" id="fbomview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($bom_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $bom_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="bom">
<input type="hidden" name="modal" value="<?php echo (int)$bom_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($bom->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_id"><?php echo $bom->id->caption() ?></span></td>
		<td data-name="id"<?php echo $bom->id->cellAttributes() ?>>
<span id="el_bom_id">
<span<?php echo $bom->id->viewAttributes() ?>>
<?php echo $bom->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_batch_no"><?php echo $bom->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $bom->batch_no->cellAttributes() ?>>
<span id="el_bom_batch_no">
<span<?php echo $bom->batch_no->viewAttributes() ?>>
<?php echo $bom->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->warp_weft->Visible) { // warp_weft ?>
	<tr id="r_warp_weft">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_warp_weft"><?php echo $bom->warp_weft->caption() ?></span></td>
		<td data-name="warp_weft"<?php echo $bom->warp_weft->cellAttributes() ?>>
<span id="el_bom_warp_weft">
<span<?php echo $bom->warp_weft->viewAttributes() ?>>
<?php echo $bom->warp_weft->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->m_grp->Visible) { // m_grp ?>
	<tr id="r_m_grp">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_m_grp"><?php echo $bom->m_grp->caption() ?></span></td>
		<td data-name="m_grp"<?php echo $bom->m_grp->cellAttributes() ?>>
<span id="el_bom_m_grp">
<span<?php echo $bom->m_grp->viewAttributes() ?>>
<?php if ((!EmptyString($bom->m_grp->getViewValue())) && $bom->m_grp->linkAttributes() <> "") { ?>
<a<?php echo $bom->m_grp->linkAttributes() ?>><?php echo $bom->m_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $bom->m_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->m_sgrp->Visible) { // m_sgrp ?>
	<tr id="r_m_sgrp">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_m_sgrp"><?php echo $bom->m_sgrp->caption() ?></span></td>
		<td data-name="m_sgrp"<?php echo $bom->m_sgrp->cellAttributes() ?>>
<span id="el_bom_m_sgrp">
<span<?php echo $bom->m_sgrp->viewAttributes() ?>>
<?php echo $bom->m_sgrp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->m_product->Visible) { // m_product ?>
	<tr id="r_m_product">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_m_product"><?php echo $bom->m_product->caption() ?></span></td>
		<td data-name="m_product"<?php echo $bom->m_product->cellAttributes() ?>>
<span id="el_bom_m_product">
<span<?php echo $bom->m_product->viewAttributes() ?>>
<?php echo $bom->m_product->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->m_rid->Visible) { // m_rid ?>
	<tr id="r_m_rid">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_m_rid"><?php echo $bom->m_rid->caption() ?></span></td>
		<td data-name="m_rid"<?php echo $bom->m_rid->cellAttributes() ?>>
<span id="el_bom_m_rid">
<span<?php echo $bom->m_rid->viewAttributes() ?>>
<?php echo $bom->m_rid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->m_packing->Visible) { // m_packing ?>
	<tr id="r_m_packing">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_m_packing"><?php echo $bom->m_packing->caption() ?></span></td>
		<td data-name="m_packing"<?php echo $bom->m_packing->cellAttributes() ?>>
<span id="el_bom_m_packing">
<span<?php echo $bom->m_packing->viewAttributes() ?>>
<?php echo $bom->m_packing->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->m_name->Visible) { // m_name ?>
	<tr id="r_m_name">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_m_name"><?php echo $bom->m_name->caption() ?></span></td>
		<td data-name="m_name"<?php echo $bom->m_name->cellAttributes() ?>>
<span id="el_bom_m_name">
<span<?php echo $bom->m_name->viewAttributes() ?>>
<?php echo $bom->m_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->quantity_a->Visible) { // quantity_a ?>
	<tr id="r_quantity_a">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_quantity_a"><?php echo $bom->quantity_a->caption() ?></span></td>
		<td data-name="quantity_a"<?php echo $bom->quantity_a->cellAttributes() ?>>
<span id="el_bom_quantity_a">
<span<?php echo $bom->quantity_a->viewAttributes() ?>>
<?php echo $bom->quantity_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->bom_waste->Visible) { // bom_waste ?>
	<tr id="r_bom_waste">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_bom_waste"><?php echo $bom->bom_waste->caption() ?></span></td>
		<td data-name="bom_waste"<?php echo $bom->bom_waste->cellAttributes() ?>>
<span id="el_bom_bom_waste">
<span<?php echo $bom->bom_waste->viewAttributes() ?>>
<?php echo $bom->bom_waste->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_quantity"><?php echo $bom->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $bom->quantity->cellAttributes() ?>>
<span id="el_bom_quantity">
<span<?php echo $bom->quantity->viewAttributes() ?>>
<?php echo $bom->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->method->Visible) { // method ?>
	<tr id="r_method">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_method"><?php echo $bom->method->caption() ?></span></td>
		<td data-name="method"<?php echo $bom->method->cellAttributes() ?>>
<span id="el_bom_method">
<span<?php echo $bom->method->viewAttributes() ?>>
<?php echo $bom->method->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->unit->Visible) { // unit ?>
	<tr id="r_unit">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_unit"><?php echo $bom->unit->caption() ?></span></td>
		<td data-name="unit"<?php echo $bom->unit->cellAttributes() ?>>
<span id="el_bom_unit">
<span<?php echo $bom->unit->viewAttributes() ?>>
<?php echo $bom->unit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->gross_nett->Visible) { // gross_nett ?>
	<tr id="r_gross_nett">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_gross_nett"><?php echo $bom->gross_nett->caption() ?></span></td>
		<td data-name="gross_nett"<?php echo $bom->gross_nett->cellAttributes() ?>>
<span id="el_bom_gross_nett">
<span<?php echo $bom->gross_nett->viewAttributes() ?>>
<?php echo $bom->gross_nett->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_grp"><?php echo $bom->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $bom->grp->cellAttributes() ?>>
<span id="el_bom_grp">
<span<?php echo $bom->grp->viewAttributes() ?>>
<?php echo $bom->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_s_grp"><?php echo $bom->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $bom->s_grp->cellAttributes() ?>>
<span id="el_bom_s_grp">
<span<?php echo $bom->s_grp->viewAttributes() ?>>
<?php echo $bom->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_product"><?php echo $bom->product->caption() ?></span></td>
		<td data-name="product"<?php echo $bom->product->cellAttributes() ?>>
<span id="el_bom_product">
<span<?php echo $bom->product->viewAttributes() ?>>
<?php echo $bom->product->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_rid"><?php echo $bom->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $bom->rid->cellAttributes() ?>>
<span id="el_bom_rid">
<span<?php echo $bom->rid->viewAttributes() ?>>
<?php echo $bom->rid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_packing_type"><?php echo $bom->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $bom->packing_type->cellAttributes() ?>>
<span id="el_bom_packing_type">
<span<?php echo $bom->packing_type->viewAttributes() ?>>
<?php echo $bom->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_operator"><?php echo $bom->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $bom->operator->cellAttributes() ?>>
<span id="el_bom_operator">
<span<?php echo $bom->operator->viewAttributes() ?>>
<?php echo $bom->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_datetime"><?php echo $bom->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $bom->datetime->cellAttributes() ?>>
<span id="el_bom_datetime">
<span<?php echo $bom->datetime->viewAttributes() ?>>
<?php echo $bom->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->a_operator->Visible) { // a_operator ?>
	<tr id="r_a_operator">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_a_operator"><?php echo $bom->a_operator->caption() ?></span></td>
		<td data-name="a_operator"<?php echo $bom->a_operator->cellAttributes() ?>>
<span id="el_bom_a_operator">
<span<?php echo $bom->a_operator->viewAttributes() ?>>
<?php echo $bom->a_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->a_datetime->Visible) { // a_datetime ?>
	<tr id="r_a_datetime">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_a_datetime"><?php echo $bom->a_datetime->caption() ?></span></td>
		<td data-name="a_datetime"<?php echo $bom->a_datetime->cellAttributes() ?>>
<span id="el_bom_a_datetime">
<span<?php echo $bom->a_datetime->viewAttributes() ?>>
<?php echo $bom->a_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->pp_qty->Visible) { // pp_qty ?>
	<tr id="r_pp_qty">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_pp_qty"><?php echo $bom->pp_qty->caption() ?></span></td>
		<td data-name="pp_qty"<?php echo $bom->pp_qty->cellAttributes() ?>>
<span id="el_bom_pp_qty">
<span<?php echo $bom->pp_qty->viewAttributes() ?>>
<?php echo $bom->pp_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->pp_bal->Visible) { // pp_bal ?>
	<tr id="r_pp_bal">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_pp_bal"><?php echo $bom->pp_bal->caption() ?></span></td>
		<td data-name="pp_bal"<?php echo $bom->pp_bal->cellAttributes() ?>>
<span id="el_bom_pp_bal">
<span<?php echo $bom->pp_bal->viewAttributes() ?>>
<?php echo $bom->pp_bal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($bom->pp_id->Visible) { // pp_id ?>
	<tr id="r_pp_id">
		<td class="<?php echo $bom_view->TableLeftColumnClass ?>"><span id="elh_bom_pp_id"><?php echo $bom->pp_id->caption() ?></span></td>
		<td data-name="pp_id"<?php echo $bom->pp_id->cellAttributes() ?>>
<span id="el_bom_pp_id">
<span<?php echo $bom->pp_id->viewAttributes() ?>>
<?php echo $bom->pp_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$bom_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$bom->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$bom_view->terminate();
?>