<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_details_list = new booking_details_list();

// Run the page
$booking_details_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_details_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$booking_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbooking_detailslist = currentForm = new ew.Form("fbooking_detailslist", "list");
fbooking_detailslist.formKeyCountName = '<?php echo $booking_details_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbooking_detailslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbooking_detailslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fbooking_detailslistsrch = currentSearchForm = new ew.Form("fbooking_detailslistsrch");

// Filters
fbooking_detailslistsrch.filterList = <?php echo $booking_details_list->getFilterList() ?>;

// Init search panel as collapsed
fbooking_detailslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$booking_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($booking_details_list->TotalRecs > 0 && $booking_details_list->ExportOptions->visible()) { ?>
<?php $booking_details_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($booking_details_list->ImportOptions->visible()) { ?>
<?php $booking_details_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($booking_details_list->SearchOptions->visible()) { ?>
<?php $booking_details_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($booking_details_list->FilterOptions->visible()) { ?>
<?php $booking_details_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$booking_details_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$booking_details->isExport() && !$booking_details->CurrentAction) { ?>
<form name="fbooking_detailslistsrch" id="fbooking_detailslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($booking_details_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbooking_detailslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="booking_details">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($booking_details_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($booking_details_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $booking_details_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($booking_details_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($booking_details_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($booking_details_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($booking_details_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $booking_details_list->showPageHeader(); ?>
<?php
$booking_details_list->showMessage();
?>
<?php if ($booking_details_list->TotalRecs > 0 || $booking_details->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($booking_details_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> booking_details">
<?php if (!$booking_details->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$booking_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($booking_details_list->Pager)) $booking_details_list->Pager = new PrevNextPager($booking_details_list->StartRec, $booking_details_list->DisplayRecs, $booking_details_list->TotalRecs, $booking_details_list->AutoHidePager) ?>
<?php if ($booking_details_list->Pager->RecordCount > 0 && $booking_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($booking_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($booking_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $booking_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($booking_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($booking_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $booking_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($booking_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $booking_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $booking_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $booking_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($booking_details_list->TotalRecs > 0 && (!$booking_details_list->AutoHidePageSizeSelector || $booking_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="booking_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($booking_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($booking_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($booking_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($booking_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($booking_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($booking_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $booking_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbooking_detailslist" id="fbooking_detailslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_details_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_details_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking_details">
<div id="gmp_booking_details" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($booking_details_list->TotalRecs > 0 || $booking_details->isGridEdit()) { ?>
<table id="tbl_booking_detailslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$booking_details_list->RowType = ROWTYPE_HEADER;

// Render list options
$booking_details_list->renderListOptions();

// Render list options (header, left)
$booking_details_list->ListOptions->render("header", "left");
?>
<?php if ($booking_details->ref->Visible) { // ref ?>
	<?php if ($booking_details->sortUrl($booking_details->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $booking_details->ref->headerCellClass() ?>"><div id="elh_booking_details_ref" class="booking_details_ref"><div class="ew-table-header-caption"><?php echo $booking_details->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $booking_details->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->ref) ?>',2);"><div id="elh_booking_details_ref" class="booking_details_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking_details->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->agent->Visible) { // agent ?>
	<?php if ($booking_details->sortUrl($booking_details->agent) == "") { ?>
		<th data-name="agent" class="<?php echo $booking_details->agent->headerCellClass() ?>"><div id="elh_booking_details_agent" class="booking_details_agent"><div class="ew-table-header-caption"><?php echo $booking_details->agent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="agent" class="<?php echo $booking_details->agent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->agent) ?>',2);"><div id="elh_booking_details_agent" class="booking_details_agent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->agent->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->agent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->agent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->supplier->Visible) { // supplier ?>
	<?php if ($booking_details->sortUrl($booking_details->supplier) == "") { ?>
		<th data-name="supplier" class="<?php echo $booking_details->supplier->headerCellClass() ?>"><div id="elh_booking_details_supplier" class="booking_details_supplier"><div class="ew-table-header-caption"><?php echo $booking_details->supplier->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="supplier" class="<?php echo $booking_details->supplier->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->supplier) ?>',2);"><div id="elh_booking_details_supplier" class="booking_details_supplier">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->supplier->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->supplier->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->supplier->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->quantity->Visible) { // quantity ?>
	<?php if ($booking_details->sortUrl($booking_details->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $booking_details->quantity->headerCellClass() ?>"><div id="elh_booking_details_quantity" class="booking_details_quantity"><div class="ew-table-header-caption"><?php echo $booking_details->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $booking_details->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->quantity) ?>',2);"><div id="elh_booking_details_quantity" class="booking_details_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->b_quantity->Visible) { // b_quantity ?>
	<?php if ($booking_details->sortUrl($booking_details->b_quantity) == "") { ?>
		<th data-name="b_quantity" class="<?php echo $booking_details->b_quantity->headerCellClass() ?>"><div id="elh_booking_details_b_quantity" class="booking_details_b_quantity"><div class="ew-table-header-caption"><?php echo $booking_details->b_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_quantity" class="<?php echo $booking_details->b_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->b_quantity) ?>',2);"><div id="elh_booking_details_b_quantity" class="booking_details_b_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->b_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->b_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->b_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->confirm_quantity->Visible) { // confirm_quantity ?>
	<?php if ($booking_details->sortUrl($booking_details->confirm_quantity) == "") { ?>
		<th data-name="confirm_quantity" class="<?php echo $booking_details->confirm_quantity->headerCellClass() ?>"><div id="elh_booking_details_confirm_quantity" class="booking_details_confirm_quantity"><div class="ew-table-header-caption"><?php echo $booking_details->confirm_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="confirm_quantity" class="<?php echo $booking_details->confirm_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->confirm_quantity) ?>',2);"><div id="elh_booking_details_confirm_quantity" class="booking_details_confirm_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->confirm_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->confirm_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->confirm_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->containers->Visible) { // containers ?>
	<?php if ($booking_details->sortUrl($booking_details->containers) == "") { ?>
		<th data-name="containers" class="<?php echo $booking_details->containers->headerCellClass() ?>"><div id="elh_booking_details_containers" class="booking_details_containers"><div class="ew-table-header-caption"><?php echo $booking_details->containers->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="containers" class="<?php echo $booking_details->containers->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->containers) ?>',2);"><div id="elh_booking_details_containers" class="booking_details_containers">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->containers->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->containers->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->containers->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->booking_currency->Visible) { // booking_currency ?>
	<?php if ($booking_details->sortUrl($booking_details->booking_currency) == "") { ?>
		<th data-name="booking_currency" class="<?php echo $booking_details->booking_currency->headerCellClass() ?>"><div id="elh_booking_details_booking_currency" class="booking_details_booking_currency"><div class="ew-table-header-caption"><?php echo $booking_details->booking_currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="booking_currency" class="<?php echo $booking_details->booking_currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->booking_currency) ?>',2);"><div id="elh_booking_details_booking_currency" class="booking_details_booking_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->booking_currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->booking_currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->booking_currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->amount->Visible) { // amount ?>
	<?php if ($booking_details->sortUrl($booking_details->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $booking_details->amount->headerCellClass() ?>"><div id="elh_booking_details_amount" class="booking_details_amount"><div class="ew-table-header-caption"><?php echo $booking_details->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $booking_details->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->amount) ?>',2);"><div id="elh_booking_details_amount" class="booking_details_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->paid->Visible) { // paid ?>
	<?php if ($booking_details->sortUrl($booking_details->paid) == "") { ?>
		<th data-name="paid" class="<?php echo $booking_details->paid->headerCellClass() ?>"><div id="elh_booking_details_paid" class="booking_details_paid"><div class="ew-table-header-caption"><?php echo $booking_details->paid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="paid" class="<?php echo $booking_details->paid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->paid) ?>',2);"><div id="elh_booking_details_paid" class="booking_details_paid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->paid->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->paid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->paid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->balance->Visible) { // balance ?>
	<?php if ($booking_details->sortUrl($booking_details->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $booking_details->balance->headerCellClass() ?>"><div id="elh_booking_details_balance" class="booking_details_balance"><div class="ew-table-header-caption"><?php echo $booking_details->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $booking_details->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->balance) ?>',2);"><div id="elh_booking_details_balance" class="booking_details_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->remarks->Visible) { // remarks ?>
	<?php if ($booking_details->sortUrl($booking_details->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $booking_details->remarks->headerCellClass() ?>"><div id="elh_booking_details_remarks" class="booking_details_remarks"><div class="ew-table-header-caption"><?php echo $booking_details->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $booking_details->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->remarks) ?>',2);"><div id="elh_booking_details_remarks" class="booking_details_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking_details->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_details->status->Visible) { // status ?>
	<?php if ($booking_details->sortUrl($booking_details->status) == "") { ?>
		<th data-name="status" class="<?php echo $booking_details->status->headerCellClass() ?>"><div id="elh_booking_details_status" class="booking_details_status"><div class="ew-table-header-caption"><?php echo $booking_details->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $booking_details->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_details->SortUrl($booking_details->status) ?>',2);"><div id="elh_booking_details_status" class="booking_details_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_details->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_details->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_details->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$booking_details_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($booking_details->ExportAll && $booking_details->isExport()) {
	$booking_details_list->StopRec = $booking_details_list->TotalRecs;
} else {

	// Set the last record to display
	if ($booking_details_list->TotalRecs > $booking_details_list->StartRec + $booking_details_list->DisplayRecs - 1)
		$booking_details_list->StopRec = $booking_details_list->StartRec + $booking_details_list->DisplayRecs - 1;
	else
		$booking_details_list->StopRec = $booking_details_list->TotalRecs;
}
$booking_details_list->RecCnt = $booking_details_list->StartRec - 1;
if ($booking_details_list->Recordset && !$booking_details_list->Recordset->EOF) {
	$booking_details_list->Recordset->moveFirst();
	$selectLimit = $booking_details_list->UseSelectLimit;
	if (!$selectLimit && $booking_details_list->StartRec > 1)
		$booking_details_list->Recordset->move($booking_details_list->StartRec - 1);
} elseif (!$booking_details->AllowAddDeleteRow && $booking_details_list->StopRec == 0) {
	$booking_details_list->StopRec = $booking_details->GridAddRowCount;
}

// Initialize aggregate
$booking_details->RowType = ROWTYPE_AGGREGATEINIT;
$booking_details->resetAttributes();
$booking_details_list->renderRow();
while ($booking_details_list->RecCnt < $booking_details_list->StopRec) {
	$booking_details_list->RecCnt++;
	if ($booking_details_list->RecCnt >= $booking_details_list->StartRec) {
		$booking_details_list->RowCnt++;

		// Set up key count
		$booking_details_list->KeyCount = $booking_details_list->RowIndex;

		// Init row class and style
		$booking_details->resetAttributes();
		$booking_details->CssClass = "";
		if ($booking_details->isGridAdd()) {
		} else {
			$booking_details_list->loadRowValues($booking_details_list->Recordset); // Load row values
		}
		$booking_details->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$booking_details->RowAttrs = array_merge($booking_details->RowAttrs, array('data-rowindex'=>$booking_details_list->RowCnt, 'id'=>'r' . $booking_details_list->RowCnt . '_booking_details', 'data-rowtype'=>$booking_details->RowType));

		// Render row
		$booking_details_list->renderRow();

		// Render list options
		$booking_details_list->renderListOptions();
?>
	<tr<?php echo $booking_details->rowAttributes() ?>>
<?php

// Render list options (body, left)
$booking_details_list->ListOptions->render("body", "left", $booking_details_list->RowCnt);
?>
	<?php if ($booking_details->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $booking_details->ref->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_ref" class="booking_details_ref">
<span<?php echo $booking_details->ref->viewAttributes() ?>>
<?php echo $booking_details->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->agent->Visible) { // agent ?>
		<td data-name="agent"<?php echo $booking_details->agent->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_agent" class="booking_details_agent">
<span<?php echo $booking_details->agent->viewAttributes() ?>>
<?php echo $booking_details->agent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->supplier->Visible) { // supplier ?>
		<td data-name="supplier"<?php echo $booking_details->supplier->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_supplier" class="booking_details_supplier">
<span<?php echo $booking_details->supplier->viewAttributes() ?>>
<?php echo $booking_details->supplier->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $booking_details->quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_quantity" class="booking_details_quantity">
<span<?php echo $booking_details->quantity->viewAttributes() ?>>
<?php echo $booking_details->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->b_quantity->Visible) { // b_quantity ?>
		<td data-name="b_quantity"<?php echo $booking_details->b_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_b_quantity" class="booking_details_b_quantity">
<span<?php echo $booking_details->b_quantity->viewAttributes() ?>>
<?php echo $booking_details->b_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->confirm_quantity->Visible) { // confirm_quantity ?>
		<td data-name="confirm_quantity"<?php echo $booking_details->confirm_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_confirm_quantity" class="booking_details_confirm_quantity">
<span<?php echo $booking_details->confirm_quantity->viewAttributes() ?>>
<?php echo $booking_details->confirm_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->containers->Visible) { // containers ?>
		<td data-name="containers"<?php echo $booking_details->containers->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_containers" class="booking_details_containers">
<span<?php echo $booking_details->containers->viewAttributes() ?>>
<?php echo $booking_details->containers->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->booking_currency->Visible) { // booking_currency ?>
		<td data-name="booking_currency"<?php echo $booking_details->booking_currency->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_booking_currency" class="booking_details_booking_currency">
<span<?php echo $booking_details->booking_currency->viewAttributes() ?>>
<?php echo $booking_details->booking_currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $booking_details->amount->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_amount" class="booking_details_amount">
<span<?php echo $booking_details->amount->viewAttributes() ?>>
<?php echo $booking_details->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->paid->Visible) { // paid ?>
		<td data-name="paid"<?php echo $booking_details->paid->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_paid" class="booking_details_paid">
<span<?php echo $booking_details->paid->viewAttributes() ?>>
<?php echo $booking_details->paid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $booking_details->balance->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_balance" class="booking_details_balance">
<span<?php echo $booking_details->balance->viewAttributes() ?>>
<?php echo $booking_details->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $booking_details->remarks->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_remarks" class="booking_details_remarks">
<span<?php echo $booking_details->remarks->viewAttributes() ?>>
<?php echo $booking_details->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_details->status->Visible) { // status ?>
		<td data-name="status"<?php echo $booking_details->status->cellAttributes() ?>>
<span id="el<?php echo $booking_details_list->RowCnt ?>_booking_details_status" class="booking_details_status">
<span<?php echo $booking_details->status->viewAttributes() ?>>
<?php echo $booking_details->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$booking_details_list->ListOptions->render("body", "right", $booking_details_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$booking_details->isGridAdd())
		$booking_details_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$booking_details->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($booking_details_list->Recordset)
	$booking_details_list->Recordset->Close();
?>
<?php if (!$booking_details->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$booking_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($booking_details_list->Pager)) $booking_details_list->Pager = new PrevNextPager($booking_details_list->StartRec, $booking_details_list->DisplayRecs, $booking_details_list->TotalRecs, $booking_details_list->AutoHidePager) ?>
<?php if ($booking_details_list->Pager->RecordCount > 0 && $booking_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($booking_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($booking_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $booking_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($booking_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($booking_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $booking_details_list->pageUrl() ?>start=<?php echo $booking_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $booking_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($booking_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $booking_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $booking_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $booking_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($booking_details_list->TotalRecs > 0 && (!$booking_details_list->AutoHidePageSizeSelector || $booking_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="booking_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($booking_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($booking_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($booking_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($booking_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($booking_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($booking_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $booking_details_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($booking_details_list->TotalRecs == 0 && !$booking_details->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $booking_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$booking_details_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$booking_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$booking_details_list->terminate();
?>