<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_ref_list = new booking_ref_list();

// Run the page
$booking_ref_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_ref_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$booking_ref->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbooking_reflist = currentForm = new ew.Form("fbooking_reflist", "list");
fbooking_reflist.formKeyCountName = '<?php echo $booking_ref_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbooking_reflist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbooking_reflist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbooking_reflist.lists["x_rid"] = <?php echo $booking_ref_list->rid->Lookup->toClientList() ?>;
fbooking_reflist.lists["x_rid"].options = <?php echo JsonEncode($booking_ref_list->rid->lookupOptions()) ?>;
fbooking_reflist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbooking_reflist.lists["x_operator"] = <?php echo $booking_ref_list->operator->Lookup->toClientList() ?>;
fbooking_reflist.lists["x_operator"].options = <?php echo JsonEncode($booking_ref_list->operator->lookupOptions()) ?>;
fbooking_reflist.lists["x_status"] = <?php echo $booking_ref_list->status->Lookup->toClientList() ?>;
fbooking_reflist.lists["x_status"].options = <?php echo JsonEncode($booking_ref_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fbooking_reflistsrch = currentSearchForm = new ew.Form("fbooking_reflistsrch");

// Validate function for search
fbooking_reflistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->rid->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbooking_reflistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbooking_reflistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbooking_reflistsrch.lists["x_rid"] = <?php echo $booking_ref_list->rid->Lookup->toClientList() ?>;
fbooking_reflistsrch.lists["x_rid"].options = <?php echo JsonEncode($booking_ref_list->rid->lookupOptions()) ?>;
fbooking_reflistsrch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fbooking_reflistsrch.filterList = <?php echo $booking_ref_list->getFilterList() ?>;

// Init search panel as collapsed
fbooking_reflistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$booking_ref->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($booking_ref_list->TotalRecs > 0 && $booking_ref_list->ExportOptions->visible()) { ?>
<?php $booking_ref_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($booking_ref_list->ImportOptions->visible()) { ?>
<?php $booking_ref_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($booking_ref_list->SearchOptions->visible()) { ?>
<?php $booking_ref_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($booking_ref_list->FilterOptions->visible()) { ?>
<?php $booking_ref_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$booking_ref_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$booking_ref->isExport() && !$booking_ref->CurrentAction) { ?>
<form name="fbooking_reflistsrch" id="fbooking_reflistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($booking_ref_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbooking_reflistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="booking_ref">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$booking_ref_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$booking_ref->RowType = ROWTYPE_SEARCH;

// Render row
$booking_ref->resetAttributes();
$booking_ref_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($booking_ref->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $booking_ref->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$booking_ref->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$booking_ref->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($booking_ref->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($booking_ref->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($booking_ref->rid->getPlaceHolder()) ?>"<?php echo $booking_ref->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_rid" data-value-separator="<?php echo $booking_ref->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($booking_ref->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbooking_reflistsrch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $booking_ref->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($booking_ref_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($booking_ref_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $booking_ref_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($booking_ref_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($booking_ref_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($booking_ref_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($booking_ref_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $booking_ref_list->showPageHeader(); ?>
<?php
$booking_ref_list->showMessage();
?>
<?php if ($booking_ref_list->TotalRecs > 0 || $booking_ref->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($booking_ref_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> booking_ref">
<?php if (!$booking_ref->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$booking_ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($booking_ref_list->Pager)) $booking_ref_list->Pager = new PrevNextPager($booking_ref_list->StartRec, $booking_ref_list->DisplayRecs, $booking_ref_list->TotalRecs, $booking_ref_list->AutoHidePager) ?>
<?php if ($booking_ref_list->Pager->RecordCount > 0 && $booking_ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($booking_ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($booking_ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $booking_ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($booking_ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($booking_ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $booking_ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($booking_ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $booking_ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $booking_ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $booking_ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($booking_ref_list->TotalRecs > 0 && (!$booking_ref_list->AutoHidePageSizeSelector || $booking_ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="booking_ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($booking_ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($booking_ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($booking_ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($booking_ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($booking_ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($booking_ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $booking_ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbooking_reflist" id="fbooking_reflist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_ref_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_ref_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking_ref">
<div id="gmp_booking_ref" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($booking_ref_list->TotalRecs > 0 || $booking_ref->isGridEdit()) { ?>
<table id="tbl_booking_reflist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$booking_ref_list->RowType = ROWTYPE_HEADER;

// Render list options
$booking_ref_list->renderListOptions();

// Render list options (header, left)
$booking_ref_list->ListOptions->render("header", "left");
?>
<?php if ($booking_ref->id->Visible) { // id ?>
	<?php if ($booking_ref->sortUrl($booking_ref->id) == "") { ?>
		<th data-name="id" class="<?php echo $booking_ref->id->headerCellClass() ?>"><div id="elh_booking_ref_id" class="booking_ref_id"><div class="ew-table-header-caption"><?php echo $booking_ref->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $booking_ref->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->id) ?>',2);"><div id="elh_booking_ref_id" class="booking_ref_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->ref->Visible) { // ref ?>
	<?php if ($booking_ref->sortUrl($booking_ref->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $booking_ref->ref->headerCellClass() ?>"><div id="elh_booking_ref_ref" class="booking_ref_ref"><div class="ew-table-header-caption"><?php echo $booking_ref->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $booking_ref->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->ref) ?>',2);"><div id="elh_booking_ref_ref" class="booking_ref_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->rid->Visible) { // rid ?>
	<?php if ($booking_ref->sortUrl($booking_ref->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $booking_ref->rid->headerCellClass() ?>"><div id="elh_booking_ref_rid" class="booking_ref_rid"><div class="ew-table-header-caption"><?php echo $booking_ref->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $booking_ref->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->rid) ?>',2);"><div id="elh_booking_ref_rid" class="booking_ref_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->quantity->Visible) { // quantity ?>
	<?php if ($booking_ref->sortUrl($booking_ref->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $booking_ref->quantity->headerCellClass() ?>"><div id="elh_booking_ref_quantity" class="booking_ref_quantity"><div class="ew-table-header-caption"><?php echo $booking_ref->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $booking_ref->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->quantity) ?>',2);"><div id="elh_booking_ref_quantity" class="booking_ref_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->b_quantity->Visible) { // b_quantity ?>
	<?php if ($booking_ref->sortUrl($booking_ref->b_quantity) == "") { ?>
		<th data-name="b_quantity" class="<?php echo $booking_ref->b_quantity->headerCellClass() ?>"><div id="elh_booking_ref_b_quantity" class="booking_ref_b_quantity"><div class="ew-table-header-caption"><?php echo $booking_ref->b_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_quantity" class="<?php echo $booking_ref->b_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->b_quantity) ?>',2);"><div id="elh_booking_ref_b_quantity" class="booking_ref_b_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->b_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->b_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->b_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->booking_date->Visible) { // booking_date ?>
	<?php if ($booking_ref->sortUrl($booking_ref->booking_date) == "") { ?>
		<th data-name="booking_date" class="<?php echo $booking_ref->booking_date->headerCellClass() ?>"><div id="elh_booking_ref_booking_date" class="booking_ref_booking_date"><div class="ew-table-header-caption"><?php echo $booking_ref->booking_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="booking_date" class="<?php echo $booking_ref->booking_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->booking_date) ?>',2);"><div id="elh_booking_ref_booking_date" class="booking_ref_booking_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->booking_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->booking_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->booking_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->booking_rate->Visible) { // booking_rate ?>
	<?php if ($booking_ref->sortUrl($booking_ref->booking_rate) == "") { ?>
		<th data-name="booking_rate" class="<?php echo $booking_ref->booking_rate->headerCellClass() ?>"><div id="elh_booking_ref_booking_rate" class="booking_ref_booking_rate"><div class="ew-table-header-caption"><?php echo $booking_ref->booking_rate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="booking_rate" class="<?php echo $booking_ref->booking_rate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->booking_rate) ?>',2);"><div id="elh_booking_ref_booking_rate" class="booking_ref_booking_rate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->booking_rate->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->booking_rate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->booking_rate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->currency_current_rate->Visible) { // currency_current_rate ?>
	<?php if ($booking_ref->sortUrl($booking_ref->currency_current_rate) == "") { ?>
		<th data-name="currency_current_rate" class="<?php echo $booking_ref->currency_current_rate->headerCellClass() ?>"><div id="elh_booking_ref_currency_current_rate" class="booking_ref_currency_current_rate"><div class="ew-table-header-caption"><?php echo $booking_ref->currency_current_rate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency_current_rate" class="<?php echo $booking_ref->currency_current_rate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->currency_current_rate) ?>',2);"><div id="elh_booking_ref_currency_current_rate" class="booking_ref_currency_current_rate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->currency_current_rate->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->currency_current_rate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->currency_current_rate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->shipment_date->Visible) { // shipment_date ?>
	<?php if ($booking_ref->sortUrl($booking_ref->shipment_date) == "") { ?>
		<th data-name="shipment_date" class="<?php echo $booking_ref->shipment_date->headerCellClass() ?>"><div id="elh_booking_ref_shipment_date" class="booking_ref_shipment_date"><div class="ew-table-header-caption"><?php echo $booking_ref->shipment_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipment_date" class="<?php echo $booking_ref->shipment_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->shipment_date) ?>',2);"><div id="elh_booking_ref_shipment_date" class="booking_ref_shipment_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->shipment_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->shipment_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->shipment_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->operator->Visible) { // operator ?>
	<?php if ($booking_ref->sortUrl($booking_ref->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $booking_ref->operator->headerCellClass() ?>"><div id="elh_booking_ref_operator" class="booking_ref_operator"><div class="ew-table-header-caption"><?php echo $booking_ref->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $booking_ref->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->operator) ?>',2);"><div id="elh_booking_ref_operator" class="booking_ref_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->datetime->Visible) { // datetime ?>
	<?php if ($booking_ref->sortUrl($booking_ref->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $booking_ref->datetime->headerCellClass() ?>"><div id="elh_booking_ref_datetime" class="booking_ref_datetime"><div class="ew-table-header-caption"><?php echo $booking_ref->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $booking_ref->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->datetime) ?>',2);"><div id="elh_booking_ref_datetime" class="booking_ref_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->remarks->Visible) { // remarks ?>
	<?php if ($booking_ref->sortUrl($booking_ref->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $booking_ref->remarks->headerCellClass() ?>"><div id="elh_booking_ref_remarks" class="booking_ref_remarks"><div class="ew-table-header-caption"><?php echo $booking_ref->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $booking_ref->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->remarks) ?>',2);"><div id="elh_booking_ref_remarks" class="booking_ref_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->status->Visible) { // status ?>
	<?php if ($booking_ref->sortUrl($booking_ref->status) == "") { ?>
		<th data-name="status" class="<?php echo $booking_ref->status->headerCellClass() ?>"><div id="elh_booking_ref_status" class="booking_ref_status"><div class="ew-table-header-caption"><?php echo $booking_ref->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $booking_ref->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->status) ?>',2);"><div id="elh_booking_ref_status" class="booking_ref_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->confirm_type->Visible) { // confirm_type ?>
	<?php if ($booking_ref->sortUrl($booking_ref->confirm_type) == "") { ?>
		<th data-name="confirm_type" class="<?php echo $booking_ref->confirm_type->headerCellClass() ?>"><div id="elh_booking_ref_confirm_type" class="booking_ref_confirm_type"><div class="ew-table-header-caption"><?php echo $booking_ref->confirm_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="confirm_type" class="<?php echo $booking_ref->confirm_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->confirm_type) ?>',2);"><div id="elh_booking_ref_confirm_type" class="booking_ref_confirm_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->confirm_type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->confirm_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->confirm_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->confirm_quantity->Visible) { // confirm_quantity ?>
	<?php if ($booking_ref->sortUrl($booking_ref->confirm_quantity) == "") { ?>
		<th data-name="confirm_quantity" class="<?php echo $booking_ref->confirm_quantity->headerCellClass() ?>"><div id="elh_booking_ref_confirm_quantity" class="booking_ref_confirm_quantity"><div class="ew-table-header-caption"><?php echo $booking_ref->confirm_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="confirm_quantity" class="<?php echo $booking_ref->confirm_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->confirm_quantity) ?>',2);"><div id="elh_booking_ref_confirm_quantity" class="booking_ref_confirm_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->confirm_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->confirm_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->confirm_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->confirm_pending->Visible) { // confirm_pending ?>
	<?php if ($booking_ref->sortUrl($booking_ref->confirm_pending) == "") { ?>
		<th data-name="confirm_pending" class="<?php echo $booking_ref->confirm_pending->headerCellClass() ?>"><div id="elh_booking_ref_confirm_pending" class="booking_ref_confirm_pending"><div class="ew-table-header-caption"><?php echo $booking_ref->confirm_pending->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="confirm_pending" class="<?php echo $booking_ref->confirm_pending->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->confirm_pending) ?>',2);"><div id="elh_booking_ref_confirm_pending" class="booking_ref_confirm_pending">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->confirm_pending->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->confirm_pending->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->confirm_pending->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->amount->Visible) { // amount ?>
	<?php if ($booking_ref->sortUrl($booking_ref->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $booking_ref->amount->headerCellClass() ?>"><div id="elh_booking_ref_amount" class="booking_ref_amount"><div class="ew-table-header-caption"><?php echo $booking_ref->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $booking_ref->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->amount) ?>',2);"><div id="elh_booking_ref_amount" class="booking_ref_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking_ref->packets->Visible) { // packets ?>
	<?php if ($booking_ref->sortUrl($booking_ref->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $booking_ref->packets->headerCellClass() ?>"><div id="elh_booking_ref_packets" class="booking_ref_packets"><div class="ew-table-header-caption"><?php echo $booking_ref->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $booking_ref->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking_ref->SortUrl($booking_ref->packets) ?>',2);"><div id="elh_booking_ref_packets" class="booking_ref_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking_ref->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking_ref->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking_ref->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$booking_ref_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($booking_ref->ExportAll && $booking_ref->isExport()) {
	$booking_ref_list->StopRec = $booking_ref_list->TotalRecs;
} else {

	// Set the last record to display
	if ($booking_ref_list->TotalRecs > $booking_ref_list->StartRec + $booking_ref_list->DisplayRecs - 1)
		$booking_ref_list->StopRec = $booking_ref_list->StartRec + $booking_ref_list->DisplayRecs - 1;
	else
		$booking_ref_list->StopRec = $booking_ref_list->TotalRecs;
}
$booking_ref_list->RecCnt = $booking_ref_list->StartRec - 1;
if ($booking_ref_list->Recordset && !$booking_ref_list->Recordset->EOF) {
	$booking_ref_list->Recordset->moveFirst();
	$selectLimit = $booking_ref_list->UseSelectLimit;
	if (!$selectLimit && $booking_ref_list->StartRec > 1)
		$booking_ref_list->Recordset->move($booking_ref_list->StartRec - 1);
} elseif (!$booking_ref->AllowAddDeleteRow && $booking_ref_list->StopRec == 0) {
	$booking_ref_list->StopRec = $booking_ref->GridAddRowCount;
}

// Initialize aggregate
$booking_ref->RowType = ROWTYPE_AGGREGATEINIT;
$booking_ref->resetAttributes();
$booking_ref_list->renderRow();
while ($booking_ref_list->RecCnt < $booking_ref_list->StopRec) {
	$booking_ref_list->RecCnt++;
	if ($booking_ref_list->RecCnt >= $booking_ref_list->StartRec) {
		$booking_ref_list->RowCnt++;

		// Set up key count
		$booking_ref_list->KeyCount = $booking_ref_list->RowIndex;

		// Init row class and style
		$booking_ref->resetAttributes();
		$booking_ref->CssClass = "";
		if ($booking_ref->isGridAdd()) {
		} else {
			$booking_ref_list->loadRowValues($booking_ref_list->Recordset); // Load row values
		}
		$booking_ref->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$booking_ref->RowAttrs = array_merge($booking_ref->RowAttrs, array('data-rowindex'=>$booking_ref_list->RowCnt, 'id'=>'r' . $booking_ref_list->RowCnt . '_booking_ref', 'data-rowtype'=>$booking_ref->RowType));

		// Render row
		$booking_ref_list->renderRow();

		// Render list options
		$booking_ref_list->renderListOptions();
?>
	<tr<?php echo $booking_ref->rowAttributes() ?>>
<?php

// Render list options (body, left)
$booking_ref_list->ListOptions->render("body", "left", $booking_ref_list->RowCnt);
?>
	<?php if ($booking_ref->id->Visible) { // id ?>
		<td data-name="id"<?php echo $booking_ref->id->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_id" class="booking_ref_id">
<span<?php echo $booking_ref->id->viewAttributes() ?>>
<?php echo $booking_ref->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $booking_ref->ref->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_ref" class="booking_ref_ref">
<span<?php echo $booking_ref->ref->viewAttributes() ?>>
<?php echo $booking_ref->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $booking_ref->rid->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_rid" class="booking_ref_rid">
<span<?php echo $booking_ref->rid->viewAttributes() ?>>
<?php if ((!EmptyString($booking_ref->rid->getViewValue())) && $booking_ref->rid->linkAttributes() <> "") { ?>
<a<?php echo $booking_ref->rid->linkAttributes() ?>><?php echo $booking_ref->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking_ref->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $booking_ref->quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_quantity" class="booking_ref_quantity">
<span<?php echo $booking_ref->quantity->viewAttributes() ?>>
<?php echo $booking_ref->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->b_quantity->Visible) { // b_quantity ?>
		<td data-name="b_quantity"<?php echo $booking_ref->b_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_b_quantity" class="booking_ref_b_quantity">
<span<?php echo $booking_ref->b_quantity->viewAttributes() ?>>
<?php echo $booking_ref->b_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->booking_date->Visible) { // booking_date ?>
		<td data-name="booking_date"<?php echo $booking_ref->booking_date->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_booking_date" class="booking_ref_booking_date">
<span<?php echo $booking_ref->booking_date->viewAttributes() ?>>
<?php if ((!EmptyString($booking_ref->booking_date->getViewValue())) && $booking_ref->booking_date->linkAttributes() <> "") { ?>
<a<?php echo $booking_ref->booking_date->linkAttributes() ?>><?php echo $booking_ref->booking_date->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking_ref->booking_date->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->booking_rate->Visible) { // booking_rate ?>
		<td data-name="booking_rate"<?php echo $booking_ref->booking_rate->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_booking_rate" class="booking_ref_booking_rate">
<span<?php echo $booking_ref->booking_rate->viewAttributes() ?>>
<?php echo $booking_ref->booking_rate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->currency_current_rate->Visible) { // currency_current_rate ?>
		<td data-name="currency_current_rate"<?php echo $booking_ref->currency_current_rate->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_currency_current_rate" class="booking_ref_currency_current_rate">
<span<?php echo $booking_ref->currency_current_rate->viewAttributes() ?>>
<?php echo $booking_ref->currency_current_rate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->shipment_date->Visible) { // shipment_date ?>
		<td data-name="shipment_date"<?php echo $booking_ref->shipment_date->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_shipment_date" class="booking_ref_shipment_date">
<span<?php echo $booking_ref->shipment_date->viewAttributes() ?>>
<?php if ((!EmptyString($booking_ref->shipment_date->getViewValue())) && $booking_ref->shipment_date->linkAttributes() <> "") { ?>
<a<?php echo $booking_ref->shipment_date->linkAttributes() ?>><?php echo $booking_ref->shipment_date->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking_ref->shipment_date->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $booking_ref->operator->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_operator" class="booking_ref_operator">
<span<?php echo $booking_ref->operator->viewAttributes() ?>>
<?php echo $booking_ref->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $booking_ref->datetime->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_datetime" class="booking_ref_datetime">
<span<?php echo $booking_ref->datetime->viewAttributes() ?>>
<?php echo $booking_ref->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $booking_ref->remarks->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_remarks" class="booking_ref_remarks">
<span<?php echo $booking_ref->remarks->viewAttributes() ?>>
<?php echo $booking_ref->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->status->Visible) { // status ?>
		<td data-name="status"<?php echo $booking_ref->status->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_status" class="booking_ref_status">
<span<?php echo $booking_ref->status->viewAttributes() ?>>
<?php echo $booking_ref->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->confirm_type->Visible) { // confirm_type ?>
		<td data-name="confirm_type"<?php echo $booking_ref->confirm_type->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_confirm_type" class="booking_ref_confirm_type">
<span<?php echo $booking_ref->confirm_type->viewAttributes() ?>>
<?php echo $booking_ref->confirm_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->confirm_quantity->Visible) { // confirm_quantity ?>
		<td data-name="confirm_quantity"<?php echo $booking_ref->confirm_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_confirm_quantity" class="booking_ref_confirm_quantity">
<span<?php echo $booking_ref->confirm_quantity->viewAttributes() ?>>
<?php echo $booking_ref->confirm_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->confirm_pending->Visible) { // confirm_pending ?>
		<td data-name="confirm_pending"<?php echo $booking_ref->confirm_pending->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_confirm_pending" class="booking_ref_confirm_pending">
<span<?php echo $booking_ref->confirm_pending->viewAttributes() ?>>
<?php echo $booking_ref->confirm_pending->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $booking_ref->amount->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_amount" class="booking_ref_amount">
<span<?php echo $booking_ref->amount->viewAttributes() ?>>
<?php echo $booking_ref->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking_ref->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $booking_ref->packets->cellAttributes() ?>>
<span id="el<?php echo $booking_ref_list->RowCnt ?>_booking_ref_packets" class="booking_ref_packets">
<span<?php echo $booking_ref->packets->viewAttributes() ?>>
<?php echo $booking_ref->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$booking_ref_list->ListOptions->render("body", "right", $booking_ref_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$booking_ref->isGridAdd())
		$booking_ref_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$booking_ref->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($booking_ref_list->Recordset)
	$booking_ref_list->Recordset->Close();
?>
<?php if (!$booking_ref->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$booking_ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($booking_ref_list->Pager)) $booking_ref_list->Pager = new PrevNextPager($booking_ref_list->StartRec, $booking_ref_list->DisplayRecs, $booking_ref_list->TotalRecs, $booking_ref_list->AutoHidePager) ?>
<?php if ($booking_ref_list->Pager->RecordCount > 0 && $booking_ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($booking_ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($booking_ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $booking_ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($booking_ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($booking_ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $booking_ref_list->pageUrl() ?>start=<?php echo $booking_ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $booking_ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($booking_ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $booking_ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $booking_ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $booking_ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($booking_ref_list->TotalRecs > 0 && (!$booking_ref_list->AutoHidePageSizeSelector || $booking_ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="booking_ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($booking_ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($booking_ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($booking_ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($booking_ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($booking_ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($booking_ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $booking_ref_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($booking_ref_list->TotalRecs == 0 && !$booking_ref->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $booking_ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$booking_ref_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$booking_ref->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$booking_ref->isExport()) { ?>
<script>
ew.scrollableTable("gmp_booking_ref", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$booking_ref_list->terminate();
?>