<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_ref_search = new booking_ref_search();

// Run the page
$booking_ref_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_ref_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($booking_ref_search->IsModal) { ?>
var fbooking_refsearch = currentAdvancedSearchForm = new ew.Form("fbooking_refsearch", "search");
<?php } else { ?>
var fbooking_refsearch = currentForm = new ew.Form("fbooking_refsearch", "search");
<?php } ?>

// Form_CustomValidate event
fbooking_refsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbooking_refsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbooking_refsearch.lists["x_rid"] = <?php echo $booking_ref_search->rid->Lookup->toClientList() ?>;
fbooking_refsearch.lists["x_rid"].options = <?php echo JsonEncode($booking_ref_search->rid->lookupOptions()) ?>;
fbooking_refsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbooking_refsearch.lists["x_booking_currency"] = <?php echo $booking_ref_search->booking_currency->Lookup->toClientList() ?>;
fbooking_refsearch.lists["x_booking_currency"].options = <?php echo JsonEncode($booking_ref_search->booking_currency->lookupOptions()) ?>;
fbooking_refsearch.lists["x_our_port"] = <?php echo $booking_ref_search->our_port->Lookup->toClientList() ?>;
fbooking_refsearch.lists["x_our_port"].options = <?php echo JsonEncode($booking_ref_search->our_port->lookupOptions()) ?>;
fbooking_refsearch.lists["x_operator"] = <?php echo $booking_ref_search->operator->Lookup->toClientList() ?>;
fbooking_refsearch.lists["x_operator"].options = <?php echo JsonEncode($booking_ref_search->operator->lookupOptions()) ?>;
fbooking_refsearch.lists["x_status"] = <?php echo $booking_ref_search->status->Lookup->toClientList() ?>;
fbooking_refsearch.lists["x_status"].options = <?php echo JsonEncode($booking_ref_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fbooking_refsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_b_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->b_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_booking_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->booking_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_booking_rate");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->booking_rate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_currency_current_rate");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->currency_current_rate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_shipment_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->shipment_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_confirm_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->confirm_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_confirm_pending");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->confirm_pending->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking_ref->packets->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $booking_ref_search->showPageHeader(); ?>
<?php
$booking_ref_search->showMessage();
?>
<form name="fbooking_refsearch" id="fbooking_refsearch" class="<?php echo $booking_ref_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_ref_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_ref_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking_ref">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$booking_ref_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($booking_ref->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_id"><?php echo $booking_ref->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->id->cellAttributes() ?>>
			<span id="el_booking_ref_id">
<input type="text" data-table="booking_ref" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($booking_ref->id->getPlaceHolder()) ?>" value="<?php echo $booking_ref->id->EditValue ?>"<?php echo $booking_ref->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_ref"><?php echo $booking_ref->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->ref->cellAttributes() ?>>
			<span id="el_booking_ref_ref">
<input type="text" data-table="booking_ref" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($booking_ref->ref->getPlaceHolder()) ?>" value="<?php echo $booking_ref->ref->EditValue ?>"<?php echo $booking_ref->ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_rid"><?php echo $booking_ref->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->rid->cellAttributes() ?>>
			<span id="el_booking_ref_rid">
<?php
$wrkonchange = "" . trim(@$booking_ref->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$booking_ref->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($booking_ref->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($booking_ref->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($booking_ref->rid->getPlaceHolder()) ?>"<?php echo $booking_ref->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_rid" data-value-separator="<?php echo $booking_ref->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($booking_ref->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbooking_refsearch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $booking_ref->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->b_quantity->Visible) { // b_quantity ?>
	<div id="r_b_quantity" class="form-group row">
		<label for="x_b_quantity" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_b_quantity"><?php echo $booking_ref->b_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_b_quantity" id="z_b_quantity" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->b_quantity->cellAttributes() ?>>
			<span id="el_booking_ref_b_quantity">
<input type="text" data-table="booking_ref" data-field="x_b_quantity" name="x_b_quantity" id="x_b_quantity" size="30" placeholder="<?php echo HtmlEncode($booking_ref->b_quantity->getPlaceHolder()) ?>" value="<?php echo $booking_ref->b_quantity->EditValue ?>"<?php echo $booking_ref->b_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->booking_date->Visible) { // booking_date ?>
	<div id="r_booking_date" class="form-group row">
		<label for="x_booking_date" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_booking_date"><?php echo $booking_ref->booking_date->caption() ?></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->booking_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_booking_date" id="z_booking_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking_ref->booking_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_ref_booking_date">
<input type="text" data-table="booking_ref" data-field="x_booking_date" name="x_booking_date" id="x_booking_date" placeholder="<?php echo HtmlEncode($booking_ref->booking_date->getPlaceHolder()) ?>" value="<?php echo $booking_ref->booking_date->EditValue ?>"<?php echo $booking_ref->booking_date->editAttributes() ?>>
<?php if (!$booking_ref->booking_date->ReadOnly && !$booking_ref->booking_date->Disabled && !isset($booking_ref->booking_date->EditAttrs["readonly"]) && !isset($booking_ref->booking_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbooking_refsearch", "x_booking_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_booking_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_ref_booking_date" class="btw1_booking_date d-none">
<input type="text" data-table="booking_ref" data-field="x_booking_date" name="y_booking_date" id="y_booking_date" placeholder="<?php echo HtmlEncode($booking_ref->booking_date->getPlaceHolder()) ?>" value="<?php echo $booking_ref->booking_date->EditValue2 ?>"<?php echo $booking_ref->booking_date->editAttributes() ?>>
<?php if (!$booking_ref->booking_date->ReadOnly && !$booking_ref->booking_date->Disabled && !isset($booking_ref->booking_date->EditAttrs["readonly"]) && !isset($booking_ref->booking_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbooking_refsearch", "y_booking_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->booking_rate->Visible) { // booking_rate ?>
	<div id="r_booking_rate" class="form-group row">
		<label for="x_booking_rate" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_booking_rate"><?php echo $booking_ref->booking_rate->caption() ?></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->booking_rate->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_booking_rate" id="z_booking_rate" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking_ref->booking_rate->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_ref_booking_rate">
<input type="text" data-table="booking_ref" data-field="x_booking_rate" name="x_booking_rate" id="x_booking_rate" size="30" placeholder="<?php echo HtmlEncode($booking_ref->booking_rate->getPlaceHolder()) ?>" value="<?php echo $booking_ref->booking_rate->EditValue ?>"<?php echo $booking_ref->booking_rate->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_booking_rate d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_ref_booking_rate" class="btw1_booking_rate d-none">
<input type="text" data-table="booking_ref" data-field="x_booking_rate" name="y_booking_rate" id="y_booking_rate" size="30" placeholder="<?php echo HtmlEncode($booking_ref->booking_rate->getPlaceHolder()) ?>" value="<?php echo $booking_ref->booking_rate->EditValue2 ?>"<?php echo $booking_ref->booking_rate->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->booking_currency->Visible) { // booking_currency ?>
	<div id="r_booking_currency" class="form-group row">
		<label for="x_booking_currency" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_booking_currency"><?php echo $booking_ref->booking_currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_booking_currency" id="z_booking_currency" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->booking_currency->cellAttributes() ?>>
			<span id="el_booking_ref_booking_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking_ref" data-field="x_booking_currency" data-value-separator="<?php echo $booking_ref->booking_currency->displayValueSeparatorAttribute() ?>" id="x_booking_currency" name="x_booking_currency"<?php echo $booking_ref->booking_currency->editAttributes() ?>>
		<?php echo $booking_ref->booking_currency->selectOptionListHtml("x_booking_currency") ?>
	</select>
</div>
<?php echo $booking_ref->booking_currency->Lookup->getParamTag("p_x_booking_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->currency_current_rate->Visible) { // currency_current_rate ?>
	<div id="r_currency_current_rate" class="form-group row">
		<label for="x_currency_current_rate" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_currency_current_rate"><?php echo $booking_ref->currency_current_rate->caption() ?></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->currency_current_rate->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_currency_current_rate" id="z_currency_current_rate" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking_ref->currency_current_rate->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_ref_currency_current_rate">
<input type="text" data-table="booking_ref" data-field="x_currency_current_rate" name="x_currency_current_rate" id="x_currency_current_rate" size="30" placeholder="<?php echo HtmlEncode($booking_ref->currency_current_rate->getPlaceHolder()) ?>" value="<?php echo $booking_ref->currency_current_rate->EditValue ?>"<?php echo $booking_ref->currency_current_rate->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_currency_current_rate d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_ref_currency_current_rate" class="btw1_currency_current_rate d-none">
<input type="text" data-table="booking_ref" data-field="x_currency_current_rate" name="y_currency_current_rate" id="y_currency_current_rate" size="30" placeholder="<?php echo HtmlEncode($booking_ref->currency_current_rate->getPlaceHolder()) ?>" value="<?php echo $booking_ref->currency_current_rate->EditValue2 ?>"<?php echo $booking_ref->currency_current_rate->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->shipment_date->Visible) { // shipment_date ?>
	<div id="r_shipment_date" class="form-group row">
		<label for="x_shipment_date" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_shipment_date"><?php echo $booking_ref->shipment_date->caption() ?></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->shipment_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_shipment_date" id="z_shipment_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking_ref->shipment_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_ref_shipment_date">
<input type="text" data-table="booking_ref" data-field="x_shipment_date" name="x_shipment_date" id="x_shipment_date" placeholder="<?php echo HtmlEncode($booking_ref->shipment_date->getPlaceHolder()) ?>" value="<?php echo $booking_ref->shipment_date->EditValue ?>"<?php echo $booking_ref->shipment_date->editAttributes() ?>>
<?php if (!$booking_ref->shipment_date->ReadOnly && !$booking_ref->shipment_date->Disabled && !isset($booking_ref->shipment_date->EditAttrs["readonly"]) && !isset($booking_ref->shipment_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbooking_refsearch", "x_shipment_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_shipment_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_ref_shipment_date" class="btw1_shipment_date d-none">
<input type="text" data-table="booking_ref" data-field="x_shipment_date" name="y_shipment_date" id="y_shipment_date" placeholder="<?php echo HtmlEncode($booking_ref->shipment_date->getPlaceHolder()) ?>" value="<?php echo $booking_ref->shipment_date->EditValue2 ?>"<?php echo $booking_ref->shipment_date->editAttributes() ?>>
<?php if (!$booking_ref->shipment_date->ReadOnly && !$booking_ref->shipment_date->Disabled && !isset($booking_ref->shipment_date->EditAttrs["readonly"]) && !isset($booking_ref->shipment_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbooking_refsearch", "y_shipment_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->our_port->Visible) { // our_port ?>
	<div id="r_our_port" class="form-group row">
		<label for="x_our_port" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_our_port"><?php echo $booking_ref->our_port->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_our_port" id="z_our_port" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->our_port->cellAttributes() ?>>
			<span id="el_booking_ref_our_port">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking_ref" data-field="x_our_port" data-value-separator="<?php echo $booking_ref->our_port->displayValueSeparatorAttribute() ?>" id="x_our_port" name="x_our_port"<?php echo $booking_ref->our_port->editAttributes() ?>>
		<?php echo $booking_ref->our_port->selectOptionListHtml("x_our_port") ?>
	</select>
</div>
<?php echo $booking_ref->our_port->Lookup->getParamTag("p_x_our_port") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_operator"><?php echo $booking_ref->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->operator->cellAttributes() ?>>
			<span id="el_booking_ref_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking_ref" data-field="x_operator" data-value-separator="<?php echo $booking_ref->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $booking_ref->operator->editAttributes() ?>>
		<?php echo $booking_ref->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $booking_ref->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_datetime"><?php echo $booking_ref->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->datetime->cellAttributes() ?>>
			<span id="el_booking_ref_datetime">
<input type="text" data-table="booking_ref" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($booking_ref->datetime->getPlaceHolder()) ?>" value="<?php echo $booking_ref->datetime->EditValue ?>"<?php echo $booking_ref->datetime->editAttributes() ?>>
<?php if (!$booking_ref->datetime->ReadOnly && !$booking_ref->datetime->Disabled && !isset($booking_ref->datetime->EditAttrs["readonly"]) && !isset($booking_ref->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbooking_refsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_remarks"><?php echo $booking_ref->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->remarks->cellAttributes() ?>>
			<span id="el_booking_ref_remarks">
<input type="text" data-table="booking_ref" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($booking_ref->remarks->getPlaceHolder()) ?>" value="<?php echo $booking_ref->remarks->EditValue ?>"<?php echo $booking_ref->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_status"><?php echo $booking_ref->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->status->cellAttributes() ?>>
			<span id="el_booking_ref_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking_ref" data-field="x_status" data-value-separator="<?php echo $booking_ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $booking_ref->status->editAttributes() ?>>
		<?php echo $booking_ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->confirm_type->Visible) { // confirm_type ?>
	<div id="r_confirm_type" class="form-group row">
		<label for="x_confirm_type" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_type"><?php echo $booking_ref->confirm_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_confirm_type" id="z_confirm_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->confirm_type->cellAttributes() ?>>
			<span id="el_booking_ref_confirm_type">
<input type="text" data-table="booking_ref" data-field="x_confirm_type" name="x_confirm_type" id="x_confirm_type" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($booking_ref->confirm_type->getPlaceHolder()) ?>" value="<?php echo $booking_ref->confirm_type->EditValue ?>"<?php echo $booking_ref->confirm_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_product_code"><?php echo $booking_ref->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->product_code->cellAttributes() ?>>
			<span id="el_booking_ref_product_code">
<input type="text" data-table="booking_ref" data-field="x_product_code" name="x_product_code" id="x_product_code" size="35" placeholder="<?php echo HtmlEncode($booking_ref->product_code->getPlaceHolder()) ?>" value="<?php echo $booking_ref->product_code->EditValue ?>"<?php echo $booking_ref->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->confirm_quantity->Visible) { // confirm_quantity ?>
	<div id="r_confirm_quantity" class="form-group row">
		<label for="x_confirm_quantity" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_quantity"><?php echo $booking_ref->confirm_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_confirm_quantity" id="z_confirm_quantity" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->confirm_quantity->cellAttributes() ?>>
			<span id="el_booking_ref_confirm_quantity">
<input type="text" data-table="booking_ref" data-field="x_confirm_quantity" name="x_confirm_quantity" id="x_confirm_quantity" size="30" placeholder="<?php echo HtmlEncode($booking_ref->confirm_quantity->getPlaceHolder()) ?>" value="<?php echo $booking_ref->confirm_quantity->EditValue ?>"<?php echo $booking_ref->confirm_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->confirm_pending->Visible) { // confirm_pending ?>
	<div id="r_confirm_pending" class="form-group row">
		<label for="x_confirm_pending" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_pending"><?php echo $booking_ref->confirm_pending->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_confirm_pending" id="z_confirm_pending" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->confirm_pending->cellAttributes() ?>>
			<span id="el_booking_ref_confirm_pending">
<input type="text" data-table="booking_ref" data-field="x_confirm_pending" name="x_confirm_pending" id="x_confirm_pending" size="30" placeholder="<?php echo HtmlEncode($booking_ref->confirm_pending->getPlaceHolder()) ?>" value="<?php echo $booking_ref->confirm_pending->EditValue ?>"<?php echo $booking_ref->confirm_pending->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_amount"><?php echo $booking_ref->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->amount->cellAttributes() ?>>
			<span id="el_booking_ref_amount">
<input type="text" data-table="booking_ref" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($booking_ref->amount->getPlaceHolder()) ?>" value="<?php echo $booking_ref->amount->EditValue ?>"<?php echo $booking_ref->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_currency"><?php echo $booking_ref->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_currency" id="z_currency" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->currency->cellAttributes() ?>>
			<span id="el_booking_ref_currency">
<input type="text" data-table="booking_ref" data-field="x_currency" name="x_currency" id="x_currency" size="35" placeholder="<?php echo HtmlEncode($booking_ref->currency->getPlaceHolder()) ?>" value="<?php echo $booking_ref->currency->EditValue ?>"<?php echo $booking_ref->currency->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->confirm_port_eta->Visible) { // confirm_port_eta ?>
	<div id="r_confirm_port_eta" class="form-group row">
		<label for="x_confirm_port_eta" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_port_eta"><?php echo $booking_ref->confirm_port_eta->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_confirm_port_eta" id="z_confirm_port_eta" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->confirm_port_eta->cellAttributes() ?>>
			<span id="el_booking_ref_confirm_port_eta">
<input type="text" data-table="booking_ref" data-field="x_confirm_port_eta" name="x_confirm_port_eta" id="x_confirm_port_eta" size="35" placeholder="<?php echo HtmlEncode($booking_ref->confirm_port_eta->getPlaceHolder()) ?>" value="<?php echo $booking_ref->confirm_port_eta->EditValue ?>"<?php echo $booking_ref->confirm_port_eta->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_reference"><?php echo $booking_ref->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_reference" id="z_reference" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->reference->cellAttributes() ?>>
			<span id="el_booking_ref_reference">
<input type="text" data-table="booking_ref" data-field="x_reference" name="x_reference" id="x_reference" size="35" placeholder="<?php echo HtmlEncode($booking_ref->reference->getPlaceHolder()) ?>" value="<?php echo $booking_ref->reference->EditValue ?>"<?php echo $booking_ref->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking_ref->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $booking_ref_search->LeftColumnClass ?>"><span id="elh_booking_ref_packets"><?php echo $booking_ref->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $booking_ref_search->RightColumnClass ?>"><div<?php echo $booking_ref->packets->cellAttributes() ?>>
			<span id="el_booking_ref_packets">
<input type="text" data-table="booking_ref" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($booking_ref->packets->getPlaceHolder()) ?>" value="<?php echo $booking_ref->packets->EditValue ?>"<?php echo $booking_ref->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$booking_ref_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $booking_ref_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$booking_ref_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$booking_ref_search->terminate();
?>