<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_delete = new booking_delete();

// Run the page
$booking_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fbookingdelete = currentForm = new ew.Form("fbookingdelete", "delete");

// Form_CustomValidate event
fbookingdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbookingdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbookingdelete.lists["x_s_grp"] = <?php echo $booking_delete->s_grp->Lookup->toClientList() ?>;
fbookingdelete.lists["x_s_grp"].options = <?php echo JsonEncode($booking_delete->s_grp->lookupOptions()) ?>;
fbookingdelete.lists["x_product"] = <?php echo $booking_delete->product->Lookup->toClientList() ?>;
fbookingdelete.lists["x_product"].options = <?php echo JsonEncode($booking_delete->product->lookupOptions()) ?>;
fbookingdelete.lists["x_rid"] = <?php echo $booking_delete->rid->Lookup->toClientList() ?>;
fbookingdelete.lists["x_rid"].options = <?php echo JsonEncode($booking_delete->rid->lookupOptions()) ?>;
fbookingdelete.lists["x_status"] = <?php echo $booking_delete->status->Lookup->toClientList() ?>;
fbookingdelete.lists["x_status"].options = <?php echo JsonEncode($booking_delete->status->options(FALSE, TRUE)) ?>;
fbookingdelete.lists["x_operator"] = <?php echo $booking_delete->operator->Lookup->toClientList() ?>;
fbookingdelete.lists["x_operator"].options = <?php echo JsonEncode($booking_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $booking_delete->showPageHeader(); ?>
<?php
$booking_delete->showMessage();
?>
<form name="fbookingdelete" id="fbookingdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($booking_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($booking->id->Visible) { // id ?>
		<th class="<?php echo $booking->id->headerCellClass() ?>"><span id="elh_booking_id" class="booking_id"><?php echo $booking->id->caption() ?></span></th>
<?php } ?>
<?php if ($booking->ref->Visible) { // ref ?>
		<th class="<?php echo $booking->ref->headerCellClass() ?>"><span id="elh_booking_ref" class="booking_ref"><?php echo $booking->ref->caption() ?></span></th>
<?php } ?>
<?php if ($booking->s_grp->Visible) { // s_grp ?>
		<th class="<?php echo $booking->s_grp->headerCellClass() ?>"><span id="elh_booking_s_grp" class="booking_s_grp"><?php echo $booking->s_grp->caption() ?></span></th>
<?php } ?>
<?php if ($booking->product->Visible) { // product ?>
		<th class="<?php echo $booking->product->headerCellClass() ?>"><span id="elh_booking_product" class="booking_product"><?php echo $booking->product->caption() ?></span></th>
<?php } ?>
<?php if ($booking->rid->Visible) { // rid ?>
		<th class="<?php echo $booking->rid->headerCellClass() ?>"><span id="elh_booking_rid" class="booking_rid"><?php echo $booking->rid->caption() ?></span></th>
<?php } ?>
<?php if ($booking->quantity->Visible) { // quantity ?>
		<th class="<?php echo $booking->quantity->headerCellClass() ?>"><span id="elh_booking_quantity" class="booking_quantity"><?php echo $booking->quantity->caption() ?></span></th>
<?php } ?>
<?php if ($booking->b_quantity->Visible) { // b_quantity ?>
		<th class="<?php echo $booking->b_quantity->headerCellClass() ?>"><span id="elh_booking_b_quantity" class="booking_b_quantity"><?php echo $booking->b_quantity->caption() ?></span></th>
<?php } ?>
<?php if ($booking->booking_rate->Visible) { // booking_rate ?>
		<th class="<?php echo $booking->booking_rate->headerCellClass() ?>"><span id="elh_booking_booking_rate" class="booking_booking_rate"><?php echo $booking->booking_rate->caption() ?></span></th>
<?php } ?>
<?php if ($booking->currency_current_rate->Visible) { // currency_current_rate ?>
		<th class="<?php echo $booking->currency_current_rate->headerCellClass() ?>"><span id="elh_booking_currency_current_rate" class="booking_currency_current_rate"><?php echo $booking->currency_current_rate->caption() ?></span></th>
<?php } ?>
<?php if ($booking->booking_date->Visible) { // booking_date ?>
		<th class="<?php echo $booking->booking_date->headerCellClass() ?>"><span id="elh_booking_booking_date" class="booking_booking_date"><?php echo $booking->booking_date->caption() ?></span></th>
<?php } ?>
<?php if ($booking->shipment_date->Visible) { // shipment_date ?>
		<th class="<?php echo $booking->shipment_date->headerCellClass() ?>"><span id="elh_booking_shipment_date" class="booking_shipment_date"><?php echo $booking->shipment_date->caption() ?></span></th>
<?php } ?>
<?php if ($booking->remarks->Visible) { // remarks ?>
		<th class="<?php echo $booking->remarks->headerCellClass() ?>"><span id="elh_booking_remarks" class="booking_remarks"><?php echo $booking->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($booking->status->Visible) { // status ?>
		<th class="<?php echo $booking->status->headerCellClass() ?>"><span id="elh_booking_status" class="booking_status"><?php echo $booking->status->caption() ?></span></th>
<?php } ?>
<?php if ($booking->operator->Visible) { // operator ?>
		<th class="<?php echo $booking->operator->headerCellClass() ?>"><span id="elh_booking_operator" class="booking_operator"><?php echo $booking->operator->caption() ?></span></th>
<?php } ?>
<?php if ($booking->datetime->Visible) { // datetime ?>
		<th class="<?php echo $booking->datetime->headerCellClass() ?>"><span id="elh_booking_datetime" class="booking_datetime"><?php echo $booking->datetime->caption() ?></span></th>
<?php } ?>
<?php if ($booking->confirm_quantity->Visible) { // confirm_quantity ?>
		<th class="<?php echo $booking->confirm_quantity->headerCellClass() ?>"><span id="elh_booking_confirm_quantity" class="booking_confirm_quantity"><?php echo $booking->confirm_quantity->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$booking_delete->RecCnt = 0;
$i = 0;
while (!$booking_delete->Recordset->EOF) {
	$booking_delete->RecCnt++;
	$booking_delete->RowCnt++;

	// Set row properties
	$booking->resetAttributes();
	$booking->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$booking_delete->loadRowValues($booking_delete->Recordset);

	// Render row
	$booking_delete->renderRow();
?>
	<tr<?php echo $booking->rowAttributes() ?>>
<?php if ($booking->id->Visible) { // id ?>
		<td<?php echo $booking->id->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_id" class="booking_id">
<span<?php echo $booking->id->viewAttributes() ?>>
<?php if ((!EmptyString($booking->id->getViewValue())) && $booking->id->linkAttributes() <> "") { ?>
<a<?php echo $booking->id->linkAttributes() ?>><?php echo $booking->id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($booking->ref->Visible) { // ref ?>
		<td<?php echo $booking->ref->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_ref" class="booking_ref">
<span<?php echo $booking->ref->viewAttributes() ?>>
<?php echo $booking->ref->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->s_grp->Visible) { // s_grp ?>
		<td<?php echo $booking->s_grp->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_s_grp" class="booking_s_grp">
<span<?php echo $booking->s_grp->viewAttributes() ?>>
<?php echo $booking->s_grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->product->Visible) { // product ?>
		<td<?php echo $booking->product->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_product" class="booking_product">
<span<?php echo $booking->product->viewAttributes() ?>>
<?php if ((!EmptyString($booking->product->getViewValue())) && $booking->product->linkAttributes() <> "") { ?>
<a<?php echo $booking->product->linkAttributes() ?>><?php echo $booking->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($booking->rid->Visible) { // rid ?>
		<td<?php echo $booking->rid->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_rid" class="booking_rid">
<span<?php echo $booking->rid->viewAttributes() ?>>
<?php if ((!EmptyString($booking->rid->getViewValue())) && $booking->rid->linkAttributes() <> "") { ?>
<a<?php echo $booking->rid->linkAttributes() ?>><?php echo $booking->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($booking->quantity->Visible) { // quantity ?>
		<td<?php echo $booking->quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_quantity" class="booking_quantity">
<span<?php echo $booking->quantity->viewAttributes() ?>>
<?php echo $booking->quantity->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->b_quantity->Visible) { // b_quantity ?>
		<td<?php echo $booking->b_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_b_quantity" class="booking_b_quantity">
<span<?php echo $booking->b_quantity->viewAttributes() ?>>
<?php echo $booking->b_quantity->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->booking_rate->Visible) { // booking_rate ?>
		<td<?php echo $booking->booking_rate->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_booking_rate" class="booking_booking_rate">
<span<?php echo $booking->booking_rate->viewAttributes() ?>>
<?php echo $booking->booking_rate->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->currency_current_rate->Visible) { // currency_current_rate ?>
		<td<?php echo $booking->currency_current_rate->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_currency_current_rate" class="booking_currency_current_rate">
<span<?php echo $booking->currency_current_rate->viewAttributes() ?>>
<?php echo $booking->currency_current_rate->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->booking_date->Visible) { // booking_date ?>
		<td<?php echo $booking->booking_date->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_booking_date" class="booking_booking_date">
<span<?php echo $booking->booking_date->viewAttributes() ?>>
<?php echo $booking->booking_date->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->shipment_date->Visible) { // shipment_date ?>
		<td<?php echo $booking->shipment_date->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_shipment_date" class="booking_shipment_date">
<span<?php echo $booking->shipment_date->viewAttributes() ?>>
<?php echo $booking->shipment_date->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->remarks->Visible) { // remarks ?>
		<td<?php echo $booking->remarks->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_remarks" class="booking_remarks">
<span<?php echo $booking->remarks->viewAttributes() ?>>
<?php echo $booking->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->status->Visible) { // status ?>
		<td<?php echo $booking->status->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_status" class="booking_status">
<span<?php echo $booking->status->viewAttributes() ?>>
<?php echo $booking->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->operator->Visible) { // operator ?>
		<td<?php echo $booking->operator->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_operator" class="booking_operator">
<span<?php echo $booking->operator->viewAttributes() ?>>
<?php echo $booking->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->datetime->Visible) { // datetime ?>
		<td<?php echo $booking->datetime->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_datetime" class="booking_datetime">
<span<?php echo $booking->datetime->viewAttributes() ?>>
<?php echo $booking->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($booking->confirm_quantity->Visible) { // confirm_quantity ?>
		<td<?php echo $booking->confirm_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_delete->RowCnt ?>_booking_confirm_quantity" class="booking_confirm_quantity">
<span<?php echo $booking->confirm_quantity->viewAttributes() ?>>
<?php echo $booking->confirm_quantity->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$booking_delete->Recordset->moveNext();
}
$booking_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $booking_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$booking_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$booking_delete->terminate();
?>