<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_edit = new booking_edit();

// Run the page
$booking_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbookingedit = currentForm = new ew.Form("fbookingedit", "edit");

// Validate form
fbookingedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($booking_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->id->caption(), $booking->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->supplier->Required) { ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->supplier->caption(), $booking->supplier->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->ref->caption(), $booking->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->grp->caption(), $booking->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->s_grp->caption(), $booking->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->product->caption(), $booking->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->rid->caption(), $booking->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->agent->Required) { ?>
			elm = this.getElements("x" + infix + "_agent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->agent->caption(), $booking->agent->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->quantity->caption(), $booking->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($booking->quantity->errorMessage()) ?>");
		<?php if ($booking_edit->containers->Required) { ?>
			elm = this.getElements("x" + infix + "_containers");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->containers->caption(), $booking->containers->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_containers");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($booking->containers->errorMessage()) ?>");
		<?php if ($booking_edit->booking_rate->Required) { ?>
			elm = this.getElements("x" + infix + "_booking_rate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->booking_rate->caption(), $booking->booking_rate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_booking_rate");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($booking->booking_rate->errorMessage()) ?>");
		<?php if ($booking_edit->booking_currency->Required) { ?>
			elm = this.getElements("x" + infix + "_booking_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->booking_currency->caption(), $booking->booking_currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->currency_current_rate->Required) { ?>
			elm = this.getElements("x" + infix + "_currency_current_rate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->currency_current_rate->caption(), $booking->currency_current_rate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_currency_current_rate");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($booking->currency_current_rate->errorMessage()) ?>");
		<?php if ($booking_edit->booking_date->Required) { ?>
			elm = this.getElements("x" + infix + "_booking_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->booking_date->caption(), $booking->booking_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_booking_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($booking->booking_date->errorMessage()) ?>");
		<?php if ($booking_edit->shipment_date->Required) { ?>
			elm = this.getElements("x" + infix + "_shipment_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->shipment_date->caption(), $booking->shipment_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_shipment_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($booking->shipment_date->errorMessage()) ?>");
		<?php if ($booking_edit->our_port->Required) { ?>
			elm = this.getElements("x" + infix + "_our_port");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->our_port->caption(), $booking->our_port->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->remarks->caption(), $booking->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->status->caption(), $booking->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->operator->caption(), $booking->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->datetime->caption(), $booking->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($booking_edit->confirm_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_confirm_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $booking->confirm_quantity->caption(), $booking->confirm_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_confirm_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($booking->confirm_quantity->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbookingedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbookingedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbookingedit.lists["x_supplier"] = <?php echo $booking_edit->supplier->Lookup->toClientList() ?>;
fbookingedit.lists["x_supplier"].options = <?php echo JsonEncode($booking_edit->supplier->lookupOptions()) ?>;
fbookingedit.lists["x_grp"] = <?php echo $booking_edit->grp->Lookup->toClientList() ?>;
fbookingedit.lists["x_grp"].options = <?php echo JsonEncode($booking_edit->grp->lookupOptions()) ?>;
fbookingedit.lists["x_s_grp"] = <?php echo $booking_edit->s_grp->Lookup->toClientList() ?>;
fbookingedit.lists["x_s_grp"].options = <?php echo JsonEncode($booking_edit->s_grp->lookupOptions()) ?>;
fbookingedit.lists["x_product"] = <?php echo $booking_edit->product->Lookup->toClientList() ?>;
fbookingedit.lists["x_product"].options = <?php echo JsonEncode($booking_edit->product->lookupOptions()) ?>;
fbookingedit.lists["x_rid"] = <?php echo $booking_edit->rid->Lookup->toClientList() ?>;
fbookingedit.lists["x_rid"].options = <?php echo JsonEncode($booking_edit->rid->lookupOptions()) ?>;
fbookingedit.lists["x_agent"] = <?php echo $booking_edit->agent->Lookup->toClientList() ?>;
fbookingedit.lists["x_agent"].options = <?php echo JsonEncode($booking_edit->agent->lookupOptions()) ?>;
fbookingedit.lists["x_booking_currency"] = <?php echo $booking_edit->booking_currency->Lookup->toClientList() ?>;
fbookingedit.lists["x_booking_currency"].options = <?php echo JsonEncode($booking_edit->booking_currency->lookupOptions()) ?>;
fbookingedit.lists["x_our_port"] = <?php echo $booking_edit->our_port->Lookup->toClientList() ?>;
fbookingedit.lists["x_our_port"].options = <?php echo JsonEncode($booking_edit->our_port->lookupOptions()) ?>;
fbookingedit.lists["x_status"] = <?php echo $booking_edit->status->Lookup->toClientList() ?>;
fbookingedit.lists["x_status"].options = <?php echo JsonEncode($booking_edit->status->options(FALSE, TRUE)) ?>;
fbookingedit.lists["x_operator"] = <?php echo $booking_edit->operator->Lookup->toClientList() ?>;
fbookingedit.lists["x_operator"].options = <?php echo JsonEncode($booking_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $booking_edit->showPageHeader(); ?>
<?php
$booking_edit->showMessage();
?>
<form name="fbookingedit" id="fbookingedit" class="<?php echo $booking_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$booking_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($booking->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_booking_id" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->id->caption() ?><?php echo ($booking->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->id->cellAttributes() ?>>
<span id="el_booking_id">
<span<?php echo $booking->id->viewAttributes() ?>>
<?php if ((!EmptyString($booking->id->EditValue)) && $booking->id->linkAttributes() <> "") { ?>
<a<?php echo $booking->id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($booking->id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($booking->id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="booking" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($booking->id->CurrentValue) ?>">
<?php echo $booking->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label id="elh_booking_supplier" for="x_supplier" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->supplier->caption() ?><?php echo ($booking->supplier->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->supplier->cellAttributes() ?>>
<span id="el_booking_supplier">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_supplier" data-value-separator="<?php echo $booking->supplier->displayValueSeparatorAttribute() ?>" id="x_supplier" name="x_supplier"<?php echo $booking->supplier->editAttributes() ?>>
		<?php echo $booking->supplier->selectOptionListHtml("x_supplier") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "production_partner") && !$booking->supplier->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_supplier" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $booking->supplier->caption() ?>" data-title="<?php echo $booking->supplier->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_supplier',url:'production_partneraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $booking->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
<?php echo $booking->supplier->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_booking_ref" for="x_ref" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->ref->caption() ?><?php echo ($booking->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->ref->cellAttributes() ?>>
<span id="el_booking_ref">
<input type="text" data-table="booking" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($booking->ref->getPlaceHolder()) ?>" value="<?php echo $booking->ref->EditValue ?>"<?php echo $booking->ref->editAttributes() ?>>
</span>
<?php echo $booking->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_booking_grp" for="x_grp" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->grp->caption() ?><?php echo ($booking->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->grp->cellAttributes() ?>>
<span id="el_booking_grp">
<?php $booking->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$booking->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_grp" data-value-separator="<?php echo $booking->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $booking->grp->editAttributes() ?>>
		<?php echo $booking->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $booking->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $booking->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_booking_s_grp" for="x_s_grp" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->s_grp->caption() ?><?php echo ($booking->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->s_grp->cellAttributes() ?>>
<span id="el_booking_s_grp">
<?php $booking->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$booking->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_s_grp" data-value-separator="<?php echo $booking->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $booking->s_grp->editAttributes() ?>>
		<?php echo $booking->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $booking->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $booking->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_booking_product" for="x_product" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->product->caption() ?><?php echo ($booking->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->product->cellAttributes() ?>>
<span id="el_booking_product">
<?php $booking->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$booking->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_product" data-value-separator="<?php echo $booking->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $booking->product->editAttributes() ?>>
		<?php echo $booking->product->selectOptionListHtml("x_product") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "product") && !$booking->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $booking->product->caption() ?>" data-title="<?php echo $booking->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_product',url:'productaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $booking->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $booking->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_booking_rid" for="x_rid" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->rid->caption() ?><?php echo ($booking->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->rid->cellAttributes() ?>>
<span id="el_booking_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_rid" data-value-separator="<?php echo $booking->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $booking->rid->editAttributes() ?>>
		<?php echo $booking->rid->selectOptionListHtml("x_rid") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "ref") && !$booking->rid->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_rid" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $booking->rid->caption() ?>" data-title="<?php echo $booking->rid->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_rid',url:'refaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $booking->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $booking->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label id="elh_booking_agent" for="x_agent" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->agent->caption() ?><?php echo ($booking->agent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->agent->cellAttributes() ?>>
<span id="el_booking_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_agent" data-value-separator="<?php echo $booking->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $booking->agent->editAttributes() ?>>
		<?php echo $booking->agent->selectOptionListHtml("x_agent") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "agent") && !$booking->agent->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_agent" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $booking->agent->caption() ?>" data-title="<?php echo $booking->agent->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_agent',url:'agentaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $booking->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php echo $booking->agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_booking_quantity" for="x_quantity" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->quantity->caption() ?><?php echo ($booking->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->quantity->cellAttributes() ?>>
<span id="el_booking_quantity">
<input type="text" data-table="booking" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($booking->quantity->getPlaceHolder()) ?>" value="<?php echo $booking->quantity->EditValue ?>"<?php echo $booking->quantity->editAttributes() ?>>
</span>
<?php echo $booking->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->containers->Visible) { // containers ?>
	<div id="r_containers" class="form-group row">
		<label id="elh_booking_containers" for="x_containers" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->containers->caption() ?><?php echo ($booking->containers->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->containers->cellAttributes() ?>>
<span id="el_booking_containers">
<input type="text" data-table="booking" data-field="x_containers" name="x_containers" id="x_containers" size="30" placeholder="<?php echo HtmlEncode($booking->containers->getPlaceHolder()) ?>" value="<?php echo $booking->containers->EditValue ?>"<?php echo $booking->containers->editAttributes() ?>>
</span>
<?php echo $booking->containers->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->booking_rate->Visible) { // booking_rate ?>
	<div id="r_booking_rate" class="form-group row">
		<label id="elh_booking_booking_rate" for="x_booking_rate" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->booking_rate->caption() ?><?php echo ($booking->booking_rate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->booking_rate->cellAttributes() ?>>
<span id="el_booking_booking_rate">
<input type="text" data-table="booking" data-field="x_booking_rate" name="x_booking_rate" id="x_booking_rate" size="30" placeholder="<?php echo HtmlEncode($booking->booking_rate->getPlaceHolder()) ?>" value="<?php echo $booking->booking_rate->EditValue ?>"<?php echo $booking->booking_rate->editAttributes() ?>>
</span>
<?php echo $booking->booking_rate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->booking_currency->Visible) { // booking_currency ?>
	<div id="r_booking_currency" class="form-group row">
		<label id="elh_booking_booking_currency" for="x_booking_currency" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->booking_currency->caption() ?><?php echo ($booking->booking_currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->booking_currency->cellAttributes() ?>>
<span id="el_booking_booking_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_booking_currency" data-value-separator="<?php echo $booking->booking_currency->displayValueSeparatorAttribute() ?>" id="x_booking_currency" name="x_booking_currency"<?php echo $booking->booking_currency->editAttributes() ?>>
		<?php echo $booking->booking_currency->selectOptionListHtml("x_booking_currency") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "currency") && !$booking->booking_currency->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_booking_currency" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $booking->booking_currency->caption() ?>" data-title="<?php echo $booking->booking_currency->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_booking_currency',url:'currencyaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $booking->booking_currency->Lookup->getParamTag("p_x_booking_currency") ?>
</span>
<?php echo $booking->booking_currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->currency_current_rate->Visible) { // currency_current_rate ?>
	<div id="r_currency_current_rate" class="form-group row">
		<label id="elh_booking_currency_current_rate" for="x_currency_current_rate" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->currency_current_rate->caption() ?><?php echo ($booking->currency_current_rate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->currency_current_rate->cellAttributes() ?>>
<span id="el_booking_currency_current_rate">
<input type="text" data-table="booking" data-field="x_currency_current_rate" name="x_currency_current_rate" id="x_currency_current_rate" size="30" placeholder="<?php echo HtmlEncode($booking->currency_current_rate->getPlaceHolder()) ?>" value="<?php echo $booking->currency_current_rate->EditValue ?>"<?php echo $booking->currency_current_rate->editAttributes() ?>>
</span>
<?php echo $booking->currency_current_rate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->booking_date->Visible) { // booking_date ?>
	<div id="r_booking_date" class="form-group row">
		<label id="elh_booking_booking_date" for="x_booking_date" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->booking_date->caption() ?><?php echo ($booking->booking_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->booking_date->cellAttributes() ?>>
<span id="el_booking_booking_date">
<input type="text" data-table="booking" data-field="x_booking_date" name="x_booking_date" id="x_booking_date" placeholder="<?php echo HtmlEncode($booking->booking_date->getPlaceHolder()) ?>" value="<?php echo $booking->booking_date->EditValue ?>"<?php echo $booking->booking_date->editAttributes() ?>>
<?php if (!$booking->booking_date->ReadOnly && !$booking->booking_date->Disabled && !isset($booking->booking_date->EditAttrs["readonly"]) && !isset($booking->booking_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbookingedit", "x_booking_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $booking->booking_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->shipment_date->Visible) { // shipment_date ?>
	<div id="r_shipment_date" class="form-group row">
		<label id="elh_booking_shipment_date" for="x_shipment_date" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->shipment_date->caption() ?><?php echo ($booking->shipment_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->shipment_date->cellAttributes() ?>>
<span id="el_booking_shipment_date">
<input type="text" data-table="booking" data-field="x_shipment_date" name="x_shipment_date" id="x_shipment_date" placeholder="<?php echo HtmlEncode($booking->shipment_date->getPlaceHolder()) ?>" value="<?php echo $booking->shipment_date->EditValue ?>"<?php echo $booking->shipment_date->editAttributes() ?>>
<?php if (!$booking->shipment_date->ReadOnly && !$booking->shipment_date->Disabled && !isset($booking->shipment_date->EditAttrs["readonly"]) && !isset($booking->shipment_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbookingedit", "x_shipment_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $booking->shipment_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->our_port->Visible) { // our_port ?>
	<div id="r_our_port" class="form-group row">
		<label id="elh_booking_our_port" for="x_our_port" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->our_port->caption() ?><?php echo ($booking->our_port->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->our_port->cellAttributes() ?>>
<span id="el_booking_our_port">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_our_port" data-value-separator="<?php echo $booking->our_port->displayValueSeparatorAttribute() ?>" id="x_our_port" name="x_our_port"<?php echo $booking->our_port->editAttributes() ?>>
		<?php echo $booking->our_port->selectOptionListHtml("x_our_port") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "port") && !$booking->our_port->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_our_port" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $booking->our_port->caption() ?>" data-title="<?php echo $booking->our_port->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_our_port',url:'portaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $booking->our_port->Lookup->getParamTag("p_x_our_port") ?>
</span>
<?php echo $booking->our_port->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_booking_remarks" for="x_remarks" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->remarks->caption() ?><?php echo ($booking->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->remarks->cellAttributes() ?>>
<span id="el_booking_remarks">
<textarea data-table="booking" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($booking->remarks->getPlaceHolder()) ?>"<?php echo $booking->remarks->editAttributes() ?>><?php echo $booking->remarks->EditValue ?></textarea>
</span>
<?php echo $booking->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_booking_status" for="x_status" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->status->caption() ?><?php echo ($booking->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->status->cellAttributes() ?>>
<span id="el_booking_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_status" data-value-separator="<?php echo $booking->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $booking->status->editAttributes() ?>>
		<?php echo $booking->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $booking->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($booking->confirm_quantity->Visible) { // confirm_quantity ?>
	<div id="r_confirm_quantity" class="form-group row">
		<label id="elh_booking_confirm_quantity" for="x_confirm_quantity" class="<?php echo $booking_edit->LeftColumnClass ?>"><?php echo $booking->confirm_quantity->caption() ?><?php echo ($booking->confirm_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $booking_edit->RightColumnClass ?>"><div<?php echo $booking->confirm_quantity->cellAttributes() ?>>
<span id="el_booking_confirm_quantity">
<input type="text" data-table="booking" data-field="x_confirm_quantity" name="x_confirm_quantity" id="x_confirm_quantity" size="30" placeholder="<?php echo HtmlEncode($booking->confirm_quantity->getPlaceHolder()) ?>" value="<?php echo $booking->confirm_quantity->EditValue ?>"<?php echo $booking->confirm_quantity->editAttributes() ?>>
</span>
<?php echo $booking->confirm_quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$booking_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $booking_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $booking_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$booking_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$booking_edit->terminate();
?>