<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_list = new booking_list();

// Run the page
$booking_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$booking->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbookinglist = currentForm = new ew.Form("fbookinglist", "list");
fbookinglist.formKeyCountName = '<?php echo $booking_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbookinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbookinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbookinglist.lists["x_s_grp"] = <?php echo $booking_list->s_grp->Lookup->toClientList() ?>;
fbookinglist.lists["x_s_grp"].options = <?php echo JsonEncode($booking_list->s_grp->lookupOptions()) ?>;
fbookinglist.lists["x_product"] = <?php echo $booking_list->product->Lookup->toClientList() ?>;
fbookinglist.lists["x_product"].options = <?php echo JsonEncode($booking_list->product->lookupOptions()) ?>;
fbookinglist.lists["x_rid"] = <?php echo $booking_list->rid->Lookup->toClientList() ?>;
fbookinglist.lists["x_rid"].options = <?php echo JsonEncode($booking_list->rid->lookupOptions()) ?>;
fbookinglist.lists["x_status"] = <?php echo $booking_list->status->Lookup->toClientList() ?>;
fbookinglist.lists["x_status"].options = <?php echo JsonEncode($booking_list->status->options(FALSE, TRUE)) ?>;
fbookinglist.lists["x_operator"] = <?php echo $booking_list->operator->Lookup->toClientList() ?>;
fbookinglist.lists["x_operator"].options = <?php echo JsonEncode($booking_list->operator->lookupOptions()) ?>;

// Form object for search
var fbookinglistsrch = currentSearchForm = new ew.Form("fbookinglistsrch");

// Validate function for search
fbookinglistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbookinglistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbookinglistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbookinglistsrch.lists["x_product"] = <?php echo $booking_list->product->Lookup->toClientList() ?>;
fbookinglistsrch.lists["x_product"].options = <?php echo JsonEncode($booking_list->product->lookupOptions()) ?>;
fbookinglistsrch.lists["x_rid"] = <?php echo $booking_list->rid->Lookup->toClientList() ?>;
fbookinglistsrch.lists["x_rid"].options = <?php echo JsonEncode($booking_list->rid->lookupOptions()) ?>;

// Filters
fbookinglistsrch.filterList = <?php echo $booking_list->getFilterList() ?>;

// Init search panel as collapsed
fbookinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$booking->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($booking_list->TotalRecs > 0 && $booking_list->ExportOptions->visible()) { ?>
<?php $booking_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($booking_list->ImportOptions->visible()) { ?>
<?php $booking_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($booking_list->SearchOptions->visible()) { ?>
<?php $booking_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($booking_list->FilterOptions->visible()) { ?>
<?php $booking_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$booking_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$booking->isExport() && !$booking->CurrentAction) { ?>
<form name="fbookinglistsrch" id="fbookinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($booking_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbookinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="booking">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$booking_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$booking->RowType = ROWTYPE_SEARCH;

// Render row
$booking->resetAttributes();
$booking_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($booking->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $booking->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php $booking->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$booking->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_product" data-value-separator="<?php echo $booking->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $booking->product->editAttributes() ?>>
		<?php echo $booking->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $booking->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($booking->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $booking->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_rid" data-value-separator="<?php echo $booking->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $booking->rid->editAttributes() ?>>
		<?php echo $booking->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $booking->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($booking_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($booking_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $booking_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($booking_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($booking_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($booking_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($booking_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $booking_list->showPageHeader(); ?>
<?php
$booking_list->showMessage();
?>
<?php if ($booking_list->TotalRecs > 0 || $booking->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($booking_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> booking">
<?php if (!$booking->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$booking->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($booking_list->Pager)) $booking_list->Pager = new PrevNextPager($booking_list->StartRec, $booking_list->DisplayRecs, $booking_list->TotalRecs, $booking_list->AutoHidePager) ?>
<?php if ($booking_list->Pager->RecordCount > 0 && $booking_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($booking_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($booking_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $booking_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($booking_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($booking_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $booking_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($booking_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $booking_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $booking_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $booking_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($booking_list->TotalRecs > 0 && (!$booking_list->AutoHidePageSizeSelector || $booking_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="booking">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($booking_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($booking_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($booking_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($booking_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($booking_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($booking->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $booking_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbookinglist" id="fbookinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking">
<div id="gmp_booking" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($booking_list->TotalRecs > 0 || $booking->isGridEdit()) { ?>
<table id="tbl_bookinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$booking_list->RowType = ROWTYPE_HEADER;

// Render list options
$booking_list->renderListOptions();

// Render list options (header, left)
$booking_list->ListOptions->render("header", "left");
?>
<?php if ($booking->id->Visible) { // id ?>
	<?php if ($booking->sortUrl($booking->id) == "") { ?>
		<th data-name="id" class="<?php echo $booking->id->headerCellClass() ?>"><div id="elh_booking_id" class="booking_id"><div class="ew-table-header-caption"><?php echo $booking->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $booking->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->id) ?>',2);"><div id="elh_booking_id" class="booking_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->ref->Visible) { // ref ?>
	<?php if ($booking->sortUrl($booking->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $booking->ref->headerCellClass() ?>"><div id="elh_booking_ref" class="booking_ref"><div class="ew-table-header-caption"><?php echo $booking->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $booking->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->ref) ?>',2);"><div id="elh_booking_ref" class="booking_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->s_grp->Visible) { // s_grp ?>
	<?php if ($booking->sortUrl($booking->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $booking->s_grp->headerCellClass() ?>"><div id="elh_booking_s_grp" class="booking_s_grp"><div class="ew-table-header-caption"><?php echo $booking->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $booking->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->s_grp) ?>',2);"><div id="elh_booking_s_grp" class="booking_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->product->Visible) { // product ?>
	<?php if ($booking->sortUrl($booking->product) == "") { ?>
		<th data-name="product" class="<?php echo $booking->product->headerCellClass() ?>"><div id="elh_booking_product" class="booking_product"><div class="ew-table-header-caption"><?php echo $booking->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $booking->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->product) ?>',2);"><div id="elh_booking_product" class="booking_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->rid->Visible) { // rid ?>
	<?php if ($booking->sortUrl($booking->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $booking->rid->headerCellClass() ?>"><div id="elh_booking_rid" class="booking_rid"><div class="ew-table-header-caption"><?php echo $booking->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $booking->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->rid) ?>',2);"><div id="elh_booking_rid" class="booking_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->quantity->Visible) { // quantity ?>
	<?php if ($booking->sortUrl($booking->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $booking->quantity->headerCellClass() ?>"><div id="elh_booking_quantity" class="booking_quantity"><div class="ew-table-header-caption"><?php echo $booking->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $booking->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->quantity) ?>',2);"><div id="elh_booking_quantity" class="booking_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->b_quantity->Visible) { // b_quantity ?>
	<?php if ($booking->sortUrl($booking->b_quantity) == "") { ?>
		<th data-name="b_quantity" class="<?php echo $booking->b_quantity->headerCellClass() ?>"><div id="elh_booking_b_quantity" class="booking_b_quantity"><div class="ew-table-header-caption"><?php echo $booking->b_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_quantity" class="<?php echo $booking->b_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->b_quantity) ?>',2);"><div id="elh_booking_b_quantity" class="booking_b_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->b_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->b_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->b_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->booking_rate->Visible) { // booking_rate ?>
	<?php if ($booking->sortUrl($booking->booking_rate) == "") { ?>
		<th data-name="booking_rate" class="<?php echo $booking->booking_rate->headerCellClass() ?>"><div id="elh_booking_booking_rate" class="booking_booking_rate"><div class="ew-table-header-caption"><?php echo $booking->booking_rate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="booking_rate" class="<?php echo $booking->booking_rate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->booking_rate) ?>',2);"><div id="elh_booking_booking_rate" class="booking_booking_rate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->booking_rate->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->booking_rate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->booking_rate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->currency_current_rate->Visible) { // currency_current_rate ?>
	<?php if ($booking->sortUrl($booking->currency_current_rate) == "") { ?>
		<th data-name="currency_current_rate" class="<?php echo $booking->currency_current_rate->headerCellClass() ?>"><div id="elh_booking_currency_current_rate" class="booking_currency_current_rate"><div class="ew-table-header-caption"><?php echo $booking->currency_current_rate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency_current_rate" class="<?php echo $booking->currency_current_rate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->currency_current_rate) ?>',2);"><div id="elh_booking_currency_current_rate" class="booking_currency_current_rate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->currency_current_rate->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->currency_current_rate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->currency_current_rate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->booking_date->Visible) { // booking_date ?>
	<?php if ($booking->sortUrl($booking->booking_date) == "") { ?>
		<th data-name="booking_date" class="<?php echo $booking->booking_date->headerCellClass() ?>"><div id="elh_booking_booking_date" class="booking_booking_date"><div class="ew-table-header-caption"><?php echo $booking->booking_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="booking_date" class="<?php echo $booking->booking_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->booking_date) ?>',2);"><div id="elh_booking_booking_date" class="booking_booking_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->booking_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->booking_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->booking_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->shipment_date->Visible) { // shipment_date ?>
	<?php if ($booking->sortUrl($booking->shipment_date) == "") { ?>
		<th data-name="shipment_date" class="<?php echo $booking->shipment_date->headerCellClass() ?>"><div id="elh_booking_shipment_date" class="booking_shipment_date"><div class="ew-table-header-caption"><?php echo $booking->shipment_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipment_date" class="<?php echo $booking->shipment_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->shipment_date) ?>',2);"><div id="elh_booking_shipment_date" class="booking_shipment_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->shipment_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->shipment_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->shipment_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->remarks->Visible) { // remarks ?>
	<?php if ($booking->sortUrl($booking->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $booking->remarks->headerCellClass() ?>"><div id="elh_booking_remarks" class="booking_remarks"><div class="ew-table-header-caption"><?php echo $booking->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $booking->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->remarks) ?>',2);"><div id="elh_booking_remarks" class="booking_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($booking->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->status->Visible) { // status ?>
	<?php if ($booking->sortUrl($booking->status) == "") { ?>
		<th data-name="status" class="<?php echo $booking->status->headerCellClass() ?>"><div id="elh_booking_status" class="booking_status"><div class="ew-table-header-caption"><?php echo $booking->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $booking->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->status) ?>',2);"><div id="elh_booking_status" class="booking_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->operator->Visible) { // operator ?>
	<?php if ($booking->sortUrl($booking->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $booking->operator->headerCellClass() ?>"><div id="elh_booking_operator" class="booking_operator"><div class="ew-table-header-caption"><?php echo $booking->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $booking->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->operator) ?>',2);"><div id="elh_booking_operator" class="booking_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->datetime->Visible) { // datetime ?>
	<?php if ($booking->sortUrl($booking->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $booking->datetime->headerCellClass() ?>"><div id="elh_booking_datetime" class="booking_datetime"><div class="ew-table-header-caption"><?php echo $booking->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $booking->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->datetime) ?>',2);"><div id="elh_booking_datetime" class="booking_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($booking->confirm_quantity->Visible) { // confirm_quantity ?>
	<?php if ($booking->sortUrl($booking->confirm_quantity) == "") { ?>
		<th data-name="confirm_quantity" class="<?php echo $booking->confirm_quantity->headerCellClass() ?>"><div id="elh_booking_confirm_quantity" class="booking_confirm_quantity"><div class="ew-table-header-caption"><?php echo $booking->confirm_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="confirm_quantity" class="<?php echo $booking->confirm_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $booking->SortUrl($booking->confirm_quantity) ?>',2);"><div id="elh_booking_confirm_quantity" class="booking_confirm_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $booking->confirm_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($booking->confirm_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($booking->confirm_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$booking_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($booking->ExportAll && $booking->isExport()) {
	$booking_list->StopRec = $booking_list->TotalRecs;
} else {

	// Set the last record to display
	if ($booking_list->TotalRecs > $booking_list->StartRec + $booking_list->DisplayRecs - 1)
		$booking_list->StopRec = $booking_list->StartRec + $booking_list->DisplayRecs - 1;
	else
		$booking_list->StopRec = $booking_list->TotalRecs;
}
$booking_list->RecCnt = $booking_list->StartRec - 1;
if ($booking_list->Recordset && !$booking_list->Recordset->EOF) {
	$booking_list->Recordset->moveFirst();
	$selectLimit = $booking_list->UseSelectLimit;
	if (!$selectLimit && $booking_list->StartRec > 1)
		$booking_list->Recordset->move($booking_list->StartRec - 1);
} elseif (!$booking->AllowAddDeleteRow && $booking_list->StopRec == 0) {
	$booking_list->StopRec = $booking->GridAddRowCount;
}

// Initialize aggregate
$booking->RowType = ROWTYPE_AGGREGATEINIT;
$booking->resetAttributes();
$booking_list->renderRow();
while ($booking_list->RecCnt < $booking_list->StopRec) {
	$booking_list->RecCnt++;
	if ($booking_list->RecCnt >= $booking_list->StartRec) {
		$booking_list->RowCnt++;

		// Set up key count
		$booking_list->KeyCount = $booking_list->RowIndex;

		// Init row class and style
		$booking->resetAttributes();
		$booking->CssClass = "";
		if ($booking->isGridAdd()) {
		} else {
			$booking_list->loadRowValues($booking_list->Recordset); // Load row values
		}
		$booking->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$booking->RowAttrs = array_merge($booking->RowAttrs, array('data-rowindex'=>$booking_list->RowCnt, 'id'=>'r' . $booking_list->RowCnt . '_booking', 'data-rowtype'=>$booking->RowType));

		// Render row
		$booking_list->renderRow();

		// Render list options
		$booking_list->renderListOptions();
?>
	<tr<?php echo $booking->rowAttributes() ?>>
<?php

// Render list options (body, left)
$booking_list->ListOptions->render("body", "left", $booking_list->RowCnt);
?>
	<?php if ($booking->id->Visible) { // id ?>
		<td data-name="id"<?php echo $booking->id->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_id" class="booking_id">
<span<?php echo $booking->id->viewAttributes() ?>>
<?php if ((!EmptyString($booking->id->getViewValue())) && $booking->id->linkAttributes() <> "") { ?>
<a<?php echo $booking->id->linkAttributes() ?>><?php echo $booking->id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $booking->ref->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_ref" class="booking_ref">
<span<?php echo $booking->ref->viewAttributes() ?>>
<?php echo $booking->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $booking->s_grp->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_s_grp" class="booking_s_grp">
<span<?php echo $booking->s_grp->viewAttributes() ?>>
<?php echo $booking->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->product->Visible) { // product ?>
		<td data-name="product"<?php echo $booking->product->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_product" class="booking_product">
<span<?php echo $booking->product->viewAttributes() ?>>
<?php if ((!EmptyString($booking->product->getViewValue())) && $booking->product->linkAttributes() <> "") { ?>
<a<?php echo $booking->product->linkAttributes() ?>><?php echo $booking->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $booking->rid->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_rid" class="booking_rid">
<span<?php echo $booking->rid->viewAttributes() ?>>
<?php if ((!EmptyString($booking->rid->getViewValue())) && $booking->rid->linkAttributes() <> "") { ?>
<a<?php echo $booking->rid->linkAttributes() ?>><?php echo $booking->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $booking->quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_quantity" class="booking_quantity">
<span<?php echo $booking->quantity->viewAttributes() ?>>
<?php echo $booking->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->b_quantity->Visible) { // b_quantity ?>
		<td data-name="b_quantity"<?php echo $booking->b_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_b_quantity" class="booking_b_quantity">
<span<?php echo $booking->b_quantity->viewAttributes() ?>>
<?php echo $booking->b_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->booking_rate->Visible) { // booking_rate ?>
		<td data-name="booking_rate"<?php echo $booking->booking_rate->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_booking_rate" class="booking_booking_rate">
<span<?php echo $booking->booking_rate->viewAttributes() ?>>
<?php echo $booking->booking_rate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->currency_current_rate->Visible) { // currency_current_rate ?>
		<td data-name="currency_current_rate"<?php echo $booking->currency_current_rate->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_currency_current_rate" class="booking_currency_current_rate">
<span<?php echo $booking->currency_current_rate->viewAttributes() ?>>
<?php echo $booking->currency_current_rate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->booking_date->Visible) { // booking_date ?>
		<td data-name="booking_date"<?php echo $booking->booking_date->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_booking_date" class="booking_booking_date">
<span<?php echo $booking->booking_date->viewAttributes() ?>>
<?php echo $booking->booking_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->shipment_date->Visible) { // shipment_date ?>
		<td data-name="shipment_date"<?php echo $booking->shipment_date->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_shipment_date" class="booking_shipment_date">
<span<?php echo $booking->shipment_date->viewAttributes() ?>>
<?php echo $booking->shipment_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $booking->remarks->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_remarks" class="booking_remarks">
<span<?php echo $booking->remarks->viewAttributes() ?>>
<?php echo $booking->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->status->Visible) { // status ?>
		<td data-name="status"<?php echo $booking->status->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_status" class="booking_status">
<span<?php echo $booking->status->viewAttributes() ?>>
<?php echo $booking->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $booking->operator->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_operator" class="booking_operator">
<span<?php echo $booking->operator->viewAttributes() ?>>
<?php echo $booking->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $booking->datetime->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_datetime" class="booking_datetime">
<span<?php echo $booking->datetime->viewAttributes() ?>>
<?php echo $booking->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($booking->confirm_quantity->Visible) { // confirm_quantity ?>
		<td data-name="confirm_quantity"<?php echo $booking->confirm_quantity->cellAttributes() ?>>
<span id="el<?php echo $booking_list->RowCnt ?>_booking_confirm_quantity" class="booking_confirm_quantity">
<span<?php echo $booking->confirm_quantity->viewAttributes() ?>>
<?php echo $booking->confirm_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$booking_list->ListOptions->render("body", "right", $booking_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$booking->isGridAdd())
		$booking_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$booking->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($booking_list->Recordset)
	$booking_list->Recordset->Close();
?>
<?php if (!$booking->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$booking->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($booking_list->Pager)) $booking_list->Pager = new PrevNextPager($booking_list->StartRec, $booking_list->DisplayRecs, $booking_list->TotalRecs, $booking_list->AutoHidePager) ?>
<?php if ($booking_list->Pager->RecordCount > 0 && $booking_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($booking_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($booking_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $booking_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($booking_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($booking_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $booking_list->pageUrl() ?>start=<?php echo $booking_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $booking_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($booking_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $booking_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $booking_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $booking_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($booking_list->TotalRecs > 0 && (!$booking_list->AutoHidePageSizeSelector || $booking_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="booking">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($booking_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($booking_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($booking_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($booking_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($booking_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($booking->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $booking_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($booking_list->TotalRecs == 0 && !$booking->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $booking_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$booking_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$booking->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$booking->isExport()) { ?>
<script>
ew.scrollableTable("gmp_booking", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$booking_list->terminate();
?>