<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_search = new booking_search();

// Run the page
$booking_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($booking_search->IsModal) { ?>
var fbookingsearch = currentAdvancedSearchForm = new ew.Form("fbookingsearch", "search");
<?php } else { ?>
var fbookingsearch = currentForm = new ew.Form("fbookingsearch", "search");
<?php } ?>

// Form_CustomValidate event
fbookingsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbookingsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbookingsearch.lists["x_s_grp"] = <?php echo $booking_search->s_grp->Lookup->toClientList() ?>;
fbookingsearch.lists["x_s_grp"].options = <?php echo JsonEncode($booking_search->s_grp->lookupOptions()) ?>;
fbookingsearch.lists["x_product"] = <?php echo $booking_search->product->Lookup->toClientList() ?>;
fbookingsearch.lists["x_product"].options = <?php echo JsonEncode($booking_search->product->lookupOptions()) ?>;
fbookingsearch.lists["x_agent"] = <?php echo $booking_search->agent->Lookup->toClientList() ?>;
fbookingsearch.lists["x_agent"].options = <?php echo JsonEncode($booking_search->agent->lookupOptions()) ?>;
fbookingsearch.lists["x_booking_currency"] = <?php echo $booking_search->booking_currency->Lookup->toClientList() ?>;
fbookingsearch.lists["x_booking_currency"].options = <?php echo JsonEncode($booking_search->booking_currency->lookupOptions()) ?>;
fbookingsearch.lists["x_our_port"] = <?php echo $booking_search->our_port->Lookup->toClientList() ?>;
fbookingsearch.lists["x_our_port"].options = <?php echo JsonEncode($booking_search->our_port->lookupOptions()) ?>;
fbookingsearch.lists["x_status"] = <?php echo $booking_search->status->Lookup->toClientList() ?>;
fbookingsearch.lists["x_status"].options = <?php echo JsonEncode($booking_search->status->options(FALSE, TRUE)) ?>;
fbookingsearch.lists["x_operator"] = <?php echo $booking_search->operator->Lookup->toClientList() ?>;
fbookingsearch.lists["x_operator"].options = <?php echo JsonEncode($booking_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbookingsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_b_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking->b_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_booking_rate");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking->booking_rate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_currency_current_rate");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking->currency_current_rate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_booking_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking->booking_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_shipment_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking->shipment_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_confirm_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($booking->confirm_quantity->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $booking_search->showPageHeader(); ?>
<?php
$booking_search->showMessage();
?>
<form name="fbookingsearch" id="fbookingsearch" class="<?php echo $booking_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$booking_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($booking->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_id"><?php echo $booking->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->id->cellAttributes() ?>>
			<span id="el_booking_id">
<input type="text" data-table="booking" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($booking->id->getPlaceHolder()) ?>" value="<?php echo $booking->id->EditValue ?>"<?php echo $booking->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_ref"><?php echo $booking->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->ref->cellAttributes() ?>>
			<span id="el_booking_ref">
<input type="text" data-table="booking" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($booking->ref->getPlaceHolder()) ?>" value="<?php echo $booking->ref->EditValue ?>"<?php echo $booking->ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_s_grp"><?php echo $booking->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->s_grp->cellAttributes() ?>>
			<span id="el_booking_s_grp">
<?php $booking->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$booking->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_s_grp" data-value-separator="<?php echo $booking->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $booking->s_grp->editAttributes() ?>>
		<?php echo $booking->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $booking->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_product"><?php echo $booking->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->product->cellAttributes() ?>>
			<span id="el_booking_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_product" data-value-separator="<?php echo $booking->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $booking->product->editAttributes() ?>>
		<?php echo $booking->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $booking->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label for="x_agent" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_agent"><?php echo $booking->agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_agent" id="z_agent" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->agent->cellAttributes() ?>>
			<span id="el_booking_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_agent" data-value-separator="<?php echo $booking->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $booking->agent->editAttributes() ?>>
		<?php echo $booking->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $booking->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->b_quantity->Visible) { // b_quantity ?>
	<div id="r_b_quantity" class="form-group row">
		<label for="x_b_quantity" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_b_quantity"><?php echo $booking->b_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_b_quantity" id="z_b_quantity" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->b_quantity->cellAttributes() ?>>
			<span id="el_booking_b_quantity">
<input type="text" data-table="booking" data-field="x_b_quantity" name="x_b_quantity" id="x_b_quantity" size="30" placeholder="<?php echo HtmlEncode($booking->b_quantity->getPlaceHolder()) ?>" value="<?php echo $booking->b_quantity->EditValue ?>"<?php echo $booking->b_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->booking_rate->Visible) { // booking_rate ?>
	<div id="r_booking_rate" class="form-group row">
		<label for="x_booking_rate" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_booking_rate"><?php echo $booking->booking_rate->caption() ?></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->booking_rate->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_booking_rate" id="z_booking_rate" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking->booking_rate->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_booking_rate">
<input type="text" data-table="booking" data-field="x_booking_rate" name="x_booking_rate" id="x_booking_rate" size="30" placeholder="<?php echo HtmlEncode($booking->booking_rate->getPlaceHolder()) ?>" value="<?php echo $booking->booking_rate->EditValue ?>"<?php echo $booking->booking_rate->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_booking_rate d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_booking_rate" class="btw1_booking_rate d-none">
<input type="text" data-table="booking" data-field="x_booking_rate" name="y_booking_rate" id="y_booking_rate" size="30" placeholder="<?php echo HtmlEncode($booking->booking_rate->getPlaceHolder()) ?>" value="<?php echo $booking->booking_rate->EditValue2 ?>"<?php echo $booking->booking_rate->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->booking_currency->Visible) { // booking_currency ?>
	<div id="r_booking_currency" class="form-group row">
		<label for="x_booking_currency" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_booking_currency"><?php echo $booking->booking_currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_booking_currency" id="z_booking_currency" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->booking_currency->cellAttributes() ?>>
			<span id="el_booking_booking_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_booking_currency" data-value-separator="<?php echo $booking->booking_currency->displayValueSeparatorAttribute() ?>" id="x_booking_currency" name="x_booking_currency"<?php echo $booking->booking_currency->editAttributes() ?>>
		<?php echo $booking->booking_currency->selectOptionListHtml("x_booking_currency") ?>
	</select>
</div>
<?php echo $booking->booking_currency->Lookup->getParamTag("p_x_booking_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->currency_current_rate->Visible) { // currency_current_rate ?>
	<div id="r_currency_current_rate" class="form-group row">
		<label for="x_currency_current_rate" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_currency_current_rate"><?php echo $booking->currency_current_rate->caption() ?></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->currency_current_rate->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_currency_current_rate" id="z_currency_current_rate" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking->currency_current_rate->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_currency_current_rate">
<input type="text" data-table="booking" data-field="x_currency_current_rate" name="x_currency_current_rate" id="x_currency_current_rate" size="30" placeholder="<?php echo HtmlEncode($booking->currency_current_rate->getPlaceHolder()) ?>" value="<?php echo $booking->currency_current_rate->EditValue ?>"<?php echo $booking->currency_current_rate->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_currency_current_rate d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_currency_current_rate" class="btw1_currency_current_rate d-none">
<input type="text" data-table="booking" data-field="x_currency_current_rate" name="y_currency_current_rate" id="y_currency_current_rate" size="30" placeholder="<?php echo HtmlEncode($booking->currency_current_rate->getPlaceHolder()) ?>" value="<?php echo $booking->currency_current_rate->EditValue2 ?>"<?php echo $booking->currency_current_rate->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->booking_date->Visible) { // booking_date ?>
	<div id="r_booking_date" class="form-group row">
		<label for="x_booking_date" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_booking_date"><?php echo $booking->booking_date->caption() ?></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->booking_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_booking_date" id="z_booking_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking->booking_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_booking_date">
<input type="text" data-table="booking" data-field="x_booking_date" name="x_booking_date" id="x_booking_date" placeholder="<?php echo HtmlEncode($booking->booking_date->getPlaceHolder()) ?>" value="<?php echo $booking->booking_date->EditValue ?>"<?php echo $booking->booking_date->editAttributes() ?>>
<?php if (!$booking->booking_date->ReadOnly && !$booking->booking_date->Disabled && !isset($booking->booking_date->EditAttrs["readonly"]) && !isset($booking->booking_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbookingsearch", "x_booking_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_booking_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_booking_date" class="btw1_booking_date d-none">
<input type="text" data-table="booking" data-field="x_booking_date" name="y_booking_date" id="y_booking_date" placeholder="<?php echo HtmlEncode($booking->booking_date->getPlaceHolder()) ?>" value="<?php echo $booking->booking_date->EditValue2 ?>"<?php echo $booking->booking_date->editAttributes() ?>>
<?php if (!$booking->booking_date->ReadOnly && !$booking->booking_date->Disabled && !isset($booking->booking_date->EditAttrs["readonly"]) && !isset($booking->booking_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbookingsearch", "y_booking_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->shipment_date->Visible) { // shipment_date ?>
	<div id="r_shipment_date" class="form-group row">
		<label for="x_shipment_date" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_shipment_date"><?php echo $booking->shipment_date->caption() ?></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->shipment_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_shipment_date" id="z_shipment_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($booking->shipment_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_booking_shipment_date">
<input type="text" data-table="booking" data-field="x_shipment_date" name="x_shipment_date" id="x_shipment_date" placeholder="<?php echo HtmlEncode($booking->shipment_date->getPlaceHolder()) ?>" value="<?php echo $booking->shipment_date->EditValue ?>"<?php echo $booking->shipment_date->editAttributes() ?>>
<?php if (!$booking->shipment_date->ReadOnly && !$booking->shipment_date->Disabled && !isset($booking->shipment_date->EditAttrs["readonly"]) && !isset($booking->shipment_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbookingsearch", "x_shipment_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_shipment_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_booking_shipment_date" class="btw1_shipment_date d-none">
<input type="text" data-table="booking" data-field="x_shipment_date" name="y_shipment_date" id="y_shipment_date" placeholder="<?php echo HtmlEncode($booking->shipment_date->getPlaceHolder()) ?>" value="<?php echo $booking->shipment_date->EditValue2 ?>"<?php echo $booking->shipment_date->editAttributes() ?>>
<?php if (!$booking->shipment_date->ReadOnly && !$booking->shipment_date->Disabled && !isset($booking->shipment_date->EditAttrs["readonly"]) && !isset($booking->shipment_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbookingsearch", "y_shipment_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->our_port->Visible) { // our_port ?>
	<div id="r_our_port" class="form-group row">
		<label for="x_our_port" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_our_port"><?php echo $booking->our_port->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_our_port" id="z_our_port" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->our_port->cellAttributes() ?>>
			<span id="el_booking_our_port">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_our_port" data-value-separator="<?php echo $booking->our_port->displayValueSeparatorAttribute() ?>" id="x_our_port" name="x_our_port"<?php echo $booking->our_port->editAttributes() ?>>
		<?php echo $booking->our_port->selectOptionListHtml("x_our_port") ?>
	</select>
</div>
<?php echo $booking->our_port->Lookup->getParamTag("p_x_our_port") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_remarks"><?php echo $booking->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->remarks->cellAttributes() ?>>
			<span id="el_booking_remarks">
<input type="text" data-table="booking" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($booking->remarks->getPlaceHolder()) ?>" value="<?php echo $booking->remarks->EditValue ?>"<?php echo $booking->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_status"><?php echo $booking->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->status->cellAttributes() ?>>
			<span id="el_booking_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_status" data-value-separator="<?php echo $booking->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $booking->status->editAttributes() ?>>
		<?php echo $booking->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_operator"><?php echo $booking->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->operator->cellAttributes() ?>>
			<span id="el_booking_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="booking" data-field="x_operator" data-value-separator="<?php echo $booking->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $booking->operator->editAttributes() ?>>
		<?php echo $booking->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $booking->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_datetime"><?php echo $booking->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->datetime->cellAttributes() ?>>
			<span id="el_booking_datetime">
<input type="text" data-table="booking" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($booking->datetime->getPlaceHolder()) ?>" value="<?php echo $booking->datetime->EditValue ?>"<?php echo $booking->datetime->editAttributes() ?>>
<?php if (!$booking->datetime->ReadOnly && !$booking->datetime->Disabled && !isset($booking->datetime->EditAttrs["readonly"]) && !isset($booking->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbookingsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($booking->confirm_quantity->Visible) { // confirm_quantity ?>
	<div id="r_confirm_quantity" class="form-group row">
		<label for="x_confirm_quantity" class="<?php echo $booking_search->LeftColumnClass ?>"><span id="elh_booking_confirm_quantity"><?php echo $booking->confirm_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_confirm_quantity" id="z_confirm_quantity" value="="></span>
		</label>
		<div class="<?php echo $booking_search->RightColumnClass ?>"><div<?php echo $booking->confirm_quantity->cellAttributes() ?>>
			<span id="el_booking_confirm_quantity">
<input type="text" data-table="booking" data-field="x_confirm_quantity" name="x_confirm_quantity" id="x_confirm_quantity" size="30" placeholder="<?php echo HtmlEncode($booking->confirm_quantity->getPlaceHolder()) ?>" value="<?php echo $booking->confirm_quantity->EditValue ?>"<?php echo $booking->confirm_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$booking_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $booking_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$booking_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$booking_search->terminate();
?>