<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$booking_view = new booking_view();

// Run the page
$booking_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$booking_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$booking->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbookingview = currentForm = new ew.Form("fbookingview", "view");

// Form_CustomValidate event
fbookingview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbookingview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbookingview.lists["x_supplier"] = <?php echo $booking_view->supplier->Lookup->toClientList() ?>;
fbookingview.lists["x_supplier"].options = <?php echo JsonEncode($booking_view->supplier->lookupOptions()) ?>;
fbookingview.lists["x_s_grp"] = <?php echo $booking_view->s_grp->Lookup->toClientList() ?>;
fbookingview.lists["x_s_grp"].options = <?php echo JsonEncode($booking_view->s_grp->lookupOptions()) ?>;
fbookingview.lists["x_product"] = <?php echo $booking_view->product->Lookup->toClientList() ?>;
fbookingview.lists["x_product"].options = <?php echo JsonEncode($booking_view->product->lookupOptions()) ?>;
fbookingview.lists["x_rid"] = <?php echo $booking_view->rid->Lookup->toClientList() ?>;
fbookingview.lists["x_rid"].options = <?php echo JsonEncode($booking_view->rid->lookupOptions()) ?>;
fbookingview.lists["x_agent"] = <?php echo $booking_view->agent->Lookup->toClientList() ?>;
fbookingview.lists["x_agent"].options = <?php echo JsonEncode($booking_view->agent->lookupOptions()) ?>;
fbookingview.lists["x_booking_currency"] = <?php echo $booking_view->booking_currency->Lookup->toClientList() ?>;
fbookingview.lists["x_booking_currency"].options = <?php echo JsonEncode($booking_view->booking_currency->lookupOptions()) ?>;
fbookingview.lists["x_our_port"] = <?php echo $booking_view->our_port->Lookup->toClientList() ?>;
fbookingview.lists["x_our_port"].options = <?php echo JsonEncode($booking_view->our_port->lookupOptions()) ?>;
fbookingview.lists["x_status"] = <?php echo $booking_view->status->Lookup->toClientList() ?>;
fbookingview.lists["x_status"].options = <?php echo JsonEncode($booking_view->status->options(FALSE, TRUE)) ?>;
fbookingview.lists["x_operator"] = <?php echo $booking_view->operator->Lookup->toClientList() ?>;
fbookingview.lists["x_operator"].options = <?php echo JsonEncode($booking_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$booking->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $booking_view->ExportOptions->render("body") ?>
<?php $booking_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $booking_view->showPageHeader(); ?>
<?php
$booking_view->showMessage();
?>
<form name="fbookingview" id="fbookingview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($booking_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $booking_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="booking">
<input type="hidden" name="modal" value="<?php echo (int)$booking_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($booking->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_id"><?php echo $booking->id->caption() ?></span></td>
		<td data-name="id"<?php echo $booking->id->cellAttributes() ?>>
<span id="el_booking_id">
<span<?php echo $booking->id->viewAttributes() ?>>
<?php if ((!EmptyString($booking->id->getViewValue())) && $booking->id->linkAttributes() <> "") { ?>
<a<?php echo $booking->id->linkAttributes() ?>><?php echo $booking->id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->supplier->Visible) { // supplier ?>
	<tr id="r_supplier">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_supplier"><?php echo $booking->supplier->caption() ?></span></td>
		<td data-name="supplier"<?php echo $booking->supplier->cellAttributes() ?>>
<span id="el_booking_supplier">
<span<?php echo $booking->supplier->viewAttributes() ?>>
<?php echo $booking->supplier->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_ref"><?php echo $booking->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $booking->ref->cellAttributes() ?>>
<span id="el_booking_ref">
<span<?php echo $booking->ref->viewAttributes() ?>>
<?php echo $booking->ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_s_grp"><?php echo $booking->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $booking->s_grp->cellAttributes() ?>>
<span id="el_booking_s_grp">
<span<?php echo $booking->s_grp->viewAttributes() ?>>
<?php echo $booking->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_product"><?php echo $booking->product->caption() ?></span></td>
		<td data-name="product"<?php echo $booking->product->cellAttributes() ?>>
<span id="el_booking_product">
<span<?php echo $booking->product->viewAttributes() ?>>
<?php if ((!EmptyString($booking->product->getViewValue())) && $booking->product->linkAttributes() <> "") { ?>
<a<?php echo $booking->product->linkAttributes() ?>><?php echo $booking->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_rid"><?php echo $booking->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $booking->rid->cellAttributes() ?>>
<span id="el_booking_rid">
<span<?php echo $booking->rid->viewAttributes() ?>>
<?php if ((!EmptyString($booking->rid->getViewValue())) && $booking->rid->linkAttributes() <> "") { ?>
<a<?php echo $booking->rid->linkAttributes() ?>><?php echo $booking->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->agent->Visible) { // agent ?>
	<tr id="r_agent">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_agent"><?php echo $booking->agent->caption() ?></span></td>
		<td data-name="agent"<?php echo $booking->agent->cellAttributes() ?>>
<span id="el_booking_agent">
<span<?php echo $booking->agent->viewAttributes() ?>>
<?php if ((!EmptyString($booking->agent->getViewValue())) && $booking->agent->linkAttributes() <> "") { ?>
<a<?php echo $booking->agent->linkAttributes() ?>><?php echo $booking->agent->getViewValue() ?></a>
<?php } else { ?>
<?php echo $booking->agent->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_quantity"><?php echo $booking->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $booking->quantity->cellAttributes() ?>>
<span id="el_booking_quantity">
<span<?php echo $booking->quantity->viewAttributes() ?>>
<?php echo $booking->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->b_quantity->Visible) { // b_quantity ?>
	<tr id="r_b_quantity">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_b_quantity"><?php echo $booking->b_quantity->caption() ?></span></td>
		<td data-name="b_quantity"<?php echo $booking->b_quantity->cellAttributes() ?>>
<span id="el_booking_b_quantity">
<span<?php echo $booking->b_quantity->viewAttributes() ?>>
<?php echo $booking->b_quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->containers->Visible) { // containers ?>
	<tr id="r_containers">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_containers"><?php echo $booking->containers->caption() ?></span></td>
		<td data-name="containers"<?php echo $booking->containers->cellAttributes() ?>>
<span id="el_booking_containers">
<span<?php echo $booking->containers->viewAttributes() ?>>
<?php echo $booking->containers->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->booking_rate->Visible) { // booking_rate ?>
	<tr id="r_booking_rate">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_booking_rate"><?php echo $booking->booking_rate->caption() ?></span></td>
		<td data-name="booking_rate"<?php echo $booking->booking_rate->cellAttributes() ?>>
<span id="el_booking_booking_rate">
<span<?php echo $booking->booking_rate->viewAttributes() ?>>
<?php echo $booking->booking_rate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->booking_currency->Visible) { // booking_currency ?>
	<tr id="r_booking_currency">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_booking_currency"><?php echo $booking->booking_currency->caption() ?></span></td>
		<td data-name="booking_currency"<?php echo $booking->booking_currency->cellAttributes() ?>>
<span id="el_booking_booking_currency">
<span<?php echo $booking->booking_currency->viewAttributes() ?>>
<?php echo $booking->booking_currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->currency_current_rate->Visible) { // currency_current_rate ?>
	<tr id="r_currency_current_rate">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_currency_current_rate"><?php echo $booking->currency_current_rate->caption() ?></span></td>
		<td data-name="currency_current_rate"<?php echo $booking->currency_current_rate->cellAttributes() ?>>
<span id="el_booking_currency_current_rate">
<span<?php echo $booking->currency_current_rate->viewAttributes() ?>>
<?php echo $booking->currency_current_rate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->booking_date->Visible) { // booking_date ?>
	<tr id="r_booking_date">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_booking_date"><?php echo $booking->booking_date->caption() ?></span></td>
		<td data-name="booking_date"<?php echo $booking->booking_date->cellAttributes() ?>>
<span id="el_booking_booking_date">
<span<?php echo $booking->booking_date->viewAttributes() ?>>
<?php echo $booking->booking_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->shipment_date->Visible) { // shipment_date ?>
	<tr id="r_shipment_date">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_shipment_date"><?php echo $booking->shipment_date->caption() ?></span></td>
		<td data-name="shipment_date"<?php echo $booking->shipment_date->cellAttributes() ?>>
<span id="el_booking_shipment_date">
<span<?php echo $booking->shipment_date->viewAttributes() ?>>
<?php echo $booking->shipment_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->our_port->Visible) { // our_port ?>
	<tr id="r_our_port">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_our_port"><?php echo $booking->our_port->caption() ?></span></td>
		<td data-name="our_port"<?php echo $booking->our_port->cellAttributes() ?>>
<span id="el_booking_our_port">
<span<?php echo $booking->our_port->viewAttributes() ?>>
<?php echo $booking->our_port->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_remarks"><?php echo $booking->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $booking->remarks->cellAttributes() ?>>
<span id="el_booking_remarks">
<span<?php echo $booking->remarks->viewAttributes() ?>>
<?php echo $booking->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_status"><?php echo $booking->status->caption() ?></span></td>
		<td data-name="status"<?php echo $booking->status->cellAttributes() ?>>
<span id="el_booking_status">
<span<?php echo $booking->status->viewAttributes() ?>>
<?php echo $booking->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_operator"><?php echo $booking->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $booking->operator->cellAttributes() ?>>
<span id="el_booking_operator">
<span<?php echo $booking->operator->viewAttributes() ?>>
<?php echo $booking->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_datetime"><?php echo $booking->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $booking->datetime->cellAttributes() ?>>
<span id="el_booking_datetime">
<span<?php echo $booking->datetime->viewAttributes() ?>>
<?php echo $booking->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($booking->confirm_quantity->Visible) { // confirm_quantity ?>
	<tr id="r_confirm_quantity">
		<td class="<?php echo $booking_view->TableLeftColumnClass ?>"><span id="elh_booking_confirm_quantity"><?php echo $booking->confirm_quantity->caption() ?></span></td>
		<td data-name="confirm_quantity"<?php echo $booking->confirm_quantity->cellAttributes() ?>>
<span id="el_booking_confirm_quantity">
<span<?php echo $booking->confirm_quantity->viewAttributes() ?>>
<?php echo $booking->confirm_quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$booking_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$booking->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$booking_view->terminate();
?>