<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_product_ref_fp_add = new buyer_product_ref_fp_add();

// Run the page
$buyer_product_ref_fp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_product_ref_fp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fbuyer_product_ref_fpadd = currentForm = new ew.Form("fbuyer_product_ref_fpadd", "add");

// Validate form
fbuyer_product_ref_fpadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($buyer_product_ref_fp_add->partner->Required) { ?>
			elm = this.getElements("x" + infix + "_partner");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->partner->caption(), $buyer_product_ref_fp->partner->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->partner_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->partner_ref->caption(), $buyer_product_ref_fp->partner_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->_barcode->caption(), $buyer_product_ref_fp->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->grp->caption(), $buyer_product_ref_fp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->s_grp->caption(), $buyer_product_ref_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->product->caption(), $buyer_product_ref_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->rid->caption(), $buyer_product_ref_fp->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->gcode->Required) { ?>
			elm = this.getElements("x" + infix + "_gcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->gcode->caption(), $buyer_product_ref_fp->gcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->batch_no->caption(), $buyer_product_ref_fp->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_fp->batch_no->errorMessage()) ?>");
		<?php if ($buyer_product_ref_fp_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->price->caption(), $buyer_product_ref_fp->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_fp->price->errorMessage()) ?>");
		<?php if ($buyer_product_ref_fp_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->status->caption(), $buyer_product_ref_fp->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->operator->caption(), $buyer_product_ref_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->datetime->caption(), $buyer_product_ref_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->w_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->w_cm->caption(), $buyer_product_ref_fp->w_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_fp->w_cm->errorMessage()) ?>");
		<?php if ($buyer_product_ref_fp_add->l_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->l_cm->caption(), $buyer_product_ref_fp->l_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_fp->l_cm->errorMessage()) ?>");
		<?php if ($buyer_product_ref_fp_add->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->shape->caption(), $buyer_product_ref_fp->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_fp_add->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_fp->currency->caption(), $buyer_product_ref_fp->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_fp->currency->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbuyer_product_ref_fpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyer_product_ref_fpadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyer_product_ref_fpadd.lists["x_partner"] = <?php echo $buyer_product_ref_fp_add->partner->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_partner"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->partner->lookupOptions()) ?>;
fbuyer_product_ref_fpadd.lists["x_grp"] = <?php echo $buyer_product_ref_fp_add->grp->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_grp"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->grp->options(FALSE, TRUE)) ?>;
fbuyer_product_ref_fpadd.lists["x_s_grp"] = <?php echo $buyer_product_ref_fp_add->s_grp->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_s_grp"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->s_grp->lookupOptions()) ?>;
fbuyer_product_ref_fpadd.lists["x_product"] = <?php echo $buyer_product_ref_fp_add->product->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_product"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->product->lookupOptions()) ?>;
fbuyer_product_ref_fpadd.lists["x_rid"] = <?php echo $buyer_product_ref_fp_add->rid->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_rid"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->rid->lookupOptions()) ?>;
fbuyer_product_ref_fpadd.lists["x_gcode"] = <?php echo $buyer_product_ref_fp_add->gcode->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_gcode"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->gcode->lookupOptions()) ?>;
fbuyer_product_ref_fpadd.lists["x_status"] = <?php echo $buyer_product_ref_fp_add->status->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_status"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->status->options(FALSE, TRUE)) ?>;
fbuyer_product_ref_fpadd.lists["x_operator"] = <?php echo $buyer_product_ref_fp_add->operator->Lookup->toClientList() ?>;
fbuyer_product_ref_fpadd.lists["x_operator"].options = <?php echo JsonEncode($buyer_product_ref_fp_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $buyer_product_ref_fp_add->showPageHeader(); ?>
<?php
$buyer_product_ref_fp_add->showMessage();
?>
<form name="fbuyer_product_ref_fpadd" id="fbuyer_product_ref_fpadd" class="<?php echo $buyer_product_ref_fp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_product_ref_fp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_product_ref_fp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer_product_ref_fp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$buyer_product_ref_fp_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($buyer_product_ref_fp->partner->Visible) { // partner ?>
	<div id="r_partner" class="form-group row">
		<label id="elh_buyer_product_ref_fp_partner" for="x_partner" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->partner->caption() ?><?php echo ($buyer_product_ref_fp->partner->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->partner->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_partner">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_fp" data-field="x_partner" data-value-separator="<?php echo $buyer_product_ref_fp->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $buyer_product_ref_fp->partner->editAttributes() ?>>
		<?php echo $buyer_product_ref_fp->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $buyer_product_ref_fp->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
<?php echo $buyer_product_ref_fp->partner->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->partner_ref->Visible) { // partner_ref ?>
	<div id="r_partner_ref" class="form-group row">
		<label id="elh_buyer_product_ref_fp_partner_ref" for="x_partner_ref" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->partner_ref->caption() ?><?php echo ($buyer_product_ref_fp->partner_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->partner_ref->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_partner_ref">
<input type="text" data-table="buyer_product_ref_fp" data-field="x_partner_ref" name="x_partner_ref" id="x_partner_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->partner_ref->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->partner_ref->EditValue ?>"<?php echo $buyer_product_ref_fp->partner_ref->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->partner_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_buyer_product_ref_fp__barcode" for="x__barcode" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->_barcode->caption() ?><?php echo ($buyer_product_ref_fp->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->_barcode->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp__barcode">
<input type="text" data-table="buyer_product_ref_fp" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->_barcode->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->_barcode->EditValue ?>"<?php echo $buyer_product_ref_fp->_barcode->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_buyer_product_ref_fp_grp" for="x_grp" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->grp->caption() ?><?php echo ($buyer_product_ref_fp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->grp->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_grp">
<?php $buyer_product_ref_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer_product_ref_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_fp" data-field="x_grp" data-value-separator="<?php echo $buyer_product_ref_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $buyer_product_ref_fp->grp->editAttributes() ?>>
		<?php echo $buyer_product_ref_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $buyer_product_ref_fp->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_buyer_product_ref_fp_s_grp" for="x_s_grp" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->s_grp->caption() ?><?php echo ($buyer_product_ref_fp->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->s_grp->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_s_grp">
<?php $buyer_product_ref_fp->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer_product_ref_fp->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_fp" data-field="x_s_grp" data-value-separator="<?php echo $buyer_product_ref_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $buyer_product_ref_fp->s_grp->editAttributes() ?>>
		<?php echo $buyer_product_ref_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $buyer_product_ref_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $buyer_product_ref_fp->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_buyer_product_ref_fp_product" for="x_product" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->product->caption() ?><?php echo ($buyer_product_ref_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->product->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_product">
<?php $buyer_product_ref_fp->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer_product_ref_fp->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_fp" data-field="x_product" data-value-separator="<?php echo $buyer_product_ref_fp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $buyer_product_ref_fp->product->editAttributes() ?>>
		<?php echo $buyer_product_ref_fp->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $buyer_product_ref_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $buyer_product_ref_fp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_buyer_product_ref_fp_rid" for="x_rid" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->rid->caption() ?><?php echo ($buyer_product_ref_fp->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->rid->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_rid">
<?php $buyer_product_ref_fp->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer_product_ref_fp->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_fp" data-field="x_rid" data-value-separator="<?php echo $buyer_product_ref_fp->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $buyer_product_ref_fp->rid->editAttributes() ?>>
		<?php echo $buyer_product_ref_fp->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $buyer_product_ref_fp->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $buyer_product_ref_fp->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->gcode->Visible) { // gcode ?>
	<div id="r_gcode" class="form-group row">
		<label id="elh_buyer_product_ref_fp_gcode" for="x_gcode" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->gcode->caption() ?><?php echo ($buyer_product_ref_fp->gcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->gcode->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_gcode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_fp" data-field="x_gcode" data-value-separator="<?php echo $buyer_product_ref_fp->gcode->displayValueSeparatorAttribute() ?>" id="x_gcode" name="x_gcode"<?php echo $buyer_product_ref_fp->gcode->editAttributes() ?>>
		<?php echo $buyer_product_ref_fp->gcode->selectOptionListHtml("x_gcode") ?>
	</select>
</div>
<?php echo $buyer_product_ref_fp->gcode->Lookup->getParamTag("p_x_gcode") ?>
</span>
<?php echo $buyer_product_ref_fp->gcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_buyer_product_ref_fp_batch_no" for="x_batch_no" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->batch_no->caption() ?><?php echo ($buyer_product_ref_fp->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->batch_no->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_batch_no">
<input type="text" data-table="buyer_product_ref_fp" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->batch_no->EditValue ?>"<?php echo $buyer_product_ref_fp->batch_no->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_buyer_product_ref_fp_price" for="x_price" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->price->caption() ?><?php echo ($buyer_product_ref_fp->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->price->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_price">
<input type="text" data-table="buyer_product_ref_fp" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->price->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->price->EditValue ?>"<?php echo $buyer_product_ref_fp->price->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_buyer_product_ref_fp_status" for="x_status" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->status->caption() ?><?php echo ($buyer_product_ref_fp->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->status->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_fp" data-field="x_status" data-value-separator="<?php echo $buyer_product_ref_fp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $buyer_product_ref_fp->status->editAttributes() ?>>
		<?php echo $buyer_product_ref_fp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $buyer_product_ref_fp->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label id="elh_buyer_product_ref_fp_w_cm" for="x_w_cm" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->w_cm->caption() ?><?php echo ($buyer_product_ref_fp->w_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->w_cm->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_w_cm">
<input type="text" data-table="buyer_product_ref_fp" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->w_cm->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->w_cm->EditValue ?>"<?php echo $buyer_product_ref_fp->w_cm->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->w_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label id="elh_buyer_product_ref_fp_l_cm" for="x_l_cm" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->l_cm->caption() ?><?php echo ($buyer_product_ref_fp->l_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->l_cm->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_l_cm">
<input type="text" data-table="buyer_product_ref_fp" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->l_cm->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->l_cm->EditValue ?>"<?php echo $buyer_product_ref_fp->l_cm->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->l_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_buyer_product_ref_fp_shape" for="x_shape" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->shape->caption() ?><?php echo ($buyer_product_ref_fp->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->shape->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_shape">
<input type="text" data-table="buyer_product_ref_fp" data-field="x_shape" name="x_shape" id="x_shape" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->shape->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->shape->EditValue ?>"<?php echo $buyer_product_ref_fp->shape->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_fp->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_buyer_product_ref_fp_currency" for="x_currency" class="<?php echo $buyer_product_ref_fp_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_fp->currency->caption() ?><?php echo ($buyer_product_ref_fp->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_fp_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_fp->currency->cellAttributes() ?>>
<span id="el_buyer_product_ref_fp_currency">
<input type="text" data-table="buyer_product_ref_fp" data-field="x_currency" name="x_currency" id="x_currency" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_fp->currency->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_fp->currency->EditValue ?>"<?php echo $buyer_product_ref_fp->currency->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_fp->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$buyer_product_ref_fp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $buyer_product_ref_fp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $buyer_product_ref_fp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$buyer_product_ref_fp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$buyer_product_ref_fp_add->terminate();
?>