<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_product_ref_fp_list = new buyer_product_ref_fp_list();

// Run the page
$buyer_product_ref_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_product_ref_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$buyer_product_ref_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbuyer_product_ref_fplist = currentForm = new ew.Form("fbuyer_product_ref_fplist", "list");
fbuyer_product_ref_fplist.formKeyCountName = '<?php echo $buyer_product_ref_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbuyer_product_ref_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyer_product_ref_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyer_product_ref_fplist.lists["x_partner"] = <?php echo $buyer_product_ref_fp_list->partner->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_partner"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->partner->lookupOptions()) ?>;
fbuyer_product_ref_fplist.lists["x_grp"] = <?php echo $buyer_product_ref_fp_list->grp->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_grp"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->grp->options(FALSE, TRUE)) ?>;
fbuyer_product_ref_fplist.lists["x_s_grp"] = <?php echo $buyer_product_ref_fp_list->s_grp->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_s_grp"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->s_grp->lookupOptions()) ?>;
fbuyer_product_ref_fplist.lists["x_product"] = <?php echo $buyer_product_ref_fp_list->product->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_product"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->product->lookupOptions()) ?>;
fbuyer_product_ref_fplist.lists["x_rid"] = <?php echo $buyer_product_ref_fp_list->rid->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_rid"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->rid->lookupOptions()) ?>;
fbuyer_product_ref_fplist.lists["x_gcode"] = <?php echo $buyer_product_ref_fp_list->gcode->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_gcode"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->gcode->lookupOptions()) ?>;
fbuyer_product_ref_fplist.lists["x_status"] = <?php echo $buyer_product_ref_fp_list->status->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_status"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->status->options(FALSE, TRUE)) ?>;
fbuyer_product_ref_fplist.lists["x_operator"] = <?php echo $buyer_product_ref_fp_list->operator->Lookup->toClientList() ?>;
fbuyer_product_ref_fplist.lists["x_operator"].options = <?php echo JsonEncode($buyer_product_ref_fp_list->operator->lookupOptions()) ?>;

// Form object for search
var fbuyer_product_ref_fplistsrch = currentSearchForm = new ew.Form("fbuyer_product_ref_fplistsrch");

// Filters
fbuyer_product_ref_fplistsrch.filterList = <?php echo $buyer_product_ref_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fbuyer_product_ref_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$buyer_product_ref_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($buyer_product_ref_fp_list->TotalRecs > 0 && $buyer_product_ref_fp_list->ExportOptions->visible()) { ?>
<?php $buyer_product_ref_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_product_ref_fp_list->ImportOptions->visible()) { ?>
<?php $buyer_product_ref_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_product_ref_fp_list->SearchOptions->visible()) { ?>
<?php $buyer_product_ref_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_product_ref_fp_list->FilterOptions->visible()) { ?>
<?php $buyer_product_ref_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$buyer_product_ref_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$buyer_product_ref_fp->isExport() && !$buyer_product_ref_fp->CurrentAction) { ?>
<form name="fbuyer_product_ref_fplistsrch" id="fbuyer_product_ref_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($buyer_product_ref_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbuyer_product_ref_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="buyer_product_ref_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($buyer_product_ref_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($buyer_product_ref_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $buyer_product_ref_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($buyer_product_ref_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($buyer_product_ref_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($buyer_product_ref_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($buyer_product_ref_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $buyer_product_ref_fp_list->showPageHeader(); ?>
<?php
$buyer_product_ref_fp_list->showMessage();
?>
<?php if ($buyer_product_ref_fp_list->TotalRecs > 0 || $buyer_product_ref_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($buyer_product_ref_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> buyer_product_ref_fp">
<?php if (!$buyer_product_ref_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$buyer_product_ref_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_product_ref_fp_list->Pager)) $buyer_product_ref_fp_list->Pager = new PrevNextPager($buyer_product_ref_fp_list->StartRec, $buyer_product_ref_fp_list->DisplayRecs, $buyer_product_ref_fp_list->TotalRecs, $buyer_product_ref_fp_list->AutoHidePager) ?>
<?php if ($buyer_product_ref_fp_list->Pager->RecordCount > 0 && $buyer_product_ref_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_product_ref_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_product_ref_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_product_ref_fp_list->TotalRecs > 0 && (!$buyer_product_ref_fp_list->AutoHidePageSizeSelector || $buyer_product_ref_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_product_ref_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_product_ref_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_product_ref_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbuyer_product_ref_fplist" id="fbuyer_product_ref_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_product_ref_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_product_ref_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer_product_ref_fp">
<div id="gmp_buyer_product_ref_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($buyer_product_ref_fp_list->TotalRecs > 0 || $buyer_product_ref_fp->isGridEdit()) { ?>
<table id="tbl_buyer_product_ref_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$buyer_product_ref_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$buyer_product_ref_fp_list->renderListOptions();

// Render list options (header, left)
$buyer_product_ref_fp_list->ListOptions->render("header", "left");
?>
<?php if ($buyer_product_ref_fp->id->Visible) { // id ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $buyer_product_ref_fp->id->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_id" class="buyer_product_ref_fp_id"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $buyer_product_ref_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->id) ?>',2);"><div id="elh_buyer_product_ref_fp_id" class="buyer_product_ref_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->partner->Visible) { // partner ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->partner) == "") { ?>
		<th data-name="partner" class="<?php echo $buyer_product_ref_fp->partner->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_partner" class="buyer_product_ref_fp_partner"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->partner->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner" class="<?php echo $buyer_product_ref_fp->partner->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->partner) ?>',2);"><div id="elh_buyer_product_ref_fp_partner" class="buyer_product_ref_fp_partner">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->partner->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->partner->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->partner->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->partner_ref->Visible) { // partner_ref ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->partner_ref) == "") { ?>
		<th data-name="partner_ref" class="<?php echo $buyer_product_ref_fp->partner_ref->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_partner_ref" class="buyer_product_ref_fp_partner_ref"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->partner_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_ref" class="<?php echo $buyer_product_ref_fp->partner_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->partner_ref) ?>',2);"><div id="elh_buyer_product_ref_fp_partner_ref" class="buyer_product_ref_fp_partner_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->partner_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->partner_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->partner_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->_barcode->Visible) { // barcode ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $buyer_product_ref_fp->_barcode->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp__barcode" class="buyer_product_ref_fp__barcode"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $buyer_product_ref_fp->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->_barcode) ?>',2);"><div id="elh_buyer_product_ref_fp__barcode" class="buyer_product_ref_fp__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->grp->Visible) { // grp ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $buyer_product_ref_fp->grp->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_grp" class="buyer_product_ref_fp_grp"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $buyer_product_ref_fp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->grp) ?>',2);"><div id="elh_buyer_product_ref_fp_grp" class="buyer_product_ref_fp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->s_grp->Visible) { // s_grp ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $buyer_product_ref_fp->s_grp->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_s_grp" class="buyer_product_ref_fp_s_grp"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $buyer_product_ref_fp->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->s_grp) ?>',2);"><div id="elh_buyer_product_ref_fp_s_grp" class="buyer_product_ref_fp_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->product->Visible) { // product ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $buyer_product_ref_fp->product->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_product" class="buyer_product_ref_fp_product"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $buyer_product_ref_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->product) ?>',2);"><div id="elh_buyer_product_ref_fp_product" class="buyer_product_ref_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->rid->Visible) { // rid ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $buyer_product_ref_fp->rid->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_rid" class="buyer_product_ref_fp_rid"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $buyer_product_ref_fp->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->rid) ?>',2);"><div id="elh_buyer_product_ref_fp_rid" class="buyer_product_ref_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->gcode->Visible) { // gcode ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->gcode) == "") { ?>
		<th data-name="gcode" class="<?php echo $buyer_product_ref_fp->gcode->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_gcode" class="buyer_product_ref_fp_gcode"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->gcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gcode" class="<?php echo $buyer_product_ref_fp->gcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->gcode) ?>',2);"><div id="elh_buyer_product_ref_fp_gcode" class="buyer_product_ref_fp_gcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->gcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->gcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->gcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->batch_no->Visible) { // batch_no ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $buyer_product_ref_fp->batch_no->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_batch_no" class="buyer_product_ref_fp_batch_no"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $buyer_product_ref_fp->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->batch_no) ?>',2);"><div id="elh_buyer_product_ref_fp_batch_no" class="buyer_product_ref_fp_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->price->Visible) { // price ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->price) == "") { ?>
		<th data-name="price" class="<?php echo $buyer_product_ref_fp->price->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_price" class="buyer_product_ref_fp_price"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $buyer_product_ref_fp->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->price) ?>',2);"><div id="elh_buyer_product_ref_fp_price" class="buyer_product_ref_fp_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->status->Visible) { // status ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->status) == "") { ?>
		<th data-name="status" class="<?php echo $buyer_product_ref_fp->status->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_status" class="buyer_product_ref_fp_status"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $buyer_product_ref_fp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->status) ?>',2);"><div id="elh_buyer_product_ref_fp_status" class="buyer_product_ref_fp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->operator->Visible) { // operator ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $buyer_product_ref_fp->operator->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_operator" class="buyer_product_ref_fp_operator"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $buyer_product_ref_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->operator) ?>',2);"><div id="elh_buyer_product_ref_fp_operator" class="buyer_product_ref_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->datetime->Visible) { // datetime ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $buyer_product_ref_fp->datetime->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_datetime" class="buyer_product_ref_fp_datetime"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $buyer_product_ref_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->datetime) ?>',2);"><div id="elh_buyer_product_ref_fp_datetime" class="buyer_product_ref_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->w_cm->Visible) { // w_cm ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->w_cm) == "") { ?>
		<th data-name="w_cm" class="<?php echo $buyer_product_ref_fp->w_cm->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_w_cm" class="buyer_product_ref_fp_w_cm"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->w_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w_cm" class="<?php echo $buyer_product_ref_fp->w_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->w_cm) ?>',2);"><div id="elh_buyer_product_ref_fp_w_cm" class="buyer_product_ref_fp_w_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->w_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->w_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->w_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->l_cm->Visible) { // l_cm ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->l_cm) == "") { ?>
		<th data-name="l_cm" class="<?php echo $buyer_product_ref_fp->l_cm->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_l_cm" class="buyer_product_ref_fp_l_cm"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->l_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l_cm" class="<?php echo $buyer_product_ref_fp->l_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->l_cm) ?>',2);"><div id="elh_buyer_product_ref_fp_l_cm" class="buyer_product_ref_fp_l_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->l_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->l_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->l_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->shape->Visible) { // shape ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $buyer_product_ref_fp->shape->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_shape" class="buyer_product_ref_fp_shape"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $buyer_product_ref_fp->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->shape) ?>',2);"><div id="elh_buyer_product_ref_fp_shape" class="buyer_product_ref_fp_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->shape->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_fp->currency->Visible) { // currency ?>
	<?php if ($buyer_product_ref_fp->sortUrl($buyer_product_ref_fp->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $buyer_product_ref_fp->currency->headerCellClass() ?>"><div id="elh_buyer_product_ref_fp_currency" class="buyer_product_ref_fp_currency"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $buyer_product_ref_fp->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_fp->SortUrl($buyer_product_ref_fp->currency) ?>',2);"><div id="elh_buyer_product_ref_fp_currency" class="buyer_product_ref_fp_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_fp->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_fp->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_fp->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$buyer_product_ref_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($buyer_product_ref_fp->ExportAll && $buyer_product_ref_fp->isExport()) {
	$buyer_product_ref_fp_list->StopRec = $buyer_product_ref_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($buyer_product_ref_fp_list->TotalRecs > $buyer_product_ref_fp_list->StartRec + $buyer_product_ref_fp_list->DisplayRecs - 1)
		$buyer_product_ref_fp_list->StopRec = $buyer_product_ref_fp_list->StartRec + $buyer_product_ref_fp_list->DisplayRecs - 1;
	else
		$buyer_product_ref_fp_list->StopRec = $buyer_product_ref_fp_list->TotalRecs;
}
$buyer_product_ref_fp_list->RecCnt = $buyer_product_ref_fp_list->StartRec - 1;
if ($buyer_product_ref_fp_list->Recordset && !$buyer_product_ref_fp_list->Recordset->EOF) {
	$buyer_product_ref_fp_list->Recordset->moveFirst();
	$selectLimit = $buyer_product_ref_fp_list->UseSelectLimit;
	if (!$selectLimit && $buyer_product_ref_fp_list->StartRec > 1)
		$buyer_product_ref_fp_list->Recordset->move($buyer_product_ref_fp_list->StartRec - 1);
} elseif (!$buyer_product_ref_fp->AllowAddDeleteRow && $buyer_product_ref_fp_list->StopRec == 0) {
	$buyer_product_ref_fp_list->StopRec = $buyer_product_ref_fp->GridAddRowCount;
}

// Initialize aggregate
$buyer_product_ref_fp->RowType = ROWTYPE_AGGREGATEINIT;
$buyer_product_ref_fp->resetAttributes();
$buyer_product_ref_fp_list->renderRow();
while ($buyer_product_ref_fp_list->RecCnt < $buyer_product_ref_fp_list->StopRec) {
	$buyer_product_ref_fp_list->RecCnt++;
	if ($buyer_product_ref_fp_list->RecCnt >= $buyer_product_ref_fp_list->StartRec) {
		$buyer_product_ref_fp_list->RowCnt++;

		// Set up key count
		$buyer_product_ref_fp_list->KeyCount = $buyer_product_ref_fp_list->RowIndex;

		// Init row class and style
		$buyer_product_ref_fp->resetAttributes();
		$buyer_product_ref_fp->CssClass = "";
		if ($buyer_product_ref_fp->isGridAdd()) {
		} else {
			$buyer_product_ref_fp_list->loadRowValues($buyer_product_ref_fp_list->Recordset); // Load row values
		}
		$buyer_product_ref_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$buyer_product_ref_fp->RowAttrs = array_merge($buyer_product_ref_fp->RowAttrs, array('data-rowindex'=>$buyer_product_ref_fp_list->RowCnt, 'id'=>'r' . $buyer_product_ref_fp_list->RowCnt . '_buyer_product_ref_fp', 'data-rowtype'=>$buyer_product_ref_fp->RowType));

		// Render row
		$buyer_product_ref_fp_list->renderRow();

		// Render list options
		$buyer_product_ref_fp_list->renderListOptions();
?>
	<tr<?php echo $buyer_product_ref_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$buyer_product_ref_fp_list->ListOptions->render("body", "left", $buyer_product_ref_fp_list->RowCnt);
?>
	<?php if ($buyer_product_ref_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $buyer_product_ref_fp->id->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_id" class="buyer_product_ref_fp_id">
<span<?php echo $buyer_product_ref_fp->id->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->partner->Visible) { // partner ?>
		<td data-name="partner"<?php echo $buyer_product_ref_fp->partner->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_partner" class="buyer_product_ref_fp_partner">
<span<?php echo $buyer_product_ref_fp->partner->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->partner->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->partner_ref->Visible) { // partner_ref ?>
		<td data-name="partner_ref"<?php echo $buyer_product_ref_fp->partner_ref->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_partner_ref" class="buyer_product_ref_fp_partner_ref">
<span<?php echo $buyer_product_ref_fp->partner_ref->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->partner_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $buyer_product_ref_fp->_barcode->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp__barcode" class="buyer_product_ref_fp__barcode">
<span<?php echo $buyer_product_ref_fp->_barcode->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $buyer_product_ref_fp->grp->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_grp" class="buyer_product_ref_fp_grp">
<span<?php echo $buyer_product_ref_fp->grp->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $buyer_product_ref_fp->s_grp->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_s_grp" class="buyer_product_ref_fp_s_grp">
<span<?php echo $buyer_product_ref_fp->s_grp->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $buyer_product_ref_fp->product->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_product" class="buyer_product_ref_fp_product">
<span<?php echo $buyer_product_ref_fp->product->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $buyer_product_ref_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_rid" class="buyer_product_ref_fp_rid">
<span<?php echo $buyer_product_ref_fp->rid->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->gcode->Visible) { // gcode ?>
		<td data-name="gcode"<?php echo $buyer_product_ref_fp->gcode->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_gcode" class="buyer_product_ref_fp_gcode">
<span<?php echo $buyer_product_ref_fp->gcode->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->gcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $buyer_product_ref_fp->batch_no->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_batch_no" class="buyer_product_ref_fp_batch_no">
<span<?php echo $buyer_product_ref_fp->batch_no->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->price->Visible) { // price ?>
		<td data-name="price"<?php echo $buyer_product_ref_fp->price->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_price" class="buyer_product_ref_fp_price">
<span<?php echo $buyer_product_ref_fp->price->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $buyer_product_ref_fp->status->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_status" class="buyer_product_ref_fp_status">
<span<?php echo $buyer_product_ref_fp->status->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $buyer_product_ref_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_operator" class="buyer_product_ref_fp_operator">
<span<?php echo $buyer_product_ref_fp->operator->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $buyer_product_ref_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_datetime" class="buyer_product_ref_fp_datetime">
<span<?php echo $buyer_product_ref_fp->datetime->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->w_cm->Visible) { // w_cm ?>
		<td data-name="w_cm"<?php echo $buyer_product_ref_fp->w_cm->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_w_cm" class="buyer_product_ref_fp_w_cm">
<span<?php echo $buyer_product_ref_fp->w_cm->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->w_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->l_cm->Visible) { // l_cm ?>
		<td data-name="l_cm"<?php echo $buyer_product_ref_fp->l_cm->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_l_cm" class="buyer_product_ref_fp_l_cm">
<span<?php echo $buyer_product_ref_fp->l_cm->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->l_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $buyer_product_ref_fp->shape->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_shape" class="buyer_product_ref_fp_shape">
<span<?php echo $buyer_product_ref_fp->shape->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_fp->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $buyer_product_ref_fp->currency->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_fp_list->RowCnt ?>_buyer_product_ref_fp_currency" class="buyer_product_ref_fp_currency">
<span<?php echo $buyer_product_ref_fp->currency->viewAttributes() ?>>
<?php echo $buyer_product_ref_fp->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$buyer_product_ref_fp_list->ListOptions->render("body", "right", $buyer_product_ref_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$buyer_product_ref_fp->isGridAdd())
		$buyer_product_ref_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$buyer_product_ref_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($buyer_product_ref_fp_list->Recordset)
	$buyer_product_ref_fp_list->Recordset->Close();
?>
<?php if (!$buyer_product_ref_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$buyer_product_ref_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_product_ref_fp_list->Pager)) $buyer_product_ref_fp_list->Pager = new PrevNextPager($buyer_product_ref_fp_list->StartRec, $buyer_product_ref_fp_list->DisplayRecs, $buyer_product_ref_fp_list->TotalRecs, $buyer_product_ref_fp_list->AutoHidePager) ?>
<?php if ($buyer_product_ref_fp_list->Pager->RecordCount > 0 && $buyer_product_ref_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_product_ref_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_product_ref_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_product_ref_fp_list->pageUrl() ?>start=<?php echo $buyer_product_ref_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_product_ref_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_product_ref_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_product_ref_fp_list->TotalRecs > 0 && (!$buyer_product_ref_fp_list->AutoHidePageSizeSelector || $buyer_product_ref_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_product_ref_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_product_ref_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_product_ref_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_product_ref_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($buyer_product_ref_fp_list->TotalRecs == 0 && !$buyer_product_ref_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $buyer_product_ref_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$buyer_product_ref_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$buyer_product_ref_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$buyer_product_ref_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_buyer_product_ref_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$buyer_product_ref_fp_list->terminate();
?>