<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_product_ref_g_add = new buyer_product_ref_g_add();

// Run the page
$buyer_product_ref_g_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_product_ref_g_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fbuyer_product_ref_gadd = currentForm = new ew.Form("fbuyer_product_ref_gadd", "add");

// Validate form
fbuyer_product_ref_gadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($buyer_product_ref_g_add->partner->Required) { ?>
			elm = this.getElements("x" + infix + "_partner");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->partner->caption(), $buyer_product_ref_g->partner->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->partner_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->partner_ref->caption(), $buyer_product_ref_g->partner_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->_barcode->caption(), $buyer_product_ref_g->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->grp->caption(), $buyer_product_ref_g->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->s_grp->caption(), $buyer_product_ref_g->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->product->caption(), $buyer_product_ref_g->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->rid->caption(), $buyer_product_ref_g->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_g->rid->errorMessage()) ?>");
		<?php if ($buyer_product_ref_g_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->price->caption(), $buyer_product_ref_g->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_g->price->errorMessage()) ?>");
		<?php if ($buyer_product_ref_g_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->status->caption(), $buyer_product_ref_g->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->operator->caption(), $buyer_product_ref_g->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->datetime->caption(), $buyer_product_ref_g->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_product_ref_g_add->w_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->w_cm->caption(), $buyer_product_ref_g->w_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_g->w_cm->errorMessage()) ?>");
		<?php if ($buyer_product_ref_g_add->l_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->l_cm->caption(), $buyer_product_ref_g->l_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_g->l_cm->errorMessage()) ?>");
		<?php if ($buyer_product_ref_g_add->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->shape->caption(), $buyer_product_ref_g->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_g->shape->errorMessage()) ?>");
		<?php if ($buyer_product_ref_g_add->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer_product_ref_g->currency->caption(), $buyer_product_ref_g->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer_product_ref_g->currency->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbuyer_product_ref_gadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyer_product_ref_gadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyer_product_ref_gadd.lists["x_partner"] = <?php echo $buyer_product_ref_g_add->partner->Lookup->toClientList() ?>;
fbuyer_product_ref_gadd.lists["x_partner"].options = <?php echo JsonEncode($buyer_product_ref_g_add->partner->lookupOptions()) ?>;
fbuyer_product_ref_gadd.lists["x_grp"] = <?php echo $buyer_product_ref_g_add->grp->Lookup->toClientList() ?>;
fbuyer_product_ref_gadd.lists["x_grp"].options = <?php echo JsonEncode($buyer_product_ref_g_add->grp->lookupOptions()) ?>;
fbuyer_product_ref_gadd.lists["x_s_grp"] = <?php echo $buyer_product_ref_g_add->s_grp->Lookup->toClientList() ?>;
fbuyer_product_ref_gadd.lists["x_s_grp"].options = <?php echo JsonEncode($buyer_product_ref_g_add->s_grp->lookupOptions()) ?>;
fbuyer_product_ref_gadd.lists["x_product"] = <?php echo $buyer_product_ref_g_add->product->Lookup->toClientList() ?>;
fbuyer_product_ref_gadd.lists["x_product"].options = <?php echo JsonEncode($buyer_product_ref_g_add->product->lookupOptions()) ?>;
fbuyer_product_ref_gadd.lists["x_status"] = <?php echo $buyer_product_ref_g_add->status->Lookup->toClientList() ?>;
fbuyer_product_ref_gadd.lists["x_status"].options = <?php echo JsonEncode($buyer_product_ref_g_add->status->options(FALSE, TRUE)) ?>;
fbuyer_product_ref_gadd.lists["x_operator"] = <?php echo $buyer_product_ref_g_add->operator->Lookup->toClientList() ?>;
fbuyer_product_ref_gadd.lists["x_operator"].options = <?php echo JsonEncode($buyer_product_ref_g_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $buyer_product_ref_g_add->showPageHeader(); ?>
<?php
$buyer_product_ref_g_add->showMessage();
?>
<form name="fbuyer_product_ref_gadd" id="fbuyer_product_ref_gadd" class="<?php echo $buyer_product_ref_g_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_product_ref_g_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_product_ref_g_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer_product_ref_g">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$buyer_product_ref_g_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($buyer_product_ref_g->partner->Visible) { // partner ?>
	<div id="r_partner" class="form-group row">
		<label id="elh_buyer_product_ref_g_partner" for="x_partner" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->partner->caption() ?><?php echo ($buyer_product_ref_g->partner->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->partner->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_partner">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_g" data-field="x_partner" data-value-separator="<?php echo $buyer_product_ref_g->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $buyer_product_ref_g->partner->editAttributes() ?>>
		<?php echo $buyer_product_ref_g->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $buyer_product_ref_g->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
<?php echo $buyer_product_ref_g->partner->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->partner_ref->Visible) { // partner_ref ?>
	<div id="r_partner_ref" class="form-group row">
		<label id="elh_buyer_product_ref_g_partner_ref" for="x_partner_ref" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->partner_ref->caption() ?><?php echo ($buyer_product_ref_g->partner_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->partner_ref->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_partner_ref">
<input type="text" data-table="buyer_product_ref_g" data-field="x_partner_ref" name="x_partner_ref" id="x_partner_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->partner_ref->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->partner_ref->EditValue ?>"<?php echo $buyer_product_ref_g->partner_ref->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->partner_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_buyer_product_ref_g__barcode" for="x__barcode" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->_barcode->caption() ?><?php echo ($buyer_product_ref_g->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->_barcode->cellAttributes() ?>>
<span id="el_buyer_product_ref_g__barcode">
<input type="text" data-table="buyer_product_ref_g" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->_barcode->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->_barcode->EditValue ?>"<?php echo $buyer_product_ref_g->_barcode->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_buyer_product_ref_g_grp" for="x_grp" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->grp->caption() ?><?php echo ($buyer_product_ref_g->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->grp->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_grp">
<?php $buyer_product_ref_g->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer_product_ref_g->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_g" data-field="x_grp" data-value-separator="<?php echo $buyer_product_ref_g->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $buyer_product_ref_g->grp->editAttributes() ?>>
		<?php echo $buyer_product_ref_g->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $buyer_product_ref_g->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $buyer_product_ref_g->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_buyer_product_ref_g_s_grp" for="x_s_grp" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->s_grp->caption() ?><?php echo ($buyer_product_ref_g->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->s_grp->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_s_grp">
<?php $buyer_product_ref_g->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer_product_ref_g->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_g" data-field="x_s_grp" data-value-separator="<?php echo $buyer_product_ref_g->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $buyer_product_ref_g->s_grp->editAttributes() ?>>
		<?php echo $buyer_product_ref_g->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $buyer_product_ref_g->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $buyer_product_ref_g->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_buyer_product_ref_g_product" for="x_product" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->product->caption() ?><?php echo ($buyer_product_ref_g->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->product->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_g" data-field="x_product" data-value-separator="<?php echo $buyer_product_ref_g->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $buyer_product_ref_g->product->editAttributes() ?>>
		<?php echo $buyer_product_ref_g->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $buyer_product_ref_g->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $buyer_product_ref_g->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_buyer_product_ref_g_rid" for="x_rid" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->rid->caption() ?><?php echo ($buyer_product_ref_g->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->rid->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_rid">
<input type="text" data-table="buyer_product_ref_g" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->rid->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->rid->EditValue ?>"<?php echo $buyer_product_ref_g->rid->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_buyer_product_ref_g_price" for="x_price" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->price->caption() ?><?php echo ($buyer_product_ref_g->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->price->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_price">
<input type="text" data-table="buyer_product_ref_g" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->price->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->price->EditValue ?>"<?php echo $buyer_product_ref_g->price->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_buyer_product_ref_g_status" for="x_status" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->status->caption() ?><?php echo ($buyer_product_ref_g->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->status->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_product_ref_g" data-field="x_status" data-value-separator="<?php echo $buyer_product_ref_g->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $buyer_product_ref_g->status->editAttributes() ?>>
		<?php echo $buyer_product_ref_g->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $buyer_product_ref_g->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label id="elh_buyer_product_ref_g_w_cm" for="x_w_cm" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->w_cm->caption() ?><?php echo ($buyer_product_ref_g->w_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->w_cm->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_w_cm">
<input type="text" data-table="buyer_product_ref_g" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->w_cm->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->w_cm->EditValue ?>"<?php echo $buyer_product_ref_g->w_cm->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->w_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label id="elh_buyer_product_ref_g_l_cm" for="x_l_cm" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->l_cm->caption() ?><?php echo ($buyer_product_ref_g->l_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->l_cm->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_l_cm">
<input type="text" data-table="buyer_product_ref_g" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->l_cm->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->l_cm->EditValue ?>"<?php echo $buyer_product_ref_g->l_cm->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->l_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_buyer_product_ref_g_shape" for="x_shape" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->shape->caption() ?><?php echo ($buyer_product_ref_g->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->shape->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_shape">
<input type="text" data-table="buyer_product_ref_g" data-field="x_shape" name="x_shape" id="x_shape" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->shape->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->shape->EditValue ?>"<?php echo $buyer_product_ref_g->shape->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer_product_ref_g->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_buyer_product_ref_g_currency" for="x_currency" class="<?php echo $buyer_product_ref_g_add->LeftColumnClass ?>"><?php echo $buyer_product_ref_g->currency->caption() ?><?php echo ($buyer_product_ref_g->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_product_ref_g_add->RightColumnClass ?>"><div<?php echo $buyer_product_ref_g->currency->cellAttributes() ?>>
<span id="el_buyer_product_ref_g_currency">
<input type="text" data-table="buyer_product_ref_g" data-field="x_currency" name="x_currency" id="x_currency" size="30" placeholder="<?php echo HtmlEncode($buyer_product_ref_g->currency->getPlaceHolder()) ?>" value="<?php echo $buyer_product_ref_g->currency->EditValue ?>"<?php echo $buyer_product_ref_g->currency->editAttributes() ?>>
</span>
<?php echo $buyer_product_ref_g->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$buyer_product_ref_g_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $buyer_product_ref_g_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $buyer_product_ref_g_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$buyer_product_ref_g_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$buyer_product_ref_g_add->terminate();
?>