<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_product_ref_g_list = new buyer_product_ref_g_list();

// Run the page
$buyer_product_ref_g_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_product_ref_g_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$buyer_product_ref_g->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbuyer_product_ref_glist = currentForm = new ew.Form("fbuyer_product_ref_glist", "list");
fbuyer_product_ref_glist.formKeyCountName = '<?php echo $buyer_product_ref_g_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbuyer_product_ref_glist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyer_product_ref_glist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyer_product_ref_glist.lists["x_partner"] = <?php echo $buyer_product_ref_g_list->partner->Lookup->toClientList() ?>;
fbuyer_product_ref_glist.lists["x_partner"].options = <?php echo JsonEncode($buyer_product_ref_g_list->partner->lookupOptions()) ?>;
fbuyer_product_ref_glist.lists["x_grp"] = <?php echo $buyer_product_ref_g_list->grp->Lookup->toClientList() ?>;
fbuyer_product_ref_glist.lists["x_grp"].options = <?php echo JsonEncode($buyer_product_ref_g_list->grp->lookupOptions()) ?>;
fbuyer_product_ref_glist.lists["x_s_grp"] = <?php echo $buyer_product_ref_g_list->s_grp->Lookup->toClientList() ?>;
fbuyer_product_ref_glist.lists["x_s_grp"].options = <?php echo JsonEncode($buyer_product_ref_g_list->s_grp->lookupOptions()) ?>;
fbuyer_product_ref_glist.lists["x_product"] = <?php echo $buyer_product_ref_g_list->product->Lookup->toClientList() ?>;
fbuyer_product_ref_glist.lists["x_product"].options = <?php echo JsonEncode($buyer_product_ref_g_list->product->lookupOptions()) ?>;
fbuyer_product_ref_glist.lists["x_status"] = <?php echo $buyer_product_ref_g_list->status->Lookup->toClientList() ?>;
fbuyer_product_ref_glist.lists["x_status"].options = <?php echo JsonEncode($buyer_product_ref_g_list->status->options(FALSE, TRUE)) ?>;
fbuyer_product_ref_glist.lists["x_operator"] = <?php echo $buyer_product_ref_g_list->operator->Lookup->toClientList() ?>;
fbuyer_product_ref_glist.lists["x_operator"].options = <?php echo JsonEncode($buyer_product_ref_g_list->operator->lookupOptions()) ?>;

// Form object for search
var fbuyer_product_ref_glistsrch = currentSearchForm = new ew.Form("fbuyer_product_ref_glistsrch");

// Filters
fbuyer_product_ref_glistsrch.filterList = <?php echo $buyer_product_ref_g_list->getFilterList() ?>;

// Init search panel as collapsed
fbuyer_product_ref_glistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$buyer_product_ref_g->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($buyer_product_ref_g_list->TotalRecs > 0 && $buyer_product_ref_g_list->ExportOptions->visible()) { ?>
<?php $buyer_product_ref_g_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_product_ref_g_list->ImportOptions->visible()) { ?>
<?php $buyer_product_ref_g_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_product_ref_g_list->SearchOptions->visible()) { ?>
<?php $buyer_product_ref_g_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_product_ref_g_list->FilterOptions->visible()) { ?>
<?php $buyer_product_ref_g_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$buyer_product_ref_g_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$buyer_product_ref_g->isExport() && !$buyer_product_ref_g->CurrentAction) { ?>
<form name="fbuyer_product_ref_glistsrch" id="fbuyer_product_ref_glistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($buyer_product_ref_g_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbuyer_product_ref_glistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="buyer_product_ref_g">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($buyer_product_ref_g_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($buyer_product_ref_g_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $buyer_product_ref_g_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($buyer_product_ref_g_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($buyer_product_ref_g_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($buyer_product_ref_g_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($buyer_product_ref_g_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $buyer_product_ref_g_list->showPageHeader(); ?>
<?php
$buyer_product_ref_g_list->showMessage();
?>
<?php if ($buyer_product_ref_g_list->TotalRecs > 0 || $buyer_product_ref_g->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($buyer_product_ref_g_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> buyer_product_ref_g">
<?php if (!$buyer_product_ref_g->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$buyer_product_ref_g->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_product_ref_g_list->Pager)) $buyer_product_ref_g_list->Pager = new PrevNextPager($buyer_product_ref_g_list->StartRec, $buyer_product_ref_g_list->DisplayRecs, $buyer_product_ref_g_list->TotalRecs, $buyer_product_ref_g_list->AutoHidePager) ?>
<?php if ($buyer_product_ref_g_list->Pager->RecordCount > 0 && $buyer_product_ref_g_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_product_ref_g_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_product_ref_g_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_product_ref_g_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_product_ref_g_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_product_ref_g_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_product_ref_g_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_product_ref_g_list->TotalRecs > 0 && (!$buyer_product_ref_g_list->AutoHidePageSizeSelector || $buyer_product_ref_g_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_product_ref_g">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_product_ref_g_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_product_ref_g_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_product_ref_g_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_product_ref_g_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_product_ref_g_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_product_ref_g->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_product_ref_g_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbuyer_product_ref_glist" id="fbuyer_product_ref_glist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_product_ref_g_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_product_ref_g_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer_product_ref_g">
<div id="gmp_buyer_product_ref_g" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($buyer_product_ref_g_list->TotalRecs > 0 || $buyer_product_ref_g->isGridEdit()) { ?>
<table id="tbl_buyer_product_ref_glist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$buyer_product_ref_g_list->RowType = ROWTYPE_HEADER;

// Render list options
$buyer_product_ref_g_list->renderListOptions();

// Render list options (header, left)
$buyer_product_ref_g_list->ListOptions->render("header", "left");
?>
<?php if ($buyer_product_ref_g->id->Visible) { // id ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->id) == "") { ?>
		<th data-name="id" class="<?php echo $buyer_product_ref_g->id->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_id" class="buyer_product_ref_g_id"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $buyer_product_ref_g->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->id) ?>',2);"><div id="elh_buyer_product_ref_g_id" class="buyer_product_ref_g_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->partner->Visible) { // partner ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->partner) == "") { ?>
		<th data-name="partner" class="<?php echo $buyer_product_ref_g->partner->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_partner" class="buyer_product_ref_g_partner"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->partner->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner" class="<?php echo $buyer_product_ref_g->partner->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->partner) ?>',2);"><div id="elh_buyer_product_ref_g_partner" class="buyer_product_ref_g_partner">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->partner->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->partner->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->partner->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->partner_ref->Visible) { // partner_ref ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->partner_ref) == "") { ?>
		<th data-name="partner_ref" class="<?php echo $buyer_product_ref_g->partner_ref->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_partner_ref" class="buyer_product_ref_g_partner_ref"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->partner_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_ref" class="<?php echo $buyer_product_ref_g->partner_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->partner_ref) ?>',2);"><div id="elh_buyer_product_ref_g_partner_ref" class="buyer_product_ref_g_partner_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->partner_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->partner_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->partner_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->_barcode->Visible) { // barcode ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $buyer_product_ref_g->_barcode->headerCellClass() ?>"><div id="elh_buyer_product_ref_g__barcode" class="buyer_product_ref_g__barcode"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $buyer_product_ref_g->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->_barcode) ?>',2);"><div id="elh_buyer_product_ref_g__barcode" class="buyer_product_ref_g__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->grp->Visible) { // grp ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $buyer_product_ref_g->grp->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_grp" class="buyer_product_ref_g_grp"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $buyer_product_ref_g->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->grp) ?>',2);"><div id="elh_buyer_product_ref_g_grp" class="buyer_product_ref_g_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->s_grp->Visible) { // s_grp ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $buyer_product_ref_g->s_grp->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_s_grp" class="buyer_product_ref_g_s_grp"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $buyer_product_ref_g->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->s_grp) ?>',2);"><div id="elh_buyer_product_ref_g_s_grp" class="buyer_product_ref_g_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->product->Visible) { // product ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->product) == "") { ?>
		<th data-name="product" class="<?php echo $buyer_product_ref_g->product->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_product" class="buyer_product_ref_g_product"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $buyer_product_ref_g->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->product) ?>',2);"><div id="elh_buyer_product_ref_g_product" class="buyer_product_ref_g_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->rid->Visible) { // rid ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $buyer_product_ref_g->rid->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_rid" class="buyer_product_ref_g_rid"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $buyer_product_ref_g->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->rid) ?>',2);"><div id="elh_buyer_product_ref_g_rid" class="buyer_product_ref_g_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->price->Visible) { // price ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->price) == "") { ?>
		<th data-name="price" class="<?php echo $buyer_product_ref_g->price->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_price" class="buyer_product_ref_g_price"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $buyer_product_ref_g->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->price) ?>',2);"><div id="elh_buyer_product_ref_g_price" class="buyer_product_ref_g_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->status->Visible) { // status ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->status) == "") { ?>
		<th data-name="status" class="<?php echo $buyer_product_ref_g->status->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_status" class="buyer_product_ref_g_status"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $buyer_product_ref_g->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->status) ?>',2);"><div id="elh_buyer_product_ref_g_status" class="buyer_product_ref_g_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->operator->Visible) { // operator ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $buyer_product_ref_g->operator->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_operator" class="buyer_product_ref_g_operator"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $buyer_product_ref_g->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->operator) ?>',2);"><div id="elh_buyer_product_ref_g_operator" class="buyer_product_ref_g_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->datetime->Visible) { // datetime ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $buyer_product_ref_g->datetime->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_datetime" class="buyer_product_ref_g_datetime"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $buyer_product_ref_g->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->datetime) ?>',2);"><div id="elh_buyer_product_ref_g_datetime" class="buyer_product_ref_g_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->w_cm->Visible) { // w_cm ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->w_cm) == "") { ?>
		<th data-name="w_cm" class="<?php echo $buyer_product_ref_g->w_cm->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_w_cm" class="buyer_product_ref_g_w_cm"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->w_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w_cm" class="<?php echo $buyer_product_ref_g->w_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->w_cm) ?>',2);"><div id="elh_buyer_product_ref_g_w_cm" class="buyer_product_ref_g_w_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->w_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->w_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->w_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->l_cm->Visible) { // l_cm ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->l_cm) == "") { ?>
		<th data-name="l_cm" class="<?php echo $buyer_product_ref_g->l_cm->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_l_cm" class="buyer_product_ref_g_l_cm"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->l_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l_cm" class="<?php echo $buyer_product_ref_g->l_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->l_cm) ?>',2);"><div id="elh_buyer_product_ref_g_l_cm" class="buyer_product_ref_g_l_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->l_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->l_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->l_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->shape->Visible) { // shape ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $buyer_product_ref_g->shape->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_shape" class="buyer_product_ref_g_shape"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $buyer_product_ref_g->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->shape) ?>',2);"><div id="elh_buyer_product_ref_g_shape" class="buyer_product_ref_g_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_product_ref_g->currency->Visible) { // currency ?>
	<?php if ($buyer_product_ref_g->sortUrl($buyer_product_ref_g->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $buyer_product_ref_g->currency->headerCellClass() ?>"><div id="elh_buyer_product_ref_g_currency" class="buyer_product_ref_g_currency"><div class="ew-table-header-caption"><?php echo $buyer_product_ref_g->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $buyer_product_ref_g->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_product_ref_g->SortUrl($buyer_product_ref_g->currency) ?>',2);"><div id="elh_buyer_product_ref_g_currency" class="buyer_product_ref_g_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_product_ref_g->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_product_ref_g->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_product_ref_g->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$buyer_product_ref_g_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($buyer_product_ref_g->ExportAll && $buyer_product_ref_g->isExport()) {
	$buyer_product_ref_g_list->StopRec = $buyer_product_ref_g_list->TotalRecs;
} else {

	// Set the last record to display
	if ($buyer_product_ref_g_list->TotalRecs > $buyer_product_ref_g_list->StartRec + $buyer_product_ref_g_list->DisplayRecs - 1)
		$buyer_product_ref_g_list->StopRec = $buyer_product_ref_g_list->StartRec + $buyer_product_ref_g_list->DisplayRecs - 1;
	else
		$buyer_product_ref_g_list->StopRec = $buyer_product_ref_g_list->TotalRecs;
}
$buyer_product_ref_g_list->RecCnt = $buyer_product_ref_g_list->StartRec - 1;
if ($buyer_product_ref_g_list->Recordset && !$buyer_product_ref_g_list->Recordset->EOF) {
	$buyer_product_ref_g_list->Recordset->moveFirst();
	$selectLimit = $buyer_product_ref_g_list->UseSelectLimit;
	if (!$selectLimit && $buyer_product_ref_g_list->StartRec > 1)
		$buyer_product_ref_g_list->Recordset->move($buyer_product_ref_g_list->StartRec - 1);
} elseif (!$buyer_product_ref_g->AllowAddDeleteRow && $buyer_product_ref_g_list->StopRec == 0) {
	$buyer_product_ref_g_list->StopRec = $buyer_product_ref_g->GridAddRowCount;
}

// Initialize aggregate
$buyer_product_ref_g->RowType = ROWTYPE_AGGREGATEINIT;
$buyer_product_ref_g->resetAttributes();
$buyer_product_ref_g_list->renderRow();
while ($buyer_product_ref_g_list->RecCnt < $buyer_product_ref_g_list->StopRec) {
	$buyer_product_ref_g_list->RecCnt++;
	if ($buyer_product_ref_g_list->RecCnt >= $buyer_product_ref_g_list->StartRec) {
		$buyer_product_ref_g_list->RowCnt++;

		// Set up key count
		$buyer_product_ref_g_list->KeyCount = $buyer_product_ref_g_list->RowIndex;

		// Init row class and style
		$buyer_product_ref_g->resetAttributes();
		$buyer_product_ref_g->CssClass = "";
		if ($buyer_product_ref_g->isGridAdd()) {
		} else {
			$buyer_product_ref_g_list->loadRowValues($buyer_product_ref_g_list->Recordset); // Load row values
		}
		$buyer_product_ref_g->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$buyer_product_ref_g->RowAttrs = array_merge($buyer_product_ref_g->RowAttrs, array('data-rowindex'=>$buyer_product_ref_g_list->RowCnt, 'id'=>'r' . $buyer_product_ref_g_list->RowCnt . '_buyer_product_ref_g', 'data-rowtype'=>$buyer_product_ref_g->RowType));

		// Render row
		$buyer_product_ref_g_list->renderRow();

		// Render list options
		$buyer_product_ref_g_list->renderListOptions();
?>
	<tr<?php echo $buyer_product_ref_g->rowAttributes() ?>>
<?php

// Render list options (body, left)
$buyer_product_ref_g_list->ListOptions->render("body", "left", $buyer_product_ref_g_list->RowCnt);
?>
	<?php if ($buyer_product_ref_g->id->Visible) { // id ?>
		<td data-name="id"<?php echo $buyer_product_ref_g->id->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_id" class="buyer_product_ref_g_id">
<span<?php echo $buyer_product_ref_g->id->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->partner->Visible) { // partner ?>
		<td data-name="partner"<?php echo $buyer_product_ref_g->partner->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_partner" class="buyer_product_ref_g_partner">
<span<?php echo $buyer_product_ref_g->partner->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_product_ref_g->partner->getViewValue())) && $buyer_product_ref_g->partner->linkAttributes() <> "") { ?>
<a<?php echo $buyer_product_ref_g->partner->linkAttributes() ?>><?php echo $buyer_product_ref_g->partner->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_product_ref_g->partner->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->partner_ref->Visible) { // partner_ref ?>
		<td data-name="partner_ref"<?php echo $buyer_product_ref_g->partner_ref->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_partner_ref" class="buyer_product_ref_g_partner_ref">
<span<?php echo $buyer_product_ref_g->partner_ref->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_product_ref_g->partner_ref->getViewValue())) && $buyer_product_ref_g->partner_ref->linkAttributes() <> "") { ?>
<a<?php echo $buyer_product_ref_g->partner_ref->linkAttributes() ?>><?php echo $buyer_product_ref_g->partner_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_product_ref_g->partner_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $buyer_product_ref_g->_barcode->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g__barcode" class="buyer_product_ref_g__barcode">
<span<?php echo $buyer_product_ref_g->_barcode->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $buyer_product_ref_g->grp->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_grp" class="buyer_product_ref_g_grp">
<span<?php echo $buyer_product_ref_g->grp->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_product_ref_g->grp->getViewValue())) && $buyer_product_ref_g->grp->linkAttributes() <> "") { ?>
<a<?php echo $buyer_product_ref_g->grp->linkAttributes() ?>><?php echo $buyer_product_ref_g->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_product_ref_g->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $buyer_product_ref_g->s_grp->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_s_grp" class="buyer_product_ref_g_s_grp">
<span<?php echo $buyer_product_ref_g->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_product_ref_g->s_grp->getViewValue())) && $buyer_product_ref_g->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $buyer_product_ref_g->s_grp->linkAttributes() ?>><?php echo $buyer_product_ref_g->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_product_ref_g->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->product->Visible) { // product ?>
		<td data-name="product"<?php echo $buyer_product_ref_g->product->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_product" class="buyer_product_ref_g_product">
<span<?php echo $buyer_product_ref_g->product->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_product_ref_g->product->getViewValue())) && $buyer_product_ref_g->product->linkAttributes() <> "") { ?>
<a<?php echo $buyer_product_ref_g->product->linkAttributes() ?>><?php echo $buyer_product_ref_g->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_product_ref_g->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $buyer_product_ref_g->rid->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_rid" class="buyer_product_ref_g_rid">
<span<?php echo $buyer_product_ref_g->rid->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_product_ref_g->rid->getViewValue())) && $buyer_product_ref_g->rid->linkAttributes() <> "") { ?>
<a<?php echo $buyer_product_ref_g->rid->linkAttributes() ?>><?php echo $buyer_product_ref_g->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_product_ref_g->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->price->Visible) { // price ?>
		<td data-name="price"<?php echo $buyer_product_ref_g->price->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_price" class="buyer_product_ref_g_price">
<span<?php echo $buyer_product_ref_g->price->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->status->Visible) { // status ?>
		<td data-name="status"<?php echo $buyer_product_ref_g->status->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_status" class="buyer_product_ref_g_status">
<span<?php echo $buyer_product_ref_g->status->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $buyer_product_ref_g->operator->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_operator" class="buyer_product_ref_g_operator">
<span<?php echo $buyer_product_ref_g->operator->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $buyer_product_ref_g->datetime->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_datetime" class="buyer_product_ref_g_datetime">
<span<?php echo $buyer_product_ref_g->datetime->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->w_cm->Visible) { // w_cm ?>
		<td data-name="w_cm"<?php echo $buyer_product_ref_g->w_cm->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_w_cm" class="buyer_product_ref_g_w_cm">
<span<?php echo $buyer_product_ref_g->w_cm->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->w_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->l_cm->Visible) { // l_cm ?>
		<td data-name="l_cm"<?php echo $buyer_product_ref_g->l_cm->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_l_cm" class="buyer_product_ref_g_l_cm">
<span<?php echo $buyer_product_ref_g->l_cm->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->l_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $buyer_product_ref_g->shape->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_shape" class="buyer_product_ref_g_shape">
<span<?php echo $buyer_product_ref_g->shape->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_product_ref_g->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $buyer_product_ref_g->currency->cellAttributes() ?>>
<span id="el<?php echo $buyer_product_ref_g_list->RowCnt ?>_buyer_product_ref_g_currency" class="buyer_product_ref_g_currency">
<span<?php echo $buyer_product_ref_g->currency->viewAttributes() ?>>
<?php echo $buyer_product_ref_g->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$buyer_product_ref_g_list->ListOptions->render("body", "right", $buyer_product_ref_g_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$buyer_product_ref_g->isGridAdd())
		$buyer_product_ref_g_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$buyer_product_ref_g->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($buyer_product_ref_g_list->Recordset)
	$buyer_product_ref_g_list->Recordset->Close();
?>
<?php if (!$buyer_product_ref_g->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$buyer_product_ref_g->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_product_ref_g_list->Pager)) $buyer_product_ref_g_list->Pager = new PrevNextPager($buyer_product_ref_g_list->StartRec, $buyer_product_ref_g_list->DisplayRecs, $buyer_product_ref_g_list->TotalRecs, $buyer_product_ref_g_list->AutoHidePager) ?>
<?php if ($buyer_product_ref_g_list->Pager->RecordCount > 0 && $buyer_product_ref_g_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_product_ref_g_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_product_ref_g_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_product_ref_g_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_product_ref_g_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_product_ref_g_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_product_ref_g_list->pageUrl() ?>start=<?php echo $buyer_product_ref_g_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_product_ref_g_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_product_ref_g_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_product_ref_g_list->TotalRecs > 0 && (!$buyer_product_ref_g_list->AutoHidePageSizeSelector || $buyer_product_ref_g_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_product_ref_g">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_product_ref_g_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_product_ref_g_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_product_ref_g_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_product_ref_g_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_product_ref_g_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_product_ref_g->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_product_ref_g_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($buyer_product_ref_g_list->TotalRecs == 0 && !$buyer_product_ref_g->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $buyer_product_ref_g_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$buyer_product_ref_g_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$buyer_product_ref_g->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$buyer_product_ref_g->isExport()) { ?>
<script>
ew.scrollableTable("gmp_buyer_product_ref_g", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$buyer_product_ref_g_list->terminate();
?>