<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_sales_list = new buyer_sales_list();

// Run the page
$buyer_sales_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_sales_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$buyer_sales->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbuyer_saleslist = currentForm = new ew.Form("fbuyer_saleslist", "list");
fbuyer_saleslist.formKeyCountName = '<?php echo $buyer_sales_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbuyer_saleslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyer_saleslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyer_saleslist.lists["x_godown"] = <?php echo $buyer_sales_list->godown->Lookup->toClientList() ?>;
fbuyer_saleslist.lists["x_godown"].options = <?php echo JsonEncode($buyer_sales_list->godown->lookupOptions()) ?>;
fbuyer_saleslist.lists["x_buyer_id"] = <?php echo $buyer_sales_list->buyer_id->Lookup->toClientList() ?>;
fbuyer_saleslist.lists["x_buyer_id"].options = <?php echo JsonEncode($buyer_sales_list->buyer_id->lookupOptions()) ?>;
fbuyer_saleslist.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyer_saleslist.lists["x_rid"] = <?php echo $buyer_sales_list->rid->Lookup->toClientList() ?>;
fbuyer_saleslist.lists["x_rid"].options = <?php echo JsonEncode($buyer_sales_list->rid->lookupOptions()) ?>;

// Form object for search
var fbuyer_saleslistsrch = currentSearchForm = new ew.Form("fbuyer_saleslistsrch");

// Filters
fbuyer_saleslistsrch.filterList = <?php echo $buyer_sales_list->getFilterList() ?>;

// Init search panel as collapsed
fbuyer_saleslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$buyer_sales->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($buyer_sales_list->TotalRecs > 0 && $buyer_sales_list->ExportOptions->visible()) { ?>
<?php $buyer_sales_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_sales_list->ImportOptions->visible()) { ?>
<?php $buyer_sales_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_sales_list->SearchOptions->visible()) { ?>
<?php $buyer_sales_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_sales_list->FilterOptions->visible()) { ?>
<?php $buyer_sales_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$buyer_sales_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$buyer_sales->isExport() && !$buyer_sales->CurrentAction) { ?>
<form name="fbuyer_saleslistsrch" id="fbuyer_saleslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($buyer_sales_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbuyer_saleslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="buyer_sales">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($buyer_sales_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($buyer_sales_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $buyer_sales_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($buyer_sales_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($buyer_sales_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($buyer_sales_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($buyer_sales_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $buyer_sales_list->showPageHeader(); ?>
<?php
$buyer_sales_list->showMessage();
?>
<?php if ($buyer_sales_list->TotalRecs > 0 || $buyer_sales->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($buyer_sales_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> buyer_sales">
<?php if (!$buyer_sales->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$buyer_sales->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_sales_list->Pager)) $buyer_sales_list->Pager = new PrevNextPager($buyer_sales_list->StartRec, $buyer_sales_list->DisplayRecs, $buyer_sales_list->TotalRecs, $buyer_sales_list->AutoHidePager) ?>
<?php if ($buyer_sales_list->Pager->RecordCount > 0 && $buyer_sales_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_sales_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_sales_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_sales_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_sales_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_sales_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_sales_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_sales_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_sales_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_sales_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_sales_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_sales_list->TotalRecs > 0 && (!$buyer_sales_list->AutoHidePageSizeSelector || $buyer_sales_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_sales">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_sales_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_sales_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_sales_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_sales_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_sales_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_sales->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_sales_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbuyer_saleslist" id="fbuyer_saleslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_sales_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_sales_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer_sales">
<div id="gmp_buyer_sales" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($buyer_sales_list->TotalRecs > 0 || $buyer_sales->isGridEdit()) { ?>
<table id="tbl_buyer_saleslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$buyer_sales_list->RowType = ROWTYPE_HEADER;

// Render list options
$buyer_sales_list->renderListOptions();

// Render list options (header, left)
$buyer_sales_list->ListOptions->render("header", "left");
?>
<?php if ($buyer_sales->godown->Visible) { // godown ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $buyer_sales->godown->headerCellClass() ?>"><div id="elh_buyer_sales_godown" class="buyer_sales_godown"><div class="ew-table-header-caption"><?php echo $buyer_sales->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $buyer_sales->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->godown) ?>',2);"><div id="elh_buyer_sales_godown" class="buyer_sales_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->buyer_id->Visible) { // buyer_id ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $buyer_sales->buyer_id->headerCellClass() ?>"><div id="elh_buyer_sales_buyer_id" class="buyer_sales_buyer_id"><div class="ew-table-header-caption"><?php echo $buyer_sales->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $buyer_sales->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->buyer_id) ?>',2);"><div id="elh_buyer_sales_buyer_id" class="buyer_sales_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->dated->Visible) { // dated ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $buyer_sales->dated->headerCellClass() ?>"><div id="elh_buyer_sales_dated" class="buyer_sales_dated"><div class="ew-table-header-caption"><?php echo $buyer_sales->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $buyer_sales->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->dated) ?>',2);"><div id="elh_buyer_sales_dated" class="buyer_sales_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->rid->Visible) { // rid ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $buyer_sales->rid->headerCellClass() ?>"><div id="elh_buyer_sales_rid" class="buyer_sales_rid"><div class="ew-table-header-caption"><?php echo $buyer_sales->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $buyer_sales->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->rid) ?>',2);"><div id="elh_buyer_sales_rid" class="buyer_sales_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->Amount->Visible) { // Amount ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->Amount) == "") { ?>
		<th data-name="Amount" class="<?php echo $buyer_sales->Amount->headerCellClass() ?>"><div id="elh_buyer_sales_Amount" class="buyer_sales_Amount"><div class="ew-table-header-caption"><?php echo $buyer_sales->Amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Amount" class="<?php echo $buyer_sales->Amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->Amount) ?>',2);"><div id="elh_buyer_sales_Amount" class="buyer_sales_Amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->Amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->Amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->Amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->quantity->Visible) { // quantity ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $buyer_sales->quantity->headerCellClass() ?>"><div id="elh_buyer_sales_quantity" class="buyer_sales_quantity"><div class="ew-table-header-caption"><?php echo $buyer_sales->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $buyer_sales->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->quantity) ?>',2);"><div id="elh_buyer_sales_quantity" class="buyer_sales_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->price->Visible) { // price ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->price) == "") { ?>
		<th data-name="price" class="<?php echo $buyer_sales->price->headerCellClass() ?>"><div id="elh_buyer_sales_price" class="buyer_sales_price"><div class="ew-table-header-caption"><?php echo $buyer_sales->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $buyer_sales->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->price) ?>',2);"><div id="elh_buyer_sales_price" class="buyer_sales_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->lot_no->Visible) { // lot_no ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $buyer_sales->lot_no->headerCellClass() ?>"><div id="elh_buyer_sales_lot_no" class="buyer_sales_lot_no"><div class="ew-table-header-caption"><?php echo $buyer_sales->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $buyer_sales->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->lot_no) ?>',2);"><div id="elh_buyer_sales_lot_no" class="buyer_sales_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_sales->id->Visible) { // id ?>
	<?php if ($buyer_sales->sortUrl($buyer_sales->id) == "") { ?>
		<th data-name="id" class="<?php echo $buyer_sales->id->headerCellClass() ?>"><div id="elh_buyer_sales_id" class="buyer_sales_id"><div class="ew-table-header-caption"><?php echo $buyer_sales->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $buyer_sales->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_sales->SortUrl($buyer_sales->id) ?>',2);"><div id="elh_buyer_sales_id" class="buyer_sales_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_sales->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_sales->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_sales->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$buyer_sales_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($buyer_sales->ExportAll && $buyer_sales->isExport()) {
	$buyer_sales_list->StopRec = $buyer_sales_list->TotalRecs;
} else {

	// Set the last record to display
	if ($buyer_sales_list->TotalRecs > $buyer_sales_list->StartRec + $buyer_sales_list->DisplayRecs - 1)
		$buyer_sales_list->StopRec = $buyer_sales_list->StartRec + $buyer_sales_list->DisplayRecs - 1;
	else
		$buyer_sales_list->StopRec = $buyer_sales_list->TotalRecs;
}
$buyer_sales_list->RecCnt = $buyer_sales_list->StartRec - 1;
if ($buyer_sales_list->Recordset && !$buyer_sales_list->Recordset->EOF) {
	$buyer_sales_list->Recordset->moveFirst();
	$selectLimit = $buyer_sales_list->UseSelectLimit;
	if (!$selectLimit && $buyer_sales_list->StartRec > 1)
		$buyer_sales_list->Recordset->move($buyer_sales_list->StartRec - 1);
} elseif (!$buyer_sales->AllowAddDeleteRow && $buyer_sales_list->StopRec == 0) {
	$buyer_sales_list->StopRec = $buyer_sales->GridAddRowCount;
}

// Initialize aggregate
$buyer_sales->RowType = ROWTYPE_AGGREGATEINIT;
$buyer_sales->resetAttributes();
$buyer_sales_list->renderRow();
while ($buyer_sales_list->RecCnt < $buyer_sales_list->StopRec) {
	$buyer_sales_list->RecCnt++;
	if ($buyer_sales_list->RecCnt >= $buyer_sales_list->StartRec) {
		$buyer_sales_list->RowCnt++;

		// Set up key count
		$buyer_sales_list->KeyCount = $buyer_sales_list->RowIndex;

		// Init row class and style
		$buyer_sales->resetAttributes();
		$buyer_sales->CssClass = "";
		if ($buyer_sales->isGridAdd()) {
		} else {
			$buyer_sales_list->loadRowValues($buyer_sales_list->Recordset); // Load row values
		}
		$buyer_sales->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$buyer_sales->RowAttrs = array_merge($buyer_sales->RowAttrs, array('data-rowindex'=>$buyer_sales_list->RowCnt, 'id'=>'r' . $buyer_sales_list->RowCnt . '_buyer_sales', 'data-rowtype'=>$buyer_sales->RowType));

		// Render row
		$buyer_sales_list->renderRow();

		// Render list options
		$buyer_sales_list->renderListOptions();
?>
	<tr<?php echo $buyer_sales->rowAttributes() ?>>
<?php

// Render list options (body, left)
$buyer_sales_list->ListOptions->render("body", "left", $buyer_sales_list->RowCnt);
?>
	<?php if ($buyer_sales->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $buyer_sales->godown->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_godown" class="buyer_sales_godown">
<span<?php echo $buyer_sales->godown->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_sales->godown->getViewValue())) && $buyer_sales->godown->linkAttributes() <> "") { ?>
<a<?php echo $buyer_sales->godown->linkAttributes() ?>><?php echo $buyer_sales->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_sales->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $buyer_sales->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_buyer_id" class="buyer_sales_buyer_id">
<span<?php echo $buyer_sales->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_sales->buyer_id->getViewValue())) && $buyer_sales->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $buyer_sales->buyer_id->linkAttributes() ?>><?php echo $buyer_sales->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_sales->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $buyer_sales->dated->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_dated" class="buyer_sales_dated">
<span<?php echo $buyer_sales->dated->viewAttributes() ?>>
<?php echo $buyer_sales->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $buyer_sales->rid->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_rid" class="buyer_sales_rid">
<span<?php echo $buyer_sales->rid->viewAttributes() ?>>
<?php if ((!EmptyString($buyer_sales->rid->getViewValue())) && $buyer_sales->rid->linkAttributes() <> "") { ?>
<a<?php echo $buyer_sales->rid->linkAttributes() ?>><?php echo $buyer_sales->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $buyer_sales->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->Amount->Visible) { // Amount ?>
		<td data-name="Amount"<?php echo $buyer_sales->Amount->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_Amount" class="buyer_sales_Amount">
<span<?php echo $buyer_sales->Amount->viewAttributes() ?>>
<?php echo $buyer_sales->Amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $buyer_sales->quantity->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_quantity" class="buyer_sales_quantity">
<span<?php echo $buyer_sales->quantity->viewAttributes() ?>>
<?php echo $buyer_sales->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->price->Visible) { // price ?>
		<td data-name="price"<?php echo $buyer_sales->price->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_price" class="buyer_sales_price">
<span<?php echo $buyer_sales->price->viewAttributes() ?>>
<?php echo $buyer_sales->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $buyer_sales->lot_no->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_lot_no" class="buyer_sales_lot_no">
<span<?php echo $buyer_sales->lot_no->viewAttributes() ?>>
<?php echo $buyer_sales->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_sales->id->Visible) { // id ?>
		<td data-name="id"<?php echo $buyer_sales->id->cellAttributes() ?>>
<span id="el<?php echo $buyer_sales_list->RowCnt ?>_buyer_sales_id" class="buyer_sales_id">
<span<?php echo $buyer_sales->id->viewAttributes() ?>>
<?php echo $buyer_sales->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$buyer_sales_list->ListOptions->render("body", "right", $buyer_sales_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$buyer_sales->isGridAdd())
		$buyer_sales_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$buyer_sales->RowType = ROWTYPE_AGGREGATE;
$buyer_sales->resetAttributes();
$buyer_sales_list->renderRow();
?>
<?php if ($buyer_sales_list->TotalRecs > 0 && !$buyer_sales->isGridAdd() && !$buyer_sales->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$buyer_sales_list->renderListOptions();

// Render list options (footer, left)
$buyer_sales_list->ListOptions->render("footer", "left");
?>
	<?php if ($buyer_sales->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $buyer_sales->godown->footerCellClass() ?>"><span id="elf_buyer_sales_godown" class="buyer_sales_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $buyer_sales->buyer_id->footerCellClass() ?>"><span id="elf_buyer_sales_buyer_id" class="buyer_sales_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $buyer_sales->dated->footerCellClass() ?>"><span id="elf_buyer_sales_dated" class="buyer_sales_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $buyer_sales->rid->footerCellClass() ?>"><span id="elf_buyer_sales_rid" class="buyer_sales_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->Amount->Visible) { // Amount ?>
		<td data-name="Amount" class="<?php echo $buyer_sales->Amount->footerCellClass() ?>"><span id="elf_buyer_sales_Amount" class="buyer_sales_Amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $buyer_sales->Amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $buyer_sales->quantity->footerCellClass() ?>"><span id="elf_buyer_sales_quantity" class="buyer_sales_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $buyer_sales->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->price->Visible) { // price ?>
		<td data-name="price" class="<?php echo $buyer_sales->price->footerCellClass() ?>"><span id="elf_buyer_sales_price" class="buyer_sales_price">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $buyer_sales->lot_no->footerCellClass() ?>"><span id="elf_buyer_sales_lot_no" class="buyer_sales_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($buyer_sales->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $buyer_sales->id->footerCellClass() ?>"><span id="elf_buyer_sales_id" class="buyer_sales_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$buyer_sales_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$buyer_sales->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($buyer_sales_list->Recordset)
	$buyer_sales_list->Recordset->Close();
?>
<?php if (!$buyer_sales->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$buyer_sales->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_sales_list->Pager)) $buyer_sales_list->Pager = new PrevNextPager($buyer_sales_list->StartRec, $buyer_sales_list->DisplayRecs, $buyer_sales_list->TotalRecs, $buyer_sales_list->AutoHidePager) ?>
<?php if ($buyer_sales_list->Pager->RecordCount > 0 && $buyer_sales_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_sales_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_sales_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_sales_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_sales_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_sales_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_sales_list->pageUrl() ?>start=<?php echo $buyer_sales_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_sales_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_sales_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_sales_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_sales_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_sales_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_sales_list->TotalRecs > 0 && (!$buyer_sales_list->AutoHidePageSizeSelector || $buyer_sales_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_sales">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_sales_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_sales_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_sales_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_sales_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_sales_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_sales->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_sales_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($buyer_sales_list->TotalRecs == 0 && !$buyer_sales->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $buyer_sales_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$buyer_sales_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$buyer_sales->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$buyer_sales->isExport()) { ?>
<script>
ew.scrollableTable("gmp_buyer_sales", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$buyer_sales_list->terminate();
?>