<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_sales_search = new buyer_sales_search();

// Run the page
$buyer_sales_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_sales_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($buyer_sales_search->IsModal) { ?>
var fbuyer_salessearch = currentAdvancedSearchForm = new ew.Form("fbuyer_salessearch", "search");
<?php } else { ?>
var fbuyer_salessearch = currentForm = new ew.Form("fbuyer_salessearch", "search");
<?php } ?>

// Form_CustomValidate event
fbuyer_salessearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyer_salessearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyer_salessearch.lists["x_godown"] = <?php echo $buyer_sales_search->godown->Lookup->toClientList() ?>;
fbuyer_salessearch.lists["x_godown"].options = <?php echo JsonEncode($buyer_sales_search->godown->lookupOptions()) ?>;
fbuyer_salessearch.lists["x_buyer_id"] = <?php echo $buyer_sales_search->buyer_id->Lookup->toClientList() ?>;
fbuyer_salessearch.lists["x_buyer_id"].options = <?php echo JsonEncode($buyer_sales_search->buyer_id->lookupOptions()) ?>;
fbuyer_salessearch.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyer_salessearch.lists["x_rid"] = <?php echo $buyer_sales_search->rid->Lookup->toClientList() ?>;
fbuyer_salessearch.lists["x_rid"].options = <?php echo JsonEncode($buyer_sales_search->rid->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbuyer_salessearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_buyer_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer_sales->buyer_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer_sales->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer_sales->Amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer_sales->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer_sales->price->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $buyer_sales_search->showPageHeader(); ?>
<?php
$buyer_sales_search->showMessage();
?>
<form name="fbuyer_salessearch" id="fbuyer_salessearch" class="<?php echo $buyer_sales_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_sales_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_sales_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer_sales">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$buyer_sales_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($buyer_sales->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_godown"><?php echo $buyer_sales->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->godown->cellAttributes() ?>>
			<span id="el_buyer_sales_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_sales" data-field="x_godown" data-value-separator="<?php echo $buyer_sales->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $buyer_sales->godown->editAttributes() ?>>
		<?php echo $buyer_sales->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $buyer_sales->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer_sales->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_buyer_id"><?php echo $buyer_sales->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->buyer_id->cellAttributes() ?>>
			<span id="el_buyer_sales_buyer_id">
<?php
$wrkonchange = "" . trim(@$buyer_sales->buyer_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$buyer_sales->buyer_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?php echo RemoveHtml($buyer_sales->buyer_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($buyer_sales->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($buyer_sales->buyer_id->getPlaceHolder()) ?>"<?php echo $buyer_sales->buyer_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="buyer_sales" data-field="x_buyer_id" data-value-separator="<?php echo $buyer_sales->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($buyer_sales->buyer_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbuyer_salessearch.createAutoSuggest({"id":"x_buyer_id","forceSelect":false});
</script>
<?php echo $buyer_sales->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer_sales->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_dated"><?php echo $buyer_sales->dated->caption() ?></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($buyer_sales->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_buyer_sales_dated">
<input type="text" data-table="buyer_sales" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($buyer_sales->dated->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->dated->EditValue ?>"<?php echo $buyer_sales->dated->editAttributes() ?>>
<?php if (!$buyer_sales->dated->ReadOnly && !$buyer_sales->dated->Disabled && !isset($buyer_sales->dated->EditAttrs["readonly"]) && !isset($buyer_sales->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbuyer_salessearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_buyer_sales_dated" class="btw1_dated d-none">
<input type="text" data-table="buyer_sales" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($buyer_sales->dated->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->dated->EditValue2 ?>"<?php echo $buyer_sales->dated->editAttributes() ?>>
<?php if (!$buyer_sales->dated->ReadOnly && !$buyer_sales->dated->Disabled && !isset($buyer_sales->dated->EditAttrs["readonly"]) && !isset($buyer_sales->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbuyer_salessearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer_sales->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_rid"><?php echo $buyer_sales->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->rid->cellAttributes() ?>>
			<span id="el_buyer_sales_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer_sales" data-field="x_rid" data-value-separator="<?php echo $buyer_sales->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $buyer_sales->rid->editAttributes() ?>>
		<?php echo $buyer_sales->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $buyer_sales->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer_sales->Amount->Visible) { // Amount ?>
	<div id="r_Amount" class="form-group row">
		<label for="x_Amount" class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_Amount"><?php echo $buyer_sales->Amount->caption() ?></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->Amount->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Amount" id="z_Amount" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($buyer_sales->Amount->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_buyer_sales_Amount">
<input type="text" data-table="buyer_sales" data-field="x_Amount" name="x_Amount" id="x_Amount" size="30" placeholder="<?php echo HtmlEncode($buyer_sales->Amount->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->Amount->EditValue ?>"<?php echo $buyer_sales->Amount->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Amount d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_buyer_sales_Amount" class="btw1_Amount d-none">
<input type="text" data-table="buyer_sales" data-field="x_Amount" name="y_Amount" id="y_Amount" size="30" placeholder="<?php echo HtmlEncode($buyer_sales->Amount->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->Amount->EditValue2 ?>"<?php echo $buyer_sales->Amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer_sales->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_quantity"><?php echo $buyer_sales->quantity->caption() ?></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->quantity->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_quantity" id="z_quantity" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($buyer_sales->quantity->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_buyer_sales_quantity">
<input type="text" data-table="buyer_sales" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($buyer_sales->quantity->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->quantity->EditValue ?>"<?php echo $buyer_sales->quantity->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_quantity d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_buyer_sales_quantity" class="btw1_quantity d-none">
<input type="text" data-table="buyer_sales" data-field="x_quantity" name="y_quantity" id="y_quantity" size="30" placeholder="<?php echo HtmlEncode($buyer_sales->quantity->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->quantity->EditValue2 ?>"<?php echo $buyer_sales->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer_sales->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_price"><?php echo $buyer_sales->price->caption() ?></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->price->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_price" id="z_price" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($buyer_sales->price->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_buyer_sales_price">
<input type="text" data-table="buyer_sales" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($buyer_sales->price->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->price->EditValue ?>"<?php echo $buyer_sales->price->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_price d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_buyer_sales_price" class="btw1_price d-none">
<input type="text" data-table="buyer_sales" data-field="x_price" name="y_price" id="y_price" size="30" placeholder="<?php echo HtmlEncode($buyer_sales->price->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->price->EditValue2 ?>"<?php echo $buyer_sales->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer_sales->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $buyer_sales_search->LeftColumnClass ?>"><span id="elh_buyer_sales_lot_no"><?php echo $buyer_sales->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_sales_search->RightColumnClass ?>"><div<?php echo $buyer_sales->lot_no->cellAttributes() ?>>
			<span id="el_buyer_sales_lot_no">
<input type="text" data-table="buyer_sales" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($buyer_sales->lot_no->getPlaceHolder()) ?>" value="<?php echo $buyer_sales->lot_no->EditValue ?>"<?php echo $buyer_sales->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$buyer_sales_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $buyer_sales_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$buyer_sales_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$buyer_sales_search->terminate();
?>