<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_seller_view_list = new buyer_seller_view_list();

// Run the page
$buyer_seller_view_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_seller_view_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$buyer_seller_view->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbuyer_seller_viewlist = currentForm = new ew.Form("fbuyer_seller_viewlist", "list");
fbuyer_seller_viewlist.formKeyCountName = '<?php echo $buyer_seller_view_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbuyer_seller_viewlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyer_seller_viewlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fbuyer_seller_viewlistsrch = currentSearchForm = new ew.Form("fbuyer_seller_viewlistsrch");

// Filters
fbuyer_seller_viewlistsrch.filterList = <?php echo $buyer_seller_view_list->getFilterList() ?>;

// Init search panel as collapsed
fbuyer_seller_viewlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$buyer_seller_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($buyer_seller_view_list->TotalRecs > 0 && $buyer_seller_view_list->ExportOptions->visible()) { ?>
<?php $buyer_seller_view_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_seller_view_list->ImportOptions->visible()) { ?>
<?php $buyer_seller_view_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_seller_view_list->SearchOptions->visible()) { ?>
<?php $buyer_seller_view_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_seller_view_list->FilterOptions->visible()) { ?>
<?php $buyer_seller_view_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$buyer_seller_view_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$buyer_seller_view->isExport() && !$buyer_seller_view->CurrentAction) { ?>
<form name="fbuyer_seller_viewlistsrch" id="fbuyer_seller_viewlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($buyer_seller_view_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbuyer_seller_viewlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="buyer_seller_view">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($buyer_seller_view_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($buyer_seller_view_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $buyer_seller_view_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($buyer_seller_view_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($buyer_seller_view_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($buyer_seller_view_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($buyer_seller_view_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $buyer_seller_view_list->showPageHeader(); ?>
<?php
$buyer_seller_view_list->showMessage();
?>
<?php if ($buyer_seller_view_list->TotalRecs > 0 || $buyer_seller_view->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($buyer_seller_view_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> buyer_seller_view">
<?php if (!$buyer_seller_view->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$buyer_seller_view->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_seller_view_list->Pager)) $buyer_seller_view_list->Pager = new PrevNextPager($buyer_seller_view_list->StartRec, $buyer_seller_view_list->DisplayRecs, $buyer_seller_view_list->TotalRecs, $buyer_seller_view_list->AutoHidePager) ?>
<?php if ($buyer_seller_view_list->Pager->RecordCount > 0 && $buyer_seller_view_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_seller_view_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_seller_view_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_seller_view_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_seller_view_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_seller_view_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_seller_view_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_seller_view_list->TotalRecs > 0 && (!$buyer_seller_view_list->AutoHidePageSizeSelector || $buyer_seller_view_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_seller_view">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_seller_view_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_seller_view_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_seller_view_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_seller_view_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_seller_view_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_seller_view->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_seller_view_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbuyer_seller_viewlist" id="fbuyer_seller_viewlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_seller_view_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_seller_view_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer_seller_view">
<div id="gmp_buyer_seller_view" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($buyer_seller_view_list->TotalRecs > 0 || $buyer_seller_view->isGridEdit()) { ?>
<table id="tbl_buyer_seller_viewlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$buyer_seller_view_list->RowType = ROWTYPE_HEADER;

// Render list options
$buyer_seller_view_list->renderListOptions();

// Render list options (header, left)
$buyer_seller_view_list->ListOptions->render("header", "left");
?>
<?php if ($buyer_seller_view->id->Visible) { // id ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->id) == "") { ?>
		<th data-name="id" class="<?php echo $buyer_seller_view->id->headerCellClass() ?>"><div id="elh_buyer_seller_view_id" class="buyer_seller_view_id"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $buyer_seller_view->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->id) ?>',2);"><div id="elh_buyer_seller_view_id" class="buyer_seller_view_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->name->Visible) { // name ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->name) == "") { ?>
		<th data-name="name" class="<?php echo $buyer_seller_view->name->headerCellClass() ?>"><div id="elh_buyer_seller_view_name" class="buyer_seller_view_name"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $buyer_seller_view->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->name) ?>',2);"><div id="elh_buyer_seller_view_name" class="buyer_seller_view_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->status->Visible) { // status ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->status) == "") { ?>
		<th data-name="status" class="<?php echo $buyer_seller_view->status->headerCellClass() ?>"><div id="elh_buyer_seller_view_status" class="buyer_seller_view_status"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $buyer_seller_view->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->status) ?>',2);"><div id="elh_buyer_seller_view_status" class="buyer_seller_view_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->partner_type->Visible) { // partner_type ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->partner_type) == "") { ?>
		<th data-name="partner_type" class="<?php echo $buyer_seller_view->partner_type->headerCellClass() ?>"><div id="elh_buyer_seller_view_partner_type" class="buyer_seller_view_partner_type"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->partner_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_type" class="<?php echo $buyer_seller_view->partner_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->partner_type) ?>',2);"><div id="elh_buyer_seller_view_partner_type" class="buyer_seller_view_partner_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->partner_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->partner_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->partner_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->address->Visible) { // address ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->address) == "") { ?>
		<th data-name="address" class="<?php echo $buyer_seller_view->address->headerCellClass() ?>"><div id="elh_buyer_seller_view_address" class="buyer_seller_view_address"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $buyer_seller_view->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->address) ?>',2);"><div id="elh_buyer_seller_view_address" class="buyer_seller_view_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->merchant->Visible) { // merchant ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->merchant) == "") { ?>
		<th data-name="merchant" class="<?php echo $buyer_seller_view->merchant->headerCellClass() ?>"><div id="elh_buyer_seller_view_merchant" class="buyer_seller_view_merchant"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->merchant->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="merchant" class="<?php echo $buyer_seller_view->merchant->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->merchant) ?>',2);"><div id="elh_buyer_seller_view_merchant" class="buyer_seller_view_merchant">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->merchant->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->merchant->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->merchant->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->category->Visible) { // category ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->category) == "") { ?>
		<th data-name="category" class="<?php echo $buyer_seller_view->category->headerCellClass() ?>"><div id="elh_buyer_seller_view_category" class="buyer_seller_view_category"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $buyer_seller_view->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->category) ?>',2);"><div id="elh_buyer_seller_view_category" class="buyer_seller_view_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->currency->Visible) { // currency ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $buyer_seller_view->currency->headerCellClass() ?>"><div id="elh_buyer_seller_view_currency" class="buyer_seller_view_currency"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $buyer_seller_view->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->currency) ?>',2);"><div id="elh_buyer_seller_view_currency" class="buyer_seller_view_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->currency->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->mo_type->Visible) { // mo_type ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->mo_type) == "") { ?>
		<th data-name="mo_type" class="<?php echo $buyer_seller_view->mo_type->headerCellClass() ?>"><div id="elh_buyer_seller_view_mo_type" class="buyer_seller_view_mo_type"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->mo_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mo_type" class="<?php echo $buyer_seller_view->mo_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->mo_type) ?>',2);"><div id="elh_buyer_seller_view_mo_type" class="buyer_seller_view_mo_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->mo_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->mo_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->mo_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->mobile->Visible) { // mobile ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $buyer_seller_view->mobile->headerCellClass() ?>"><div id="elh_buyer_seller_view_mobile" class="buyer_seller_view_mobile"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $buyer_seller_view->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->mobile) ?>',2);"><div id="elh_buyer_seller_view_mobile" class="buyer_seller_view_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer_seller_view->code->Visible) { // code ?>
	<?php if ($buyer_seller_view->sortUrl($buyer_seller_view->code) == "") { ?>
		<th data-name="code" class="<?php echo $buyer_seller_view->code->headerCellClass() ?>"><div id="elh_buyer_seller_view_code" class="buyer_seller_view_code"><div class="ew-table-header-caption"><?php echo $buyer_seller_view->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $buyer_seller_view->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer_seller_view->SortUrl($buyer_seller_view->code) ?>',2);"><div id="elh_buyer_seller_view_code" class="buyer_seller_view_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer_seller_view->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer_seller_view->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer_seller_view->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$buyer_seller_view_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($buyer_seller_view->ExportAll && $buyer_seller_view->isExport()) {
	$buyer_seller_view_list->StopRec = $buyer_seller_view_list->TotalRecs;
} else {

	// Set the last record to display
	if ($buyer_seller_view_list->TotalRecs > $buyer_seller_view_list->StartRec + $buyer_seller_view_list->DisplayRecs - 1)
		$buyer_seller_view_list->StopRec = $buyer_seller_view_list->StartRec + $buyer_seller_view_list->DisplayRecs - 1;
	else
		$buyer_seller_view_list->StopRec = $buyer_seller_view_list->TotalRecs;
}
$buyer_seller_view_list->RecCnt = $buyer_seller_view_list->StartRec - 1;
if ($buyer_seller_view_list->Recordset && !$buyer_seller_view_list->Recordset->EOF) {
	$buyer_seller_view_list->Recordset->moveFirst();
	$selectLimit = $buyer_seller_view_list->UseSelectLimit;
	if (!$selectLimit && $buyer_seller_view_list->StartRec > 1)
		$buyer_seller_view_list->Recordset->move($buyer_seller_view_list->StartRec - 1);
} elseif (!$buyer_seller_view->AllowAddDeleteRow && $buyer_seller_view_list->StopRec == 0) {
	$buyer_seller_view_list->StopRec = $buyer_seller_view->GridAddRowCount;
}

// Initialize aggregate
$buyer_seller_view->RowType = ROWTYPE_AGGREGATEINIT;
$buyer_seller_view->resetAttributes();
$buyer_seller_view_list->renderRow();
while ($buyer_seller_view_list->RecCnt < $buyer_seller_view_list->StopRec) {
	$buyer_seller_view_list->RecCnt++;
	if ($buyer_seller_view_list->RecCnt >= $buyer_seller_view_list->StartRec) {
		$buyer_seller_view_list->RowCnt++;

		// Set up key count
		$buyer_seller_view_list->KeyCount = $buyer_seller_view_list->RowIndex;

		// Init row class and style
		$buyer_seller_view->resetAttributes();
		$buyer_seller_view->CssClass = "";
		if ($buyer_seller_view->isGridAdd()) {
		} else {
			$buyer_seller_view_list->loadRowValues($buyer_seller_view_list->Recordset); // Load row values
		}
		$buyer_seller_view->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$buyer_seller_view->RowAttrs = array_merge($buyer_seller_view->RowAttrs, array('data-rowindex'=>$buyer_seller_view_list->RowCnt, 'id'=>'r' . $buyer_seller_view_list->RowCnt . '_buyer_seller_view', 'data-rowtype'=>$buyer_seller_view->RowType));

		// Render row
		$buyer_seller_view_list->renderRow();

		// Render list options
		$buyer_seller_view_list->renderListOptions();
?>
	<tr<?php echo $buyer_seller_view->rowAttributes() ?>>
<?php

// Render list options (body, left)
$buyer_seller_view_list->ListOptions->render("body", "left", $buyer_seller_view_list->RowCnt);
?>
	<?php if ($buyer_seller_view->id->Visible) { // id ?>
		<td data-name="id"<?php echo $buyer_seller_view->id->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_id" class="buyer_seller_view_id">
<span<?php echo $buyer_seller_view->id->viewAttributes() ?>>
<?php echo $buyer_seller_view->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->name->Visible) { // name ?>
		<td data-name="name"<?php echo $buyer_seller_view->name->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_name" class="buyer_seller_view_name">
<span<?php echo $buyer_seller_view->name->viewAttributes() ?>>
<?php echo $buyer_seller_view->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->status->Visible) { // status ?>
		<td data-name="status"<?php echo $buyer_seller_view->status->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_status" class="buyer_seller_view_status">
<span<?php echo $buyer_seller_view->status->viewAttributes() ?>>
<?php echo $buyer_seller_view->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->partner_type->Visible) { // partner_type ?>
		<td data-name="partner_type"<?php echo $buyer_seller_view->partner_type->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_partner_type" class="buyer_seller_view_partner_type">
<span<?php echo $buyer_seller_view->partner_type->viewAttributes() ?>>
<?php echo $buyer_seller_view->partner_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->address->Visible) { // address ?>
		<td data-name="address"<?php echo $buyer_seller_view->address->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_address" class="buyer_seller_view_address">
<span<?php echo $buyer_seller_view->address->viewAttributes() ?>>
<?php echo $buyer_seller_view->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->merchant->Visible) { // merchant ?>
		<td data-name="merchant"<?php echo $buyer_seller_view->merchant->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_merchant" class="buyer_seller_view_merchant">
<span<?php echo $buyer_seller_view->merchant->viewAttributes() ?>>
<?php echo $buyer_seller_view->merchant->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->category->Visible) { // category ?>
		<td data-name="category"<?php echo $buyer_seller_view->category->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_category" class="buyer_seller_view_category">
<span<?php echo $buyer_seller_view->category->viewAttributes() ?>>
<?php echo $buyer_seller_view->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $buyer_seller_view->currency->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_currency" class="buyer_seller_view_currency">
<span<?php echo $buyer_seller_view->currency->viewAttributes() ?>>
<?php echo $buyer_seller_view->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->mo_type->Visible) { // mo_type ?>
		<td data-name="mo_type"<?php echo $buyer_seller_view->mo_type->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_mo_type" class="buyer_seller_view_mo_type">
<span<?php echo $buyer_seller_view->mo_type->viewAttributes() ?>>
<?php echo $buyer_seller_view->mo_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $buyer_seller_view->mobile->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_mobile" class="buyer_seller_view_mobile">
<span<?php echo $buyer_seller_view->mobile->viewAttributes() ?>>
<?php echo $buyer_seller_view->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer_seller_view->code->Visible) { // code ?>
		<td data-name="code"<?php echo $buyer_seller_view->code->cellAttributes() ?>>
<span id="el<?php echo $buyer_seller_view_list->RowCnt ?>_buyer_seller_view_code" class="buyer_seller_view_code">
<span<?php echo $buyer_seller_view->code->viewAttributes() ?>>
<?php echo $buyer_seller_view->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$buyer_seller_view_list->ListOptions->render("body", "right", $buyer_seller_view_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$buyer_seller_view->isGridAdd())
		$buyer_seller_view_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$buyer_seller_view->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($buyer_seller_view_list->Recordset)
	$buyer_seller_view_list->Recordset->Close();
?>
<?php if (!$buyer_seller_view->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$buyer_seller_view->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_seller_view_list->Pager)) $buyer_seller_view_list->Pager = new PrevNextPager($buyer_seller_view_list->StartRec, $buyer_seller_view_list->DisplayRecs, $buyer_seller_view_list->TotalRecs, $buyer_seller_view_list->AutoHidePager) ?>
<?php if ($buyer_seller_view_list->Pager->RecordCount > 0 && $buyer_seller_view_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_seller_view_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_seller_view_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_seller_view_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_seller_view_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_seller_view_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_seller_view_list->pageUrl() ?>start=<?php echo $buyer_seller_view_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_seller_view_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_seller_view_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_seller_view_list->TotalRecs > 0 && (!$buyer_seller_view_list->AutoHidePageSizeSelector || $buyer_seller_view_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer_seller_view">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_seller_view_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_seller_view_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_seller_view_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_seller_view_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_seller_view_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer_seller_view->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_seller_view_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($buyer_seller_view_list->TotalRecs == 0 && !$buyer_seller_view->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $buyer_seller_view_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$buyer_seller_view_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$buyer_seller_view->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$buyer_seller_view->isExport()) { ?>
<script>
ew.scrollableTable("gmp_buyer_seller_view", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$buyer_seller_view_list->terminate();
?>