<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_addopt = new buyer_addopt();

// Run the page
$buyer_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fbuyeraddopt = currentForm = new ew.Form("fbuyeraddopt", "addopt");

// Validate form
fbuyeraddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($buyer_addopt->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->category->caption(), $buyer->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->sub_category->Required) { ?>
			elm = this.getElements("x" + infix + "_sub_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->sub_category->caption(), $buyer->sub_category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->grp->caption(), $buyer->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->name->caption(), $buyer->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->code->caption(), $buyer->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){1,6}$/))
				return this.onError(elm, "<?php echo JsEncode($buyer->code->errorMessage()) ?>");
		<?php if ($buyer_addopt->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->mobile->caption(), $buyer->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->_email->caption(), $buyer->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->country->caption(), $buyer->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->region->Required) { ?>
			elm = this.getElements("x" + infix + "_region");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->region->caption(), $buyer->region->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->city->caption(), $buyer->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->address->caption(), $buyer->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->reports_to->caption(), $buyer->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->status->caption(), $buyer->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->tax_registration->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_registration");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->tax_registration->caption(), $buyer->tax_registration->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->operator->caption(), $buyer->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->datetime->caption(), $buyer->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_addopt->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->remarks->caption(), $buyer->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbuyeraddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyeraddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyeraddopt.lists["x_category"] = <?php echo $buyer_addopt->category->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_category"].options = <?php echo JsonEncode($buyer_addopt->category->lookupOptions()) ?>;
fbuyeraddopt.lists["x_sub_category"] = <?php echo $buyer_addopt->sub_category->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_sub_category"].options = <?php echo JsonEncode($buyer_addopt->sub_category->lookupOptions()) ?>;
fbuyeraddopt.lists["x_grp[]"] = <?php echo $buyer_addopt->grp->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_grp[]"].options = <?php echo JsonEncode($buyer_addopt->grp->lookupOptions()) ?>;
fbuyeraddopt.lists["x_country"] = <?php echo $buyer_addopt->country->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_country"].options = <?php echo JsonEncode($buyer_addopt->country->lookupOptions()) ?>;
fbuyeraddopt.lists["x_region"] = <?php echo $buyer_addopt->region->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_region"].options = <?php echo JsonEncode($buyer_addopt->region->lookupOptions()) ?>;
fbuyeraddopt.lists["x_city"] = <?php echo $buyer_addopt->city->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_city"].options = <?php echo JsonEncode($buyer_addopt->city->lookupOptions()) ?>;
fbuyeraddopt.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyeraddopt.lists["x_reports_to[]"] = <?php echo $buyer_addopt->reports_to->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_reports_to[]"].options = <?php echo JsonEncode($buyer_addopt->reports_to->lookupOptions()) ?>;
fbuyeraddopt.lists["x_status"] = <?php echo $buyer_addopt->status->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_status"].options = <?php echo JsonEncode($buyer_addopt->status->options(FALSE, TRUE)) ?>;
fbuyeraddopt.lists["x_operator"] = <?php echo $buyer_addopt->operator->Lookup->toClientList() ?>;
fbuyeraddopt.lists["x_operator"].options = <?php echo JsonEncode($buyer_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $buyer_addopt->showPageHeader(); ?>
<?php
$buyer_addopt->showMessage();
?>
<form name="fbuyeraddopt" id="fbuyeraddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($buyer_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $buyer_addopt->TableVar ?>">
<?php if ($buyer->category->Visible) { // category ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_category"><?php echo $buyer->category->caption() ?><?php echo ($buyer->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $buyer->category->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->category->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_category" data-value-separator="<?php echo $buyer->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $buyer->category->editAttributes() ?>>
		<?php echo $buyer->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $buyer->category->Lookup->getParamTag("p_x_category") ?>
<?php echo $buyer->category->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->sub_category->Visible) { // sub_category ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_sub_category"><?php echo $buyer->sub_category->caption() ?><?php echo ($buyer->sub_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_sub_category" data-value-separator="<?php echo $buyer->sub_category->displayValueSeparatorAttribute() ?>" id="x_sub_category" name="x_sub_category"<?php echo $buyer->sub_category->editAttributes() ?>>
		<?php echo $buyer->sub_category->selectOptionListHtml("x_sub_category") ?>
	</select>
</div>
<?php echo $buyer->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
<?php echo $buyer->sub_category->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $buyer->grp->caption() ?><?php echo ($buyer->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="buyer" data-field="x_grp" data-value-separator="<?php echo $buyer->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $buyer->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $buyer->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $buyer->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $buyer->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $buyer->name->caption() ?><?php echo ($buyer->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="buyer" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($buyer->name->getPlaceHolder()) ?>" value="<?php echo $buyer->name->EditValue ?>"<?php echo $buyer->name->editAttributes() ?>>
<?php echo $buyer->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $buyer->code->caption() ?><?php echo ($buyer->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="buyer" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($buyer->code->getPlaceHolder()) ?>" value="<?php echo $buyer->code->EditValue ?>"<?php echo $buyer->code->editAttributes() ?>>
<?php echo $buyer->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->mobile->Visible) { // mobile ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile"><?php echo $buyer->mobile->caption() ?><?php echo ($buyer->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="buyer" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($buyer->mobile->getPlaceHolder()) ?>" value="<?php echo $buyer->mobile->EditValue ?>"<?php echo $buyer->mobile->editAttributes() ?>>
<?php echo $buyer->mobile->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->_email->Visible) { // email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__email"><?php echo $buyer->_email->caption() ?><?php echo ($buyer->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="buyer" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($buyer->_email->getPlaceHolder()) ?>" value="<?php echo $buyer->_email->EditValue ?>"<?php echo $buyer->_email->editAttributes() ?>>
<?php echo $buyer->_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->country->Visible) { // country ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_country"><?php echo $buyer->country->caption() ?><?php echo ($buyer->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $buyer->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_country" data-value-separator="<?php echo $buyer->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $buyer->country->editAttributes() ?>>
		<?php echo $buyer->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $buyer->country->Lookup->getParamTag("p_x_country") ?>
<?php echo $buyer->country->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->region->Visible) { // region ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_region"><?php echo $buyer->region->caption() ?><?php echo ($buyer->region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $buyer->region->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->region->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_region" data-value-separator="<?php echo $buyer->region->displayValueSeparatorAttribute() ?>" id="x_region" name="x_region"<?php echo $buyer->region->editAttributes() ?>>
		<?php echo $buyer->region->selectOptionListHtml("x_region") ?>
	</select>
</div>
<?php echo $buyer->region->Lookup->getParamTag("p_x_region") ?>
<?php echo $buyer->region->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->city->Visible) { // city ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $buyer->city->caption() ?><?php echo ($buyer->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$buyer->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$buyer->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($buyer->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($buyer->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($buyer->city->getPlaceHolder()) ?>"<?php echo $buyer->city->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($buyer->city->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_city',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($buyer->city->ReadOnly || $buyer->city->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="buyer" data-field="x_city" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $buyer->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($buyer->city->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbuyeraddopt.createAutoSuggest({"id":"x_city","forceSelect":true});
</script>
<?php echo $buyer->city->Lookup->getParamTag("p_x_city") ?>
<?php echo $buyer->city->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->address->Visible) { // address ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_address"><?php echo $buyer->address->caption() ?><?php echo ($buyer->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="buyer" data-field="x_address" name="x_address" id="x_address" cols="30" rows="4" placeholder="<?php echo HtmlEncode($buyer->address->getPlaceHolder()) ?>"<?php echo $buyer->address->editAttributes() ?>><?php echo $buyer->address->EditValue ?></textarea>
<?php echo $buyer->address->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->reports_to->Visible) { // reports_to ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_reports_to"><?php echo $buyer->reports_to->caption() ?><?php echo ($buyer->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_reports_to" data-value-separator="<?php echo $buyer->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to[]" name="x_reports_to[]" multiple="multiple"<?php echo $buyer->reports_to->editAttributes() ?>>
		<?php echo $buyer->reports_to->selectOptionListHtml("x_reports_to[]") ?>
	</select>
</div>
<?php echo $buyer->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
<?php echo $buyer->reports_to->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $buyer->status->caption() ?><?php echo ($buyer->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_status" data-value-separator="<?php echo $buyer->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $buyer->status->editAttributes() ?>>
		<?php echo $buyer->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $buyer->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->tax_registration->Visible) { // tax_registration ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_tax_registration"><?php echo $buyer->tax_registration->caption() ?><?php echo ($buyer->tax_registration->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="buyer" data-field="x_tax_registration" name="x_tax_registration" id="x_tax_registration" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($buyer->tax_registration->getPlaceHolder()) ?>" value="<?php echo $buyer->tax_registration->EditValue ?>"<?php echo $buyer->tax_registration->editAttributes() ?>>
<?php echo $buyer->tax_registration->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($buyer->operator->Visible) { // operator ?>
	<input type="hidden" data-table="buyer" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($buyer->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($buyer->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="buyer" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($buyer->datetime->CurrentValue) ?>">
	<?php if (!$buyer->datetime->ReadOnly && !$buyer->datetime->Disabled && !isset($buyer->datetime->EditAttrs["readonly"]) && !isset($buyer->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fbuyeraddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($buyer->remarks->Visible) { // remarks ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remarks"><?php echo $buyer->remarks->caption() ?><?php echo ($buyer->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="buyer" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($buyer->remarks->getPlaceHolder()) ?>" value="<?php echo $buyer->remarks->EditValue ?>"<?php echo $buyer->remarks->editAttributes() ?>>
<?php echo $buyer->remarks->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$buyer_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$buyer_addopt->terminate();
?>