<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_edit = new buyer_edit();

// Run the page
$buyer_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbuyeredit = currentForm = new ew.Form("fbuyeredit", "edit");

// Validate form
fbuyeredit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($buyer_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->id->caption(), $buyer->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer->id->errorMessage()) ?>");
		<?php if ($buyer_edit->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->user_name->caption(), $buyer->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->password->Required) { ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->password->caption(), $buyer->password->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->category->caption(), $buyer->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->sub_category->Required) { ?>
			elm = this.getElements("x" + infix + "_sub_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->sub_category->caption(), $buyer->sub_category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->grp->caption(), $buyer->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->name->caption(), $buyer->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->code->caption(), $buyer->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){1,6}$/))
				return this.onError(elm, "<?php echo JsEncode($buyer->code->errorMessage()) ?>");
		<?php if ($buyer_edit->seller->Required) { ?>
			elm = this.getElements("x" + infix + "_seller");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->seller->caption(), $buyer->seller->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->mobile->caption(), $buyer->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->_email->caption(), $buyer->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->country->caption(), $buyer->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->region->Required) { ?>
			elm = this.getElements("x" + infix + "_region");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->region->caption(), $buyer->region->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->city->caption(), $buyer->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->address->caption(), $buyer->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->location->caption(), $buyer->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->reports_to->caption(), $buyer->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->status->caption(), $buyer->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->tax_registration->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_registration");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->tax_registration->caption(), $buyer->tax_registration->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->currency->caption(), $buyer->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->port_sea->Required) { ?>
			elm = this.getElements("x" + infix + "_port_sea");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->port_sea->caption(), $buyer->port_sea->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->incoterm->Required) { ?>
			elm = this.getElements("x" + infix + "_incoterm[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->incoterm->caption(), $buyer->incoterm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->port_air->Required) { ?>
			elm = this.getElements("x" + infix + "_port_air");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->port_air->caption(), $buyer->port_air->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->operator->caption(), $buyer->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->datetime->caption(), $buyer->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($buyer_edit->price_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_price_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->price_percent->caption(), $buyer->price_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($buyer->price_percent->errorMessage()) ?>");
		<?php if ($buyer_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $buyer->remarks->caption(), $buyer->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbuyeredit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyeredit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyeredit.lists["x_category"] = <?php echo $buyer_edit->category->Lookup->toClientList() ?>;
fbuyeredit.lists["x_category"].options = <?php echo JsonEncode($buyer_edit->category->lookupOptions()) ?>;
fbuyeredit.lists["x_sub_category"] = <?php echo $buyer_edit->sub_category->Lookup->toClientList() ?>;
fbuyeredit.lists["x_sub_category"].options = <?php echo JsonEncode($buyer_edit->sub_category->lookupOptions()) ?>;
fbuyeredit.lists["x_grp[]"] = <?php echo $buyer_edit->grp->Lookup->toClientList() ?>;
fbuyeredit.lists["x_grp[]"].options = <?php echo JsonEncode($buyer_edit->grp->lookupOptions()) ?>;
fbuyeredit.lists["x_seller"] = <?php echo $buyer_edit->seller->Lookup->toClientList() ?>;
fbuyeredit.lists["x_seller"].options = <?php echo JsonEncode($buyer_edit->seller->lookupOptions()) ?>;
fbuyeredit.lists["x_country"] = <?php echo $buyer_edit->country->Lookup->toClientList() ?>;
fbuyeredit.lists["x_country"].options = <?php echo JsonEncode($buyer_edit->country->lookupOptions()) ?>;
fbuyeredit.lists["x_region"] = <?php echo $buyer_edit->region->Lookup->toClientList() ?>;
fbuyeredit.lists["x_region"].options = <?php echo JsonEncode($buyer_edit->region->lookupOptions()) ?>;
fbuyeredit.lists["x_city"] = <?php echo $buyer_edit->city->Lookup->toClientList() ?>;
fbuyeredit.lists["x_city"].options = <?php echo JsonEncode($buyer_edit->city->lookupOptions()) ?>;
fbuyeredit.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyeredit.lists["x_location"] = <?php echo $buyer_edit->location->Lookup->toClientList() ?>;
fbuyeredit.lists["x_location"].options = <?php echo JsonEncode($buyer_edit->location->lookupOptions()) ?>;
fbuyeredit.autoSuggests["x_location"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyeredit.lists["x_reports_to[]"] = <?php echo $buyer_edit->reports_to->Lookup->toClientList() ?>;
fbuyeredit.lists["x_reports_to[]"].options = <?php echo JsonEncode($buyer_edit->reports_to->lookupOptions()) ?>;
fbuyeredit.lists["x_status"] = <?php echo $buyer_edit->status->Lookup->toClientList() ?>;
fbuyeredit.lists["x_status"].options = <?php echo JsonEncode($buyer_edit->status->options(FALSE, TRUE)) ?>;
fbuyeredit.lists["x_currency"] = <?php echo $buyer_edit->currency->Lookup->toClientList() ?>;
fbuyeredit.lists["x_currency"].options = <?php echo JsonEncode($buyer_edit->currency->lookupOptions()) ?>;
fbuyeredit.lists["x_port_sea"] = <?php echo $buyer_edit->port_sea->Lookup->toClientList() ?>;
fbuyeredit.lists["x_port_sea"].options = <?php echo JsonEncode($buyer_edit->port_sea->lookupOptions()) ?>;
fbuyeredit.lists["x_incoterm[]"] = <?php echo $buyer_edit->incoterm->Lookup->toClientList() ?>;
fbuyeredit.lists["x_incoterm[]"].options = <?php echo JsonEncode($buyer_edit->incoterm->lookupOptions()) ?>;
fbuyeredit.lists["x_port_air"] = <?php echo $buyer_edit->port_air->Lookup->toClientList() ?>;
fbuyeredit.lists["x_port_air"].options = <?php echo JsonEncode($buyer_edit->port_air->lookupOptions()) ?>;
fbuyeredit.lists["x_operator"] = <?php echo $buyer_edit->operator->Lookup->toClientList() ?>;
fbuyeredit.lists["x_operator"].options = <?php echo JsonEncode($buyer_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $buyer_edit->showPageHeader(); ?>
<?php
$buyer_edit->showMessage();
?>
<form name="fbuyeredit" id="fbuyeredit" class="<?php echo $buyer_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$buyer_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($buyer->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_buyer_id" for="x_id" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->id->caption() ?><?php echo ($buyer->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->id->cellAttributes() ?>>
<span id="el_buyer_id">
<span<?php echo $buyer->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($buyer->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="buyer" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($buyer->id->CurrentValue) ?>">
<?php echo $buyer->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_buyer_user_name" for="x_user_name" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->user_name->caption() ?><?php echo ($buyer->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->user_name->cellAttributes() ?>>
<span id="el_buyer_user_name">
<input type="text" data-table="buyer" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($buyer->user_name->getPlaceHolder()) ?>" value="<?php echo $buyer->user_name->EditValue ?>"<?php echo $buyer->user_name->editAttributes() ?>>
</span>
<?php echo $buyer->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label id="elh_buyer_password" for="x_password" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->password->caption() ?><?php echo ($buyer->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->password->cellAttributes() ?>>
<span id="el_buyer_password">
<input type="text" data-table="buyer" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($buyer->password->getPlaceHolder()) ?>" value="<?php echo $buyer->password->EditValue ?>"<?php echo $buyer->password->editAttributes() ?>>
</span>
<?php echo $buyer->password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_buyer_category" for="x_category" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->category->caption() ?><?php echo ($buyer->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->category->cellAttributes() ?>>
<span id="el_buyer_category">
<?php $buyer->category->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->category->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_category" data-value-separator="<?php echo $buyer->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $buyer->category->editAttributes() ?>>
		<?php echo $buyer->category->selectOptionListHtml("x_category") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "pp_category") && !$buyer->category->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_category" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $buyer->category->caption() ?>" data-title="<?php echo $buyer->category->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_category',url:'pp_categoryaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $buyer->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $buyer->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->sub_category->Visible) { // sub_category ?>
	<div id="r_sub_category" class="form-group row">
		<label id="elh_buyer_sub_category" for="x_sub_category" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->sub_category->caption() ?><?php echo ($buyer->sub_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->sub_category->cellAttributes() ?>>
<span id="el_buyer_sub_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_sub_category" data-value-separator="<?php echo $buyer->sub_category->displayValueSeparatorAttribute() ?>" id="x_sub_category" name="x_sub_category"<?php echo $buyer->sub_category->editAttributes() ?>>
		<?php echo $buyer->sub_category->selectOptionListHtml("x_sub_category") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "pp_category") && !$buyer->sub_category->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sub_category" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $buyer->sub_category->caption() ?>" data-title="<?php echo $buyer->sub_category->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_sub_category',url:'pp_categoryaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $buyer->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
</span>
<?php echo $buyer->sub_category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_buyer_grp" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->grp->caption() ?><?php echo ($buyer->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->grp->cellAttributes() ?>>
<span id="el_buyer_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="buyer" data-field="x_grp" data-value-separator="<?php echo $buyer->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $buyer->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $buyer->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $buyer->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $buyer->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_buyer_name" for="x_name" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->name->caption() ?><?php echo ($buyer->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->name->cellAttributes() ?>>
<span id="el_buyer_name">
<input type="text" data-table="buyer" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($buyer->name->getPlaceHolder()) ?>" value="<?php echo $buyer->name->EditValue ?>"<?php echo $buyer->name->editAttributes() ?>>
</span>
<?php echo $buyer->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_buyer_code" for="x_code" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->code->caption() ?><?php echo ($buyer->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->code->cellAttributes() ?>>
<span id="el_buyer_code">
<input type="text" data-table="buyer" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($buyer->code->getPlaceHolder()) ?>" value="<?php echo $buyer->code->EditValue ?>"<?php echo $buyer->code->editAttributes() ?>>
</span>
<?php echo $buyer->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->seller->Visible) { // seller ?>
	<div id="r_seller" class="form-group row">
		<label id="elh_buyer_seller" for="x_seller" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->seller->caption() ?><?php echo ($buyer->seller->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->seller->cellAttributes() ?>>
<span id="el_buyer_seller">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_seller" data-value-separator="<?php echo $buyer->seller->displayValueSeparatorAttribute() ?>" id="x_seller" name="x_seller"<?php echo $buyer->seller->editAttributes() ?>>
		<?php echo $buyer->seller->selectOptionListHtml("x_seller") ?>
	</select>
</div>
<?php echo $buyer->seller->Lookup->getParamTag("p_x_seller") ?>
</span>
<?php echo $buyer->seller->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_buyer_mobile" for="x_mobile" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->mobile->caption() ?><?php echo ($buyer->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->mobile->cellAttributes() ?>>
<span id="el_buyer_mobile">
<input type="text" data-table="buyer" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($buyer->mobile->getPlaceHolder()) ?>" value="<?php echo $buyer->mobile->EditValue ?>"<?php echo $buyer->mobile->editAttributes() ?>>
</span>
<?php echo $buyer->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_buyer__email" for="x__email" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->_email->caption() ?><?php echo ($buyer->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->_email->cellAttributes() ?>>
<span id="el_buyer__email">
<input type="text" data-table="buyer" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($buyer->_email->getPlaceHolder()) ?>" value="<?php echo $buyer->_email->EditValue ?>"<?php echo $buyer->_email->editAttributes() ?>>
</span>
<?php echo $buyer->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label id="elh_buyer_country" for="x_country" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->country->caption() ?><?php echo ($buyer->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->country->cellAttributes() ?>>
<span id="el_buyer_country">
<?php $buyer->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_country" data-value-separator="<?php echo $buyer->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $buyer->country->editAttributes() ?>>
		<?php echo $buyer->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $buyer->country->Lookup->getParamTag("p_x_country") ?>
</span>
<?php echo $buyer->country->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->region->Visible) { // region ?>
	<div id="r_region" class="form-group row">
		<label id="elh_buyer_region" for="x_region" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->region->caption() ?><?php echo ($buyer->region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->region->cellAttributes() ?>>
<span id="el_buyer_region">
<?php $buyer->region->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->region->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_region" data-value-separator="<?php echo $buyer->region->displayValueSeparatorAttribute() ?>" id="x_region" name="x_region"<?php echo $buyer->region->editAttributes() ?>>
		<?php echo $buyer->region->selectOptionListHtml("x_region") ?>
	</select>
</div>
<?php echo $buyer->region->Lookup->getParamTag("p_x_region") ?>
</span>
<?php echo $buyer->region->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label id="elh_buyer_city" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->city->caption() ?><?php echo ($buyer->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->city->cellAttributes() ?>>
<span id="el_buyer_city">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$buyer->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$buyer->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($buyer->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($buyer->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($buyer->city->getPlaceHolder()) ?>"<?php echo $buyer->city->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($buyer->city->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_city',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($buyer->city->ReadOnly || $buyer->city->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="buyer" data-field="x_city" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $buyer->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($buyer->city->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbuyeredit.createAutoSuggest({"id":"x_city","forceSelect":true});
</script>
<?php echo $buyer->city->Lookup->getParamTag("p_x_city") ?>
</span>
<?php echo $buyer->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_buyer_address" for="x_address" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->address->caption() ?><?php echo ($buyer->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->address->cellAttributes() ?>>
<span id="el_buyer_address">
<textarea data-table="buyer" data-field="x_address" name="x_address" id="x_address" cols="30" rows="4" placeholder="<?php echo HtmlEncode($buyer->address->getPlaceHolder()) ?>"<?php echo $buyer->address->editAttributes() ?>><?php echo $buyer->address->EditValue ?></textarea>
</span>
<?php echo $buyer->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_buyer_location" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->location->caption() ?><?php echo ($buyer->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->location->cellAttributes() ?>>
<span id="el_buyer_location">
<?php
$wrkonchange = "" . trim(@$buyer->location->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$buyer->location->EditAttrs["onchange"] = "";
?>
<span id="as_x_location" class="text-nowrap" style="z-index: 8840">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_location" id="sv_x_location" value="<?php echo RemoveHtml($buyer->location->EditValue) ?>" placeholder="<?php echo HtmlEncode($buyer->location->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($buyer->location->getPlaceHolder()) ?>"<?php echo $buyer->location->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($buyer->location->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_location',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($buyer->location->ReadOnly || $buyer->location->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="buyer" data-field="x_location" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $buyer->location->displayValueSeparatorAttribute() ?>" name="x_location" id="x_location" value="<?php echo HtmlEncode($buyer->location->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbuyeredit.createAutoSuggest({"id":"x_location","forceSelect":false});
</script>
<?php echo $buyer->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $buyer->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_buyer_reports_to" for="x_reports_to" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->reports_to->caption() ?><?php echo ($buyer->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->reports_to->cellAttributes() ?>>
<span id="el_buyer_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_reports_to" data-value-separator="<?php echo $buyer->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to[]" name="x_reports_to[]" multiple="multiple"<?php echo $buyer->reports_to->editAttributes() ?>>
		<?php echo $buyer->reports_to->selectOptionListHtml("x_reports_to[]") ?>
	</select>
</div>
<?php echo $buyer->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $buyer->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_buyer_status" for="x_status" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->status->caption() ?><?php echo ($buyer->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->status->cellAttributes() ?>>
<span id="el_buyer_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_status" data-value-separator="<?php echo $buyer->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $buyer->status->editAttributes() ?>>
		<?php echo $buyer->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $buyer->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->tax_registration->Visible) { // tax_registration ?>
	<div id="r_tax_registration" class="form-group row">
		<label id="elh_buyer_tax_registration" for="x_tax_registration" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->tax_registration->caption() ?><?php echo ($buyer->tax_registration->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->tax_registration->cellAttributes() ?>>
<span id="el_buyer_tax_registration">
<input type="text" data-table="buyer" data-field="x_tax_registration" name="x_tax_registration" id="x_tax_registration" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($buyer->tax_registration->getPlaceHolder()) ?>" value="<?php echo $buyer->tax_registration->EditValue ?>"<?php echo $buyer->tax_registration->editAttributes() ?>>
</span>
<?php echo $buyer->tax_registration->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_buyer_currency" for="x_currency" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->currency->caption() ?><?php echo ($buyer->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->currency->cellAttributes() ?>>
<span id="el_buyer_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_currency" data-value-separator="<?php echo $buyer->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $buyer->currency->editAttributes() ?>>
		<?php echo $buyer->currency->selectOptionListHtml("x_currency") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "currency") && !$buyer->currency->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_currency" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $buyer->currency->caption() ?>" data-title="<?php echo $buyer->currency->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_currency',url:'currencyaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $buyer->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $buyer->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->port_sea->Visible) { // port_sea ?>
	<div id="r_port_sea" class="form-group row">
		<label id="elh_buyer_port_sea" for="x_port_sea" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->port_sea->caption() ?><?php echo ($buyer->port_sea->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->port_sea->cellAttributes() ?>>
<span id="el_buyer_port_sea">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_port_sea" data-value-separator="<?php echo $buyer->port_sea->displayValueSeparatorAttribute() ?>" id="x_port_sea" name="x_port_sea"<?php echo $buyer->port_sea->editAttributes() ?>>
		<?php echo $buyer->port_sea->selectOptionListHtml("x_port_sea") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "port") && !$buyer->port_sea->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_port_sea" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $buyer->port_sea->caption() ?>" data-title="<?php echo $buyer->port_sea->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_port_sea',url:'portaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $buyer->port_sea->Lookup->getParamTag("p_x_port_sea") ?>
</span>
<?php echo $buyer->port_sea->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->incoterm->Visible) { // incoterm ?>
	<div id="r_incoterm" class="form-group row">
		<label id="elh_buyer_incoterm" for="x_incoterm" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->incoterm->caption() ?><?php echo ($buyer->incoterm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->incoterm->cellAttributes() ?>>
<span id="el_buyer_incoterm">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_incoterm" data-value-separator="<?php echo $buyer->incoterm->displayValueSeparatorAttribute() ?>" id="x_incoterm[]" name="x_incoterm[]" size=5 multiple="multiple"<?php echo $buyer->incoterm->editAttributes() ?>>
		<?php echo $buyer->incoterm->selectOptionListHtml("x_incoterm[]") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "incoterm") && !$buyer->incoterm->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_incoterm" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $buyer->incoterm->caption() ?>" data-title="<?php echo $buyer->incoterm->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_incoterm[]',url:'incotermaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $buyer->incoterm->Lookup->getParamTag("p_x_incoterm") ?>
</span>
<?php echo $buyer->incoterm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->port_air->Visible) { // port_air ?>
	<div id="r_port_air" class="form-group row">
		<label id="elh_buyer_port_air" for="x_port_air" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->port_air->caption() ?><?php echo ($buyer->port_air->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->port_air->cellAttributes() ?>>
<span id="el_buyer_port_air">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_port_air" data-value-separator="<?php echo $buyer->port_air->displayValueSeparatorAttribute() ?>" id="x_port_air" name="x_port_air"<?php echo $buyer->port_air->editAttributes() ?>>
		<?php echo $buyer->port_air->selectOptionListHtml("x_port_air") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "port") && !$buyer->port_air->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_port_air" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $buyer->port_air->caption() ?>" data-title="<?php echo $buyer->port_air->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_port_air',url:'portaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $buyer->port_air->Lookup->getParamTag("p_x_port_air") ?>
</span>
<?php echo $buyer->port_air->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->price_percent->Visible) { // price_percent ?>
	<div id="r_price_percent" class="form-group row">
		<label id="elh_buyer_price_percent" for="x_price_percent" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->price_percent->caption() ?><?php echo ($buyer->price_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->price_percent->cellAttributes() ?>>
<span id="el_buyer_price_percent">
<input type="text" data-table="buyer" data-field="x_price_percent" name="x_price_percent" id="x_price_percent" size="30" placeholder="<?php echo HtmlEncode($buyer->price_percent->getPlaceHolder()) ?>" value="<?php echo $buyer->price_percent->EditValue ?>"<?php echo $buyer->price_percent->editAttributes() ?>>
</span>
<?php echo $buyer->price_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($buyer->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_buyer_remarks" for="x_remarks" class="<?php echo $buyer_edit->LeftColumnClass ?>"><?php echo $buyer->remarks->caption() ?><?php echo ($buyer->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $buyer_edit->RightColumnClass ?>"><div<?php echo $buyer->remarks->cellAttributes() ?>>
<span id="el_buyer_remarks">
<input type="text" data-table="buyer" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($buyer->remarks->getPlaceHolder()) ?>" value="<?php echo $buyer->remarks->EditValue ?>"<?php echo $buyer->remarks->editAttributes() ?>>
</span>
<?php echo $buyer->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$buyer_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $buyer_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $buyer_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$buyer_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$buyer_edit->terminate();
?>