<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_list = new buyer_list();

// Run the page
$buyer_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$buyer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbuyerlist = currentForm = new ew.Form("fbuyerlist", "list");
fbuyerlist.formKeyCountName = '<?php echo $buyer_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbuyerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyerlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyerlist.lists["x_category"] = <?php echo $buyer_list->category->Lookup->toClientList() ?>;
fbuyerlist.lists["x_category"].options = <?php echo JsonEncode($buyer_list->category->lookupOptions()) ?>;
fbuyerlist.lists["x_sub_category"] = <?php echo $buyer_list->sub_category->Lookup->toClientList() ?>;
fbuyerlist.lists["x_sub_category"].options = <?php echo JsonEncode($buyer_list->sub_category->lookupOptions()) ?>;
fbuyerlist.lists["x_grp[]"] = <?php echo $buyer_list->grp->Lookup->toClientList() ?>;
fbuyerlist.lists["x_grp[]"].options = <?php echo JsonEncode($buyer_list->grp->lookupOptions()) ?>;
fbuyerlist.lists["x_seller"] = <?php echo $buyer_list->seller->Lookup->toClientList() ?>;
fbuyerlist.lists["x_seller"].options = <?php echo JsonEncode($buyer_list->seller->lookupOptions()) ?>;
fbuyerlist.lists["x_country"] = <?php echo $buyer_list->country->Lookup->toClientList() ?>;
fbuyerlist.lists["x_country"].options = <?php echo JsonEncode($buyer_list->country->lookupOptions()) ?>;
fbuyerlist.lists["x_region"] = <?php echo $buyer_list->region->Lookup->toClientList() ?>;
fbuyerlist.lists["x_region"].options = <?php echo JsonEncode($buyer_list->region->lookupOptions()) ?>;
fbuyerlist.lists["x_city"] = <?php echo $buyer_list->city->Lookup->toClientList() ?>;
fbuyerlist.lists["x_city"].options = <?php echo JsonEncode($buyer_list->city->lookupOptions()) ?>;
fbuyerlist.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyerlist.lists["x_reports_to[]"] = <?php echo $buyer_list->reports_to->Lookup->toClientList() ?>;
fbuyerlist.lists["x_reports_to[]"].options = <?php echo JsonEncode($buyer_list->reports_to->lookupOptions()) ?>;
fbuyerlist.lists["x_status"] = <?php echo $buyer_list->status->Lookup->toClientList() ?>;
fbuyerlist.lists["x_status"].options = <?php echo JsonEncode($buyer_list->status->options(FALSE, TRUE)) ?>;
fbuyerlist.lists["x_currency"] = <?php echo $buyer_list->currency->Lookup->toClientList() ?>;
fbuyerlist.lists["x_currency"].options = <?php echo JsonEncode($buyer_list->currency->lookupOptions()) ?>;
fbuyerlist.lists["x_port_sea"] = <?php echo $buyer_list->port_sea->Lookup->toClientList() ?>;
fbuyerlist.lists["x_port_sea"].options = <?php echo JsonEncode($buyer_list->port_sea->lookupOptions()) ?>;
fbuyerlist.lists["x_incoterm[]"] = <?php echo $buyer_list->incoterm->Lookup->toClientList() ?>;
fbuyerlist.lists["x_incoterm[]"].options = <?php echo JsonEncode($buyer_list->incoterm->lookupOptions()) ?>;
fbuyerlist.lists["x_port_air"] = <?php echo $buyer_list->port_air->Lookup->toClientList() ?>;
fbuyerlist.lists["x_port_air"].options = <?php echo JsonEncode($buyer_list->port_air->lookupOptions()) ?>;
fbuyerlist.lists["x_operator"] = <?php echo $buyer_list->operator->Lookup->toClientList() ?>;
fbuyerlist.lists["x_operator"].options = <?php echo JsonEncode($buyer_list->operator->lookupOptions()) ?>;

// Form object for search
var fbuyerlistsrch = currentSearchForm = new ew.Form("fbuyerlistsrch");

// Filters
fbuyerlistsrch.filterList = <?php echo $buyer_list->getFilterList() ?>;

// Init search panel as collapsed
fbuyerlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$buyer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($buyer_list->TotalRecs > 0 && $buyer_list->ExportOptions->visible()) { ?>
<?php $buyer_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_list->ImportOptions->visible()) { ?>
<?php $buyer_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_list->SearchOptions->visible()) { ?>
<?php $buyer_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($buyer_list->FilterOptions->visible()) { ?>
<?php $buyer_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$buyer_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$buyer->isExport() && !$buyer->CurrentAction) { ?>
<form name="fbuyerlistsrch" id="fbuyerlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($buyer_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fbuyerlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="buyer">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($buyer_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($buyer_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $buyer_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($buyer_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($buyer_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($buyer_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($buyer_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $buyer_list->showPageHeader(); ?>
<?php
$buyer_list->showMessage();
?>
<?php if ($buyer_list->TotalRecs > 0 || $buyer->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($buyer_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> buyer">
<?php if (!$buyer->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$buyer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_list->Pager)) $buyer_list->Pager = new PrevNextPager($buyer_list->StartRec, $buyer_list->DisplayRecs, $buyer_list->TotalRecs, $buyer_list->AutoHidePager) ?>
<?php if ($buyer_list->Pager->RecordCount > 0 && $buyer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_list->TotalRecs > 0 && (!$buyer_list->AutoHidePageSizeSelector || $buyer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbuyerlist" id="fbuyerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer">
<div id="gmp_buyer" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($buyer_list->TotalRecs > 0 || $buyer->isGridEdit()) { ?>
<table id="tbl_buyerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$buyer_list->RowType = ROWTYPE_HEADER;

// Render list options
$buyer_list->renderListOptions();

// Render list options (header, left)
$buyer_list->ListOptions->render("header", "left");
?>
<?php if ($buyer->id->Visible) { // id ?>
	<?php if ($buyer->sortUrl($buyer->id) == "") { ?>
		<th data-name="id" class="<?php echo $buyer->id->headerCellClass() ?>"><div id="elh_buyer_id" class="buyer_id"><div class="ew-table-header-caption"><?php echo $buyer->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $buyer->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->id) ?>',2);"><div id="elh_buyer_id" class="buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->user_name->Visible) { // user_name ?>
	<?php if ($buyer->sortUrl($buyer->user_name) == "") { ?>
		<th data-name="user_name" class="<?php echo $buyer->user_name->headerCellClass() ?>"><div id="elh_buyer_user_name" class="buyer_user_name"><div class="ew-table-header-caption"><?php echo $buyer->user_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_name" class="<?php echo $buyer->user_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->user_name) ?>',2);"><div id="elh_buyer_user_name" class="buyer_user_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->user_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->user_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->user_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->password->Visible) { // password ?>
	<?php if ($buyer->sortUrl($buyer->password) == "") { ?>
		<th data-name="password" class="<?php echo $buyer->password->headerCellClass() ?>"><div id="elh_buyer_password" class="buyer_password"><div class="ew-table-header-caption"><?php echo $buyer->password->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="password" class="<?php echo $buyer->password->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->password) ?>',2);"><div id="elh_buyer_password" class="buyer_password">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->password->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->password->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->password->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->category->Visible) { // category ?>
	<?php if ($buyer->sortUrl($buyer->category) == "") { ?>
		<th data-name="category" class="<?php echo $buyer->category->headerCellClass() ?>"><div id="elh_buyer_category" class="buyer_category"><div class="ew-table-header-caption"><?php echo $buyer->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $buyer->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->category) ?>',2);"><div id="elh_buyer_category" class="buyer_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->sub_category->Visible) { // sub_category ?>
	<?php if ($buyer->sortUrl($buyer->sub_category) == "") { ?>
		<th data-name="sub_category" class="<?php echo $buyer->sub_category->headerCellClass() ?>"><div id="elh_buyer_sub_category" class="buyer_sub_category"><div class="ew-table-header-caption"><?php echo $buyer->sub_category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sub_category" class="<?php echo $buyer->sub_category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->sub_category) ?>',2);"><div id="elh_buyer_sub_category" class="buyer_sub_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->sub_category->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->sub_category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->sub_category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->grp->Visible) { // grp ?>
	<?php if ($buyer->sortUrl($buyer->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $buyer->grp->headerCellClass() ?>"><div id="elh_buyer_grp" class="buyer_grp"><div class="ew-table-header-caption"><?php echo $buyer->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $buyer->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->grp) ?>',2);"><div id="elh_buyer_grp" class="buyer_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->name->Visible) { // name ?>
	<?php if ($buyer->sortUrl($buyer->name) == "") { ?>
		<th data-name="name" class="<?php echo $buyer->name->headerCellClass() ?>"><div id="elh_buyer_name" class="buyer_name"><div class="ew-table-header-caption"><?php echo $buyer->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $buyer->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->name) ?>',2);"><div id="elh_buyer_name" class="buyer_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->code->Visible) { // code ?>
	<?php if ($buyer->sortUrl($buyer->code) == "") { ?>
		<th data-name="code" class="<?php echo $buyer->code->headerCellClass() ?>"><div id="elh_buyer_code" class="buyer_code"><div class="ew-table-header-caption"><?php echo $buyer->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $buyer->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->code) ?>',2);"><div id="elh_buyer_code" class="buyer_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->seller->Visible) { // seller ?>
	<?php if ($buyer->sortUrl($buyer->seller) == "") { ?>
		<th data-name="seller" class="<?php echo $buyer->seller->headerCellClass() ?>"><div id="elh_buyer_seller" class="buyer_seller"><div class="ew-table-header-caption"><?php echo $buyer->seller->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="seller" class="<?php echo $buyer->seller->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->seller) ?>',2);"><div id="elh_buyer_seller" class="buyer_seller">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->seller->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->seller->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->seller->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->mobile->Visible) { // mobile ?>
	<?php if ($buyer->sortUrl($buyer->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $buyer->mobile->headerCellClass() ?>"><div id="elh_buyer_mobile" class="buyer_mobile"><div class="ew-table-header-caption"><?php echo $buyer->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $buyer->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->mobile) ?>',2);"><div id="elh_buyer_mobile" class="buyer_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->_email->Visible) { // email ?>
	<?php if ($buyer->sortUrl($buyer->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $buyer->_email->headerCellClass() ?>"><div id="elh_buyer__email" class="buyer__email"><div class="ew-table-header-caption"><?php echo $buyer->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $buyer->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->_email) ?>',2);"><div id="elh_buyer__email" class="buyer__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->country->Visible) { // country ?>
	<?php if ($buyer->sortUrl($buyer->country) == "") { ?>
		<th data-name="country" class="<?php echo $buyer->country->headerCellClass() ?>"><div id="elh_buyer_country" class="buyer_country"><div class="ew-table-header-caption"><?php echo $buyer->country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="country" class="<?php echo $buyer->country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->country) ?>',2);"><div id="elh_buyer_country" class="buyer_country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->country->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->region->Visible) { // region ?>
	<?php if ($buyer->sortUrl($buyer->region) == "") { ?>
		<th data-name="region" class="<?php echo $buyer->region->headerCellClass() ?>"><div id="elh_buyer_region" class="buyer_region"><div class="ew-table-header-caption"><?php echo $buyer->region->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="region" class="<?php echo $buyer->region->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->region) ?>',2);"><div id="elh_buyer_region" class="buyer_region">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->region->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->region->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->region->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->city->Visible) { // city ?>
	<?php if ($buyer->sortUrl($buyer->city) == "") { ?>
		<th data-name="city" class="<?php echo $buyer->city->headerCellClass() ?>"><div id="elh_buyer_city" class="buyer_city"><div class="ew-table-header-caption"><?php echo $buyer->city->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city" class="<?php echo $buyer->city->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->city) ?>',2);"><div id="elh_buyer_city" class="buyer_city">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->city->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->city->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->city->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->address->Visible) { // address ?>
	<?php if ($buyer->sortUrl($buyer->address) == "") { ?>
		<th data-name="address" class="<?php echo $buyer->address->headerCellClass() ?>"><div id="elh_buyer_address" class="buyer_address"><div class="ew-table-header-caption"><?php echo $buyer->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $buyer->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->address) ?>',2);"><div id="elh_buyer_address" class="buyer_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->reports_to->Visible) { // reports_to ?>
	<?php if ($buyer->sortUrl($buyer->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $buyer->reports_to->headerCellClass() ?>"><div id="elh_buyer_reports_to" class="buyer_reports_to"><div class="ew-table-header-caption"><?php echo $buyer->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $buyer->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->reports_to) ?>',2);"><div id="elh_buyer_reports_to" class="buyer_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->status->Visible) { // status ?>
	<?php if ($buyer->sortUrl($buyer->status) == "") { ?>
		<th data-name="status" class="<?php echo $buyer->status->headerCellClass() ?>"><div id="elh_buyer_status" class="buyer_status"><div class="ew-table-header-caption"><?php echo $buyer->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $buyer->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->status) ?>',2);"><div id="elh_buyer_status" class="buyer_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->tax_registration->Visible) { // tax_registration ?>
	<?php if ($buyer->sortUrl($buyer->tax_registration) == "") { ?>
		<th data-name="tax_registration" class="<?php echo $buyer->tax_registration->headerCellClass() ?>"><div id="elh_buyer_tax_registration" class="buyer_tax_registration"><div class="ew-table-header-caption"><?php echo $buyer->tax_registration->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tax_registration" class="<?php echo $buyer->tax_registration->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->tax_registration) ?>',2);"><div id="elh_buyer_tax_registration" class="buyer_tax_registration">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->tax_registration->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->tax_registration->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->tax_registration->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->currency->Visible) { // currency ?>
	<?php if ($buyer->sortUrl($buyer->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $buyer->currency->headerCellClass() ?>"><div id="elh_buyer_currency" class="buyer_currency"><div class="ew-table-header-caption"><?php echo $buyer->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $buyer->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->currency) ?>',2);"><div id="elh_buyer_currency" class="buyer_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->port_sea->Visible) { // port_sea ?>
	<?php if ($buyer->sortUrl($buyer->port_sea) == "") { ?>
		<th data-name="port_sea" class="<?php echo $buyer->port_sea->headerCellClass() ?>"><div id="elh_buyer_port_sea" class="buyer_port_sea"><div class="ew-table-header-caption"><?php echo $buyer->port_sea->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port_sea" class="<?php echo $buyer->port_sea->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->port_sea) ?>',2);"><div id="elh_buyer_port_sea" class="buyer_port_sea">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->port_sea->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->port_sea->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->port_sea->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->incoterm->Visible) { // incoterm ?>
	<?php if ($buyer->sortUrl($buyer->incoterm) == "") { ?>
		<th data-name="incoterm" class="<?php echo $buyer->incoterm->headerCellClass() ?>"><div id="elh_buyer_incoterm" class="buyer_incoterm"><div class="ew-table-header-caption"><?php echo $buyer->incoterm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="incoterm" class="<?php echo $buyer->incoterm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->incoterm) ?>',2);"><div id="elh_buyer_incoterm" class="buyer_incoterm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->incoterm->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->incoterm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->incoterm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->port_air->Visible) { // port_air ?>
	<?php if ($buyer->sortUrl($buyer->port_air) == "") { ?>
		<th data-name="port_air" class="<?php echo $buyer->port_air->headerCellClass() ?>"><div id="elh_buyer_port_air" class="buyer_port_air"><div class="ew-table-header-caption"><?php echo $buyer->port_air->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port_air" class="<?php echo $buyer->port_air->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->port_air) ?>',2);"><div id="elh_buyer_port_air" class="buyer_port_air">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->port_air->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->port_air->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->port_air->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->operator->Visible) { // operator ?>
	<?php if ($buyer->sortUrl($buyer->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $buyer->operator->headerCellClass() ?>"><div id="elh_buyer_operator" class="buyer_operator"><div class="ew-table-header-caption"><?php echo $buyer->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $buyer->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->operator) ?>',2);"><div id="elh_buyer_operator" class="buyer_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->datetime->Visible) { // datetime ?>
	<?php if ($buyer->sortUrl($buyer->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $buyer->datetime->headerCellClass() ?>"><div id="elh_buyer_datetime" class="buyer_datetime"><div class="ew-table-header-caption"><?php echo $buyer->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $buyer->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->datetime) ?>',2);"><div id="elh_buyer_datetime" class="buyer_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->performance->Visible) { // performance ?>
	<?php if ($buyer->sortUrl($buyer->performance) == "") { ?>
		<th data-name="performance" class="<?php echo $buyer->performance->headerCellClass() ?>"><div id="elh_buyer_performance" class="buyer_performance"><div class="ew-table-header-caption"><?php echo $buyer->performance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="performance" class="<?php echo $buyer->performance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->performance) ?>',2);"><div id="elh_buyer_performance" class="buyer_performance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->performance->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->performance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->performance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->price_percent->Visible) { // price_percent ?>
	<?php if ($buyer->sortUrl($buyer->price_percent) == "") { ?>
		<th data-name="price_percent" class="<?php echo $buyer->price_percent->headerCellClass() ?>"><div id="elh_buyer_price_percent" class="buyer_price_percent"><div class="ew-table-header-caption"><?php echo $buyer->price_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_percent" class="<?php echo $buyer->price_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->price_percent) ?>',2);"><div id="elh_buyer_price_percent" class="buyer_price_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->price_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($buyer->price_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->price_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($buyer->remarks->Visible) { // remarks ?>
	<?php if ($buyer->sortUrl($buyer->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $buyer->remarks->headerCellClass() ?>"><div id="elh_buyer_remarks" class="buyer_remarks"><div class="ew-table-header-caption"><?php echo $buyer->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $buyer->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $buyer->SortUrl($buyer->remarks) ?>',2);"><div id="elh_buyer_remarks" class="buyer_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $buyer->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($buyer->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($buyer->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$buyer_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($buyer->ExportAll && $buyer->isExport()) {
	$buyer_list->StopRec = $buyer_list->TotalRecs;
} else {

	// Set the last record to display
	if ($buyer_list->TotalRecs > $buyer_list->StartRec + $buyer_list->DisplayRecs - 1)
		$buyer_list->StopRec = $buyer_list->StartRec + $buyer_list->DisplayRecs - 1;
	else
		$buyer_list->StopRec = $buyer_list->TotalRecs;
}
$buyer_list->RecCnt = $buyer_list->StartRec - 1;
if ($buyer_list->Recordset && !$buyer_list->Recordset->EOF) {
	$buyer_list->Recordset->moveFirst();
	$selectLimit = $buyer_list->UseSelectLimit;
	if (!$selectLimit && $buyer_list->StartRec > 1)
		$buyer_list->Recordset->move($buyer_list->StartRec - 1);
} elseif (!$buyer->AllowAddDeleteRow && $buyer_list->StopRec == 0) {
	$buyer_list->StopRec = $buyer->GridAddRowCount;
}

// Initialize aggregate
$buyer->RowType = ROWTYPE_AGGREGATEINIT;
$buyer->resetAttributes();
$buyer_list->renderRow();
while ($buyer_list->RecCnt < $buyer_list->StopRec) {
	$buyer_list->RecCnt++;
	if ($buyer_list->RecCnt >= $buyer_list->StartRec) {
		$buyer_list->RowCnt++;

		// Set up key count
		$buyer_list->KeyCount = $buyer_list->RowIndex;

		// Init row class and style
		$buyer->resetAttributes();
		$buyer->CssClass = "";
		if ($buyer->isGridAdd()) {
		} else {
			$buyer_list->loadRowValues($buyer_list->Recordset); // Load row values
		}
		$buyer->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$buyer->RowAttrs = array_merge($buyer->RowAttrs, array('data-rowindex'=>$buyer_list->RowCnt, 'id'=>'r' . $buyer_list->RowCnt . '_buyer', 'data-rowtype'=>$buyer->RowType));

		// Render row
		$buyer_list->renderRow();

		// Render list options
		$buyer_list->renderListOptions();
?>
	<tr<?php echo $buyer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$buyer_list->ListOptions->render("body", "left", $buyer_list->RowCnt);
?>
	<?php if ($buyer->id->Visible) { // id ?>
		<td data-name="id"<?php echo $buyer->id->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_id" class="buyer_id">
<span<?php echo $buyer->id->viewAttributes() ?>>
<?php echo $buyer->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->user_name->Visible) { // user_name ?>
		<td data-name="user_name"<?php echo $buyer->user_name->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_user_name" class="buyer_user_name">
<span<?php echo $buyer->user_name->viewAttributes() ?>>
<?php echo $buyer->user_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->password->Visible) { // password ?>
		<td data-name="password"<?php echo $buyer->password->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_password" class="buyer_password">
<span<?php echo $buyer->password->viewAttributes() ?>>
<?php echo $buyer->password->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->category->Visible) { // category ?>
		<td data-name="category"<?php echo $buyer->category->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_category" class="buyer_category">
<span<?php echo $buyer->category->viewAttributes() ?>>
<?php echo $buyer->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->sub_category->Visible) { // sub_category ?>
		<td data-name="sub_category"<?php echo $buyer->sub_category->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_sub_category" class="buyer_sub_category">
<span<?php echo $buyer->sub_category->viewAttributes() ?>>
<?php echo $buyer->sub_category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $buyer->grp->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_grp" class="buyer_grp">
<span<?php echo $buyer->grp->viewAttributes() ?>>
<?php echo $buyer->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->name->Visible) { // name ?>
		<td data-name="name"<?php echo $buyer->name->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_name" class="buyer_name">
<span<?php echo $buyer->name->viewAttributes() ?>>
<?php echo $buyer->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->code->Visible) { // code ?>
		<td data-name="code"<?php echo $buyer->code->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_code" class="buyer_code">
<span<?php echo $buyer->code->viewAttributes() ?>>
<?php echo $buyer->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->seller->Visible) { // seller ?>
		<td data-name="seller"<?php echo $buyer->seller->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_seller" class="buyer_seller">
<span<?php echo $buyer->seller->viewAttributes() ?>>
<?php echo $buyer->seller->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $buyer->mobile->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_mobile" class="buyer_mobile">
<span<?php echo $buyer->mobile->viewAttributes() ?>>
<?php echo $buyer->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $buyer->_email->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer__email" class="buyer__email">
<span<?php echo $buyer->_email->viewAttributes() ?>>
<?php echo $buyer->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->country->Visible) { // country ?>
		<td data-name="country"<?php echo $buyer->country->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_country" class="buyer_country">
<span<?php echo $buyer->country->viewAttributes() ?>>
<?php echo $buyer->country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->region->Visible) { // region ?>
		<td data-name="region"<?php echo $buyer->region->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_region" class="buyer_region">
<span<?php echo $buyer->region->viewAttributes() ?>>
<?php echo $buyer->region->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->city->Visible) { // city ?>
		<td data-name="city"<?php echo $buyer->city->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_city" class="buyer_city">
<span<?php echo $buyer->city->viewAttributes() ?>>
<?php echo $buyer->city->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->address->Visible) { // address ?>
		<td data-name="address"<?php echo $buyer->address->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_address" class="buyer_address">
<span<?php echo $buyer->address->viewAttributes() ?>>
<?php echo $buyer->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $buyer->reports_to->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_reports_to" class="buyer_reports_to">
<span<?php echo $buyer->reports_to->viewAttributes() ?>>
<?php echo $buyer->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->status->Visible) { // status ?>
		<td data-name="status"<?php echo $buyer->status->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_status" class="buyer_status">
<span<?php echo $buyer->status->viewAttributes() ?>>
<?php echo $buyer->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->tax_registration->Visible) { // tax_registration ?>
		<td data-name="tax_registration"<?php echo $buyer->tax_registration->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_tax_registration" class="buyer_tax_registration">
<span<?php echo $buyer->tax_registration->viewAttributes() ?>>
<?php echo $buyer->tax_registration->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $buyer->currency->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_currency" class="buyer_currency">
<span<?php echo $buyer->currency->viewAttributes() ?>>
<?php echo $buyer->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->port_sea->Visible) { // port_sea ?>
		<td data-name="port_sea"<?php echo $buyer->port_sea->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_port_sea" class="buyer_port_sea">
<span<?php echo $buyer->port_sea->viewAttributes() ?>>
<?php echo $buyer->port_sea->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->incoterm->Visible) { // incoterm ?>
		<td data-name="incoterm"<?php echo $buyer->incoterm->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_incoterm" class="buyer_incoterm">
<span<?php echo $buyer->incoterm->viewAttributes() ?>>
<?php echo $buyer->incoterm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->port_air->Visible) { // port_air ?>
		<td data-name="port_air"<?php echo $buyer->port_air->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_port_air" class="buyer_port_air">
<span<?php echo $buyer->port_air->viewAttributes() ?>>
<?php echo $buyer->port_air->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $buyer->operator->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_operator" class="buyer_operator">
<span<?php echo $buyer->operator->viewAttributes() ?>>
<?php echo $buyer->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $buyer->datetime->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_datetime" class="buyer_datetime">
<span<?php echo $buyer->datetime->viewAttributes() ?>>
<?php echo $buyer->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->performance->Visible) { // performance ?>
		<td data-name="performance"<?php echo $buyer->performance->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_performance" class="buyer_performance">
<span<?php echo $buyer->performance->viewAttributes() ?>>
<?php echo $buyer->performance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->price_percent->Visible) { // price_percent ?>
		<td data-name="price_percent"<?php echo $buyer->price_percent->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_price_percent" class="buyer_price_percent">
<span<?php echo $buyer->price_percent->viewAttributes() ?>>
<?php echo $buyer->price_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($buyer->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $buyer->remarks->cellAttributes() ?>>
<span id="el<?php echo $buyer_list->RowCnt ?>_buyer_remarks" class="buyer_remarks">
<span<?php echo $buyer->remarks->viewAttributes() ?>>
<?php echo $buyer->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$buyer_list->ListOptions->render("body", "right", $buyer_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$buyer->isGridAdd())
		$buyer_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$buyer->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($buyer_list->Recordset)
	$buyer_list->Recordset->Close();
?>
<?php if (!$buyer->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$buyer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($buyer_list->Pager)) $buyer_list->Pager = new PrevNextPager($buyer_list->StartRec, $buyer_list->DisplayRecs, $buyer_list->TotalRecs, $buyer_list->AutoHidePager) ?>
<?php if ($buyer_list->Pager->RecordCount > 0 && $buyer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($buyer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($buyer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $buyer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($buyer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($buyer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $buyer_list->pageUrl() ?>start=<?php echo $buyer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $buyer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($buyer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $buyer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $buyer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $buyer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($buyer_list->TotalRecs > 0 && (!$buyer_list->AutoHidePageSizeSelector || $buyer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="buyer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($buyer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($buyer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($buyer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($buyer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($buyer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($buyer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $buyer_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($buyer_list->TotalRecs == 0 && !$buyer->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $buyer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$buyer_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$buyer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$buyer->isExport()) { ?>
<script>
ew.scrollableTable("gmp_buyer", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$buyer_list->terminate();
?>