<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_search = new buyer_search();

// Run the page
$buyer_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($buyer_search->IsModal) { ?>
var fbuyersearch = currentAdvancedSearchForm = new ew.Form("fbuyersearch", "search");
<?php } else { ?>
var fbuyersearch = currentForm = new ew.Form("fbuyersearch", "search");
<?php } ?>

// Form_CustomValidate event
fbuyersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyersearch.lists["x_category"] = <?php echo $buyer_search->category->Lookup->toClientList() ?>;
fbuyersearch.lists["x_category"].options = <?php echo JsonEncode($buyer_search->category->lookupOptions()) ?>;
fbuyersearch.lists["x_sub_category"] = <?php echo $buyer_search->sub_category->Lookup->toClientList() ?>;
fbuyersearch.lists["x_sub_category"].options = <?php echo JsonEncode($buyer_search->sub_category->lookupOptions()) ?>;
fbuyersearch.lists["x_grp[]"] = <?php echo $buyer_search->grp->Lookup->toClientList() ?>;
fbuyersearch.lists["x_grp[]"].options = <?php echo JsonEncode($buyer_search->grp->lookupOptions()) ?>;
fbuyersearch.lists["x_seller"] = <?php echo $buyer_search->seller->Lookup->toClientList() ?>;
fbuyersearch.lists["x_seller"].options = <?php echo JsonEncode($buyer_search->seller->lookupOptions()) ?>;
fbuyersearch.lists["x_country"] = <?php echo $buyer_search->country->Lookup->toClientList() ?>;
fbuyersearch.lists["x_country"].options = <?php echo JsonEncode($buyer_search->country->lookupOptions()) ?>;
fbuyersearch.lists["x_region"] = <?php echo $buyer_search->region->Lookup->toClientList() ?>;
fbuyersearch.lists["x_region"].options = <?php echo JsonEncode($buyer_search->region->lookupOptions()) ?>;
fbuyersearch.lists["x_city"] = <?php echo $buyer_search->city->Lookup->toClientList() ?>;
fbuyersearch.lists["x_city"].options = <?php echo JsonEncode($buyer_search->city->lookupOptions()) ?>;
fbuyersearch.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyersearch.lists["x_location"] = <?php echo $buyer_search->location->Lookup->toClientList() ?>;
fbuyersearch.lists["x_location"].options = <?php echo JsonEncode($buyer_search->location->lookupOptions()) ?>;
fbuyersearch.autoSuggests["x_location"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyersearch.lists["x_reports_to[]"] = <?php echo $buyer_search->reports_to->Lookup->toClientList() ?>;
fbuyersearch.lists["x_reports_to[]"].options = <?php echo JsonEncode($buyer_search->reports_to->lookupOptions()) ?>;
fbuyersearch.lists["x_status"] = <?php echo $buyer_search->status->Lookup->toClientList() ?>;
fbuyersearch.lists["x_status"].options = <?php echo JsonEncode($buyer_search->status->options(FALSE, TRUE)) ?>;
fbuyersearch.lists["x_currency"] = <?php echo $buyer_search->currency->Lookup->toClientList() ?>;
fbuyersearch.lists["x_currency"].options = <?php echo JsonEncode($buyer_search->currency->lookupOptions()) ?>;
fbuyersearch.lists["x_port_sea"] = <?php echo $buyer_search->port_sea->Lookup->toClientList() ?>;
fbuyersearch.lists["x_port_sea"].options = <?php echo JsonEncode($buyer_search->port_sea->lookupOptions()) ?>;
fbuyersearch.lists["x_incoterm[]"] = <?php echo $buyer_search->incoterm->Lookup->toClientList() ?>;
fbuyersearch.lists["x_incoterm[]"].options = <?php echo JsonEncode($buyer_search->incoterm->lookupOptions()) ?>;
fbuyersearch.lists["x_port_air"] = <?php echo $buyer_search->port_air->Lookup->toClientList() ?>;
fbuyersearch.lists["x_port_air"].options = <?php echo JsonEncode($buyer_search->port_air->lookupOptions()) ?>;
fbuyersearch.lists["x_operator"] = <?php echo $buyer_search->operator->Lookup->toClientList() ?>;
fbuyersearch.lists["x_operator"].options = <?php echo JsonEncode($buyer_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fbuyersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){1,6}$/))
		return this.onError(elm, "<?php echo JsEncode($buyer->code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_performance");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer->performance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($buyer->price_percent->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $buyer_search->showPageHeader(); ?>
<?php
$buyer_search->showMessage();
?>
<form name="fbuyersearch" id="fbuyersearch" class="<?php echo $buyer_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$buyer_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($buyer->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_id"><?php echo $buyer->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->id->cellAttributes() ?>>
			<span id="el_buyer_id">
<input type="text" data-table="buyer" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($buyer->id->getPlaceHolder()) ?>" value="<?php echo $buyer->id->EditValue ?>"<?php echo $buyer->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label for="x_user_name" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_user_name"><?php echo $buyer->user_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_user_name" id="z_user_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->user_name->cellAttributes() ?>>
			<span id="el_buyer_user_name">
<input type="text" data-table="buyer" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($buyer->user_name->getPlaceHolder()) ?>" value="<?php echo $buyer->user_name->EditValue ?>"<?php echo $buyer->user_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label for="x_password" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_password"><?php echo $buyer->password->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_password" id="z_password" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->password->cellAttributes() ?>>
			<span id="el_buyer_password">
<input type="text" data-table="buyer" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($buyer->password->getPlaceHolder()) ?>" value="<?php echo $buyer->password->EditValue ?>"<?php echo $buyer->password->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_category"><?php echo $buyer->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->category->cellAttributes() ?>>
			<span id="el_buyer_category">
<?php $buyer->category->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->category->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_category" data-value-separator="<?php echo $buyer->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $buyer->category->editAttributes() ?>>
		<?php echo $buyer->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $buyer->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->sub_category->Visible) { // sub_category ?>
	<div id="r_sub_category" class="form-group row">
		<label for="x_sub_category" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_sub_category"><?php echo $buyer->sub_category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sub_category" id="z_sub_category" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->sub_category->cellAttributes() ?>>
			<span id="el_buyer_sub_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_sub_category" data-value-separator="<?php echo $buyer->sub_category->displayValueSeparatorAttribute() ?>" id="x_sub_category" name="x_sub_category"<?php echo $buyer->sub_category->editAttributes() ?>>
		<?php echo $buyer->sub_category->selectOptionListHtml("x_sub_category") ?>
	</select>
</div>
<?php echo $buyer->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_grp"><?php echo $buyer->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->grp->cellAttributes() ?>>
			<span id="el_buyer_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="buyer" data-field="x_grp" data-value-separator="<?php echo $buyer->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $buyer->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $buyer->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $buyer->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_name"><?php echo $buyer->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->name->cellAttributes() ?>>
			<span id="el_buyer_name">
<input type="text" data-table="buyer" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($buyer->name->getPlaceHolder()) ?>" value="<?php echo $buyer->name->EditValue ?>"<?php echo $buyer->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_code"><?php echo $buyer->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->code->cellAttributes() ?>>
			<span id="el_buyer_code">
<input type="text" data-table="buyer" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($buyer->code->getPlaceHolder()) ?>" value="<?php echo $buyer->code->EditValue ?>"<?php echo $buyer->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->seller->Visible) { // seller ?>
	<div id="r_seller" class="form-group row">
		<label for="x_seller" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_seller"><?php echo $buyer->seller->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_seller" id="z_seller" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->seller->cellAttributes() ?>>
			<span id="el_buyer_seller">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_seller" data-value-separator="<?php echo $buyer->seller->displayValueSeparatorAttribute() ?>" id="x_seller" name="x_seller"<?php echo $buyer->seller->editAttributes() ?>>
		<?php echo $buyer->seller->selectOptionListHtml("x_seller") ?>
	</select>
</div>
<?php echo $buyer->seller->Lookup->getParamTag("p_x_seller") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_mobile"><?php echo $buyer->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->mobile->cellAttributes() ?>>
			<span id="el_buyer_mobile">
<input type="text" data-table="buyer" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($buyer->mobile->getPlaceHolder()) ?>" value="<?php echo $buyer->mobile->EditValue ?>"<?php echo $buyer->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer__email"><?php echo $buyer->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->_email->cellAttributes() ?>>
			<span id="el_buyer__email">
<input type="text" data-table="buyer" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($buyer->_email->getPlaceHolder()) ?>" value="<?php echo $buyer->_email->EditValue ?>"<?php echo $buyer->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label for="x_country" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_country"><?php echo $buyer->country->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_country" id="z_country" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->country->cellAttributes() ?>>
			<span id="el_buyer_country">
<?php $buyer->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_country" data-value-separator="<?php echo $buyer->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $buyer->country->editAttributes() ?>>
		<?php echo $buyer->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $buyer->country->Lookup->getParamTag("p_x_country") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->region->Visible) { // region ?>
	<div id="r_region" class="form-group row">
		<label for="x_region" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_region"><?php echo $buyer->region->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_region" id="z_region" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->region->cellAttributes() ?>>
			<span id="el_buyer_region">
<?php $buyer->region->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$buyer->region->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_region" data-value-separator="<?php echo $buyer->region->displayValueSeparatorAttribute() ?>" id="x_region" name="x_region"<?php echo $buyer->region->editAttributes() ?>>
		<?php echo $buyer->region->selectOptionListHtml("x_region") ?>
	</select>
</div>
<?php echo $buyer->region->Lookup->getParamTag("p_x_region") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_city"><?php echo $buyer->city->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_city" id="z_city" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->city->cellAttributes() ?>>
			<span id="el_buyer_city">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$buyer->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$buyer->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($buyer->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($buyer->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($buyer->city->getPlaceHolder()) ?>"<?php echo $buyer->city->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($buyer->city->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_city',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($buyer->city->ReadOnly || $buyer->city->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="buyer" data-field="x_city" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $buyer->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($buyer->city->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbuyersearch.createAutoSuggest({"id":"x_city","forceSelect":false});
</script>
<?php echo $buyer->city->Lookup->getParamTag("p_x_city") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_address"><?php echo $buyer->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->address->cellAttributes() ?>>
			<span id="el_buyer_address">
<input type="text" data-table="buyer" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($buyer->address->getPlaceHolder()) ?>" value="<?php echo $buyer->address->EditValue ?>"<?php echo $buyer->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_location"><?php echo $buyer->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_location" id="z_location" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->location->cellAttributes() ?>>
			<span id="el_buyer_location">
<?php
$wrkonchange = "" . trim(@$buyer->location->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$buyer->location->EditAttrs["onchange"] = "";
?>
<span id="as_x_location" class="text-nowrap" style="z-index: 8840">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_location" id="sv_x_location" value="<?php echo RemoveHtml($buyer->location->EditValue) ?>" placeholder="<?php echo HtmlEncode($buyer->location->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($buyer->location->getPlaceHolder()) ?>"<?php echo $buyer->location->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($buyer->location->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_location',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($buyer->location->ReadOnly || $buyer->location->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="buyer" data-field="x_location" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $buyer->location->displayValueSeparatorAttribute() ?>" name="x_location" id="x_location" value="<?php echo HtmlEncode($buyer->location->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fbuyersearch.createAutoSuggest({"id":"x_location","forceSelect":false});
</script>
<?php echo $buyer->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_reports_to"><?php echo $buyer->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->reports_to->cellAttributes() ?>>
			<span id="el_buyer_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_reports_to" data-value-separator="<?php echo $buyer->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to[]" name="x_reports_to[]" multiple="multiple"<?php echo $buyer->reports_to->editAttributes() ?>>
		<?php echo $buyer->reports_to->selectOptionListHtml("x_reports_to[]") ?>
	</select>
</div>
<?php echo $buyer->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_status"><?php echo $buyer->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->status->cellAttributes() ?>>
			<span id="el_buyer_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_status" data-value-separator="<?php echo $buyer->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $buyer->status->editAttributes() ?>>
		<?php echo $buyer->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->tax_registration->Visible) { // tax_registration ?>
	<div id="r_tax_registration" class="form-group row">
		<label for="x_tax_registration" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_tax_registration"><?php echo $buyer->tax_registration->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tax_registration" id="z_tax_registration" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->tax_registration->cellAttributes() ?>>
			<span id="el_buyer_tax_registration">
<input type="text" data-table="buyer" data-field="x_tax_registration" name="x_tax_registration" id="x_tax_registration" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($buyer->tax_registration->getPlaceHolder()) ?>" value="<?php echo $buyer->tax_registration->EditValue ?>"<?php echo $buyer->tax_registration->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_currency"><?php echo $buyer->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->currency->cellAttributes() ?>>
			<span id="el_buyer_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_currency" data-value-separator="<?php echo $buyer->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $buyer->currency->editAttributes() ?>>
		<?php echo $buyer->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $buyer->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->port_sea->Visible) { // port_sea ?>
	<div id="r_port_sea" class="form-group row">
		<label for="x_port_sea" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_port_sea"><?php echo $buyer->port_sea->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_port_sea" id="z_port_sea" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->port_sea->cellAttributes() ?>>
			<span id="el_buyer_port_sea">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_port_sea" data-value-separator="<?php echo $buyer->port_sea->displayValueSeparatorAttribute() ?>" id="x_port_sea" name="x_port_sea"<?php echo $buyer->port_sea->editAttributes() ?>>
		<?php echo $buyer->port_sea->selectOptionListHtml("x_port_sea") ?>
	</select>
</div>
<?php echo $buyer->port_sea->Lookup->getParamTag("p_x_port_sea") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->incoterm->Visible) { // incoterm ?>
	<div id="r_incoterm" class="form-group row">
		<label for="x_incoterm" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_incoterm"><?php echo $buyer->incoterm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_incoterm" id="z_incoterm" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->incoterm->cellAttributes() ?>>
			<span id="el_buyer_incoterm">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_incoterm" data-value-separator="<?php echo $buyer->incoterm->displayValueSeparatorAttribute() ?>" id="x_incoterm[]" name="x_incoterm[]" size=5 multiple="multiple"<?php echo $buyer->incoterm->editAttributes() ?>>
		<?php echo $buyer->incoterm->selectOptionListHtml("x_incoterm[]") ?>
	</select>
</div>
<?php echo $buyer->incoterm->Lookup->getParamTag("p_x_incoterm") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->port_air->Visible) { // port_air ?>
	<div id="r_port_air" class="form-group row">
		<label for="x_port_air" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_port_air"><?php echo $buyer->port_air->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_port_air" id="z_port_air" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->port_air->cellAttributes() ?>>
			<span id="el_buyer_port_air">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_port_air" data-value-separator="<?php echo $buyer->port_air->displayValueSeparatorAttribute() ?>" id="x_port_air" name="x_port_air"<?php echo $buyer->port_air->editAttributes() ?>>
		<?php echo $buyer->port_air->selectOptionListHtml("x_port_air") ?>
	</select>
</div>
<?php echo $buyer->port_air->Lookup->getParamTag("p_x_port_air") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_operator"><?php echo $buyer->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->operator->cellAttributes() ?>>
			<span id="el_buyer_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="buyer" data-field="x_operator" data-value-separator="<?php echo $buyer->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $buyer->operator->editAttributes() ?>>
		<?php echo $buyer->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $buyer->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_datetime"><?php echo $buyer->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->datetime->cellAttributes() ?>>
			<span id="el_buyer_datetime">
<input type="text" data-table="buyer" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($buyer->datetime->getPlaceHolder()) ?>" value="<?php echo $buyer->datetime->EditValue ?>"<?php echo $buyer->datetime->editAttributes() ?>>
<?php if (!$buyer->datetime->ReadOnly && !$buyer->datetime->Disabled && !isset($buyer->datetime->EditAttrs["readonly"]) && !isset($buyer->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fbuyersearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->performance->Visible) { // performance ?>
	<div id="r_performance" class="form-group row">
		<label for="x_performance" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_performance"><?php echo $buyer->performance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_performance" id="z_performance" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->performance->cellAttributes() ?>>
			<span id="el_buyer_performance">
<input type="text" data-table="buyer" data-field="x_performance" name="x_performance" id="x_performance" size="30" placeholder="<?php echo HtmlEncode($buyer->performance->getPlaceHolder()) ?>" value="<?php echo $buyer->performance->EditValue ?>"<?php echo $buyer->performance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->price_percent->Visible) { // price_percent ?>
	<div id="r_price_percent" class="form-group row">
		<label for="x_price_percent" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_price_percent"><?php echo $buyer->price_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price_percent" id="z_price_percent" value="="></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->price_percent->cellAttributes() ?>>
			<span id="el_buyer_price_percent">
<input type="text" data-table="buyer" data-field="x_price_percent" name="x_price_percent" id="x_price_percent" size="30" placeholder="<?php echo HtmlEncode($buyer->price_percent->getPlaceHolder()) ?>" value="<?php echo $buyer->price_percent->EditValue ?>"<?php echo $buyer->price_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($buyer->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $buyer_search->LeftColumnClass ?>"><span id="elh_buyer_remarks"><?php echo $buyer->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $buyer_search->RightColumnClass ?>"><div<?php echo $buyer->remarks->cellAttributes() ?>>
			<span id="el_buyer_remarks">
<input type="text" data-table="buyer" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($buyer->remarks->getPlaceHolder()) ?>" value="<?php echo $buyer->remarks->EditValue ?>"<?php echo $buyer->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$buyer_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $buyer_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$buyer_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$buyer_search->terminate();
?>