<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$buyer_view = new buyer_view();

// Run the page
$buyer_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$buyer_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$buyer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fbuyerview = currentForm = new ew.Form("fbuyerview", "view");

// Form_CustomValidate event
fbuyerview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbuyerview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbuyerview.lists["x_category"] = <?php echo $buyer_view->category->Lookup->toClientList() ?>;
fbuyerview.lists["x_category"].options = <?php echo JsonEncode($buyer_view->category->lookupOptions()) ?>;
fbuyerview.lists["x_sub_category"] = <?php echo $buyer_view->sub_category->Lookup->toClientList() ?>;
fbuyerview.lists["x_sub_category"].options = <?php echo JsonEncode($buyer_view->sub_category->lookupOptions()) ?>;
fbuyerview.lists["x_grp[]"] = <?php echo $buyer_view->grp->Lookup->toClientList() ?>;
fbuyerview.lists["x_grp[]"].options = <?php echo JsonEncode($buyer_view->grp->lookupOptions()) ?>;
fbuyerview.lists["x_seller"] = <?php echo $buyer_view->seller->Lookup->toClientList() ?>;
fbuyerview.lists["x_seller"].options = <?php echo JsonEncode($buyer_view->seller->lookupOptions()) ?>;
fbuyerview.lists["x_country"] = <?php echo $buyer_view->country->Lookup->toClientList() ?>;
fbuyerview.lists["x_country"].options = <?php echo JsonEncode($buyer_view->country->lookupOptions()) ?>;
fbuyerview.lists["x_region"] = <?php echo $buyer_view->region->Lookup->toClientList() ?>;
fbuyerview.lists["x_region"].options = <?php echo JsonEncode($buyer_view->region->lookupOptions()) ?>;
fbuyerview.lists["x_city"] = <?php echo $buyer_view->city->Lookup->toClientList() ?>;
fbuyerview.lists["x_city"].options = <?php echo JsonEncode($buyer_view->city->lookupOptions()) ?>;
fbuyerview.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyerview.lists["x_location"] = <?php echo $buyer_view->location->Lookup->toClientList() ?>;
fbuyerview.lists["x_location"].options = <?php echo JsonEncode($buyer_view->location->lookupOptions()) ?>;
fbuyerview.autoSuggests["x_location"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fbuyerview.lists["x_reports_to[]"] = <?php echo $buyer_view->reports_to->Lookup->toClientList() ?>;
fbuyerview.lists["x_reports_to[]"].options = <?php echo JsonEncode($buyer_view->reports_to->lookupOptions()) ?>;
fbuyerview.lists["x_status"] = <?php echo $buyer_view->status->Lookup->toClientList() ?>;
fbuyerview.lists["x_status"].options = <?php echo JsonEncode($buyer_view->status->options(FALSE, TRUE)) ?>;
fbuyerview.lists["x_currency"] = <?php echo $buyer_view->currency->Lookup->toClientList() ?>;
fbuyerview.lists["x_currency"].options = <?php echo JsonEncode($buyer_view->currency->lookupOptions()) ?>;
fbuyerview.lists["x_port_sea"] = <?php echo $buyer_view->port_sea->Lookup->toClientList() ?>;
fbuyerview.lists["x_port_sea"].options = <?php echo JsonEncode($buyer_view->port_sea->lookupOptions()) ?>;
fbuyerview.lists["x_incoterm[]"] = <?php echo $buyer_view->incoterm->Lookup->toClientList() ?>;
fbuyerview.lists["x_incoterm[]"].options = <?php echo JsonEncode($buyer_view->incoterm->lookupOptions()) ?>;
fbuyerview.lists["x_port_air"] = <?php echo $buyer_view->port_air->Lookup->toClientList() ?>;
fbuyerview.lists["x_port_air"].options = <?php echo JsonEncode($buyer_view->port_air->lookupOptions()) ?>;
fbuyerview.lists["x_operator"] = <?php echo $buyer_view->operator->Lookup->toClientList() ?>;
fbuyerview.lists["x_operator"].options = <?php echo JsonEncode($buyer_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$buyer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $buyer_view->ExportOptions->render("body") ?>
<?php $buyer_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $buyer_view->showPageHeader(); ?>
<?php
$buyer_view->showMessage();
?>
<form name="fbuyerview" id="fbuyerview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($buyer_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $buyer_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="buyer">
<input type="hidden" name="modal" value="<?php echo (int)$buyer_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($buyer->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_id"><?php echo $buyer->id->caption() ?></span></td>
		<td data-name="id"<?php echo $buyer->id->cellAttributes() ?>>
<span id="el_buyer_id">
<span<?php echo $buyer->id->viewAttributes() ?>>
<?php echo $buyer->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->user_name->Visible) { // user_name ?>
	<tr id="r_user_name">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_user_name"><?php echo $buyer->user_name->caption() ?></span></td>
		<td data-name="user_name"<?php echo $buyer->user_name->cellAttributes() ?>>
<span id="el_buyer_user_name">
<span<?php echo $buyer->user_name->viewAttributes() ?>>
<?php echo $buyer->user_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->password->Visible) { // password ?>
	<tr id="r_password">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_password"><?php echo $buyer->password->caption() ?></span></td>
		<td data-name="password"<?php echo $buyer->password->cellAttributes() ?>>
<span id="el_buyer_password">
<span<?php echo $buyer->password->viewAttributes() ?>>
<?php echo $buyer->password->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_category"><?php echo $buyer->category->caption() ?></span></td>
		<td data-name="category"<?php echo $buyer->category->cellAttributes() ?>>
<span id="el_buyer_category">
<span<?php echo $buyer->category->viewAttributes() ?>>
<?php echo $buyer->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->sub_category->Visible) { // sub_category ?>
	<tr id="r_sub_category">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_sub_category"><?php echo $buyer->sub_category->caption() ?></span></td>
		<td data-name="sub_category"<?php echo $buyer->sub_category->cellAttributes() ?>>
<span id="el_buyer_sub_category">
<span<?php echo $buyer->sub_category->viewAttributes() ?>>
<?php echo $buyer->sub_category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_grp"><?php echo $buyer->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $buyer->grp->cellAttributes() ?>>
<span id="el_buyer_grp">
<span<?php echo $buyer->grp->viewAttributes() ?>>
<?php echo $buyer->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_name"><?php echo $buyer->name->caption() ?></span></td>
		<td data-name="name"<?php echo $buyer->name->cellAttributes() ?>>
<span id="el_buyer_name">
<span<?php echo $buyer->name->viewAttributes() ?>>
<?php echo $buyer->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_code"><?php echo $buyer->code->caption() ?></span></td>
		<td data-name="code"<?php echo $buyer->code->cellAttributes() ?>>
<span id="el_buyer_code">
<span<?php echo $buyer->code->viewAttributes() ?>>
<?php echo $buyer->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->seller->Visible) { // seller ?>
	<tr id="r_seller">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_seller"><?php echo $buyer->seller->caption() ?></span></td>
		<td data-name="seller"<?php echo $buyer->seller->cellAttributes() ?>>
<span id="el_buyer_seller">
<span<?php echo $buyer->seller->viewAttributes() ?>>
<?php echo $buyer->seller->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_mobile"><?php echo $buyer->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $buyer->mobile->cellAttributes() ?>>
<span id="el_buyer_mobile">
<span<?php echo $buyer->mobile->viewAttributes() ?>>
<?php echo $buyer->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer__email"><?php echo $buyer->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $buyer->_email->cellAttributes() ?>>
<span id="el_buyer__email">
<span<?php echo $buyer->_email->viewAttributes() ?>>
<?php echo $buyer->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->country->Visible) { // country ?>
	<tr id="r_country">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_country"><?php echo $buyer->country->caption() ?></span></td>
		<td data-name="country"<?php echo $buyer->country->cellAttributes() ?>>
<span id="el_buyer_country">
<span<?php echo $buyer->country->viewAttributes() ?>>
<?php echo $buyer->country->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->region->Visible) { // region ?>
	<tr id="r_region">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_region"><?php echo $buyer->region->caption() ?></span></td>
		<td data-name="region"<?php echo $buyer->region->cellAttributes() ?>>
<span id="el_buyer_region">
<span<?php echo $buyer->region->viewAttributes() ?>>
<?php echo $buyer->region->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->city->Visible) { // city ?>
	<tr id="r_city">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_city"><?php echo $buyer->city->caption() ?></span></td>
		<td data-name="city"<?php echo $buyer->city->cellAttributes() ?>>
<span id="el_buyer_city">
<span<?php echo $buyer->city->viewAttributes() ?>>
<?php echo $buyer->city->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_address"><?php echo $buyer->address->caption() ?></span></td>
		<td data-name="address"<?php echo $buyer->address->cellAttributes() ?>>
<span id="el_buyer_address">
<span<?php echo $buyer->address->viewAttributes() ?>>
<?php echo $buyer->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_location"><?php echo $buyer->location->caption() ?></span></td>
		<td data-name="location"<?php echo $buyer->location->cellAttributes() ?>>
<span id="el_buyer_location">
<span<?php echo $buyer->location->viewAttributes() ?>>
<?php echo $buyer->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->reports_to->Visible) { // reports_to ?>
	<tr id="r_reports_to">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_reports_to"><?php echo $buyer->reports_to->caption() ?></span></td>
		<td data-name="reports_to"<?php echo $buyer->reports_to->cellAttributes() ?>>
<span id="el_buyer_reports_to">
<span<?php echo $buyer->reports_to->viewAttributes() ?>>
<?php echo $buyer->reports_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_status"><?php echo $buyer->status->caption() ?></span></td>
		<td data-name="status"<?php echo $buyer->status->cellAttributes() ?>>
<span id="el_buyer_status">
<span<?php echo $buyer->status->viewAttributes() ?>>
<?php echo $buyer->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->tax_registration->Visible) { // tax_registration ?>
	<tr id="r_tax_registration">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_tax_registration"><?php echo $buyer->tax_registration->caption() ?></span></td>
		<td data-name="tax_registration"<?php echo $buyer->tax_registration->cellAttributes() ?>>
<span id="el_buyer_tax_registration">
<span<?php echo $buyer->tax_registration->viewAttributes() ?>>
<?php echo $buyer->tax_registration->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->currency->Visible) { // currency ?>
	<tr id="r_currency">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_currency"><?php echo $buyer->currency->caption() ?></span></td>
		<td data-name="currency"<?php echo $buyer->currency->cellAttributes() ?>>
<span id="el_buyer_currency">
<span<?php echo $buyer->currency->viewAttributes() ?>>
<?php echo $buyer->currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->port_sea->Visible) { // port_sea ?>
	<tr id="r_port_sea">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_port_sea"><?php echo $buyer->port_sea->caption() ?></span></td>
		<td data-name="port_sea"<?php echo $buyer->port_sea->cellAttributes() ?>>
<span id="el_buyer_port_sea">
<span<?php echo $buyer->port_sea->viewAttributes() ?>>
<?php echo $buyer->port_sea->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->incoterm->Visible) { // incoterm ?>
	<tr id="r_incoterm">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_incoterm"><?php echo $buyer->incoterm->caption() ?></span></td>
		<td data-name="incoterm"<?php echo $buyer->incoterm->cellAttributes() ?>>
<span id="el_buyer_incoterm">
<span<?php echo $buyer->incoterm->viewAttributes() ?>>
<?php echo $buyer->incoterm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->port_air->Visible) { // port_air ?>
	<tr id="r_port_air">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_port_air"><?php echo $buyer->port_air->caption() ?></span></td>
		<td data-name="port_air"<?php echo $buyer->port_air->cellAttributes() ?>>
<span id="el_buyer_port_air">
<span<?php echo $buyer->port_air->viewAttributes() ?>>
<?php echo $buyer->port_air->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_operator"><?php echo $buyer->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $buyer->operator->cellAttributes() ?>>
<span id="el_buyer_operator">
<span<?php echo $buyer->operator->viewAttributes() ?>>
<?php echo $buyer->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_datetime"><?php echo $buyer->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $buyer->datetime->cellAttributes() ?>>
<span id="el_buyer_datetime">
<span<?php echo $buyer->datetime->viewAttributes() ?>>
<?php echo $buyer->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->performance->Visible) { // performance ?>
	<tr id="r_performance">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_performance"><?php echo $buyer->performance->caption() ?></span></td>
		<td data-name="performance"<?php echo $buyer->performance->cellAttributes() ?>>
<span id="el_buyer_performance">
<span<?php echo $buyer->performance->viewAttributes() ?>>
<?php echo $buyer->performance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->price_percent->Visible) { // price_percent ?>
	<tr id="r_price_percent">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_price_percent"><?php echo $buyer->price_percent->caption() ?></span></td>
		<td data-name="price_percent"<?php echo $buyer->price_percent->cellAttributes() ?>>
<span id="el_buyer_price_percent">
<span<?php echo $buyer->price_percent->viewAttributes() ?>>
<?php echo $buyer->price_percent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->last_login->Visible) { // last_login ?>
	<tr id="r_last_login">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_last_login"><?php echo $buyer->last_login->caption() ?></span></td>
		<td data-name="last_login"<?php echo $buyer->last_login->cellAttributes() ?>>
<span id="el_buyer_last_login">
<span<?php echo $buyer->last_login->viewAttributes() ?>>
<?php echo $buyer->last_login->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->reg_date->Visible) { // reg_date ?>
	<tr id="r_reg_date">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_reg_date"><?php echo $buyer->reg_date->caption() ?></span></td>
		<td data-name="reg_date"<?php echo $buyer->reg_date->cellAttributes() ?>>
<span id="el_buyer_reg_date">
<span<?php echo $buyer->reg_date->viewAttributes() ?>>
<?php echo $buyer->reg_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->reg_device->Visible) { // reg_device ?>
	<tr id="r_reg_device">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_reg_device"><?php echo $buyer->reg_device->caption() ?></span></td>
		<td data-name="reg_device"<?php echo $buyer->reg_device->cellAttributes() ?>>
<span id="el_buyer_reg_device">
<span<?php echo $buyer->reg_device->viewAttributes() ?>>
<?php echo $buyer->reg_device->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->device_id->Visible) { // device_id ?>
	<tr id="r_device_id">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_device_id"><?php echo $buyer->device_id->caption() ?></span></td>
		<td data-name="device_id"<?php echo $buyer->device_id->cellAttributes() ?>>
<span id="el_buyer_device_id">
<span<?php echo $buyer->device_id->viewAttributes() ?>>
<?php echo $buyer->device_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->device_token_id->Visible) { // device_token_id ?>
	<tr id="r_device_token_id">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_device_token_id"><?php echo $buyer->device_token_id->caption() ?></span></td>
		<td data-name="device_token_id"<?php echo $buyer->device_token_id->cellAttributes() ?>>
<span id="el_buyer_device_token_id">
<span<?php echo $buyer->device_token_id->viewAttributes() ?>>
<?php echo $buyer->device_token_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->cart_number->Visible) { // cart_number ?>
	<tr id="r_cart_number">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_cart_number"><?php echo $buyer->cart_number->caption() ?></span></td>
		<td data-name="cart_number"<?php echo $buyer->cart_number->cellAttributes() ?>>
<span id="el_buyer_cart_number">
<span<?php echo $buyer->cart_number->viewAttributes() ?>>
<?php echo $buyer->cart_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($buyer->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $buyer_view->TableLeftColumnClass ?>"><span id="elh_buyer_remarks"><?php echo $buyer->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $buyer->remarks->cellAttributes() ?>>
<span id="el_buyer_remarks">
<span<?php echo $buyer->remarks->viewAttributes() ?>>
<?php echo $buyer->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$buyer_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$buyer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$buyer_view->terminate();
?>