<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$c_charge_delete = new c_charge_delete();

// Run the page
$c_charge_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$c_charge_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fc_chargedelete = currentForm = new ew.Form("fc_chargedelete", "delete");

// Form_CustomValidate event
fc_chargedelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fc_chargedelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fc_chargedelete.lists["x_contractor_id"] = <?php echo $c_charge_delete->contractor_id->Lookup->toClientList() ?>;
fc_chargedelete.lists["x_contractor_id"].options = <?php echo JsonEncode($c_charge_delete->contractor_id->lookupOptions()) ?>;
fc_chargedelete.lists["x_grp"] = <?php echo $c_charge_delete->grp->Lookup->toClientList() ?>;
fc_chargedelete.lists["x_grp"].options = <?php echo JsonEncode($c_charge_delete->grp->lookupOptions()) ?>;
fc_chargedelete.lists["x_s_grp"] = <?php echo $c_charge_delete->s_grp->Lookup->toClientList() ?>;
fc_chargedelete.lists["x_s_grp"].options = <?php echo JsonEncode($c_charge_delete->s_grp->lookupOptions()) ?>;
fc_chargedelete.lists["x_process[]"] = <?php echo $c_charge_delete->process->Lookup->toClientList() ?>;
fc_chargedelete.lists["x_process[]"].options = <?php echo JsonEncode($c_charge_delete->process->lookupOptions()) ?>;
fc_chargedelete.lists["x_method"] = <?php echo $c_charge_delete->method->Lookup->toClientList() ?>;
fc_chargedelete.lists["x_method"].options = <?php echo JsonEncode($c_charge_delete->method->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $c_charge_delete->showPageHeader(); ?>
<?php
$c_charge_delete->showMessage();
?>
<form name="fc_chargedelete" id="fc_chargedelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($c_charge_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $c_charge_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="c_charge">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($c_charge_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($c_charge->id->Visible) { // id ?>
		<th class="<?php echo $c_charge->id->headerCellClass() ?>"><span id="elh_c_charge_id" class="c_charge_id"><?php echo $c_charge->id->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->contractor_id->Visible) { // contractor_id ?>
		<th class="<?php echo $c_charge->contractor_id->headerCellClass() ?>"><span id="elh_c_charge_contractor_id" class="c_charge_contractor_id"><?php echo $c_charge->contractor_id->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->grp->Visible) { // grp ?>
		<th class="<?php echo $c_charge->grp->headerCellClass() ?>"><span id="elh_c_charge_grp" class="c_charge_grp"><?php echo $c_charge->grp->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->s_grp->Visible) { // s_grp ?>
		<th class="<?php echo $c_charge->s_grp->headerCellClass() ?>"><span id="elh_c_charge_s_grp" class="c_charge_s_grp"><?php echo $c_charge->s_grp->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->process->Visible) { // process ?>
		<th class="<?php echo $c_charge->process->headerCellClass() ?>"><span id="elh_c_charge_process" class="c_charge_process"><?php echo $c_charge->process->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->method->Visible) { // method ?>
		<th class="<?php echo $c_charge->method->headerCellClass() ?>"><span id="elh_c_charge_method" class="c_charge_method"><?php echo $c_charge->method->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->from_date->Visible) { // from_date ?>
		<th class="<?php echo $c_charge->from_date->headerCellClass() ?>"><span id="elh_c_charge_from_date" class="c_charge_from_date"><?php echo $c_charge->from_date->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->to_date->Visible) { // to_date ?>
		<th class="<?php echo $c_charge->to_date->headerCellClass() ?>"><span id="elh_c_charge_to_date" class="c_charge_to_date"><?php echo $c_charge->to_date->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->_40->Visible) { // @ ?>
		<th class="<?php echo $c_charge->_40->headerCellClass() ?>"><span id="elh_c_charge__40" class="c_charge__40"><?php echo $c_charge->_40->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->operator->Visible) { // operator ?>
		<th class="<?php echo $c_charge->operator->headerCellClass() ?>"><span id="elh_c_charge_operator" class="c_charge_operator"><?php echo $c_charge->operator->caption() ?></span></th>
<?php } ?>
<?php if ($c_charge->datetime->Visible) { // datetime ?>
		<th class="<?php echo $c_charge->datetime->headerCellClass() ?>"><span id="elh_c_charge_datetime" class="c_charge_datetime"><?php echo $c_charge->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$c_charge_delete->RecCnt = 0;
$i = 0;
while (!$c_charge_delete->Recordset->EOF) {
	$c_charge_delete->RecCnt++;
	$c_charge_delete->RowCnt++;

	// Set row properties
	$c_charge->resetAttributes();
	$c_charge->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$c_charge_delete->loadRowValues($c_charge_delete->Recordset);

	// Render row
	$c_charge_delete->renderRow();
?>
	<tr<?php echo $c_charge->rowAttributes() ?>>
<?php if ($c_charge->id->Visible) { // id ?>
		<td<?php echo $c_charge->id->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_id" class="c_charge_id">
<span<?php echo $c_charge->id->viewAttributes() ?>>
<?php echo $c_charge->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->contractor_id->Visible) { // contractor_id ?>
		<td<?php echo $c_charge->contractor_id->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_contractor_id" class="c_charge_contractor_id">
<span<?php echo $c_charge->contractor_id->viewAttributes() ?>>
<?php echo $c_charge->contractor_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->grp->Visible) { // grp ?>
		<td<?php echo $c_charge->grp->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_grp" class="c_charge_grp">
<span<?php echo $c_charge->grp->viewAttributes() ?>>
<?php echo $c_charge->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->s_grp->Visible) { // s_grp ?>
		<td<?php echo $c_charge->s_grp->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_s_grp" class="c_charge_s_grp">
<span<?php echo $c_charge->s_grp->viewAttributes() ?>>
<?php echo $c_charge->s_grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->process->Visible) { // process ?>
		<td<?php echo $c_charge->process->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_process" class="c_charge_process">
<span<?php echo $c_charge->process->viewAttributes() ?>>
<?php echo $c_charge->process->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->method->Visible) { // method ?>
		<td<?php echo $c_charge->method->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_method" class="c_charge_method">
<span<?php echo $c_charge->method->viewAttributes() ?>>
<?php echo $c_charge->method->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->from_date->Visible) { // from_date ?>
		<td<?php echo $c_charge->from_date->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_from_date" class="c_charge_from_date">
<span<?php echo $c_charge->from_date->viewAttributes() ?>>
<?php echo $c_charge->from_date->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->to_date->Visible) { // to_date ?>
		<td<?php echo $c_charge->to_date->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_to_date" class="c_charge_to_date">
<span<?php echo $c_charge->to_date->viewAttributes() ?>>
<?php echo $c_charge->to_date->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->_40->Visible) { // @ ?>
		<td<?php echo $c_charge->_40->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge__40" class="c_charge__40">
<span<?php echo $c_charge->_40->viewAttributes() ?>>
<?php echo $c_charge->_40->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->operator->Visible) { // operator ?>
		<td<?php echo $c_charge->operator->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_operator" class="c_charge_operator">
<span<?php echo $c_charge->operator->viewAttributes() ?>>
<?php echo $c_charge->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($c_charge->datetime->Visible) { // datetime ?>
		<td<?php echo $c_charge->datetime->cellAttributes() ?>>
<span id="el<?php echo $c_charge_delete->RowCnt ?>_c_charge_datetime" class="c_charge_datetime">
<span<?php echo $c_charge->datetime->viewAttributes() ?>>
<?php echo $c_charge->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$c_charge_delete->Recordset->moveNext();
}
$c_charge_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $c_charge_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$c_charge_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$c_charge_delete->terminate();
?>