<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$c_charge_list = new c_charge_list();

// Run the page
$c_charge_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$c_charge_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$c_charge->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fc_chargelist = currentForm = new ew.Form("fc_chargelist", "list");
fc_chargelist.formKeyCountName = '<?php echo $c_charge_list->FormKeyCountName ?>';

// Form_CustomValidate event
fc_chargelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fc_chargelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fc_chargelist.lists["x_contractor_id"] = <?php echo $c_charge_list->contractor_id->Lookup->toClientList() ?>;
fc_chargelist.lists["x_contractor_id"].options = <?php echo JsonEncode($c_charge_list->contractor_id->lookupOptions()) ?>;
fc_chargelist.lists["x_grp"] = <?php echo $c_charge_list->grp->Lookup->toClientList() ?>;
fc_chargelist.lists["x_grp"].options = <?php echo JsonEncode($c_charge_list->grp->lookupOptions()) ?>;
fc_chargelist.lists["x_s_grp"] = <?php echo $c_charge_list->s_grp->Lookup->toClientList() ?>;
fc_chargelist.lists["x_s_grp"].options = <?php echo JsonEncode($c_charge_list->s_grp->lookupOptions()) ?>;
fc_chargelist.lists["x_process[]"] = <?php echo $c_charge_list->process->Lookup->toClientList() ?>;
fc_chargelist.lists["x_process[]"].options = <?php echo JsonEncode($c_charge_list->process->lookupOptions()) ?>;
fc_chargelist.lists["x_method"] = <?php echo $c_charge_list->method->Lookup->toClientList() ?>;
fc_chargelist.lists["x_method"].options = <?php echo JsonEncode($c_charge_list->method->options(FALSE, TRUE)) ?>;

// Form object for search
var fc_chargelistsrch = currentSearchForm = new ew.Form("fc_chargelistsrch");

// Validate function for search
fc_chargelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fc_chargelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fc_chargelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fc_chargelistsrch.lists["x_contractor_id"] = <?php echo $c_charge_list->contractor_id->Lookup->toClientList() ?>;
fc_chargelistsrch.lists["x_contractor_id"].options = <?php echo JsonEncode($c_charge_list->contractor_id->lookupOptions()) ?>;
fc_chargelistsrch.lists["x_process[]"] = <?php echo $c_charge_list->process->Lookup->toClientList() ?>;
fc_chargelistsrch.lists["x_process[]"].options = <?php echo JsonEncode($c_charge_list->process->lookupOptions()) ?>;

// Filters
fc_chargelistsrch.filterList = <?php echo $c_charge_list->getFilterList() ?>;

// Init search panel as collapsed
fc_chargelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$c_charge->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($c_charge_list->TotalRecs > 0 && $c_charge_list->ExportOptions->visible()) { ?>
<?php $c_charge_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($c_charge_list->ImportOptions->visible()) { ?>
<?php $c_charge_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($c_charge_list->SearchOptions->visible()) { ?>
<?php $c_charge_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($c_charge_list->FilterOptions->visible()) { ?>
<?php $c_charge_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$c_charge_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$c_charge->isExport() && !$c_charge->CurrentAction) { ?>
<form name="fc_chargelistsrch" id="fc_chargelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($c_charge_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fc_chargelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="c_charge">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$c_charge_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$c_charge->RowType = ROWTYPE_SEARCH;

// Render row
$c_charge->resetAttributes();
$c_charge_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($c_charge->contractor_id->Visible) { // contractor_id ?>
	<div id="xsc_contractor_id" class="ew-cell form-group">
		<label for="x_contractor_id" class="ew-search-caption ew-label"><?php echo $c_charge->contractor_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_contractor_id" id="z_contractor_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="c_charge" data-field="x_contractor_id" data-value-separator="<?php echo $c_charge->contractor_id->displayValueSeparatorAttribute() ?>" id="x_contractor_id" name="x_contractor_id"<?php echo $c_charge->contractor_id->editAttributes() ?>>
		<?php echo $c_charge->contractor_id->selectOptionListHtml("x_contractor_id") ?>
	</select>
</div>
<?php echo $c_charge->contractor_id->Lookup->getParamTag("p_x_contractor_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($c_charge->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $c_charge->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		<span class="ew-search-field">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="c_charge" data-field="x_process" data-value-separator="<?php echo $c_charge->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $c_charge->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $c_charge->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $c_charge->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($c_charge_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($c_charge_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $c_charge_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($c_charge_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($c_charge_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($c_charge_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($c_charge_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $c_charge_list->showPageHeader(); ?>
<?php
$c_charge_list->showMessage();
?>
<?php if ($c_charge_list->TotalRecs > 0 || $c_charge->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($c_charge_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> c_charge">
<?php if (!$c_charge->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$c_charge->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($c_charge_list->Pager)) $c_charge_list->Pager = new PrevNextPager($c_charge_list->StartRec, $c_charge_list->DisplayRecs, $c_charge_list->TotalRecs, $c_charge_list->AutoHidePager) ?>
<?php if ($c_charge_list->Pager->RecordCount > 0 && $c_charge_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($c_charge_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($c_charge_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $c_charge_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($c_charge_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($c_charge_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $c_charge_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($c_charge_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $c_charge_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $c_charge_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $c_charge_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($c_charge_list->TotalRecs > 0 && (!$c_charge_list->AutoHidePageSizeSelector || $c_charge_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="c_charge">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($c_charge_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($c_charge_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($c_charge_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($c_charge_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($c_charge_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($c_charge->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $c_charge_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fc_chargelist" id="fc_chargelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($c_charge_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $c_charge_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="c_charge">
<div id="gmp_c_charge" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($c_charge_list->TotalRecs > 0 || $c_charge->isGridEdit()) { ?>
<table id="tbl_c_chargelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$c_charge_list->RowType = ROWTYPE_HEADER;

// Render list options
$c_charge_list->renderListOptions();

// Render list options (header, left)
$c_charge_list->ListOptions->render("header", "left");
?>
<?php if ($c_charge->id->Visible) { // id ?>
	<?php if ($c_charge->sortUrl($c_charge->id) == "") { ?>
		<th data-name="id" class="<?php echo $c_charge->id->headerCellClass() ?>"><div id="elh_c_charge_id" class="c_charge_id"><div class="ew-table-header-caption"><?php echo $c_charge->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $c_charge->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->id) ?>',2);"><div id="elh_c_charge_id" class="c_charge_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->contractor_id->Visible) { // contractor_id ?>
	<?php if ($c_charge->sortUrl($c_charge->contractor_id) == "") { ?>
		<th data-name="contractor_id" class="<?php echo $c_charge->contractor_id->headerCellClass() ?>"><div id="elh_c_charge_contractor_id" class="c_charge_contractor_id"><div class="ew-table-header-caption"><?php echo $c_charge->contractor_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="contractor_id" class="<?php echo $c_charge->contractor_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->contractor_id) ?>',2);"><div id="elh_c_charge_contractor_id" class="c_charge_contractor_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->contractor_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->contractor_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->contractor_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->grp->Visible) { // grp ?>
	<?php if ($c_charge->sortUrl($c_charge->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $c_charge->grp->headerCellClass() ?>"><div id="elh_c_charge_grp" class="c_charge_grp"><div class="ew-table-header-caption"><?php echo $c_charge->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $c_charge->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->grp) ?>',2);"><div id="elh_c_charge_grp" class="c_charge_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->s_grp->Visible) { // s_grp ?>
	<?php if ($c_charge->sortUrl($c_charge->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $c_charge->s_grp->headerCellClass() ?>"><div id="elh_c_charge_s_grp" class="c_charge_s_grp"><div class="ew-table-header-caption"><?php echo $c_charge->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $c_charge->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->s_grp) ?>',2);"><div id="elh_c_charge_s_grp" class="c_charge_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->process->Visible) { // process ?>
	<?php if ($c_charge->sortUrl($c_charge->process) == "") { ?>
		<th data-name="process" class="<?php echo $c_charge->process->headerCellClass() ?>"><div id="elh_c_charge_process" class="c_charge_process"><div class="ew-table-header-caption"><?php echo $c_charge->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $c_charge->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->process) ?>',2);"><div id="elh_c_charge_process" class="c_charge_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->method->Visible) { // method ?>
	<?php if ($c_charge->sortUrl($c_charge->method) == "") { ?>
		<th data-name="method" class="<?php echo $c_charge->method->headerCellClass() ?>"><div id="elh_c_charge_method" class="c_charge_method"><div class="ew-table-header-caption"><?php echo $c_charge->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $c_charge->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->method) ?>',2);"><div id="elh_c_charge_method" class="c_charge_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->from_date->Visible) { // from_date ?>
	<?php if ($c_charge->sortUrl($c_charge->from_date) == "") { ?>
		<th data-name="from_date" class="<?php echo $c_charge->from_date->headerCellClass() ?>"><div id="elh_c_charge_from_date" class="c_charge_from_date"><div class="ew-table-header-caption"><?php echo $c_charge->from_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_date" class="<?php echo $c_charge->from_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->from_date) ?>',2);"><div id="elh_c_charge_from_date" class="c_charge_from_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->from_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->from_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->from_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->to_date->Visible) { // to_date ?>
	<?php if ($c_charge->sortUrl($c_charge->to_date) == "") { ?>
		<th data-name="to_date" class="<?php echo $c_charge->to_date->headerCellClass() ?>"><div id="elh_c_charge_to_date" class="c_charge_to_date"><div class="ew-table-header-caption"><?php echo $c_charge->to_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_date" class="<?php echo $c_charge->to_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->to_date) ?>',2);"><div id="elh_c_charge_to_date" class="c_charge_to_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->to_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->to_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->to_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->_40->Visible) { // @ ?>
	<?php if ($c_charge->sortUrl($c_charge->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $c_charge->_40->headerCellClass() ?>"><div id="elh_c_charge__40" class="c_charge__40"><div class="ew-table-header-caption"><?php echo $c_charge->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $c_charge->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->_40) ?>',2);"><div id="elh_c_charge__40" class="c_charge__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->operator->Visible) { // operator ?>
	<?php if ($c_charge->sortUrl($c_charge->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $c_charge->operator->headerCellClass() ?>"><div id="elh_c_charge_operator" class="c_charge_operator"><div class="ew-table-header-caption"><?php echo $c_charge->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $c_charge->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->operator) ?>',2);"><div id="elh_c_charge_operator" class="c_charge_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($c_charge->datetime->Visible) { // datetime ?>
	<?php if ($c_charge->sortUrl($c_charge->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $c_charge->datetime->headerCellClass() ?>"><div id="elh_c_charge_datetime" class="c_charge_datetime"><div class="ew-table-header-caption"><?php echo $c_charge->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $c_charge->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $c_charge->SortUrl($c_charge->datetime) ?>',2);"><div id="elh_c_charge_datetime" class="c_charge_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $c_charge->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($c_charge->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($c_charge->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$c_charge_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($c_charge->ExportAll && $c_charge->isExport()) {
	$c_charge_list->StopRec = $c_charge_list->TotalRecs;
} else {

	// Set the last record to display
	if ($c_charge_list->TotalRecs > $c_charge_list->StartRec + $c_charge_list->DisplayRecs - 1)
		$c_charge_list->StopRec = $c_charge_list->StartRec + $c_charge_list->DisplayRecs - 1;
	else
		$c_charge_list->StopRec = $c_charge_list->TotalRecs;
}
$c_charge_list->RecCnt = $c_charge_list->StartRec - 1;
if ($c_charge_list->Recordset && !$c_charge_list->Recordset->EOF) {
	$c_charge_list->Recordset->moveFirst();
	$selectLimit = $c_charge_list->UseSelectLimit;
	if (!$selectLimit && $c_charge_list->StartRec > 1)
		$c_charge_list->Recordset->move($c_charge_list->StartRec - 1);
} elseif (!$c_charge->AllowAddDeleteRow && $c_charge_list->StopRec == 0) {
	$c_charge_list->StopRec = $c_charge->GridAddRowCount;
}

// Initialize aggregate
$c_charge->RowType = ROWTYPE_AGGREGATEINIT;
$c_charge->resetAttributes();
$c_charge_list->renderRow();
while ($c_charge_list->RecCnt < $c_charge_list->StopRec) {
	$c_charge_list->RecCnt++;
	if ($c_charge_list->RecCnt >= $c_charge_list->StartRec) {
		$c_charge_list->RowCnt++;

		// Set up key count
		$c_charge_list->KeyCount = $c_charge_list->RowIndex;

		// Init row class and style
		$c_charge->resetAttributes();
		$c_charge->CssClass = "";
		if ($c_charge->isGridAdd()) {
		} else {
			$c_charge_list->loadRowValues($c_charge_list->Recordset); // Load row values
		}
		$c_charge->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$c_charge->RowAttrs = array_merge($c_charge->RowAttrs, array('data-rowindex'=>$c_charge_list->RowCnt, 'id'=>'r' . $c_charge_list->RowCnt . '_c_charge', 'data-rowtype'=>$c_charge->RowType));

		// Render row
		$c_charge_list->renderRow();

		// Render list options
		$c_charge_list->renderListOptions();
?>
	<tr<?php echo $c_charge->rowAttributes() ?>>
<?php

// Render list options (body, left)
$c_charge_list->ListOptions->render("body", "left", $c_charge_list->RowCnt);
?>
	<?php if ($c_charge->id->Visible) { // id ?>
		<td data-name="id"<?php echo $c_charge->id->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_id" class="c_charge_id">
<span<?php echo $c_charge->id->viewAttributes() ?>>
<?php echo $c_charge->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->contractor_id->Visible) { // contractor_id ?>
		<td data-name="contractor_id"<?php echo $c_charge->contractor_id->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_contractor_id" class="c_charge_contractor_id">
<span<?php echo $c_charge->contractor_id->viewAttributes() ?>>
<?php echo $c_charge->contractor_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $c_charge->grp->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_grp" class="c_charge_grp">
<span<?php echo $c_charge->grp->viewAttributes() ?>>
<?php echo $c_charge->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $c_charge->s_grp->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_s_grp" class="c_charge_s_grp">
<span<?php echo $c_charge->s_grp->viewAttributes() ?>>
<?php echo $c_charge->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->process->Visible) { // process ?>
		<td data-name="process"<?php echo $c_charge->process->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_process" class="c_charge_process">
<span<?php echo $c_charge->process->viewAttributes() ?>>
<?php echo $c_charge->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->method->Visible) { // method ?>
		<td data-name="method"<?php echo $c_charge->method->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_method" class="c_charge_method">
<span<?php echo $c_charge->method->viewAttributes() ?>>
<?php echo $c_charge->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->from_date->Visible) { // from_date ?>
		<td data-name="from_date"<?php echo $c_charge->from_date->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_from_date" class="c_charge_from_date">
<span<?php echo $c_charge->from_date->viewAttributes() ?>>
<?php echo $c_charge->from_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->to_date->Visible) { // to_date ?>
		<td data-name="to_date"<?php echo $c_charge->to_date->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_to_date" class="c_charge_to_date">
<span<?php echo $c_charge->to_date->viewAttributes() ?>>
<?php echo $c_charge->to_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $c_charge->_40->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge__40" class="c_charge__40">
<span<?php echo $c_charge->_40->viewAttributes() ?>>
<?php echo $c_charge->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $c_charge->operator->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_operator" class="c_charge_operator">
<span<?php echo $c_charge->operator->viewAttributes() ?>>
<?php echo $c_charge->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($c_charge->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $c_charge->datetime->cellAttributes() ?>>
<span id="el<?php echo $c_charge_list->RowCnt ?>_c_charge_datetime" class="c_charge_datetime">
<span<?php echo $c_charge->datetime->viewAttributes() ?>>
<?php echo $c_charge->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$c_charge_list->ListOptions->render("body", "right", $c_charge_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$c_charge->isGridAdd())
		$c_charge_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$c_charge->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($c_charge_list->Recordset)
	$c_charge_list->Recordset->Close();
?>
<?php if (!$c_charge->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$c_charge->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($c_charge_list->Pager)) $c_charge_list->Pager = new PrevNextPager($c_charge_list->StartRec, $c_charge_list->DisplayRecs, $c_charge_list->TotalRecs, $c_charge_list->AutoHidePager) ?>
<?php if ($c_charge_list->Pager->RecordCount > 0 && $c_charge_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($c_charge_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($c_charge_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $c_charge_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($c_charge_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($c_charge_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $c_charge_list->pageUrl() ?>start=<?php echo $c_charge_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $c_charge_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($c_charge_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $c_charge_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $c_charge_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $c_charge_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($c_charge_list->TotalRecs > 0 && (!$c_charge_list->AutoHidePageSizeSelector || $c_charge_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="c_charge">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($c_charge_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($c_charge_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($c_charge_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($c_charge_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($c_charge_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($c_charge->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $c_charge_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($c_charge_list->TotalRecs == 0 && !$c_charge->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $c_charge_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$c_charge_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$c_charge->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$c_charge->isExport()) { ?>
<script>
ew.scrollableTable("gmp_c_charge", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$c_charge_list->terminate();
?>