<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$c_charge_search = new c_charge_search();

// Run the page
$c_charge_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$c_charge_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($c_charge_search->IsModal) { ?>
var fc_chargesearch = currentAdvancedSearchForm = new ew.Form("fc_chargesearch", "search");
<?php } else { ?>
var fc_chargesearch = currentForm = new ew.Form("fc_chargesearch", "search");
<?php } ?>

// Form_CustomValidate event
fc_chargesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fc_chargesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fc_chargesearch.lists["x_contractor_id"] = <?php echo $c_charge_search->contractor_id->Lookup->toClientList() ?>;
fc_chargesearch.lists["x_contractor_id"].options = <?php echo JsonEncode($c_charge_search->contractor_id->lookupOptions()) ?>;
fc_chargesearch.lists["x_grp"] = <?php echo $c_charge_search->grp->Lookup->toClientList() ?>;
fc_chargesearch.lists["x_grp"].options = <?php echo JsonEncode($c_charge_search->grp->lookupOptions()) ?>;
fc_chargesearch.lists["x_s_grp"] = <?php echo $c_charge_search->s_grp->Lookup->toClientList() ?>;
fc_chargesearch.lists["x_s_grp"].options = <?php echo JsonEncode($c_charge_search->s_grp->lookupOptions()) ?>;
fc_chargesearch.lists["x_process[]"] = <?php echo $c_charge_search->process->Lookup->toClientList() ?>;
fc_chargesearch.lists["x_process[]"].options = <?php echo JsonEncode($c_charge_search->process->lookupOptions()) ?>;
fc_chargesearch.lists["x_method"] = <?php echo $c_charge_search->method->Lookup->toClientList() ?>;
fc_chargesearch.lists["x_method"].options = <?php echo JsonEncode($c_charge_search->method->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fc_chargesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($c_charge->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($c_charge->from_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_to_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($c_charge->to_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($c_charge->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($c_charge->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($c_charge->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $c_charge_search->showPageHeader(); ?>
<?php
$c_charge_search->showMessage();
?>
<form name="fc_chargesearch" id="fc_chargesearch" class="<?php echo $c_charge_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($c_charge_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $c_charge_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="c_charge">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$c_charge_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($c_charge->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_id"><?php echo $c_charge->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->id->cellAttributes() ?>>
			<span id="el_c_charge_id">
<input type="text" data-table="c_charge" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($c_charge->id->getPlaceHolder()) ?>" value="<?php echo $c_charge->id->EditValue ?>"<?php echo $c_charge->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->contractor_id->Visible) { // contractor_id ?>
	<div id="r_contractor_id" class="form-group row">
		<label for="x_contractor_id" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_contractor_id"><?php echo $c_charge->contractor_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_contractor_id" id="z_contractor_id" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->contractor_id->cellAttributes() ?>>
			<span id="el_c_charge_contractor_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="c_charge" data-field="x_contractor_id" data-value-separator="<?php echo $c_charge->contractor_id->displayValueSeparatorAttribute() ?>" id="x_contractor_id" name="x_contractor_id"<?php echo $c_charge->contractor_id->editAttributes() ?>>
		<?php echo $c_charge->contractor_id->selectOptionListHtml("x_contractor_id") ?>
	</select>
</div>
<?php echo $c_charge->contractor_id->Lookup->getParamTag("p_x_contractor_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_grp"><?php echo $c_charge->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->grp->cellAttributes() ?>>
			<span id="el_c_charge_grp">
<?php $c_charge->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$c_charge->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="c_charge" data-field="x_grp" data-value-separator="<?php echo $c_charge->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $c_charge->grp->editAttributes() ?>>
		<?php echo $c_charge->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $c_charge->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_s_grp"><?php echo $c_charge->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->s_grp->cellAttributes() ?>>
			<span id="el_c_charge_s_grp">
<?php $c_charge->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$c_charge->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="c_charge" data-field="x_s_grp" data-value-separator="<?php echo $c_charge->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $c_charge->s_grp->editAttributes() ?>>
		<?php echo $c_charge->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $c_charge->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_process"><?php echo $c_charge->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->process->cellAttributes() ?>>
			<span id="el_c_charge_process">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="c_charge" data-field="x_process" data-value-separator="<?php echo $c_charge->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $c_charge->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $c_charge->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $c_charge->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_method"><?php echo $c_charge->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->method->cellAttributes() ?>>
			<span id="el_c_charge_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="c_charge" data-field="x_method" data-value-separator="<?php echo $c_charge->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $c_charge->method->editAttributes() ?>>
		<?php echo $c_charge->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->from_date->Visible) { // from_date ?>
	<div id="r_from_date" class="form-group row">
		<label for="x_from_date" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_from_date"><?php echo $c_charge->from_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_date" id="z_from_date" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->from_date->cellAttributes() ?>>
			<span id="el_c_charge_from_date">
<input type="text" data-table="c_charge" data-field="x_from_date" name="x_from_date" id="x_from_date" placeholder="<?php echo HtmlEncode($c_charge->from_date->getPlaceHolder()) ?>" value="<?php echo $c_charge->from_date->EditValue ?>"<?php echo $c_charge->from_date->editAttributes() ?>>
<?php if (!$c_charge->from_date->ReadOnly && !$c_charge->from_date->Disabled && !isset($c_charge->from_date->EditAttrs["readonly"]) && !isset($c_charge->from_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fc_chargesearch", "x_from_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->to_date->Visible) { // to_date ?>
	<div id="r_to_date" class="form-group row">
		<label for="x_to_date" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_to_date"><?php echo $c_charge->to_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_date" id="z_to_date" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->to_date->cellAttributes() ?>>
			<span id="el_c_charge_to_date">
<input type="text" data-table="c_charge" data-field="x_to_date" name="x_to_date" id="x_to_date" placeholder="<?php echo HtmlEncode($c_charge->to_date->getPlaceHolder()) ?>" value="<?php echo $c_charge->to_date->EditValue ?>"<?php echo $c_charge->to_date->editAttributes() ?>>
<?php if (!$c_charge->to_date->ReadOnly && !$c_charge->to_date->Disabled && !isset($c_charge->to_date->EditAttrs["readonly"]) && !isset($c_charge->to_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fc_chargesearch", "x_to_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge__40"><?php echo $c_charge->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->_40->cellAttributes() ?>>
			<span id="el_c_charge__40">
<input type="text" data-table="c_charge" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($c_charge->_40->getPlaceHolder()) ?>" value="<?php echo $c_charge->_40->EditValue ?>"<?php echo $c_charge->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_operator"><?php echo $c_charge->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->operator->cellAttributes() ?>>
			<span id="el_c_charge_operator">
<input type="text" data-table="c_charge" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($c_charge->operator->getPlaceHolder()) ?>" value="<?php echo $c_charge->operator->EditValue ?>"<?php echo $c_charge->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($c_charge->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $c_charge_search->LeftColumnClass ?>"><span id="elh_c_charge_datetime"><?php echo $c_charge->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $c_charge_search->RightColumnClass ?>"><div<?php echo $c_charge->datetime->cellAttributes() ?>>
			<span id="el_c_charge_datetime">
<input type="text" data-table="c_charge" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($c_charge->datetime->getPlaceHolder()) ?>" value="<?php echo $c_charge->datetime->EditValue ?>"<?php echo $c_charge->datetime->editAttributes() ?>>
<?php if (!$c_charge->datetime->ReadOnly && !$c_charge->datetime->Disabled && !isset($c_charge->datetime->EditAttrs["readonly"]) && !isset($c_charge->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fc_chargesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$c_charge_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $c_charge_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$c_charge_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$c_charge_search->terminate();
?>