<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$c_charge_view = new c_charge_view();

// Run the page
$c_charge_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$c_charge_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$c_charge->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fc_chargeview = currentForm = new ew.Form("fc_chargeview", "view");

// Form_CustomValidate event
fc_chargeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fc_chargeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fc_chargeview.lists["x_contractor_id"] = <?php echo $c_charge_view->contractor_id->Lookup->toClientList() ?>;
fc_chargeview.lists["x_contractor_id"].options = <?php echo JsonEncode($c_charge_view->contractor_id->lookupOptions()) ?>;
fc_chargeview.lists["x_grp"] = <?php echo $c_charge_view->grp->Lookup->toClientList() ?>;
fc_chargeview.lists["x_grp"].options = <?php echo JsonEncode($c_charge_view->grp->lookupOptions()) ?>;
fc_chargeview.lists["x_s_grp"] = <?php echo $c_charge_view->s_grp->Lookup->toClientList() ?>;
fc_chargeview.lists["x_s_grp"].options = <?php echo JsonEncode($c_charge_view->s_grp->lookupOptions()) ?>;
fc_chargeview.lists["x_process[]"] = <?php echo $c_charge_view->process->Lookup->toClientList() ?>;
fc_chargeview.lists["x_process[]"].options = <?php echo JsonEncode($c_charge_view->process->lookupOptions()) ?>;
fc_chargeview.lists["x_product_code[]"] = <?php echo $c_charge_view->product_code->Lookup->toClientList() ?>;
fc_chargeview.lists["x_product_code[]"].options = <?php echo JsonEncode($c_charge_view->product_code->lookupOptions()) ?>;
fc_chargeview.lists["x_method"] = <?php echo $c_charge_view->method->Lookup->toClientList() ?>;
fc_chargeview.lists["x_method"].options = <?php echo JsonEncode($c_charge_view->method->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$c_charge->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $c_charge_view->ExportOptions->render("body") ?>
<?php $c_charge_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $c_charge_view->showPageHeader(); ?>
<?php
$c_charge_view->showMessage();
?>
<form name="fc_chargeview" id="fc_chargeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($c_charge_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $c_charge_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="c_charge">
<input type="hidden" name="modal" value="<?php echo (int)$c_charge_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($c_charge->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_id"><?php echo $c_charge->id->caption() ?></span></td>
		<td data-name="id"<?php echo $c_charge->id->cellAttributes() ?>>
<span id="el_c_charge_id">
<span<?php echo $c_charge->id->viewAttributes() ?>>
<?php echo $c_charge->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->contractor_id->Visible) { // contractor_id ?>
	<tr id="r_contractor_id">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_contractor_id"><?php echo $c_charge->contractor_id->caption() ?></span></td>
		<td data-name="contractor_id"<?php echo $c_charge->contractor_id->cellAttributes() ?>>
<span id="el_c_charge_contractor_id">
<span<?php echo $c_charge->contractor_id->viewAttributes() ?>>
<?php echo $c_charge->contractor_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_grp"><?php echo $c_charge->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $c_charge->grp->cellAttributes() ?>>
<span id="el_c_charge_grp">
<span<?php echo $c_charge->grp->viewAttributes() ?>>
<?php echo $c_charge->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_s_grp"><?php echo $c_charge->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $c_charge->s_grp->cellAttributes() ?>>
<span id="el_c_charge_s_grp">
<span<?php echo $c_charge->s_grp->viewAttributes() ?>>
<?php echo $c_charge->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_process"><?php echo $c_charge->process->caption() ?></span></td>
		<td data-name="process"<?php echo $c_charge->process->cellAttributes() ?>>
<span id="el_c_charge_process">
<span<?php echo $c_charge->process->viewAttributes() ?>>
<?php echo $c_charge->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_product_code"><?php echo $c_charge->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $c_charge->product_code->cellAttributes() ?>>
<span id="el_c_charge_product_code">
<span<?php echo $c_charge->product_code->viewAttributes() ?>>
<?php echo $c_charge->product_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->method->Visible) { // method ?>
	<tr id="r_method">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_method"><?php echo $c_charge->method->caption() ?></span></td>
		<td data-name="method"<?php echo $c_charge->method->cellAttributes() ?>>
<span id="el_c_charge_method">
<span<?php echo $c_charge->method->viewAttributes() ?>>
<?php echo $c_charge->method->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->from_date->Visible) { // from_date ?>
	<tr id="r_from_date">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_from_date"><?php echo $c_charge->from_date->caption() ?></span></td>
		<td data-name="from_date"<?php echo $c_charge->from_date->cellAttributes() ?>>
<span id="el_c_charge_from_date">
<span<?php echo $c_charge->from_date->viewAttributes() ?>>
<?php echo $c_charge->from_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->to_date->Visible) { // to_date ?>
	<tr id="r_to_date">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_to_date"><?php echo $c_charge->to_date->caption() ?></span></td>
		<td data-name="to_date"<?php echo $c_charge->to_date->cellAttributes() ?>>
<span id="el_c_charge_to_date">
<span<?php echo $c_charge->to_date->viewAttributes() ?>>
<?php echo $c_charge->to_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->_40->Visible) { // @ ?>
	<tr id="r__40">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge__40"><?php echo $c_charge->_40->caption() ?></span></td>
		<td data-name="_40"<?php echo $c_charge->_40->cellAttributes() ?>>
<span id="el_c_charge__40">
<span<?php echo $c_charge->_40->viewAttributes() ?>>
<?php echo $c_charge->_40->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_operator"><?php echo $c_charge->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $c_charge->operator->cellAttributes() ?>>
<span id="el_c_charge_operator">
<span<?php echo $c_charge->operator->viewAttributes() ?>>
<?php echo $c_charge->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($c_charge->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $c_charge_view->TableLeftColumnClass ?>"><span id="elh_c_charge_datetime"><?php echo $c_charge->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $c_charge->datetime->cellAttributes() ?>>
<span id="el_c_charge_datetime">
<span<?php echo $c_charge->datetime->viewAttributes() ?>>
<?php echo $c_charge->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$c_charge_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$c_charge->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$c_charge_view->terminate();
?>