<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$capacity_plan_edit = new capacity_plan_edit();

// Run the page
$capacity_plan_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$capacity_plan_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fcapacity_planedit = currentForm = new ew.Form("fcapacity_planedit", "edit");

// Validate form
fcapacity_planedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($capacity_plan_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->id->caption(), $capacity_plan->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($capacity_plan_edit->user_id->Required) { ?>
			elm = this.getElements("x" + infix + "_user_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->user_id->caption(), $capacity_plan->user_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($capacity_plan_edit->period->Required) { ?>
			elm = this.getElements("x" + infix + "_period");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->period->caption(), $capacity_plan->period->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($capacity_plan_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->grp->caption(), $capacity_plan->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($capacity_plan_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->s_grp->caption(), $capacity_plan->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($capacity_plan_edit->capacity->Required) { ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->capacity->caption(), $capacity_plan->capacity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($capacity_plan->capacity->errorMessage()) ?>");
		<?php if ($capacity_plan_edit->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->method->caption(), $capacity_plan->method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($capacity_plan_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->operator->caption(), $capacity_plan->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($capacity_plan_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $capacity_plan->datetime->caption(), $capacity_plan->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcapacity_planedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcapacity_planedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcapacity_planedit.lists["x_user_id"] = <?php echo $capacity_plan_edit->user_id->Lookup->toClientList() ?>;
fcapacity_planedit.lists["x_user_id"].options = <?php echo JsonEncode($capacity_plan_edit->user_id->lookupOptions()) ?>;
fcapacity_planedit.lists["x_period"] = <?php echo $capacity_plan_edit->period->Lookup->toClientList() ?>;
fcapacity_planedit.lists["x_period"].options = <?php echo JsonEncode($capacity_plan_edit->period->lookupOptions()) ?>;
fcapacity_planedit.lists["x_grp"] = <?php echo $capacity_plan_edit->grp->Lookup->toClientList() ?>;
fcapacity_planedit.lists["x_grp"].options = <?php echo JsonEncode($capacity_plan_edit->grp->lookupOptions()) ?>;
fcapacity_planedit.lists["x_s_grp"] = <?php echo $capacity_plan_edit->s_grp->Lookup->toClientList() ?>;
fcapacity_planedit.lists["x_s_grp"].options = <?php echo JsonEncode($capacity_plan_edit->s_grp->lookupOptions()) ?>;
fcapacity_planedit.lists["x_method"] = <?php echo $capacity_plan_edit->method->Lookup->toClientList() ?>;
fcapacity_planedit.lists["x_method"].options = <?php echo JsonEncode($capacity_plan_edit->method->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $capacity_plan_edit->showPageHeader(); ?>
<?php
$capacity_plan_edit->showMessage();
?>
<form name="fcapacity_planedit" id="fcapacity_planedit" class="<?php echo $capacity_plan_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($capacity_plan_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $capacity_plan_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="capacity_plan">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$capacity_plan_edit->IsModal ?>">
<?php if ($capacity_plan->getCurrentMasterTable() == "production_partner") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="production_partner">
<input type="hidden" name="fk_id" value="<?php echo $capacity_plan->user_id->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($capacity_plan->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_capacity_plan_id" class="<?php echo $capacity_plan_edit->LeftColumnClass ?>"><?php echo $capacity_plan->id->caption() ?><?php echo ($capacity_plan->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $capacity_plan_edit->RightColumnClass ?>"><div<?php echo $capacity_plan->id->cellAttributes() ?>>
<span id="el_capacity_plan_id">
<span<?php echo $capacity_plan->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($capacity_plan->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="capacity_plan" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($capacity_plan->id->CurrentValue) ?>">
<?php echo $capacity_plan->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($capacity_plan->user_id->Visible) { // user_id ?>
	<div id="r_user_id" class="form-group row">
		<label id="elh_capacity_plan_user_id" for="x_user_id" class="<?php echo $capacity_plan_edit->LeftColumnClass ?>"><?php echo $capacity_plan->user_id->caption() ?><?php echo ($capacity_plan->user_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $capacity_plan_edit->RightColumnClass ?>"><div<?php echo $capacity_plan->user_id->cellAttributes() ?>>
<?php if ($capacity_plan->user_id->getSessionValue() <> "") { ?>
<span id="el_capacity_plan_user_id">
<span<?php echo $capacity_plan->user_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($capacity_plan->user_id->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_user_id" name="x_user_id" value="<?php echo HtmlEncode($capacity_plan->user_id->CurrentValue) ?>">
<?php } else { ?>
<span id="el_capacity_plan_user_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="capacity_plan" data-field="x_user_id" data-value-separator="<?php echo $capacity_plan->user_id->displayValueSeparatorAttribute() ?>" id="x_user_id" name="x_user_id"<?php echo $capacity_plan->user_id->editAttributes() ?>>
		<?php echo $capacity_plan->user_id->selectOptionListHtml("x_user_id") ?>
	</select>
</div>
<?php echo $capacity_plan->user_id->Lookup->getParamTag("p_x_user_id") ?>
</span>
<?php } ?>
<?php echo $capacity_plan->user_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($capacity_plan->period->Visible) { // period ?>
	<div id="r_period" class="form-group row">
		<label id="elh_capacity_plan_period" for="x_period" class="<?php echo $capacity_plan_edit->LeftColumnClass ?>"><?php echo $capacity_plan->period->caption() ?><?php echo ($capacity_plan->period->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $capacity_plan_edit->RightColumnClass ?>"><div<?php echo $capacity_plan->period->cellAttributes() ?>>
<span id="el_capacity_plan_period">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="capacity_plan" data-field="x_period" data-value-separator="<?php echo $capacity_plan->period->displayValueSeparatorAttribute() ?>" id="x_period" name="x_period"<?php echo $capacity_plan->period->editAttributes() ?>>
		<?php echo $capacity_plan->period->selectOptionListHtml("x_period") ?>
	</select>
</div>
<?php echo $capacity_plan->period->Lookup->getParamTag("p_x_period") ?>
</span>
<?php echo $capacity_plan->period->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($capacity_plan->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_capacity_plan_grp" for="x_grp" class="<?php echo $capacity_plan_edit->LeftColumnClass ?>"><?php echo $capacity_plan->grp->caption() ?><?php echo ($capacity_plan->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $capacity_plan_edit->RightColumnClass ?>"><div<?php echo $capacity_plan->grp->cellAttributes() ?>>
<span id="el_capacity_plan_grp">
<?php $capacity_plan->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$capacity_plan->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="capacity_plan" data-field="x_grp" data-value-separator="<?php echo $capacity_plan->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $capacity_plan->grp->editAttributes() ?>>
		<?php echo $capacity_plan->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $capacity_plan->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $capacity_plan->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($capacity_plan->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_capacity_plan_s_grp" for="x_s_grp" class="<?php echo $capacity_plan_edit->LeftColumnClass ?>"><?php echo $capacity_plan->s_grp->caption() ?><?php echo ($capacity_plan->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $capacity_plan_edit->RightColumnClass ?>"><div<?php echo $capacity_plan->s_grp->cellAttributes() ?>>
<span id="el_capacity_plan_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="capacity_plan" data-field="x_s_grp" data-value-separator="<?php echo $capacity_plan->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $capacity_plan->s_grp->editAttributes() ?>>
		<?php echo $capacity_plan->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $capacity_plan->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $capacity_plan->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($capacity_plan->capacity->Visible) { // capacity ?>
	<div id="r_capacity" class="form-group row">
		<label id="elh_capacity_plan_capacity" for="x_capacity" class="<?php echo $capacity_plan_edit->LeftColumnClass ?>"><?php echo $capacity_plan->capacity->caption() ?><?php echo ($capacity_plan->capacity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $capacity_plan_edit->RightColumnClass ?>"><div<?php echo $capacity_plan->capacity->cellAttributes() ?>>
<span id="el_capacity_plan_capacity">
<input type="text" data-table="capacity_plan" data-field="x_capacity" name="x_capacity" id="x_capacity" size="30" placeholder="<?php echo HtmlEncode($capacity_plan->capacity->getPlaceHolder()) ?>" value="<?php echo $capacity_plan->capacity->EditValue ?>"<?php echo $capacity_plan->capacity->editAttributes() ?>>
</span>
<?php echo $capacity_plan->capacity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($capacity_plan->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label id="elh_capacity_plan_method" for="x_method" class="<?php echo $capacity_plan_edit->LeftColumnClass ?>"><?php echo $capacity_plan->method->caption() ?><?php echo ($capacity_plan->method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $capacity_plan_edit->RightColumnClass ?>"><div<?php echo $capacity_plan->method->cellAttributes() ?>>
<span id="el_capacity_plan_method">
<span<?php echo $capacity_plan->method->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($capacity_plan->method->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="capacity_plan" data-field="x_method" name="x_method" id="x_method" value="<?php echo HtmlEncode($capacity_plan->method->CurrentValue) ?>">
<?php echo $capacity_plan->method->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$capacity_plan_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $capacity_plan_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $capacity_plan_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$capacity_plan_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$capacity_plan_edit->terminate();
?>