<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$capacity_plan_view = new capacity_plan_view();

// Run the page
$capacity_plan_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$capacity_plan_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$capacity_plan->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcapacity_planview = currentForm = new ew.Form("fcapacity_planview", "view");

// Form_CustomValidate event
fcapacity_planview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcapacity_planview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcapacity_planview.lists["x_user_id"] = <?php echo $capacity_plan_view->user_id->Lookup->toClientList() ?>;
fcapacity_planview.lists["x_user_id"].options = <?php echo JsonEncode($capacity_plan_view->user_id->lookupOptions()) ?>;
fcapacity_planview.lists["x_period"] = <?php echo $capacity_plan_view->period->Lookup->toClientList() ?>;
fcapacity_planview.lists["x_period"].options = <?php echo JsonEncode($capacity_plan_view->period->lookupOptions()) ?>;
fcapacity_planview.lists["x_grp"] = <?php echo $capacity_plan_view->grp->Lookup->toClientList() ?>;
fcapacity_planview.lists["x_grp"].options = <?php echo JsonEncode($capacity_plan_view->grp->lookupOptions()) ?>;
fcapacity_planview.lists["x_s_grp"] = <?php echo $capacity_plan_view->s_grp->Lookup->toClientList() ?>;
fcapacity_planview.lists["x_s_grp"].options = <?php echo JsonEncode($capacity_plan_view->s_grp->lookupOptions()) ?>;
fcapacity_planview.lists["x_method"] = <?php echo $capacity_plan_view->method->Lookup->toClientList() ?>;
fcapacity_planview.lists["x_method"].options = <?php echo JsonEncode($capacity_plan_view->method->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$capacity_plan->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $capacity_plan_view->ExportOptions->render("body") ?>
<?php $capacity_plan_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $capacity_plan_view->showPageHeader(); ?>
<?php
$capacity_plan_view->showMessage();
?>
<form name="fcapacity_planview" id="fcapacity_planview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($capacity_plan_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $capacity_plan_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="capacity_plan">
<input type="hidden" name="modal" value="<?php echo (int)$capacity_plan_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($capacity_plan->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_id"><?php echo $capacity_plan->id->caption() ?></span></td>
		<td data-name="id"<?php echo $capacity_plan->id->cellAttributes() ?>>
<span id="el_capacity_plan_id">
<span<?php echo $capacity_plan->id->viewAttributes() ?>>
<?php echo $capacity_plan->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->user_id->Visible) { // user_id ?>
	<tr id="r_user_id">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_user_id"><?php echo $capacity_plan->user_id->caption() ?></span></td>
		<td data-name="user_id"<?php echo $capacity_plan->user_id->cellAttributes() ?>>
<span id="el_capacity_plan_user_id">
<span<?php echo $capacity_plan->user_id->viewAttributes() ?>>
<?php echo $capacity_plan->user_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->period->Visible) { // period ?>
	<tr id="r_period">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_period"><?php echo $capacity_plan->period->caption() ?></span></td>
		<td data-name="period"<?php echo $capacity_plan->period->cellAttributes() ?>>
<span id="el_capacity_plan_period">
<span<?php echo $capacity_plan->period->viewAttributes() ?>>
<?php echo $capacity_plan->period->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_grp"><?php echo $capacity_plan->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $capacity_plan->grp->cellAttributes() ?>>
<span id="el_capacity_plan_grp">
<span<?php echo $capacity_plan->grp->viewAttributes() ?>>
<?php echo $capacity_plan->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_s_grp"><?php echo $capacity_plan->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $capacity_plan->s_grp->cellAttributes() ?>>
<span id="el_capacity_plan_s_grp">
<span<?php echo $capacity_plan->s_grp->viewAttributes() ?>>
<?php echo $capacity_plan->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->capacity->Visible) { // capacity ?>
	<tr id="r_capacity">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_capacity"><?php echo $capacity_plan->capacity->caption() ?></span></td>
		<td data-name="capacity"<?php echo $capacity_plan->capacity->cellAttributes() ?>>
<span id="el_capacity_plan_capacity">
<span<?php echo $capacity_plan->capacity->viewAttributes() ?>>
<?php echo $capacity_plan->capacity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->method->Visible) { // method ?>
	<tr id="r_method">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_method"><?php echo $capacity_plan->method->caption() ?></span></td>
		<td data-name="method"<?php echo $capacity_plan->method->cellAttributes() ?>>
<span id="el_capacity_plan_method">
<span<?php echo $capacity_plan->method->viewAttributes() ?>>
<?php echo $capacity_plan->method->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_operator"><?php echo $capacity_plan->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $capacity_plan->operator->cellAttributes() ?>>
<span id="el_capacity_plan_operator">
<span<?php echo $capacity_plan->operator->viewAttributes() ?>>
<?php echo $capacity_plan->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($capacity_plan->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $capacity_plan_view->TableLeftColumnClass ?>"><span id="elh_capacity_plan_datetime"><?php echo $capacity_plan->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $capacity_plan->datetime->cellAttributes() ?>>
<span id="el_capacity_plan_datetime">
<span<?php echo $capacity_plan->datetime->viewAttributes() ?>>
<?php echo $capacity_plan->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$capacity_plan_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$capacity_plan->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$capacity_plan_view->terminate();
?>