<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$carpet_setup_add = new carpet_setup_add();

// Run the page
$carpet_setup_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$carpet_setup_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcarpet_setupadd = currentForm = new ew.Form("fcarpet_setupadd", "add");

// Validate form
fcarpet_setupadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($carpet_setup_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->id->caption(), $carpet_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->id->errorMessage()) ?>");
		<?php if ($carpet_setup_add->cs_min_width->Required) { ?>
			elm = this.getElements("x" + infix + "_cs_min_width");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->cs_min_width->caption(), $carpet_setup->cs_min_width->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cs_min_width");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->cs_min_width->errorMessage()) ?>");
		<?php if ($carpet_setup_add->cs_min_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_cs_min_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->cs_min_qty->caption(), $carpet_setup->cs_min_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cs_min_qty");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->cs_min_qty->errorMessage()) ?>");
		<?php if ($carpet_setup_add->payment_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->payment_sqm->caption(), $carpet_setup->payment_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->process_byepass->Required) { ?>
			elm = this.getElements("x" + infix + "_process_byepass");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->process_byepass->caption(), $carpet_setup->process_byepass->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->jc_bom_wastage->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_bom_wastage");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->jc_bom_wastage->caption(), $carpet_setup->jc_bom_wastage->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->bom_1000->Required) { ?>
			elm = this.getElements("x" + infix + "_bom_1000");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->bom_1000->caption(), $carpet_setup->bom_1000->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_bom_1000");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->bom_1000->errorMessage()) ?>");
		<?php if ($carpet_setup_add->batch_authorized_id->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_authorized_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->batch_authorized_id->caption(), $carpet_setup->batch_authorized_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->tufting_plan_sgrp->Required) { ?>
			elm = this.getElements("x" + infix + "_tufting_plan_sgrp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->tufting_plan_sgrp->caption(), $carpet_setup->tufting_plan_sgrp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->tufting_plan_loom_group->Required) { ?>
			elm = this.getElements("x" + infix + "_tufting_plan_loom_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->tufting_plan_loom_group->caption(), $carpet_setup->tufting_plan_loom_group->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->jc_weeks->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_weeks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->jc_weeks->caption(), $carpet_setup->jc_weeks->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_weeks");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->jc_weeks->errorMessage()) ?>");
		<?php if ($carpet_setup_add->required_material_overall_update->Required) { ?>
			elm = this.getElements("x" + infix + "_required_material_overall_update");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->required_material_overall_update->caption(), $carpet_setup->required_material_overall_update->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_required_material_overall_update");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->required_material_overall_update->errorMessage()) ?>");
		<?php if ($carpet_setup_add->jc_material_issue->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_material_issue");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->jc_material_issue->caption(), $carpet_setup->jc_material_issue->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->operator->caption(), $carpet_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->datetime->caption(), $carpet_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($carpet_setup_add->jc_qr->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_qr");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->jc_qr->caption(), $carpet_setup->jc_qr->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_qr");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->jc_qr->errorMessage()) ?>");
		<?php if ($carpet_setup_add->tufting_performance_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_tufting_performance_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->tufting_performance_percent->caption(), $carpet_setup->tufting_performance_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tufting_performance_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->tufting_performance_percent->errorMessage()) ?>");
		<?php if ($carpet_setup_add->jc_mrlot->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_mrlot");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->jc_mrlot->caption(), $carpet_setup->jc_mrlot->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_mrlot");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->jc_mrlot->errorMessage()) ?>");
		<?php if ($carpet_setup_add->batch_pp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_pp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->batch_pp_id->caption(), $carpet_setup->batch_pp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_pp_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->batch_pp_id->errorMessage()) ?>");
		<?php if ($carpet_setup_add->tufting_plan_active->Required) { ?>
			elm = this.getElements("x" + infix + "_tufting_plan_active");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->tufting_plan_active->caption(), $carpet_setup->tufting_plan_active->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tufting_plan_active");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->tufting_plan_active->errorMessage()) ?>");
		<?php if ($carpet_setup_add->max_jobcard->Required) { ?>
			elm = this.getElements("x" + infix + "_max_jobcard");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->max_jobcard->caption(), $carpet_setup->max_jobcard->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_jobcard");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->max_jobcard->errorMessage()) ?>");
		<?php if ($carpet_setup_add->jc_pending_delete_days->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_pending_delete_days");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->jc_pending_delete_days->caption(), $carpet_setup->jc_pending_delete_days->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_pending_delete_days");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($carpet_setup->jc_pending_delete_days->errorMessage()) ?>");
		<?php if ($carpet_setup_add->payment_sqm_byepass_category->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_sqm_byepass_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $carpet_setup->payment_sqm_byepass_category->caption(), $carpet_setup->payment_sqm_byepass_category->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcarpet_setupadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcarpet_setupadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcarpet_setupadd.lists["x_payment_sqm"] = <?php echo $carpet_setup_add->payment_sqm->Lookup->toClientList() ?>;
fcarpet_setupadd.lists["x_payment_sqm"].options = <?php echo JsonEncode($carpet_setup_add->payment_sqm->options(FALSE, TRUE)) ?>;
fcarpet_setupadd.lists["x_process_byepass"] = <?php echo $carpet_setup_add->process_byepass->Lookup->toClientList() ?>;
fcarpet_setupadd.lists["x_process_byepass"].options = <?php echo JsonEncode($carpet_setup_add->process_byepass->options(FALSE, TRUE)) ?>;
fcarpet_setupadd.lists["x_jc_bom_wastage"] = <?php echo $carpet_setup_add->jc_bom_wastage->Lookup->toClientList() ?>;
fcarpet_setupadd.lists["x_jc_bom_wastage"].options = <?php echo JsonEncode($carpet_setup_add->jc_bom_wastage->options(FALSE, TRUE)) ?>;
fcarpet_setupadd.lists["x_batch_authorized_id"] = <?php echo $carpet_setup_add->batch_authorized_id->Lookup->toClientList() ?>;
fcarpet_setupadd.lists["x_batch_authorized_id"].options = <?php echo JsonEncode($carpet_setup_add->batch_authorized_id->lookupOptions()) ?>;
fcarpet_setupadd.lists["x_tufting_plan_sgrp[]"] = <?php echo $carpet_setup_add->tufting_plan_sgrp->Lookup->toClientList() ?>;
fcarpet_setupadd.lists["x_tufting_plan_sgrp[]"].options = <?php echo JsonEncode($carpet_setup_add->tufting_plan_sgrp->lookupOptions()) ?>;
fcarpet_setupadd.lists["x_tufting_plan_loom_group"] = <?php echo $carpet_setup_add->tufting_plan_loom_group->Lookup->toClientList() ?>;
fcarpet_setupadd.lists["x_tufting_plan_loom_group"].options = <?php echo JsonEncode($carpet_setup_add->tufting_plan_loom_group->options(FALSE, TRUE)) ?>;
fcarpet_setupadd.lists["x_jc_material_issue"] = <?php echo $carpet_setup_add->jc_material_issue->Lookup->toClientList() ?>;
fcarpet_setupadd.lists["x_jc_material_issue"].options = <?php echo JsonEncode($carpet_setup_add->jc_material_issue->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $carpet_setup_add->showPageHeader(); ?>
<?php
$carpet_setup_add->showMessage();
?>
<form name="fcarpet_setupadd" id="fcarpet_setupadd" class="<?php echo $carpet_setup_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($carpet_setup_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $carpet_setup_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="carpet_setup">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$carpet_setup_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($carpet_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_carpet_setup_id" for="x_id" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->id->caption() ?><?php echo ($carpet_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->id->cellAttributes() ?>>
<span id="el_carpet_setup_id">
<input type="text" data-table="carpet_setup" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->id->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->id->EditValue ?>"<?php echo $carpet_setup->id->editAttributes() ?>>
</span>
<?php echo $carpet_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->cs_min_width->Visible) { // cs_min_width ?>
	<div id="r_cs_min_width" class="form-group row">
		<label id="elh_carpet_setup_cs_min_width" for="x_cs_min_width" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->cs_min_width->caption() ?><?php echo ($carpet_setup->cs_min_width->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->cs_min_width->cellAttributes() ?>>
<span id="el_carpet_setup_cs_min_width">
<input type="text" data-table="carpet_setup" data-field="x_cs_min_width" name="x_cs_min_width" id="x_cs_min_width" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->cs_min_width->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->cs_min_width->EditValue ?>"<?php echo $carpet_setup->cs_min_width->editAttributes() ?>>
</span>
<?php echo $carpet_setup->cs_min_width->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->cs_min_qty->Visible) { // cs_min_qty ?>
	<div id="r_cs_min_qty" class="form-group row">
		<label id="elh_carpet_setup_cs_min_qty" for="x_cs_min_qty" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->cs_min_qty->caption() ?><?php echo ($carpet_setup->cs_min_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->cs_min_qty->cellAttributes() ?>>
<span id="el_carpet_setup_cs_min_qty">
<input type="text" data-table="carpet_setup" data-field="x_cs_min_qty" name="x_cs_min_qty" id="x_cs_min_qty" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->cs_min_qty->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->cs_min_qty->EditValue ?>"<?php echo $carpet_setup->cs_min_qty->editAttributes() ?>>
</span>
<?php echo $carpet_setup->cs_min_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->payment_sqm->Visible) { // payment_sqm ?>
	<div id="r_payment_sqm" class="form-group row">
		<label id="elh_carpet_setup_payment_sqm" for="x_payment_sqm" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->payment_sqm->caption() ?><?php echo ($carpet_setup->payment_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->payment_sqm->cellAttributes() ?>>
<span id="el_carpet_setup_payment_sqm">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="carpet_setup" data-field="x_payment_sqm" data-value-separator="<?php echo $carpet_setup->payment_sqm->displayValueSeparatorAttribute() ?>" id="x_payment_sqm" name="x_payment_sqm"<?php echo $carpet_setup->payment_sqm->editAttributes() ?>>
		<?php echo $carpet_setup->payment_sqm->selectOptionListHtml("x_payment_sqm") ?>
	</select>
</div>
</span>
<?php echo $carpet_setup->payment_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->process_byepass->Visible) { // process_byepass ?>
	<div id="r_process_byepass" class="form-group row">
		<label id="elh_carpet_setup_process_byepass" for="x_process_byepass" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->process_byepass->caption() ?><?php echo ($carpet_setup->process_byepass->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->process_byepass->cellAttributes() ?>>
<span id="el_carpet_setup_process_byepass">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="carpet_setup" data-field="x_process_byepass" data-value-separator="<?php echo $carpet_setup->process_byepass->displayValueSeparatorAttribute() ?>" id="x_process_byepass" name="x_process_byepass"<?php echo $carpet_setup->process_byepass->editAttributes() ?>>
		<?php echo $carpet_setup->process_byepass->selectOptionListHtml("x_process_byepass") ?>
	</select>
</div>
</span>
<?php echo $carpet_setup->process_byepass->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->jc_bom_wastage->Visible) { // jc_bom_wastage ?>
	<div id="r_jc_bom_wastage" class="form-group row">
		<label id="elh_carpet_setup_jc_bom_wastage" for="x_jc_bom_wastage" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->jc_bom_wastage->caption() ?><?php echo ($carpet_setup->jc_bom_wastage->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->jc_bom_wastage->cellAttributes() ?>>
<span id="el_carpet_setup_jc_bom_wastage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="carpet_setup" data-field="x_jc_bom_wastage" data-value-separator="<?php echo $carpet_setup->jc_bom_wastage->displayValueSeparatorAttribute() ?>" id="x_jc_bom_wastage" name="x_jc_bom_wastage"<?php echo $carpet_setup->jc_bom_wastage->editAttributes() ?>>
		<?php echo $carpet_setup->jc_bom_wastage->selectOptionListHtml("x_jc_bom_wastage") ?>
	</select>
</div>
</span>
<?php echo $carpet_setup->jc_bom_wastage->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->bom_1000->Visible) { // bom_1000 ?>
	<div id="r_bom_1000" class="form-group row">
		<label id="elh_carpet_setup_bom_1000" for="x_bom_1000" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->bom_1000->caption() ?><?php echo ($carpet_setup->bom_1000->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->bom_1000->cellAttributes() ?>>
<span id="el_carpet_setup_bom_1000">
<input type="text" data-table="carpet_setup" data-field="x_bom_1000" name="x_bom_1000" id="x_bom_1000" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->bom_1000->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->bom_1000->EditValue ?>"<?php echo $carpet_setup->bom_1000->editAttributes() ?>>
</span>
<?php echo $carpet_setup->bom_1000->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->batch_authorized_id->Visible) { // batch_authorized_id ?>
	<div id="r_batch_authorized_id" class="form-group row">
		<label id="elh_carpet_setup_batch_authorized_id" for="x_batch_authorized_id" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->batch_authorized_id->caption() ?><?php echo ($carpet_setup->batch_authorized_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->batch_authorized_id->cellAttributes() ?>>
<span id="el_carpet_setup_batch_authorized_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="carpet_setup" data-field="x_batch_authorized_id" data-value-separator="<?php echo $carpet_setup->batch_authorized_id->displayValueSeparatorAttribute() ?>" id="x_batch_authorized_id" name="x_batch_authorized_id"<?php echo $carpet_setup->batch_authorized_id->editAttributes() ?>>
		<?php echo $carpet_setup->batch_authorized_id->selectOptionListHtml("x_batch_authorized_id") ?>
	</select>
</div>
<?php echo $carpet_setup->batch_authorized_id->Lookup->getParamTag("p_x_batch_authorized_id") ?>
</span>
<?php echo $carpet_setup->batch_authorized_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_sgrp->Visible) { // tufting_plan_sgrp ?>
	<div id="r_tufting_plan_sgrp" class="form-group row">
		<label id="elh_carpet_setup_tufting_plan_sgrp" for="x_tufting_plan_sgrp" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->tufting_plan_sgrp->caption() ?><?php echo ($carpet_setup->tufting_plan_sgrp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->tufting_plan_sgrp->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_plan_sgrp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="carpet_setup" data-field="x_tufting_plan_sgrp" data-value-separator="<?php echo $carpet_setup->tufting_plan_sgrp->displayValueSeparatorAttribute() ?>" id="x_tufting_plan_sgrp[]" name="x_tufting_plan_sgrp[]" multiple="multiple"<?php echo $carpet_setup->tufting_plan_sgrp->editAttributes() ?>>
		<?php echo $carpet_setup->tufting_plan_sgrp->selectOptionListHtml("x_tufting_plan_sgrp[]") ?>
	</select>
</div>
<?php echo $carpet_setup->tufting_plan_sgrp->Lookup->getParamTag("p_x_tufting_plan_sgrp") ?>
</span>
<?php echo $carpet_setup->tufting_plan_sgrp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_loom_group->Visible) { // tufting_plan_loom_group ?>
	<div id="r_tufting_plan_loom_group" class="form-group row">
		<label id="elh_carpet_setup_tufting_plan_loom_group" for="x_tufting_plan_loom_group" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->tufting_plan_loom_group->caption() ?><?php echo ($carpet_setup->tufting_plan_loom_group->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->tufting_plan_loom_group->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_plan_loom_group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="carpet_setup" data-field="x_tufting_plan_loom_group" data-value-separator="<?php echo $carpet_setup->tufting_plan_loom_group->displayValueSeparatorAttribute() ?>" id="x_tufting_plan_loom_group" name="x_tufting_plan_loom_group"<?php echo $carpet_setup->tufting_plan_loom_group->editAttributes() ?>>
		<?php echo $carpet_setup->tufting_plan_loom_group->selectOptionListHtml("x_tufting_plan_loom_group") ?>
	</select>
</div>
</span>
<?php echo $carpet_setup->tufting_plan_loom_group->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->jc_weeks->Visible) { // jc_weeks ?>
	<div id="r_jc_weeks" class="form-group row">
		<label id="elh_carpet_setup_jc_weeks" for="x_jc_weeks" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->jc_weeks->caption() ?><?php echo ($carpet_setup->jc_weeks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->jc_weeks->cellAttributes() ?>>
<span id="el_carpet_setup_jc_weeks">
<input type="text" data-table="carpet_setup" data-field="x_jc_weeks" name="x_jc_weeks" id="x_jc_weeks" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->jc_weeks->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->jc_weeks->EditValue ?>"<?php echo $carpet_setup->jc_weeks->editAttributes() ?>>
</span>
<?php echo $carpet_setup->jc_weeks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->required_material_overall_update->Visible) { // required_material_overall_update ?>
	<div id="r_required_material_overall_update" class="form-group row">
		<label id="elh_carpet_setup_required_material_overall_update" for="x_required_material_overall_update" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->required_material_overall_update->caption() ?><?php echo ($carpet_setup->required_material_overall_update->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->required_material_overall_update->cellAttributes() ?>>
<span id="el_carpet_setup_required_material_overall_update">
<input type="text" data-table="carpet_setup" data-field="x_required_material_overall_update" name="x_required_material_overall_update" id="x_required_material_overall_update" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->required_material_overall_update->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->required_material_overall_update->EditValue ?>"<?php echo $carpet_setup->required_material_overall_update->editAttributes() ?>>
</span>
<?php echo $carpet_setup->required_material_overall_update->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->jc_material_issue->Visible) { // jc_material_issue ?>
	<div id="r_jc_material_issue" class="form-group row">
		<label id="elh_carpet_setup_jc_material_issue" for="x_jc_material_issue" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->jc_material_issue->caption() ?><?php echo ($carpet_setup->jc_material_issue->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->jc_material_issue->cellAttributes() ?>>
<span id="el_carpet_setup_jc_material_issue">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="carpet_setup" data-field="x_jc_material_issue" data-value-separator="<?php echo $carpet_setup->jc_material_issue->displayValueSeparatorAttribute() ?>" id="x_jc_material_issue" name="x_jc_material_issue"<?php echo $carpet_setup->jc_material_issue->editAttributes() ?>>
		<?php echo $carpet_setup->jc_material_issue->selectOptionListHtml("x_jc_material_issue") ?>
	</select>
</div>
</span>
<?php echo $carpet_setup->jc_material_issue->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->jc_qr->Visible) { // jc_qr ?>
	<div id="r_jc_qr" class="form-group row">
		<label id="elh_carpet_setup_jc_qr" for="x_jc_qr" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->jc_qr->caption() ?><?php echo ($carpet_setup->jc_qr->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->jc_qr->cellAttributes() ?>>
<span id="el_carpet_setup_jc_qr">
<input type="text" data-table="carpet_setup" data-field="x_jc_qr" name="x_jc_qr" id="x_jc_qr" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->jc_qr->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->jc_qr->EditValue ?>"<?php echo $carpet_setup->jc_qr->editAttributes() ?>>
</span>
<?php echo $carpet_setup->jc_qr->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->tufting_performance_percent->Visible) { // tufting_performance_percent ?>
	<div id="r_tufting_performance_percent" class="form-group row">
		<label id="elh_carpet_setup_tufting_performance_percent" for="x_tufting_performance_percent" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->tufting_performance_percent->caption() ?><?php echo ($carpet_setup->tufting_performance_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->tufting_performance_percent->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_performance_percent">
<input type="text" data-table="carpet_setup" data-field="x_tufting_performance_percent" name="x_tufting_performance_percent" id="x_tufting_performance_percent" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->tufting_performance_percent->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->tufting_performance_percent->EditValue ?>"<?php echo $carpet_setup->tufting_performance_percent->editAttributes() ?>>
</span>
<?php echo $carpet_setup->tufting_performance_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->jc_mrlot->Visible) { // jc_mrlot ?>
	<div id="r_jc_mrlot" class="form-group row">
		<label id="elh_carpet_setup_jc_mrlot" for="x_jc_mrlot" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->jc_mrlot->caption() ?><?php echo ($carpet_setup->jc_mrlot->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->jc_mrlot->cellAttributes() ?>>
<span id="el_carpet_setup_jc_mrlot">
<input type="text" data-table="carpet_setup" data-field="x_jc_mrlot" name="x_jc_mrlot" id="x_jc_mrlot" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->jc_mrlot->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->jc_mrlot->EditValue ?>"<?php echo $carpet_setup->jc_mrlot->editAttributes() ?>>
</span>
<?php echo $carpet_setup->jc_mrlot->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->batch_pp_id->Visible) { // batch_pp_id ?>
	<div id="r_batch_pp_id" class="form-group row">
		<label id="elh_carpet_setup_batch_pp_id" for="x_batch_pp_id" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->batch_pp_id->caption() ?><?php echo ($carpet_setup->batch_pp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->batch_pp_id->cellAttributes() ?>>
<span id="el_carpet_setup_batch_pp_id">
<input type="text" data-table="carpet_setup" data-field="x_batch_pp_id" name="x_batch_pp_id" id="x_batch_pp_id" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->batch_pp_id->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->batch_pp_id->EditValue ?>"<?php echo $carpet_setup->batch_pp_id->editAttributes() ?>>
</span>
<?php echo $carpet_setup->batch_pp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_active->Visible) { // tufting_plan_active ?>
	<div id="r_tufting_plan_active" class="form-group row">
		<label id="elh_carpet_setup_tufting_plan_active" for="x_tufting_plan_active" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->tufting_plan_active->caption() ?><?php echo ($carpet_setup->tufting_plan_active->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->tufting_plan_active->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_plan_active">
<input type="text" data-table="carpet_setup" data-field="x_tufting_plan_active" name="x_tufting_plan_active" id="x_tufting_plan_active" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->tufting_plan_active->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->tufting_plan_active->EditValue ?>"<?php echo $carpet_setup->tufting_plan_active->editAttributes() ?>>
</span>
<?php echo $carpet_setup->tufting_plan_active->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->max_jobcard->Visible) { // max_jobcard ?>
	<div id="r_max_jobcard" class="form-group row">
		<label id="elh_carpet_setup_max_jobcard" for="x_max_jobcard" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->max_jobcard->caption() ?><?php echo ($carpet_setup->max_jobcard->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->max_jobcard->cellAttributes() ?>>
<span id="el_carpet_setup_max_jobcard">
<input type="text" data-table="carpet_setup" data-field="x_max_jobcard" name="x_max_jobcard" id="x_max_jobcard" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->max_jobcard->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->max_jobcard->EditValue ?>"<?php echo $carpet_setup->max_jobcard->editAttributes() ?>>
</span>
<?php echo $carpet_setup->max_jobcard->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->jc_pending_delete_days->Visible) { // jc_pending_delete_days ?>
	<div id="r_jc_pending_delete_days" class="form-group row">
		<label id="elh_carpet_setup_jc_pending_delete_days" for="x_jc_pending_delete_days" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->jc_pending_delete_days->caption() ?><?php echo ($carpet_setup->jc_pending_delete_days->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->jc_pending_delete_days->cellAttributes() ?>>
<span id="el_carpet_setup_jc_pending_delete_days">
<input type="text" data-table="carpet_setup" data-field="x_jc_pending_delete_days" name="x_jc_pending_delete_days" id="x_jc_pending_delete_days" size="30" placeholder="<?php echo HtmlEncode($carpet_setup->jc_pending_delete_days->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->jc_pending_delete_days->EditValue ?>"<?php echo $carpet_setup->jc_pending_delete_days->editAttributes() ?>>
</span>
<?php echo $carpet_setup->jc_pending_delete_days->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($carpet_setup->payment_sqm_byepass_category->Visible) { // payment_sqm_byepass_category ?>
	<div id="r_payment_sqm_byepass_category" class="form-group row">
		<label id="elh_carpet_setup_payment_sqm_byepass_category" for="x_payment_sqm_byepass_category" class="<?php echo $carpet_setup_add->LeftColumnClass ?>"><?php echo $carpet_setup->payment_sqm_byepass_category->caption() ?><?php echo ($carpet_setup->payment_sqm_byepass_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $carpet_setup_add->RightColumnClass ?>"><div<?php echo $carpet_setup->payment_sqm_byepass_category->cellAttributes() ?>>
<span id="el_carpet_setup_payment_sqm_byepass_category">
<input type="text" data-table="carpet_setup" data-field="x_payment_sqm_byepass_category" name="x_payment_sqm_byepass_category" id="x_payment_sqm_byepass_category" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($carpet_setup->payment_sqm_byepass_category->getPlaceHolder()) ?>" value="<?php echo $carpet_setup->payment_sqm_byepass_category->EditValue ?>"<?php echo $carpet_setup->payment_sqm_byepass_category->editAttributes() ?>>
</span>
<?php echo $carpet_setup->payment_sqm_byepass_category->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$carpet_setup_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $carpet_setup_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $carpet_setup_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$carpet_setup_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$carpet_setup_add->terminate();
?>