<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$carpet_setup_list = new carpet_setup_list();

// Run the page
$carpet_setup_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$carpet_setup_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$carpet_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcarpet_setuplist = currentForm = new ew.Form("fcarpet_setuplist", "list");
fcarpet_setuplist.formKeyCountName = '<?php echo $carpet_setup_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcarpet_setuplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcarpet_setuplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcarpet_setuplist.lists["x_payment_sqm"] = <?php echo $carpet_setup_list->payment_sqm->Lookup->toClientList() ?>;
fcarpet_setuplist.lists["x_payment_sqm"].options = <?php echo JsonEncode($carpet_setup_list->payment_sqm->options(FALSE, TRUE)) ?>;
fcarpet_setuplist.lists["x_process_byepass"] = <?php echo $carpet_setup_list->process_byepass->Lookup->toClientList() ?>;
fcarpet_setuplist.lists["x_process_byepass"].options = <?php echo JsonEncode($carpet_setup_list->process_byepass->options(FALSE, TRUE)) ?>;
fcarpet_setuplist.lists["x_jc_bom_wastage"] = <?php echo $carpet_setup_list->jc_bom_wastage->Lookup->toClientList() ?>;
fcarpet_setuplist.lists["x_jc_bom_wastage"].options = <?php echo JsonEncode($carpet_setup_list->jc_bom_wastage->options(FALSE, TRUE)) ?>;
fcarpet_setuplist.lists["x_batch_authorized_id"] = <?php echo $carpet_setup_list->batch_authorized_id->Lookup->toClientList() ?>;
fcarpet_setuplist.lists["x_batch_authorized_id"].options = <?php echo JsonEncode($carpet_setup_list->batch_authorized_id->lookupOptions()) ?>;
fcarpet_setuplist.lists["x_tufting_plan_sgrp[]"] = <?php echo $carpet_setup_list->tufting_plan_sgrp->Lookup->toClientList() ?>;
fcarpet_setuplist.lists["x_tufting_plan_sgrp[]"].options = <?php echo JsonEncode($carpet_setup_list->tufting_plan_sgrp->lookupOptions()) ?>;
fcarpet_setuplist.lists["x_tufting_plan_loom_group"] = <?php echo $carpet_setup_list->tufting_plan_loom_group->Lookup->toClientList() ?>;
fcarpet_setuplist.lists["x_tufting_plan_loom_group"].options = <?php echo JsonEncode($carpet_setup_list->tufting_plan_loom_group->options(FALSE, TRUE)) ?>;
fcarpet_setuplist.lists["x_jc_material_issue"] = <?php echo $carpet_setup_list->jc_material_issue->Lookup->toClientList() ?>;
fcarpet_setuplist.lists["x_jc_material_issue"].options = <?php echo JsonEncode($carpet_setup_list->jc_material_issue->options(FALSE, TRUE)) ?>;

// Form object for search
var fcarpet_setuplistsrch = currentSearchForm = new ew.Form("fcarpet_setuplistsrch");

// Filters
fcarpet_setuplistsrch.filterList = <?php echo $carpet_setup_list->getFilterList() ?>;

// Init search panel as collapsed
fcarpet_setuplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$carpet_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($carpet_setup_list->TotalRecs > 0 && $carpet_setup_list->ExportOptions->visible()) { ?>
<?php $carpet_setup_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($carpet_setup_list->ImportOptions->visible()) { ?>
<?php $carpet_setup_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($carpet_setup_list->SearchOptions->visible()) { ?>
<?php $carpet_setup_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($carpet_setup_list->FilterOptions->visible()) { ?>
<?php $carpet_setup_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$carpet_setup_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$carpet_setup->isExport() && !$carpet_setup->CurrentAction) { ?>
<form name="fcarpet_setuplistsrch" id="fcarpet_setuplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($carpet_setup_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcarpet_setuplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="carpet_setup">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($carpet_setup_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($carpet_setup_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $carpet_setup_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($carpet_setup_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($carpet_setup_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($carpet_setup_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($carpet_setup_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $carpet_setup_list->showPageHeader(); ?>
<?php
$carpet_setup_list->showMessage();
?>
<?php if ($carpet_setup_list->TotalRecs > 0 || $carpet_setup->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($carpet_setup_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> carpet_setup">
<?php if (!$carpet_setup->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$carpet_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($carpet_setup_list->Pager)) $carpet_setup_list->Pager = new PrevNextPager($carpet_setup_list->StartRec, $carpet_setup_list->DisplayRecs, $carpet_setup_list->TotalRecs, $carpet_setup_list->AutoHidePager) ?>
<?php if ($carpet_setup_list->Pager->RecordCount > 0 && $carpet_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($carpet_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($carpet_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $carpet_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($carpet_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($carpet_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $carpet_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($carpet_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $carpet_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $carpet_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $carpet_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($carpet_setup_list->TotalRecs > 0 && (!$carpet_setup_list->AutoHidePageSizeSelector || $carpet_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="carpet_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($carpet_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($carpet_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($carpet_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($carpet_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($carpet_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($carpet_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $carpet_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcarpet_setuplist" id="fcarpet_setuplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($carpet_setup_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $carpet_setup_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="carpet_setup">
<div id="gmp_carpet_setup" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($carpet_setup_list->TotalRecs > 0 || $carpet_setup->isGridEdit()) { ?>
<table id="tbl_carpet_setuplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$carpet_setup_list->RowType = ROWTYPE_HEADER;

// Render list options
$carpet_setup_list->renderListOptions();

// Render list options (header, left)
$carpet_setup_list->ListOptions->render("header", "left");
?>
<?php if ($carpet_setup->id->Visible) { // id ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->id) == "") { ?>
		<th data-name="id" class="<?php echo $carpet_setup->id->headerCellClass() ?>"><div id="elh_carpet_setup_id" class="carpet_setup_id"><div class="ew-table-header-caption"><?php echo $carpet_setup->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $carpet_setup->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->id) ?>',2);"><div id="elh_carpet_setup_id" class="carpet_setup_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->cs_min_width->Visible) { // cs_min_width ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->cs_min_width) == "") { ?>
		<th data-name="cs_min_width" class="<?php echo $carpet_setup->cs_min_width->headerCellClass() ?>"><div id="elh_carpet_setup_cs_min_width" class="carpet_setup_cs_min_width"><div class="ew-table-header-caption"><?php echo $carpet_setup->cs_min_width->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs_min_width" class="<?php echo $carpet_setup->cs_min_width->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->cs_min_width) ?>',2);"><div id="elh_carpet_setup_cs_min_width" class="carpet_setup_cs_min_width">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->cs_min_width->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->cs_min_width->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->cs_min_width->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->cs_min_qty->Visible) { // cs_min_qty ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->cs_min_qty) == "") { ?>
		<th data-name="cs_min_qty" class="<?php echo $carpet_setup->cs_min_qty->headerCellClass() ?>"><div id="elh_carpet_setup_cs_min_qty" class="carpet_setup_cs_min_qty"><div class="ew-table-header-caption"><?php echo $carpet_setup->cs_min_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs_min_qty" class="<?php echo $carpet_setup->cs_min_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->cs_min_qty) ?>',2);"><div id="elh_carpet_setup_cs_min_qty" class="carpet_setup_cs_min_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->cs_min_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->cs_min_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->cs_min_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->payment_sqm->Visible) { // payment_sqm ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->payment_sqm) == "") { ?>
		<th data-name="payment_sqm" class="<?php echo $carpet_setup->payment_sqm->headerCellClass() ?>"><div id="elh_carpet_setup_payment_sqm" class="carpet_setup_payment_sqm"><div class="ew-table-header-caption"><?php echo $carpet_setup->payment_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_sqm" class="<?php echo $carpet_setup->payment_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->payment_sqm) ?>',2);"><div id="elh_carpet_setup_payment_sqm" class="carpet_setup_payment_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->payment_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->payment_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->payment_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->process_byepass->Visible) { // process_byepass ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->process_byepass) == "") { ?>
		<th data-name="process_byepass" class="<?php echo $carpet_setup->process_byepass->headerCellClass() ?>"><div id="elh_carpet_setup_process_byepass" class="carpet_setup_process_byepass"><div class="ew-table-header-caption"><?php echo $carpet_setup->process_byepass->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_byepass" class="<?php echo $carpet_setup->process_byepass->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->process_byepass) ?>',2);"><div id="elh_carpet_setup_process_byepass" class="carpet_setup_process_byepass">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->process_byepass->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->process_byepass->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->process_byepass->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->jc_bom_wastage->Visible) { // jc_bom_wastage ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->jc_bom_wastage) == "") { ?>
		<th data-name="jc_bom_wastage" class="<?php echo $carpet_setup->jc_bom_wastage->headerCellClass() ?>"><div id="elh_carpet_setup_jc_bom_wastage" class="carpet_setup_jc_bom_wastage"><div class="ew-table-header-caption"><?php echo $carpet_setup->jc_bom_wastage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_bom_wastage" class="<?php echo $carpet_setup->jc_bom_wastage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->jc_bom_wastage) ?>',2);"><div id="elh_carpet_setup_jc_bom_wastage" class="carpet_setup_jc_bom_wastage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->jc_bom_wastage->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->jc_bom_wastage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->jc_bom_wastage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->bom_1000->Visible) { // bom_1000 ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->bom_1000) == "") { ?>
		<th data-name="bom_1000" class="<?php echo $carpet_setup->bom_1000->headerCellClass() ?>"><div id="elh_carpet_setup_bom_1000" class="carpet_setup_bom_1000"><div class="ew-table-header-caption"><?php echo $carpet_setup->bom_1000->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bom_1000" class="<?php echo $carpet_setup->bom_1000->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->bom_1000) ?>',2);"><div id="elh_carpet_setup_bom_1000" class="carpet_setup_bom_1000">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->bom_1000->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->bom_1000->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->bom_1000->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->batch_authorized_id->Visible) { // batch_authorized_id ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->batch_authorized_id) == "") { ?>
		<th data-name="batch_authorized_id" class="<?php echo $carpet_setup->batch_authorized_id->headerCellClass() ?>"><div id="elh_carpet_setup_batch_authorized_id" class="carpet_setup_batch_authorized_id"><div class="ew-table-header-caption"><?php echo $carpet_setup->batch_authorized_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_authorized_id" class="<?php echo $carpet_setup->batch_authorized_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->batch_authorized_id) ?>',2);"><div id="elh_carpet_setup_batch_authorized_id" class="carpet_setup_batch_authorized_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->batch_authorized_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->batch_authorized_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->batch_authorized_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_sgrp->Visible) { // tufting_plan_sgrp ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->tufting_plan_sgrp) == "") { ?>
		<th data-name="tufting_plan_sgrp" class="<?php echo $carpet_setup->tufting_plan_sgrp->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_plan_sgrp" class="carpet_setup_tufting_plan_sgrp"><div class="ew-table-header-caption"><?php echo $carpet_setup->tufting_plan_sgrp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tufting_plan_sgrp" class="<?php echo $carpet_setup->tufting_plan_sgrp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->tufting_plan_sgrp) ?>',2);"><div id="elh_carpet_setup_tufting_plan_sgrp" class="carpet_setup_tufting_plan_sgrp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->tufting_plan_sgrp->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->tufting_plan_sgrp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->tufting_plan_sgrp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_loom_group->Visible) { // tufting_plan_loom_group ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->tufting_plan_loom_group) == "") { ?>
		<th data-name="tufting_plan_loom_group" class="<?php echo $carpet_setup->tufting_plan_loom_group->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_plan_loom_group" class="carpet_setup_tufting_plan_loom_group"><div class="ew-table-header-caption"><?php echo $carpet_setup->tufting_plan_loom_group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tufting_plan_loom_group" class="<?php echo $carpet_setup->tufting_plan_loom_group->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->tufting_plan_loom_group) ?>',2);"><div id="elh_carpet_setup_tufting_plan_loom_group" class="carpet_setup_tufting_plan_loom_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->tufting_plan_loom_group->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->tufting_plan_loom_group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->tufting_plan_loom_group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->jc_weeks->Visible) { // jc_weeks ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->jc_weeks) == "") { ?>
		<th data-name="jc_weeks" class="<?php echo $carpet_setup->jc_weeks->headerCellClass() ?>"><div id="elh_carpet_setup_jc_weeks" class="carpet_setup_jc_weeks"><div class="ew-table-header-caption"><?php echo $carpet_setup->jc_weeks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_weeks" class="<?php echo $carpet_setup->jc_weeks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->jc_weeks) ?>',2);"><div id="elh_carpet_setup_jc_weeks" class="carpet_setup_jc_weeks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->jc_weeks->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->jc_weeks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->jc_weeks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->required_material_overall_update->Visible) { // required_material_overall_update ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->required_material_overall_update) == "") { ?>
		<th data-name="required_material_overall_update" class="<?php echo $carpet_setup->required_material_overall_update->headerCellClass() ?>"><div id="elh_carpet_setup_required_material_overall_update" class="carpet_setup_required_material_overall_update"><div class="ew-table-header-caption"><?php echo $carpet_setup->required_material_overall_update->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="required_material_overall_update" class="<?php echo $carpet_setup->required_material_overall_update->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->required_material_overall_update) ?>',2);"><div id="elh_carpet_setup_required_material_overall_update" class="carpet_setup_required_material_overall_update">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->required_material_overall_update->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->required_material_overall_update->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->required_material_overall_update->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->jc_material_issue->Visible) { // jc_material_issue ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->jc_material_issue) == "") { ?>
		<th data-name="jc_material_issue" class="<?php echo $carpet_setup->jc_material_issue->headerCellClass() ?>"><div id="elh_carpet_setup_jc_material_issue" class="carpet_setup_jc_material_issue"><div class="ew-table-header-caption"><?php echo $carpet_setup->jc_material_issue->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_material_issue" class="<?php echo $carpet_setup->jc_material_issue->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->jc_material_issue) ?>',2);"><div id="elh_carpet_setup_jc_material_issue" class="carpet_setup_jc_material_issue">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->jc_material_issue->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->jc_material_issue->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->jc_material_issue->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->operator->Visible) { // operator ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $carpet_setup->operator->headerCellClass() ?>"><div id="elh_carpet_setup_operator" class="carpet_setup_operator"><div class="ew-table-header-caption"><?php echo $carpet_setup->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $carpet_setup->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->operator) ?>',2);"><div id="elh_carpet_setup_operator" class="carpet_setup_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->datetime->Visible) { // datetime ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $carpet_setup->datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_carpet_setup_datetime" class="carpet_setup_datetime"><div class="ew-table-header-caption"><?php echo $carpet_setup->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $carpet_setup->datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->datetime) ?>',2);"><div id="elh_carpet_setup_datetime" class="carpet_setup_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->jc_qr->Visible) { // jc_qr ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->jc_qr) == "") { ?>
		<th data-name="jc_qr" class="<?php echo $carpet_setup->jc_qr->headerCellClass() ?>"><div id="elh_carpet_setup_jc_qr" class="carpet_setup_jc_qr"><div class="ew-table-header-caption"><?php echo $carpet_setup->jc_qr->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_qr" class="<?php echo $carpet_setup->jc_qr->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->jc_qr) ?>',2);"><div id="elh_carpet_setup_jc_qr" class="carpet_setup_jc_qr">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->jc_qr->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->jc_qr->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->jc_qr->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->tufting_performance_percent->Visible) { // tufting_performance_percent ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->tufting_performance_percent) == "") { ?>
		<th data-name="tufting_performance_percent" class="<?php echo $carpet_setup->tufting_performance_percent->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_performance_percent" class="carpet_setup_tufting_performance_percent"><div class="ew-table-header-caption"><?php echo $carpet_setup->tufting_performance_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tufting_performance_percent" class="<?php echo $carpet_setup->tufting_performance_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->tufting_performance_percent) ?>',2);"><div id="elh_carpet_setup_tufting_performance_percent" class="carpet_setup_tufting_performance_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->tufting_performance_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->tufting_performance_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->tufting_performance_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->jc_mrlot->Visible) { // jc_mrlot ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->jc_mrlot) == "") { ?>
		<th data-name="jc_mrlot" class="<?php echo $carpet_setup->jc_mrlot->headerCellClass() ?>"><div id="elh_carpet_setup_jc_mrlot" class="carpet_setup_jc_mrlot"><div class="ew-table-header-caption"><?php echo $carpet_setup->jc_mrlot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_mrlot" class="<?php echo $carpet_setup->jc_mrlot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->jc_mrlot) ?>',2);"><div id="elh_carpet_setup_jc_mrlot" class="carpet_setup_jc_mrlot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->jc_mrlot->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->jc_mrlot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->jc_mrlot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->batch_pp_id->Visible) { // batch_pp_id ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->batch_pp_id) == "") { ?>
		<th data-name="batch_pp_id" class="<?php echo $carpet_setup->batch_pp_id->headerCellClass() ?>"><div id="elh_carpet_setup_batch_pp_id" class="carpet_setup_batch_pp_id"><div class="ew-table-header-caption"><?php echo $carpet_setup->batch_pp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_pp_id" class="<?php echo $carpet_setup->batch_pp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->batch_pp_id) ?>',2);"><div id="elh_carpet_setup_batch_pp_id" class="carpet_setup_batch_pp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->batch_pp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->batch_pp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->batch_pp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_active->Visible) { // tufting_plan_active ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->tufting_plan_active) == "") { ?>
		<th data-name="tufting_plan_active" class="<?php echo $carpet_setup->tufting_plan_active->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_plan_active" class="carpet_setup_tufting_plan_active"><div class="ew-table-header-caption"><?php echo $carpet_setup->tufting_plan_active->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tufting_plan_active" class="<?php echo $carpet_setup->tufting_plan_active->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->tufting_plan_active) ?>',2);"><div id="elh_carpet_setup_tufting_plan_active" class="carpet_setup_tufting_plan_active">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->tufting_plan_active->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->tufting_plan_active->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->tufting_plan_active->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->max_jobcard->Visible) { // max_jobcard ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->max_jobcard) == "") { ?>
		<th data-name="max_jobcard" class="<?php echo $carpet_setup->max_jobcard->headerCellClass() ?>"><div id="elh_carpet_setup_max_jobcard" class="carpet_setup_max_jobcard"><div class="ew-table-header-caption"><?php echo $carpet_setup->max_jobcard->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_jobcard" class="<?php echo $carpet_setup->max_jobcard->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->max_jobcard) ?>',2);"><div id="elh_carpet_setup_max_jobcard" class="carpet_setup_max_jobcard">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->max_jobcard->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->max_jobcard->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->max_jobcard->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->jc_pending_delete_days->Visible) { // jc_pending_delete_days ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->jc_pending_delete_days) == "") { ?>
		<th data-name="jc_pending_delete_days" class="<?php echo $carpet_setup->jc_pending_delete_days->headerCellClass() ?>"><div id="elh_carpet_setup_jc_pending_delete_days" class="carpet_setup_jc_pending_delete_days"><div class="ew-table-header-caption"><?php echo $carpet_setup->jc_pending_delete_days->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_pending_delete_days" class="<?php echo $carpet_setup->jc_pending_delete_days->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->jc_pending_delete_days) ?>',2);"><div id="elh_carpet_setup_jc_pending_delete_days" class="carpet_setup_jc_pending_delete_days">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->jc_pending_delete_days->caption() ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->jc_pending_delete_days->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->jc_pending_delete_days->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($carpet_setup->payment_sqm_byepass_category->Visible) { // payment_sqm_byepass_category ?>
	<?php if ($carpet_setup->sortUrl($carpet_setup->payment_sqm_byepass_category) == "") { ?>
		<th data-name="payment_sqm_byepass_category" class="<?php echo $carpet_setup->payment_sqm_byepass_category->headerCellClass() ?>"><div id="elh_carpet_setup_payment_sqm_byepass_category" class="carpet_setup_payment_sqm_byepass_category"><div class="ew-table-header-caption"><?php echo $carpet_setup->payment_sqm_byepass_category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_sqm_byepass_category" class="<?php echo $carpet_setup->payment_sqm_byepass_category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $carpet_setup->SortUrl($carpet_setup->payment_sqm_byepass_category) ?>',2);"><div id="elh_carpet_setup_payment_sqm_byepass_category" class="carpet_setup_payment_sqm_byepass_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $carpet_setup->payment_sqm_byepass_category->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($carpet_setup->payment_sqm_byepass_category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($carpet_setup->payment_sqm_byepass_category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$carpet_setup_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($carpet_setup->ExportAll && $carpet_setup->isExport()) {
	$carpet_setup_list->StopRec = $carpet_setup_list->TotalRecs;
} else {

	// Set the last record to display
	if ($carpet_setup_list->TotalRecs > $carpet_setup_list->StartRec + $carpet_setup_list->DisplayRecs - 1)
		$carpet_setup_list->StopRec = $carpet_setup_list->StartRec + $carpet_setup_list->DisplayRecs - 1;
	else
		$carpet_setup_list->StopRec = $carpet_setup_list->TotalRecs;
}
$carpet_setup_list->RecCnt = $carpet_setup_list->StartRec - 1;
if ($carpet_setup_list->Recordset && !$carpet_setup_list->Recordset->EOF) {
	$carpet_setup_list->Recordset->moveFirst();
	$selectLimit = $carpet_setup_list->UseSelectLimit;
	if (!$selectLimit && $carpet_setup_list->StartRec > 1)
		$carpet_setup_list->Recordset->move($carpet_setup_list->StartRec - 1);
} elseif (!$carpet_setup->AllowAddDeleteRow && $carpet_setup_list->StopRec == 0) {
	$carpet_setup_list->StopRec = $carpet_setup->GridAddRowCount;
}

// Initialize aggregate
$carpet_setup->RowType = ROWTYPE_AGGREGATEINIT;
$carpet_setup->resetAttributes();
$carpet_setup_list->renderRow();
while ($carpet_setup_list->RecCnt < $carpet_setup_list->StopRec) {
	$carpet_setup_list->RecCnt++;
	if ($carpet_setup_list->RecCnt >= $carpet_setup_list->StartRec) {
		$carpet_setup_list->RowCnt++;

		// Set up key count
		$carpet_setup_list->KeyCount = $carpet_setup_list->RowIndex;

		// Init row class and style
		$carpet_setup->resetAttributes();
		$carpet_setup->CssClass = "";
		if ($carpet_setup->isGridAdd()) {
		} else {
			$carpet_setup_list->loadRowValues($carpet_setup_list->Recordset); // Load row values
		}
		$carpet_setup->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$carpet_setup->RowAttrs = array_merge($carpet_setup->RowAttrs, array('data-rowindex'=>$carpet_setup_list->RowCnt, 'id'=>'r' . $carpet_setup_list->RowCnt . '_carpet_setup', 'data-rowtype'=>$carpet_setup->RowType));

		// Render row
		$carpet_setup_list->renderRow();

		// Render list options
		$carpet_setup_list->renderListOptions();
?>
	<tr<?php echo $carpet_setup->rowAttributes() ?>>
<?php

// Render list options (body, left)
$carpet_setup_list->ListOptions->render("body", "left", $carpet_setup_list->RowCnt);
?>
	<?php if ($carpet_setup->id->Visible) { // id ?>
		<td data-name="id"<?php echo $carpet_setup->id->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_id" class="carpet_setup_id">
<span<?php echo $carpet_setup->id->viewAttributes() ?>>
<?php echo $carpet_setup->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->cs_min_width->Visible) { // cs_min_width ?>
		<td data-name="cs_min_width"<?php echo $carpet_setup->cs_min_width->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_cs_min_width" class="carpet_setup_cs_min_width">
<span<?php echo $carpet_setup->cs_min_width->viewAttributes() ?>>
<?php echo $carpet_setup->cs_min_width->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->cs_min_qty->Visible) { // cs_min_qty ?>
		<td data-name="cs_min_qty"<?php echo $carpet_setup->cs_min_qty->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_cs_min_qty" class="carpet_setup_cs_min_qty">
<span<?php echo $carpet_setup->cs_min_qty->viewAttributes() ?>>
<?php echo $carpet_setup->cs_min_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->payment_sqm->Visible) { // payment_sqm ?>
		<td data-name="payment_sqm"<?php echo $carpet_setup->payment_sqm->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_payment_sqm" class="carpet_setup_payment_sqm">
<span<?php echo $carpet_setup->payment_sqm->viewAttributes() ?>>
<?php echo $carpet_setup->payment_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->process_byepass->Visible) { // process_byepass ?>
		<td data-name="process_byepass"<?php echo $carpet_setup->process_byepass->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_process_byepass" class="carpet_setup_process_byepass">
<span<?php echo $carpet_setup->process_byepass->viewAttributes() ?>>
<?php echo $carpet_setup->process_byepass->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->jc_bom_wastage->Visible) { // jc_bom_wastage ?>
		<td data-name="jc_bom_wastage"<?php echo $carpet_setup->jc_bom_wastage->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_jc_bom_wastage" class="carpet_setup_jc_bom_wastage">
<span<?php echo $carpet_setup->jc_bom_wastage->viewAttributes() ?>>
<?php echo $carpet_setup->jc_bom_wastage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->bom_1000->Visible) { // bom_1000 ?>
		<td data-name="bom_1000"<?php echo $carpet_setup->bom_1000->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_bom_1000" class="carpet_setup_bom_1000">
<span<?php echo $carpet_setup->bom_1000->viewAttributes() ?>>
<?php echo $carpet_setup->bom_1000->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->batch_authorized_id->Visible) { // batch_authorized_id ?>
		<td data-name="batch_authorized_id"<?php echo $carpet_setup->batch_authorized_id->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_batch_authorized_id" class="carpet_setup_batch_authorized_id">
<span<?php echo $carpet_setup->batch_authorized_id->viewAttributes() ?>>
<?php echo $carpet_setup->batch_authorized_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->tufting_plan_sgrp->Visible) { // tufting_plan_sgrp ?>
		<td data-name="tufting_plan_sgrp"<?php echo $carpet_setup->tufting_plan_sgrp->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_tufting_plan_sgrp" class="carpet_setup_tufting_plan_sgrp">
<span<?php echo $carpet_setup->tufting_plan_sgrp->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_plan_sgrp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->tufting_plan_loom_group->Visible) { // tufting_plan_loom_group ?>
		<td data-name="tufting_plan_loom_group"<?php echo $carpet_setup->tufting_plan_loom_group->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_tufting_plan_loom_group" class="carpet_setup_tufting_plan_loom_group">
<span<?php echo $carpet_setup->tufting_plan_loom_group->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_plan_loom_group->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->jc_weeks->Visible) { // jc_weeks ?>
		<td data-name="jc_weeks"<?php echo $carpet_setup->jc_weeks->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_jc_weeks" class="carpet_setup_jc_weeks">
<span<?php echo $carpet_setup->jc_weeks->viewAttributes() ?>>
<?php echo $carpet_setup->jc_weeks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->required_material_overall_update->Visible) { // required_material_overall_update ?>
		<td data-name="required_material_overall_update"<?php echo $carpet_setup->required_material_overall_update->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_required_material_overall_update" class="carpet_setup_required_material_overall_update">
<span<?php echo $carpet_setup->required_material_overall_update->viewAttributes() ?>>
<?php echo $carpet_setup->required_material_overall_update->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->jc_material_issue->Visible) { // jc_material_issue ?>
		<td data-name="jc_material_issue"<?php echo $carpet_setup->jc_material_issue->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_jc_material_issue" class="carpet_setup_jc_material_issue">
<span<?php echo $carpet_setup->jc_material_issue->viewAttributes() ?>>
<?php echo $carpet_setup->jc_material_issue->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $carpet_setup->operator->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_operator" class="carpet_setup_operator">
<span<?php echo $carpet_setup->operator->viewAttributes() ?>>
<?php echo $carpet_setup->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $carpet_setup->datetime->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_datetime" class="carpet_setup_datetime">
<span<?php echo $carpet_setup->datetime->viewAttributes() ?>>
<?php echo $carpet_setup->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->jc_qr->Visible) { // jc_qr ?>
		<td data-name="jc_qr"<?php echo $carpet_setup->jc_qr->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_jc_qr" class="carpet_setup_jc_qr">
<span<?php echo $carpet_setup->jc_qr->viewAttributes() ?>>
<?php echo $carpet_setup->jc_qr->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->tufting_performance_percent->Visible) { // tufting_performance_percent ?>
		<td data-name="tufting_performance_percent"<?php echo $carpet_setup->tufting_performance_percent->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_tufting_performance_percent" class="carpet_setup_tufting_performance_percent">
<span<?php echo $carpet_setup->tufting_performance_percent->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_performance_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->jc_mrlot->Visible) { // jc_mrlot ?>
		<td data-name="jc_mrlot"<?php echo $carpet_setup->jc_mrlot->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_jc_mrlot" class="carpet_setup_jc_mrlot">
<span<?php echo $carpet_setup->jc_mrlot->viewAttributes() ?>>
<?php echo $carpet_setup->jc_mrlot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->batch_pp_id->Visible) { // batch_pp_id ?>
		<td data-name="batch_pp_id"<?php echo $carpet_setup->batch_pp_id->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_batch_pp_id" class="carpet_setup_batch_pp_id">
<span<?php echo $carpet_setup->batch_pp_id->viewAttributes() ?>>
<?php echo $carpet_setup->batch_pp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->tufting_plan_active->Visible) { // tufting_plan_active ?>
		<td data-name="tufting_plan_active"<?php echo $carpet_setup->tufting_plan_active->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_tufting_plan_active" class="carpet_setup_tufting_plan_active">
<span<?php echo $carpet_setup->tufting_plan_active->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_plan_active->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->max_jobcard->Visible) { // max_jobcard ?>
		<td data-name="max_jobcard"<?php echo $carpet_setup->max_jobcard->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_max_jobcard" class="carpet_setup_max_jobcard">
<span<?php echo $carpet_setup->max_jobcard->viewAttributes() ?>>
<?php echo $carpet_setup->max_jobcard->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->jc_pending_delete_days->Visible) { // jc_pending_delete_days ?>
		<td data-name="jc_pending_delete_days"<?php echo $carpet_setup->jc_pending_delete_days->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_jc_pending_delete_days" class="carpet_setup_jc_pending_delete_days">
<span<?php echo $carpet_setup->jc_pending_delete_days->viewAttributes() ?>>
<?php echo $carpet_setup->jc_pending_delete_days->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($carpet_setup->payment_sqm_byepass_category->Visible) { // payment_sqm_byepass_category ?>
		<td data-name="payment_sqm_byepass_category"<?php echo $carpet_setup->payment_sqm_byepass_category->cellAttributes() ?>>
<span id="el<?php echo $carpet_setup_list->RowCnt ?>_carpet_setup_payment_sqm_byepass_category" class="carpet_setup_payment_sqm_byepass_category">
<span<?php echo $carpet_setup->payment_sqm_byepass_category->viewAttributes() ?>>
<?php echo $carpet_setup->payment_sqm_byepass_category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$carpet_setup_list->ListOptions->render("body", "right", $carpet_setup_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$carpet_setup->isGridAdd())
		$carpet_setup_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$carpet_setup->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($carpet_setup_list->Recordset)
	$carpet_setup_list->Recordset->Close();
?>
<?php if (!$carpet_setup->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$carpet_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($carpet_setup_list->Pager)) $carpet_setup_list->Pager = new PrevNextPager($carpet_setup_list->StartRec, $carpet_setup_list->DisplayRecs, $carpet_setup_list->TotalRecs, $carpet_setup_list->AutoHidePager) ?>
<?php if ($carpet_setup_list->Pager->RecordCount > 0 && $carpet_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($carpet_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($carpet_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $carpet_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($carpet_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($carpet_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $carpet_setup_list->pageUrl() ?>start=<?php echo $carpet_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $carpet_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($carpet_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $carpet_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $carpet_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $carpet_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($carpet_setup_list->TotalRecs > 0 && (!$carpet_setup_list->AutoHidePageSizeSelector || $carpet_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="carpet_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($carpet_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($carpet_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($carpet_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($carpet_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($carpet_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($carpet_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $carpet_setup_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($carpet_setup_list->TotalRecs == 0 && !$carpet_setup->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $carpet_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$carpet_setup_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$carpet_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$carpet_setup->isExport()) { ?>
<script>
ew.scrollableTable("gmp_carpet_setup", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$carpet_setup_list->terminate();
?>