<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$carpet_setup_view = new carpet_setup_view();

// Run the page
$carpet_setup_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$carpet_setup_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$carpet_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcarpet_setupview = currentForm = new ew.Form("fcarpet_setupview", "view");

// Form_CustomValidate event
fcarpet_setupview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcarpet_setupview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcarpet_setupview.lists["x_payment_sqm"] = <?php echo $carpet_setup_view->payment_sqm->Lookup->toClientList() ?>;
fcarpet_setupview.lists["x_payment_sqm"].options = <?php echo JsonEncode($carpet_setup_view->payment_sqm->options(FALSE, TRUE)) ?>;
fcarpet_setupview.lists["x_process_byepass"] = <?php echo $carpet_setup_view->process_byepass->Lookup->toClientList() ?>;
fcarpet_setupview.lists["x_process_byepass"].options = <?php echo JsonEncode($carpet_setup_view->process_byepass->options(FALSE, TRUE)) ?>;
fcarpet_setupview.lists["x_jc_bom_wastage"] = <?php echo $carpet_setup_view->jc_bom_wastage->Lookup->toClientList() ?>;
fcarpet_setupview.lists["x_jc_bom_wastage"].options = <?php echo JsonEncode($carpet_setup_view->jc_bom_wastage->options(FALSE, TRUE)) ?>;
fcarpet_setupview.lists["x_batch_authorized_id"] = <?php echo $carpet_setup_view->batch_authorized_id->Lookup->toClientList() ?>;
fcarpet_setupview.lists["x_batch_authorized_id"].options = <?php echo JsonEncode($carpet_setup_view->batch_authorized_id->lookupOptions()) ?>;
fcarpet_setupview.lists["x_tufting_plan_sgrp[]"] = <?php echo $carpet_setup_view->tufting_plan_sgrp->Lookup->toClientList() ?>;
fcarpet_setupview.lists["x_tufting_plan_sgrp[]"].options = <?php echo JsonEncode($carpet_setup_view->tufting_plan_sgrp->lookupOptions()) ?>;
fcarpet_setupview.lists["x_tufting_plan_loom_group"] = <?php echo $carpet_setup_view->tufting_plan_loom_group->Lookup->toClientList() ?>;
fcarpet_setupview.lists["x_tufting_plan_loom_group"].options = <?php echo JsonEncode($carpet_setup_view->tufting_plan_loom_group->options(FALSE, TRUE)) ?>;
fcarpet_setupview.lists["x_jc_material_issue"] = <?php echo $carpet_setup_view->jc_material_issue->Lookup->toClientList() ?>;
fcarpet_setupview.lists["x_jc_material_issue"].options = <?php echo JsonEncode($carpet_setup_view->jc_material_issue->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$carpet_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $carpet_setup_view->ExportOptions->render("body") ?>
<?php $carpet_setup_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $carpet_setup_view->showPageHeader(); ?>
<?php
$carpet_setup_view->showMessage();
?>
<form name="fcarpet_setupview" id="fcarpet_setupview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($carpet_setup_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $carpet_setup_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="carpet_setup">
<input type="hidden" name="modal" value="<?php echo (int)$carpet_setup_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($carpet_setup->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_id"><?php echo $carpet_setup->id->caption() ?></span></td>
		<td data-name="id"<?php echo $carpet_setup->id->cellAttributes() ?>>
<span id="el_carpet_setup_id">
<span<?php echo $carpet_setup->id->viewAttributes() ?>>
<?php echo $carpet_setup->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->cs_min_width->Visible) { // cs_min_width ?>
	<tr id="r_cs_min_width">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_cs_min_width"><?php echo $carpet_setup->cs_min_width->caption() ?></span></td>
		<td data-name="cs_min_width"<?php echo $carpet_setup->cs_min_width->cellAttributes() ?>>
<span id="el_carpet_setup_cs_min_width">
<span<?php echo $carpet_setup->cs_min_width->viewAttributes() ?>>
<?php echo $carpet_setup->cs_min_width->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->cs_min_qty->Visible) { // cs_min_qty ?>
	<tr id="r_cs_min_qty">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_cs_min_qty"><?php echo $carpet_setup->cs_min_qty->caption() ?></span></td>
		<td data-name="cs_min_qty"<?php echo $carpet_setup->cs_min_qty->cellAttributes() ?>>
<span id="el_carpet_setup_cs_min_qty">
<span<?php echo $carpet_setup->cs_min_qty->viewAttributes() ?>>
<?php echo $carpet_setup->cs_min_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->payment_sqm->Visible) { // payment_sqm ?>
	<tr id="r_payment_sqm">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_payment_sqm"><?php echo $carpet_setup->payment_sqm->caption() ?></span></td>
		<td data-name="payment_sqm"<?php echo $carpet_setup->payment_sqm->cellAttributes() ?>>
<span id="el_carpet_setup_payment_sqm">
<span<?php echo $carpet_setup->payment_sqm->viewAttributes() ?>>
<?php echo $carpet_setup->payment_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->process_byepass->Visible) { // process_byepass ?>
	<tr id="r_process_byepass">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_process_byepass"><?php echo $carpet_setup->process_byepass->caption() ?></span></td>
		<td data-name="process_byepass"<?php echo $carpet_setup->process_byepass->cellAttributes() ?>>
<span id="el_carpet_setup_process_byepass">
<span<?php echo $carpet_setup->process_byepass->viewAttributes() ?>>
<?php echo $carpet_setup->process_byepass->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->jc_bom_wastage->Visible) { // jc_bom_wastage ?>
	<tr id="r_jc_bom_wastage">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_jc_bom_wastage"><?php echo $carpet_setup->jc_bom_wastage->caption() ?></span></td>
		<td data-name="jc_bom_wastage"<?php echo $carpet_setup->jc_bom_wastage->cellAttributes() ?>>
<span id="el_carpet_setup_jc_bom_wastage">
<span<?php echo $carpet_setup->jc_bom_wastage->viewAttributes() ?>>
<?php echo $carpet_setup->jc_bom_wastage->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->bom_1000->Visible) { // bom_1000 ?>
	<tr id="r_bom_1000">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_bom_1000"><?php echo $carpet_setup->bom_1000->caption() ?></span></td>
		<td data-name="bom_1000"<?php echo $carpet_setup->bom_1000->cellAttributes() ?>>
<span id="el_carpet_setup_bom_1000">
<span<?php echo $carpet_setup->bom_1000->viewAttributes() ?>>
<?php echo $carpet_setup->bom_1000->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->batch_authorized_id->Visible) { // batch_authorized_id ?>
	<tr id="r_batch_authorized_id">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_batch_authorized_id"><?php echo $carpet_setup->batch_authorized_id->caption() ?></span></td>
		<td data-name="batch_authorized_id"<?php echo $carpet_setup->batch_authorized_id->cellAttributes() ?>>
<span id="el_carpet_setup_batch_authorized_id">
<span<?php echo $carpet_setup->batch_authorized_id->viewAttributes() ?>>
<?php echo $carpet_setup->batch_authorized_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_sgrp->Visible) { // tufting_plan_sgrp ?>
	<tr id="r_tufting_plan_sgrp">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_tufting_plan_sgrp"><?php echo $carpet_setup->tufting_plan_sgrp->caption() ?></span></td>
		<td data-name="tufting_plan_sgrp"<?php echo $carpet_setup->tufting_plan_sgrp->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_plan_sgrp">
<span<?php echo $carpet_setup->tufting_plan_sgrp->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_plan_sgrp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_loom_group->Visible) { // tufting_plan_loom_group ?>
	<tr id="r_tufting_plan_loom_group">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_tufting_plan_loom_group"><?php echo $carpet_setup->tufting_plan_loom_group->caption() ?></span></td>
		<td data-name="tufting_plan_loom_group"<?php echo $carpet_setup->tufting_plan_loom_group->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_plan_loom_group">
<span<?php echo $carpet_setup->tufting_plan_loom_group->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_plan_loom_group->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->jc_weeks->Visible) { // jc_weeks ?>
	<tr id="r_jc_weeks">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_jc_weeks"><?php echo $carpet_setup->jc_weeks->caption() ?></span></td>
		<td data-name="jc_weeks"<?php echo $carpet_setup->jc_weeks->cellAttributes() ?>>
<span id="el_carpet_setup_jc_weeks">
<span<?php echo $carpet_setup->jc_weeks->viewAttributes() ?>>
<?php echo $carpet_setup->jc_weeks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->required_material_overall_update->Visible) { // required_material_overall_update ?>
	<tr id="r_required_material_overall_update">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_required_material_overall_update"><?php echo $carpet_setup->required_material_overall_update->caption() ?></span></td>
		<td data-name="required_material_overall_update"<?php echo $carpet_setup->required_material_overall_update->cellAttributes() ?>>
<span id="el_carpet_setup_required_material_overall_update">
<span<?php echo $carpet_setup->required_material_overall_update->viewAttributes() ?>>
<?php echo $carpet_setup->required_material_overall_update->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->jc_material_issue->Visible) { // jc_material_issue ?>
	<tr id="r_jc_material_issue">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_jc_material_issue"><?php echo $carpet_setup->jc_material_issue->caption() ?></span></td>
		<td data-name="jc_material_issue"<?php echo $carpet_setup->jc_material_issue->cellAttributes() ?>>
<span id="el_carpet_setup_jc_material_issue">
<span<?php echo $carpet_setup->jc_material_issue->viewAttributes() ?>>
<?php echo $carpet_setup->jc_material_issue->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_operator"><?php echo $carpet_setup->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $carpet_setup->operator->cellAttributes() ?>>
<span id="el_carpet_setup_operator">
<span<?php echo $carpet_setup->operator->viewAttributes() ?>>
<?php echo $carpet_setup->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_datetime"><?php echo $carpet_setup->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $carpet_setup->datetime->cellAttributes() ?>>
<span id="el_carpet_setup_datetime">
<span<?php echo $carpet_setup->datetime->viewAttributes() ?>>
<?php echo $carpet_setup->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->jc_qr->Visible) { // jc_qr ?>
	<tr id="r_jc_qr">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_jc_qr"><?php echo $carpet_setup->jc_qr->caption() ?></span></td>
		<td data-name="jc_qr"<?php echo $carpet_setup->jc_qr->cellAttributes() ?>>
<span id="el_carpet_setup_jc_qr">
<span<?php echo $carpet_setup->jc_qr->viewAttributes() ?>>
<?php echo $carpet_setup->jc_qr->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->tufting_performance_percent->Visible) { // tufting_performance_percent ?>
	<tr id="r_tufting_performance_percent">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_tufting_performance_percent"><?php echo $carpet_setup->tufting_performance_percent->caption() ?></span></td>
		<td data-name="tufting_performance_percent"<?php echo $carpet_setup->tufting_performance_percent->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_performance_percent">
<span<?php echo $carpet_setup->tufting_performance_percent->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_performance_percent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->jc_mrlot->Visible) { // jc_mrlot ?>
	<tr id="r_jc_mrlot">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_jc_mrlot"><?php echo $carpet_setup->jc_mrlot->caption() ?></span></td>
		<td data-name="jc_mrlot"<?php echo $carpet_setup->jc_mrlot->cellAttributes() ?>>
<span id="el_carpet_setup_jc_mrlot">
<span<?php echo $carpet_setup->jc_mrlot->viewAttributes() ?>>
<?php echo $carpet_setup->jc_mrlot->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->batch_pp_id->Visible) { // batch_pp_id ?>
	<tr id="r_batch_pp_id">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_batch_pp_id"><?php echo $carpet_setup->batch_pp_id->caption() ?></span></td>
		<td data-name="batch_pp_id"<?php echo $carpet_setup->batch_pp_id->cellAttributes() ?>>
<span id="el_carpet_setup_batch_pp_id">
<span<?php echo $carpet_setup->batch_pp_id->viewAttributes() ?>>
<?php echo $carpet_setup->batch_pp_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->tufting_plan_active->Visible) { // tufting_plan_active ?>
	<tr id="r_tufting_plan_active">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_tufting_plan_active"><?php echo $carpet_setup->tufting_plan_active->caption() ?></span></td>
		<td data-name="tufting_plan_active"<?php echo $carpet_setup->tufting_plan_active->cellAttributes() ?>>
<span id="el_carpet_setup_tufting_plan_active">
<span<?php echo $carpet_setup->tufting_plan_active->viewAttributes() ?>>
<?php echo $carpet_setup->tufting_plan_active->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->max_jobcard->Visible) { // max_jobcard ?>
	<tr id="r_max_jobcard">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_max_jobcard"><?php echo $carpet_setup->max_jobcard->caption() ?></span></td>
		<td data-name="max_jobcard"<?php echo $carpet_setup->max_jobcard->cellAttributes() ?>>
<span id="el_carpet_setup_max_jobcard">
<span<?php echo $carpet_setup->max_jobcard->viewAttributes() ?>>
<?php echo $carpet_setup->max_jobcard->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->jc_pending_delete_days->Visible) { // jc_pending_delete_days ?>
	<tr id="r_jc_pending_delete_days">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_jc_pending_delete_days"><?php echo $carpet_setup->jc_pending_delete_days->caption() ?></span></td>
		<td data-name="jc_pending_delete_days"<?php echo $carpet_setup->jc_pending_delete_days->cellAttributes() ?>>
<span id="el_carpet_setup_jc_pending_delete_days">
<span<?php echo $carpet_setup->jc_pending_delete_days->viewAttributes() ?>>
<?php echo $carpet_setup->jc_pending_delete_days->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($carpet_setup->payment_sqm_byepass_category->Visible) { // payment_sqm_byepass_category ?>
	<tr id="r_payment_sqm_byepass_category">
		<td class="<?php echo $carpet_setup_view->TableLeftColumnClass ?>"><span id="elh_carpet_setup_payment_sqm_byepass_category"><?php echo $carpet_setup->payment_sqm_byepass_category->caption() ?></span></td>
		<td data-name="payment_sqm_byepass_category"<?php echo $carpet_setup->payment_sqm_byepass_category->cellAttributes() ?>>
<span id="el_carpet_setup_payment_sqm_byepass_category">
<span<?php echo $carpet_setup->payment_sqm_byepass_category->viewAttributes() ?>>
<?php echo $carpet_setup->payment_sqm_byepass_category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$carpet_setup_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$carpet_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$carpet_setup_view->terminate();
?>