<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cha_agent_addopt = new cha_agent_addopt();

// Run the page
$cha_agent_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cha_agent_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fcha_agentaddopt = currentForm = new ew.Form("fcha_agentaddopt", "addopt");

// Validate form
fcha_agentaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($cha_agent_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cha_agent->grp->caption(), $cha_agent->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cha_agent_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cha_agent->name->caption(), $cha_agent->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cha_agent_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cha_agent->code->caption(), $cha_agent->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($cha_agent->code->errorMessage()) ?>");
		<?php if ($cha_agent_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cha_agent->status->caption(), $cha_agent->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cha_agent_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cha_agent->operator->caption(), $cha_agent->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cha_agent_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cha_agent->datetime->caption(), $cha_agent->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcha_agentaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcha_agentaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcha_agentaddopt.lists["x_grp"] = <?php echo $cha_agent_addopt->grp->Lookup->toClientList() ?>;
fcha_agentaddopt.lists["x_grp"].options = <?php echo JsonEncode($cha_agent_addopt->grp->options(FALSE, TRUE)) ?>;
fcha_agentaddopt.lists["x_status"] = <?php echo $cha_agent_addopt->status->Lookup->toClientList() ?>;
fcha_agentaddopt.lists["x_status"].options = <?php echo JsonEncode($cha_agent_addopt->status->options(FALSE, TRUE)) ?>;
fcha_agentaddopt.lists["x_operator"] = <?php echo $cha_agent_addopt->operator->Lookup->toClientList() ?>;
fcha_agentaddopt.lists["x_operator"].options = <?php echo JsonEncode($cha_agent_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cha_agent_addopt->showPageHeader(); ?>
<?php
$cha_agent_addopt->showMessage();
?>
<form name="fcha_agentaddopt" id="fcha_agentaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($cha_agent_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cha_agent_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $cha_agent_addopt->TableVar ?>">
<?php if ($cha_agent->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $cha_agent->grp->caption() ?><?php echo ($cha_agent->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cha_agent" data-field="x_grp" data-value-separator="<?php echo $cha_agent->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $cha_agent->grp->editAttributes() ?>>
		<?php echo $cha_agent->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $cha_agent->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($cha_agent->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $cha_agent->name->caption() ?><?php echo ($cha_agent->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cha_agent" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($cha_agent->name->getPlaceHolder()) ?>" value="<?php echo $cha_agent->name->EditValue ?>"<?php echo $cha_agent->name->editAttributes() ?>>
<?php echo $cha_agent->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($cha_agent->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $cha_agent->code->caption() ?><?php echo ($cha_agent->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cha_agent" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($cha_agent->code->getPlaceHolder()) ?>" value="<?php echo $cha_agent->code->EditValue ?>"<?php echo $cha_agent->code->editAttributes() ?>>
<?php echo $cha_agent->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($cha_agent->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $cha_agent->status->caption() ?><?php echo ($cha_agent->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cha_agent" data-field="x_status" data-value-separator="<?php echo $cha_agent->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $cha_agent->status->editAttributes() ?>>
		<?php echo $cha_agent->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $cha_agent->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($cha_agent->operator->Visible) { // operator ?>
	<input type="hidden" data-table="cha_agent" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($cha_agent->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($cha_agent->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="cha_agent" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($cha_agent->datetime->CurrentValue) ?>">
	<?php if (!$cha_agent->datetime->ReadOnly && !$cha_agent->datetime->Disabled && !isset($cha_agent->datetime->EditAttrs["readonly"]) && !isset($cha_agent->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fcha_agentaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$cha_agent_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$cha_agent_addopt->terminate();
?>