<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cha_agent_list = new cha_agent_list();

// Run the page
$cha_agent_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cha_agent_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$cha_agent->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcha_agentlist = currentForm = new ew.Form("fcha_agentlist", "list");
fcha_agentlist.formKeyCountName = '<?php echo $cha_agent_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcha_agentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcha_agentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcha_agentlist.lists["x_grp"] = <?php echo $cha_agent_list->grp->Lookup->toClientList() ?>;
fcha_agentlist.lists["x_grp"].options = <?php echo JsonEncode($cha_agent_list->grp->options(FALSE, TRUE)) ?>;
fcha_agentlist.lists["x_status"] = <?php echo $cha_agent_list->status->Lookup->toClientList() ?>;
fcha_agentlist.lists["x_status"].options = <?php echo JsonEncode($cha_agent_list->status->options(FALSE, TRUE)) ?>;
fcha_agentlist.lists["x_operator"] = <?php echo $cha_agent_list->operator->Lookup->toClientList() ?>;
fcha_agentlist.lists["x_operator"].options = <?php echo JsonEncode($cha_agent_list->operator->lookupOptions()) ?>;

// Form object for search
var fcha_agentlistsrch = currentSearchForm = new ew.Form("fcha_agentlistsrch");

// Filters
fcha_agentlistsrch.filterList = <?php echo $cha_agent_list->getFilterList() ?>;

// Init search panel as collapsed
fcha_agentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$cha_agent->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($cha_agent_list->TotalRecs > 0 && $cha_agent_list->ExportOptions->visible()) { ?>
<?php $cha_agent_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($cha_agent_list->ImportOptions->visible()) { ?>
<?php $cha_agent_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($cha_agent_list->SearchOptions->visible()) { ?>
<?php $cha_agent_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($cha_agent_list->FilterOptions->visible()) { ?>
<?php $cha_agent_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$cha_agent_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$cha_agent->isExport() && !$cha_agent->CurrentAction) { ?>
<form name="fcha_agentlistsrch" id="fcha_agentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($cha_agent_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcha_agentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="cha_agent">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($cha_agent_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($cha_agent_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $cha_agent_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($cha_agent_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($cha_agent_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($cha_agent_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($cha_agent_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $cha_agent_list->showPageHeader(); ?>
<?php
$cha_agent_list->showMessage();
?>
<?php if ($cha_agent_list->TotalRecs > 0 || $cha_agent->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($cha_agent_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> cha_agent">
<?php if (!$cha_agent->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$cha_agent->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cha_agent_list->Pager)) $cha_agent_list->Pager = new PrevNextPager($cha_agent_list->StartRec, $cha_agent_list->DisplayRecs, $cha_agent_list->TotalRecs, $cha_agent_list->AutoHidePager) ?>
<?php if ($cha_agent_list->Pager->RecordCount > 0 && $cha_agent_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cha_agent_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cha_agent_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cha_agent_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cha_agent_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cha_agent_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cha_agent_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cha_agent_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cha_agent_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cha_agent_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cha_agent_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cha_agent_list->TotalRecs > 0 && (!$cha_agent_list->AutoHidePageSizeSelector || $cha_agent_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cha_agent">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($cha_agent_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cha_agent_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($cha_agent_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cha_agent_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($cha_agent_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($cha_agent->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cha_agent_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcha_agentlist" id="fcha_agentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cha_agent_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cha_agent_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cha_agent">
<div id="gmp_cha_agent" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($cha_agent_list->TotalRecs > 0 || $cha_agent->isGridEdit()) { ?>
<table id="tbl_cha_agentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$cha_agent_list->RowType = ROWTYPE_HEADER;

// Render list options
$cha_agent_list->renderListOptions();

// Render list options (header, left)
$cha_agent_list->ListOptions->render("header", "left");
?>
<?php if ($cha_agent->id->Visible) { // id ?>
	<?php if ($cha_agent->sortUrl($cha_agent->id) == "") { ?>
		<th data-name="id" class="<?php echo $cha_agent->id->headerCellClass() ?>"><div id="elh_cha_agent_id" class="cha_agent_id"><div class="ew-table-header-caption"><?php echo $cha_agent->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $cha_agent->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cha_agent->SortUrl($cha_agent->id) ?>',2);"><div id="elh_cha_agent_id" class="cha_agent_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cha_agent->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($cha_agent->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cha_agent->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cha_agent->grp->Visible) { // grp ?>
	<?php if ($cha_agent->sortUrl($cha_agent->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $cha_agent->grp->headerCellClass() ?>"><div id="elh_cha_agent_grp" class="cha_agent_grp"><div class="ew-table-header-caption"><?php echo $cha_agent->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $cha_agent->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cha_agent->SortUrl($cha_agent->grp) ?>',2);"><div id="elh_cha_agent_grp" class="cha_agent_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cha_agent->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($cha_agent->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cha_agent->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cha_agent->name->Visible) { // name ?>
	<?php if ($cha_agent->sortUrl($cha_agent->name) == "") { ?>
		<th data-name="name" class="<?php echo $cha_agent->name->headerCellClass() ?>"><div id="elh_cha_agent_name" class="cha_agent_name"><div class="ew-table-header-caption"><?php echo $cha_agent->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $cha_agent->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cha_agent->SortUrl($cha_agent->name) ?>',2);"><div id="elh_cha_agent_name" class="cha_agent_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cha_agent->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cha_agent->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cha_agent->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cha_agent->code->Visible) { // code ?>
	<?php if ($cha_agent->sortUrl($cha_agent->code) == "") { ?>
		<th data-name="code" class="<?php echo $cha_agent->code->headerCellClass() ?>"><div id="elh_cha_agent_code" class="cha_agent_code"><div class="ew-table-header-caption"><?php echo $cha_agent->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $cha_agent->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cha_agent->SortUrl($cha_agent->code) ?>',2);"><div id="elh_cha_agent_code" class="cha_agent_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cha_agent->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cha_agent->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cha_agent->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cha_agent->status->Visible) { // status ?>
	<?php if ($cha_agent->sortUrl($cha_agent->status) == "") { ?>
		<th data-name="status" class="<?php echo $cha_agent->status->headerCellClass() ?>"><div id="elh_cha_agent_status" class="cha_agent_status"><div class="ew-table-header-caption"><?php echo $cha_agent->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $cha_agent->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cha_agent->SortUrl($cha_agent->status) ?>',2);"><div id="elh_cha_agent_status" class="cha_agent_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cha_agent->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($cha_agent->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cha_agent->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cha_agent->operator->Visible) { // operator ?>
	<?php if ($cha_agent->sortUrl($cha_agent->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $cha_agent->operator->headerCellClass() ?>"><div id="elh_cha_agent_operator" class="cha_agent_operator"><div class="ew-table-header-caption"><?php echo $cha_agent->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $cha_agent->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cha_agent->SortUrl($cha_agent->operator) ?>',2);"><div id="elh_cha_agent_operator" class="cha_agent_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cha_agent->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($cha_agent->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cha_agent->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cha_agent->datetime->Visible) { // datetime ?>
	<?php if ($cha_agent->sortUrl($cha_agent->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $cha_agent->datetime->headerCellClass() ?>"><div id="elh_cha_agent_datetime" class="cha_agent_datetime"><div class="ew-table-header-caption"><?php echo $cha_agent->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $cha_agent->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cha_agent->SortUrl($cha_agent->datetime) ?>',2);"><div id="elh_cha_agent_datetime" class="cha_agent_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cha_agent->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($cha_agent->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cha_agent->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$cha_agent_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($cha_agent->ExportAll && $cha_agent->isExport()) {
	$cha_agent_list->StopRec = $cha_agent_list->TotalRecs;
} else {

	// Set the last record to display
	if ($cha_agent_list->TotalRecs > $cha_agent_list->StartRec + $cha_agent_list->DisplayRecs - 1)
		$cha_agent_list->StopRec = $cha_agent_list->StartRec + $cha_agent_list->DisplayRecs - 1;
	else
		$cha_agent_list->StopRec = $cha_agent_list->TotalRecs;
}
$cha_agent_list->RecCnt = $cha_agent_list->StartRec - 1;
if ($cha_agent_list->Recordset && !$cha_agent_list->Recordset->EOF) {
	$cha_agent_list->Recordset->moveFirst();
	$selectLimit = $cha_agent_list->UseSelectLimit;
	if (!$selectLimit && $cha_agent_list->StartRec > 1)
		$cha_agent_list->Recordset->move($cha_agent_list->StartRec - 1);
} elseif (!$cha_agent->AllowAddDeleteRow && $cha_agent_list->StopRec == 0) {
	$cha_agent_list->StopRec = $cha_agent->GridAddRowCount;
}

// Initialize aggregate
$cha_agent->RowType = ROWTYPE_AGGREGATEINIT;
$cha_agent->resetAttributes();
$cha_agent_list->renderRow();
while ($cha_agent_list->RecCnt < $cha_agent_list->StopRec) {
	$cha_agent_list->RecCnt++;
	if ($cha_agent_list->RecCnt >= $cha_agent_list->StartRec) {
		$cha_agent_list->RowCnt++;

		// Set up key count
		$cha_agent_list->KeyCount = $cha_agent_list->RowIndex;

		// Init row class and style
		$cha_agent->resetAttributes();
		$cha_agent->CssClass = "";
		if ($cha_agent->isGridAdd()) {
		} else {
			$cha_agent_list->loadRowValues($cha_agent_list->Recordset); // Load row values
		}
		$cha_agent->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$cha_agent->RowAttrs = array_merge($cha_agent->RowAttrs, array('data-rowindex'=>$cha_agent_list->RowCnt, 'id'=>'r' . $cha_agent_list->RowCnt . '_cha_agent', 'data-rowtype'=>$cha_agent->RowType));

		// Render row
		$cha_agent_list->renderRow();

		// Render list options
		$cha_agent_list->renderListOptions();
?>
	<tr<?php echo $cha_agent->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cha_agent_list->ListOptions->render("body", "left", $cha_agent_list->RowCnt);
?>
	<?php if ($cha_agent->id->Visible) { // id ?>
		<td data-name="id"<?php echo $cha_agent->id->cellAttributes() ?>>
<span id="el<?php echo $cha_agent_list->RowCnt ?>_cha_agent_id" class="cha_agent_id">
<span<?php echo $cha_agent->id->viewAttributes() ?>>
<?php echo $cha_agent->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cha_agent->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $cha_agent->grp->cellAttributes() ?>>
<span id="el<?php echo $cha_agent_list->RowCnt ?>_cha_agent_grp" class="cha_agent_grp">
<span<?php echo $cha_agent->grp->viewAttributes() ?>>
<?php echo $cha_agent->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cha_agent->name->Visible) { // name ?>
		<td data-name="name"<?php echo $cha_agent->name->cellAttributes() ?>>
<span id="el<?php echo $cha_agent_list->RowCnt ?>_cha_agent_name" class="cha_agent_name">
<span<?php echo $cha_agent->name->viewAttributes() ?>>
<?php echo $cha_agent->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cha_agent->code->Visible) { // code ?>
		<td data-name="code"<?php echo $cha_agent->code->cellAttributes() ?>>
<span id="el<?php echo $cha_agent_list->RowCnt ?>_cha_agent_code" class="cha_agent_code">
<span<?php echo $cha_agent->code->viewAttributes() ?>>
<?php echo $cha_agent->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cha_agent->status->Visible) { // status ?>
		<td data-name="status"<?php echo $cha_agent->status->cellAttributes() ?>>
<span id="el<?php echo $cha_agent_list->RowCnt ?>_cha_agent_status" class="cha_agent_status">
<span<?php echo $cha_agent->status->viewAttributes() ?>>
<?php echo $cha_agent->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cha_agent->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $cha_agent->operator->cellAttributes() ?>>
<span id="el<?php echo $cha_agent_list->RowCnt ?>_cha_agent_operator" class="cha_agent_operator">
<span<?php echo $cha_agent->operator->viewAttributes() ?>>
<?php echo $cha_agent->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cha_agent->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $cha_agent->datetime->cellAttributes() ?>>
<span id="el<?php echo $cha_agent_list->RowCnt ?>_cha_agent_datetime" class="cha_agent_datetime">
<span<?php echo $cha_agent->datetime->viewAttributes() ?>>
<?php echo $cha_agent->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cha_agent_list->ListOptions->render("body", "right", $cha_agent_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$cha_agent->isGridAdd())
		$cha_agent_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$cha_agent->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($cha_agent_list->Recordset)
	$cha_agent_list->Recordset->Close();
?>
<?php if (!$cha_agent->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$cha_agent->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cha_agent_list->Pager)) $cha_agent_list->Pager = new PrevNextPager($cha_agent_list->StartRec, $cha_agent_list->DisplayRecs, $cha_agent_list->TotalRecs, $cha_agent_list->AutoHidePager) ?>
<?php if ($cha_agent_list->Pager->RecordCount > 0 && $cha_agent_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cha_agent_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cha_agent_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cha_agent_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cha_agent_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cha_agent_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cha_agent_list->pageUrl() ?>start=<?php echo $cha_agent_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cha_agent_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cha_agent_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cha_agent_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cha_agent_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cha_agent_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cha_agent_list->TotalRecs > 0 && (!$cha_agent_list->AutoHidePageSizeSelector || $cha_agent_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cha_agent">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($cha_agent_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cha_agent_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($cha_agent_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cha_agent_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($cha_agent_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($cha_agent->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cha_agent_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($cha_agent_list->TotalRecs == 0 && !$cha_agent->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $cha_agent_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$cha_agent_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$cha_agent->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$cha_agent->isExport()) { ?>
<script>
ew.scrollableTable("gmp_cha_agent", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$cha_agent_list->terminate();
?>