<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cha_agent_view = new cha_agent_view();

// Run the page
$cha_agent_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cha_agent_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$cha_agent->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcha_agentview = currentForm = new ew.Form("fcha_agentview", "view");

// Form_CustomValidate event
fcha_agentview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcha_agentview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcha_agentview.lists["x_grp"] = <?php echo $cha_agent_view->grp->Lookup->toClientList() ?>;
fcha_agentview.lists["x_grp"].options = <?php echo JsonEncode($cha_agent_view->grp->options(FALSE, TRUE)) ?>;
fcha_agentview.lists["x_status"] = <?php echo $cha_agent_view->status->Lookup->toClientList() ?>;
fcha_agentview.lists["x_status"].options = <?php echo JsonEncode($cha_agent_view->status->options(FALSE, TRUE)) ?>;
fcha_agentview.lists["x_operator"] = <?php echo $cha_agent_view->operator->Lookup->toClientList() ?>;
fcha_agentview.lists["x_operator"].options = <?php echo JsonEncode($cha_agent_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$cha_agent->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $cha_agent_view->ExportOptions->render("body") ?>
<?php $cha_agent_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $cha_agent_view->showPageHeader(); ?>
<?php
$cha_agent_view->showMessage();
?>
<form name="fcha_agentview" id="fcha_agentview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cha_agent_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cha_agent_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cha_agent">
<input type="hidden" name="modal" value="<?php echo (int)$cha_agent_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($cha_agent->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $cha_agent_view->TableLeftColumnClass ?>"><span id="elh_cha_agent_id"><?php echo $cha_agent->id->caption() ?></span></td>
		<td data-name="id"<?php echo $cha_agent->id->cellAttributes() ?>>
<span id="el_cha_agent_id">
<span<?php echo $cha_agent->id->viewAttributes() ?>>
<?php echo $cha_agent->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cha_agent->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $cha_agent_view->TableLeftColumnClass ?>"><span id="elh_cha_agent_grp"><?php echo $cha_agent->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $cha_agent->grp->cellAttributes() ?>>
<span id="el_cha_agent_grp">
<span<?php echo $cha_agent->grp->viewAttributes() ?>>
<?php echo $cha_agent->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cha_agent->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $cha_agent_view->TableLeftColumnClass ?>"><span id="elh_cha_agent_name"><?php echo $cha_agent->name->caption() ?></span></td>
		<td data-name="name"<?php echo $cha_agent->name->cellAttributes() ?>>
<span id="el_cha_agent_name">
<span<?php echo $cha_agent->name->viewAttributes() ?>>
<?php echo $cha_agent->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cha_agent->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $cha_agent_view->TableLeftColumnClass ?>"><span id="elh_cha_agent_code"><?php echo $cha_agent->code->caption() ?></span></td>
		<td data-name="code"<?php echo $cha_agent->code->cellAttributes() ?>>
<span id="el_cha_agent_code">
<span<?php echo $cha_agent->code->viewAttributes() ?>>
<?php echo $cha_agent->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cha_agent->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $cha_agent_view->TableLeftColumnClass ?>"><span id="elh_cha_agent_status"><?php echo $cha_agent->status->caption() ?></span></td>
		<td data-name="status"<?php echo $cha_agent->status->cellAttributes() ?>>
<span id="el_cha_agent_status">
<span<?php echo $cha_agent->status->viewAttributes() ?>>
<?php echo $cha_agent->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cha_agent->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $cha_agent_view->TableLeftColumnClass ?>"><span id="elh_cha_agent_operator"><?php echo $cha_agent->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $cha_agent->operator->cellAttributes() ?>>
<span id="el_cha_agent_operator">
<span<?php echo $cha_agent->operator->viewAttributes() ?>>
<?php echo $cha_agent->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cha_agent->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $cha_agent_view->TableLeftColumnClass ?>"><span id="elh_cha_agent_datetime"><?php echo $cha_agent->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $cha_agent->datetime->cellAttributes() ?>>
<span id="el_cha_agent_datetime">
<span<?php echo $cha_agent->datetime->viewAttributes() ?>>
<?php echo $cha_agent->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$cha_agent_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$cha_agent->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$cha_agent_view->terminate();
?>