<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for request
 */
class __request extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $type;
	public $r_from;
	public $r_to;
	public $lead_type;
	public $lead_status;
	public $lead_by;
	public $subject;
	public $message;
	public $alert;
	public $uploads;
	public $reference;
	public $status;
	public $operator;
	public $datetime;
	public $beep;
	public $c_message;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = '__request';
		$this->TableName = 'request';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`request`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('__request', 'request', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// type
		$this->type = new DbField('__request', 'request', 'x_type', 'type', '`type`', '`type`', 17, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->type->Nullable = FALSE; // NOT NULL field
		$this->type->Required = TRUE; // Required field
		$this->type->Sortable = TRUE; // Allow sort
		$this->type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->type->Lookup = new Lookup('type', '__request', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->type->OptionCount = 4;
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// r_from
		$this->r_from = new DbField('__request', 'request', 'x_r_from', 'r_from', '`r_from`', '`r_from`', 200, -1, FALSE, '`r_from`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->r_from->Nullable = FALSE; // NOT NULL field
		$this->r_from->Sortable = TRUE; // Allow sort
		$this->r_from->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->r_from->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->r_from->Lookup = new Lookup('r_from', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->fields['r_from'] = &$this->r_from;

		// r_to
		$this->r_to = new DbField('__request', 'request', 'x_r_to', 'r_to', '`r_to`', '`r_to`', 200, -1, FALSE, '`r_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->r_to->Nullable = FALSE; // NOT NULL field
		$this->r_to->Required = TRUE; // Required field
		$this->r_to->Sortable = TRUE; // Allow sort
		$this->r_to->Lookup = new Lookup('r_to', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->fields['r_to'] = &$this->r_to;

		// lead_type
		$this->lead_type = new DbField('__request', 'request', 'x_lead_type', 'lead_type', '`lead_type`', '`lead_type`', 2, -1, FALSE, '`lead_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->lead_type->Sortable = TRUE; // Allow sort
		$this->lead_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->lead_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->lead_type->Lookup = new Lookup('lead_type', 'request_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->lead_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['lead_type'] = &$this->lead_type;

		// lead_status
		$this->lead_status = new DbField('__request', 'request', 'x_lead_status', 'lead_status', '`lead_status`', '`lead_status`', 2, -1, FALSE, '`lead_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->lead_status->Sortable = TRUE; // Allow sort
		$this->lead_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->lead_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->lead_status->Lookup = new Lookup('lead_status', 'request_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->lead_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['lead_status'] = &$this->lead_status;

		// lead_by
		$this->lead_by = new DbField('__request', 'request', 'x_lead_by', 'lead_by', '`lead_by`', '`lead_by`', 200, -1, FALSE, '`lead_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lead_by->Required = TRUE; // Required field
		$this->lead_by->Sortable = TRUE; // Allow sort
		$this->fields['lead_by'] = &$this->lead_by;

		// subject
		$this->subject = new DbField('__request', 'request', 'x_subject', 'subject', '`subject`', '`subject`', 200, -1, FALSE, '`subject`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->subject->Nullable = FALSE; // NOT NULL field
		$this->subject->Required = TRUE; // Required field
		$this->subject->Sortable = TRUE; // Allow sort
		$this->fields['subject'] = &$this->subject;

		// message
		$this->message = new DbField('__request', 'request', 'x_message', 'message', '`message`', '`message`', 201, -1, FALSE, '`message`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->message->Nullable = FALSE; // NOT NULL field
		$this->message->Required = TRUE; // Required field
		$this->message->Sortable = TRUE; // Allow sort
		$this->fields['message'] = &$this->message;

		// alert
		$this->alert = new DbField('__request', 'request', 'x_alert', 'alert', '`alert`', CastDateFieldForLike('`alert`', 11, "DB"), 135, 11, FALSE, '`alert`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->alert->Sortable = TRUE; // Allow sort
		$this->alert->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['alert'] = &$this->alert;

		// uploads
		$this->uploads = new DbField('__request', 'request', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->uploads->Sortable = TRUE; // Allow sort
		$this->uploads->UploadMultiple = TRUE;
		$this->uploads->Upload->UploadMultiple = TRUE;
		$this->uploads->UploadMaxFileCount = 0;
		$this->fields['uploads'] = &$this->uploads;

		// reference
		$this->reference = new DbField('__request', 'request', 'x_reference', 'reference', '`reference`', '`reference`', 2, -1, FALSE, '`reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reference->Nullable = FALSE; // NOT NULL field
		$this->reference->Required = TRUE; // Required field
		$this->reference->Sortable = TRUE; // Allow sort
		$this->reference->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reference'] = &$this->reference;

		// status
		$this->status = new DbField('__request', 'request', 'x_status', 'status', '`status`', '`status`', 18, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('__request', 'request', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('__request', 'request', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// beep
		$this->beep = new DbField('__request', 'request', 'x_beep', 'beep', '`beep`', '`beep`', 200, -1, FALSE, '`beep`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->beep->Required = TRUE; // Required field
		$this->beep->Sortable = TRUE; // Allow sort
		$this->beep->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['beep'] = &$this->beep;

		// c_message
		$this->c_message = new DbField('__request', 'request', 'x_c_message', 'c_message', '`c_message`', '`c_message`', 201, -1, FALSE, '`c_message`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->c_message->Sortable = FALSE; // Allow sort
		$this->fields['c_message'] = &$this->c_message;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`request`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`operator` = " . CurrentUserID();
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->type->DbValue = $row['type'];
		$this->r_from->DbValue = $row['r_from'];
		$this->r_to->DbValue = $row['r_to'];
		$this->lead_type->DbValue = $row['lead_type'];
		$this->lead_status->DbValue = $row['lead_status'];
		$this->lead_by->DbValue = $row['lead_by'];
		$this->subject->DbValue = $row['subject'];
		$this->message->DbValue = $row['message'];
		$this->alert->DbValue = $row['alert'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->reference->DbValue = $row['reference'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->beep->DbValue = $row['beep'];
		$this->c_message->DbValue = $row['c_message'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->uploads->OldUploadPath = ".p_uploads/request/";
		$oldFiles = EmptyValue($row['uploads']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['uploads']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "__requestlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "__requestview.php")
			return $Language->phrase("View");
		elseif ($pageName == "__requestedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "__requestadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "__requestlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("__requestview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("__requestview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "__requestadd.php?" . $this->getUrlParm($parm);
		else
			$url = "__requestadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("__requestedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("__requestadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("__requestdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->type->setDbValue($rs->fields('type'));
		$this->r_from->setDbValue($rs->fields('r_from'));
		$this->r_to->setDbValue($rs->fields('r_to'));
		$this->lead_type->setDbValue($rs->fields('lead_type'));
		$this->lead_status->setDbValue($rs->fields('lead_status'));
		$this->lead_by->setDbValue($rs->fields('lead_by'));
		$this->subject->setDbValue($rs->fields('subject'));
		$this->message->setDbValue($rs->fields('message'));
		$this->alert->setDbValue($rs->fields('alert'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->reference->setDbValue($rs->fields('reference'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->beep->setDbValue($rs->fields('beep'));
		$this->c_message->setDbValue($rs->fields('c_message'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// type
		// r_from
		// r_to
		// lead_type
		// lead_status
		// lead_by
		// subject
		// message
		// alert
		// uploads
		// reference
		// status
		// operator
		// datetime
		// beep
		// c_message

		$this->c_message->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		if (strval($this->type->CurrentValue) <> "") {
			$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
		} else {
			$this->type->ViewValue = NULL;
		}
		$this->type->ViewCustomAttributes = "";

		// r_from
		$curVal = strval($this->r_from->CurrentValue);
		if ($curVal <> "") {
			$this->r_from->ViewValue = $this->r_from->lookupCacheOption($curVal);
			if ($this->r_from->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->r_from->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->r_from->ViewValue = $this->r_from->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->r_from->ViewValue = $this->r_from->CurrentValue;
				}
			}
		} else {
			$this->r_from->ViewValue = NULL;
		}
		$this->r_from->ViewCustomAttributes = "";

		// r_to
		$curVal = strval($this->r_to->CurrentValue);
		if ($curVal <> "") {
			$this->r_to->ViewValue = $this->r_to->lookupCacheOption($curVal);
			if ($this->r_to->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (isset($_GET['type']) && $_GET['type'] == 99) ? "`id` = 1 || FIND_IN_SET(`id`, '". $_GET['to'] . "')" : ((User_Company_ID() == 0) ?  "`activated` = 1  and `id` > 9"  : "((`activated` = 1 and company_id = " . $_COOKIE['User_Company_ID'] . " and `id` > 9) or (`user_name` like '%Support%'))" . ((isset($_GET['to'])) ? " or ((`id` = " . $_GET['to'] . "))" : ''));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->r_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->r_to->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->r_to->ViewValue->add($this->r_to->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->r_to->ViewValue = $this->r_to->CurrentValue;
				}
			}
		} else {
			$this->r_to->ViewValue = NULL;
		}
		$this->r_to->ViewCustomAttributes = "";

		// lead_type
		$curVal = strval($this->lead_type->CurrentValue);
		if ($curVal <> "") {
			$this->lead_type->ViewValue = $this->lead_type->lookupCacheOption($curVal);
			if ($this->lead_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->lead_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->lead_type->ViewValue = $this->lead_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->lead_type->ViewValue = $this->lead_type->CurrentValue;
				}
			}
		} else {
			$this->lead_type->ViewValue = NULL;
		}
		$this->lead_type->ViewCustomAttributes = "";

		// lead_status
		$curVal = strval($this->lead_status->CurrentValue);
		if ($curVal <> "") {
			$this->lead_status->ViewValue = $this->lead_status->lookupCacheOption($curVal);
			if ($this->lead_status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=12";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->lead_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->lead_status->ViewValue = $this->lead_status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->lead_status->ViewValue = $this->lead_status->CurrentValue;
				}
			}
		} else {
			$this->lead_status->ViewValue = NULL;
		}
		$this->lead_status->ViewCustomAttributes = "";

		// lead_by
		$this->lead_by->ViewValue = $this->lead_by->CurrentValue;
		$this->lead_by->ViewCustomAttributes = "";

		// subject
		$this->subject->ViewValue = $this->subject->CurrentValue;
		$this->subject->ViewCustomAttributes = "";

		// message
		$this->message->ViewValue = $this->message->CurrentValue;
		$this->message->ViewCustomAttributes = "";

		// alert
		$this->alert->ViewValue = $this->alert->CurrentValue;
		$this->alert->ViewValue = FormatDateTime($this->alert->ViewValue, 11);
		$this->alert->ViewCustomAttributes = "";

		// uploads
		$this->uploads->UploadPath = ".p_uploads/request/";
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->ViewCustomAttributes = "";

		// reference
		$this->reference->ViewValue = $this->reference->CurrentValue;
		$this->reference->ViewValue = FormatNumber($this->reference->ViewValue, 0, -2, -2, -2);
		$this->reference->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// beep
		$this->beep->ViewValue = $this->beep->CurrentValue;
		$this->beep->ViewCustomAttributes = "";

		// c_message
		$this->c_message->ViewValue = $this->c_message->CurrentValue;
		$this->c_message->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// r_from
		$this->r_from->LinkCustomAttributes = "";
		$this->r_from->HrefValue = "";
		$this->r_from->TooltipValue = "";

		// r_to
		$this->r_to->LinkCustomAttributes = "";
		$this->r_to->HrefValue = "";
		$this->r_to->TooltipValue = "";

		// lead_type
		$this->lead_type->LinkCustomAttributes = "";
		$this->lead_type->HrefValue = "";
		$this->lead_type->TooltipValue = "";

		// lead_status
		$this->lead_status->LinkCustomAttributes = "";
		$this->lead_status->HrefValue = "";
		$this->lead_status->TooltipValue = "";

		// lead_by
		$this->lead_by->LinkCustomAttributes = "";
		$this->lead_by->HrefValue = "";
		$this->lead_by->TooltipValue = "";

		// subject
		$this->subject->LinkCustomAttributes = "";
		$this->subject->HrefValue = "";
		$this->subject->TooltipValue = "";

		// message
		$this->message->LinkCustomAttributes = "";
		$this->message->HrefValue = "";
		$this->message->TooltipValue = "";

		// alert
		$this->alert->LinkCustomAttributes = "";
		$this->alert->HrefValue = "";
		$this->alert->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->UploadPath = ".p_uploads/request/";
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->HrefValue = "%u"; // Add prefix/suffix
			$this->uploads->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
		} else {
			$this->uploads->HrefValue = "";
		}
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";
		if ($this->uploads->UseColorbox) {
			if (EmptyValue($this->uploads->TooltipValue))
				$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->uploads->LinkAttrs["data-rel"] = "__request_x_uploads";
			AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
		}

		// reference
		$this->reference->LinkCustomAttributes = "";
		$this->reference->HrefValue = "";
		$this->reference->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// beep
		$this->beep->LinkCustomAttributes = "";
		$this->beep->HrefValue = "";
		$this->beep->TooltipValue = "";

		// c_message
		$this->c_message->LinkCustomAttributes = "";
		$this->c_message->HrefValue = "";
		$this->c_message->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		$this->type->EditValue = $this->type->options(TRUE);

		// r_from
		// r_to

		$this->r_to->EditCustomAttributes = "";

		// lead_type
		$this->lead_type->EditAttrs["class"] = "form-control";
		$this->lead_type->EditCustomAttributes = "";

		// lead_status
		$this->lead_status->EditAttrs["class"] = "form-control";
		$this->lead_status->EditCustomAttributes = "";

		// lead_by
		$this->lead_by->EditAttrs["class"] = "form-control";
		$this->lead_by->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lead_by->CurrentValue = HtmlDecode($this->lead_by->CurrentValue);
		$this->lead_by->EditValue = $this->lead_by->CurrentValue;
		$this->lead_by->PlaceHolder = RemoveHtml($this->lead_by->caption());

		// subject
		$this->subject->EditAttrs["class"] = "form-control";
		$this->subject->EditCustomAttributes = "";
		$this->subject->EditValue = $this->subject->CurrentValue;
		$this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

		// message
		$this->message->EditAttrs["class"] = "form-control";
		$this->message->EditCustomAttributes = "";
		$this->message->EditValue = $this->message->CurrentValue;
		$this->message->PlaceHolder = RemoveHtml($this->message->caption());

		// alert
		$this->alert->EditAttrs["class"] = "form-control";
		$this->alert->EditCustomAttributes = "";
		$this->alert->EditValue = FormatDateTime($this->alert->CurrentValue, 11);
		$this->alert->PlaceHolder = RemoveHtml($this->alert->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->UploadPath = ".p_uploads/request/";
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// reference
		$this->reference->EditAttrs["class"] = "form-control";
		$this->reference->EditCustomAttributes = "";
		$this->reference->EditValue = $this->reference->CurrentValue;
		$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// operator
		// datetime
		// beep

		$this->beep->EditAttrs["class"] = "form-control";
		$this->beep->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->beep->CurrentValue = HtmlDecode($this->beep->CurrentValue);
		$this->beep->EditValue = $this->beep->CurrentValue;
		$this->beep->PlaceHolder = RemoveHtml($this->beep->caption());

		// c_message
		$this->c_message->EditAttrs["class"] = "form-control";
		$this->c_message->EditCustomAttributes = "";
		$this->c_message->EditValue = $this->c_message->CurrentValue;
		$this->c_message->PlaceHolder = RemoveHtml($this->c_message->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->r_from);
					$doc->exportCaption($this->r_to);
					$doc->exportCaption($this->lead_type);
					$doc->exportCaption($this->lead_status);
					$doc->exportCaption($this->lead_by);
					$doc->exportCaption($this->subject);
					$doc->exportCaption($this->message);
					$doc->exportCaption($this->alert);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->beep);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->r_from);
					$doc->exportCaption($this->r_to);
					$doc->exportCaption($this->lead_type);
					$doc->exportCaption($this->lead_status);
					$doc->exportCaption($this->lead_by);
					$doc->exportCaption($this->subject);
					$doc->exportCaption($this->message);
					$doc->exportCaption($this->alert);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->beep);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->r_from);
						$doc->exportField($this->r_to);
						$doc->exportField($this->lead_type);
						$doc->exportField($this->lead_status);
						$doc->exportField($this->lead_by);
						$doc->exportField($this->subject);
						$doc->exportField($this->message);
						$doc->exportField($this->alert);
						$doc->exportField($this->uploads);
						$doc->exportField($this->reference);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->beep);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->r_from);
						$doc->exportField($this->r_to);
						$doc->exportField($this->lead_type);
						$doc->exportField($this->lead_status);
						$doc->exportField($this->lead_by);
						$doc->exportField($this->subject);
						$doc->exportField($this->message);
						$doc->exportField($this->alert);
						$doc->exportField($this->uploads);
						$doc->exportField($this->reference);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->beep);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>