<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for barcode
 */
class _barcode extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $po;
	public $despatch_week;
	public $_barcode;
	public $buyers_id;
	public $design_id;
	public $buyer_ref;
	public $design_size;
	public $sqm;
	public $sqm_a;
	public $status;
	public $jc_no;
	public $cs;
	public $weaving_works;
	public $current_works;
	public $process_c;
	public $process_d;
	public $remarks;
	public $p_remarks;
	public $batch_no;
	public $weight;
	public $buyer_po;
	public $buyer_uid_loc;
	public $order_date;
	public $completed;
	public $operator;
	public $datetime;
	public $process;
	public $id;
	public $pid;
	public $shape;
	public $production_plan;
	public $size_cm;
	public $_2srm;
	public $_4srm;
	public $RefID;
	public $buyer_tid;
	public $grp;
	public $s_grp;
	public $product_type;
	public $w_cm;
	public $l_cm;
	public $_2srm_a;
	public $_4srm_a;
	public $category;
	public $quantity;
	public $pl_no;
	public $buyer_barcode;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = '_barcode';
		$this->TableName = 'barcode';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`barcode`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// po
		$this->po = new DbField('_barcode', 'barcode', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// despatch_week
		$this->despatch_week = new DbField('_barcode', 'barcode', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["week","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// barcode
		$this->_barcode = new DbField('_barcode', 'barcode', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`EV___barcode`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->_barcode->Nullable = FALSE; // NOT NULL field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->_barcode->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->_barcode->Lookup = new Lookup('barcode', 'bcode', FALSE, 'barcode', ["barcode","buyer_uid","buyer_loc",""], [], [], [], [], [], [], '', '');
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['barcode'] = &$this->_barcode;

		// buyers_id
		$this->buyers_id = new DbField('_barcode', 'barcode', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`EV__buyers_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->buyers_id->Sortable = FALSE; // Allow sort
		$this->buyers_id->Lookup = new Lookup('buyers_id', 'buyer_seller_view', TRUE, 'id', ["code","","",""], [], ["x_buyer_ref"], [], [], [], [], '`code` ASC', '');
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// design_id
		$this->design_id = new DbField('_barcode', 'barcode', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`design_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_id->Sortable = FALSE; // Allow sort
		$this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design_id'] = &$this->design_id;

		// buyer_ref
		$this->buyer_ref = new DbField('_barcode', 'barcode', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 2, -1, FALSE, '`buyer_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->buyer_ref->Lookup = new Lookup('buyer_ref', 'partner_product_ref', FALSE, 'id', ["partner_ref","","",""], ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], '`partner_ref` ASC', '');
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// design_size
		$this->design_size = new DbField('_barcode', 'barcode', 'x_design_size', 'design_size', '`design_size`', '`design_size`', 200, -1, FALSE, '`design_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_size->Sortable = TRUE; // Allow sort
		$this->design_size->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design_size'] = &$this->design_size;

		// sqm
		$this->sqm = new DbField('_barcode', 'barcode', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Nullable = FALSE; // NOT NULL field
		$this->sqm->Required = TRUE; // Required field
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// sqm_a
		$this->sqm_a = new DbField('_barcode', 'barcode', 'x_sqm_a', 'sqm_a', '`sqm_a`', '`sqm_a`', 4, -1, FALSE, '`sqm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_a->Nullable = FALSE; // NOT NULL field
		$this->sqm_a->Required = TRUE; // Required field
		$this->sqm_a->Sortable = TRUE; // Allow sort
		$this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_a'] = &$this->sqm_a;

		// status
		$this->status = new DbField('_barcode', 'barcode', 'x_status', 'status', '`status`', '`status`', 18, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'status', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// jc_no
		$this->jc_no = new DbField('_barcode', 'barcode', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 19, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// cs
		$this->cs = new DbField('_barcode', 'barcode', 'x_cs', 'cs', '`cs`', '`cs`', 19, -1, FALSE, '`cs`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->cs->Nullable = FALSE; // NOT NULL field
		$this->cs->Sortable = TRUE; // Allow sort
		$this->cs->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->cs->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->cs->Lookup = new Lookup('cs', '_barcode', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->cs->OptionCount = 2;
		$this->cs->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cs'] = &$this->cs;

		// weaving_works
		$this->weaving_works = new DbField('_barcode', 'barcode', 'x_weaving_works', 'weaving_works', '`weaving_works`', '`weaving_works`', 18, -1, FALSE, '`weaving_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->weaving_works->Nullable = FALSE; // NOT NULL field
		$this->weaving_works->Sortable = TRUE; // Allow sort
		$this->weaving_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->weaving_works->Lookup = new Lookup('weaving_works', 'godown_table', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['weaving_works'] = &$this->weaving_works;

		// current_works
		$this->current_works = new DbField('_barcode', 'barcode', 'x_current_works', 'current_works', '`current_works`', '`current_works`', 18, -1, FALSE, '`current_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->current_works->Nullable = FALSE; // NOT NULL field
		$this->current_works->Sortable = TRUE; // Allow sort
		$this->current_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->current_works->Lookup = new Lookup('current_works', 'godown_table', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['current_works'] = &$this->current_works;

		// process_c
		$this->process_c = new DbField('_barcode', 'barcode', 'x_process_c', 'process_c', '`process_c`', '`process_c`', 200, -1, FALSE, '`process_c`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process_c->Sortable = TRUE; // Allow sort
		$this->process_c->SelectMultiple = TRUE; // Multiple select
		$this->process_c->Lookup = new Lookup('process_c', 'sub_process_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process_c'] = &$this->process_c;

		// process_d
		$this->process_d = new DbField('_barcode', 'barcode', 'x_process_d', 'process_d', '`process_d`', '`process_d`', 200, -1, FALSE, '`process_d`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process_d->Sortable = TRUE; // Allow sort
		$this->process_d->SelectMultiple = TRUE; // Multiple select
		$this->process_d->Lookup = new Lookup('process_d', 'sub_process_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process_d'] = &$this->process_d;

		// remarks
		$this->remarks = new DbField('_barcode', 'barcode', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// p_remarks
		$this->p_remarks = new DbField('_barcode', 'barcode', 'x_p_remarks', 'p_remarks', '`p_remarks`', '`p_remarks`', 201, -1, FALSE, '`p_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->p_remarks->Sortable = TRUE; // Allow sort
		$this->fields['p_remarks'] = &$this->p_remarks;

		// batch_no
		$this->batch_no = new DbField('_barcode', 'barcode', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`EV__batch_no`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// weight
		$this->weight = new DbField('_barcode', 'barcode', 'x_weight', 'weight', '`weight`', '`weight`', 131, -1, FALSE, '`weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weight->Sortable = TRUE; // Allow sort
		$this->weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['weight'] = &$this->weight;

		// buyer_po
		$this->buyer_po = new DbField('_barcode', 'barcode', 'x_buyer_po', 'buyer_po', '`buyer_po`', '`buyer_po`', 200, -1, FALSE, '`buyer_po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_po->Sortable = TRUE; // Allow sort
		$this->fields['buyer_po'] = &$this->buyer_po;

		// buyer_uid_loc
		$this->buyer_uid_loc = new DbField('_barcode', 'barcode', 'x_buyer_uid_loc', 'buyer_uid_loc', '`buyer_uid_loc`', '`buyer_uid_loc`', 200, -1, FALSE, '`buyer_uid_loc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_uid_loc->Sortable = TRUE; // Allow sort
		$this->fields['buyer_uid_loc'] = &$this->buyer_uid_loc;

		// order_date
		$this->order_date = new DbField('_barcode', 'barcode', 'x_order_date', 'order_date', '`order_date`', CastDateFieldForLike('`order_date`', 0, "DB"), 133, 0, FALSE, '`order_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_date->Sortable = TRUE; // Allow sort
		$this->order_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['order_date'] = &$this->order_date;

		// completed
		$this->completed = new DbField('_barcode', 'barcode', 'x_completed', 'completed', '`completed`', '`completed`', 17, -1, FALSE, '`completed`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->completed->Sortable = TRUE; // Allow sort
		$this->completed->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->completed->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->completed->Lookup = new Lookup('completed', '_barcode', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->completed->OptionCount = 2;
		$this->completed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['completed'] = &$this->completed;

		// operator
		$this->operator = new DbField('_barcode', 'barcode', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = FALSE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('_barcode', 'barcode', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = FALSE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// process
		$this->process = new DbField('_barcode', 'barcode', 'x_process', 'process', '`process`', '`process`', 200, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Sortable = FALSE; // Allow sort
		$this->process->SelectMultiple = TRUE; // Multiple select
		$this->process->Lookup = new Lookup('process', 'sub_process_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process'] = &$this->process;

		// id
		$this->id = new DbField('_barcode', 'barcode', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Sortable = FALSE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// pid
		$this->pid = new DbField('_barcode', 'barcode', 'x_pid', 'pid', '`pid`', '`pid`', 131, -1, FALSE, '`pid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pid->Sortable = FALSE; // Allow sort
		$this->pid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pid'] = &$this->pid;

		// shape
		$this->shape = new DbField('_barcode', 'barcode', 'x_shape', 'shape', '`shape`', '`shape`', 17, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shape->Nullable = FALSE; // NOT NULL field
		$this->shape->Required = TRUE; // Required field
		$this->shape->Sortable = FALSE; // Allow sort
		$this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shape'] = &$this->shape;

		// production_plan
		$this->production_plan = new DbField('_barcode', 'barcode', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 17, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->production_plan->Sortable = FALSE; // Allow sort
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;

		// size_cm
		$this->size_cm = new DbField('_barcode', 'barcode', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Nullable = FALSE; // NOT NULL field
		$this->size_cm->Required = TRUE; // Required field
		$this->size_cm->Sortable = FALSE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// 2srm
		$this->_2srm = new DbField('_barcode', 'barcode', 'x__2srm', '2srm', '`2srm`', '`2srm`', 4, -1, FALSE, '`2srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2srm->Nullable = FALSE; // NOT NULL field
		$this->_2srm->Required = TRUE; // Required field
		$this->_2srm->Sortable = FALSE; // Allow sort
		$this->_2srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['2srm'] = &$this->_2srm;

		// 4srm
		$this->_4srm = new DbField('_barcode', 'barcode', 'x__4srm', '4srm', '`4srm`', '`4srm`', 4, -1, FALSE, '`4srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4srm->Nullable = FALSE; // NOT NULL field
		$this->_4srm->Required = TRUE; // Required field
		$this->_4srm->Sortable = FALSE; // Allow sort
		$this->_4srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['4srm'] = &$this->_4srm;

		// RefID
		$this->RefID = new DbField('_barcode', 'barcode', 'x_RefID', 'RefID', '`RefID`', '`RefID`', 200, -1, FALSE, '`RefID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->RefID->Sortable = FALSE; // Allow sort
		$this->RefID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['RefID'] = &$this->RefID;

		// buyer_tid
		$this->buyer_tid = new DbField('_barcode', 'barcode', 'x_buyer_tid', 'buyer_tid', '`buyer_tid`', '`buyer_tid`', 200, -1, FALSE, '`buyer_tid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_tid->Sortable = FALSE; // Allow sort
		$this->fields['buyer_tid'] = &$this->buyer_tid;

		// grp
		$this->grp = new DbField('_barcode', 'barcode', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('_barcode', 'barcode', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 2, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product_type
		$this->product_type = new DbField('_barcode', 'barcode', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 2, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_type->Nullable = FALSE; // NOT NULL field
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = FALSE; // Allow sort
		$this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_type'] = &$this->product_type;

		// w_cm
		$this->w_cm = new DbField('_barcode', 'barcode', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 18, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Sortable = FALSE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['w_cm'] = &$this->w_cm;

		// l_cm
		$this->l_cm = new DbField('_barcode', 'barcode', 'x_l_cm', 'l_cm', '`l_cm`', '`l_cm`', 18, -1, FALSE, '`l_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l_cm->Sortable = FALSE; // Allow sort
		$this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['l_cm'] = &$this->l_cm;

		// 2srm_a
		$this->_2srm_a = new DbField('_barcode', 'barcode', 'x__2srm_a', '2srm_a', '`2srm_a`', '`2srm_a`', 4, -1, FALSE, '`2srm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2srm_a->Nullable = FALSE; // NOT NULL field
		$this->_2srm_a->Required = TRUE; // Required field
		$this->_2srm_a->Sortable = FALSE; // Allow sort
		$this->_2srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['2srm_a'] = &$this->_2srm_a;

		// 4srm_a
		$this->_4srm_a = new DbField('_barcode', 'barcode', 'x__4srm_a', '4srm_a', '`4srm_a`', '`4srm_a`', 4, -1, FALSE, '`4srm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4srm_a->Nullable = FALSE; // NOT NULL field
		$this->_4srm_a->Required = TRUE; // Required field
		$this->_4srm_a->Sortable = FALSE; // Allow sort
		$this->_4srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['4srm_a'] = &$this->_4srm_a;

		// category
		$this->category = new DbField('_barcode', 'barcode', 'x_category', 'category', '`category`', '`category`', 200, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->category->Nullable = FALSE; // NOT NULL field
		$this->category->Required = TRUE; // Required field
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->category->Lookup = new Lookup('category', 'product_category', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['category'] = &$this->category;

		// quantity
		$this->quantity = new DbField('_barcode', 'barcode', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = FALSE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// pl_no
		$this->pl_no = new DbField('_barcode', 'barcode', 'x_pl_no', 'pl_no', '`pl_no`', '`pl_no`', 131, -1, FALSE, '`pl_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pl_no->Nullable = FALSE; // NOT NULL field
		$this->pl_no->Sortable = TRUE; // Allow sort
		$this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pl_no'] = &$this->pl_no;

		// buyer_barcode
		$this->buyer_barcode = new DbField('_barcode', 'barcode', 'x_buyer_barcode', 'buyer_barcode', '`buyer_barcode`', '`buyer_barcode`', 200, -1, FALSE, '`buyer_barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_barcode->Sortable = TRUE; // Allow sort
		$this->fields['buyer_barcode'] = &$this->buyer_barcode;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`barcode`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT CONCAT(COALESCE(`barcode`, ''),'" . ValueSeparator(1, $this->_barcode) . "',COALESCE(`buyer_uid`,''),'" . ValueSeparator(2, $this->_barcode) . "',COALESCE(`buyer_loc`,'')) FROM `bcode` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`barcode` = `barcode`.`barcode` LIMIT 1) AS `EV___barcode`, (SELECT DISTINCT `code` FROM `buyer_seller_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `barcode`.`buyers_id` LIMIT 1) AS `EV__buyers_id`, (SELECT `batch_no` FROM `batch_no` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `barcode`.`batch_no` LIMIT 1) AS `EV__batch_no` FROM `barcode`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site() == 0)? "" : "FIND_IN_SET(`weaving_works`, " . User_Site() . ")";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`barcode` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->_barcode->AdvancedSearch->SearchValue <> "" ||
			$this->_barcode->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->_barcode->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->_barcode->VirtualExpression . " "))
			return TRUE;
		if ($this->buyers_id->AdvancedSearch->SearchValue <> "" ||
			$this->buyers_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->buyers_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->buyers_id->VirtualExpression . " "))
			return TRUE;
		if ($this->batch_no->AdvancedSearch->SearchValue <> "" ||
			$this->batch_no->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->batch_no->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->batch_no->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->po->DbValue = $row['po'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->design_id->DbValue = $row['design_id'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->design_size->DbValue = $row['design_size'];
		$this->sqm->DbValue = $row['sqm'];
		$this->sqm_a->DbValue = $row['sqm_a'];
		$this->status->DbValue = $row['status'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->cs->DbValue = $row['cs'];
		$this->weaving_works->DbValue = $row['weaving_works'];
		$this->current_works->DbValue = $row['current_works'];
		$this->process_c->DbValue = $row['process_c'];
		$this->process_d->DbValue = $row['process_d'];
		$this->remarks->DbValue = $row['remarks'];
		$this->p_remarks->DbValue = $row['p_remarks'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->weight->DbValue = $row['weight'];
		$this->buyer_po->DbValue = $row['buyer_po'];
		$this->buyer_uid_loc->DbValue = $row['buyer_uid_loc'];
		$this->order_date->DbValue = $row['order_date'];
		$this->completed->DbValue = $row['completed'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->process->DbValue = $row['process'];
		$this->id->DbValue = $row['id'];
		$this->pid->DbValue = $row['pid'];
		$this->shape->DbValue = $row['shape'];
		$this->production_plan->DbValue = $row['production_plan'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->_2srm->DbValue = $row['2srm'];
		$this->_4srm->DbValue = $row['4srm'];
		$this->RefID->DbValue = $row['RefID'];
		$this->buyer_tid->DbValue = $row['buyer_tid'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product_type->DbValue = $row['product_type'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->l_cm->DbValue = $row['l_cm'];
		$this->_2srm_a->DbValue = $row['2srm_a'];
		$this->_4srm_a->DbValue = $row['4srm_a'];
		$this->category->DbValue = $row['category'];
		$this->quantity->DbValue = $row['quantity'];
		$this->pl_no->DbValue = $row['pl_no'];
		$this->buyer_barcode->DbValue = $row['buyer_barcode'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "_barcodelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "_barcodeview.php")
			return $Language->phrase("View");
		elseif ($pageName == "_barcodeedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "_barcodeadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "_barcodelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("_barcodeview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("_barcodeview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "_barcodeadd.php?" . $this->getUrlParm($parm);
		else
			$url = "_barcodeadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("_barcodeedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("_barcodeadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("_barcodedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->po->setDbValue($rs->fields('po'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->design_size->setDbValue($rs->fields('design_size'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->sqm_a->setDbValue($rs->fields('sqm_a'));
		$this->status->setDbValue($rs->fields('status'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->cs->setDbValue($rs->fields('cs'));
		$this->weaving_works->setDbValue($rs->fields('weaving_works'));
		$this->current_works->setDbValue($rs->fields('current_works'));
		$this->process_c->setDbValue($rs->fields('process_c'));
		$this->process_d->setDbValue($rs->fields('process_d'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->p_remarks->setDbValue($rs->fields('p_remarks'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->weight->setDbValue($rs->fields('weight'));
		$this->buyer_po->setDbValue($rs->fields('buyer_po'));
		$this->buyer_uid_loc->setDbValue($rs->fields('buyer_uid_loc'));
		$this->order_date->setDbValue($rs->fields('order_date'));
		$this->completed->setDbValue($rs->fields('completed'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->process->setDbValue($rs->fields('process'));
		$this->id->setDbValue($rs->fields('id'));
		$this->pid->setDbValue($rs->fields('pid'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->_2srm->setDbValue($rs->fields('2srm'));
		$this->_4srm->setDbValue($rs->fields('4srm'));
		$this->RefID->setDbValue($rs->fields('RefID'));
		$this->buyer_tid->setDbValue($rs->fields('buyer_tid'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->l_cm->setDbValue($rs->fields('l_cm'));
		$this->_2srm_a->setDbValue($rs->fields('2srm_a'));
		$this->_4srm_a->setDbValue($rs->fields('4srm_a'));
		$this->category->setDbValue($rs->fields('category'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->pl_no->setDbValue($rs->fields('pl_no'));
		$this->buyer_barcode->setDbValue($rs->fields('buyer_barcode'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// po
		// despatch_week
		// barcode
		// buyers_id

		$this->buyers_id->CellCssStyle = "white-space: nowrap;";

		// design_id
		$this->design_id->CellCssStyle = "white-space: nowrap;";

		// buyer_ref
		// design_size
		// sqm
		// sqm_a

		$this->sqm_a->CellCssStyle = "white-space: nowrap;";

		// status
		// jc_no
		// cs
		// weaving_works
		// current_works
		// process_c
		// process_d
		// remarks
		// p_remarks
		// batch_no
		// weight
		// buyer_po
		// buyer_uid_loc
		// order_date
		// completed
		// operator

		$this->operator->CellCssStyle = "white-space: nowrap;";

		// datetime
		$this->datetime->CellCssStyle = "white-space: nowrap;";

		// process
		$this->process->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->CellCssStyle = "white-space: nowrap;";

		// pid
		$this->pid->CellCssStyle = "white-space: nowrap;";

		// shape
		$this->shape->CellCssStyle = "white-space: nowrap;";

		// production_plan
		$this->production_plan->CellCssStyle = "white-space: nowrap;";

		// size_cm
		$this->size_cm->CellCssStyle = "white-space: nowrap;";

		// 2srm
		$this->_2srm->CellCssStyle = "white-space: nowrap;";

		// 4srm
		$this->_4srm->CellCssStyle = "white-space: nowrap;";

		// RefID
		$this->RefID->CellCssStyle = "white-space: nowrap;";

		// buyer_tid
		$this->buyer_tid->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// product_type
		$this->product_type->CellCssStyle = "white-space: nowrap;";

		// w_cm
		$this->w_cm->CellCssStyle = "white-space: nowrap;";

		// l_cm
		$this->l_cm->CellCssStyle = "white-space: nowrap;";

		// 2srm_a
		$this->_2srm_a->CellCssStyle = "white-space: nowrap;";

		// 4srm_a
		$this->_4srm_a->CellCssStyle = "white-space: nowrap;";

		// category
		$this->category->CellCssStyle = "white-space: nowrap;";

		// quantity
		$this->quantity->CellCssStyle = "white-space: nowrap;";

		// pl_no
		// buyer_barcode
		// po

		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` >= DATE_FORMAT(NOW(), '%y%u')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// barcode
		if ($this->_barcode->VirtualValue <> "") {
			$this->_barcode->ViewValue = $this->_barcode->VirtualValue;
		} else {
		$curVal = strval($this->_barcode->CurrentValue);
		if ($curVal <> "") {
			$this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
			if ($this->_barcode->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`barcode`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->_barcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->_barcode->ViewValue = $this->_barcode->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
				}
			}
		} else {
			$this->_barcode->ViewValue = NULL;
		}
		}
		$this->_barcode->ViewCustomAttributes = "";

		// buyers_id
		if ($this->buyers_id->VirtualValue <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->VirtualValue;
		} else {
			$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "length(code)>0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->ViewValue = NULL;
		}
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// design_id
		$this->design_id->ViewValue = $this->design_id->CurrentValue;
		$this->design_id->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->ViewValue = NULL;
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// design_size
		$this->design_size->ViewValue = $this->design_size->CurrentValue;
		$this->design_size->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_a
		$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
		$this->sqm_a->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=1001 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
		$this->jc_no->ViewCustomAttributes = "";

		// cs
		if (strval($this->cs->CurrentValue) <> "") {
			$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
		} else {
			$this->cs->ViewValue = NULL;
		}
		$this->cs->ViewCustomAttributes = "";

		// weaving_works
		$curVal = strval($this->weaving_works->CurrentValue);
		if ($curVal <> "") {
			$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
				}
			}
		} else {
			$this->weaving_works->ViewValue = NULL;
		}
		$this->weaving_works->ViewCustomAttributes = "";

		// current_works
		$curVal = strval($this->current_works->CurrentValue);
		if ($curVal <> "") {
			$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
			if ($this->current_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->current_works->ViewValue = $this->current_works->CurrentValue;
				}
			}
		} else {
			$this->current_works->ViewValue = NULL;
		}
		$this->current_works->ViewCustomAttributes = "";

		// process_c
		$curVal = strval($this->process_c->CurrentValue);
		if ($curVal <> "") {
			$this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
			if ($this->process_c->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->process_c->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_c->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process_c->ViewValue = $this->process_c->CurrentValue;
				}
			}
		} else {
			$this->process_c->ViewValue = NULL;
		}
		$this->process_c->ViewCustomAttributes = "";

		// process_d
		$curVal = strval($this->process_d->CurrentValue);
		if ($curVal <> "") {
			$this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
			if ($this->process_d->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->process_d->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_d->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process_d->ViewValue = $this->process_d->CurrentValue;
				}
			}
		} else {
			$this->process_d->ViewValue = NULL;
		}
		$this->process_d->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// p_remarks
		$this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
		$this->p_remarks->ViewCustomAttributes = "";

		// batch_no
		if ($this->batch_no->VirtualValue <> "") {
			$this->batch_no->ViewValue = $this->batch_no->VirtualValue;
		} else {
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		}
		$this->batch_no->ViewCustomAttributes = "";

		// weight
		$this->weight->ViewValue = $this->weight->CurrentValue;
		$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
		$this->weight->ViewCustomAttributes = "";

		// buyer_po
		$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->ViewCustomAttributes = "";

		// buyer_uid_loc
		$this->buyer_uid_loc->ViewValue = $this->buyer_uid_loc->CurrentValue;
		$this->buyer_uid_loc->ViewCustomAttributes = "";

		// order_date
		$this->order_date->ViewValue = $this->order_date->CurrentValue;
		$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
		$this->order_date->ViewCustomAttributes = "";

		// completed
		if (strval($this->completed->CurrentValue) <> "") {
			$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
		} else {
			$this->completed->ViewValue = NULL;
		}
		$this->completed->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue->add($this->process->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pid
		$this->pid->ViewValue = $this->pid->CurrentValue;
		$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
		$this->pid->ViewCustomAttributes = "";

		// shape
		$this->shape->ViewValue = $this->shape->CurrentValue;
		$this->shape->ViewValue = FormatNumber($this->shape->ViewValue, 0, -2, -2, -2);
		$this->shape->ViewCustomAttributes = "";

		// production_plan
		$this->production_plan->ViewValue = $this->production_plan->CurrentValue;
		$this->production_plan->ViewValue = FormatNumber($this->production_plan->ViewValue, 0, -2, -2, -2);
		$this->production_plan->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// 2srm
		$this->_2srm->ViewValue = $this->_2srm->CurrentValue;
		$this->_2srm->ViewValue = FormatNumber($this->_2srm->ViewValue, 0, -2, -2, -2);
		$this->_2srm->ViewCustomAttributes = "";

		// 4srm
		$this->_4srm->ViewValue = $this->_4srm->CurrentValue;
		$this->_4srm->ViewValue = FormatNumber($this->_4srm->ViewValue, 0, -2, -2, -2);
		$this->_4srm->ViewCustomAttributes = "";

		// RefID
		$this->RefID->ViewValue = $this->RefID->CurrentValue;
		$this->RefID->ViewCustomAttributes = "";

		// buyer_tid
		$this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;
		$this->buyer_tid->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// product_type
		$this->product_type->ViewValue = $this->product_type->CurrentValue;
		$this->product_type->ViewValue = FormatNumber($this->product_type->ViewValue, 0, -2, -2, -2);
		$this->product_type->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 0, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// l_cm
		$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
		$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 0, -2, -2, -2);
		$this->l_cm->ViewCustomAttributes = "";

		// 2srm_a
		$this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
		$this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, 2, -2, -2, -2);
		$this->_2srm_a->ViewCustomAttributes = "";

		// 4srm_a
		$this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
		$this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, 2, -2, -2, -2);
		$this->_4srm_a->ViewCustomAttributes = "";

		// category
		$curVal = strval($this->category->CurrentValue);
		if ($curVal <> "") {
			$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			if ($this->category->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->category->ViewValue = $this->category->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->category->ViewValue = $this->category->CurrentValue;
				}
			}
		} else {
			$this->category->ViewValue = NULL;
		}
		$this->category->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// pl_no
		$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
		$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
		$this->pl_no->ViewCustomAttributes = "";

		// buyer_barcode
		$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
		$this->buyer_barcode->ViewCustomAttributes = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		$this->buyers_id->HrefValue = "";
		$this->buyers_id->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		$this->design_id->HrefValue = "";
		$this->design_id->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		$this->buyer_ref->HrefValue = "";
		$this->buyer_ref->TooltipValue = "";

		// design_size
		$this->design_size->LinkCustomAttributes = "";
		$this->design_size->HrefValue = "";
		$this->design_size->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// sqm_a
		$this->sqm_a->LinkCustomAttributes = "";
		$this->sqm_a->HrefValue = "";
		$this->sqm_a->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// cs
		$this->cs->LinkCustomAttributes = "";
		$this->cs->HrefValue = "";
		$this->cs->TooltipValue = "";

		// weaving_works
		$this->weaving_works->LinkCustomAttributes = "";
		$this->weaving_works->HrefValue = "";
		$this->weaving_works->TooltipValue = "";

		// current_works
		$this->current_works->LinkCustomAttributes = "";
		$this->current_works->HrefValue = "";
		$this->current_works->TooltipValue = "";

		// process_c
		$this->process_c->LinkCustomAttributes = "";
		$this->process_c->HrefValue = "";
		$this->process_c->TooltipValue = "";

		// process_d
		$this->process_d->LinkCustomAttributes = "";
		$this->process_d->HrefValue = "";
		$this->process_d->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// p_remarks
		$this->p_remarks->LinkCustomAttributes = "";
		$this->p_remarks->HrefValue = "";
		$this->p_remarks->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// weight
		$this->weight->LinkCustomAttributes = "";
		$this->weight->HrefValue = "";
		$this->weight->TooltipValue = "";

		// buyer_po
		$this->buyer_po->LinkCustomAttributes = "";
		$this->buyer_po->HrefValue = "";
		$this->buyer_po->TooltipValue = "";

		// buyer_uid_loc
		$this->buyer_uid_loc->LinkCustomAttributes = "";
		$this->buyer_uid_loc->HrefValue = "";
		$this->buyer_uid_loc->TooltipValue = "";

		// order_date
		$this->order_date->LinkCustomAttributes = "";
		$this->order_date->HrefValue = "";
		$this->order_date->TooltipValue = "";

		// completed
		$this->completed->LinkCustomAttributes = "";
		$this->completed->HrefValue = "";
		$this->completed->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// pid
		$this->pid->LinkCustomAttributes = "";
		$this->pid->HrefValue = "";
		$this->pid->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		$this->size_cm->HrefValue = "";
		$this->size_cm->TooltipValue = "";

		// 2srm
		$this->_2srm->LinkCustomAttributes = "";
		$this->_2srm->HrefValue = "";
		$this->_2srm->TooltipValue = "";

		// 4srm
		$this->_4srm->LinkCustomAttributes = "";
		$this->_4srm->HrefValue = "";
		$this->_4srm->TooltipValue = "";

		// RefID
		$this->RefID->LinkCustomAttributes = "";
		$this->RefID->HrefValue = "";
		$this->RefID->TooltipValue = "";

		// buyer_tid
		$this->buyer_tid->LinkCustomAttributes = "";
		$this->buyer_tid->HrefValue = "";
		$this->buyer_tid->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// l_cm
		$this->l_cm->LinkCustomAttributes = "";
		$this->l_cm->HrefValue = "";
		$this->l_cm->TooltipValue = "";

		// 2srm_a
		$this->_2srm_a->LinkCustomAttributes = "";
		$this->_2srm_a->HrefValue = "";
		$this->_2srm_a->TooltipValue = "";

		// 4srm_a
		$this->_4srm_a->LinkCustomAttributes = "";
		$this->_4srm_a->HrefValue = "";
		$this->_4srm_a->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// pl_no
		$this->pl_no->LinkCustomAttributes = "";
		$this->pl_no->HrefValue = "";
		$this->pl_no->TooltipValue = "";

		// buyer_barcode
		$this->buyer_barcode->LinkCustomAttributes = "";
		$this->buyer_barcode->HrefValue = "";
		$this->buyer_barcode->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
		$this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_id->CurrentValue = HtmlDecode($this->design_id->CurrentValue);
		$this->design_id->EditValue = $this->design_id->CurrentValue;
		$this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
		$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

		// design_size
		$this->design_size->EditAttrs["class"] = "form-control";
		$this->design_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_size->CurrentValue = HtmlDecode($this->design_size->CurrentValue);
		$this->design_size->EditValue = $this->design_size->CurrentValue;
		$this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// sqm_a
		$this->sqm_a->EditAttrs["class"] = "form-control";
		$this->sqm_a->EditCustomAttributes = "";
		$this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
		if (strval($this->sqm_a->EditValue) <> "" && is_numeric($this->sqm_a->EditValue))
			$this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, -2, -2, -2, -2);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// cs
		$this->cs->EditAttrs["class"] = "form-control";
		$this->cs->EditCustomAttributes = "";
		$this->cs->EditValue = $this->cs->options(TRUE);

		// weaving_works
		$this->weaving_works->EditAttrs["class"] = "form-control";
		$this->weaving_works->EditCustomAttributes = "";

		// current_works
		$this->current_works->EditAttrs["class"] = "form-control";
		$this->current_works->EditCustomAttributes = "";
		$curVal = strval($this->current_works->CurrentValue);
		if ($curVal <> "") {
			$this->current_works->EditValue = $this->current_works->lookupCacheOption($curVal);
			if ($this->current_works->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->current_works->EditValue = $this->current_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->current_works->EditValue = $this->current_works->CurrentValue;
				}
			}
		} else {
			$this->current_works->EditValue = NULL;
		}
		$this->current_works->ViewCustomAttributes = "";

		// process_c
		$this->process_c->EditAttrs["class"] = "form-control";
		$this->process_c->EditCustomAttributes = "";

		// process_d
		$this->process_d->EditAttrs["class"] = "form-control";
		$this->process_d->EditCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// p_remarks
		$this->p_remarks->EditAttrs["class"] = "form-control";
		$this->p_remarks->EditCustomAttributes = "";
		$this->p_remarks->EditValue = $this->p_remarks->CurrentValue;
		$this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// weight
		$this->weight->EditAttrs["class"] = "form-control";
		$this->weight->EditCustomAttributes = "";
		$this->weight->EditValue = $this->weight->CurrentValue;
		$this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
		if (strval($this->weight->EditValue) <> "" && is_numeric($this->weight->EditValue))
			$this->weight->EditValue = FormatNumber($this->weight->EditValue, -2, -2, -2, -2);

		// buyer_po
		$this->buyer_po->EditAttrs["class"] = "form-control";
		$this->buyer_po->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
		$this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

		// buyer_uid_loc
		$this->buyer_uid_loc->EditAttrs["class"] = "form-control";
		$this->buyer_uid_loc->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_uid_loc->CurrentValue = HtmlDecode($this->buyer_uid_loc->CurrentValue);
		$this->buyer_uid_loc->EditValue = $this->buyer_uid_loc->CurrentValue;
		$this->buyer_uid_loc->PlaceHolder = RemoveHtml($this->buyer_uid_loc->caption());

		// order_date
		$this->order_date->EditAttrs["class"] = "form-control";
		$this->order_date->EditCustomAttributes = "";
		$this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, 8);
		$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

		// completed
		$this->completed->EditAttrs["class"] = "form-control";
		$this->completed->EditCustomAttributes = "";
		$this->completed->EditValue = $this->completed->options(TRUE);

		// operator
		// datetime
		// process

		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pid
		$this->pid->EditAttrs["class"] = "form-control";
		$this->pid->EditCustomAttributes = "";
		$this->pid->EditValue = $this->pid->CurrentValue;
		$this->pid->PlaceHolder = RemoveHtml($this->pid->caption());
		if (strval($this->pid->EditValue) <> "" && is_numeric($this->pid->EditValue))
			$this->pid->EditValue = FormatNumber($this->pid->EditValue, -2, -2, -2, -2);

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";
		$this->shape->EditValue = $this->shape->CurrentValue;
		$this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";
		$this->production_plan->EditValue = $this->production_plan->CurrentValue;
		$this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

		// 2srm
		$this->_2srm->EditAttrs["class"] = "form-control";
		$this->_2srm->EditCustomAttributes = "";
		$this->_2srm->EditValue = $this->_2srm->CurrentValue;
		$this->_2srm->PlaceHolder = RemoveHtml($this->_2srm->caption());
		if (strval($this->_2srm->EditValue) <> "" && is_numeric($this->_2srm->EditValue))
			$this->_2srm->EditValue = FormatNumber($this->_2srm->EditValue, -2, -2, -2, -2);

		// 4srm
		$this->_4srm->EditAttrs["class"] = "form-control";
		$this->_4srm->EditCustomAttributes = "";
		$this->_4srm->EditValue = $this->_4srm->CurrentValue;
		$this->_4srm->PlaceHolder = RemoveHtml($this->_4srm->caption());
		if (strval($this->_4srm->EditValue) <> "" && is_numeric($this->_4srm->EditValue))
			$this->_4srm->EditValue = FormatNumber($this->_4srm->EditValue, -2, -2, -2, -2);

		// RefID
		$this->RefID->EditAttrs["class"] = "form-control";
		$this->RefID->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->RefID->CurrentValue = HtmlDecode($this->RefID->CurrentValue);
		$this->RefID->EditValue = $this->RefID->CurrentValue;
		$this->RefID->PlaceHolder = RemoveHtml($this->RefID->caption());

		// buyer_tid
		$this->buyer_tid->EditAttrs["class"] = "form-control";
		$this->buyer_tid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_tid->CurrentValue = HtmlDecode($this->buyer_tid->CurrentValue);
		$this->buyer_tid->EditValue = $this->buyer_tid->CurrentValue;
		$this->buyer_tid->PlaceHolder = RemoveHtml($this->buyer_tid->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";
		$this->product_type->EditValue = $this->product_type->CurrentValue;
		$this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = "";
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

		// l_cm
		$this->l_cm->EditAttrs["class"] = "form-control";
		$this->l_cm->EditCustomAttributes = "";
		$this->l_cm->EditValue = $this->l_cm->CurrentValue;
		$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

		// 2srm_a
		$this->_2srm_a->EditAttrs["class"] = "form-control";
		$this->_2srm_a->EditCustomAttributes = "";
		$this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
		$this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
		if (strval($this->_2srm_a->EditValue) <> "" && is_numeric($this->_2srm_a->EditValue))
			$this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, -2, -2, -2, -2);

		// 4srm_a
		$this->_4srm_a->EditAttrs["class"] = "form-control";
		$this->_4srm_a->EditCustomAttributes = "";
		$this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
		$this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
		if (strval($this->_4srm_a->EditValue) <> "" && is_numeric($this->_4srm_a->EditValue))
			$this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, -2, -2, -2, -2);

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

		// pl_no
		$this->pl_no->EditAttrs["class"] = "form-control";
		$this->pl_no->EditCustomAttributes = "";
		$this->pl_no->EditValue = $this->pl_no->CurrentValue;
		$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());
		if (strval($this->pl_no->EditValue) <> "" && is_numeric($this->pl_no->EditValue))
			$this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, -2, -2, -2, -2);

		// buyer_barcode
		$this->buyer_barcode->EditAttrs["class"] = "form-control";
		$this->buyer_barcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_barcode->CurrentValue = HtmlDecode($this->buyer_barcode->CurrentValue);
		$this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;
		$this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->design_size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->cs);
					$doc->exportCaption($this->weaving_works);
					$doc->exportCaption($this->current_works);
					$doc->exportCaption($this->process_c);
					$doc->exportCaption($this->process_d);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->p_remarks);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->weight);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->buyer_uid_loc);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->completed);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->buyer_barcode);
				} else {
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->design_size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->sqm_a);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->cs);
					$doc->exportCaption($this->weaving_works);
					$doc->exportCaption($this->current_works);
					$doc->exportCaption($this->process_c);
					$doc->exportCaption($this->process_d);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->p_remarks);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->weight);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->buyer_uid_loc);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->completed);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->buyer_barcode);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->po);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->design_size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->status);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->cs);
						$doc->exportField($this->weaving_works);
						$doc->exportField($this->current_works);
						$doc->exportField($this->process_c);
						$doc->exportField($this->process_d);
						$doc->exportField($this->remarks);
						$doc->exportField($this->p_remarks);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->weight);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->buyer_uid_loc);
						$doc->exportField($this->order_date);
						$doc->exportField($this->completed);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->buyer_barcode);
					} else {
						$doc->exportField($this->po);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->design_size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->sqm_a);
						$doc->exportField($this->status);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->cs);
						$doc->exportField($this->weaving_works);
						$doc->exportField($this->current_works);
						$doc->exportField($this->process_c);
						$doc->exportField($this->process_d);
						$doc->exportField($this->remarks);
						$doc->exportField($this->p_remarks);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->weight);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->buyer_uid_loc);
						$doc->exportField($this->order_date);
						$doc->exportField($this->completed);
						$doc->exportField($this->category);
						$doc->exportField($this->quantity);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->buyer_barcode);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->despatch_week, '');
				$doc->exportAggregate($this->_barcode, '');
				$doc->exportAggregate($this->buyers_id, '');
				$doc->exportAggregate($this->buyer_ref, '');
				$doc->exportAggregate($this->design_size, '');
				$doc->exportAggregate($this->sqm, 'TOTAL');
				$doc->exportAggregate($this->sqm_a, '');
				$doc->exportAggregate($this->status, '');
				$doc->exportAggregate($this->jc_no, '');
				$doc->exportAggregate($this->cs, '');
				$doc->exportAggregate($this->weaving_works, '');
				$doc->exportAggregate($this->current_works, '');
				$doc->exportAggregate($this->process_c, '');
				$doc->exportAggregate($this->process_d, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->exportAggregate($this->p_remarks, '');
				$doc->exportAggregate($this->batch_no, '');
				$doc->exportAggregate($this->weight, '');
				$doc->exportAggregate($this->buyer_po, '');
				$doc->exportAggregate($this->buyer_uid_loc, '');
				$doc->exportAggregate($this->order_date, '');
				$doc->exportAggregate($this->completed, '');
				$doc->exportAggregate($this->category, '');
				$doc->exportAggregate($this->quantity, '');
				$doc->exportAggregate($this->pl_no, '');
				$doc->exportAggregate($this->buyer_barcode, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>