<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class _barcode_search extends _barcode
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'barcode';

	// Page object name
	public $PageObjName = "_barcode_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (_barcode)
		if (!isset($GLOBALS["_barcode"]) || get_class($GLOBALS["_barcode"]) == PROJECT_NAMESPACE . "_barcode") {
			$GLOBALS["_barcode"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["_barcode"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'barcode');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $_barcode;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($_barcode);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "_barcodeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("_barcodelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->po->setVisibility();
		$this->despatch_week->setVisibility();
		$this->_barcode->setVisibility();
		$this->buyers_id->setVisibility();
		$this->design_id->Visible = FALSE;
		$this->buyer_ref->setVisibility();
		$this->design_size->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_a->Visible = FALSE;
		$this->status->setVisibility();
		$this->jc_no->setVisibility();
		$this->cs->setVisibility();
		$this->weaving_works->setVisibility();
		$this->current_works->setVisibility();
		$this->process_c->setVisibility();
		$this->process_d->setVisibility();
		$this->remarks->setVisibility();
		$this->p_remarks->setVisibility();
		$this->batch_no->setVisibility();
		$this->weight->setVisibility();
		$this->buyer_po->setVisibility();
		$this->buyer_uid_loc->setVisibility();
		$this->order_date->setVisibility();
		$this->completed->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->process->Visible = FALSE;
		$this->id->Visible = FALSE;
		$this->pid->setVisibility();
		$this->shape->Visible = FALSE;
		$this->production_plan->Visible = FALSE;
		$this->size_cm->Visible = FALSE;
		$this->_2srm->Visible = FALSE;
		$this->_4srm->Visible = FALSE;
		$this->RefID->Visible = FALSE;
		$this->buyer_tid->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->product_type->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->_2srm_a->Visible = FALSE;
		$this->_4srm_a->Visible = FALSE;
		$this->category->setVisibility();
		$this->quantity->Visible = FALSE;
		$this->pl_no->setVisibility();
		$this->buyer_barcode->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->_barcode);
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->buyer_ref);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->process_c);
		$this->setupLookupOptions($this->process_d);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->category);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "_barcodelist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
		$this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
		$this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
		$this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
		$this->buildSearchUrl($srchUrl, $this->design_size); // design_size
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
		$this->buildSearchUrl($srchUrl, $this->cs); // cs
		$this->buildSearchUrl($srchUrl, $this->weaving_works); // weaving_works
		$this->buildSearchUrl($srchUrl, $this->current_works); // current_works
		$this->buildSearchUrl($srchUrl, $this->process_c); // process_c
		$this->buildSearchUrl($srchUrl, $this->process_d); // process_d
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->p_remarks); // p_remarks
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->weight); // weight
		$this->buildSearchUrl($srchUrl, $this->buyer_po); // buyer_po
		$this->buildSearchUrl($srchUrl, $this->buyer_uid_loc); // buyer_uid_loc
		$this->buildSearchUrl($srchUrl, $this->order_date); // order_date
		$this->buildSearchUrl($srchUrl, $this->completed); // completed
		$this->buildSearchUrl($srchUrl, $this->pid); // pid
		$this->buildSearchUrl($srchUrl, $this->category); // category
		$this->buildSearchUrl($srchUrl, $this->pl_no); // pl_no
		$this->buildSearchUrl($srchUrl, $this->buyer_barcode); // buyer_barcode
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// po

		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));
		$this->po->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_po"));
		$this->po->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_po"));
		$this->po->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_po"));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_despatch_week"));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__barcode"));
		$this->_barcode->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v__barcode"));
		$this->_barcode->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w__barcode"));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyers_id"));
		$this->buyers_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyers_id"));

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_ref"));
		$this->buyer_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_ref"));

		// design_size
		if (!$this->isAddOrEdit())
			$this->design_size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design_size"));
		$this->design_size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design_size"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no"));
		$this->jc_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no"));

		// cs
		if (!$this->isAddOrEdit())
			$this->cs->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cs"));
		$this->cs->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cs"));

		// weaving_works
		if (!$this->isAddOrEdit())
			$this->weaving_works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_weaving_works"));
		$this->weaving_works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_weaving_works"));

		// current_works
		if (!$this->isAddOrEdit())
			$this->current_works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_current_works"));
		$this->current_works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_current_works"));

		// process_c
		if (!$this->isAddOrEdit())
			$this->process_c->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_c"));
		$this->process_c->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_c"));
		$this->process_c->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_process_c"));
		$this->process_c->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_process_c"));
		$this->process_c->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_process_c"));
		if (is_array($this->process_c->AdvancedSearch->SearchValue))
			$this->process_c->AdvancedSearch->SearchValue = implode(",", $this->process_c->AdvancedSearch->SearchValue);
		if (is_array($this->process_c->AdvancedSearch->SearchValue2))
			$this->process_c->AdvancedSearch->SearchValue2 = implode(",", $this->process_c->AdvancedSearch->SearchValue2);

		// process_d
		if (!$this->isAddOrEdit())
			$this->process_d->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_d"));
		$this->process_d->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_d"));
		$this->process_d->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_process_d"));
		$this->process_d->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_process_d"));
		$this->process_d->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_process_d"));
		if (is_array($this->process_d->AdvancedSearch->SearchValue))
			$this->process_d->AdvancedSearch->SearchValue = implode(",", $this->process_d->AdvancedSearch->SearchValue);
		if (is_array($this->process_d->AdvancedSearch->SearchValue2))
			$this->process_d->AdvancedSearch->SearchValue2 = implode(",", $this->process_d->AdvancedSearch->SearchValue2);

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// p_remarks
		if (!$this->isAddOrEdit())
			$this->p_remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p_remarks"));
		$this->p_remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p_remarks"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));

		// weight
		if (!$this->isAddOrEdit())
			$this->weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_weight"));
		$this->weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_weight"));

		// buyer_po
		if (!$this->isAddOrEdit())
			$this->buyer_po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_po"));
		$this->buyer_po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_po"));

		// buyer_uid_loc
		if (!$this->isAddOrEdit())
			$this->buyer_uid_loc->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_uid_loc"));
		$this->buyer_uid_loc->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_uid_loc"));

		// order_date
		if (!$this->isAddOrEdit())
			$this->order_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_date"));
		$this->order_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_date"));

		// completed
		if (!$this->isAddOrEdit())
			$this->completed->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_completed"));
		$this->completed->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_completed"));

		// pid
		if (!$this->isAddOrEdit())
			$this->pid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pid"));
		$this->pid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pid"));
		$this->pid->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_pid"));
		$this->pid->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_pid"));
		$this->pid->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_pid"));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));

		// pl_no
		if (!$this->isAddOrEdit())
			$this->pl_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_no"));
		$this->pl_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_no"));
		$this->pl_no->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_pl_no"));
		$this->pl_no->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_pl_no"));
		$this->pl_no->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_pl_no"));

		// buyer_barcode
		if (!$this->isAddOrEdit())
			$this->buyer_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_barcode"));
		$this->buyer_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_barcode"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight->FormValue == $this->weight->CurrentValue && is_numeric(ConvertToFloatString($this->weight->CurrentValue)))
			$this->weight->CurrentValue = ConvertToFloatString($this->weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pid->FormValue == $this->pid->CurrentValue && is_numeric(ConvertToFloatString($this->pid->CurrentValue)))
			$this->pid->CurrentValue = ConvertToFloatString($this->pid->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pl_no->FormValue == $this->pl_no->CurrentValue && is_numeric(ConvertToFloatString($this->pl_no->CurrentValue)))
			$this->pl_no->CurrentValue = ConvertToFloatString($this->pl_no->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// po
		// despatch_week
		// barcode
		// buyers_id
		// design_id
		// buyer_ref
		// design_size
		// sqm
		// sqm_a
		// status
		// jc_no
		// cs
		// weaving_works
		// current_works
		// process_c
		// process_d
		// remarks
		// p_remarks
		// batch_no
		// weight
		// buyer_po
		// buyer_uid_loc
		// order_date
		// completed
		// operator
		// datetime
		// process
		// id
		// pid
		// shape
		// production_plan
		// size_cm
		// 2srm
		// 4srm
		// RefID
		// buyer_tid
		// grp
		// s_grp
		// product_type
		// w_cm
		// l_cm
		// 2srm_a
		// 4srm_a
		// category
		// quantity
		// pl_no
		// buyer_barcode

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` >= DATE_FORMAT(NOW(), '%y%u')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// barcode
			if ($this->_barcode->VirtualValue <> "") {
				$this->_barcode->ViewValue = $this->_barcode->VirtualValue;
			} else {
			$curVal = strval($this->_barcode->CurrentValue);
			if ($curVal <> "") {
				$this->_barcode->ViewValue = $this->_barcode->lookupCacheOption($curVal);
				if ($this->_barcode->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`barcode`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->_barcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->_barcode->ViewValue = $this->_barcode->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
					}
				}
			} else {
				$this->_barcode->ViewValue = NULL;
			}
			}
			$this->_barcode->ViewCustomAttributes = "";

			// buyers_id
			if ($this->buyers_id->VirtualValue <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->VirtualValue;
			} else {
				$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "length(code)>0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
			$curVal = strval($this->buyer_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_ref->ViewValue = NULL;
			}
			$this->buyer_ref->ViewCustomAttributes = "";

			// design_size
			$this->design_size->ViewValue = $this->design_size->CurrentValue;
			$this->design_size->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_a
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=1001 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// cs
			if (strval($this->cs->CurrentValue) <> "") {
				$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
			} else {
				$this->cs->ViewValue = NULL;
			}
			$this->cs->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// process_c
			$curVal = strval($this->process_c->CurrentValue);
			if ($curVal <> "") {
				$this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
				if ($this->process_c->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->process_c->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_c->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_c->ViewValue = $this->process_c->CurrentValue;
					}
				}
			} else {
				$this->process_c->ViewValue = NULL;
			}
			$this->process_c->ViewCustomAttributes = "";

			// process_d
			$curVal = strval($this->process_d->CurrentValue);
			if ($curVal <> "") {
				$this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
				if ($this->process_d->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->process_d->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_d->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_d->ViewValue = $this->process_d->CurrentValue;
					}
				}
			} else {
				$this->process_d->ViewValue = NULL;
			}
			$this->process_d->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// p_remarks
			$this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
			$this->p_remarks->ViewCustomAttributes = "";

			// batch_no
			if ($this->batch_no->VirtualValue <> "") {
				$this->batch_no->ViewValue = $this->batch_no->VirtualValue;
			} else {
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			}
			$this->batch_no->ViewCustomAttributes = "";

			// weight
			$this->weight->ViewValue = $this->weight->CurrentValue;
			$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
			$this->weight->ViewCustomAttributes = "";

			// buyer_po
			$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
			$this->buyer_po->ViewCustomAttributes = "";

			// buyer_uid_loc
			$this->buyer_uid_loc->ViewValue = $this->buyer_uid_loc->CurrentValue;
			$this->buyer_uid_loc->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
			$this->order_date->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// pid
			$this->pid->ViewValue = $this->pid->CurrentValue;
			$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
			$this->pid->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// buyer_barcode
			$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
			$this->buyer_barcode->ViewCustomAttributes = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			$this->buyers_id->HrefValue = "";
			$this->buyers_id->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";

			// design_size
			$this->design_size->LinkCustomAttributes = "";
			$this->design_size->HrefValue = "";
			$this->design_size->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// cs
			$this->cs->LinkCustomAttributes = "";
			$this->cs->HrefValue = "";
			$this->cs->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";
			$this->current_works->TooltipValue = "";

			// process_c
			$this->process_c->LinkCustomAttributes = "";
			$this->process_c->HrefValue = "";
			$this->process_c->TooltipValue = "";

			// process_d
			$this->process_d->LinkCustomAttributes = "";
			$this->process_d->HrefValue = "";
			$this->process_d->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// p_remarks
			$this->p_remarks->LinkCustomAttributes = "";
			$this->p_remarks->HrefValue = "";
			$this->p_remarks->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// weight
			$this->weight->LinkCustomAttributes = "";
			$this->weight->HrefValue = "";
			$this->weight->TooltipValue = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";
			$this->buyer_po->TooltipValue = "";

			// buyer_uid_loc
			$this->buyer_uid_loc->LinkCustomAttributes = "";
			$this->buyer_uid_loc->HrefValue = "";
			$this->buyer_uid_loc->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";
			$this->completed->TooltipValue = "";

			// pid
			$this->pid->LinkCustomAttributes = "";
			$this->pid->HrefValue = "";
			$this->pid->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// buyer_barcode
			$this->buyer_barcode->LinkCustomAttributes = "";
			$this->buyer_barcode->HrefValue = "";
			$this->buyer_barcode->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` >= DATE_FORMAT(NOW(), '%y%u')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue2 = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue2 = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->despatch_week->EditValue2 = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue2, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` >= DATE_FORMAT(NOW(), '%y%u')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue2 = $arwrk;
			}

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue2 = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue2);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$this->buyers_id->EditValue = HtmlEncode($this->buyers_id->AdvancedSearch->SearchValue);
			$this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$curVal = strval($this->buyer_ref->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->buyer_ref->EditValue = NULL;
			}
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// design_size
			$this->design_size->EditAttrs["class"] = "form-control";
			$this->design_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design_size->AdvancedSearch->SearchValue = HtmlDecode($this->design_size->AdvancedSearch->SearchValue);
			$this->design_size->EditValue = HtmlEncode($this->design_size->AdvancedSearch->SearchValue);
			$this->design_size->PlaceHolder = RemoveHtml($this->design_size->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=1001 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// cs
			$this->cs->EditAttrs["class"] = "form-control";
			$this->cs->EditCustomAttributes = "";
			$this->cs->EditValue = $this->cs->options(TRUE);

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->weaving_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			else
				$this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->Lookup !== NULL && is_array($this->weaving_works->Lookup->Options) ? $curVal : NULL;
			if ($this->weaving_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->weaving_works->EditValue = array_values($this->weaving_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->weaving_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->weaving_works->EditValue = $arwrk;
			}

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
			else
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== NULL && is_array($this->current_works->Lookup->Options) ? $curVal : NULL;
			if ($this->current_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->current_works->EditValue = array_values($this->current_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->current_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->current_works->EditValue = $arwrk;
			}

			// process_c
			$this->process_c->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_c->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process_c->AdvancedSearch->ViewValue = $this->process_c->lookupCacheOption($curVal);
			else
				$this->process_c->AdvancedSearch->ViewValue = $this->process_c->Lookup !== NULL && is_array($this->process_c->Lookup->Options) ? $curVal : NULL;
			if ($this->process_c->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process_c->EditValue = array_values($this->process_c->Lookup->Options);
				if ($this->process_c->AdvancedSearch->ViewValue == "")
					$this->process_c->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->process_c->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_c->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->process_c->AdvancedSearch->ViewValue->add($this->process_c->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->process_c->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_c->EditValue = $arwrk;
			}
			$this->process_c->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_c->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->process_c->AdvancedSearch->ViewValue2 = $this->process_c->lookupCacheOption($curVal);
			else
				$this->process_c->AdvancedSearch->ViewValue2 = $this->process_c->Lookup !== NULL && is_array($this->process_c->Lookup->Options) ? $curVal : NULL;
			if ($this->process_c->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->process_c->EditValue2 = array_values($this->process_c->Lookup->Options);
				if ($this->process_c->AdvancedSearch->ViewValue2 == "")
					$this->process_c->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->process_c->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_c->AdvancedSearch->ViewValue2 = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->process_c->AdvancedSearch->ViewValue2->add($this->process_c->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->process_c->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_c->EditValue2 = $arwrk;
			}

			// process_d
			$this->process_d->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_d->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process_d->AdvancedSearch->ViewValue = $this->process_d->lookupCacheOption($curVal);
			else
				$this->process_d->AdvancedSearch->ViewValue = $this->process_d->Lookup !== NULL && is_array($this->process_d->Lookup->Options) ? $curVal : NULL;
			if ($this->process_d->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process_d->EditValue = array_values($this->process_d->Lookup->Options);
				if ($this->process_d->AdvancedSearch->ViewValue == "")
					$this->process_d->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->process_d->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_d->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->process_d->AdvancedSearch->ViewValue->add($this->process_d->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->process_d->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_d->EditValue = $arwrk;
			}
			$this->process_d->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_d->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->process_d->AdvancedSearch->ViewValue2 = $this->process_d->lookupCacheOption($curVal);
			else
				$this->process_d->AdvancedSearch->ViewValue2 = $this->process_d->Lookup !== NULL && is_array($this->process_d->Lookup->Options) ? $curVal : NULL;
			if ($this->process_d->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->process_d->EditValue2 = array_values($this->process_d->Lookup->Options);
				if ($this->process_d->AdvancedSearch->ViewValue2 == "")
					$this->process_d->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->process_d->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_d->AdvancedSearch->ViewValue2 = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->process_d->AdvancedSearch->ViewValue2->add($this->process_d->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->process_d->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_d->EditValue2 = $arwrk;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// p_remarks
			$this->p_remarks->EditAttrs["class"] = "form-control";
			$this->p_remarks->EditCustomAttributes = "";
			$this->p_remarks->EditValue = HtmlEncode($this->p_remarks->AdvancedSearch->SearchValue);
			$this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->AdvancedSearch->SearchValue);
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

			// weight
			$this->weight->EditAttrs["class"] = "form-control";
			$this->weight->EditCustomAttributes = "";
			$this->weight->EditValue = HtmlEncode($this->weight->AdvancedSearch->SearchValue);
			$this->weight->PlaceHolder = RemoveHtml($this->weight->caption());

			// buyer_po
			$this->buyer_po->EditAttrs["class"] = "form-control";
			$this->buyer_po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

			// buyer_uid_loc
			$this->buyer_uid_loc->EditAttrs["class"] = "form-control";
			$this->buyer_uid_loc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_uid_loc->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_uid_loc->AdvancedSearch->SearchValue);
			$this->buyer_uid_loc->EditValue = HtmlEncode($this->buyer_uid_loc->AdvancedSearch->SearchValue);
			$this->buyer_uid_loc->PlaceHolder = RemoveHtml($this->buyer_uid_loc->caption());

			// order_date
			$this->order_date->EditAttrs["class"] = "form-control";
			$this->order_date->EditCustomAttributes = "";
			$this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, 0), 8));
			$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

			// completed
			$this->completed->EditAttrs["class"] = "form-control";
			$this->completed->EditCustomAttributes = "";
			$this->completed->EditValue = $this->completed->options(TRUE);

			// pid
			$this->pid->EditAttrs["class"] = "form-control";
			$this->pid->EditCustomAttributes = "";
			$this->pid->EditValue = HtmlEncode($this->pid->AdvancedSearch->SearchValue);
			$this->pid->PlaceHolder = RemoveHtml($this->pid->caption());
			$this->pid->EditAttrs["class"] = "form-control";
			$this->pid->EditCustomAttributes = "";
			$this->pid->EditValue2 = HtmlEncode($this->pid->AdvancedSearch->SearchValue2);
			$this->pid->PlaceHolder = RemoveHtml($this->pid->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			$this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			$this->pl_no->EditValue2 = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue2);
			$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

			// buyer_barcode
			$this->buyer_barcode->EditAttrs["class"] = "form-control";
			$this->buyer_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->design_size->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->design_size->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->jc_no->errorMessage());
		}
		if (!CheckNumber($this->weight->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->weight->errorMessage());
		}
		if (!CheckDate($this->order_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->order_date->errorMessage());
		}
		if (!CheckInteger($this->pid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pid->errorMessage());
		}
		if (!CheckInteger($this->pid->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->pid->errorMessage());
		}
		if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pl_no->errorMessage());
		}
		if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->pl_no->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->po->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->design_size->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->cs->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->process_c->AdvancedSearch->load();
		$this->process_d->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->p_remarks->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->weight->AdvancedSearch->load();
		$this->buyer_po->AdvancedSearch->load();
		$this->buyer_uid_loc->AdvancedSearch->load();
		$this->order_date->AdvancedSearch->load();
		$this->completed->AdvancedSearch->load();
		$this->pid->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->buyer_barcode->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("_barcodelist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_despatch_week":
					$lookupFilter = function() {
						return "`id` >= DATE_FORMAT(NOW(), '%y%u')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyers_id":
					$lookupFilter = function() {
						return "length(code)>0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`grp`=1001 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_weaving_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_despatch_week":
							break;
						case "x__barcode":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_buyers_id":
							break;
						case "x_buyer_ref":
							break;
						case "x_status":
							break;
						case "x_weaving_works":
							break;
						case "x_current_works":
							break;
						case "x_process_c":
							break;
						case "x_process_d":
							break;
						case "x_batch_no":
							break;
						case "x_process":
							break;
						case "x_category":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>