<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for l_examination_report
 */
class _l_examination_report extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $d_id;
	public $mobile;
	public $name;
	public $examination_code;
	public $diagnosis_value;
	public $diagnosis_st_min;
	public $diagnosis_st_max;
	public $diagnosis_unit;
	public $balance_amount;
	public $age;
	public $sex;
	public $referral;
	public $remarks;
	public $examination_grp;
	public $diagnosis_datetime;
	public $import_value;
	public $total_amount;
	public $discount_amount;
	public $received_amount;
	public $examination_id;
	public $examination_name;
	public $uid;
	public $operator;
	public $datetime;
	public $user;
	public $report_grp;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = '_l_examination_report';
		$this->TableName = 'l_examination_report';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`l_examination_report`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// d_id
		$this->d_id = new DbField('_l_examination_report', 'l_examination_report', 'x_d_id', 'd_id', '`d_id`', '`d_id`', 3, -1, FALSE, '`d_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_id->Nullable = FALSE; // NOT NULL field
		$this->d_id->Required = TRUE; // Required field
		$this->d_id->Sortable = TRUE; // Allow sort
		$this->d_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_id'] = &$this->d_id;

		// mobile
		$this->mobile = new DbField('_l_examination_report', 'l_examination_report', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 200, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Required = TRUE; // Required field
		$this->mobile->Sortable = TRUE; // Allow sort
		$this->mobile->Lookup = new Lookup('mobile', 'user', TRUE, 'mobile', ["mobile","","",""], [], ["x_name"], [], [], ["name"], ["x_name"], '`mobile` ASC', '');
		$this->fields['mobile'] = &$this->mobile;

		// name
		$this->name = new DbField('_l_examination_report', 'l_examination_report', 'x_name', 'name', '`name`', '`name`', 200, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Required = TRUE; // Required field
		$this->name->Sortable = TRUE; // Allow sort
		$this->name->Lookup = new Lookup('name', 'l_examination', TRUE, 'name', ["name","","",""], ["x_mobile"], [], ["mobile"], ["x_mobile"], ["mobile"], ["x_mobile"], '`name` ASC', '');
		$this->fields['name'] = &$this->name;

		// examination_code
		$this->examination_code = new DbField('_l_examination_report', 'l_examination_report', 'x_examination_code', 'examination_code', '`examination_code`', '`examination_code`', 200, -1, FALSE, '`examination_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->examination_code->Nullable = FALSE; // NOT NULL field
		$this->examination_code->Required = TRUE; // Required field
		$this->examination_code->Sortable = TRUE; // Allow sort
		$this->fields['examination_code'] = &$this->examination_code;

		// diagnosis_value
		$this->diagnosis_value = new DbField('_l_examination_report', 'l_examination_report', 'x_diagnosis_value', 'diagnosis_value', '`diagnosis_value`', '`diagnosis_value`', 200, -1, FALSE, '`diagnosis_value`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diagnosis_value->Sortable = TRUE; // Allow sort
		$this->fields['diagnosis_value'] = &$this->diagnosis_value;

		// diagnosis_st_min
		$this->diagnosis_st_min = new DbField('_l_examination_report', 'l_examination_report', 'x_diagnosis_st_min', 'diagnosis_st_min', '`diagnosis_st_min`', '`diagnosis_st_min`', 131, -1, FALSE, '`diagnosis_st_min`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diagnosis_st_min->Sortable = TRUE; // Allow sort
		$this->fields['diagnosis_st_min'] = &$this->diagnosis_st_min;

		// diagnosis_st_max
		$this->diagnosis_st_max = new DbField('_l_examination_report', 'l_examination_report', 'x_diagnosis_st_max', 'diagnosis_st_max', '`diagnosis_st_max`', '`diagnosis_st_max`', 131, -1, FALSE, '`diagnosis_st_max`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diagnosis_st_max->Sortable = TRUE; // Allow sort
		$this->diagnosis_st_max->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diagnosis_st_max'] = &$this->diagnosis_st_max;

		// diagnosis_unit
		$this->diagnosis_unit = new DbField('_l_examination_report', 'l_examination_report', 'x_diagnosis_unit', 'diagnosis_unit', '`diagnosis_unit`', '`diagnosis_unit`', 200, -1, FALSE, '`diagnosis_unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diagnosis_unit->Sortable = TRUE; // Allow sort
		$this->fields['diagnosis_unit'] = &$this->diagnosis_unit;

		// balance_amount
		$this->balance_amount = new DbField('_l_examination_report', 'l_examination_report', 'x_balance_amount', 'balance_amount', '`balance_amount`', '`balance_amount`', 131, -1, FALSE, '`balance_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance_amount->Nullable = FALSE; // NOT NULL field
		$this->balance_amount->Sortable = TRUE; // Allow sort
		$this->balance_amount->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['balance_amount'] = &$this->balance_amount;

		// age
		$this->age = new DbField('_l_examination_report', 'l_examination_report', 'x_age', 'age', '`age`', '`age`', 17, -1, FALSE, '`age`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->age->Nullable = FALSE; // NOT NULL field
		$this->age->Required = TRUE; // Required field
		$this->age->Sortable = TRUE; // Allow sort
		$this->age->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['age'] = &$this->age;

		// sex
		$this->sex = new DbField('_l_examination_report', 'l_examination_report', 'x_sex', 'sex', '`sex`', '`sex`', 17, -1, FALSE, '`sex`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->sex->Nullable = FALSE; // NOT NULL field
		$this->sex->Required = TRUE; // Required field
		$this->sex->Sortable = TRUE; // Allow sort
		$this->sex->Lookup = new Lookup('sex', '_l_examination_report', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->sex->OptionCount = 3;
		$this->sex->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sex'] = &$this->sex;

		// referral
		$this->referral = new DbField('_l_examination_report', 'l_examination_report', 'x_referral', 'referral', '`referral`', '`referral`', 18, -1, FALSE, '`referral`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->referral->Sortable = TRUE; // Allow sort
		$this->referral->Lookup = new Lookup('referral', 'l_referral', FALSE, 'id', ["name","mobile","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->referral->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['referral'] = &$this->referral;

		// remarks
		$this->remarks = new DbField('_l_examination_report', 'l_examination_report', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// examination_grp
		$this->examination_grp = new DbField('_l_examination_report', 'l_examination_report', 'x_examination_grp', 'examination_grp', '`examination_grp`', '`examination_grp`', 18, -1, FALSE, '`examination_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->examination_grp->Nullable = FALSE; // NOT NULL field
		$this->examination_grp->Required = TRUE; // Required field
		$this->examination_grp->Sortable = TRUE; // Allow sort
		$this->examination_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->examination_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->examination_grp->Lookup = new Lookup('examination_grp', 'l_examination_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->examination_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['examination_grp'] = &$this->examination_grp;

		// diagnosis_datetime
		$this->diagnosis_datetime = new DbField('_l_examination_report', 'l_examination_report', 'x_diagnosis_datetime', 'diagnosis_datetime', '`diagnosis_datetime`', CastDateFieldForLike('`diagnosis_datetime`', 0, "DB"), 135, 0, FALSE, '`diagnosis_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diagnosis_datetime->Sortable = TRUE; // Allow sort
		$this->diagnosis_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['diagnosis_datetime'] = &$this->diagnosis_datetime;

		// import_value
		$this->import_value = new DbField('_l_examination_report', 'l_examination_report', 'x_import_value', 'import_value', '`import_value`', '`import_value`', 201, -1, FALSE, '`import_value`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->import_value->Nullable = FALSE; // NOT NULL field
		$this->import_value->Required = TRUE; // Required field
		$this->import_value->Sortable = TRUE; // Allow sort
		$this->fields['import_value'] = &$this->import_value;

		// total_amount
		$this->total_amount = new DbField('_l_examination_report', 'l_examination_report', 'x_total_amount', 'total_amount', '`total_amount`', '`total_amount`', 131, -1, FALSE, '`total_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->total_amount->Nullable = FALSE; // NOT NULL field
		$this->total_amount->Sortable = TRUE; // Allow sort
		$this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['total_amount'] = &$this->total_amount;

		// discount_amount
		$this->discount_amount = new DbField('_l_examination_report', 'l_examination_report', 'x_discount_amount', 'discount_amount', '`discount_amount`', '`discount_amount`', 131, -1, FALSE, '`discount_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->discount_amount->Nullable = FALSE; // NOT NULL field
		$this->discount_amount->Sortable = TRUE; // Allow sort
		$this->discount_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['discount_amount'] = &$this->discount_amount;

		// received_amount
		$this->received_amount = new DbField('_l_examination_report', 'l_examination_report', 'x_received_amount', 'received_amount', '`received_amount`', '`received_amount`', 131, -1, FALSE, '`received_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->received_amount->Nullable = FALSE; // NOT NULL field
		$this->received_amount->Sortable = TRUE; // Allow sort
		$this->received_amount->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['received_amount'] = &$this->received_amount;

		// examination_id
		$this->examination_id = new DbField('_l_examination_report', 'l_examination_report', 'x_examination_id', 'examination_id', '`examination_id`', '`examination_id`', 18, -1, FALSE, '`examination_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->examination_id->Sortable = TRUE; // Allow sort
		$this->examination_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['examination_id'] = &$this->examination_id;

		// examination_name
		$this->examination_name = new DbField('_l_examination_report', 'l_examination_report', 'x_examination_name', 'examination_name', '`examination_name`', '`examination_name`', 200, -1, FALSE, '`examination_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->examination_name->Nullable = FALSE; // NOT NULL field
		$this->examination_name->Required = TRUE; // Required field
		$this->examination_name->Sortable = TRUE; // Allow sort
		$this->fields['examination_name'] = &$this->examination_name;

		// uid
		$this->uid = new DbField('_l_examination_report', 'l_examination_report', 'x_uid', 'uid', '`uid`', '`uid`', 200, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->uid->IsPrimaryKey = TRUE; // Primary key field
		$this->uid->Nullable = FALSE; // NOT NULL field
		$this->uid->Required = TRUE; // Required field
		$this->uid->Sortable = TRUE; // Allow sort
		$this->fields['uid'] = &$this->uid;

		// operator
		$this->operator = new DbField('_l_examination_report', 'l_examination_report', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('_l_examination_report', 'l_examination_report', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// user
		$this->user = new DbField('_l_examination_report', 'l_examination_report', 'x_user', 'user', '`user`', '`user`', 18, -1, FALSE, '`user`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->user->Nullable = FALSE; // NOT NULL field
		$this->user->Required = TRUE; // Required field
		$this->user->Sortable = TRUE; // Allow sort
		$this->user->Lookup = new Lookup('user', 'user', TRUE, 'id', ["mobile","id","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['user'] = &$this->user;

		// report_grp
		$this->report_grp = new DbField('_l_examination_report', 'l_examination_report', 'x_report_grp', 'report_grp', '`report_grp`', '`report_grp`', 18, -1, FALSE, '`report_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->report_grp->Sortable = FALSE; // Allow sort
		$this->report_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['report_grp'] = &$this->report_grp;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`l_examination_report`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('uid', $rs))
				AddFilter($where, QuotedName('uid', $this->Dbid) . '=' . QuotedValue($rs['uid'], $this->uid->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->d_id->DbValue = $row['d_id'];
		$this->mobile->DbValue = $row['mobile'];
		$this->name->DbValue = $row['name'];
		$this->examination_code->DbValue = $row['examination_code'];
		$this->diagnosis_value->DbValue = $row['diagnosis_value'];
		$this->diagnosis_st_min->DbValue = $row['diagnosis_st_min'];
		$this->diagnosis_st_max->DbValue = $row['diagnosis_st_max'];
		$this->diagnosis_unit->DbValue = $row['diagnosis_unit'];
		$this->balance_amount->DbValue = $row['balance_amount'];
		$this->age->DbValue = $row['age'];
		$this->sex->DbValue = $row['sex'];
		$this->referral->DbValue = $row['referral'];
		$this->remarks->DbValue = $row['remarks'];
		$this->examination_grp->DbValue = $row['examination_grp'];
		$this->diagnosis_datetime->DbValue = $row['diagnosis_datetime'];
		$this->import_value->DbValue = $row['import_value'];
		$this->total_amount->DbValue = $row['total_amount'];
		$this->discount_amount->DbValue = $row['discount_amount'];
		$this->received_amount->DbValue = $row['received_amount'];
		$this->examination_id->DbValue = $row['examination_id'];
		$this->examination_name->DbValue = $row['examination_name'];
		$this->uid->DbValue = $row['uid'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->user->DbValue = $row['user'];
		$this->report_grp->DbValue = $row['report_grp'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`uid` = '@uid@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('uid', $row) ? $row['uid'] : NULL) : $this->uid->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@uid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "_l_examination_reportlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "_l_examination_reportview.php")
			return $Language->phrase("View");
		elseif ($pageName == "_l_examination_reportedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "_l_examination_reportadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "_l_examination_reportlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("_l_examination_reportview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("_l_examination_reportview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "_l_examination_reportadd.php?" . $this->getUrlParm($parm);
		else
			$url = "_l_examination_reportadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("_l_examination_reportedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("_l_examination_reportadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("_l_examination_reportdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "uid:" . JsonEncode($this->uid->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->uid->CurrentValue != NULL) {
			$url .= "uid=" . urlencode($this->uid->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("uid") !== NULL)
				$arKeys[] = Param("uid");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->uid->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->d_id->setDbValue($rs->fields('d_id'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->name->setDbValue($rs->fields('name'));
		$this->examination_code->setDbValue($rs->fields('examination_code'));
		$this->diagnosis_value->setDbValue($rs->fields('diagnosis_value'));
		$this->diagnosis_st_min->setDbValue($rs->fields('diagnosis_st_min'));
		$this->diagnosis_st_max->setDbValue($rs->fields('diagnosis_st_max'));
		$this->diagnosis_unit->setDbValue($rs->fields('diagnosis_unit'));
		$this->balance_amount->setDbValue($rs->fields('balance_amount'));
		$this->age->setDbValue($rs->fields('age'));
		$this->sex->setDbValue($rs->fields('sex'));
		$this->referral->setDbValue($rs->fields('referral'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->examination_grp->setDbValue($rs->fields('examination_grp'));
		$this->diagnosis_datetime->setDbValue($rs->fields('diagnosis_datetime'));
		$this->import_value->setDbValue($rs->fields('import_value'));
		$this->total_amount->setDbValue($rs->fields('total_amount'));
		$this->discount_amount->setDbValue($rs->fields('discount_amount'));
		$this->received_amount->setDbValue($rs->fields('received_amount'));
		$this->examination_id->setDbValue($rs->fields('examination_id'));
		$this->examination_name->setDbValue($rs->fields('examination_name'));
		$this->uid->setDbValue($rs->fields('uid'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->user->setDbValue($rs->fields('user'));
		$this->report_grp->setDbValue($rs->fields('report_grp'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// d_id
		// mobile
		// name
		// examination_code
		// diagnosis_value
		// diagnosis_st_min
		// diagnosis_st_max
		// diagnosis_unit
		// balance_amount
		// age
		// sex
		// referral
		// remarks
		// examination_grp
		// diagnosis_datetime
		// import_value
		// total_amount
		// discount_amount
		// received_amount
		// examination_id
		// examination_name
		// uid
		// operator
		// datetime
		// user
		// report_grp

		$this->report_grp->CellCssStyle = "white-space: nowrap;";

		// d_id
		$this->d_id->ViewValue = $this->d_id->CurrentValue;
		$this->d_id->ViewValue = FormatNumber($this->d_id->ViewValue, 0, -2, -2, -2);
		$this->d_id->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$curVal = strval($this->mobile->CurrentValue);
		if ($curVal <> "") {
			$this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
			if ($this->mobile->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`mobile`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->mobile->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->mobile->ViewValue = $this->mobile->CurrentValue;
				}
			}
		} else {
			$this->mobile->ViewValue = NULL;
		}
		$this->mobile->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$curVal = strval($this->name->CurrentValue);
		if ($curVal <> "") {
			$this->name->ViewValue = $this->name->lookupCacheOption($curVal);
			if ($this->name->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`name`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->name->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->name->ViewValue = $this->name->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->name->ViewValue = $this->name->CurrentValue;
				}
			}
		} else {
			$this->name->ViewValue = NULL;
		}
		$this->name->ViewCustomAttributes = "";

		// examination_code
		$this->examination_code->ViewValue = $this->examination_code->CurrentValue;
		$this->examination_code->ViewCustomAttributes = "";

		// diagnosis_value
		$this->diagnosis_value->ViewValue = $this->diagnosis_value->CurrentValue;
		$this->diagnosis_value->ViewCustomAttributes = "";

		// diagnosis_st_min
		$this->diagnosis_st_min->ViewValue = $this->diagnosis_st_min->CurrentValue;
		$this->diagnosis_st_min->ViewCustomAttributes = "";

		// diagnosis_st_max
		$this->diagnosis_st_max->ViewValue = $this->diagnosis_st_max->CurrentValue;
		$this->diagnosis_st_max->ViewValue = FormatNumber($this->diagnosis_st_max->ViewValue, 2, -2, -2, -2);
		$this->diagnosis_st_max->ViewCustomAttributes = "";

		// diagnosis_unit
		$this->diagnosis_unit->ViewValue = $this->diagnosis_unit->CurrentValue;
		$this->diagnosis_unit->ViewCustomAttributes = "";

		// balance_amount
		$this->balance_amount->ViewValue = $this->balance_amount->CurrentValue;
		$this->balance_amount->ViewValue = FormatNumber($this->balance_amount->ViewValue, 0, -2, -2, -2);
		$this->balance_amount->ViewCustomAttributes = "";

		// age
		$this->age->ViewValue = $this->age->CurrentValue;
		$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
		$this->age->ViewCustomAttributes = "";

		// sex
		if (strval($this->sex->CurrentValue) <> "") {
			$this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
		} else {
			$this->sex->ViewValue = NULL;
		}
		$this->sex->ViewCustomAttributes = "";

		// referral
		$this->referral->ViewValue = $this->referral->CurrentValue;
		$curVal = strval($this->referral->CurrentValue);
		if ($curVal <> "") {
			$this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
			if ($this->referral->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->referral->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
					$this->referral->ViewValue = $this->referral->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->referral->ViewValue = $this->referral->CurrentValue;
				}
			}
		} else {
			$this->referral->ViewValue = NULL;
		}
		$this->referral->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// examination_grp
		$curVal = strval($this->examination_grp->CurrentValue);
		if ($curVal <> "") {
			$this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
			if ($this->examination_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `grp` = 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->examination_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->examination_grp->ViewValue = $this->examination_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->examination_grp->ViewValue = $this->examination_grp->CurrentValue;
				}
			}
		} else {
			$this->examination_grp->ViewValue = NULL;
		}
		$this->examination_grp->ViewCustomAttributes = "";

		// diagnosis_datetime
		$this->diagnosis_datetime->ViewValue = $this->diagnosis_datetime->CurrentValue;
		$this->diagnosis_datetime->ViewValue = FormatDateTime($this->diagnosis_datetime->ViewValue, 0);
		$this->diagnosis_datetime->ViewCustomAttributes = "";

		// import_value
		$this->import_value->ViewValue = $this->import_value->CurrentValue;
		$this->import_value->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
		$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 0, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// discount_amount
		$this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
		$this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, 2, -2, -2, -2);
		$this->discount_amount->ViewCustomAttributes = "";

		// received_amount
		$this->received_amount->ViewValue = $this->received_amount->CurrentValue;
		$this->received_amount->ViewValue = FormatNumber($this->received_amount->ViewValue, 0, -2, -2, -2);
		$this->received_amount->ViewCustomAttributes = "";

		// examination_id
		$this->examination_id->ViewValue = $this->examination_id->CurrentValue;
		$this->examination_id->ViewValue = FormatNumber($this->examination_id->ViewValue, 0, -2, -2, -2);
		$this->examination_id->ViewCustomAttributes = "";

		// examination_name
		$this->examination_name->ViewValue = $this->examination_name->CurrentValue;
		$this->examination_name->ViewCustomAttributes = "";

		// uid
		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// user
		$this->user->ViewValue = $this->user->CurrentValue;
		$curVal = strval($this->user->CurrentValue);
		if ($curVal <> "") {
			$this->user->ViewValue = $this->user->lookupCacheOption($curVal);
			if ($this->user->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->user->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->user->ViewValue = $this->user->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->user->ViewValue = $this->user->CurrentValue;
				}
			}
		} else {
			$this->user->ViewValue = NULL;
		}
		$this->user->ViewCustomAttributes = "";

		// report_grp
		$this->report_grp->ViewValue = $this->report_grp->CurrentValue;
		$this->report_grp->ViewValue = FormatNumber($this->report_grp->ViewValue, 0, -2, -2, -2);
		$this->report_grp->ViewCustomAttributes = "";

		// d_id
		$this->d_id->LinkCustomAttributes = "";
		$this->d_id->HrefValue = "";
		$this->d_id->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		$this->name->HrefValue = "";
		$this->name->TooltipValue = "";

		// examination_code
		$this->examination_code->LinkCustomAttributes = "";
		$this->examination_code->HrefValue = "";
		$this->examination_code->TooltipValue = "";

		// diagnosis_value
		$this->diagnosis_value->LinkCustomAttributes = "";
		$this->diagnosis_value->HrefValue = "";
		$this->diagnosis_value->TooltipValue = "";

		// diagnosis_st_min
		$this->diagnosis_st_min->LinkCustomAttributes = "";
		$this->diagnosis_st_min->HrefValue = "";
		$this->diagnosis_st_min->TooltipValue = "";

		// diagnosis_st_max
		$this->diagnosis_st_max->LinkCustomAttributes = "";
		$this->diagnosis_st_max->HrefValue = "";
		$this->diagnosis_st_max->TooltipValue = "";

		// diagnosis_unit
		$this->diagnosis_unit->LinkCustomAttributes = "";
		$this->diagnosis_unit->HrefValue = "";
		$this->diagnosis_unit->TooltipValue = "";

		// balance_amount
		$this->balance_amount->LinkCustomAttributes = "";
		$this->balance_amount->HrefValue = "";
		$this->balance_amount->TooltipValue = "";

		// age
		$this->age->LinkCustomAttributes = "";
		$this->age->HrefValue = "";
		$this->age->TooltipValue = "";

		// sex
		$this->sex->LinkCustomAttributes = "";
		$this->sex->HrefValue = "";
		$this->sex->TooltipValue = "";

		// referral
		$this->referral->LinkCustomAttributes = "";
		$this->referral->HrefValue = "";
		$this->referral->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// examination_grp
		$this->examination_grp->LinkCustomAttributes = "";
		$this->examination_grp->HrefValue = "";
		$this->examination_grp->TooltipValue = "";

		// diagnosis_datetime
		$this->diagnosis_datetime->LinkCustomAttributes = "";
		$this->diagnosis_datetime->HrefValue = "";
		$this->diagnosis_datetime->TooltipValue = "";

		// import_value
		$this->import_value->LinkCustomAttributes = "";
		$this->import_value->HrefValue = "";
		$this->import_value->TooltipValue = "";

		// total_amount
		$this->total_amount->LinkCustomAttributes = "";
		$this->total_amount->HrefValue = "";
		$this->total_amount->TooltipValue = "";

		// discount_amount
		$this->discount_amount->LinkCustomAttributes = "";
		$this->discount_amount->HrefValue = "";
		$this->discount_amount->TooltipValue = "";

		// received_amount
		$this->received_amount->LinkCustomAttributes = "";
		$this->received_amount->HrefValue = "";
		$this->received_amount->TooltipValue = "";

		// examination_id
		$this->examination_id->LinkCustomAttributes = "";
		$this->examination_id->HrefValue = "";
		$this->examination_id->TooltipValue = "";

		// examination_name
		$this->examination_name->LinkCustomAttributes = "";
		$this->examination_name->HrefValue = "";
		$this->examination_name->TooltipValue = "";

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// user
		$this->user->LinkCustomAttributes = "";
		$this->user->HrefValue = "";
		$this->user->TooltipValue = "";

		// report_grp
		$this->report_grp->LinkCustomAttributes = "";
		$this->report_grp->HrefValue = "";
		$this->report_grp->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// d_id
		$this->d_id->EditAttrs["class"] = "form-control";
		$this->d_id->EditCustomAttributes = "";
		$this->d_id->EditValue = $this->d_id->CurrentValue;
		$this->d_id->EditValue = FormatNumber($this->d_id->EditValue, 0, -2, -2, -2);
		$this->d_id->ViewCustomAttributes = "";

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$curVal = strval($this->mobile->CurrentValue);
		if ($curVal <> "") {
			$this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
			if ($this->mobile->EditValue === NULL) { // Lookup from database
				$filterWrk = "`mobile`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->mobile->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->mobile->EditValue = $this->mobile->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->mobile->EditValue = $this->mobile->CurrentValue;
				}
			}
		} else {
			$this->mobile->EditValue = NULL;
		}
		$this->mobile->ViewCustomAttributes = "";

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// examination_code
		$this->examination_code->EditAttrs["class"] = "form-control";
		$this->examination_code->EditCustomAttributes = "";
		$this->examination_code->EditValue = $this->examination_code->CurrentValue;
		$this->examination_code->ViewCustomAttributes = "";

		// diagnosis_value
		$this->diagnosis_value->EditAttrs["class"] = "form-control";
		$this->diagnosis_value->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->diagnosis_value->CurrentValue = HtmlDecode($this->diagnosis_value->CurrentValue);
		$this->diagnosis_value->EditValue = $this->diagnosis_value->CurrentValue;
		$this->diagnosis_value->PlaceHolder = RemoveHtml($this->diagnosis_value->caption());

		// diagnosis_st_min
		$this->diagnosis_st_min->EditAttrs["class"] = "form-control";
		$this->diagnosis_st_min->EditCustomAttributes = "";
		$this->diagnosis_st_min->EditValue = $this->diagnosis_st_min->CurrentValue;
		$this->diagnosis_st_min->PlaceHolder = RemoveHtml($this->diagnosis_st_min->caption());
		if (strval($this->diagnosis_st_min->EditValue) <> "" && is_numeric($this->diagnosis_st_min->EditValue))
			$this->diagnosis_st_min->EditValue = FormatNumber($this->diagnosis_st_min->EditValue, -2, -1, -2, 0);

		// diagnosis_st_max
		$this->diagnosis_st_max->EditAttrs["class"] = "form-control";
		$this->diagnosis_st_max->EditCustomAttributes = "";
		$this->diagnosis_st_max->EditValue = $this->diagnosis_st_max->CurrentValue;
		$this->diagnosis_st_max->PlaceHolder = RemoveHtml($this->diagnosis_st_max->caption());
		if (strval($this->diagnosis_st_max->EditValue) <> "" && is_numeric($this->diagnosis_st_max->EditValue))
			$this->diagnosis_st_max->EditValue = FormatNumber($this->diagnosis_st_max->EditValue, -2, -2, -2, -2);

		// diagnosis_unit
		$this->diagnosis_unit->EditAttrs["class"] = "form-control";
		$this->diagnosis_unit->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->diagnosis_unit->CurrentValue = HtmlDecode($this->diagnosis_unit->CurrentValue);
		$this->diagnosis_unit->EditValue = $this->diagnosis_unit->CurrentValue;
		$this->diagnosis_unit->PlaceHolder = RemoveHtml($this->diagnosis_unit->caption());

		// balance_amount
		$this->balance_amount->EditAttrs["class"] = "form-control";
		$this->balance_amount->EditCustomAttributes = "";
		$this->balance_amount->EditValue = $this->balance_amount->CurrentValue;
		$this->balance_amount->EditValue = FormatNumber($this->balance_amount->EditValue, 0, -2, -2, -2);
		$this->balance_amount->ViewCustomAttributes = "";

		// age
		$this->age->EditAttrs["class"] = "form-control";
		$this->age->EditCustomAttributes = "";
		$this->age->EditValue = $this->age->CurrentValue;
		$this->age->PlaceHolder = RemoveHtml($this->age->caption());

		// sex
		$this->sex->EditCustomAttributes = "";
		$this->sex->EditValue = $this->sex->options(FALSE);

		// referral
		$this->referral->EditAttrs["class"] = "form-control";
		$this->referral->EditCustomAttributes = "";
		$this->referral->EditValue = $this->referral->CurrentValue;
		$this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// examination_grp
		$this->examination_grp->EditAttrs["class"] = "form-control";
		$this->examination_grp->EditCustomAttributes = "";
		$curVal = strval($this->examination_grp->CurrentValue);
		if ($curVal <> "") {
			$this->examination_grp->EditValue = $this->examination_grp->lookupCacheOption($curVal);
			if ($this->examination_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `grp` = 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->examination_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->examination_grp->EditValue = $this->examination_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->examination_grp->EditValue = $this->examination_grp->CurrentValue;
				}
			}
		} else {
			$this->examination_grp->EditValue = NULL;
		}
		$this->examination_grp->ViewCustomAttributes = "";

		// diagnosis_datetime
		$this->diagnosis_datetime->EditAttrs["class"] = "form-control";
		$this->diagnosis_datetime->EditCustomAttributes = "";
		$this->diagnosis_datetime->EditValue = $this->diagnosis_datetime->CurrentValue;
		$this->diagnosis_datetime->EditValue = FormatDateTime($this->diagnosis_datetime->EditValue, 0);
		$this->diagnosis_datetime->ViewCustomAttributes = "";

		// import_value
		$this->import_value->EditAttrs["class"] = "form-control";
		$this->import_value->EditCustomAttributes = "";
		$this->import_value->EditValue = $this->import_value->CurrentValue;
		$this->import_value->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->EditAttrs["class"] = "form-control";
		$this->total_amount->EditCustomAttributes = "";
		$this->total_amount->EditValue = $this->total_amount->CurrentValue;
		$this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, 0, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// discount_amount
		$this->discount_amount->EditAttrs["class"] = "form-control";
		$this->discount_amount->EditCustomAttributes = "";
		$this->discount_amount->EditValue = $this->discount_amount->CurrentValue;
		$this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());
		if (strval($this->discount_amount->EditValue) <> "" && is_numeric($this->discount_amount->EditValue))
			$this->discount_amount->EditValue = FormatNumber($this->discount_amount->EditValue, -2, -2, -2, -2);

		// received_amount
		$this->received_amount->EditAttrs["class"] = "form-control";
		$this->received_amount->EditCustomAttributes = "";
		$this->received_amount->EditValue = $this->received_amount->CurrentValue;
		$this->received_amount->EditValue = FormatNumber($this->received_amount->EditValue, 0, -2, -2, -2);
		$this->received_amount->ViewCustomAttributes = "";

		// examination_id
		$this->examination_id->EditAttrs["class"] = "form-control";
		$this->examination_id->EditCustomAttributes = "";
		$this->examination_id->EditValue = $this->examination_id->CurrentValue;
		$this->examination_id->EditValue = FormatNumber($this->examination_id->EditValue, 0, -2, -2, -2);
		$this->examination_id->ViewCustomAttributes = "";

		// examination_name
		$this->examination_name->EditAttrs["class"] = "form-control";
		$this->examination_name->EditCustomAttributes = "";
		$this->examination_name->EditValue = $this->examination_name->CurrentValue;
		$this->examination_name->ViewCustomAttributes = "";

		// uid
		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// operator
		// datetime
		// user

		$this->user->EditAttrs["class"] = "form-control";
		$this->user->EditCustomAttributes = "";
		$this->user->EditValue = $this->user->CurrentValue;
		$curVal = strval($this->user->CurrentValue);
		if ($curVal <> "") {
			$this->user->EditValue = $this->user->lookupCacheOption($curVal);
			if ($this->user->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->user->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->user->EditValue = $this->user->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->user->EditValue = $this->user->CurrentValue;
				}
			}
		} else {
			$this->user->EditValue = NULL;
		}
		$this->user->ViewCustomAttributes = "";

		// report_grp
		$this->report_grp->EditAttrs["class"] = "form-control";
		$this->report_grp->EditCustomAttributes = "";
		$this->report_grp->EditValue = $this->report_grp->CurrentValue;
		$this->report_grp->PlaceHolder = RemoveHtml($this->report_grp->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->d_id);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->examination_code);
					$doc->exportCaption($this->diagnosis_value);
					$doc->exportCaption($this->diagnosis_st_min);
					$doc->exportCaption($this->diagnosis_st_max);
					$doc->exportCaption($this->diagnosis_unit);
					$doc->exportCaption($this->balance_amount);
					$doc->exportCaption($this->age);
					$doc->exportCaption($this->sex);
					$doc->exportCaption($this->referral);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->examination_grp);
					$doc->exportCaption($this->diagnosis_datetime);
					$doc->exportCaption($this->import_value);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->discount_amount);
					$doc->exportCaption($this->received_amount);
					$doc->exportCaption($this->examination_id);
					$doc->exportCaption($this->examination_name);
					$doc->exportCaption($this->uid);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->user);
				} else {
					$doc->exportCaption($this->d_id);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->examination_code);
					$doc->exportCaption($this->diagnosis_value);
					$doc->exportCaption($this->diagnosis_st_min);
					$doc->exportCaption($this->diagnosis_st_max);
					$doc->exportCaption($this->diagnosis_unit);
					$doc->exportCaption($this->balance_amount);
					$doc->exportCaption($this->age);
					$doc->exportCaption($this->sex);
					$doc->exportCaption($this->referral);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->examination_grp);
					$doc->exportCaption($this->diagnosis_datetime);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->discount_amount);
					$doc->exportCaption($this->received_amount);
					$doc->exportCaption($this->examination_id);
					$doc->exportCaption($this->examination_name);
					$doc->exportCaption($this->uid);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->user);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->d_id);
						$doc->exportField($this->mobile);
						$doc->exportField($this->name);
						$doc->exportField($this->examination_code);
						$doc->exportField($this->diagnosis_value);
						$doc->exportField($this->diagnosis_st_min);
						$doc->exportField($this->diagnosis_st_max);
						$doc->exportField($this->diagnosis_unit);
						$doc->exportField($this->balance_amount);
						$doc->exportField($this->age);
						$doc->exportField($this->sex);
						$doc->exportField($this->referral);
						$doc->exportField($this->remarks);
						$doc->exportField($this->examination_grp);
						$doc->exportField($this->diagnosis_datetime);
						$doc->exportField($this->import_value);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->discount_amount);
						$doc->exportField($this->received_amount);
						$doc->exportField($this->examination_id);
						$doc->exportField($this->examination_name);
						$doc->exportField($this->uid);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->user);
					} else {
						$doc->exportField($this->d_id);
						$doc->exportField($this->mobile);
						$doc->exportField($this->name);
						$doc->exportField($this->examination_code);
						$doc->exportField($this->diagnosis_value);
						$doc->exportField($this->diagnosis_st_min);
						$doc->exportField($this->diagnosis_st_max);
						$doc->exportField($this->diagnosis_unit);
						$doc->exportField($this->balance_amount);
						$doc->exportField($this->age);
						$doc->exportField($this->sex);
						$doc->exportField($this->referral);
						$doc->exportField($this->remarks);
						$doc->exportField($this->examination_grp);
						$doc->exportField($this->diagnosis_datetime);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->discount_amount);
						$doc->exportField($this->received_amount);
						$doc->exportField($this->examination_id);
						$doc->exportField($this->examination_name);
						$doc->exportField($this->uid);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->user);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>