<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class _l_examination_report_edit extends _l_examination_report
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'l_examination_report';

	// Page object name
	public $PageObjName = "_l_examination_report_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (_l_examination_report)
		if (!isset($GLOBALS["_l_examination_report"]) || get_class($GLOBALS["_l_examination_report"]) == PROJECT_NAMESPACE . "_l_examination_report") {
			$GLOBALS["_l_examination_report"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["_l_examination_report"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'l_examination_report');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $_l_examination_report;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($_l_examination_report);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "_l_examination_reportview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['uid'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("_l_examination_reportlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->d_id->setVisibility();
		$this->mobile->setVisibility();
		$this->name->setVisibility();
		$this->examination_code->setVisibility();
		$this->diagnosis_value->setVisibility();
		$this->diagnosis_st_min->setVisibility();
		$this->diagnosis_st_max->setVisibility();
		$this->diagnosis_unit->setVisibility();
		$this->balance_amount->setVisibility();
		$this->age->setVisibility();
		$this->sex->setVisibility();
		$this->referral->setVisibility();
		$this->remarks->setVisibility();
		$this->examination_grp->setVisibility();
		$this->diagnosis_datetime->setVisibility();
		$this->import_value->setVisibility();
		$this->total_amount->setVisibility();
		$this->discount_amount->setVisibility();
		$this->received_amount->setVisibility();
		$this->examination_id->setVisibility();
		$this->examination_name->setVisibility();
		$this->uid->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->user->Visible = FALSE;
		$this->report_grp->Visible = FALSE;
		$this->hideFieldsForAddEdit();
		$this->d_id->Required = FALSE;
		$this->mobile->Required = FALSE;
		$this->examination_code->Required = FALSE;
		$this->examination_grp->Required = FALSE;
		$this->import_value->Required = FALSE;
		$this->examination_name->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->mobile);
		$this->setupLookupOptions($this->name);
		$this->setupLookupOptions($this->referral);
		$this->setupLookupOptions($this->examination_grp);
		$this->setupLookupOptions($this->user);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_uid")) {
				$this->uid->setFormValue($CurrentForm->getValue("x_uid"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("uid") !== NULL) {
				$this->uid->setQueryStringValue(Get("uid"));
				$loadByQuery = TRUE;
			} else {
				$this->uid->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("_l_examination_reportlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "_l_examination_reportlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'd_id' first before field var 'x_d_id'
		$val = $CurrentForm->hasValue("d_id") ? $CurrentForm->getValue("d_id") : $CurrentForm->getValue("x_d_id");
		if (!$this->d_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_id->Visible = FALSE; // Disable update for API request
			else
				$this->d_id->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'name' first before field var 'x_name'
		$val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
		if (!$this->name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->name->Visible = FALSE; // Disable update for API request
			else
				$this->name->setFormValue($val);
		}

		// Check field name 'examination_code' first before field var 'x_examination_code'
		$val = $CurrentForm->hasValue("examination_code") ? $CurrentForm->getValue("examination_code") : $CurrentForm->getValue("x_examination_code");
		if (!$this->examination_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->examination_code->Visible = FALSE; // Disable update for API request
			else
				$this->examination_code->setFormValue($val);
		}

		// Check field name 'diagnosis_value' first before field var 'x_diagnosis_value'
		$val = $CurrentForm->hasValue("diagnosis_value") ? $CurrentForm->getValue("diagnosis_value") : $CurrentForm->getValue("x_diagnosis_value");
		if (!$this->diagnosis_value->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diagnosis_value->Visible = FALSE; // Disable update for API request
			else
				$this->diagnosis_value->setFormValue($val);
		}

		// Check field name 'diagnosis_st_min' first before field var 'x_diagnosis_st_min'
		$val = $CurrentForm->hasValue("diagnosis_st_min") ? $CurrentForm->getValue("diagnosis_st_min") : $CurrentForm->getValue("x_diagnosis_st_min");
		if (!$this->diagnosis_st_min->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diagnosis_st_min->Visible = FALSE; // Disable update for API request
			else
				$this->diagnosis_st_min->setFormValue($val);
		}

		// Check field name 'diagnosis_st_max' first before field var 'x_diagnosis_st_max'
		$val = $CurrentForm->hasValue("diagnosis_st_max") ? $CurrentForm->getValue("diagnosis_st_max") : $CurrentForm->getValue("x_diagnosis_st_max");
		if (!$this->diagnosis_st_max->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diagnosis_st_max->Visible = FALSE; // Disable update for API request
			else
				$this->diagnosis_st_max->setFormValue($val);
		}

		// Check field name 'diagnosis_unit' first before field var 'x_diagnosis_unit'
		$val = $CurrentForm->hasValue("diagnosis_unit") ? $CurrentForm->getValue("diagnosis_unit") : $CurrentForm->getValue("x_diagnosis_unit");
		if (!$this->diagnosis_unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diagnosis_unit->Visible = FALSE; // Disable update for API request
			else
				$this->diagnosis_unit->setFormValue($val);
		}

		// Check field name 'balance_amount' first before field var 'x_balance_amount'
		$val = $CurrentForm->hasValue("balance_amount") ? $CurrentForm->getValue("balance_amount") : $CurrentForm->getValue("x_balance_amount");
		if (!$this->balance_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->balance_amount->Visible = FALSE; // Disable update for API request
			else
				$this->balance_amount->setFormValue($val);
		}

		// Check field name 'age' first before field var 'x_age'
		$val = $CurrentForm->hasValue("age") ? $CurrentForm->getValue("age") : $CurrentForm->getValue("x_age");
		if (!$this->age->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->age->Visible = FALSE; // Disable update for API request
			else
				$this->age->setFormValue($val);
		}

		// Check field name 'sex' first before field var 'x_sex'
		$val = $CurrentForm->hasValue("sex") ? $CurrentForm->getValue("sex") : $CurrentForm->getValue("x_sex");
		if (!$this->sex->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sex->Visible = FALSE; // Disable update for API request
			else
				$this->sex->setFormValue($val);
		}

		// Check field name 'referral' first before field var 'x_referral'
		$val = $CurrentForm->hasValue("referral") ? $CurrentForm->getValue("referral") : $CurrentForm->getValue("x_referral");
		if (!$this->referral->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->referral->Visible = FALSE; // Disable update for API request
			else
				$this->referral->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'examination_grp' first before field var 'x_examination_grp'
		$val = $CurrentForm->hasValue("examination_grp") ? $CurrentForm->getValue("examination_grp") : $CurrentForm->getValue("x_examination_grp");
		if (!$this->examination_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->examination_grp->Visible = FALSE; // Disable update for API request
			else
				$this->examination_grp->setFormValue($val);
		}

		// Check field name 'diagnosis_datetime' first before field var 'x_diagnosis_datetime'
		$val = $CurrentForm->hasValue("diagnosis_datetime") ? $CurrentForm->getValue("diagnosis_datetime") : $CurrentForm->getValue("x_diagnosis_datetime");
		if (!$this->diagnosis_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diagnosis_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->diagnosis_datetime->setFormValue($val);
			$this->diagnosis_datetime->CurrentValue = UnFormatDateTime($this->diagnosis_datetime->CurrentValue, 0);
		}

		// Check field name 'import_value' first before field var 'x_import_value'
		$val = $CurrentForm->hasValue("import_value") ? $CurrentForm->getValue("import_value") : $CurrentForm->getValue("x_import_value");
		if (!$this->import_value->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->import_value->Visible = FALSE; // Disable update for API request
			else
				$this->import_value->setFormValue($val);
		}

		// Check field name 'total_amount' first before field var 'x_total_amount'
		$val = $CurrentForm->hasValue("total_amount") ? $CurrentForm->getValue("total_amount") : $CurrentForm->getValue("x_total_amount");
		if (!$this->total_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->total_amount->Visible = FALSE; // Disable update for API request
			else
				$this->total_amount->setFormValue($val);
		}

		// Check field name 'discount_amount' first before field var 'x_discount_amount'
		$val = $CurrentForm->hasValue("discount_amount") ? $CurrentForm->getValue("discount_amount") : $CurrentForm->getValue("x_discount_amount");
		if (!$this->discount_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->discount_amount->Visible = FALSE; // Disable update for API request
			else
				$this->discount_amount->setFormValue($val);
		}

		// Check field name 'received_amount' first before field var 'x_received_amount'
		$val = $CurrentForm->hasValue("received_amount") ? $CurrentForm->getValue("received_amount") : $CurrentForm->getValue("x_received_amount");
		if (!$this->received_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->received_amount->Visible = FALSE; // Disable update for API request
			else
				$this->received_amount->setFormValue($val);
		}

		// Check field name 'examination_id' first before field var 'x_examination_id'
		$val = $CurrentForm->hasValue("examination_id") ? $CurrentForm->getValue("examination_id") : $CurrentForm->getValue("x_examination_id");
		if (!$this->examination_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->examination_id->Visible = FALSE; // Disable update for API request
			else
				$this->examination_id->setFormValue($val);
		}

		// Check field name 'examination_name' first before field var 'x_examination_name'
		$val = $CurrentForm->hasValue("examination_name") ? $CurrentForm->getValue("examination_name") : $CurrentForm->getValue("x_examination_name");
		if (!$this->examination_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->examination_name->Visible = FALSE; // Disable update for API request
			else
				$this->examination_name->setFormValue($val);
		}

		// Check field name 'uid' first before field var 'x_uid'
		$val = $CurrentForm->hasValue("uid") ? $CurrentForm->getValue("uid") : $CurrentForm->getValue("x_uid");
		if (!$this->uid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->uid->Visible = FALSE; // Disable update for API request
			else
				$this->uid->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->d_id->CurrentValue = $this->d_id->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->name->CurrentValue = $this->name->FormValue;
		$this->examination_code->CurrentValue = $this->examination_code->FormValue;
		$this->diagnosis_value->CurrentValue = $this->diagnosis_value->FormValue;
		$this->diagnosis_st_min->CurrentValue = $this->diagnosis_st_min->FormValue;
		$this->diagnosis_st_max->CurrentValue = $this->diagnosis_st_max->FormValue;
		$this->diagnosis_unit->CurrentValue = $this->diagnosis_unit->FormValue;
		$this->balance_amount->CurrentValue = $this->balance_amount->FormValue;
		$this->age->CurrentValue = $this->age->FormValue;
		$this->sex->CurrentValue = $this->sex->FormValue;
		$this->referral->CurrentValue = $this->referral->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->examination_grp->CurrentValue = $this->examination_grp->FormValue;
		$this->diagnosis_datetime->CurrentValue = $this->diagnosis_datetime->FormValue;
		$this->diagnosis_datetime->CurrentValue = UnFormatDateTime($this->diagnosis_datetime->CurrentValue, 0);
		$this->import_value->CurrentValue = $this->import_value->FormValue;
		$this->total_amount->CurrentValue = $this->total_amount->FormValue;
		$this->discount_amount->CurrentValue = $this->discount_amount->FormValue;
		$this->received_amount->CurrentValue = $this->received_amount->FormValue;
		$this->examination_id->CurrentValue = $this->examination_id->FormValue;
		$this->examination_name->CurrentValue = $this->examination_name->FormValue;
		$this->uid->CurrentValue = $this->uid->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->d_id->setDbValue($row['d_id']);
		$this->mobile->setDbValue($row['mobile']);
		$this->name->setDbValue($row['name']);
		$this->examination_code->setDbValue($row['examination_code']);
		$this->diagnosis_value->setDbValue($row['diagnosis_value']);
		$this->diagnosis_st_min->setDbValue($row['diagnosis_st_min']);
		$this->diagnosis_st_max->setDbValue($row['diagnosis_st_max']);
		$this->diagnosis_unit->setDbValue($row['diagnosis_unit']);
		$this->balance_amount->setDbValue($row['balance_amount']);
		$this->age->setDbValue($row['age']);
		$this->sex->setDbValue($row['sex']);
		$this->referral->setDbValue($row['referral']);
		$this->remarks->setDbValue($row['remarks']);
		$this->examination_grp->setDbValue($row['examination_grp']);
		$this->diagnosis_datetime->setDbValue($row['diagnosis_datetime']);
		$this->import_value->setDbValue($row['import_value']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->discount_amount->setDbValue($row['discount_amount']);
		$this->received_amount->setDbValue($row['received_amount']);
		$this->examination_id->setDbValue($row['examination_id']);
		$this->examination_name->setDbValue($row['examination_name']);
		$this->uid->setDbValue($row['uid']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->user->setDbValue($row['user']);
		$this->report_grp->setDbValue($row['report_grp']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['d_id'] = NULL;
		$row['mobile'] = NULL;
		$row['name'] = NULL;
		$row['examination_code'] = NULL;
		$row['diagnosis_value'] = NULL;
		$row['diagnosis_st_min'] = NULL;
		$row['diagnosis_st_max'] = NULL;
		$row['diagnosis_unit'] = NULL;
		$row['balance_amount'] = NULL;
		$row['age'] = NULL;
		$row['sex'] = NULL;
		$row['referral'] = NULL;
		$row['remarks'] = NULL;
		$row['examination_grp'] = NULL;
		$row['diagnosis_datetime'] = NULL;
		$row['import_value'] = NULL;
		$row['total_amount'] = NULL;
		$row['discount_amount'] = NULL;
		$row['received_amount'] = NULL;
		$row['examination_id'] = NULL;
		$row['examination_name'] = NULL;
		$row['uid'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['user'] = NULL;
		$row['report_grp'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("uid")) <> "")
			$this->uid->CurrentValue = $this->getKey("uid"); // uid
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->diagnosis_st_min->FormValue == $this->diagnosis_st_min->CurrentValue && is_numeric(ConvertToFloatString($this->diagnosis_st_min->CurrentValue)))
			$this->diagnosis_st_min->CurrentValue = ConvertToFloatString($this->diagnosis_st_min->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diagnosis_st_max->FormValue == $this->diagnosis_st_max->CurrentValue && is_numeric(ConvertToFloatString($this->diagnosis_st_max->CurrentValue)))
			$this->diagnosis_st_max->CurrentValue = ConvertToFloatString($this->diagnosis_st_max->CurrentValue);

		// Convert decimal values if posted back
		if ($this->balance_amount->FormValue == $this->balance_amount->CurrentValue && is_numeric(ConvertToFloatString($this->balance_amount->CurrentValue)))
			$this->balance_amount->CurrentValue = ConvertToFloatString($this->balance_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->total_amount->FormValue == $this->total_amount->CurrentValue && is_numeric(ConvertToFloatString($this->total_amount->CurrentValue)))
			$this->total_amount->CurrentValue = ConvertToFloatString($this->total_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->discount_amount->FormValue == $this->discount_amount->CurrentValue && is_numeric(ConvertToFloatString($this->discount_amount->CurrentValue)))
			$this->discount_amount->CurrentValue = ConvertToFloatString($this->discount_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->received_amount->FormValue == $this->received_amount->CurrentValue && is_numeric(ConvertToFloatString($this->received_amount->CurrentValue)))
			$this->received_amount->CurrentValue = ConvertToFloatString($this->received_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// d_id
		// mobile
		// name
		// examination_code
		// diagnosis_value
		// diagnosis_st_min
		// diagnosis_st_max
		// diagnosis_unit
		// balance_amount
		// age
		// sex
		// referral
		// remarks
		// examination_grp
		// diagnosis_datetime
		// import_value
		// total_amount
		// discount_amount
		// received_amount
		// examination_id
		// examination_name
		// uid
		// operator
		// datetime
		// user
		// report_grp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// d_id
			$this->d_id->ViewValue = $this->d_id->CurrentValue;
			$this->d_id->ViewValue = FormatNumber($this->d_id->ViewValue, 0, -2, -2, -2);
			$this->d_id->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$curVal = strval($this->mobile->CurrentValue);
			if ($curVal <> "") {
				$this->mobile->ViewValue = $this->mobile->lookupCacheOption($curVal);
				if ($this->mobile->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`mobile`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->mobile->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->mobile->ViewValue = $this->mobile->CurrentValue;
					}
				}
			} else {
				$this->mobile->ViewValue = NULL;
			}
			$this->mobile->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$curVal = strval($this->name->CurrentValue);
			if ($curVal <> "") {
				$this->name->ViewValue = $this->name->lookupCacheOption($curVal);
				if ($this->name->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`name`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->name->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->name->ViewValue = $this->name->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->name->ViewValue = $this->name->CurrentValue;
					}
				}
			} else {
				$this->name->ViewValue = NULL;
			}
			$this->name->ViewCustomAttributes = "";

			// examination_code
			$this->examination_code->ViewValue = $this->examination_code->CurrentValue;
			$this->examination_code->ViewCustomAttributes = "";

			// diagnosis_value
			$this->diagnosis_value->ViewValue = $this->diagnosis_value->CurrentValue;
			$this->diagnosis_value->ViewCustomAttributes = "";

			// diagnosis_st_min
			$this->diagnosis_st_min->ViewValue = $this->diagnosis_st_min->CurrentValue;
			$this->diagnosis_st_min->ViewCustomAttributes = "";

			// diagnosis_st_max
			$this->diagnosis_st_max->ViewValue = $this->diagnosis_st_max->CurrentValue;
			$this->diagnosis_st_max->ViewValue = FormatNumber($this->diagnosis_st_max->ViewValue, 2, -2, -2, -2);
			$this->diagnosis_st_max->ViewCustomAttributes = "";

			// diagnosis_unit
			$this->diagnosis_unit->ViewValue = $this->diagnosis_unit->CurrentValue;
			$this->diagnosis_unit->ViewCustomAttributes = "";

			// balance_amount
			$this->balance_amount->ViewValue = $this->balance_amount->CurrentValue;
			$this->balance_amount->ViewValue = FormatNumber($this->balance_amount->ViewValue, 0, -2, -2, -2);
			$this->balance_amount->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
			$this->age->ViewCustomAttributes = "";

			// sex
			if (strval($this->sex->CurrentValue) <> "") {
				$this->sex->ViewValue = $this->sex->optionCaption($this->sex->CurrentValue);
			} else {
				$this->sex->ViewValue = NULL;
			}
			$this->sex->ViewCustomAttributes = "";

			// referral
			$this->referral->ViewValue = $this->referral->CurrentValue;
			$curVal = strval($this->referral->CurrentValue);
			if ($curVal <> "") {
				$this->referral->ViewValue = $this->referral->lookupCacheOption($curVal);
				if ($this->referral->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->referral->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$this->referral->ViewValue = $this->referral->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->referral->ViewValue = $this->referral->CurrentValue;
					}
				}
			} else {
				$this->referral->ViewValue = NULL;
			}
			$this->referral->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// examination_grp
			$curVal = strval($this->examination_grp->CurrentValue);
			if ($curVal <> "") {
				$this->examination_grp->ViewValue = $this->examination_grp->lookupCacheOption($curVal);
				if ($this->examination_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->examination_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->examination_grp->ViewValue = $this->examination_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->examination_grp->ViewValue = $this->examination_grp->CurrentValue;
					}
				}
			} else {
				$this->examination_grp->ViewValue = NULL;
			}
			$this->examination_grp->ViewCustomAttributes = "";

			// diagnosis_datetime
			$this->diagnosis_datetime->ViewValue = $this->diagnosis_datetime->CurrentValue;
			$this->diagnosis_datetime->ViewValue = FormatDateTime($this->diagnosis_datetime->ViewValue, 0);
			$this->diagnosis_datetime->ViewCustomAttributes = "";

			// import_value
			$this->import_value->ViewValue = $this->import_value->CurrentValue;
			$this->import_value->ViewCustomAttributes = "";

			// total_amount
			$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
			$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 0, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";

			// discount_amount
			$this->discount_amount->ViewValue = $this->discount_amount->CurrentValue;
			$this->discount_amount->ViewValue = FormatNumber($this->discount_amount->ViewValue, 2, -2, -2, -2);
			$this->discount_amount->ViewCustomAttributes = "";

			// received_amount
			$this->received_amount->ViewValue = $this->received_amount->CurrentValue;
			$this->received_amount->ViewValue = FormatNumber($this->received_amount->ViewValue, 0, -2, -2, -2);
			$this->received_amount->ViewCustomAttributes = "";

			// examination_id
			$this->examination_id->ViewValue = $this->examination_id->CurrentValue;
			$this->examination_id->ViewValue = FormatNumber($this->examination_id->ViewValue, 0, -2, -2, -2);
			$this->examination_id->ViewCustomAttributes = "";

			// examination_name
			$this->examination_name->ViewValue = $this->examination_name->CurrentValue;
			$this->examination_name->ViewCustomAttributes = "";

			// uid
			$this->uid->ViewValue = $this->uid->CurrentValue;
			$this->uid->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// user
			$this->user->ViewValue = $this->user->CurrentValue;
			$curVal = strval($this->user->CurrentValue);
			if ($curVal <> "") {
				$this->user->ViewValue = $this->user->lookupCacheOption($curVal);
				if ($this->user->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->user->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->user->ViewValue = $this->user->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->user->ViewValue = $this->user->CurrentValue;
					}
				}
			} else {
				$this->user->ViewValue = NULL;
			}
			$this->user->ViewCustomAttributes = "";

			// d_id
			$this->d_id->LinkCustomAttributes = "";
			$this->d_id->HrefValue = "";
			$this->d_id->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// examination_code
			$this->examination_code->LinkCustomAttributes = "";
			$this->examination_code->HrefValue = "";
			$this->examination_code->TooltipValue = "";

			// diagnosis_value
			$this->diagnosis_value->LinkCustomAttributes = "";
			$this->diagnosis_value->HrefValue = "";
			$this->diagnosis_value->TooltipValue = "";

			// diagnosis_st_min
			$this->diagnosis_st_min->LinkCustomAttributes = "";
			$this->diagnosis_st_min->HrefValue = "";
			$this->diagnosis_st_min->TooltipValue = "";

			// diagnosis_st_max
			$this->diagnosis_st_max->LinkCustomAttributes = "";
			$this->diagnosis_st_max->HrefValue = "";
			$this->diagnosis_st_max->TooltipValue = "";

			// diagnosis_unit
			$this->diagnosis_unit->LinkCustomAttributes = "";
			$this->diagnosis_unit->HrefValue = "";
			$this->diagnosis_unit->TooltipValue = "";

			// balance_amount
			$this->balance_amount->LinkCustomAttributes = "";
			$this->balance_amount->HrefValue = "";
			$this->balance_amount->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";

			// sex
			$this->sex->LinkCustomAttributes = "";
			$this->sex->HrefValue = "";
			$this->sex->TooltipValue = "";

			// referral
			$this->referral->LinkCustomAttributes = "";
			$this->referral->HrefValue = "";
			$this->referral->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// examination_grp
			$this->examination_grp->LinkCustomAttributes = "";
			$this->examination_grp->HrefValue = "";
			$this->examination_grp->TooltipValue = "";

			// diagnosis_datetime
			$this->diagnosis_datetime->LinkCustomAttributes = "";
			$this->diagnosis_datetime->HrefValue = "";
			$this->diagnosis_datetime->TooltipValue = "";

			// import_value
			$this->import_value->LinkCustomAttributes = "";
			$this->import_value->HrefValue = "";
			$this->import_value->TooltipValue = "";

			// total_amount
			$this->total_amount->LinkCustomAttributes = "";
			$this->total_amount->HrefValue = "";
			$this->total_amount->TooltipValue = "";

			// discount_amount
			$this->discount_amount->LinkCustomAttributes = "";
			$this->discount_amount->HrefValue = "";
			$this->discount_amount->TooltipValue = "";

			// received_amount
			$this->received_amount->LinkCustomAttributes = "";
			$this->received_amount->HrefValue = "";
			$this->received_amount->TooltipValue = "";

			// examination_id
			$this->examination_id->LinkCustomAttributes = "";
			$this->examination_id->HrefValue = "";
			$this->examination_id->TooltipValue = "";

			// examination_name
			$this->examination_name->LinkCustomAttributes = "";
			$this->examination_name->HrefValue = "";
			$this->examination_name->TooltipValue = "";

			// uid
			$this->uid->LinkCustomAttributes = "";
			$this->uid->HrefValue = "";
			$this->uid->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// d_id
			$this->d_id->EditAttrs["class"] = "form-control";
			$this->d_id->EditCustomAttributes = "";
			$this->d_id->EditValue = $this->d_id->CurrentValue;
			$this->d_id->EditValue = FormatNumber($this->d_id->EditValue, 0, -2, -2, -2);
			$this->d_id->ViewCustomAttributes = "";

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = $this->mobile->CurrentValue;
			$curVal = strval($this->mobile->CurrentValue);
			if ($curVal <> "") {
				$this->mobile->EditValue = $this->mobile->lookupCacheOption($curVal);
				if ($this->mobile->EditValue === NULL) { // Lookup from database
					$filterWrk = "`mobile`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->mobile->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->mobile->EditValue = $this->mobile->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->mobile->EditValue = $this->mobile->CurrentValue;
					}
				}
			} else {
				$this->mobile->EditValue = NULL;
			}
			$this->mobile->ViewCustomAttributes = "";

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
			$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
			$curVal = strval($this->name->CurrentValue);
			if ($curVal <> "") {
				$this->name->EditValue = $this->name->lookupCacheOption($curVal);
				if ($this->name->EditValue === NULL) { // Lookup from database
					$filterWrk = "`name`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->name->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->name->EditValue = $this->name->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
					}
				}
			} else {
				$this->name->EditValue = NULL;
			}
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// examination_code
			$this->examination_code->EditAttrs["class"] = "form-control";
			$this->examination_code->EditCustomAttributes = "";
			$this->examination_code->EditValue = $this->examination_code->CurrentValue;
			$this->examination_code->ViewCustomAttributes = "";

			// diagnosis_value
			$this->diagnosis_value->EditAttrs["class"] = "form-control";
			$this->diagnosis_value->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->diagnosis_value->CurrentValue = HtmlDecode($this->diagnosis_value->CurrentValue);
			$this->diagnosis_value->EditValue = HtmlEncode($this->diagnosis_value->CurrentValue);
			$this->diagnosis_value->PlaceHolder = RemoveHtml($this->diagnosis_value->caption());

			// diagnosis_st_min
			$this->diagnosis_st_min->EditAttrs["class"] = "form-control";
			$this->diagnosis_st_min->EditCustomAttributes = "";
			$this->diagnosis_st_min->EditValue = HtmlEncode($this->diagnosis_st_min->CurrentValue);
			$this->diagnosis_st_min->PlaceHolder = RemoveHtml($this->diagnosis_st_min->caption());
			if (strval($this->diagnosis_st_min->EditValue) <> "" && is_numeric($this->diagnosis_st_min->EditValue))
				$this->diagnosis_st_min->EditValue = FormatNumber($this->diagnosis_st_min->EditValue, -2, -1, -2, 0);

			// diagnosis_st_max
			$this->diagnosis_st_max->EditAttrs["class"] = "form-control";
			$this->diagnosis_st_max->EditCustomAttributes = "";
			$this->diagnosis_st_max->EditValue = HtmlEncode($this->diagnosis_st_max->CurrentValue);
			$this->diagnosis_st_max->PlaceHolder = RemoveHtml($this->diagnosis_st_max->caption());
			if (strval($this->diagnosis_st_max->EditValue) <> "" && is_numeric($this->diagnosis_st_max->EditValue))
				$this->diagnosis_st_max->EditValue = FormatNumber($this->diagnosis_st_max->EditValue, -2, -2, -2, -2);

			// diagnosis_unit
			$this->diagnosis_unit->EditAttrs["class"] = "form-control";
			$this->diagnosis_unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->diagnosis_unit->CurrentValue = HtmlDecode($this->diagnosis_unit->CurrentValue);
			$this->diagnosis_unit->EditValue = HtmlEncode($this->diagnosis_unit->CurrentValue);
			$this->diagnosis_unit->PlaceHolder = RemoveHtml($this->diagnosis_unit->caption());

			// balance_amount
			$this->balance_amount->EditAttrs["class"] = "form-control";
			$this->balance_amount->EditCustomAttributes = "";
			$this->balance_amount->EditValue = $this->balance_amount->CurrentValue;
			$this->balance_amount->EditValue = FormatNumber($this->balance_amount->EditValue, 0, -2, -2, -2);
			$this->balance_amount->ViewCustomAttributes = "";

			// age
			$this->age->EditAttrs["class"] = "form-control";
			$this->age->EditCustomAttributes = "";
			$this->age->EditValue = HtmlEncode($this->age->CurrentValue);
			$this->age->PlaceHolder = RemoveHtml($this->age->caption());

			// sex
			$this->sex->EditCustomAttributes = "";
			$this->sex->EditValue = $this->sex->options(FALSE);

			// referral
			$this->referral->EditAttrs["class"] = "form-control";
			$this->referral->EditCustomAttributes = "";
			$this->referral->EditValue = HtmlEncode($this->referral->CurrentValue);
			$curVal = strval($this->referral->CurrentValue);
			if ($curVal <> "") {
				$this->referral->EditValue = $this->referral->lookupCacheOption($curVal);
				if ($this->referral->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->referral->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode(FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2));
						$this->referral->EditValue = $this->referral->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->referral->EditValue = HtmlEncode($this->referral->CurrentValue);
					}
				}
			} else {
				$this->referral->EditValue = NULL;
			}
			$this->referral->PlaceHolder = RemoveHtml($this->referral->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// examination_grp
			$this->examination_grp->EditAttrs["class"] = "form-control";
			$this->examination_grp->EditCustomAttributes = "";
			$curVal = strval($this->examination_grp->CurrentValue);
			if ($curVal <> "") {
				$this->examination_grp->EditValue = $this->examination_grp->lookupCacheOption($curVal);
				if ($this->examination_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->examination_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->examination_grp->EditValue = $this->examination_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->examination_grp->EditValue = $this->examination_grp->CurrentValue;
					}
				}
			} else {
				$this->examination_grp->EditValue = NULL;
			}
			$this->examination_grp->ViewCustomAttributes = "";

			// diagnosis_datetime
			$this->diagnosis_datetime->EditAttrs["class"] = "form-control";
			$this->diagnosis_datetime->EditCustomAttributes = "";
			$this->diagnosis_datetime->EditValue = $this->diagnosis_datetime->CurrentValue;
			$this->diagnosis_datetime->EditValue = FormatDateTime($this->diagnosis_datetime->EditValue, 0);
			$this->diagnosis_datetime->ViewCustomAttributes = "";

			// import_value
			$this->import_value->EditAttrs["class"] = "form-control";
			$this->import_value->EditCustomAttributes = "";
			$this->import_value->EditValue = $this->import_value->CurrentValue;
			$this->import_value->ViewCustomAttributes = "";

			// total_amount
			$this->total_amount->EditAttrs["class"] = "form-control";
			$this->total_amount->EditCustomAttributes = "";
			$this->total_amount->EditValue = $this->total_amount->CurrentValue;
			$this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, 0, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";

			// discount_amount
			$this->discount_amount->EditAttrs["class"] = "form-control";
			$this->discount_amount->EditCustomAttributes = "";
			$this->discount_amount->EditValue = HtmlEncode($this->discount_amount->CurrentValue);
			$this->discount_amount->PlaceHolder = RemoveHtml($this->discount_amount->caption());
			if (strval($this->discount_amount->EditValue) <> "" && is_numeric($this->discount_amount->EditValue))
				$this->discount_amount->EditValue = FormatNumber($this->discount_amount->EditValue, -2, -2, -2, -2);

			// received_amount
			$this->received_amount->EditAttrs["class"] = "form-control";
			$this->received_amount->EditCustomAttributes = "";
			$this->received_amount->EditValue = $this->received_amount->CurrentValue;
			$this->received_amount->EditValue = FormatNumber($this->received_amount->EditValue, 0, -2, -2, -2);
			$this->received_amount->ViewCustomAttributes = "";

			// examination_id
			$this->examination_id->EditAttrs["class"] = "form-control";
			$this->examination_id->EditCustomAttributes = "";
			$this->examination_id->EditValue = $this->examination_id->CurrentValue;
			$this->examination_id->EditValue = FormatNumber($this->examination_id->EditValue, 0, -2, -2, -2);
			$this->examination_id->ViewCustomAttributes = "";

			// examination_name
			$this->examination_name->EditAttrs["class"] = "form-control";
			$this->examination_name->EditCustomAttributes = "";
			$this->examination_name->EditValue = $this->examination_name->CurrentValue;
			$this->examination_name->ViewCustomAttributes = "";

			// uid
			$this->uid->EditAttrs["class"] = "form-control";
			$this->uid->EditCustomAttributes = "";
			$this->uid->EditValue = $this->uid->CurrentValue;
			$this->uid->ViewCustomAttributes = "";

			// operator
			// datetime
			// Edit refer script
			// d_id

			$this->d_id->LinkCustomAttributes = "";
			$this->d_id->HrefValue = "";
			$this->d_id->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";

			// examination_code
			$this->examination_code->LinkCustomAttributes = "";
			$this->examination_code->HrefValue = "";
			$this->examination_code->TooltipValue = "";

			// diagnosis_value
			$this->diagnosis_value->LinkCustomAttributes = "";
			$this->diagnosis_value->HrefValue = "";

			// diagnosis_st_min
			$this->diagnosis_st_min->LinkCustomAttributes = "";
			$this->diagnosis_st_min->HrefValue = "";

			// diagnosis_st_max
			$this->diagnosis_st_max->LinkCustomAttributes = "";
			$this->diagnosis_st_max->HrefValue = "";

			// diagnosis_unit
			$this->diagnosis_unit->LinkCustomAttributes = "";
			$this->diagnosis_unit->HrefValue = "";

			// balance_amount
			$this->balance_amount->LinkCustomAttributes = "";
			$this->balance_amount->HrefValue = "";
			$this->balance_amount->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";

			// sex
			$this->sex->LinkCustomAttributes = "";
			$this->sex->HrefValue = "";

			// referral
			$this->referral->LinkCustomAttributes = "";
			$this->referral->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// examination_grp
			$this->examination_grp->LinkCustomAttributes = "";
			$this->examination_grp->HrefValue = "";
			$this->examination_grp->TooltipValue = "";

			// diagnosis_datetime
			$this->diagnosis_datetime->LinkCustomAttributes = "";
			$this->diagnosis_datetime->HrefValue = "";
			$this->diagnosis_datetime->TooltipValue = "";

			// import_value
			$this->import_value->LinkCustomAttributes = "";
			$this->import_value->HrefValue = "";
			$this->import_value->TooltipValue = "";

			// total_amount
			$this->total_amount->LinkCustomAttributes = "";
			$this->total_amount->HrefValue = "";
			$this->total_amount->TooltipValue = "";

			// discount_amount
			$this->discount_amount->LinkCustomAttributes = "";
			$this->discount_amount->HrefValue = "";

			// received_amount
			$this->received_amount->LinkCustomAttributes = "";
			$this->received_amount->HrefValue = "";
			$this->received_amount->TooltipValue = "";

			// examination_id
			$this->examination_id->LinkCustomAttributes = "";
			$this->examination_id->HrefValue = "";
			$this->examination_id->TooltipValue = "";

			// examination_name
			$this->examination_name->LinkCustomAttributes = "";
			$this->examination_name->HrefValue = "";
			$this->examination_name->TooltipValue = "";

			// uid
			$this->uid->LinkCustomAttributes = "";
			$this->uid->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->d_id->Required) {
			if (!$this->d_id->IsDetailKey && $this->d_id->FormValue != NULL && $this->d_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_id->caption(), $this->d_id->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if ($this->name->Required) {
			if (!$this->name->IsDetailKey && $this->name->FormValue != NULL && $this->name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
			}
		}
		if ($this->examination_code->Required) {
			if (!$this->examination_code->IsDetailKey && $this->examination_code->FormValue != NULL && $this->examination_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->examination_code->caption(), $this->examination_code->RequiredErrorMessage));
			}
		}
		if ($this->diagnosis_value->Required) {
			if (!$this->diagnosis_value->IsDetailKey && $this->diagnosis_value->FormValue != NULL && $this->diagnosis_value->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diagnosis_value->caption(), $this->diagnosis_value->RequiredErrorMessage));
			}
		}
		if ($this->diagnosis_st_min->Required) {
			if (!$this->diagnosis_st_min->IsDetailKey && $this->diagnosis_st_min->FormValue != NULL && $this->diagnosis_st_min->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diagnosis_st_min->caption(), $this->diagnosis_st_min->RequiredErrorMessage));
			}
		}
		if ($this->diagnosis_st_max->Required) {
			if (!$this->diagnosis_st_max->IsDetailKey && $this->diagnosis_st_max->FormValue != NULL && $this->diagnosis_st_max->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diagnosis_st_max->caption(), $this->diagnosis_st_max->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->diagnosis_st_max->FormValue)) {
			AddMessage($FormError, $this->diagnosis_st_max->errorMessage());
		}
		if ($this->diagnosis_unit->Required) {
			if (!$this->diagnosis_unit->IsDetailKey && $this->diagnosis_unit->FormValue != NULL && $this->diagnosis_unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diagnosis_unit->caption(), $this->diagnosis_unit->RequiredErrorMessage));
			}
		}
		if ($this->balance_amount->Required) {
			if (!$this->balance_amount->IsDetailKey && $this->balance_amount->FormValue != NULL && $this->balance_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance_amount->caption(), $this->balance_amount->RequiredErrorMessage));
			}
		}
		if ($this->age->Required) {
			if (!$this->age->IsDetailKey && $this->age->FormValue != NULL && $this->age->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->age->caption(), $this->age->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->age->FormValue)) {
			AddMessage($FormError, $this->age->errorMessage());
		}
		if ($this->sex->Required) {
			if ($this->sex->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sex->caption(), $this->sex->RequiredErrorMessage));
			}
		}
		if ($this->referral->Required) {
			if (!$this->referral->IsDetailKey && $this->referral->FormValue != NULL && $this->referral->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->referral->caption(), $this->referral->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->referral->FormValue)) {
			AddMessage($FormError, $this->referral->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->examination_grp->Required) {
			if (!$this->examination_grp->IsDetailKey && $this->examination_grp->FormValue != NULL && $this->examination_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->examination_grp->caption(), $this->examination_grp->RequiredErrorMessage));
			}
		}
		if ($this->diagnosis_datetime->Required) {
			if (!$this->diagnosis_datetime->IsDetailKey && $this->diagnosis_datetime->FormValue != NULL && $this->diagnosis_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diagnosis_datetime->caption(), $this->diagnosis_datetime->RequiredErrorMessage));
			}
		}
		if ($this->import_value->Required) {
			if (!$this->import_value->IsDetailKey && $this->import_value->FormValue != NULL && $this->import_value->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->import_value->caption(), $this->import_value->RequiredErrorMessage));
			}
		}
		if ($this->total_amount->Required) {
			if (!$this->total_amount->IsDetailKey && $this->total_amount->FormValue != NULL && $this->total_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
			}
		}
		if ($this->discount_amount->Required) {
			if (!$this->discount_amount->IsDetailKey && $this->discount_amount->FormValue != NULL && $this->discount_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->discount_amount->caption(), $this->discount_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->discount_amount->FormValue)) {
			AddMessage($FormError, $this->discount_amount->errorMessage());
		}
		if ($this->received_amount->Required) {
			if (!$this->received_amount->IsDetailKey && $this->received_amount->FormValue != NULL && $this->received_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->received_amount->caption(), $this->received_amount->RequiredErrorMessage));
			}
		}
		if ($this->examination_id->Required) {
			if (!$this->examination_id->IsDetailKey && $this->examination_id->FormValue != NULL && $this->examination_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->examination_id->caption(), $this->examination_id->RequiredErrorMessage));
			}
		}
		if ($this->examination_name->Required) {
			if (!$this->examination_name->IsDetailKey && $this->examination_name->FormValue != NULL && $this->examination_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->examination_name->caption(), $this->examination_name->RequiredErrorMessage));
			}
		}
		if ($this->uid->Required) {
			if (!$this->uid->IsDetailKey && $this->uid->FormValue != NULL && $this->uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->user->Required) {
			if (!$this->user->IsDetailKey && $this->user->FormValue != NULL && $this->user->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->user->caption(), $this->user->RequiredErrorMessage));
			}
		}
		if ($this->report_grp->Required) {
			if (!$this->report_grp->IsDetailKey && $this->report_grp->FormValue != NULL && $this->report_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->report_grp->caption(), $this->report_grp->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// name
			$this->name->setDbValueDef($rsnew, $this->name->CurrentValue, NULL, $this->name->ReadOnly);

			// diagnosis_value
			$this->diagnosis_value->setDbValueDef($rsnew, $this->diagnosis_value->CurrentValue, NULL, $this->diagnosis_value->ReadOnly);

			// diagnosis_st_min
			$this->diagnosis_st_min->setDbValueDef($rsnew, $this->diagnosis_st_min->CurrentValue, NULL, $this->diagnosis_st_min->ReadOnly);

			// diagnosis_st_max
			$this->diagnosis_st_max->setDbValueDef($rsnew, $this->diagnosis_st_max->CurrentValue, NULL, $this->diagnosis_st_max->ReadOnly);

			// diagnosis_unit
			$this->diagnosis_unit->setDbValueDef($rsnew, $this->diagnosis_unit->CurrentValue, NULL, $this->diagnosis_unit->ReadOnly);

			// age
			$this->age->setDbValueDef($rsnew, $this->age->CurrentValue, 0, $this->age->ReadOnly);

			// sex
			$this->sex->setDbValueDef($rsnew, $this->sex->CurrentValue, 0, $this->sex->ReadOnly);

			// referral
			$this->referral->setDbValueDef($rsnew, $this->referral->CurrentValue, NULL, $this->referral->ReadOnly);

			// discount_amount
			$this->discount_amount->setDbValueDef($rsnew, $this->discount_amount->CurrentValue, 0, $this->discount_amount->ReadOnly);

			// uid
			// operator

			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("_l_examination_reportlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_examination_grp":
					$lookupFilter = function() {
						return "`status`=1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_mobile":
							break;
						case "x_name":
							break;
						case "x_referral":
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_examination_grp":
							break;
						case "x_user":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>