<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for ref_view
 */
class _ref_view extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $product;
	public $product_n;
	public $ref_status;
	public $product_code;
	public $url;
	public $oid;
	public $company_id;
	public $grp;
	public $s_grp;
	public $product_type;
	public $gcode;
	public $code;
	public $product_id;
	public $print_name;
	public $batch_no;
	public $v_01;
	public $v_02;
	public $v_03;
	public $v_04;
	public $v_05;
	public $v_06;
	public $v_07;
	public $v_08;
	public $v_09;
	public $v_10;
	public $b_01;
	public $b_02;
	public $b_03;
	public $b_04;
	public $b_05;
	public $b_06;
	public $b_07;
	public $b_08;
	public $b_09;
	public $b_10;
	public $b_11;
	public $b_12;
	public $b_13;
	public $b_14;
	public $b_15;
	public $t_01;
	public $t_02;
	public $t_03;
	public $t_04;
	public $t_05;
	public $t_06;
	public $t_07;
	public $t_08;
	public $t_09;
	public $t_10;
	public $t_11;
	public $t_12;
	public $t_13;
	public $t_14;
	public $t_15;
	public $d_head_01;
	public $d_description_01;
	public $d_head_02;
	public $d_description_02;
	public $image;
	public $main_image;
	public $top_view;
	public $front_view;
	public $corner_view;
	public $back_view;
	public $color_options;
	public $other_options;
	public $last_price;
	public $hsn;
	public $status;
	public $operator;
	public $datetime;
	public $currency;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = '_ref_view';
		$this->TableName = 'ref_view';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`ref_view`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('_ref_view', 'ref_view', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->IsForeignKey = TRUE; // Foreign key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// product
		$this->product = new DbField('_ref_view', 'ref_view', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`EV__product`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], [], [], [], [], ["product"], ["x_product_n"], '`product` ASC', '');
		$this->fields['product'] = &$this->product;

		// product_n
		$this->product_n = new DbField('_ref_view', 'ref_view', 'x_product_n', 'product_n', '`product_n`', '`product_n`', 200, -1, FALSE, '`product_n`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_n->Required = TRUE; // Required field
		$this->product_n->Sortable = TRUE; // Allow sort
		$this->fields['product_n'] = &$this->product_n;

		// ref_status
		$this->ref_status = new DbField('_ref_view', 'ref_view', 'x_ref_status', 'ref_status', '`ref_status`', '`ref_status`', 200, -1, FALSE, '`ref_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ref_status->Nullable = FALSE; // NOT NULL field
		$this->ref_status->Required = TRUE; // Required field
		$this->ref_status->Sortable = TRUE; // Allow sort
		$this->fields['ref_status'] = &$this->ref_status;

		// product_code
		$this->product_code = new DbField('_ref_view', 'ref_view', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// url
		$this->url = new DbField('_ref_view', 'ref_view', 'x_url', 'url', 'if(`ref_status` = \'Create\', concat(\'autoprogramme.php?apcid=892c91e0a653ba19df81a90f89d99bcd&pc=\',product_code), \'\')', 'if(`ref_status` = \'Create\', concat(\'autoprogramme.php?apcid=892c91e0a653ba19df81a90f89d99bcd&pc=\',product_code), \'\')', 201, -1, FALSE, 'if(`ref_status` = \'Create\', concat(\'autoprogramme.php?apcid=892c91e0a653ba19df81a90f89d99bcd&pc=\',product_code), \'\')', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->url->IsCustom = TRUE; // Custom field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;

		// oid
		$this->oid = new DbField('_ref_view', 'ref_view', 'x_oid', 'oid', '`oid`', '`oid`', 200, -1, FALSE, '`oid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->oid->Sortable = FALSE; // Allow sort
		$this->fields['oid'] = &$this->oid;

		// company_id
		$this->company_id = new DbField('_ref_view', 'ref_view', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 201, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = FALSE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// grp
		$this->grp = new DbField('_ref_view', 'ref_view', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('_ref_view', 'ref_view', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product_type
		$this->product_type = new DbField('_ref_view', 'ref_view', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 200, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_type->Sortable = FALSE; // Allow sort
		$this->product_type->Lookup = new Lookup('product_type', 'product_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['product_type'] = &$this->product_type;

		// gcode
		$this->gcode = new DbField('_ref_view', 'ref_view', 'x_gcode', 'gcode', '`gcode`', '`gcode`', 200, -1, FALSE, '`gcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gcode->Sortable = FALSE; // Allow sort
		$this->fields['gcode'] = &$this->gcode;

		// code
		$this->code = new DbField('_ref_view', 'ref_view', 'x_code', 'code', '`code`', '`code`', 200, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code->Sortable = FALSE; // Allow sort
		$this->fields['code'] = &$this->code;

		// product_id
		$this->product_id = new DbField('_ref_view', 'ref_view', 'x_product_id', 'product_id', '`product_id`', '`product_id`', 200, -1, FALSE, '`product_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_id->Sortable = FALSE; // Allow sort
		$this->fields['product_id'] = &$this->product_id;

		// print_name
		$this->print_name = new DbField('_ref_view', 'ref_view', 'x_print_name', 'print_name', '`print_name`', '`print_name`', 200, -1, FALSE, '`print_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->print_name->Sortable = FALSE; // Allow sort
		$this->fields['print_name'] = &$this->print_name;

		// batch_no
		$this->batch_no = new DbField('_ref_view', 'ref_view', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 200, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Sortable = FALSE; // Allow sort
		$this->fields['batch_no'] = &$this->batch_no;

		// v_01
		$this->v_01 = new DbField('_ref_view', 'ref_view', 'x_v_01', 'v_01', '`v_01`', '`v_01`', 200, -1, FALSE, '`v_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_01->Sortable = FALSE; // Allow sort
		$this->fields['v_01'] = &$this->v_01;

		// v_02
		$this->v_02 = new DbField('_ref_view', 'ref_view', 'x_v_02', 'v_02', '`v_02`', '`v_02`', 200, -1, FALSE, '`v_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_02->Sortable = FALSE; // Allow sort
		$this->fields['v_02'] = &$this->v_02;

		// v_03
		$this->v_03 = new DbField('_ref_view', 'ref_view', 'x_v_03', 'v_03', '`v_03`', '`v_03`', 200, -1, FALSE, '`v_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_03->Sortable = FALSE; // Allow sort
		$this->fields['v_03'] = &$this->v_03;

		// v_04
		$this->v_04 = new DbField('_ref_view', 'ref_view', 'x_v_04', 'v_04', '`v_04`', '`v_04`', 200, -1, FALSE, '`v_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_04->Sortable = FALSE; // Allow sort
		$this->fields['v_04'] = &$this->v_04;

		// v_05
		$this->v_05 = new DbField('_ref_view', 'ref_view', 'x_v_05', 'v_05', '`v_05`', '`v_05`', 200, -1, FALSE, '`v_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_05->Sortable = FALSE; // Allow sort
		$this->fields['v_05'] = &$this->v_05;

		// v_06
		$this->v_06 = new DbField('_ref_view', 'ref_view', 'x_v_06', 'v_06', '`v_06`', '`v_06`', 200, -1, FALSE, '`v_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_06->Sortable = FALSE; // Allow sort
		$this->fields['v_06'] = &$this->v_06;

		// v_07
		$this->v_07 = new DbField('_ref_view', 'ref_view', 'x_v_07', 'v_07', '`v_07`', '`v_07`', 200, -1, FALSE, '`v_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_07->Sortable = FALSE; // Allow sort
		$this->fields['v_07'] = &$this->v_07;

		// v_08
		$this->v_08 = new DbField('_ref_view', 'ref_view', 'x_v_08', 'v_08', '`v_08`', '`v_08`', 200, -1, FALSE, '`v_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_08->Sortable = FALSE; // Allow sort
		$this->fields['v_08'] = &$this->v_08;

		// v_09
		$this->v_09 = new DbField('_ref_view', 'ref_view', 'x_v_09', 'v_09', '`v_09`', '`v_09`', 200, -1, FALSE, '`v_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_09->Sortable = FALSE; // Allow sort
		$this->fields['v_09'] = &$this->v_09;

		// v_10
		$this->v_10 = new DbField('_ref_view', 'ref_view', 'x_v_10', 'v_10', '`v_10`', '`v_10`', 200, -1, FALSE, '`v_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->v_10->Sortable = TRUE; // Allow sort
		$this->fields['v_10'] = &$this->v_10;

		// b_01
		$this->b_01 = new DbField('_ref_view', 'ref_view', 'x_b_01', 'b_01', '`b_01`', '`b_01`', 200, -1, FALSE, '`b_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_01->Sortable = TRUE; // Allow sort
		$this->fields['b_01'] = &$this->b_01;

		// b_02
		$this->b_02 = new DbField('_ref_view', 'ref_view', 'x_b_02', 'b_02', '`b_02`', '`b_02`', 200, -1, FALSE, '`b_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_02->Sortable = TRUE; // Allow sort
		$this->fields['b_02'] = &$this->b_02;

		// b_03
		$this->b_03 = new DbField('_ref_view', 'ref_view', 'x_b_03', 'b_03', '`b_03`', '`b_03`', 200, -1, FALSE, '`b_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_03->Sortable = TRUE; // Allow sort
		$this->fields['b_03'] = &$this->b_03;

		// b_04
		$this->b_04 = new DbField('_ref_view', 'ref_view', 'x_b_04', 'b_04', '`b_04`', '`b_04`', 200, -1, FALSE, '`b_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_04->Sortable = TRUE; // Allow sort
		$this->fields['b_04'] = &$this->b_04;

		// b_05
		$this->b_05 = new DbField('_ref_view', 'ref_view', 'x_b_05', 'b_05', '`b_05`', '`b_05`', 200, -1, FALSE, '`b_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_05->Sortable = TRUE; // Allow sort
		$this->fields['b_05'] = &$this->b_05;

		// b_06
		$this->b_06 = new DbField('_ref_view', 'ref_view', 'x_b_06', 'b_06', '`b_06`', '`b_06`', 200, -1, FALSE, '`b_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_06->Sortable = TRUE; // Allow sort
		$this->fields['b_06'] = &$this->b_06;

		// b_07
		$this->b_07 = new DbField('_ref_view', 'ref_view', 'x_b_07', 'b_07', '`b_07`', '`b_07`', 200, -1, FALSE, '`b_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_07->Sortable = TRUE; // Allow sort
		$this->fields['b_07'] = &$this->b_07;

		// b_08
		$this->b_08 = new DbField('_ref_view', 'ref_view', 'x_b_08', 'b_08', '`b_08`', '`b_08`', 200, -1, FALSE, '`b_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_08->Sortable = TRUE; // Allow sort
		$this->fields['b_08'] = &$this->b_08;

		// b_09
		$this->b_09 = new DbField('_ref_view', 'ref_view', 'x_b_09', 'b_09', '`b_09`', '`b_09`', 200, -1, FALSE, '`b_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_09->Sortable = TRUE; // Allow sort
		$this->fields['b_09'] = &$this->b_09;

		// b_10
		$this->b_10 = new DbField('_ref_view', 'ref_view', 'x_b_10', 'b_10', '`b_10`', '`b_10`', 200, -1, FALSE, '`b_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_10->Sortable = TRUE; // Allow sort
		$this->fields['b_10'] = &$this->b_10;

		// b_11
		$this->b_11 = new DbField('_ref_view', 'ref_view', 'x_b_11', 'b_11', '`b_11`', '`b_11`', 200, -1, FALSE, '`b_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_11->Sortable = TRUE; // Allow sort
		$this->fields['b_11'] = &$this->b_11;

		// b_12
		$this->b_12 = new DbField('_ref_view', 'ref_view', 'x_b_12', 'b_12', '`b_12`', '`b_12`', 200, -1, FALSE, '`b_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_12->Sortable = TRUE; // Allow sort
		$this->fields['b_12'] = &$this->b_12;

		// b_13
		$this->b_13 = new DbField('_ref_view', 'ref_view', 'x_b_13', 'b_13', '`b_13`', '`b_13`', 200, -1, FALSE, '`b_13`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_13->Sortable = TRUE; // Allow sort
		$this->fields['b_13'] = &$this->b_13;

		// b_14
		$this->b_14 = new DbField('_ref_view', 'ref_view', 'x_b_14', 'b_14', '`b_14`', '`b_14`', 200, -1, FALSE, '`b_14`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_14->Sortable = TRUE; // Allow sort
		$this->fields['b_14'] = &$this->b_14;

		// b_15
		$this->b_15 = new DbField('_ref_view', 'ref_view', 'x_b_15', 'b_15', '`b_15`', '`b_15`', 200, -1, FALSE, '`b_15`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_15->Sortable = TRUE; // Allow sort
		$this->fields['b_15'] = &$this->b_15;

		// t_01
		$this->t_01 = new DbField('_ref_view', 'ref_view', 'x_t_01', 't_01', '`t_01`', '`t_01`', 200, -1, FALSE, '`t_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_01->Sortable = TRUE; // Allow sort
		$this->fields['t_01'] = &$this->t_01;

		// t_02
		$this->t_02 = new DbField('_ref_view', 'ref_view', 'x_t_02', 't_02', '`t_02`', '`t_02`', 200, -1, FALSE, '`t_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_02->Sortable = TRUE; // Allow sort
		$this->fields['t_02'] = &$this->t_02;

		// t_03
		$this->t_03 = new DbField('_ref_view', 'ref_view', 'x_t_03', 't_03', '`t_03`', '`t_03`', 200, -1, FALSE, '`t_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_03->Sortable = TRUE; // Allow sort
		$this->fields['t_03'] = &$this->t_03;

		// t_04
		$this->t_04 = new DbField('_ref_view', 'ref_view', 'x_t_04', 't_04', '`t_04`', '`t_04`', 200, -1, FALSE, '`t_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_04->Sortable = TRUE; // Allow sort
		$this->fields['t_04'] = &$this->t_04;

		// t_05
		$this->t_05 = new DbField('_ref_view', 'ref_view', 'x_t_05', 't_05', '`t_05`', '`t_05`', 200, -1, FALSE, '`t_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_05->Sortable = TRUE; // Allow sort
		$this->fields['t_05'] = &$this->t_05;

		// t_06
		$this->t_06 = new DbField('_ref_view', 'ref_view', 'x_t_06', 't_06', '`t_06`', '`t_06`', 200, -1, FALSE, '`t_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_06->Sortable = TRUE; // Allow sort
		$this->fields['t_06'] = &$this->t_06;

		// t_07
		$this->t_07 = new DbField('_ref_view', 'ref_view', 'x_t_07', 't_07', '`t_07`', '`t_07`', 200, -1, FALSE, '`t_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_07->Sortable = TRUE; // Allow sort
		$this->fields['t_07'] = &$this->t_07;

		// t_08
		$this->t_08 = new DbField('_ref_view', 'ref_view', 'x_t_08', 't_08', '`t_08`', '`t_08`', 200, -1, FALSE, '`t_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_08->Sortable = TRUE; // Allow sort
		$this->fields['t_08'] = &$this->t_08;

		// t_09
		$this->t_09 = new DbField('_ref_view', 'ref_view', 'x_t_09', 't_09', '`t_09`', '`t_09`', 200, -1, FALSE, '`t_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_09->Sortable = TRUE; // Allow sort
		$this->fields['t_09'] = &$this->t_09;

		// t_10
		$this->t_10 = new DbField('_ref_view', 'ref_view', 'x_t_10', 't_10', '`t_10`', '`t_10`', 200, -1, FALSE, '`t_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_10->Sortable = TRUE; // Allow sort
		$this->fields['t_10'] = &$this->t_10;

		// t_11
		$this->t_11 = new DbField('_ref_view', 'ref_view', 'x_t_11', 't_11', '`t_11`', '`t_11`', 200, -1, FALSE, '`t_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_11->Sortable = TRUE; // Allow sort
		$this->fields['t_11'] = &$this->t_11;

		// t_12
		$this->t_12 = new DbField('_ref_view', 'ref_view', 'x_t_12', 't_12', '`t_12`', '`t_12`', 200, -1, FALSE, '`t_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_12->Sortable = TRUE; // Allow sort
		$this->fields['t_12'] = &$this->t_12;

		// t_13
		$this->t_13 = new DbField('_ref_view', 'ref_view', 'x_t_13', 't_13', '`t_13`', '`t_13`', 200, -1, FALSE, '`t_13`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_13->Sortable = TRUE; // Allow sort
		$this->fields['t_13'] = &$this->t_13;

		// t_14
		$this->t_14 = new DbField('_ref_view', 'ref_view', 'x_t_14', 't_14', '`t_14`', '`t_14`', 200, -1, FALSE, '`t_14`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_14->Sortable = TRUE; // Allow sort
		$this->fields['t_14'] = &$this->t_14;

		// t_15
		$this->t_15 = new DbField('_ref_view', 'ref_view', 'x_t_15', 't_15', '`t_15`', '`t_15`', 200, -1, FALSE, '`t_15`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_15->Sortable = TRUE; // Allow sort
		$this->fields['t_15'] = &$this->t_15;

		// d_head_01
		$this->d_head_01 = new DbField('_ref_view', 'ref_view', 'x_d_head_01', 'd_head_01', '`d_head_01`', '`d_head_01`', 200, -1, FALSE, '`d_head_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_head_01->Sortable = TRUE; // Allow sort
		$this->fields['d_head_01'] = &$this->d_head_01;

		// d_description_01
		$this->d_description_01 = new DbField('_ref_view', 'ref_view', 'x_d_description_01', 'd_description_01', '`d_description_01`', '`d_description_01`', 201, -1, FALSE, '`d_description_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->d_description_01->Sortable = TRUE; // Allow sort
		$this->fields['d_description_01'] = &$this->d_description_01;

		// d_head_02
		$this->d_head_02 = new DbField('_ref_view', 'ref_view', 'x_d_head_02', 'd_head_02', '`d_head_02`', '`d_head_02`', 200, -1, FALSE, '`d_head_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_head_02->Sortable = TRUE; // Allow sort
		$this->fields['d_head_02'] = &$this->d_head_02;

		// d_description_02
		$this->d_description_02 = new DbField('_ref_view', 'ref_view', 'x_d_description_02', 'd_description_02', '`d_description_02`', '`d_description_02`', 201, -1, FALSE, '`d_description_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->d_description_02->Sortable = TRUE; // Allow sort
		$this->fields['d_description_02'] = &$this->d_description_02;

		// image
		$this->image = new DbField('_ref_view', 'ref_view', 'x_image', 'image', '`image`', '`image`', 200, -1, FALSE, '`image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->image->Sortable = TRUE; // Allow sort
		$this->fields['image'] = &$this->image;

		// main_image
		$this->main_image = new DbField('_ref_view', 'ref_view', 'x_main_image', 'main_image', '`main_image`', '`main_image`', 200, -1, FALSE, '`main_image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->main_image->Sortable = TRUE; // Allow sort
		$this->fields['main_image'] = &$this->main_image;

		// top_view
		$this->top_view = new DbField('_ref_view', 'ref_view', 'x_top_view', 'top_view', '`top_view`', '`top_view`', 200, -1, FALSE, '`top_view`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->top_view->Sortable = TRUE; // Allow sort
		$this->fields['top_view'] = &$this->top_view;

		// front_view
		$this->front_view = new DbField('_ref_view', 'ref_view', 'x_front_view', 'front_view', '`front_view`', '`front_view`', 200, -1, FALSE, '`front_view`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->front_view->Sortable = TRUE; // Allow sort
		$this->fields['front_view'] = &$this->front_view;

		// corner_view
		$this->corner_view = new DbField('_ref_view', 'ref_view', 'x_corner_view', 'corner_view', '`corner_view`', '`corner_view`', 200, -1, FALSE, '`corner_view`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->corner_view->Sortable = TRUE; // Allow sort
		$this->fields['corner_view'] = &$this->corner_view;

		// back_view
		$this->back_view = new DbField('_ref_view', 'ref_view', 'x_back_view', 'back_view', '`back_view`', '`back_view`', 200, -1, FALSE, '`back_view`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->back_view->Sortable = TRUE; // Allow sort
		$this->fields['back_view'] = &$this->back_view;

		// color_options
		$this->color_options = new DbField('_ref_view', 'ref_view', 'x_color_options', 'color_options', '`color_options`', '`color_options`', 200, -1, FALSE, '`color_options`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->color_options->Sortable = TRUE; // Allow sort
		$this->fields['color_options'] = &$this->color_options;

		// other_options
		$this->other_options = new DbField('_ref_view', 'ref_view', 'x_other_options', 'other_options', '`other_options`', '`other_options`', 200, -1, FALSE, '`other_options`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other_options->Sortable = TRUE; // Allow sort
		$this->fields['other_options'] = &$this->other_options;

		// last_price
		$this->last_price = new DbField('_ref_view', 'ref_view', 'x_last_price', 'last_price', '`last_price`', '`last_price`', 200, -1, FALSE, '`last_price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->last_price->Sortable = TRUE; // Allow sort
		$this->fields['last_price'] = &$this->last_price;

		// hsn
		$this->hsn = new DbField('_ref_view', 'ref_view', 'x_hsn', 'hsn', '`hsn`', '`hsn`', 3, -1, FALSE, '`hsn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->hsn->Sortable = TRUE; // Allow sort
		$this->hsn->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['hsn'] = &$this->hsn;

		// status
		$this->status = new DbField('_ref_view', 'ref_view', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('_ref_view', 'ref_view', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('_ref_view', 'ref_view', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Required = TRUE; // Required field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// currency
		$this->currency = new DbField('_ref_view', 'ref_view', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->currency->Nullable = FALSE; // NOT NULL field
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "ref_multi") {
			if ($this->id->getSessionValue() <> "")
				$masterFilter .= "`id`=" . QuotedValue($this->id->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "ref_multi") {
			if ($this->id->getSessionValue() <> "")
				$detailFilter .= "`id`=" . QuotedValue($this->id->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_ref_multi()
	{
		return "`id`=@id@";
	}

	// Detail filter
	public function sqlDetailFilter_ref_multi()
	{
		return "`id`=@id@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`ref_view`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, if(`ref_status` = 'Create', concat('autoprogramme.php?apcid=892c91e0a653ba19df81a90f89d99bcd&pc=',product_code), '') AS `url` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, if(`ref_status` = 'Create', concat('autoprogramme.php?apcid=892c91e0a653ba19df81a90f89d99bcd&pc=',product_code), '') AS `url`, (SELECT `product` FROM `product` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `ref_view`.`product` LIMIT 1) AS `EV__product` FROM `ref_view`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->product->AdvancedSearch->SearchValue <> "" ||
			$this->product->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->product->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->product->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->product->DbValue = $row['product'];
		$this->product_n->DbValue = $row['product_n'];
		$this->ref_status->DbValue = $row['ref_status'];
		$this->product_code->DbValue = $row['product_code'];
		$this->url->DbValue = $row['url'];
		$this->oid->DbValue = $row['oid'];
		$this->company_id->DbValue = $row['company_id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product_type->DbValue = $row['product_type'];
		$this->gcode->DbValue = $row['gcode'];
		$this->code->DbValue = $row['code'];
		$this->product_id->DbValue = $row['product_id'];
		$this->print_name->DbValue = $row['print_name'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->v_01->DbValue = $row['v_01'];
		$this->v_02->DbValue = $row['v_02'];
		$this->v_03->DbValue = $row['v_03'];
		$this->v_04->DbValue = $row['v_04'];
		$this->v_05->DbValue = $row['v_05'];
		$this->v_06->DbValue = $row['v_06'];
		$this->v_07->DbValue = $row['v_07'];
		$this->v_08->DbValue = $row['v_08'];
		$this->v_09->DbValue = $row['v_09'];
		$this->v_10->DbValue = $row['v_10'];
		$this->b_01->DbValue = $row['b_01'];
		$this->b_02->DbValue = $row['b_02'];
		$this->b_03->DbValue = $row['b_03'];
		$this->b_04->DbValue = $row['b_04'];
		$this->b_05->DbValue = $row['b_05'];
		$this->b_06->DbValue = $row['b_06'];
		$this->b_07->DbValue = $row['b_07'];
		$this->b_08->DbValue = $row['b_08'];
		$this->b_09->DbValue = $row['b_09'];
		$this->b_10->DbValue = $row['b_10'];
		$this->b_11->DbValue = $row['b_11'];
		$this->b_12->DbValue = $row['b_12'];
		$this->b_13->DbValue = $row['b_13'];
		$this->b_14->DbValue = $row['b_14'];
		$this->b_15->DbValue = $row['b_15'];
		$this->t_01->DbValue = $row['t_01'];
		$this->t_02->DbValue = $row['t_02'];
		$this->t_03->DbValue = $row['t_03'];
		$this->t_04->DbValue = $row['t_04'];
		$this->t_05->DbValue = $row['t_05'];
		$this->t_06->DbValue = $row['t_06'];
		$this->t_07->DbValue = $row['t_07'];
		$this->t_08->DbValue = $row['t_08'];
		$this->t_09->DbValue = $row['t_09'];
		$this->t_10->DbValue = $row['t_10'];
		$this->t_11->DbValue = $row['t_11'];
		$this->t_12->DbValue = $row['t_12'];
		$this->t_13->DbValue = $row['t_13'];
		$this->t_14->DbValue = $row['t_14'];
		$this->t_15->DbValue = $row['t_15'];
		$this->d_head_01->DbValue = $row['d_head_01'];
		$this->d_description_01->DbValue = $row['d_description_01'];
		$this->d_head_02->DbValue = $row['d_head_02'];
		$this->d_description_02->DbValue = $row['d_description_02'];
		$this->image->DbValue = $row['image'];
		$this->main_image->DbValue = $row['main_image'];
		$this->top_view->DbValue = $row['top_view'];
		$this->front_view->DbValue = $row['front_view'];
		$this->corner_view->DbValue = $row['corner_view'];
		$this->back_view->DbValue = $row['back_view'];
		$this->color_options->DbValue = $row['color_options'];
		$this->other_options->DbValue = $row['other_options'];
		$this->last_price->DbValue = $row['last_price'];
		$this->hsn->DbValue = $row['hsn'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->currency->DbValue = $row['currency'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "_ref_viewlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "_ref_viewview.php")
			return $Language->phrase("View");
		elseif ($pageName == "_ref_viewedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "_ref_viewadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "_ref_viewlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("_ref_viewview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("_ref_viewview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "_ref_viewadd.php?" . $this->getUrlParm($parm);
		else
			$url = "_ref_viewadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("_ref_viewedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("_ref_viewadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("_ref_viewdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "ref_multi" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_n->setDbValue($rs->fields('product_n'));
		$this->ref_status->setDbValue($rs->fields('ref_status'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->url->setDbValue($rs->fields('url'));
		$this->oid->setDbValue($rs->fields('oid'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->gcode->setDbValue($rs->fields('gcode'));
		$this->code->setDbValue($rs->fields('code'));
		$this->product_id->setDbValue($rs->fields('product_id'));
		$this->print_name->setDbValue($rs->fields('print_name'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->v_01->setDbValue($rs->fields('v_01'));
		$this->v_02->setDbValue($rs->fields('v_02'));
		$this->v_03->setDbValue($rs->fields('v_03'));
		$this->v_04->setDbValue($rs->fields('v_04'));
		$this->v_05->setDbValue($rs->fields('v_05'));
		$this->v_06->setDbValue($rs->fields('v_06'));
		$this->v_07->setDbValue($rs->fields('v_07'));
		$this->v_08->setDbValue($rs->fields('v_08'));
		$this->v_09->setDbValue($rs->fields('v_09'));
		$this->v_10->setDbValue($rs->fields('v_10'));
		$this->b_01->setDbValue($rs->fields('b_01'));
		$this->b_02->setDbValue($rs->fields('b_02'));
		$this->b_03->setDbValue($rs->fields('b_03'));
		$this->b_04->setDbValue($rs->fields('b_04'));
		$this->b_05->setDbValue($rs->fields('b_05'));
		$this->b_06->setDbValue($rs->fields('b_06'));
		$this->b_07->setDbValue($rs->fields('b_07'));
		$this->b_08->setDbValue($rs->fields('b_08'));
		$this->b_09->setDbValue($rs->fields('b_09'));
		$this->b_10->setDbValue($rs->fields('b_10'));
		$this->b_11->setDbValue($rs->fields('b_11'));
		$this->b_12->setDbValue($rs->fields('b_12'));
		$this->b_13->setDbValue($rs->fields('b_13'));
		$this->b_14->setDbValue($rs->fields('b_14'));
		$this->b_15->setDbValue($rs->fields('b_15'));
		$this->t_01->setDbValue($rs->fields('t_01'));
		$this->t_02->setDbValue($rs->fields('t_02'));
		$this->t_03->setDbValue($rs->fields('t_03'));
		$this->t_04->setDbValue($rs->fields('t_04'));
		$this->t_05->setDbValue($rs->fields('t_05'));
		$this->t_06->setDbValue($rs->fields('t_06'));
		$this->t_07->setDbValue($rs->fields('t_07'));
		$this->t_08->setDbValue($rs->fields('t_08'));
		$this->t_09->setDbValue($rs->fields('t_09'));
		$this->t_10->setDbValue($rs->fields('t_10'));
		$this->t_11->setDbValue($rs->fields('t_11'));
		$this->t_12->setDbValue($rs->fields('t_12'));
		$this->t_13->setDbValue($rs->fields('t_13'));
		$this->t_14->setDbValue($rs->fields('t_14'));
		$this->t_15->setDbValue($rs->fields('t_15'));
		$this->d_head_01->setDbValue($rs->fields('d_head_01'));
		$this->d_description_01->setDbValue($rs->fields('d_description_01'));
		$this->d_head_02->setDbValue($rs->fields('d_head_02'));
		$this->d_description_02->setDbValue($rs->fields('d_description_02'));
		$this->image->setDbValue($rs->fields('image'));
		$this->main_image->setDbValue($rs->fields('main_image'));
		$this->top_view->setDbValue($rs->fields('top_view'));
		$this->front_view->setDbValue($rs->fields('front_view'));
		$this->corner_view->setDbValue($rs->fields('corner_view'));
		$this->back_view->setDbValue($rs->fields('back_view'));
		$this->color_options->setDbValue($rs->fields('color_options'));
		$this->other_options->setDbValue($rs->fields('other_options'));
		$this->last_price->setDbValue($rs->fields('last_price'));
		$this->hsn->setDbValue($rs->fields('hsn'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->currency->setDbValue($rs->fields('currency'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// product
		// product_n
		// ref_status
		// product_code
		// url

		$this->url->CellCssStyle = "white-space: nowrap;";

		// oid
		$this->oid->CellCssStyle = "white-space: nowrap;";

		// company_id
		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// product_type
		$this->product_type->CellCssStyle = "white-space: nowrap;";

		// gcode
		$this->gcode->CellCssStyle = "white-space: nowrap;";

		// code
		$this->code->CellCssStyle = "white-space: nowrap;";

		// product_id
		$this->product_id->CellCssStyle = "white-space: nowrap;";

		// print_name
		$this->print_name->CellCssStyle = "white-space: nowrap;";

		// batch_no
		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// v_01
		$this->v_01->CellCssStyle = "white-space: nowrap;";

		// v_02
		$this->v_02->CellCssStyle = "white-space: nowrap;";

		// v_03
		$this->v_03->CellCssStyle = "white-space: nowrap;";

		// v_04
		$this->v_04->CellCssStyle = "white-space: nowrap;";

		// v_05
		$this->v_05->CellCssStyle = "white-space: nowrap;";

		// v_06
		$this->v_06->CellCssStyle = "white-space: nowrap;";

		// v_07
		$this->v_07->CellCssStyle = "white-space: nowrap;";

		// v_08
		$this->v_08->CellCssStyle = "white-space: nowrap;";

		// v_09
		$this->v_09->CellCssStyle = "white-space: nowrap;";

		// v_10
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// image
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// last_price
		// hsn
		// status
		// operator
		// datetime
		// currency
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// product
		if ($this->product->VirtualValue <> "") {
			$this->product->ViewValue = $this->product->VirtualValue;
		} else {
			$this->product->ViewValue = $this->product->CurrentValue;
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		}
		$this->product->ViewCustomAttributes = "";

		// product_n
		$this->product_n->ViewValue = $this->product_n->CurrentValue;
		$this->product_n->ViewCustomAttributes = "";

		// ref_status
		$this->ref_status->ViewValue = $this->ref_status->CurrentValue;
		$this->ref_status->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// oid
		$this->oid->ViewValue = $this->oid->CurrentValue;
		$this->oid->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// product_type
		$this->product_type->ViewValue = $this->product_type->CurrentValue;
		$curVal = strval($this->product_type->CurrentValue);
		if ($curVal <> "") {
			$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			if ($this->product_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_type->ViewValue = $this->product_type->CurrentValue;
				}
			}
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// gcode
		$this->gcode->ViewValue = $this->gcode->CurrentValue;
		$this->gcode->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// product_id
		$this->product_id->ViewValue = $this->product_id->CurrentValue;
		$this->product_id->ViewCustomAttributes = "";

		// print_name
		$this->print_name->ViewValue = $this->print_name->CurrentValue;
		$this->print_name->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewCustomAttributes = "";

		// v_01
		$this->v_01->ViewValue = $this->v_01->CurrentValue;
		$this->v_01->ViewCustomAttributes = "";

		// v_02
		$this->v_02->ViewValue = $this->v_02->CurrentValue;
		$this->v_02->ViewCustomAttributes = "";

		// v_03
		$this->v_03->ViewValue = $this->v_03->CurrentValue;
		$this->v_03->ViewCustomAttributes = "";

		// v_04
		$this->v_04->ViewValue = $this->v_04->CurrentValue;
		$this->v_04->ViewCustomAttributes = "";

		// v_05
		$this->v_05->ViewValue = $this->v_05->CurrentValue;
		$this->v_05->ViewCustomAttributes = "";

		// v_06
		$this->v_06->ViewValue = $this->v_06->CurrentValue;
		$this->v_06->ViewCustomAttributes = "";

		// v_07
		$this->v_07->ViewValue = $this->v_07->CurrentValue;
		$this->v_07->ViewCustomAttributes = "";

		// v_08
		$this->v_08->ViewValue = $this->v_08->CurrentValue;
		$this->v_08->ViewCustomAttributes = "";

		// v_09
		$this->v_09->ViewValue = $this->v_09->CurrentValue;
		$this->v_09->ViewCustomAttributes = "";

		// v_10
		$this->v_10->ViewValue = $this->v_10->CurrentValue;
		$this->v_10->ViewCustomAttributes = "";

		// b_01
		$this->b_01->ViewValue = $this->b_01->CurrentValue;
		$this->b_01->ViewCustomAttributes = "";

		// b_02
		$this->b_02->ViewValue = $this->b_02->CurrentValue;
		$this->b_02->ViewCustomAttributes = "";

		// b_03
		$this->b_03->ViewValue = $this->b_03->CurrentValue;
		$this->b_03->ViewCustomAttributes = "";

		// b_04
		$this->b_04->ViewValue = $this->b_04->CurrentValue;
		$this->b_04->ViewCustomAttributes = "";

		// b_05
		$this->b_05->ViewValue = $this->b_05->CurrentValue;
		$this->b_05->ViewCustomAttributes = "";

		// b_06
		$this->b_06->ViewValue = $this->b_06->CurrentValue;
		$this->b_06->ViewCustomAttributes = "";

		// b_07
		$this->b_07->ViewValue = $this->b_07->CurrentValue;
		$this->b_07->ViewCustomAttributes = "";

		// b_08
		$this->b_08->ViewValue = $this->b_08->CurrentValue;
		$this->b_08->ViewCustomAttributes = "";

		// b_09
		$this->b_09->ViewValue = $this->b_09->CurrentValue;
		$this->b_09->ViewCustomAttributes = "";

		// b_10
		$this->b_10->ViewValue = $this->b_10->CurrentValue;
		$this->b_10->ViewCustomAttributes = "";

		// b_11
		$this->b_11->ViewValue = $this->b_11->CurrentValue;
		$this->b_11->ViewCustomAttributes = "";

		// b_12
		$this->b_12->ViewValue = $this->b_12->CurrentValue;
		$this->b_12->ViewCustomAttributes = "";

		// b_13
		$this->b_13->ViewValue = $this->b_13->CurrentValue;
		$this->b_13->ViewCustomAttributes = "";

		// b_14
		$this->b_14->ViewValue = $this->b_14->CurrentValue;
		$this->b_14->ViewCustomAttributes = "";

		// b_15
		$this->b_15->ViewValue = $this->b_15->CurrentValue;
		$this->b_15->ViewCustomAttributes = "";

		// t_01
		$this->t_01->ViewValue = $this->t_01->CurrentValue;
		$this->t_01->ViewCustomAttributes = "";

		// t_02
		$this->t_02->ViewValue = $this->t_02->CurrentValue;
		$this->t_02->ViewCustomAttributes = "";

		// t_03
		$this->t_03->ViewValue = $this->t_03->CurrentValue;
		$this->t_03->ViewCustomAttributes = "";

		// t_04
		$this->t_04->ViewValue = $this->t_04->CurrentValue;
		$this->t_04->ViewCustomAttributes = "";

		// t_05
		$this->t_05->ViewValue = $this->t_05->CurrentValue;
		$this->t_05->ViewCustomAttributes = "";

		// t_06
		$this->t_06->ViewValue = $this->t_06->CurrentValue;
		$this->t_06->ViewCustomAttributes = "";

		// t_07
		$this->t_07->ViewValue = $this->t_07->CurrentValue;
		$this->t_07->ViewCustomAttributes = "";

		// t_08
		$this->t_08->ViewValue = $this->t_08->CurrentValue;
		$this->t_08->ViewCustomAttributes = "";

		// t_09
		$this->t_09->ViewValue = $this->t_09->CurrentValue;
		$this->t_09->ViewCustomAttributes = "";

		// t_10
		$this->t_10->ViewValue = $this->t_10->CurrentValue;
		$this->t_10->ViewCustomAttributes = "";

		// t_11
		$this->t_11->ViewValue = $this->t_11->CurrentValue;
		$this->t_11->ViewCustomAttributes = "";

		// t_12
		$this->t_12->ViewValue = $this->t_12->CurrentValue;
		$this->t_12->ViewCustomAttributes = "";

		// t_13
		$this->t_13->ViewValue = $this->t_13->CurrentValue;
		$this->t_13->ViewCustomAttributes = "";

		// t_14
		$this->t_14->ViewValue = $this->t_14->CurrentValue;
		$this->t_14->ViewCustomAttributes = "";

		// t_15
		$this->t_15->ViewValue = $this->t_15->CurrentValue;
		$this->t_15->ViewCustomAttributes = "";

		// d_head_01
		$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
		$this->d_head_01->ViewCustomAttributes = "";

		// d_description_01
		$this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;
		$this->d_description_01->ViewCustomAttributes = "";

		// d_head_02
		$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
		$this->d_head_02->ViewCustomAttributes = "";

		// d_description_02
		$this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;
		$this->d_description_02->ViewCustomAttributes = "";

		// image
		$this->image->ViewValue = $this->image->CurrentValue;
		$this->image->ViewCustomAttributes = "";

		// main_image
		$this->main_image->ViewValue = $this->main_image->CurrentValue;
		$this->main_image->ViewCustomAttributes = "";

		// top_view
		$this->top_view->ViewValue = $this->top_view->CurrentValue;
		$this->top_view->ViewCustomAttributes = "";

		// front_view
		$this->front_view->ViewValue = $this->front_view->CurrentValue;
		$this->front_view->ViewCustomAttributes = "";

		// corner_view
		$this->corner_view->ViewValue = $this->corner_view->CurrentValue;
		$this->corner_view->ViewCustomAttributes = "";

		// back_view
		$this->back_view->ViewValue = $this->back_view->CurrentValue;
		$this->back_view->ViewCustomAttributes = "";

		// color_options
		$this->color_options->ViewValue = $this->color_options->CurrentValue;
		$this->color_options->ViewCustomAttributes = "";

		// other_options
		$this->other_options->ViewValue = $this->other_options->CurrentValue;
		$this->other_options->ViewCustomAttributes = "";

		// last_price
		$this->last_price->ViewValue = $this->last_price->CurrentValue;
		$this->last_price->ViewCustomAttributes = "";

		// hsn
		$this->hsn->ViewValue = $this->hsn->CurrentValue;
		$this->hsn->ViewValue = FormatNumber($this->hsn->ViewValue, 0, -2, -2, -2);
		$this->hsn->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// currency
		$this->currency->ViewValue = $this->currency->CurrentValue;
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "ref_viewlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// product_n
		$this->product_n->LinkCustomAttributes = "";
		if (!EmptyValue($this->product_n->CurrentValue)) {
			$this->product_n->HrefValue = "ref_viewlist.php?x_product_n=" . $this->product_n->CurrentValue; // Add prefix/suffix
			$this->product_n->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product_n->HrefValue = FullUrl($this->product_n->HrefValue, "href");
		} else {
			$this->product_n->HrefValue = "";
		}
		$this->product_n->TooltipValue = "";

		// ref_status
		$this->ref_status->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->ref_status->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->ref_status->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->ref_status->HrefValue = FullUrl($this->ref_status->HrefValue, "href");
		} else {
			$this->ref_status->HrefValue = "";
		}
		$this->ref_status->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		if (!EmptyValue($this->product_code->CurrentValue)) {
			$this->product_code->HrefValue = "ref_viewlist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
			$this->product_code->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
		} else {
			$this->product_code->HrefValue = "";
		}
		$this->product_code->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// oid
		$this->oid->LinkCustomAttributes = "";
		$this->oid->HrefValue = "";
		$this->oid->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// gcode
		$this->gcode->LinkCustomAttributes = "";
		$this->gcode->HrefValue = "";
		$this->gcode->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		$this->code->HrefValue = "";
		$this->code->TooltipValue = "";

		// product_id
		$this->product_id->LinkCustomAttributes = "";
		$this->product_id->HrefValue = "";
		$this->product_id->TooltipValue = "";

		// print_name
		$this->print_name->LinkCustomAttributes = "";
		$this->print_name->HrefValue = "";
		$this->print_name->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// v_01
		$this->v_01->LinkCustomAttributes = "";
		$this->v_01->HrefValue = "";
		$this->v_01->TooltipValue = "";

		// v_02
		$this->v_02->LinkCustomAttributes = "";
		$this->v_02->HrefValue = "";
		$this->v_02->TooltipValue = "";

		// v_03
		$this->v_03->LinkCustomAttributes = "";
		$this->v_03->HrefValue = "";
		$this->v_03->TooltipValue = "";

		// v_04
		$this->v_04->LinkCustomAttributes = "";
		$this->v_04->HrefValue = "";
		$this->v_04->TooltipValue = "";

		// v_05
		$this->v_05->LinkCustomAttributes = "";
		$this->v_05->HrefValue = "";
		$this->v_05->TooltipValue = "";

		// v_06
		$this->v_06->LinkCustomAttributes = "";
		$this->v_06->HrefValue = "";
		$this->v_06->TooltipValue = "";

		// v_07
		$this->v_07->LinkCustomAttributes = "";
		$this->v_07->HrefValue = "";
		$this->v_07->TooltipValue = "";

		// v_08
		$this->v_08->LinkCustomAttributes = "";
		$this->v_08->HrefValue = "";
		$this->v_08->TooltipValue = "";

		// v_09
		$this->v_09->LinkCustomAttributes = "";
		$this->v_09->HrefValue = "";
		$this->v_09->TooltipValue = "";

		// v_10
		$this->v_10->LinkCustomAttributes = "";
		$this->v_10->HrefValue = "";
		$this->v_10->TooltipValue = "";

		// b_01
		$this->b_01->LinkCustomAttributes = "";
		$this->b_01->HrefValue = "";
		$this->b_01->TooltipValue = "";

		// b_02
		$this->b_02->LinkCustomAttributes = "";
		$this->b_02->HrefValue = "";
		$this->b_02->TooltipValue = "";

		// b_03
		$this->b_03->LinkCustomAttributes = "";
		$this->b_03->HrefValue = "";
		$this->b_03->TooltipValue = "";

		// b_04
		$this->b_04->LinkCustomAttributes = "";
		$this->b_04->HrefValue = "";
		$this->b_04->TooltipValue = "";

		// b_05
		$this->b_05->LinkCustomAttributes = "";
		$this->b_05->HrefValue = "";
		$this->b_05->TooltipValue = "";

		// b_06
		$this->b_06->LinkCustomAttributes = "";
		$this->b_06->HrefValue = "";
		$this->b_06->TooltipValue = "";

		// b_07
		$this->b_07->LinkCustomAttributes = "";
		$this->b_07->HrefValue = "";
		$this->b_07->TooltipValue = "";

		// b_08
		$this->b_08->LinkCustomAttributes = "";
		$this->b_08->HrefValue = "";
		$this->b_08->TooltipValue = "";

		// b_09
		$this->b_09->LinkCustomAttributes = "";
		$this->b_09->HrefValue = "";
		$this->b_09->TooltipValue = "";

		// b_10
		$this->b_10->LinkCustomAttributes = "";
		$this->b_10->HrefValue = "";
		$this->b_10->TooltipValue = "";

		// b_11
		$this->b_11->LinkCustomAttributes = "";
		$this->b_11->HrefValue = "";
		$this->b_11->TooltipValue = "";

		// b_12
		$this->b_12->LinkCustomAttributes = "";
		$this->b_12->HrefValue = "";
		$this->b_12->TooltipValue = "";

		// b_13
		$this->b_13->LinkCustomAttributes = "";
		$this->b_13->HrefValue = "";
		$this->b_13->TooltipValue = "";

		// b_14
		$this->b_14->LinkCustomAttributes = "";
		$this->b_14->HrefValue = "";
		$this->b_14->TooltipValue = "";

		// b_15
		$this->b_15->LinkCustomAttributes = "";
		$this->b_15->HrefValue = "";
		$this->b_15->TooltipValue = "";

		// t_01
		$this->t_01->LinkCustomAttributes = "";
		$this->t_01->HrefValue = "";
		$this->t_01->TooltipValue = "";

		// t_02
		$this->t_02->LinkCustomAttributes = "";
		$this->t_02->HrefValue = "";
		$this->t_02->TooltipValue = "";

		// t_03
		$this->t_03->LinkCustomAttributes = "";
		$this->t_03->HrefValue = "";
		$this->t_03->TooltipValue = "";

		// t_04
		$this->t_04->LinkCustomAttributes = "";
		$this->t_04->HrefValue = "";
		$this->t_04->TooltipValue = "";

		// t_05
		$this->t_05->LinkCustomAttributes = "";
		$this->t_05->HrefValue = "";
		$this->t_05->TooltipValue = "";

		// t_06
		$this->t_06->LinkCustomAttributes = "";
		$this->t_06->HrefValue = "";
		$this->t_06->TooltipValue = "";

		// t_07
		$this->t_07->LinkCustomAttributes = "";
		$this->t_07->HrefValue = "";
		$this->t_07->TooltipValue = "";

		// t_08
		$this->t_08->LinkCustomAttributes = "";
		$this->t_08->HrefValue = "";
		$this->t_08->TooltipValue = "";

		// t_09
		$this->t_09->LinkCustomAttributes = "";
		$this->t_09->HrefValue = "";
		$this->t_09->TooltipValue = "";

		// t_10
		$this->t_10->LinkCustomAttributes = "";
		$this->t_10->HrefValue = "";
		$this->t_10->TooltipValue = "";

		// t_11
		$this->t_11->LinkCustomAttributes = "";
		$this->t_11->HrefValue = "";
		$this->t_11->TooltipValue = "";

		// t_12
		$this->t_12->LinkCustomAttributes = "";
		$this->t_12->HrefValue = "";
		$this->t_12->TooltipValue = "";

		// t_13
		$this->t_13->LinkCustomAttributes = "";
		$this->t_13->HrefValue = "";
		$this->t_13->TooltipValue = "";

		// t_14
		$this->t_14->LinkCustomAttributes = "";
		$this->t_14->HrefValue = "";
		$this->t_14->TooltipValue = "";

		// t_15
		$this->t_15->LinkCustomAttributes = "";
		$this->t_15->HrefValue = "";
		$this->t_15->TooltipValue = "";

		// d_head_01
		$this->d_head_01->LinkCustomAttributes = "";
		$this->d_head_01->HrefValue = "";
		$this->d_head_01->TooltipValue = "";

		// d_description_01
		$this->d_description_01->LinkCustomAttributes = "";
		$this->d_description_01->HrefValue = "";
		$this->d_description_01->TooltipValue = "";

		// d_head_02
		$this->d_head_02->LinkCustomAttributes = "";
		$this->d_head_02->HrefValue = "";
		$this->d_head_02->TooltipValue = "";

		// d_description_02
		$this->d_description_02->LinkCustomAttributes = "";
		$this->d_description_02->HrefValue = "";
		$this->d_description_02->TooltipValue = "";

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->HrefValue = "";
		$this->image->TooltipValue = "";

		// main_image
		$this->main_image->LinkCustomAttributes = "";
		$this->main_image->HrefValue = "";
		$this->main_image->TooltipValue = "";

		// top_view
		$this->top_view->LinkCustomAttributes = "";
		$this->top_view->HrefValue = "";
		$this->top_view->TooltipValue = "";

		// front_view
		$this->front_view->LinkCustomAttributes = "";
		$this->front_view->HrefValue = "";
		$this->front_view->TooltipValue = "";

		// corner_view
		$this->corner_view->LinkCustomAttributes = "";
		$this->corner_view->HrefValue = "";
		$this->corner_view->TooltipValue = "";

		// back_view
		$this->back_view->LinkCustomAttributes = "";
		$this->back_view->HrefValue = "";
		$this->back_view->TooltipValue = "";

		// color_options
		$this->color_options->LinkCustomAttributes = "";
		$this->color_options->HrefValue = "";
		$this->color_options->TooltipValue = "";

		// other_options
		$this->other_options->LinkCustomAttributes = "";
		$this->other_options->HrefValue = "";
		$this->other_options->TooltipValue = "";

		// last_price
		$this->last_price->LinkCustomAttributes = "";
		$this->last_price->HrefValue = "";
		$this->last_price->TooltipValue = "";

		// hsn
		$this->hsn->LinkCustomAttributes = "";
		$this->hsn->HrefValue = "";
		$this->hsn->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// product_n
		$this->product_n->EditAttrs["class"] = "form-control";
		$this->product_n->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
		$this->product_n->EditValue = $this->product_n->CurrentValue;
		$this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

		// ref_status
		$this->ref_status->EditAttrs["class"] = "form-control";
		$this->ref_status->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ref_status->CurrentValue = HtmlDecode($this->ref_status->CurrentValue);
		$this->ref_status->EditValue = $this->ref_status->CurrentValue;
		$this->ref_status->PlaceHolder = RemoveHtml($this->ref_status->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// oid
		$this->oid->EditAttrs["class"] = "form-control";
		$this->oid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->oid->CurrentValue = HtmlDecode($this->oid->CurrentValue);
		$this->oid->EditValue = $this->oid->CurrentValue;
		$this->oid->PlaceHolder = RemoveHtml($this->oid->caption());

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_type->CurrentValue = HtmlDecode($this->product_type->CurrentValue);
		$this->product_type->EditValue = $this->product_type->CurrentValue;
		$this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

		// gcode
		$this->gcode->EditAttrs["class"] = "form-control";
		$this->gcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->gcode->CurrentValue = HtmlDecode($this->gcode->CurrentValue);
		$this->gcode->EditValue = $this->gcode->CurrentValue;
		$this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->PlaceHolder = RemoveHtml($this->code->caption());

		// product_id
		$this->product_id->EditAttrs["class"] = "form-control";
		$this->product_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_id->CurrentValue = HtmlDecode($this->product_id->CurrentValue);
		$this->product_id->EditValue = $this->product_id->CurrentValue;
		$this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

		// print_name
		$this->print_name->EditAttrs["class"] = "form-control";
		$this->print_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->print_name->CurrentValue = HtmlDecode($this->print_name->CurrentValue);
		$this->print_name->EditValue = $this->print_name->CurrentValue;
		$this->print_name->PlaceHolder = RemoveHtml($this->print_name->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->batch_no->CurrentValue = HtmlDecode($this->batch_no->CurrentValue);
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// v_01
		$this->v_01->EditAttrs["class"] = "form-control";
		$this->v_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_01->CurrentValue = HtmlDecode($this->v_01->CurrentValue);
		$this->v_01->EditValue = $this->v_01->CurrentValue;
		$this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

		// v_02
		$this->v_02->EditAttrs["class"] = "form-control";
		$this->v_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_02->CurrentValue = HtmlDecode($this->v_02->CurrentValue);
		$this->v_02->EditValue = $this->v_02->CurrentValue;
		$this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

		// v_03
		$this->v_03->EditAttrs["class"] = "form-control";
		$this->v_03->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_03->CurrentValue = HtmlDecode($this->v_03->CurrentValue);
		$this->v_03->EditValue = $this->v_03->CurrentValue;
		$this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

		// v_04
		$this->v_04->EditAttrs["class"] = "form-control";
		$this->v_04->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_04->CurrentValue = HtmlDecode($this->v_04->CurrentValue);
		$this->v_04->EditValue = $this->v_04->CurrentValue;
		$this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

		// v_05
		$this->v_05->EditAttrs["class"] = "form-control";
		$this->v_05->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_05->CurrentValue = HtmlDecode($this->v_05->CurrentValue);
		$this->v_05->EditValue = $this->v_05->CurrentValue;
		$this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

		// v_06
		$this->v_06->EditAttrs["class"] = "form-control";
		$this->v_06->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_06->CurrentValue = HtmlDecode($this->v_06->CurrentValue);
		$this->v_06->EditValue = $this->v_06->CurrentValue;
		$this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

		// v_07
		$this->v_07->EditAttrs["class"] = "form-control";
		$this->v_07->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_07->CurrentValue = HtmlDecode($this->v_07->CurrentValue);
		$this->v_07->EditValue = $this->v_07->CurrentValue;
		$this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

		// v_08
		$this->v_08->EditAttrs["class"] = "form-control";
		$this->v_08->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_08->CurrentValue = HtmlDecode($this->v_08->CurrentValue);
		$this->v_08->EditValue = $this->v_08->CurrentValue;
		$this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

		// v_09
		$this->v_09->EditAttrs["class"] = "form-control";
		$this->v_09->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_09->CurrentValue = HtmlDecode($this->v_09->CurrentValue);
		$this->v_09->EditValue = $this->v_09->CurrentValue;
		$this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

		// v_10
		$this->v_10->EditAttrs["class"] = "form-control";
		$this->v_10->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->v_10->CurrentValue = HtmlDecode($this->v_10->CurrentValue);
		$this->v_10->EditValue = $this->v_10->CurrentValue;
		$this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

		// b_01
		$this->b_01->EditAttrs["class"] = "form-control";
		$this->b_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
		$this->b_01->EditValue = $this->b_01->CurrentValue;
		$this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

		// b_02
		$this->b_02->EditAttrs["class"] = "form-control";
		$this->b_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_02->CurrentValue = HtmlDecode($this->b_02->CurrentValue);
		$this->b_02->EditValue = $this->b_02->CurrentValue;
		$this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

		// b_03
		$this->b_03->EditAttrs["class"] = "form-control";
		$this->b_03->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_03->CurrentValue = HtmlDecode($this->b_03->CurrentValue);
		$this->b_03->EditValue = $this->b_03->CurrentValue;
		$this->b_03->PlaceHolder = RemoveHtml($this->b_03->caption());

		// b_04
		$this->b_04->EditAttrs["class"] = "form-control";
		$this->b_04->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_04->CurrentValue = HtmlDecode($this->b_04->CurrentValue);
		$this->b_04->EditValue = $this->b_04->CurrentValue;
		$this->b_04->PlaceHolder = RemoveHtml($this->b_04->caption());

		// b_05
		$this->b_05->EditAttrs["class"] = "form-control";
		$this->b_05->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_05->CurrentValue = HtmlDecode($this->b_05->CurrentValue);
		$this->b_05->EditValue = $this->b_05->CurrentValue;
		$this->b_05->PlaceHolder = RemoveHtml($this->b_05->caption());

		// b_06
		$this->b_06->EditAttrs["class"] = "form-control";
		$this->b_06->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_06->CurrentValue = HtmlDecode($this->b_06->CurrentValue);
		$this->b_06->EditValue = $this->b_06->CurrentValue;
		$this->b_06->PlaceHolder = RemoveHtml($this->b_06->caption());

		// b_07
		$this->b_07->EditAttrs["class"] = "form-control";
		$this->b_07->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_07->CurrentValue = HtmlDecode($this->b_07->CurrentValue);
		$this->b_07->EditValue = $this->b_07->CurrentValue;
		$this->b_07->PlaceHolder = RemoveHtml($this->b_07->caption());

		// b_08
		$this->b_08->EditAttrs["class"] = "form-control";
		$this->b_08->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_08->CurrentValue = HtmlDecode($this->b_08->CurrentValue);
		$this->b_08->EditValue = $this->b_08->CurrentValue;
		$this->b_08->PlaceHolder = RemoveHtml($this->b_08->caption());

		// b_09
		$this->b_09->EditAttrs["class"] = "form-control";
		$this->b_09->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_09->CurrentValue = HtmlDecode($this->b_09->CurrentValue);
		$this->b_09->EditValue = $this->b_09->CurrentValue;
		$this->b_09->PlaceHolder = RemoveHtml($this->b_09->caption());

		// b_10
		$this->b_10->EditAttrs["class"] = "form-control";
		$this->b_10->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_10->CurrentValue = HtmlDecode($this->b_10->CurrentValue);
		$this->b_10->EditValue = $this->b_10->CurrentValue;
		$this->b_10->PlaceHolder = RemoveHtml($this->b_10->caption());

		// b_11
		$this->b_11->EditAttrs["class"] = "form-control";
		$this->b_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_11->CurrentValue = HtmlDecode($this->b_11->CurrentValue);
		$this->b_11->EditValue = $this->b_11->CurrentValue;
		$this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

		// b_12
		$this->b_12->EditAttrs["class"] = "form-control";
		$this->b_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
		$this->b_12->EditValue = $this->b_12->CurrentValue;
		$this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

		// b_13
		$this->b_13->EditAttrs["class"] = "form-control";
		$this->b_13->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_13->CurrentValue = HtmlDecode($this->b_13->CurrentValue);
		$this->b_13->EditValue = $this->b_13->CurrentValue;
		$this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

		// b_14
		$this->b_14->EditAttrs["class"] = "form-control";
		$this->b_14->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_14->CurrentValue = HtmlDecode($this->b_14->CurrentValue);
		$this->b_14->EditValue = $this->b_14->CurrentValue;
		$this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

		// b_15
		$this->b_15->EditAttrs["class"] = "form-control";
		$this->b_15->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_15->CurrentValue = HtmlDecode($this->b_15->CurrentValue);
		$this->b_15->EditValue = $this->b_15->CurrentValue;
		$this->b_15->PlaceHolder = RemoveHtml($this->b_15->caption());

		// t_01
		$this->t_01->EditAttrs["class"] = "form-control";
		$this->t_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_01->CurrentValue = HtmlDecode($this->t_01->CurrentValue);
		$this->t_01->EditValue = $this->t_01->CurrentValue;
		$this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

		// t_02
		$this->t_02->EditAttrs["class"] = "form-control";
		$this->t_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_02->CurrentValue = HtmlDecode($this->t_02->CurrentValue);
		$this->t_02->EditValue = $this->t_02->CurrentValue;
		$this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

		// t_03
		$this->t_03->EditAttrs["class"] = "form-control";
		$this->t_03->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_03->CurrentValue = HtmlDecode($this->t_03->CurrentValue);
		$this->t_03->EditValue = $this->t_03->CurrentValue;
		$this->t_03->PlaceHolder = RemoveHtml($this->t_03->caption());

		// t_04
		$this->t_04->EditAttrs["class"] = "form-control";
		$this->t_04->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_04->CurrentValue = HtmlDecode($this->t_04->CurrentValue);
		$this->t_04->EditValue = $this->t_04->CurrentValue;
		$this->t_04->PlaceHolder = RemoveHtml($this->t_04->caption());

		// t_05
		$this->t_05->EditAttrs["class"] = "form-control";
		$this->t_05->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_05->CurrentValue = HtmlDecode($this->t_05->CurrentValue);
		$this->t_05->EditValue = $this->t_05->CurrentValue;
		$this->t_05->PlaceHolder = RemoveHtml($this->t_05->caption());

		// t_06
		$this->t_06->EditAttrs["class"] = "form-control";
		$this->t_06->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_06->CurrentValue = HtmlDecode($this->t_06->CurrentValue);
		$this->t_06->EditValue = $this->t_06->CurrentValue;
		$this->t_06->PlaceHolder = RemoveHtml($this->t_06->caption());

		// t_07
		$this->t_07->EditAttrs["class"] = "form-control";
		$this->t_07->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_07->CurrentValue = HtmlDecode($this->t_07->CurrentValue);
		$this->t_07->EditValue = $this->t_07->CurrentValue;
		$this->t_07->PlaceHolder = RemoveHtml($this->t_07->caption());

		// t_08
		$this->t_08->EditAttrs["class"] = "form-control";
		$this->t_08->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_08->CurrentValue = HtmlDecode($this->t_08->CurrentValue);
		$this->t_08->EditValue = $this->t_08->CurrentValue;
		$this->t_08->PlaceHolder = RemoveHtml($this->t_08->caption());

		// t_09
		$this->t_09->EditAttrs["class"] = "form-control";
		$this->t_09->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_09->CurrentValue = HtmlDecode($this->t_09->CurrentValue);
		$this->t_09->EditValue = $this->t_09->CurrentValue;
		$this->t_09->PlaceHolder = RemoveHtml($this->t_09->caption());

		// t_10
		$this->t_10->EditAttrs["class"] = "form-control";
		$this->t_10->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_10->CurrentValue = HtmlDecode($this->t_10->CurrentValue);
		$this->t_10->EditValue = $this->t_10->CurrentValue;
		$this->t_10->PlaceHolder = RemoveHtml($this->t_10->caption());

		// t_11
		$this->t_11->EditAttrs["class"] = "form-control";
		$this->t_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_11->CurrentValue = HtmlDecode($this->t_11->CurrentValue);
		$this->t_11->EditValue = $this->t_11->CurrentValue;
		$this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

		// t_12
		$this->t_12->EditAttrs["class"] = "form-control";
		$this->t_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_12->CurrentValue = HtmlDecode($this->t_12->CurrentValue);
		$this->t_12->EditValue = $this->t_12->CurrentValue;
		$this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

		// t_13
		$this->t_13->EditAttrs["class"] = "form-control";
		$this->t_13->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_13->CurrentValue = HtmlDecode($this->t_13->CurrentValue);
		$this->t_13->EditValue = $this->t_13->CurrentValue;
		$this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

		// t_14
		$this->t_14->EditAttrs["class"] = "form-control";
		$this->t_14->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_14->CurrentValue = HtmlDecode($this->t_14->CurrentValue);
		$this->t_14->EditValue = $this->t_14->CurrentValue;
		$this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

		// t_15
		$this->t_15->EditAttrs["class"] = "form-control";
		$this->t_15->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_15->CurrentValue = HtmlDecode($this->t_15->CurrentValue);
		$this->t_15->EditValue = $this->t_15->CurrentValue;
		$this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

		// d_head_01
		$this->d_head_01->EditAttrs["class"] = "form-control";
		$this->d_head_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_head_01->CurrentValue = HtmlDecode($this->d_head_01->CurrentValue);
		$this->d_head_01->EditValue = $this->d_head_01->CurrentValue;
		$this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

		// d_description_01
		$this->d_description_01->EditAttrs["class"] = "form-control";
		$this->d_description_01->EditCustomAttributes = "";
		$this->d_description_01->EditValue = $this->d_description_01->CurrentValue;
		$this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

		// d_head_02
		$this->d_head_02->EditAttrs["class"] = "form-control";
		$this->d_head_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_head_02->CurrentValue = HtmlDecode($this->d_head_02->CurrentValue);
		$this->d_head_02->EditValue = $this->d_head_02->CurrentValue;
		$this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

		// d_description_02
		$this->d_description_02->EditAttrs["class"] = "form-control";
		$this->d_description_02->EditCustomAttributes = "";
		$this->d_description_02->EditValue = $this->d_description_02->CurrentValue;
		$this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->image->CurrentValue = HtmlDecode($this->image->CurrentValue);
		$this->image->EditValue = $this->image->CurrentValue;
		$this->image->PlaceHolder = RemoveHtml($this->image->caption());

		// main_image
		$this->main_image->EditAttrs["class"] = "form-control";
		$this->main_image->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->main_image->CurrentValue = HtmlDecode($this->main_image->CurrentValue);
		$this->main_image->EditValue = $this->main_image->CurrentValue;
		$this->main_image->PlaceHolder = RemoveHtml($this->main_image->caption());

		// top_view
		$this->top_view->EditAttrs["class"] = "form-control";
		$this->top_view->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->top_view->CurrentValue = HtmlDecode($this->top_view->CurrentValue);
		$this->top_view->EditValue = $this->top_view->CurrentValue;
		$this->top_view->PlaceHolder = RemoveHtml($this->top_view->caption());

		// front_view
		$this->front_view->EditAttrs["class"] = "form-control";
		$this->front_view->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->front_view->CurrentValue = HtmlDecode($this->front_view->CurrentValue);
		$this->front_view->EditValue = $this->front_view->CurrentValue;
		$this->front_view->PlaceHolder = RemoveHtml($this->front_view->caption());

		// corner_view
		$this->corner_view->EditAttrs["class"] = "form-control";
		$this->corner_view->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->corner_view->CurrentValue = HtmlDecode($this->corner_view->CurrentValue);
		$this->corner_view->EditValue = $this->corner_view->CurrentValue;
		$this->corner_view->PlaceHolder = RemoveHtml($this->corner_view->caption());

		// back_view
		$this->back_view->EditAttrs["class"] = "form-control";
		$this->back_view->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->back_view->CurrentValue = HtmlDecode($this->back_view->CurrentValue);
		$this->back_view->EditValue = $this->back_view->CurrentValue;
		$this->back_view->PlaceHolder = RemoveHtml($this->back_view->caption());

		// color_options
		$this->color_options->EditAttrs["class"] = "form-control";
		$this->color_options->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->color_options->CurrentValue = HtmlDecode($this->color_options->CurrentValue);
		$this->color_options->EditValue = $this->color_options->CurrentValue;
		$this->color_options->PlaceHolder = RemoveHtml($this->color_options->caption());

		// other_options
		$this->other_options->EditAttrs["class"] = "form-control";
		$this->other_options->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->other_options->CurrentValue = HtmlDecode($this->other_options->CurrentValue);
		$this->other_options->EditValue = $this->other_options->CurrentValue;
		$this->other_options->PlaceHolder = RemoveHtml($this->other_options->caption());

		// last_price
		$this->last_price->EditAttrs["class"] = "form-control";
		$this->last_price->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->last_price->CurrentValue = HtmlDecode($this->last_price->CurrentValue);
		$this->last_price->EditValue = $this->last_price->CurrentValue;
		$this->last_price->PlaceHolder = RemoveHtml($this->last_price->caption());

		// hsn
		$this->hsn->EditAttrs["class"] = "form-control";
		$this->hsn->EditCustomAttributes = "";
		$this->hsn->EditValue = $this->hsn->CurrentValue;
		$this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// operator
		$this->operator->EditAttrs["class"] = "form-control";
		$this->operator->EditCustomAttributes = "";
		$this->operator->EditValue = $this->operator->CurrentValue;
		$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

		// datetime
		$this->datetime->EditAttrs["class"] = "form-control";
		$this->datetime->EditCustomAttributes = "";
		$this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, 8);
		$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";
		$this->currency->EditValue = $this->currency->CurrentValue;
		$this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_n);
					$doc->exportCaption($this->ref_status);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->v_10);
					$doc->exportCaption($this->b_01);
					$doc->exportCaption($this->b_02);
					$doc->exportCaption($this->b_03);
					$doc->exportCaption($this->b_04);
					$doc->exportCaption($this->b_05);
					$doc->exportCaption($this->b_06);
					$doc->exportCaption($this->b_07);
					$doc->exportCaption($this->b_08);
					$doc->exportCaption($this->b_09);
					$doc->exportCaption($this->b_10);
					$doc->exportCaption($this->b_11);
					$doc->exportCaption($this->b_12);
					$doc->exportCaption($this->b_13);
					$doc->exportCaption($this->b_14);
					$doc->exportCaption($this->b_15);
					$doc->exportCaption($this->t_01);
					$doc->exportCaption($this->t_02);
					$doc->exportCaption($this->t_03);
					$doc->exportCaption($this->t_04);
					$doc->exportCaption($this->t_05);
					$doc->exportCaption($this->t_06);
					$doc->exportCaption($this->t_07);
					$doc->exportCaption($this->t_08);
					$doc->exportCaption($this->t_09);
					$doc->exportCaption($this->t_10);
					$doc->exportCaption($this->t_11);
					$doc->exportCaption($this->t_12);
					$doc->exportCaption($this->t_13);
					$doc->exportCaption($this->t_14);
					$doc->exportCaption($this->t_15);
					$doc->exportCaption($this->d_head_01);
					$doc->exportCaption($this->d_description_01);
					$doc->exportCaption($this->d_head_02);
					$doc->exportCaption($this->d_description_02);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->top_view);
					$doc->exportCaption($this->front_view);
					$doc->exportCaption($this->corner_view);
					$doc->exportCaption($this->back_view);
					$doc->exportCaption($this->color_options);
					$doc->exportCaption($this->other_options);
					$doc->exportCaption($this->last_price);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->currency);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_n);
					$doc->exportCaption($this->ref_status);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->v_10);
					$doc->exportCaption($this->b_01);
					$doc->exportCaption($this->b_02);
					$doc->exportCaption($this->b_03);
					$doc->exportCaption($this->b_04);
					$doc->exportCaption($this->b_05);
					$doc->exportCaption($this->b_06);
					$doc->exportCaption($this->b_07);
					$doc->exportCaption($this->b_08);
					$doc->exportCaption($this->b_09);
					$doc->exportCaption($this->b_10);
					$doc->exportCaption($this->b_11);
					$doc->exportCaption($this->b_12);
					$doc->exportCaption($this->b_13);
					$doc->exportCaption($this->b_14);
					$doc->exportCaption($this->b_15);
					$doc->exportCaption($this->t_01);
					$doc->exportCaption($this->t_02);
					$doc->exportCaption($this->t_03);
					$doc->exportCaption($this->t_04);
					$doc->exportCaption($this->t_05);
					$doc->exportCaption($this->t_06);
					$doc->exportCaption($this->t_07);
					$doc->exportCaption($this->t_08);
					$doc->exportCaption($this->t_09);
					$doc->exportCaption($this->t_10);
					$doc->exportCaption($this->t_11);
					$doc->exportCaption($this->t_12);
					$doc->exportCaption($this->t_13);
					$doc->exportCaption($this->t_14);
					$doc->exportCaption($this->t_15);
					$doc->exportCaption($this->d_head_01);
					$doc->exportCaption($this->d_head_02);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->top_view);
					$doc->exportCaption($this->front_view);
					$doc->exportCaption($this->corner_view);
					$doc->exportCaption($this->back_view);
					$doc->exportCaption($this->color_options);
					$doc->exportCaption($this->other_options);
					$doc->exportCaption($this->last_price);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->currency);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->product);
						$doc->exportField($this->product_n);
						$doc->exportField($this->ref_status);
						$doc->exportField($this->product_code);
						$doc->exportField($this->v_10);
						$doc->exportField($this->b_01);
						$doc->exportField($this->b_02);
						$doc->exportField($this->b_03);
						$doc->exportField($this->b_04);
						$doc->exportField($this->b_05);
						$doc->exportField($this->b_06);
						$doc->exportField($this->b_07);
						$doc->exportField($this->b_08);
						$doc->exportField($this->b_09);
						$doc->exportField($this->b_10);
						$doc->exportField($this->b_11);
						$doc->exportField($this->b_12);
						$doc->exportField($this->b_13);
						$doc->exportField($this->b_14);
						$doc->exportField($this->b_15);
						$doc->exportField($this->t_01);
						$doc->exportField($this->t_02);
						$doc->exportField($this->t_03);
						$doc->exportField($this->t_04);
						$doc->exportField($this->t_05);
						$doc->exportField($this->t_06);
						$doc->exportField($this->t_07);
						$doc->exportField($this->t_08);
						$doc->exportField($this->t_09);
						$doc->exportField($this->t_10);
						$doc->exportField($this->t_11);
						$doc->exportField($this->t_12);
						$doc->exportField($this->t_13);
						$doc->exportField($this->t_14);
						$doc->exportField($this->t_15);
						$doc->exportField($this->d_head_01);
						$doc->exportField($this->d_description_01);
						$doc->exportField($this->d_head_02);
						$doc->exportField($this->d_description_02);
						$doc->exportField($this->image);
						$doc->exportField($this->main_image);
						$doc->exportField($this->top_view);
						$doc->exportField($this->front_view);
						$doc->exportField($this->corner_view);
						$doc->exportField($this->back_view);
						$doc->exportField($this->color_options);
						$doc->exportField($this->other_options);
						$doc->exportField($this->last_price);
						$doc->exportField($this->hsn);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->currency);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->product);
						$doc->exportField($this->product_n);
						$doc->exportField($this->ref_status);
						$doc->exportField($this->product_code);
						$doc->exportField($this->v_10);
						$doc->exportField($this->b_01);
						$doc->exportField($this->b_02);
						$doc->exportField($this->b_03);
						$doc->exportField($this->b_04);
						$doc->exportField($this->b_05);
						$doc->exportField($this->b_06);
						$doc->exportField($this->b_07);
						$doc->exportField($this->b_08);
						$doc->exportField($this->b_09);
						$doc->exportField($this->b_10);
						$doc->exportField($this->b_11);
						$doc->exportField($this->b_12);
						$doc->exportField($this->b_13);
						$doc->exportField($this->b_14);
						$doc->exportField($this->b_15);
						$doc->exportField($this->t_01);
						$doc->exportField($this->t_02);
						$doc->exportField($this->t_03);
						$doc->exportField($this->t_04);
						$doc->exportField($this->t_05);
						$doc->exportField($this->t_06);
						$doc->exportField($this->t_07);
						$doc->exportField($this->t_08);
						$doc->exportField($this->t_09);
						$doc->exportField($this->t_10);
						$doc->exportField($this->t_11);
						$doc->exportField($this->t_12);
						$doc->exportField($this->t_13);
						$doc->exportField($this->t_14);
						$doc->exportField($this->t_15);
						$doc->exportField($this->d_head_01);
						$doc->exportField($this->d_head_02);
						$doc->exportField($this->image);
						$doc->exportField($this->main_image);
						$doc->exportField($this->top_view);
						$doc->exportField($this->front_view);
						$doc->exportField($this->corner_view);
						$doc->exportField($this->back_view);
						$doc->exportField($this->color_options);
						$doc->exportField($this->other_options);
						$doc->exportField($this->last_price);
						$doc->exportField($this->hsn);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->currency);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>