<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class _ref_view_grid extends _ref_view
{

	// Page ID
	public $PageID = "grid";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ref_view';

	// Page object name
	public $PageObjName = "_ref_view_grid";

	// Grid form hidden field names
	public $FormName = "f_ref_viewgrid";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$this->FormActionName .= "_" . $this->FormName;
		$this->FormKeyName .= "_" . $this->FormName;
		$this->FormOldKeyName .= "_" . $this->FormName;
		$this->FormBlankRowName .= "_" . $this->FormName;
		$this->FormKeyCountName .= "_" . $this->FormName;
		$GLOBALS["Grid"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (_ref_view)
		if (!isset($GLOBALS["_ref_view"]) || get_class($GLOBALS["_ref_view"]) == PROJECT_NAMESPACE . "_ref_view") {
			$GLOBALS["_ref_view"] = &$this;

			// $GLOBALS["MasterTable"] = &$GLOBALS["Table"];
			// if (!isset($GLOBALS["Table"]))
			// 	$GLOBALS["Table"] = &$GLOBALS["_ref_view"];

		}
		$this->AddUrl = "_ref_viewadd.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'grid');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_view');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Export
		global $EXPORT, $_ref_view;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($_ref_view);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}

//		$GLOBALS["Table"] = &$GLOBALS["MasterTable"];
		unset($GLOBALS["Grid"]);
		if ($url === "")
			return;
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $ShowOtherOptions = FALSE;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->id->setVisibility();
		$this->product->setVisibility();
		$this->product_n->setVisibility();
		$this->ref_status->setVisibility();
		$this->product_code->setVisibility();
		$this->url->Visible = FALSE;
		$this->oid->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->product_type->setVisibility();
		$this->gcode->Visible = FALSE;
		$this->code->Visible = FALSE;
		$this->product_id->Visible = FALSE;
		$this->print_name->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->v_01->Visible = FALSE;
		$this->v_02->Visible = FALSE;
		$this->v_03->Visible = FALSE;
		$this->v_04->Visible = FALSE;
		$this->v_05->Visible = FALSE;
		$this->v_06->Visible = FALSE;
		$this->v_07->Visible = FALSE;
		$this->v_08->Visible = FALSE;
		$this->v_09->Visible = FALSE;
		$this->v_10->Visible = FALSE;
		$this->b_01->Visible = FALSE;
		$this->b_02->Visible = FALSE;
		$this->b_03->Visible = FALSE;
		$this->b_04->Visible = FALSE;
		$this->b_05->Visible = FALSE;
		$this->b_06->Visible = FALSE;
		$this->b_07->Visible = FALSE;
		$this->b_08->Visible = FALSE;
		$this->b_09->Visible = FALSE;
		$this->b_10->Visible = FALSE;
		$this->b_11->Visible = FALSE;
		$this->b_12->Visible = FALSE;
		$this->b_13->Visible = FALSE;
		$this->b_14->Visible = FALSE;
		$this->b_15->Visible = FALSE;
		$this->t_01->Visible = FALSE;
		$this->t_02->Visible = FALSE;
		$this->t_03->Visible = FALSE;
		$this->t_04->Visible = FALSE;
		$this->t_05->Visible = FALSE;
		$this->t_06->Visible = FALSE;
		$this->t_07->Visible = FALSE;
		$this->t_08->Visible = FALSE;
		$this->t_09->Visible = FALSE;
		$this->t_10->Visible = FALSE;
		$this->t_11->Visible = FALSE;
		$this->t_12->Visible = FALSE;
		$this->t_13->Visible = FALSE;
		$this->t_14->Visible = FALSE;
		$this->t_15->Visible = FALSE;
		$this->d_head_01->Visible = FALSE;
		$this->d_description_01->Visible = FALSE;
		$this->d_head_02->Visible = FALSE;
		$this->d_description_02->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->main_image->Visible = FALSE;
		$this->top_view->Visible = FALSE;
		$this->front_view->Visible = FALSE;
		$this->corner_view->Visible = FALSE;
		$this->back_view->Visible = FALSE;
		$this->color_options->Visible = FALSE;
		$this->other_options->Visible = FALSE;
		$this->last_price->Visible = FALSE;
		$this->hsn->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->currency->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up master detail parameters
		$this->setupMasterParms();

		// Setup other options
		$this->setupOtherOptions();

		// Set up lookup cache
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->currency);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Show grid delete link for grid add / grid edit
			if ($this->AllowAddDeleteRow) {
				if ($this->isGridAdd() || $this->isGridEdit()) {
					$item = &$this->ListOptions->getItem("griddelete");
					if ($item)
						$item->Visible = TRUE;
				}
			}

			// Set up sorting order
			$this->setupSortOrder();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records

		// Restore master/detail filter
		$this->DbMasterFilter = $this->getMasterFilter(); // Restore master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Restore detail filter
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Load master record
		if ($this->CurrentMode <> "add" && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "ref_multi") {
			global $ref_multi;
			$rsmaster = $ref_multi->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("ref_multilist.php"); // Return to master page
			} else {
				$ref_multi->loadListRowValues($rsmaster);
				$ref_multi->RowType = ROWTYPE_MASTER; // Master row
				$ref_multi->renderListRow();
				$rsmaster->close();
			}
		}

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			if ($this->CurrentMode == "copy") {
				$selectLimit = $this->UseSelectLimit;
				if ($selectLimit) {
					$this->TotalRecs = $this->listRecordCount();
					$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);
				} else {
					if ($this->Recordset = $this->loadRecordset())
						$this->TotalRecs = $this->Recordset->RecordCount();
				}
				$this->StartRec = 1;
				$this->DisplayRecs = $this->TotalRecs;
			} else {
				$this->CurrentFilter = "0=1";
				$this->StartRec = 1;
				$this->DisplayRecs = $this->GridAddRowCount;
			}
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			$this->DisplayRecs = $this->TotalRecs; // Display all records
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Grid Add mode
	protected function gridAddMode()
	{
		$this->CurrentAction = "gridadd";
		$_SESSION[SESSION_INLINE_MODE] = "gridadd";
		$this->hideFieldsForAddEdit();
	}

	// Switch to Grid Edit mode
	protected function gridEditMode()
	{
		$this->CurrentAction = "gridedit";
		$_SESSION[SESSION_INLINE_MODE] = "gridedit";
		$this->hideFieldsForAddEdit();
	}

	// Perform update to grid
	public function gridUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$gridUpdate = TRUE;

		// Get old recordset
		$this->CurrentFilter = $this->buildKeyFilter();
		if ($this->CurrentFilter == "")
			$this->CurrentFilter = "0=1";
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sql)) {
			$rsold = $rs->getRows();
			$rs->close();
		}

		// Call Grid Updating event
		if (!$this->Grid_Updating($rsold)) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
			return FALSE;
		}
		$key = "";

		// Update row index and get row key
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Update all rows based on key
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
			$CurrentForm->Index = $rowindex;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));

			// Load all values and keys
			if ($rowaction <> "insertdelete") { // Skip insert then deleted rows
				$this->loadFormValues(); // Get form values
				if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
					$gridUpdate = $this->setupKeyValues($rowkey); // Set up key values
				} else {
					$gridUpdate = TRUE;
				}

				// Skip empty row
				if ($rowaction == "insert" && $this->emptyRow()) {

					// No action required
				// Validate form and insert/update/delete record

				} elseif ($gridUpdate) {
					if ($rowaction == "delete") {
						$this->CurrentFilter = $this->getRecordFilter();
						$gridUpdate = $this->deleteRows(); // Delete this row
					} else if (!$this->validateForm()) {
						$gridUpdate = FALSE; // Form error, reset action
						$this->setFailureMessage($FormError);
					} else {
						if ($rowaction == "insert") {
							$gridUpdate = $this->addRow(); // Insert this row
						} else {
							if ($rowkey <> "") {
								$this->SendEmail = FALSE; // Do not send email on update success
								$gridUpdate = $this->editRow(); // Update this row
							}
						} // End update
					}
				}
				if ($gridUpdate) {
					if ($key <> "")
						$key .= ", ";
					$key .= $rowkey;
				} else {
					break;
				}
			}
		}
		if ($gridUpdate) {

			// Get new recordset
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Updated event
			$this->Grid_Updated($rsold, $rsnew);
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
		}
		return $gridUpdate;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Perform Grid Add
	public function gridInsert()
	{
		global $Language, $CurrentForm, $FormError;
		$rowindex = 1;
		$gridInsert = FALSE;
		$conn = &$this->getConnection();

		// Call Grid Inserting event
		if (!$this->Grid_Inserting()) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
			return FALSE;
		}

		// Init key filter
		$wrkfilter = "";
		$addcnt = 0;
		$key = "";

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Insert all rows
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "" && $rowaction <> "insert")
				continue; // Skip
			if ($rowaction == "insert") {
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
				$this->loadOldRecord(); // Load old record
			}
			$this->loadFormValues(); // Get form values
			if (!$this->emptyRow()) {
				$addcnt++;
				$this->SendEmail = FALSE; // Do not send email on insert success

				// Validate form
				if (!$this->validateForm()) {
					$gridInsert = FALSE; // Form error, reset action
					$this->setFailureMessage($FormError);
				} else {
					$gridInsert = $this->addRow($this->OldRecordset); // Insert this row
				}
				if ($gridInsert) {
					if ($key <> "")
						$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
					$key .= $this->id->CurrentValue;

					// Add filter for this record
					$filter = $this->getRecordFilter();
					if ($wrkfilter <> "")
						$wrkfilter .= " OR ";
					$wrkfilter .= $filter;
				} else {
					break;
				}
			}
		}
		if ($addcnt == 0) { // No record inserted
			$this->clearInlineMode(); // Clear grid add mode and return
			return TRUE;
		}
		if ($gridInsert) {

			// Get new recordset
			$this->CurrentFilter = $wrkfilter;
			$sql = $this->getCurrentSql();
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Inserted event
			$this->Grid_Inserted($rsnew);
			$this->clearInlineMode(); // Clear grid add mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
		}
		return $gridInsert;
	}

	// Check if empty row
	public function emptyRow()
	{
		global $CurrentForm;
		if ($CurrentForm->hasValue("x_product") && $CurrentForm->hasValue("o_product") && $this->product->CurrentValue <> $this->product->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_product_n") && $CurrentForm->hasValue("o_product_n") && $this->product_n->CurrentValue <> $this->product_n->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_ref_status") && $CurrentForm->hasValue("o_ref_status") && $this->ref_status->CurrentValue <> $this->ref_status->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_product_code") && $CurrentForm->hasValue("o_product_code") && $this->product_code->CurrentValue <> $this->product_code->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_company_id") && $CurrentForm->hasValue("o_company_id") && $this->company_id->CurrentValue <> $this->company_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_product_type") && $CurrentForm->hasValue("o_product_type") && $this->product_type->CurrentValue <> $this->product_type->OldValue)
			return FALSE;
		return TRUE;
	}

	// Validate grid form
	public function validateGridForm()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Validate all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else if (!$this->validateForm()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	// Get all form values of the grid
	public function getGridFormValues()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;
		$rows = array();

		// Loop through all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else {
					$rows[] = $this->getFieldValues("FormValue"); // Return row as array
				}
			}
		}
		return $rows; // Return as array of array
	}

	// Restore form values for current row
	public function restoreCurrentRowFormValues($idx)
	{
		global $CurrentForm;

		// Get row based on current index
		$CurrentForm->Index = $idx;
		$this->loadFormValues(); // Load form values
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset master/detail keys
			if ($this->Command == "resetall") {
				$this->setCurrentMasterTable(""); // Clear master table
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
				$this->id->setSessionValue("");
			}

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// "griddelete"
		if ($this->AllowAddDeleteRow) {
			$item = &$this->ListOptions->add("griddelete");
			$item->CssClass = "text-nowrap";
			$item->OnLeft = TRUE;
			$item->Visible = FALSE; // Default hidden
		}

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode <> "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($CurrentForm->hasValue($this->FormOldKeyName))
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
			if ($this->RowOldKey <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($this->RowOldKey) . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "delete"
		if ($this->AllowAddDeleteRow) {
			if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
				$options = &$this->ListOptions;
				$options->UseButtonGroup = TRUE; // Use button group for grid delete button
				$opt = &$options->Items["griddelete"];
				if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
					$opt->Body = "&nbsp;";
				} else {
					$opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
				}
			}
		}
		if ($this->CurrentMode == "view") { // View mode
		} // End View mode
		if ($this->CurrentMode == "edit" && is_numeric($this->RowIndex)) {
			$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . $this->id->CurrentValue . "\">";
		}
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set record key
	public function setRecordKey(&$key, $rs)
	{
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs->fields('id');
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$option = &$this->OtherOptions["addedit"];
		$option->UseDropDownButton = FALSE;
		$option->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$option->UseButtonGroup = TRUE;

		//$option->ButtonClass = ""; // Class for button group
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		if (($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") && !$this->isConfirm()) { // Check add/copy/edit mode
			if ($this->AllowAddDeleteRow) {
				$option = &$options["addedit"];
				$option->UseDropDownButton = FALSE;
				$item = &$option->add("addblankrow");
				$item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"javascript:void(0);\" onclick=\"ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
				$item->Visible = FALSE;
				$this->ShowOtherOptions = $item->Visible;
			}
		}
		if ($this->CurrentMode == "view") { // Check view mode
			$option = &$options["addedit"];
			$item = &$option->getItem("add");
			$this->ShowOtherOptions = $item && $item->Visible;
		}
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->product_n->CurrentValue = NULL;
		$this->product_n->OldValue = $this->product_n->CurrentValue;
		$this->ref_status->CurrentValue = NULL;
		$this->ref_status->OldValue = $this->ref_status->CurrentValue;
		$this->product_code->CurrentValue = NULL;
		$this->product_code->OldValue = $this->product_code->CurrentValue;
		$this->url->CurrentValue = NULL;
		$this->url->OldValue = $this->url->CurrentValue;
		$this->oid->CurrentValue = NULL;
		$this->oid->OldValue = $this->oid->CurrentValue;
		$this->company_id->CurrentValue = NULL;
		$this->company_id->OldValue = $this->company_id->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product_type->CurrentValue = NULL;
		$this->product_type->OldValue = $this->product_type->CurrentValue;
		$this->gcode->CurrentValue = NULL;
		$this->gcode->OldValue = $this->gcode->CurrentValue;
		$this->code->CurrentValue = NULL;
		$this->code->OldValue = $this->code->CurrentValue;
		$this->product_id->CurrentValue = NULL;
		$this->product_id->OldValue = $this->product_id->CurrentValue;
		$this->print_name->CurrentValue = NULL;
		$this->print_name->OldValue = $this->print_name->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->v_01->CurrentValue = NULL;
		$this->v_01->OldValue = $this->v_01->CurrentValue;
		$this->v_02->CurrentValue = NULL;
		$this->v_02->OldValue = $this->v_02->CurrentValue;
		$this->v_03->CurrentValue = NULL;
		$this->v_03->OldValue = $this->v_03->CurrentValue;
		$this->v_04->CurrentValue = NULL;
		$this->v_04->OldValue = $this->v_04->CurrentValue;
		$this->v_05->CurrentValue = NULL;
		$this->v_05->OldValue = $this->v_05->CurrentValue;
		$this->v_06->CurrentValue = NULL;
		$this->v_06->OldValue = $this->v_06->CurrentValue;
		$this->v_07->CurrentValue = NULL;
		$this->v_07->OldValue = $this->v_07->CurrentValue;
		$this->v_08->CurrentValue = NULL;
		$this->v_08->OldValue = $this->v_08->CurrentValue;
		$this->v_09->CurrentValue = NULL;
		$this->v_09->OldValue = $this->v_09->CurrentValue;
		$this->v_10->CurrentValue = NULL;
		$this->v_10->OldValue = $this->v_10->CurrentValue;
		$this->b_01->CurrentValue = NULL;
		$this->b_01->OldValue = $this->b_01->CurrentValue;
		$this->b_02->CurrentValue = NULL;
		$this->b_02->OldValue = $this->b_02->CurrentValue;
		$this->b_03->CurrentValue = NULL;
		$this->b_03->OldValue = $this->b_03->CurrentValue;
		$this->b_04->CurrentValue = NULL;
		$this->b_04->OldValue = $this->b_04->CurrentValue;
		$this->b_05->CurrentValue = NULL;
		$this->b_05->OldValue = $this->b_05->CurrentValue;
		$this->b_06->CurrentValue = NULL;
		$this->b_06->OldValue = $this->b_06->CurrentValue;
		$this->b_07->CurrentValue = NULL;
		$this->b_07->OldValue = $this->b_07->CurrentValue;
		$this->b_08->CurrentValue = NULL;
		$this->b_08->OldValue = $this->b_08->CurrentValue;
		$this->b_09->CurrentValue = NULL;
		$this->b_09->OldValue = $this->b_09->CurrentValue;
		$this->b_10->CurrentValue = NULL;
		$this->b_10->OldValue = $this->b_10->CurrentValue;
		$this->b_11->CurrentValue = NULL;
		$this->b_11->OldValue = $this->b_11->CurrentValue;
		$this->b_12->CurrentValue = NULL;
		$this->b_12->OldValue = $this->b_12->CurrentValue;
		$this->b_13->CurrentValue = NULL;
		$this->b_13->OldValue = $this->b_13->CurrentValue;
		$this->b_14->CurrentValue = NULL;
		$this->b_14->OldValue = $this->b_14->CurrentValue;
		$this->b_15->CurrentValue = NULL;
		$this->b_15->OldValue = $this->b_15->CurrentValue;
		$this->t_01->CurrentValue = NULL;
		$this->t_01->OldValue = $this->t_01->CurrentValue;
		$this->t_02->CurrentValue = NULL;
		$this->t_02->OldValue = $this->t_02->CurrentValue;
		$this->t_03->CurrentValue = NULL;
		$this->t_03->OldValue = $this->t_03->CurrentValue;
		$this->t_04->CurrentValue = NULL;
		$this->t_04->OldValue = $this->t_04->CurrentValue;
		$this->t_05->CurrentValue = NULL;
		$this->t_05->OldValue = $this->t_05->CurrentValue;
		$this->t_06->CurrentValue = NULL;
		$this->t_06->OldValue = $this->t_06->CurrentValue;
		$this->t_07->CurrentValue = NULL;
		$this->t_07->OldValue = $this->t_07->CurrentValue;
		$this->t_08->CurrentValue = NULL;
		$this->t_08->OldValue = $this->t_08->CurrentValue;
		$this->t_09->CurrentValue = NULL;
		$this->t_09->OldValue = $this->t_09->CurrentValue;
		$this->t_10->CurrentValue = NULL;
		$this->t_10->OldValue = $this->t_10->CurrentValue;
		$this->t_11->CurrentValue = NULL;
		$this->t_11->OldValue = $this->t_11->CurrentValue;
		$this->t_12->CurrentValue = NULL;
		$this->t_12->OldValue = $this->t_12->CurrentValue;
		$this->t_13->CurrentValue = NULL;
		$this->t_13->OldValue = $this->t_13->CurrentValue;
		$this->t_14->CurrentValue = NULL;
		$this->t_14->OldValue = $this->t_14->CurrentValue;
		$this->t_15->CurrentValue = NULL;
		$this->t_15->OldValue = $this->t_15->CurrentValue;
		$this->d_head_01->CurrentValue = NULL;
		$this->d_head_01->OldValue = $this->d_head_01->CurrentValue;
		$this->d_description_01->CurrentValue = NULL;
		$this->d_description_01->OldValue = $this->d_description_01->CurrentValue;
		$this->d_head_02->CurrentValue = NULL;
		$this->d_head_02->OldValue = $this->d_head_02->CurrentValue;
		$this->d_description_02->CurrentValue = NULL;
		$this->d_description_02->OldValue = $this->d_description_02->CurrentValue;
		$this->image->CurrentValue = NULL;
		$this->image->OldValue = $this->image->CurrentValue;
		$this->main_image->CurrentValue = NULL;
		$this->main_image->OldValue = $this->main_image->CurrentValue;
		$this->top_view->CurrentValue = NULL;
		$this->top_view->OldValue = $this->top_view->CurrentValue;
		$this->front_view->CurrentValue = NULL;
		$this->front_view->OldValue = $this->front_view->CurrentValue;
		$this->corner_view->CurrentValue = NULL;
		$this->corner_view->OldValue = $this->corner_view->CurrentValue;
		$this->back_view->CurrentValue = NULL;
		$this->back_view->OldValue = $this->back_view->CurrentValue;
		$this->color_options->CurrentValue = NULL;
		$this->color_options->OldValue = $this->color_options->CurrentValue;
		$this->other_options->CurrentValue = NULL;
		$this->other_options->OldValue = $this->other_options->CurrentValue;
		$this->last_price->CurrentValue = NULL;
		$this->last_price->OldValue = $this->last_price->CurrentValue;
		$this->hsn->CurrentValue = NULL;
		$this->hsn->OldValue = $this->hsn->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->currency->CurrentValue = NULL;
		$this->currency->OldValue = $this->currency->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$CurrentForm->FormName = $this->FormName;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd())
			$this->id->setFormValue($val);

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}
		$this->product->setOldValue($CurrentForm->getValue("o_product"));

		// Check field name 'product_n' first before field var 'x_product_n'
		$val = $CurrentForm->hasValue("product_n") ? $CurrentForm->getValue("product_n") : $CurrentForm->getValue("x_product_n");
		if (!$this->product_n->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_n->Visible = FALSE; // Disable update for API request
			else
				$this->product_n->setFormValue($val);
		}
		$this->product_n->setOldValue($CurrentForm->getValue("o_product_n"));

		// Check field name 'ref_status' first before field var 'x_ref_status'
		$val = $CurrentForm->hasValue("ref_status") ? $CurrentForm->getValue("ref_status") : $CurrentForm->getValue("x_ref_status");
		if (!$this->ref_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ref_status->Visible = FALSE; // Disable update for API request
			else
				$this->ref_status->setFormValue($val);
		}
		$this->ref_status->setOldValue($CurrentForm->getValue("o_ref_status"));

		// Check field name 'product_code' first before field var 'x_product_code'
		$val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
		if (!$this->product_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_code->Visible = FALSE; // Disable update for API request
			else
				$this->product_code->setFormValue($val);
		}
		$this->product_code->setOldValue($CurrentForm->getValue("o_product_code"));

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}
		$this->company_id->setOldValue($CurrentForm->getValue("o_company_id"));

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}
		$this->product_type->setOldValue($CurrentForm->getValue("o_product_type"));
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		if (!$this->isGridAdd() && !$this->isAdd())
			$this->id->CurrentValue = $this->id->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->product_n->CurrentValue = $this->product_n->FormValue;
		$this->ref_status->CurrentValue = $this->ref_status->FormValue;
		$this->product_code->CurrentValue = $this->product_code->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->product->setDbValue($row['product']);
		if (array_key_exists('EV__product', $rs->fields)) {
			$this->product->VirtualValue = $rs->fields('EV__product'); // Set up virtual field value
		} else {
			$this->product->VirtualValue = ""; // Clear value
		}
		$this->product_n->setDbValue($row['product_n']);
		$this->ref_status->setDbValue($row['ref_status']);
		$this->product_code->setDbValue($row['product_code']);
		$this->url->setDbValue($row['url']);
		$this->oid->setDbValue($row['oid']);
		$this->company_id->setDbValue($row['company_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product_type->setDbValue($row['product_type']);
		$this->gcode->setDbValue($row['gcode']);
		$this->code->setDbValue($row['code']);
		$this->product_id->setDbValue($row['product_id']);
		$this->print_name->setDbValue($row['print_name']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_10->setDbValue($row['v_10']);
		$this->b_01->setDbValue($row['b_01']);
		$this->b_02->setDbValue($row['b_02']);
		$this->b_03->setDbValue($row['b_03']);
		$this->b_04->setDbValue($row['b_04']);
		$this->b_05->setDbValue($row['b_05']);
		$this->b_06->setDbValue($row['b_06']);
		$this->b_07->setDbValue($row['b_07']);
		$this->b_08->setDbValue($row['b_08']);
		$this->b_09->setDbValue($row['b_09']);
		$this->b_10->setDbValue($row['b_10']);
		$this->b_11->setDbValue($row['b_11']);
		$this->b_12->setDbValue($row['b_12']);
		$this->b_13->setDbValue($row['b_13']);
		$this->b_14->setDbValue($row['b_14']);
		$this->b_15->setDbValue($row['b_15']);
		$this->t_01->setDbValue($row['t_01']);
		$this->t_02->setDbValue($row['t_02']);
		$this->t_03->setDbValue($row['t_03']);
		$this->t_04->setDbValue($row['t_04']);
		$this->t_05->setDbValue($row['t_05']);
		$this->t_06->setDbValue($row['t_06']);
		$this->t_07->setDbValue($row['t_07']);
		$this->t_08->setDbValue($row['t_08']);
		$this->t_09->setDbValue($row['t_09']);
		$this->t_10->setDbValue($row['t_10']);
		$this->t_11->setDbValue($row['t_11']);
		$this->t_12->setDbValue($row['t_12']);
		$this->t_13->setDbValue($row['t_13']);
		$this->t_14->setDbValue($row['t_14']);
		$this->t_15->setDbValue($row['t_15']);
		$this->d_head_01->setDbValue($row['d_head_01']);
		$this->d_description_01->setDbValue($row['d_description_01']);
		$this->d_head_02->setDbValue($row['d_head_02']);
		$this->d_description_02->setDbValue($row['d_description_02']);
		$this->image->setDbValue($row['image']);
		$this->main_image->setDbValue($row['main_image']);
		$this->top_view->setDbValue($row['top_view']);
		$this->front_view->setDbValue($row['front_view']);
		$this->corner_view->setDbValue($row['corner_view']);
		$this->back_view->setDbValue($row['back_view']);
		$this->color_options->setDbValue($row['color_options']);
		$this->other_options->setDbValue($row['other_options']);
		$this->last_price->setDbValue($row['last_price']);
		$this->hsn->setDbValue($row['hsn']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->currency->setDbValue($row['currency']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['product_n'] = $this->product_n->CurrentValue;
		$row['ref_status'] = $this->ref_status->CurrentValue;
		$row['product_code'] = $this->product_code->CurrentValue;
		$row['url'] = $this->url->CurrentValue;
		$row['oid'] = $this->oid->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product_type'] = $this->product_type->CurrentValue;
		$row['gcode'] = $this->gcode->CurrentValue;
		$row['code'] = $this->code->CurrentValue;
		$row['product_id'] = $this->product_id->CurrentValue;
		$row['print_name'] = $this->print_name->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['v_01'] = $this->v_01->CurrentValue;
		$row['v_02'] = $this->v_02->CurrentValue;
		$row['v_03'] = $this->v_03->CurrentValue;
		$row['v_04'] = $this->v_04->CurrentValue;
		$row['v_05'] = $this->v_05->CurrentValue;
		$row['v_06'] = $this->v_06->CurrentValue;
		$row['v_07'] = $this->v_07->CurrentValue;
		$row['v_08'] = $this->v_08->CurrentValue;
		$row['v_09'] = $this->v_09->CurrentValue;
		$row['v_10'] = $this->v_10->CurrentValue;
		$row['b_01'] = $this->b_01->CurrentValue;
		$row['b_02'] = $this->b_02->CurrentValue;
		$row['b_03'] = $this->b_03->CurrentValue;
		$row['b_04'] = $this->b_04->CurrentValue;
		$row['b_05'] = $this->b_05->CurrentValue;
		$row['b_06'] = $this->b_06->CurrentValue;
		$row['b_07'] = $this->b_07->CurrentValue;
		$row['b_08'] = $this->b_08->CurrentValue;
		$row['b_09'] = $this->b_09->CurrentValue;
		$row['b_10'] = $this->b_10->CurrentValue;
		$row['b_11'] = $this->b_11->CurrentValue;
		$row['b_12'] = $this->b_12->CurrentValue;
		$row['b_13'] = $this->b_13->CurrentValue;
		$row['b_14'] = $this->b_14->CurrentValue;
		$row['b_15'] = $this->b_15->CurrentValue;
		$row['t_01'] = $this->t_01->CurrentValue;
		$row['t_02'] = $this->t_02->CurrentValue;
		$row['t_03'] = $this->t_03->CurrentValue;
		$row['t_04'] = $this->t_04->CurrentValue;
		$row['t_05'] = $this->t_05->CurrentValue;
		$row['t_06'] = $this->t_06->CurrentValue;
		$row['t_07'] = $this->t_07->CurrentValue;
		$row['t_08'] = $this->t_08->CurrentValue;
		$row['t_09'] = $this->t_09->CurrentValue;
		$row['t_10'] = $this->t_10->CurrentValue;
		$row['t_11'] = $this->t_11->CurrentValue;
		$row['t_12'] = $this->t_12->CurrentValue;
		$row['t_13'] = $this->t_13->CurrentValue;
		$row['t_14'] = $this->t_14->CurrentValue;
		$row['t_15'] = $this->t_15->CurrentValue;
		$row['d_head_01'] = $this->d_head_01->CurrentValue;
		$row['d_description_01'] = $this->d_description_01->CurrentValue;
		$row['d_head_02'] = $this->d_head_02->CurrentValue;
		$row['d_description_02'] = $this->d_description_02->CurrentValue;
		$row['image'] = $this->image->CurrentValue;
		$row['main_image'] = $this->main_image->CurrentValue;
		$row['top_view'] = $this->top_view->CurrentValue;
		$row['front_view'] = $this->front_view->CurrentValue;
		$row['corner_view'] = $this->corner_view->CurrentValue;
		$row['back_view'] = $this->back_view->CurrentValue;
		$row['color_options'] = $this->color_options->CurrentValue;
		$row['other_options'] = $this->other_options->CurrentValue;
		$row['last_price'] = $this->last_price->CurrentValue;
		$row['hsn'] = $this->hsn->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['currency'] = $this->currency->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		$arKeys[] = $this->RowOldKey;
		$cnt = count($arKeys);
		if ($cnt >= 1) {
			if (strval($arKeys[0]) <> "")
				$this->id->CurrentValue = strval($arKeys[0]); // id
			else
				$validKey = FALSE;
		} else {
			$validKey = FALSE;
		}

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// product
		// product_n
		// ref_status
		// product_code
		// url

		$this->url->CellCssStyle = "white-space: nowrap;";

		// oid
		$this->oid->CellCssStyle = "white-space: nowrap;";

		// company_id
		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// product_type
		$this->product_type->CellCssStyle = "white-space: nowrap;";

		// gcode
		$this->gcode->CellCssStyle = "white-space: nowrap;";

		// code
		$this->code->CellCssStyle = "white-space: nowrap;";

		// product_id
		$this->product_id->CellCssStyle = "white-space: nowrap;";

		// print_name
		$this->print_name->CellCssStyle = "white-space: nowrap;";

		// batch_no
		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// v_01
		$this->v_01->CellCssStyle = "white-space: nowrap;";

		// v_02
		$this->v_02->CellCssStyle = "white-space: nowrap;";

		// v_03
		$this->v_03->CellCssStyle = "white-space: nowrap;";

		// v_04
		$this->v_04->CellCssStyle = "white-space: nowrap;";

		// v_05
		$this->v_05->CellCssStyle = "white-space: nowrap;";

		// v_06
		$this->v_06->CellCssStyle = "white-space: nowrap;";

		// v_07
		$this->v_07->CellCssStyle = "white-space: nowrap;";

		// v_08
		$this->v_08->CellCssStyle = "white-space: nowrap;";

		// v_09
		$this->v_09->CellCssStyle = "white-space: nowrap;";

		// v_10
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// image
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// last_price
		// hsn
		// status
		// operator
		// datetime
		// currency

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// product
			if ($this->product->VirtualValue <> "") {
				$this->product->ViewValue = $this->product->VirtualValue;
			} else {
				$this->product->ViewValue = $this->product->CurrentValue;
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// product_n
			$this->product_n->ViewValue = $this->product_n->CurrentValue;
			$this->product_n->ViewCustomAttributes = "";

			// ref_status
			$this->ref_status->ViewValue = $this->ref_status->CurrentValue;
			$this->ref_status->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// product_type
			$this->product_type->ViewValue = $this->product_type->CurrentValue;
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// v_10
			$this->v_10->ViewValue = $this->v_10->CurrentValue;
			$this->v_10->ViewCustomAttributes = "";

			// b_01
			$this->b_01->ViewValue = $this->b_01->CurrentValue;
			$this->b_01->ViewCustomAttributes = "";

			// b_02
			$this->b_02->ViewValue = $this->b_02->CurrentValue;
			$this->b_02->ViewCustomAttributes = "";

			// b_03
			$this->b_03->ViewValue = $this->b_03->CurrentValue;
			$this->b_03->ViewCustomAttributes = "";

			// b_04
			$this->b_04->ViewValue = $this->b_04->CurrentValue;
			$this->b_04->ViewCustomAttributes = "";

			// b_05
			$this->b_05->ViewValue = $this->b_05->CurrentValue;
			$this->b_05->ViewCustomAttributes = "";

			// b_06
			$this->b_06->ViewValue = $this->b_06->CurrentValue;
			$this->b_06->ViewCustomAttributes = "";

			// b_07
			$this->b_07->ViewValue = $this->b_07->CurrentValue;
			$this->b_07->ViewCustomAttributes = "";

			// b_08
			$this->b_08->ViewValue = $this->b_08->CurrentValue;
			$this->b_08->ViewCustomAttributes = "";

			// b_09
			$this->b_09->ViewValue = $this->b_09->CurrentValue;
			$this->b_09->ViewCustomAttributes = "";

			// b_10
			$this->b_10->ViewValue = $this->b_10->CurrentValue;
			$this->b_10->ViewCustomAttributes = "";

			// b_11
			$this->b_11->ViewValue = $this->b_11->CurrentValue;
			$this->b_11->ViewCustomAttributes = "";

			// b_12
			$this->b_12->ViewValue = $this->b_12->CurrentValue;
			$this->b_12->ViewCustomAttributes = "";

			// b_13
			$this->b_13->ViewValue = $this->b_13->CurrentValue;
			$this->b_13->ViewCustomAttributes = "";

			// b_14
			$this->b_14->ViewValue = $this->b_14->CurrentValue;
			$this->b_14->ViewCustomAttributes = "";

			// b_15
			$this->b_15->ViewValue = $this->b_15->CurrentValue;
			$this->b_15->ViewCustomAttributes = "";

			// t_01
			$this->t_01->ViewValue = $this->t_01->CurrentValue;
			$this->t_01->ViewCustomAttributes = "";

			// t_02
			$this->t_02->ViewValue = $this->t_02->CurrentValue;
			$this->t_02->ViewCustomAttributes = "";

			// t_03
			$this->t_03->ViewValue = $this->t_03->CurrentValue;
			$this->t_03->ViewCustomAttributes = "";

			// t_04
			$this->t_04->ViewValue = $this->t_04->CurrentValue;
			$this->t_04->ViewCustomAttributes = "";

			// t_05
			$this->t_05->ViewValue = $this->t_05->CurrentValue;
			$this->t_05->ViewCustomAttributes = "";

			// t_06
			$this->t_06->ViewValue = $this->t_06->CurrentValue;
			$this->t_06->ViewCustomAttributes = "";

			// t_07
			$this->t_07->ViewValue = $this->t_07->CurrentValue;
			$this->t_07->ViewCustomAttributes = "";

			// t_08
			$this->t_08->ViewValue = $this->t_08->CurrentValue;
			$this->t_08->ViewCustomAttributes = "";

			// t_09
			$this->t_09->ViewValue = $this->t_09->CurrentValue;
			$this->t_09->ViewCustomAttributes = "";

			// t_10
			$this->t_10->ViewValue = $this->t_10->CurrentValue;
			$this->t_10->ViewCustomAttributes = "";

			// t_11
			$this->t_11->ViewValue = $this->t_11->CurrentValue;
			$this->t_11->ViewCustomAttributes = "";

			// t_12
			$this->t_12->ViewValue = $this->t_12->CurrentValue;
			$this->t_12->ViewCustomAttributes = "";

			// t_13
			$this->t_13->ViewValue = $this->t_13->CurrentValue;
			$this->t_13->ViewCustomAttributes = "";

			// t_14
			$this->t_14->ViewValue = $this->t_14->CurrentValue;
			$this->t_14->ViewCustomAttributes = "";

			// t_15
			$this->t_15->ViewValue = $this->t_15->CurrentValue;
			$this->t_15->ViewCustomAttributes = "";

			// d_head_01
			$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
			$this->d_head_01->ViewCustomAttributes = "";

			// d_head_02
			$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
			$this->d_head_02->ViewCustomAttributes = "";

			// image
			$this->image->ViewValue = $this->image->CurrentValue;
			$this->image->ViewCustomAttributes = "";

			// main_image
			$this->main_image->ViewValue = $this->main_image->CurrentValue;
			$this->main_image->ViewCustomAttributes = "";

			// top_view
			$this->top_view->ViewValue = $this->top_view->CurrentValue;
			$this->top_view->ViewCustomAttributes = "";

			// front_view
			$this->front_view->ViewValue = $this->front_view->CurrentValue;
			$this->front_view->ViewCustomAttributes = "";

			// corner_view
			$this->corner_view->ViewValue = $this->corner_view->CurrentValue;
			$this->corner_view->ViewCustomAttributes = "";

			// back_view
			$this->back_view->ViewValue = $this->back_view->CurrentValue;
			$this->back_view->ViewCustomAttributes = "";

			// color_options
			$this->color_options->ViewValue = $this->color_options->CurrentValue;
			$this->color_options->ViewCustomAttributes = "";

			// other_options
			$this->other_options->ViewValue = $this->other_options->CurrentValue;
			$this->other_options->ViewCustomAttributes = "";

			// last_price
			$this->last_price->ViewValue = $this->last_price->CurrentValue;
			$this->last_price->ViewCustomAttributes = "";

			// hsn
			$this->hsn->ViewValue = $this->hsn->CurrentValue;
			$this->hsn->ViewValue = FormatNumber($this->hsn->ViewValue, 0, -2, -2, -2);
			$this->hsn->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// currency
			$this->currency->ViewValue = $this->currency->CurrentValue;
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_viewlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_n
			$this->product_n->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_n->CurrentValue)) {
				$this->product_n->HrefValue = "ref_viewlist.php?x_product_n=" . $this->product_n->CurrentValue; // Add prefix/suffix
				$this->product_n->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_n->HrefValue = FullUrl($this->product_n->HrefValue, "href");
			} else {
				$this->product_n->HrefValue = "";
			}
			$this->product_n->TooltipValue = "";

			// ref_status
			$this->ref_status->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->ref_status->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->ref_status->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->ref_status->HrefValue = FullUrl($this->ref_status->HrefValue, "href");
			} else {
				$this->ref_status->HrefValue = "";
			}
			$this->ref_status->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "ref_viewlist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}
			$this->product_code->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			// product

			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// product_n
			$this->product_n->EditAttrs["class"] = "form-control";
			$this->product_n->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
			$this->product_n->EditValue = HtmlEncode($this->product_n->CurrentValue);
			$this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

			// ref_status
			$this->ref_status->EditAttrs["class"] = "form-control";
			$this->ref_status->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref_status->CurrentValue = HtmlDecode($this->ref_status->CurrentValue);
			$this->ref_status->EditValue = HtmlEncode($this->ref_status->CurrentValue);
			$this->ref_status->PlaceHolder = RemoveHtml($this->ref_status->caption());

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
			$this->product_code->EditValue = HtmlEncode($this->product_code->CurrentValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->CurrentValue));
			if ($curVal <> "")
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_type->CurrentValue = HtmlDecode($this->product_type->CurrentValue);
			$this->product_type->EditValue = HtmlEncode($this->product_type->CurrentValue);
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->EditValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product_type->EditValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->EditValue = HtmlEncode($this->product_type->CurrentValue);
					}
				}
			} else {
				$this->product_type->EditValue = NULL;
			}
			$this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_viewlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// product_n
			$this->product_n->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_n->CurrentValue)) {
				$this->product_n->HrefValue = "ref_viewlist.php?x_product_n=" . $this->product_n->CurrentValue; // Add prefix/suffix
				$this->product_n->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_n->HrefValue = FullUrl($this->product_n->HrefValue, "href");
			} else {
				$this->product_n->HrefValue = "";
			}

			// ref_status
			$this->ref_status->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->ref_status->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->ref_status->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->ref_status->HrefValue = FullUrl($this->ref_status->HrefValue, "href");
			} else {
				$this->ref_status->HrefValue = "";
			}

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "ref_viewlist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// product_n
			$this->product_n->EditAttrs["class"] = "form-control";
			$this->product_n->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
			$this->product_n->EditValue = HtmlEncode($this->product_n->CurrentValue);
			$this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

			// ref_status
			$this->ref_status->EditAttrs["class"] = "form-control";
			$this->ref_status->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref_status->CurrentValue = HtmlDecode($this->ref_status->CurrentValue);
			$this->ref_status->EditValue = HtmlEncode($this->ref_status->CurrentValue);
			$this->ref_status->PlaceHolder = RemoveHtml($this->ref_status->caption());

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
			$this->product_code->EditValue = HtmlEncode($this->product_code->CurrentValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->CurrentValue));
			if ($curVal <> "")
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_type->CurrentValue = HtmlDecode($this->product_type->CurrentValue);
			$this->product_type->EditValue = HtmlEncode($this->product_type->CurrentValue);
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->EditValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product_type->EditValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->EditValue = HtmlEncode($this->product_type->CurrentValue);
					}
				}
			} else {
				$this->product_type->EditValue = NULL;
			}
			$this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_viewlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// product_n
			$this->product_n->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_n->CurrentValue)) {
				$this->product_n->HrefValue = "ref_viewlist.php?x_product_n=" . $this->product_n->CurrentValue; // Add prefix/suffix
				$this->product_n->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_n->HrefValue = FullUrl($this->product_n->HrefValue, "href");
			} else {
				$this->product_n->HrefValue = "";
			}

			// ref_status
			$this->ref_status->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->ref_status->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->ref_status->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->ref_status->HrefValue = FullUrl($this->ref_status->HrefValue, "href");
			} else {
				$this->ref_status->HrefValue = "";
			}

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "ref_viewlist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->product_n->Required) {
			if (!$this->product_n->IsDetailKey && $this->product_n->FormValue != NULL && $this->product_n->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_n->caption(), $this->product_n->RequiredErrorMessage));
			}
		}
		if ($this->ref_status->Required) {
			if (!$this->ref_status->IsDetailKey && $this->ref_status->FormValue != NULL && $this->ref_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ref_status->caption(), $this->ref_status->RequiredErrorMessage));
			}
		}
		if ($this->product_code->Required) {
			if (!$this->product_code->IsDetailKey && $this->product_code->FormValue != NULL && $this->product_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}
		if ($this->oid->Required) {
			if (!$this->oid->IsDetailKey && $this->oid->FormValue != NULL && $this->oid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->oid->caption(), $this->oid->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->gcode->Required) {
			if (!$this->gcode->IsDetailKey && $this->gcode->FormValue != NULL && $this->gcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gcode->caption(), $this->gcode->RequiredErrorMessage));
			}
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->product_id->Required) {
			if (!$this->product_id->IsDetailKey && $this->product_id->FormValue != NULL && $this->product_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
			}
		}
		if ($this->print_name->Required) {
			if (!$this->print_name->IsDetailKey && $this->print_name->FormValue != NULL && $this->print_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->print_name->caption(), $this->print_name->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->v_01->Required) {
			if (!$this->v_01->IsDetailKey && $this->v_01->FormValue != NULL && $this->v_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_01->caption(), $this->v_01->RequiredErrorMessage));
			}
		}
		if ($this->v_02->Required) {
			if (!$this->v_02->IsDetailKey && $this->v_02->FormValue != NULL && $this->v_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_02->caption(), $this->v_02->RequiredErrorMessage));
			}
		}
		if ($this->v_03->Required) {
			if (!$this->v_03->IsDetailKey && $this->v_03->FormValue != NULL && $this->v_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_03->caption(), $this->v_03->RequiredErrorMessage));
			}
		}
		if ($this->v_04->Required) {
			if (!$this->v_04->IsDetailKey && $this->v_04->FormValue != NULL && $this->v_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_04->caption(), $this->v_04->RequiredErrorMessage));
			}
		}
		if ($this->v_05->Required) {
			if (!$this->v_05->IsDetailKey && $this->v_05->FormValue != NULL && $this->v_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_05->caption(), $this->v_05->RequiredErrorMessage));
			}
		}
		if ($this->v_06->Required) {
			if (!$this->v_06->IsDetailKey && $this->v_06->FormValue != NULL && $this->v_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_06->caption(), $this->v_06->RequiredErrorMessage));
			}
		}
		if ($this->v_07->Required) {
			if (!$this->v_07->IsDetailKey && $this->v_07->FormValue != NULL && $this->v_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_07->caption(), $this->v_07->RequiredErrorMessage));
			}
		}
		if ($this->v_08->Required) {
			if (!$this->v_08->IsDetailKey && $this->v_08->FormValue != NULL && $this->v_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_08->caption(), $this->v_08->RequiredErrorMessage));
			}
		}
		if ($this->v_09->Required) {
			if (!$this->v_09->IsDetailKey && $this->v_09->FormValue != NULL && $this->v_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_09->caption(), $this->v_09->RequiredErrorMessage));
			}
		}
		if ($this->v_10->Required) {
			if (!$this->v_10->IsDetailKey && $this->v_10->FormValue != NULL && $this->v_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_10->caption(), $this->v_10->RequiredErrorMessage));
			}
		}
		if ($this->b_01->Required) {
			if (!$this->b_01->IsDetailKey && $this->b_01->FormValue != NULL && $this->b_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_01->caption(), $this->b_01->RequiredErrorMessage));
			}
		}
		if ($this->b_02->Required) {
			if (!$this->b_02->IsDetailKey && $this->b_02->FormValue != NULL && $this->b_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_02->caption(), $this->b_02->RequiredErrorMessage));
			}
		}
		if ($this->b_03->Required) {
			if (!$this->b_03->IsDetailKey && $this->b_03->FormValue != NULL && $this->b_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_03->caption(), $this->b_03->RequiredErrorMessage));
			}
		}
		if ($this->b_04->Required) {
			if (!$this->b_04->IsDetailKey && $this->b_04->FormValue != NULL && $this->b_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_04->caption(), $this->b_04->RequiredErrorMessage));
			}
		}
		if ($this->b_05->Required) {
			if (!$this->b_05->IsDetailKey && $this->b_05->FormValue != NULL && $this->b_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_05->caption(), $this->b_05->RequiredErrorMessage));
			}
		}
		if ($this->b_06->Required) {
			if (!$this->b_06->IsDetailKey && $this->b_06->FormValue != NULL && $this->b_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_06->caption(), $this->b_06->RequiredErrorMessage));
			}
		}
		if ($this->b_07->Required) {
			if (!$this->b_07->IsDetailKey && $this->b_07->FormValue != NULL && $this->b_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_07->caption(), $this->b_07->RequiredErrorMessage));
			}
		}
		if ($this->b_08->Required) {
			if (!$this->b_08->IsDetailKey && $this->b_08->FormValue != NULL && $this->b_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_08->caption(), $this->b_08->RequiredErrorMessage));
			}
		}
		if ($this->b_09->Required) {
			if (!$this->b_09->IsDetailKey && $this->b_09->FormValue != NULL && $this->b_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_09->caption(), $this->b_09->RequiredErrorMessage));
			}
		}
		if ($this->b_10->Required) {
			if (!$this->b_10->IsDetailKey && $this->b_10->FormValue != NULL && $this->b_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_10->caption(), $this->b_10->RequiredErrorMessage));
			}
		}
		if ($this->b_11->Required) {
			if (!$this->b_11->IsDetailKey && $this->b_11->FormValue != NULL && $this->b_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_11->caption(), $this->b_11->RequiredErrorMessage));
			}
		}
		if ($this->b_12->Required) {
			if (!$this->b_12->IsDetailKey && $this->b_12->FormValue != NULL && $this->b_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_12->caption(), $this->b_12->RequiredErrorMessage));
			}
		}
		if ($this->b_13->Required) {
			if (!$this->b_13->IsDetailKey && $this->b_13->FormValue != NULL && $this->b_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_13->caption(), $this->b_13->RequiredErrorMessage));
			}
		}
		if ($this->b_14->Required) {
			if (!$this->b_14->IsDetailKey && $this->b_14->FormValue != NULL && $this->b_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_14->caption(), $this->b_14->RequiredErrorMessage));
			}
		}
		if ($this->b_15->Required) {
			if (!$this->b_15->IsDetailKey && $this->b_15->FormValue != NULL && $this->b_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_15->caption(), $this->b_15->RequiredErrorMessage));
			}
		}
		if ($this->t_01->Required) {
			if (!$this->t_01->IsDetailKey && $this->t_01->FormValue != NULL && $this->t_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_01->caption(), $this->t_01->RequiredErrorMessage));
			}
		}
		if ($this->t_02->Required) {
			if (!$this->t_02->IsDetailKey && $this->t_02->FormValue != NULL && $this->t_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_02->caption(), $this->t_02->RequiredErrorMessage));
			}
		}
		if ($this->t_03->Required) {
			if (!$this->t_03->IsDetailKey && $this->t_03->FormValue != NULL && $this->t_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_03->caption(), $this->t_03->RequiredErrorMessage));
			}
		}
		if ($this->t_04->Required) {
			if (!$this->t_04->IsDetailKey && $this->t_04->FormValue != NULL && $this->t_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_04->caption(), $this->t_04->RequiredErrorMessage));
			}
		}
		if ($this->t_05->Required) {
			if (!$this->t_05->IsDetailKey && $this->t_05->FormValue != NULL && $this->t_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_05->caption(), $this->t_05->RequiredErrorMessage));
			}
		}
		if ($this->t_06->Required) {
			if (!$this->t_06->IsDetailKey && $this->t_06->FormValue != NULL && $this->t_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_06->caption(), $this->t_06->RequiredErrorMessage));
			}
		}
		if ($this->t_07->Required) {
			if (!$this->t_07->IsDetailKey && $this->t_07->FormValue != NULL && $this->t_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_07->caption(), $this->t_07->RequiredErrorMessage));
			}
		}
		if ($this->t_08->Required) {
			if (!$this->t_08->IsDetailKey && $this->t_08->FormValue != NULL && $this->t_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_08->caption(), $this->t_08->RequiredErrorMessage));
			}
		}
		if ($this->t_09->Required) {
			if (!$this->t_09->IsDetailKey && $this->t_09->FormValue != NULL && $this->t_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_09->caption(), $this->t_09->RequiredErrorMessage));
			}
		}
		if ($this->t_10->Required) {
			if (!$this->t_10->IsDetailKey && $this->t_10->FormValue != NULL && $this->t_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_10->caption(), $this->t_10->RequiredErrorMessage));
			}
		}
		if ($this->t_11->Required) {
			if (!$this->t_11->IsDetailKey && $this->t_11->FormValue != NULL && $this->t_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_11->caption(), $this->t_11->RequiredErrorMessage));
			}
		}
		if ($this->t_12->Required) {
			if (!$this->t_12->IsDetailKey && $this->t_12->FormValue != NULL && $this->t_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_12->caption(), $this->t_12->RequiredErrorMessage));
			}
		}
		if ($this->t_13->Required) {
			if (!$this->t_13->IsDetailKey && $this->t_13->FormValue != NULL && $this->t_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_13->caption(), $this->t_13->RequiredErrorMessage));
			}
		}
		if ($this->t_14->Required) {
			if (!$this->t_14->IsDetailKey && $this->t_14->FormValue != NULL && $this->t_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_14->caption(), $this->t_14->RequiredErrorMessage));
			}
		}
		if ($this->t_15->Required) {
			if (!$this->t_15->IsDetailKey && $this->t_15->FormValue != NULL && $this->t_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_15->caption(), $this->t_15->RequiredErrorMessage));
			}
		}
		if ($this->d_head_01->Required) {
			if (!$this->d_head_01->IsDetailKey && $this->d_head_01->FormValue != NULL && $this->d_head_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_head_01->caption(), $this->d_head_01->RequiredErrorMessage));
			}
		}
		if ($this->d_description_01->Required) {
			if (!$this->d_description_01->IsDetailKey && $this->d_description_01->FormValue != NULL && $this->d_description_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_description_01->caption(), $this->d_description_01->RequiredErrorMessage));
			}
		}
		if ($this->d_head_02->Required) {
			if (!$this->d_head_02->IsDetailKey && $this->d_head_02->FormValue != NULL && $this->d_head_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_head_02->caption(), $this->d_head_02->RequiredErrorMessage));
			}
		}
		if ($this->d_description_02->Required) {
			if (!$this->d_description_02->IsDetailKey && $this->d_description_02->FormValue != NULL && $this->d_description_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_description_02->caption(), $this->d_description_02->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if (!$this->image->IsDetailKey && $this->image->FormValue != NULL && $this->image->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->main_image->Required) {
			if (!$this->main_image->IsDetailKey && $this->main_image->FormValue != NULL && $this->main_image->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->main_image->caption(), $this->main_image->RequiredErrorMessage));
			}
		}
		if ($this->top_view->Required) {
			if (!$this->top_view->IsDetailKey && $this->top_view->FormValue != NULL && $this->top_view->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->top_view->caption(), $this->top_view->RequiredErrorMessage));
			}
		}
		if ($this->front_view->Required) {
			if (!$this->front_view->IsDetailKey && $this->front_view->FormValue != NULL && $this->front_view->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->front_view->caption(), $this->front_view->RequiredErrorMessage));
			}
		}
		if ($this->corner_view->Required) {
			if (!$this->corner_view->IsDetailKey && $this->corner_view->FormValue != NULL && $this->corner_view->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->corner_view->caption(), $this->corner_view->RequiredErrorMessage));
			}
		}
		if ($this->back_view->Required) {
			if (!$this->back_view->IsDetailKey && $this->back_view->FormValue != NULL && $this->back_view->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->back_view->caption(), $this->back_view->RequiredErrorMessage));
			}
		}
		if ($this->color_options->Required) {
			if (!$this->color_options->IsDetailKey && $this->color_options->FormValue != NULL && $this->color_options->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->color_options->caption(), $this->color_options->RequiredErrorMessage));
			}
		}
		if ($this->other_options->Required) {
			if (!$this->other_options->IsDetailKey && $this->other_options->FormValue != NULL && $this->other_options->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_options->caption(), $this->other_options->RequiredErrorMessage));
			}
		}
		if ($this->last_price->Required) {
			if (!$this->last_price->IsDetailKey && $this->last_price->FormValue != NULL && $this->last_price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_price->caption(), $this->last_price->RequiredErrorMessage));
			}
		}
		if ($this->hsn->Required) {
			if (!$this->hsn->IsDetailKey && $this->hsn->FormValue != NULL && $this->hsn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, $this->product->ReadOnly);

			// product_n
			$this->product_n->setDbValueDef($rsnew, $this->product_n->CurrentValue, NULL, $this->product_n->ReadOnly);

			// ref_status
			$this->ref_status->setDbValueDef($rsnew, $this->ref_status->CurrentValue, "", $this->ref_status->ReadOnly);

			// product_code
			$this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, NULL, $this->product_code->ReadOnly);

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// product_type
			$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, NULL, $this->product_type->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Set up foreign key field value from Session
			if ($this->getCurrentMasterTable() == "ref_multi") {
				$this->id->CurrentValue = $this->id->getSessionValue();
			}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// product_n
		$this->product_n->setDbValueDef($rsnew, $this->product_n->CurrentValue, NULL, FALSE);

		// ref_status
		$this->ref_status->setDbValueDef($rsnew, $this->ref_status->CurrentValue, "", FALSE);

		// product_code
		$this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, NULL, FALSE);

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, FALSE);

		// product_type
		$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, NULL, strval($this->product_type->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{

		// Hide foreign keys
		$masterTblVar = $this->getCurrentMasterTable();
		if ($masterTblVar == "ref_multi") {
			$this->id->Visible = FALSE;
			if ($GLOBALS["ref_multi"]->EventCancelled)
				$this->EventCancelled = TRUE;
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_product":
							break;
						case "x_company_id":
							break;
						case "x_product_type":
							break;
						case "x_currency":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}
}
?>