<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class admin_office_add extends admin_office
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'admin_office';

	// Page object name
	public $PageObjName = "admin_office_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (admin_office)
		if (!isset($GLOBALS["admin_office"]) || get_class($GLOBALS["admin_office"]) == PROJECT_NAMESPACE . "admin_office") {
			$GLOBALS["admin_office"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["admin_office"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'admin_office');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $admin_office;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($admin_office);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "admin_officeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("admin_officelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->user_name->setVisibility();
		$this->password->setVisibility();
		$this->address->setVisibility();
		$this->mobile->setVisibility();
		$this->category->Visible = FALSE;
		$this->userlevel->setVisibility();
		$this->_email->setVisibility();
		$this->activated->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->reports_to->setVisibility();
		$this->profile->Visible = FALSE;
		$this->mobile_id->setVisibility();
		$this->mobile_token_id->setVisibility();
		$this->site->setVisibility();
		$this->formal_name->setVisibility();
		$this->company_id->setVisibility();
		$this->reg_ip->setVisibility();
		$this->pp_id->setVisibility();
		$this->profile_old->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->userlevel);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->reports_to);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("admin_officelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "admin_officelist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "admin_officeview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->user_name->CurrentValue = NULL;
		$this->user_name->OldValue = $this->user_name->CurrentValue;
		$this->password->CurrentValue = NULL;
		$this->password->OldValue = $this->password->CurrentValue;
		$this->address->CurrentValue = NULL;
		$this->address->OldValue = $this->address->CurrentValue;
		$this->mobile->CurrentValue = NULL;
		$this->mobile->OldValue = $this->mobile->CurrentValue;
		$this->category->CurrentValue = NULL;
		$this->category->OldValue = $this->category->CurrentValue;
		$this->userlevel->CurrentValue = 0;
		$this->_email->CurrentValue = NULL;
		$this->_email->OldValue = $this->_email->CurrentValue;
		$this->activated->CurrentValue = 1;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->reports_to->CurrentValue = 0;
		$this->profile->CurrentValue = NULL;
		$this->profile->OldValue = $this->profile->CurrentValue;
		$this->mobile_id->CurrentValue = NULL;
		$this->mobile_id->OldValue = $this->mobile_id->CurrentValue;
		$this->mobile_token_id->CurrentValue = NULL;
		$this->mobile_token_id->OldValue = $this->mobile_token_id->CurrentValue;
		$this->site->CurrentValue = NULL;
		$this->site->OldValue = $this->site->CurrentValue;
		$this->formal_name->CurrentValue = NULL;
		$this->formal_name->OldValue = $this->formal_name->CurrentValue;
		$this->company_id->CurrentValue = 1001;
		$this->reg_ip->CurrentValue = NULL;
		$this->reg_ip->OldValue = $this->reg_ip->CurrentValue;
		$this->pp_id->CurrentValue = NULL;
		$this->pp_id->OldValue = $this->pp_id->CurrentValue;
		$this->profile_old->CurrentValue = NULL;
		$this->profile_old->OldValue = $this->profile_old->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'user_name' first before field var 'x_user_name'
		$val = $CurrentForm->hasValue("user_name") ? $CurrentForm->getValue("user_name") : $CurrentForm->getValue("x_user_name");
		if (!$this->user_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->user_name->Visible = FALSE; // Disable update for API request
			else
				$this->user_name->setFormValue($val);
		}

		// Check field name 'password' first before field var 'x_password'
		$val = $CurrentForm->hasValue("password") ? $CurrentForm->getValue("password") : $CurrentForm->getValue("x_password");
		if (!$this->password->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->password->Visible = FALSE; // Disable update for API request
			else
				$this->password->setFormValue($val);
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address->Visible = FALSE; // Disable update for API request
			else
				$this->address->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'userlevel' first before field var 'x_userlevel'
		$val = $CurrentForm->hasValue("userlevel") ? $CurrentForm->getValue("userlevel") : $CurrentForm->getValue("x_userlevel");
		if (!$this->userlevel->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->userlevel->Visible = FALSE; // Disable update for API request
			else
				$this->userlevel->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'activated' first before field var 'x_activated'
		$val = $CurrentForm->hasValue("activated") ? $CurrentForm->getValue("activated") : $CurrentForm->getValue("x_activated");
		if (!$this->activated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->activated->Visible = FALSE; // Disable update for API request
			else
				$this->activated->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'reports_to' first before field var 'x_reports_to'
		$val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
		if (!$this->reports_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reports_to->Visible = FALSE; // Disable update for API request
			else
				$this->reports_to->setFormValue($val);
		}

		// Check field name 'mobile_id' first before field var 'x_mobile_id'
		$val = $CurrentForm->hasValue("mobile_id") ? $CurrentForm->getValue("mobile_id") : $CurrentForm->getValue("x_mobile_id");
		if (!$this->mobile_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile_id->Visible = FALSE; // Disable update for API request
			else
				$this->mobile_id->setFormValue($val);
		}

		// Check field name 'mobile_token_id' first before field var 'x_mobile_token_id'
		$val = $CurrentForm->hasValue("mobile_token_id") ? $CurrentForm->getValue("mobile_token_id") : $CurrentForm->getValue("x_mobile_token_id");
		if (!$this->mobile_token_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile_token_id->Visible = FALSE; // Disable update for API request
			else
				$this->mobile_token_id->setFormValue($val);
		}

		// Check field name 'site' first before field var 'x_site'
		$val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
		if (!$this->site->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->site->Visible = FALSE; // Disable update for API request
			else
				$this->site->setFormValue($val);
		}

		// Check field name 'formal_name' first before field var 'x_formal_name'
		$val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
		if (!$this->formal_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->formal_name->Visible = FALSE; // Disable update for API request
			else
				$this->formal_name->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'reg_ip' first before field var 'x_reg_ip'
		$val = $CurrentForm->hasValue("reg_ip") ? $CurrentForm->getValue("reg_ip") : $CurrentForm->getValue("x_reg_ip");
		if (!$this->reg_ip->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reg_ip->Visible = FALSE; // Disable update for API request
			else
				$this->reg_ip->setFormValue($val);
		}

		// Check field name 'pp_id' first before field var 'x_pp_id'
		$val = $CurrentForm->hasValue("pp_id") ? $CurrentForm->getValue("pp_id") : $CurrentForm->getValue("x_pp_id");
		if (!$this->pp_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_id->Visible = FALSE; // Disable update for API request
			else
				$this->pp_id->setFormValue($val);
		}

		// Check field name 'profile_old' first before field var 'x_profile_old'
		$val = $CurrentForm->hasValue("profile_old") ? $CurrentForm->getValue("profile_old") : $CurrentForm->getValue("x_profile_old");
		if (!$this->profile_old->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->profile_old->Visible = FALSE; // Disable update for API request
			else
				$this->profile_old->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->user_name->CurrentValue = $this->user_name->FormValue;
		$this->password->CurrentValue = $this->password->FormValue;
		$this->address->CurrentValue = $this->address->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->userlevel->CurrentValue = $this->userlevel->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->activated->CurrentValue = $this->activated->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->reports_to->CurrentValue = $this->reports_to->FormValue;
		$this->mobile_id->CurrentValue = $this->mobile_id->FormValue;
		$this->mobile_token_id->CurrentValue = $this->mobile_token_id->FormValue;
		$this->site->CurrentValue = $this->site->FormValue;
		$this->formal_name->CurrentValue = $this->formal_name->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->reg_ip->CurrentValue = $this->reg_ip->FormValue;
		$this->pp_id->CurrentValue = $this->pp_id->FormValue;
		$this->profile_old->CurrentValue = $this->profile_old->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->user_name->setDbValue($row['user_name']);
		$this->password->setDbValue($row['password']);
		$this->address->setDbValue($row['address']);
		$this->mobile->setDbValue($row['mobile']);
		$this->category->setDbValue($row['category']);
		$this->userlevel->setDbValue($row['userlevel']);
		$this->_email->setDbValue($row['email']);
		$this->activated->setDbValue($row['activated']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->profile->setDbValue($row['profile']);
		$this->mobile_id->setDbValue($row['mobile_id']);
		$this->mobile_token_id->setDbValue($row['mobile_token_id']);
		$this->site->setDbValue($row['site']);
		$this->formal_name->setDbValue($row['formal_name']);
		$this->company_id->setDbValue($row['company_id']);
		$this->reg_ip->setDbValue($row['reg_ip']);
		$this->pp_id->setDbValue($row['pp_id']);
		$this->profile_old->setDbValue($row['profile_old']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['user_name'] = $this->user_name->CurrentValue;
		$row['password'] = $this->password->CurrentValue;
		$row['address'] = $this->address->CurrentValue;
		$row['mobile'] = $this->mobile->CurrentValue;
		$row['category'] = $this->category->CurrentValue;
		$row['userlevel'] = $this->userlevel->CurrentValue;
		$row['email'] = $this->_email->CurrentValue;
		$row['activated'] = $this->activated->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['reports_to'] = $this->reports_to->CurrentValue;
		$row['profile'] = $this->profile->CurrentValue;
		$row['mobile_id'] = $this->mobile_id->CurrentValue;
		$row['mobile_token_id'] = $this->mobile_token_id->CurrentValue;
		$row['site'] = $this->site->CurrentValue;
		$row['formal_name'] = $this->formal_name->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['reg_ip'] = $this->reg_ip->CurrentValue;
		$row['pp_id'] = $this->pp_id->CurrentValue;
		$row['profile_old'] = $this->profile_old->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// user_name
		// password
		// address
		// mobile
		// category
		// userlevel
		// email
		// activated
		// operator
		// datetime
		// reports_to
		// profile
		// mobile_id
		// mobile_token_id
		// site
		// formal_name
		// company_id
		// reg_ip
		// pp_id
		// profile_old

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// user_name
			$this->user_name->ViewValue = $this->user_name->CurrentValue;
			$this->user_name->ViewCustomAttributes = "";

			// password
			$this->password->ViewValue = $Language->phrase("PasswordMask");
			$this->password->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// userlevel
			$curVal = strval($this->userlevel->CurrentValue);
			if ($curVal <> "") {
				$this->userlevel->ViewValue = $this->userlevel->lookupCacheOption($curVal);
				if ($this->userlevel->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`userlevelid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevelid` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->userlevel->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->userlevel->ViewValue = $this->userlevel->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->userlevel->ViewValue = $this->userlevel->CurrentValue;
					}
				}
			} else {
				$this->userlevel->ViewValue = NULL;
			}
			$this->userlevel->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// activated
			if (strval($this->activated->CurrentValue) <> "") {
				$this->activated->ViewValue = $this->activated->optionCaption($this->activated->CurrentValue);
			} else {
				$this->activated->ViewValue = NULL;
			}
			$this->activated->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// mobile_id
			$this->mobile_id->ViewValue = $this->mobile_id->CurrentValue;
			$this->mobile_id->ViewCustomAttributes = "";

			// mobile_token_id
			$this->mobile_token_id->ViewValue = $this->mobile_token_id->CurrentValue;
			$this->mobile_token_id->ViewCustomAttributes = "";

			// site
			$this->site->ViewValue = $this->site->CurrentValue;
			$this->site->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
			$this->formal_name->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// reg_ip
			$this->reg_ip->ViewValue = $this->reg_ip->CurrentValue;
			$this->reg_ip->ViewCustomAttributes = "";

			// pp_id
			$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
			$this->pp_id->ViewCustomAttributes = "";

			// profile_old
			$this->profile_old->ViewValue = $this->profile_old->CurrentValue;
			$this->profile_old->ViewCustomAttributes = "";

			// user_name
			$this->user_name->LinkCustomAttributes = "";
			$this->user_name->HrefValue = "";
			$this->user_name->TooltipValue = "";

			// password
			$this->password->LinkCustomAttributes = "";
			$this->password->HrefValue = "";
			$this->password->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// userlevel
			$this->userlevel->LinkCustomAttributes = "";
			$this->userlevel->HrefValue = "";
			$this->userlevel->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// activated
			$this->activated->LinkCustomAttributes = "";
			$this->activated->HrefValue = "";
			$this->activated->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// mobile_id
			$this->mobile_id->LinkCustomAttributes = "";
			$this->mobile_id->HrefValue = "";
			$this->mobile_id->TooltipValue = "";

			// mobile_token_id
			$this->mobile_token_id->LinkCustomAttributes = "";
			$this->mobile_token_id->HrefValue = "";
			$this->mobile_token_id->TooltipValue = "";

			// site
			$this->site->LinkCustomAttributes = "";
			$this->site->HrefValue = "";
			$this->site->TooltipValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";
			$this->formal_name->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// reg_ip
			$this->reg_ip->LinkCustomAttributes = "";
			$this->reg_ip->HrefValue = "";
			$this->reg_ip->TooltipValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";
			$this->pp_id->TooltipValue = "";

			// profile_old
			$this->profile_old->LinkCustomAttributes = "";
			$this->profile_old->HrefValue = "";
			$this->profile_old->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// user_name
			$this->user_name->EditAttrs["class"] = "form-control";
			$this->user_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
			$this->user_name->EditValue = HtmlEncode($this->user_name->CurrentValue);
			$this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

			// password
			$this->password->EditAttrs["class"] = "form-control ew-password-strength";
			$this->password->EditCustomAttributes = "";
			$this->password->EditValue = HtmlEncode($this->password->CurrentValue);
			$this->password->PlaceHolder = RemoveHtml($this->password->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// userlevel
			$this->userlevel->EditAttrs["class"] = "form-control";
			$this->userlevel->EditCustomAttributes = "";
			$curVal = trim(strval($this->userlevel->CurrentValue));
			if ($curVal <> "")
				$this->userlevel->ViewValue = $this->userlevel->lookupCacheOption($curVal);
			else
				$this->userlevel->ViewValue = $this->userlevel->Lookup !== NULL && is_array($this->userlevel->Lookup->Options) ? $curVal : NULL;
			if ($this->userlevel->ViewValue !== NULL) { // Load from cache
				$this->userlevel->EditValue = array_values($this->userlevel->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`userlevelid`" . SearchString("=", $this->userlevel->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`userlevelid` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->userlevel->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->userlevel->EditValue = $arwrk;
			}

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// activated
			$this->activated->EditAttrs["class"] = "form-control";
			$this->activated->EditCustomAttributes = "";
			$this->activated->EditValue = $this->activated->options(TRUE);

			// operator
			// datetime
			// reports_to

			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->CurrentValue));
			if ($curVal <> "")
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// mobile_id
			$this->mobile_id->EditAttrs["class"] = "form-control";
			$this->mobile_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_id->CurrentValue = HtmlDecode($this->mobile_id->CurrentValue);
			$this->mobile_id->EditValue = HtmlEncode($this->mobile_id->CurrentValue);
			$this->mobile_id->PlaceHolder = RemoveHtml($this->mobile_id->caption());

			// mobile_token_id
			$this->mobile_token_id->EditAttrs["class"] = "form-control";
			$this->mobile_token_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_token_id->CurrentValue = HtmlDecode($this->mobile_token_id->CurrentValue);
			$this->mobile_token_id->EditValue = HtmlEncode($this->mobile_token_id->CurrentValue);
			$this->mobile_token_id->PlaceHolder = RemoveHtml($this->mobile_token_id->caption());

			// site
			$this->site->EditAttrs["class"] = "form-control";
			$this->site->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->site->CurrentValue = HtmlDecode($this->site->CurrentValue);
			$this->site->EditValue = HtmlEncode($this->site->CurrentValue);
			$this->site->PlaceHolder = RemoveHtml($this->site->caption());

			// formal_name
			$this->formal_name->EditAttrs["class"] = "form-control";
			$this->formal_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
			$this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
			$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// reg_ip
			$this->reg_ip->EditAttrs["class"] = "form-control";
			$this->reg_ip->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->reg_ip->CurrentValue = HtmlDecode($this->reg_ip->CurrentValue);
			$this->reg_ip->EditValue = HtmlEncode($this->reg_ip->CurrentValue);
			$this->reg_ip->PlaceHolder = RemoveHtml($this->reg_ip->caption());

			// pp_id
			$this->pp_id->EditAttrs["class"] = "form-control";
			$this->pp_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pp_id->CurrentValue = HtmlDecode($this->pp_id->CurrentValue);
			$this->pp_id->EditValue = HtmlEncode($this->pp_id->CurrentValue);
			$this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

			// profile_old
			$this->profile_old->EditAttrs["class"] = "form-control";
			$this->profile_old->EditCustomAttributes = "";
			$this->profile_old->EditValue = HtmlEncode($this->profile_old->CurrentValue);
			$this->profile_old->PlaceHolder = RemoveHtml($this->profile_old->caption());

			// Add refer script
			// user_name

			$this->user_name->LinkCustomAttributes = "";
			$this->user_name->HrefValue = "";

			// password
			$this->password->LinkCustomAttributes = "";
			$this->password->HrefValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// userlevel
			$this->userlevel->LinkCustomAttributes = "";
			$this->userlevel->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// activated
			$this->activated->LinkCustomAttributes = "";
			$this->activated->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";

			// mobile_id
			$this->mobile_id->LinkCustomAttributes = "";
			$this->mobile_id->HrefValue = "";

			// mobile_token_id
			$this->mobile_token_id->LinkCustomAttributes = "";
			$this->mobile_token_id->HrefValue = "";

			// site
			$this->site->LinkCustomAttributes = "";
			$this->site->HrefValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// reg_ip
			$this->reg_ip->LinkCustomAttributes = "";
			$this->reg_ip->HrefValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";

			// profile_old
			$this->profile_old->LinkCustomAttributes = "";
			$this->profile_old->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->user_name->Required) {
			if (!$this->user_name->IsDetailKey && $this->user_name->FormValue != NULL && $this->user_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->user_name->caption(), $this->user_name->RequiredErrorMessage));
			}
		}
		if ($this->password->Required) {
			if (!$this->password->IsDetailKey && $this->password->FormValue != NULL && $this->password->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->password->caption(), $this->password->RequiredErrorMessage));
			}
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mobile->FormValue)) {
			AddMessage($FormError, $this->mobile->errorMessage());
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->userlevel->Required) {
			if (!$this->userlevel->IsDetailKey && $this->userlevel->FormValue != NULL && $this->userlevel->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->userlevel->caption(), $this->userlevel->RequiredErrorMessage));
			}
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if ($this->activated->Required) {
			if (!$this->activated->IsDetailKey && $this->activated->FormValue != NULL && $this->activated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->activated->caption(), $this->activated->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->profile->Required) {
			if (!$this->profile->IsDetailKey && $this->profile->FormValue != NULL && $this->profile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->profile->caption(), $this->profile->RequiredErrorMessage));
			}
		}
		if ($this->mobile_id->Required) {
			if (!$this->mobile_id->IsDetailKey && $this->mobile_id->FormValue != NULL && $this->mobile_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile_id->caption(), $this->mobile_id->RequiredErrorMessage));
			}
		}
		if ($this->mobile_token_id->Required) {
			if (!$this->mobile_token_id->IsDetailKey && $this->mobile_token_id->FormValue != NULL && $this->mobile_token_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile_token_id->caption(), $this->mobile_token_id->RequiredErrorMessage));
			}
		}
		if ($this->site->Required) {
			if (!$this->site->IsDetailKey && $this->site->FormValue != NULL && $this->site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->site->FormValue)) {
			AddMessage($FormError, $this->site->errorMessage());
		}
		if ($this->formal_name->Required) {
			if (!$this->formal_name->IsDetailKey && $this->formal_name->FormValue != NULL && $this->formal_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->reg_ip->Required) {
			if (!$this->reg_ip->IsDetailKey && $this->reg_ip->FormValue != NULL && $this->reg_ip->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reg_ip->caption(), $this->reg_ip->RequiredErrorMessage));
			}
		}
		if ($this->pp_id->Required) {
			if (!$this->pp_id->IsDetailKey && $this->pp_id->FormValue != NULL && $this->pp_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_id->caption(), $this->pp_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->pp_id->FormValue)) {
			AddMessage($FormError, $this->pp_id->errorMessage());
		}
		if ($this->profile_old->Required) {
			if (!$this->profile_old->IsDetailKey && $this->profile_old->FormValue != NULL && $this->profile_old->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->profile_old->caption(), $this->profile_old->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->user_name->CurrentValue <> "") { // Check field with unique index
			$filter = "(user_name = '" . AdjustSql($this->user_name->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->user_name->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->user_name->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// user_name
		$this->user_name->setDbValueDef($rsnew, $this->user_name->CurrentValue, NULL, FALSE);

		// password
		$this->password->setDbValueDef($rsnew, $this->password->CurrentValue, NULL, FALSE);

		// address
		$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, NULL, FALSE);

		// mobile
		$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, FALSE);

		// userlevel
		$this->userlevel->setDbValueDef($rsnew, $this->userlevel->CurrentValue, NULL, strval($this->userlevel->CurrentValue) == "");

		// email
		$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, FALSE);

		// activated
		$this->activated->setDbValueDef($rsnew, $this->activated->CurrentValue, NULL, strval($this->activated->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// reports_to
		$this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, NULL, strval($this->reports_to->CurrentValue) == "");

		// mobile_id
		$this->mobile_id->setDbValueDef($rsnew, $this->mobile_id->CurrentValue, "", FALSE);

		// mobile_token_id
		$this->mobile_token_id->setDbValueDef($rsnew, $this->mobile_token_id->CurrentValue, "", FALSE);

		// site
		$this->site->setDbValueDef($rsnew, $this->site->CurrentValue, "", strval($this->site->CurrentValue) == "");

		// formal_name
		$this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, "", FALSE);

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, 0, FALSE);

		// reg_ip
		$this->reg_ip->setDbValueDef($rsnew, $this->reg_ip->CurrentValue, NULL, FALSE);

		// pp_id
		$this->pp_id->setDbValueDef($rsnew, $this->pp_id->CurrentValue, NULL, strval($this->pp_id->CurrentValue) == "");

		// profile_old
		$this->profile_old->setDbValueDef($rsnew, $this->profile_old->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("admin_officelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_userlevel":
					$lookupFilter = function() {
						return "`userlevelid` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_userlevel":
							break;
						case "x_operator":
							break;
						case "x_reports_to":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>